+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "LogsParser"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## LogsParser interface

<b>Signature</b>

```typescript
export interface LogsParser 
```
<b>Import</b>

```typescript
import { LogsParser } from '@grafana/data';
```
<b>Properties</b>

|  Property | Type | Description |
|  --- | --- | --- |
|  [buildMatcher](#buildmatcher-property) | <code>(label: string) =&gt; RegExp</code> | Value-agnostic matcher for a field label. Used to filter rows, and first capture group contains the value. |
|  [getFields](#getfields-property) | <code>(line: string) =&gt; string[]</code> | Returns all parsable substrings from a line, used for highlighting |
|  [getLabelFromField](#getlabelfromfield-property) | <code>(field: string) =&gt; string</code> | Gets the label name from a parsable substring of a line |
|  [getValueFromField](#getvaluefromfield-property) | <code>(field: string) =&gt; string</code> | Gets the label value from a parsable substring of a line |
|  [test](#test-property) | <code>(line: string) =&gt; any</code> | Function to verify if this is a valid parser for the given line. The parser accepts the line unless it returns undefined. |

### buildMatcher property

Value-agnostic matcher for a field label. Used to filter rows, and first capture group contains the value.

<b>Signature</b>

```typescript
buildMatcher: (label: string) => RegExp;
```

### getFields property

Returns all parsable substrings from a line, used for highlighting

<b>Signature</b>

```typescript
getFields: (line: string) => string[];
```

### getLabelFromField property

Gets the label name from a parsable substring of a line

<b>Signature</b>

```typescript
getLabelFromField: (field: string) => string;
```

### getValueFromField property

Gets the label value from a parsable substring of a line

<b>Signature</b>

```typescript
getValueFromField: (field: string) => string;
```

### test property

Function to verify if this is a valid parser for the given line. The parser accepts the line unless it returns undefined.

<b>Signature</b>

```typescript
test: (line: string) => any;
```
