// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	otlpmetrics "go.opentelemetry.io/collector/internal/data/protogen/metrics/v1"
)

// ResourceMetricsSlice logically represents a slice of ResourceMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetricsSlice struct {
	// orig points to the slice otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.ResourceMetrics
}

func newResourceMetricsSlice(orig *[]*otlpmetrics.ResourceMetrics) ResourceMetricsSlice {
	return ResourceMetricsSlice{orig}
}

// NewResourceMetricsSlice creates a ResourceMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewResourceMetricsSlice() ResourceMetricsSlice {
	orig := []*otlpmetrics.ResourceMetrics(nil)
	return ResourceMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewResourceMetricsSlice()".
func (es ResourceMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es ResourceMetricsSlice) At(ix int) ResourceMetrics {
	return newResourceMetrics((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ResourceMetricsSlice) MoveAndAppendTo(dest ResourceMetricsSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es ResourceMetricsSlice) CopyTo(dest ResourceMetricsSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newResourceMetrics((*es.orig)[i]).CopyTo(newResourceMetrics((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ResourceMetrics, srcLen)
	wrappers := make([]*otlpmetrics.ResourceMetrics, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newResourceMetrics((*es.orig)[i]).CopyTo(newResourceMetrics(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new ResourceMetricsSlice can be initialized:
// es := NewResourceMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es ResourceMetricsSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.ResourceMetrics, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.ResourceMetrics, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the ResourceMetricsSlice by one and set the
// given ResourceMetrics at that new position.  The original ResourceMetrics
// could still be referenced so do not reuse it after passing it to this
// method.
func (es ResourceMetricsSlice) Append(e ResourceMetrics) {
	*es.orig = append(*es.orig, e.orig)
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetrics struct {
	orig *otlpmetrics.ResourceMetrics
}

func newResourceMetrics(orig *otlpmetrics.ResourceMetrics) ResourceMetrics {
	return ResourceMetrics{orig: orig}
}

// NewResourceMetrics creates a new empty ResourceMetrics.
//
// This must be used only in testing code since no "Set" method available.
func NewResourceMetrics() ResourceMetrics {
	return newResourceMetrics(&otlpmetrics.ResourceMetrics{})
}

// Resource returns the resource associated with this ResourceMetrics.
func (ms ResourceMetrics) Resource() Resource {
	return newResource(&(*ms.orig).Resource)
}

// InstrumentationLibraryMetrics returns the InstrumentationLibraryMetrics associated with this ResourceMetrics.
func (ms ResourceMetrics) InstrumentationLibraryMetrics() InstrumentationLibraryMetricsSlice {
	return newInstrumentationLibraryMetricsSlice(&(*ms.orig).InstrumentationLibraryMetrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ResourceMetrics) CopyTo(dest ResourceMetrics) {
	ms.Resource().CopyTo(dest.Resource())
	ms.InstrumentationLibraryMetrics().CopyTo(dest.InstrumentationLibraryMetrics())
}

// InstrumentationLibraryMetricsSlice logically represents a slice of InstrumentationLibraryMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetricsSlice struct {
	// orig points to the slice otlpmetrics.InstrumentationLibraryMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetricsSlice(orig *[]*otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetricsSlice {
	return InstrumentationLibraryMetricsSlice{orig}
}

// NewInstrumentationLibraryMetricsSlice creates a InstrumentationLibraryMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	orig := []*otlpmetrics.InstrumentationLibraryMetrics(nil)
	return InstrumentationLibraryMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewInstrumentationLibraryMetricsSlice()".
func (es InstrumentationLibraryMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es InstrumentationLibraryMetricsSlice) At(ix int) InstrumentationLibraryMetrics {
	return newInstrumentationLibraryMetrics((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es InstrumentationLibraryMetricsSlice) MoveAndAppendTo(dest InstrumentationLibraryMetricsSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es InstrumentationLibraryMetricsSlice) CopyTo(dest InstrumentationLibraryMetricsSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newInstrumentationLibraryMetrics((*es.orig)[i]).CopyTo(newInstrumentationLibraryMetrics((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.InstrumentationLibraryMetrics, srcLen)
	wrappers := make([]*otlpmetrics.InstrumentationLibraryMetrics, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newInstrumentationLibraryMetrics((*es.orig)[i]).CopyTo(newInstrumentationLibraryMetrics(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new InstrumentationLibraryMetricsSlice can be initialized:
// es := NewInstrumentationLibraryMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es InstrumentationLibraryMetricsSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.InstrumentationLibraryMetrics, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.InstrumentationLibraryMetrics, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the InstrumentationLibraryMetricsSlice by one and set the
// given InstrumentationLibraryMetrics at that new position.  The original InstrumentationLibraryMetrics
// could still be referenced so do not reuse it after passing it to this
// method.
func (es InstrumentationLibraryMetricsSlice) Append(e InstrumentationLibraryMetrics) {
	*es.orig = append(*es.orig, e.orig)
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetrics struct {
	orig *otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetrics(orig *otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetrics {
	return InstrumentationLibraryMetrics{orig: orig}
}

// NewInstrumentationLibraryMetrics creates a new empty InstrumentationLibraryMetrics.
//
// This must be used only in testing code since no "Set" method available.
func NewInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	return newInstrumentationLibraryMetrics(&otlpmetrics.InstrumentationLibraryMetrics{})
}

// InstrumentationLibrary returns the instrumentationlibrary associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) InstrumentationLibrary() InstrumentationLibrary {
	return newInstrumentationLibrary(&(*ms.orig).InstrumentationLibrary)
}

// Metrics returns the Metrics associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) Metrics() MetricSlice {
	return newMetricSlice(&(*ms.orig).Metrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms InstrumentationLibraryMetrics) CopyTo(dest InstrumentationLibraryMetrics) {
	ms.InstrumentationLibrary().CopyTo(dest.InstrumentationLibrary())
	ms.Metrics().CopyTo(dest.Metrics())
}

// MetricSlice logically represents a slice of Metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricSlice struct {
	// orig points to the slice otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.Metric
}

func newMetricSlice(orig *[]*otlpmetrics.Metric) MetricSlice {
	return MetricSlice{orig}
}

// NewMetricSlice creates a MetricSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewMetricSlice() MetricSlice {
	orig := []*otlpmetrics.Metric(nil)
	return MetricSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewMetricSlice()".
func (es MetricSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es MetricSlice) At(ix int) Metric {
	return newMetric((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es MetricSlice) MoveAndAppendTo(dest MetricSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es MetricSlice) CopyTo(dest MetricSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newMetric((*es.orig)[i]).CopyTo(newMetric((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.Metric, srcLen)
	wrappers := make([]*otlpmetrics.Metric, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newMetric((*es.orig)[i]).CopyTo(newMetric(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new MetricSlice can be initialized:
// es := NewMetricSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es MetricSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.Metric, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.Metric, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the MetricSlice by one and set the
// given Metric at that new position.  The original Metric
// could still be referenced so do not reuse it after passing it to this
// method.
func (es MetricSlice) Append(e Metric) {
	*es.orig = append(*es.orig, e.orig)
}

// Metric represents one metric as a collection of datapoints.
// See Metric definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/metrics/v1/metrics.proto
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetric function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metric struct {
	orig *otlpmetrics.Metric
}

func newMetric(orig *otlpmetrics.Metric) Metric {
	return Metric{orig: orig}
}

// NewMetric creates a new empty Metric.
//
// This must be used only in testing code since no "Set" method available.
func NewMetric() Metric {
	return newMetric(&otlpmetrics.Metric{})
}

// Name returns the name associated with this Metric.
func (ms Metric) Name() string {
	return (*ms.orig).Name
}

// SetName replaces the name associated with this Metric.
func (ms Metric) SetName(v string) {
	(*ms.orig).Name = v
}

// Description returns the description associated with this Metric.
func (ms Metric) Description() string {
	return (*ms.orig).Description
}

// SetDescription replaces the description associated with this Metric.
func (ms Metric) SetDescription(v string) {
	(*ms.orig).Description = v
}

// Unit returns the unit associated with this Metric.
func (ms Metric) Unit() string {
	return (*ms.orig).Unit
}

// SetUnit replaces the unit associated with this Metric.
func (ms Metric) SetUnit(v string) {
	(*ms.orig).Unit = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Metric) CopyTo(dest Metric) {
	dest.SetName(ms.Name())
	dest.SetDescription(ms.Description())
	dest.SetUnit(ms.Unit())
	copyData(ms.orig, dest.orig)
}

// IntGauge represents the type of a int scalar metric that always exports the "current value" for every data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntGauge function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntGauge struct {
	orig *otlpmetrics.IntGauge
}

func newIntGauge(orig *otlpmetrics.IntGauge) IntGauge {
	return IntGauge{orig: orig}
}

// NewIntGauge creates a new empty IntGauge.
//
// This must be used only in testing code since no "Set" method available.
func NewIntGauge() IntGauge {
	return newIntGauge(&otlpmetrics.IntGauge{})
}

// DataPoints returns the DataPoints associated with this IntGauge.
func (ms IntGauge) DataPoints() IntDataPointSlice {
	return newIntDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntGauge) CopyTo(dest IntGauge) {
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleGauge represents the type of a double scalar metric that always exports the "current value" for every data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleGauge function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleGauge struct {
	orig *otlpmetrics.DoubleGauge
}

func newDoubleGauge(orig *otlpmetrics.DoubleGauge) DoubleGauge {
	return DoubleGauge{orig: orig}
}

// NewDoubleGauge creates a new empty DoubleGauge.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleGauge() DoubleGauge {
	return newDoubleGauge(&otlpmetrics.DoubleGauge{})
}

// DataPoints returns the DataPoints associated with this DoubleGauge.
func (ms DoubleGauge) DataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleGauge) CopyTo(dest DoubleGauge) {
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntSum represents the type of a numeric int scalar metric that is calculated as a sum of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntSum function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntSum struct {
	orig *otlpmetrics.IntSum
}

func newIntSum(orig *otlpmetrics.IntSum) IntSum {
	return IntSum{orig: orig}
}

// NewIntSum creates a new empty IntSum.
//
// This must be used only in testing code since no "Set" method available.
func NewIntSum() IntSum {
	return newIntSum(&otlpmetrics.IntSum{})
}

// AggregationTemporality returns the aggregationtemporality associated with this IntSum.
func (ms IntSum) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this IntSum.
func (ms IntSum) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// IsMonotonic returns the ismonotonic associated with this IntSum.
func (ms IntSum) IsMonotonic() bool {
	return (*ms.orig).IsMonotonic
}

// SetIsMonotonic replaces the ismonotonic associated with this IntSum.
func (ms IntSum) SetIsMonotonic(v bool) {
	(*ms.orig).IsMonotonic = v
}

// DataPoints returns the DataPoints associated with this IntSum.
func (ms IntSum) DataPoints() IntDataPointSlice {
	return newIntDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntSum) CopyTo(dest IntSum) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	dest.SetIsMonotonic(ms.IsMonotonic())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleSum represents the type of a numeric double scalar metric that is calculated as a sum of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleSum function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleSum struct {
	orig *otlpmetrics.DoubleSum
}

func newDoubleSum(orig *otlpmetrics.DoubleSum) DoubleSum {
	return DoubleSum{orig: orig}
}

// NewDoubleSum creates a new empty DoubleSum.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleSum() DoubleSum {
	return newDoubleSum(&otlpmetrics.DoubleSum{})
}

// AggregationTemporality returns the aggregationtemporality associated with this DoubleSum.
func (ms DoubleSum) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this DoubleSum.
func (ms DoubleSum) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// IsMonotonic returns the ismonotonic associated with this DoubleSum.
func (ms DoubleSum) IsMonotonic() bool {
	return (*ms.orig).IsMonotonic
}

// SetIsMonotonic replaces the ismonotonic associated with this DoubleSum.
func (ms DoubleSum) SetIsMonotonic(v bool) {
	(*ms.orig).IsMonotonic = v
}

// DataPoints returns the DataPoints associated with this DoubleSum.
func (ms DoubleSum) DataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleSum) CopyTo(dest DoubleSum) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	dest.SetIsMonotonic(ms.IsMonotonic())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntHistogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogram struct {
	orig *otlpmetrics.IntHistogram
}

func newIntHistogram(orig *otlpmetrics.IntHistogram) IntHistogram {
	return IntHistogram{orig: orig}
}

// NewIntHistogram creates a new empty IntHistogram.
//
// This must be used only in testing code since no "Set" method available.
func NewIntHistogram() IntHistogram {
	return newIntHistogram(&otlpmetrics.IntHistogram{})
}

// AggregationTemporality returns the aggregationtemporality associated with this IntHistogram.
func (ms IntHistogram) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this IntHistogram.
func (ms IntHistogram) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this IntHistogram.
func (ms IntHistogram) DataPoints() IntHistogramDataPointSlice {
	return newIntHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntHistogram) CopyTo(dest IntHistogram) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleHistogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogram struct {
	orig *otlpmetrics.DoubleHistogram
}

func newDoubleHistogram(orig *otlpmetrics.DoubleHistogram) DoubleHistogram {
	return DoubleHistogram{orig: orig}
}

// NewDoubleHistogram creates a new empty DoubleHistogram.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleHistogram() DoubleHistogram {
	return newDoubleHistogram(&otlpmetrics.DoubleHistogram{})
}

// AggregationTemporality returns the aggregationtemporality associated with this DoubleHistogram.
func (ms DoubleHistogram) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this DoubleHistogram.
func (ms DoubleHistogram) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this DoubleHistogram.
func (ms DoubleHistogram) DataPoints() DoubleHistogramDataPointSlice {
	return newDoubleHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleHistogram) CopyTo(dest DoubleHistogram) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleSummary represents the type of a metric that is calculated by aggregating as a Summary of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleSummary function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleSummary struct {
	orig *otlpmetrics.DoubleSummary
}

func newDoubleSummary(orig *otlpmetrics.DoubleSummary) DoubleSummary {
	return DoubleSummary{orig: orig}
}

// NewDoubleSummary creates a new empty DoubleSummary.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleSummary() DoubleSummary {
	return newDoubleSummary(&otlpmetrics.DoubleSummary{})
}

// DataPoints returns the DataPoints associated with this DoubleSummary.
func (ms DoubleSummary) DataPoints() DoubleSummaryDataPointSlice {
	return newDoubleSummaryDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleSummary) CopyTo(dest DoubleSummary) {
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntDataPointSlice logically represents a slice of IntDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntDataPointSlice struct {
	// orig points to the slice otlpmetrics.IntDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.IntDataPoint
}

func newIntDataPointSlice(orig *[]*otlpmetrics.IntDataPoint) IntDataPointSlice {
	return IntDataPointSlice{orig}
}

// NewIntDataPointSlice creates a IntDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntDataPointSlice() IntDataPointSlice {
	orig := []*otlpmetrics.IntDataPoint(nil)
	return IntDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntDataPointSlice()".
func (es IntDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntDataPointSlice) At(ix int) IntDataPoint {
	return newIntDataPoint((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntDataPointSlice) MoveAndAppendTo(dest IntDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntDataPointSlice) CopyTo(dest IntDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newIntDataPoint((*es.orig)[i]).CopyTo(newIntDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.IntDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.IntDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newIntDataPoint((*es.orig)[i]).CopyTo(newIntDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new IntDataPointSlice can be initialized:
// es := NewIntDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntDataPointSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.IntDataPoint, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.IntDataPoint, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the IntDataPointSlice by one and set the
// given IntDataPoint at that new position.  The original IntDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntDataPointSlice) Append(e IntDataPoint) {
	*es.orig = append(*es.orig, e.orig)
}

// IntDataPoint is a single data point in a timeseries that describes the time-varying values of a scalar int metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntDataPoint struct {
	orig *otlpmetrics.IntDataPoint
}

func newIntDataPoint(orig *otlpmetrics.IntDataPoint) IntDataPoint {
	return IntDataPoint{orig: orig}
}

// NewIntDataPoint creates a new empty IntDataPoint.
//
// This must be used only in testing code since no "Set" method available.
func NewIntDataPoint() IntDataPoint {
	return newIntDataPoint(&otlpmetrics.IntDataPoint{})
}

// LabelsMap returns the Labels associated with this IntDataPoint.
func (ms IntDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this IntDataPoint.
func (ms IntDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this IntDataPoint.
func (ms IntDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this IntDataPoint.
func (ms IntDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntDataPoint.
func (ms IntDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this IntDataPoint.
func (ms IntDataPoint) Value() int64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this IntDataPoint.
func (ms IntDataPoint) SetValue(v int64) {
	(*ms.orig).Value = v
}

// Exemplars returns the Exemplars associated with this IntDataPoint.
func (ms IntDataPoint) Exemplars() IntExemplarSlice {
	return newIntExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntDataPoint) CopyTo(dest IntDataPoint) {
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// DoubleDataPointSlice logically represents a slice of DoubleDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleDataPoint
}

func newDoubleDataPointSlice(orig *[]*otlpmetrics.DoubleDataPoint) DoubleDataPointSlice {
	return DoubleDataPointSlice{orig}
}

// NewDoubleDataPointSlice creates a DoubleDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleDataPointSlice() DoubleDataPointSlice {
	orig := []*otlpmetrics.DoubleDataPoint(nil)
	return DoubleDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleDataPointSlice()".
func (es DoubleDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleDataPointSlice) At(ix int) DoubleDataPoint {
	return newDoubleDataPoint((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleDataPointSlice) MoveAndAppendTo(dest DoubleDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleDataPointSlice) CopyTo(dest DoubleDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newDoubleDataPoint((*es.orig)[i]).CopyTo(newDoubleDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.DoubleDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleDataPoint((*es.orig)[i]).CopyTo(newDoubleDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new DoubleDataPointSlice can be initialized:
// es := NewDoubleDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleDataPointSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.DoubleDataPoint, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.DoubleDataPoint, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the DoubleDataPointSlice by one and set the
// given DoubleDataPoint at that new position.  The original DoubleDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleDataPointSlice) Append(e DoubleDataPoint) {
	*es.orig = append(*es.orig, e.orig)
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying value of a double metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPoint struct {
	orig *otlpmetrics.DoubleDataPoint
}

func newDoubleDataPoint(orig *otlpmetrics.DoubleDataPoint) DoubleDataPoint {
	return DoubleDataPoint{orig: orig}
}

// NewDoubleDataPoint creates a new empty DoubleDataPoint.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleDataPoint() DoubleDataPoint {
	return newDoubleDataPoint(&otlpmetrics.DoubleDataPoint{})
}

// LabelsMap returns the Labels associated with this DoubleDataPoint.
func (ms DoubleDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleDataPoint.
func (ms DoubleDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleDataPoint.
func (ms DoubleDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleDataPoint.
func (ms DoubleDataPoint) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetValue(v float64) {
	(*ms.orig).Value = v
}

// Exemplars returns the Exemplars associated with this DoubleDataPoint.
func (ms DoubleDataPoint) Exemplars() DoubleExemplarSlice {
	return newDoubleExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleDataPoint) CopyTo(dest DoubleDataPoint) {
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// IntHistogramDataPointSlice logically represents a slice of IntHistogramDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.IntHistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.IntHistogramDataPoint
}

func newIntHistogramDataPointSlice(orig *[]*otlpmetrics.IntHistogramDataPoint) IntHistogramDataPointSlice {
	return IntHistogramDataPointSlice{orig}
}

// NewIntHistogramDataPointSlice creates a IntHistogramDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntHistogramDataPointSlice() IntHistogramDataPointSlice {
	orig := []*otlpmetrics.IntHistogramDataPoint(nil)
	return IntHistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntHistogramDataPointSlice()".
func (es IntHistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntHistogramDataPointSlice) At(ix int) IntHistogramDataPoint {
	return newIntHistogramDataPoint((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntHistogramDataPointSlice) MoveAndAppendTo(dest IntHistogramDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntHistogramDataPointSlice) CopyTo(dest IntHistogramDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newIntHistogramDataPoint((*es.orig)[i]).CopyTo(newIntHistogramDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.IntHistogramDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.IntHistogramDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newIntHistogramDataPoint((*es.orig)[i]).CopyTo(newIntHistogramDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new IntHistogramDataPointSlice can be initialized:
// es := NewIntHistogramDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntHistogramDataPointSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.IntHistogramDataPoint, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.IntHistogramDataPoint, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the IntHistogramDataPointSlice by one and set the
// given IntHistogramDataPoint at that new position.  The original IntHistogramDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntHistogramDataPointSlice) Append(e IntHistogramDataPoint) {
	*es.orig = append(*es.orig, e.orig)
}

// IntHistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of int values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogramDataPoint struct {
	orig *otlpmetrics.IntHistogramDataPoint
}

func newIntHistogramDataPoint(orig *otlpmetrics.IntHistogramDataPoint) IntHistogramDataPoint {
	return IntHistogramDataPoint{orig: orig}
}

// NewIntHistogramDataPoint creates a new empty IntHistogramDataPoint.
//
// This must be used only in testing code since no "Set" method available.
func NewIntHistogramDataPoint() IntHistogramDataPoint {
	return newIntHistogramDataPoint(&otlpmetrics.IntHistogramDataPoint{})
}

// LabelsMap returns the Labels associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) Sum() int64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetSum(v int64) {
	(*ms.orig).Sum = v
}

// BucketCounts returns the bucketcounts associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) BucketCounts() []uint64 {
	return (*ms.orig).BucketCounts
}

// SetBucketCounts replaces the bucketcounts associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetBucketCounts(v []uint64) {
	(*ms.orig).BucketCounts = v
}

// ExplicitBounds returns the explicitbounds associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) ExplicitBounds() []float64 {
	return (*ms.orig).ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) SetExplicitBounds(v []float64) {
	(*ms.orig).ExplicitBounds = v
}

// Exemplars returns the Exemplars associated with this IntHistogramDataPoint.
func (ms IntHistogramDataPoint) Exemplars() IntExemplarSlice {
	return newIntExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntHistogramDataPoint) CopyTo(dest IntHistogramDataPoint) {
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	dest.SetBucketCounts(ms.BucketCounts())
	dest.SetExplicitBounds(ms.ExplicitBounds())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// DoubleHistogramDataPointSlice logically represents a slice of DoubleHistogramDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleHistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleHistogramDataPoint
}

func newDoubleHistogramDataPointSlice(orig *[]*otlpmetrics.DoubleHistogramDataPoint) DoubleHistogramDataPointSlice {
	return DoubleHistogramDataPointSlice{orig}
}

// NewDoubleHistogramDataPointSlice creates a DoubleHistogramDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleHistogramDataPointSlice() DoubleHistogramDataPointSlice {
	orig := []*otlpmetrics.DoubleHistogramDataPoint(nil)
	return DoubleHistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleHistogramDataPointSlice()".
func (es DoubleHistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleHistogramDataPointSlice) At(ix int) DoubleHistogramDataPoint {
	return newDoubleHistogramDataPoint((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleHistogramDataPointSlice) MoveAndAppendTo(dest DoubleHistogramDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleHistogramDataPointSlice) CopyTo(dest DoubleHistogramDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newDoubleHistogramDataPoint((*es.orig)[i]).CopyTo(newDoubleHistogramDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleHistogramDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.DoubleHistogramDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleHistogramDataPoint((*es.orig)[i]).CopyTo(newDoubleHistogramDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new DoubleHistogramDataPointSlice can be initialized:
// es := NewDoubleHistogramDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleHistogramDataPointSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.DoubleHistogramDataPoint, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.DoubleHistogramDataPoint, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the DoubleHistogramDataPointSlice by one and set the
// given DoubleHistogramDataPoint at that new position.  The original DoubleHistogramDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleHistogramDataPointSlice) Append(e DoubleHistogramDataPoint) {
	*es.orig = append(*es.orig, e.orig)
}

// DoubleHistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of double values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogramDataPoint struct {
	orig *otlpmetrics.DoubleHistogramDataPoint
}

func newDoubleHistogramDataPoint(orig *otlpmetrics.DoubleHistogramDataPoint) DoubleHistogramDataPoint {
	return DoubleHistogramDataPoint{orig: orig}
}

// NewDoubleHistogramDataPoint creates a new empty DoubleHistogramDataPoint.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleHistogramDataPoint() DoubleHistogramDataPoint {
	return newDoubleHistogramDataPoint(&otlpmetrics.DoubleHistogramDataPoint{})
}

// LabelsMap returns the Labels associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// BucketCounts returns the bucketcounts associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) BucketCounts() []uint64 {
	return (*ms.orig).BucketCounts
}

// SetBucketCounts replaces the bucketcounts associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetBucketCounts(v []uint64) {
	(*ms.orig).BucketCounts = v
}

// ExplicitBounds returns the explicitbounds associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) ExplicitBounds() []float64 {
	return (*ms.orig).ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) SetExplicitBounds(v []float64) {
	(*ms.orig).ExplicitBounds = v
}

// Exemplars returns the Exemplars associated with this DoubleHistogramDataPoint.
func (ms DoubleHistogramDataPoint) Exemplars() DoubleExemplarSlice {
	return newDoubleExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleHistogramDataPoint) CopyTo(dest DoubleHistogramDataPoint) {
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	dest.SetBucketCounts(ms.BucketCounts())
	dest.SetExplicitBounds(ms.ExplicitBounds())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// DoubleSummaryDataPointSlice logically represents a slice of DoubleSummaryDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleSummaryDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleSummaryDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleSummaryDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleSummaryDataPoint
}

func newDoubleSummaryDataPointSlice(orig *[]*otlpmetrics.DoubleSummaryDataPoint) DoubleSummaryDataPointSlice {
	return DoubleSummaryDataPointSlice{orig}
}

// NewDoubleSummaryDataPointSlice creates a DoubleSummaryDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleSummaryDataPointSlice() DoubleSummaryDataPointSlice {
	orig := []*otlpmetrics.DoubleSummaryDataPoint(nil)
	return DoubleSummaryDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleSummaryDataPointSlice()".
func (es DoubleSummaryDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleSummaryDataPointSlice) At(ix int) DoubleSummaryDataPoint {
	return newDoubleSummaryDataPoint((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleSummaryDataPointSlice) MoveAndAppendTo(dest DoubleSummaryDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleSummaryDataPointSlice) CopyTo(dest DoubleSummaryDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newDoubleSummaryDataPoint((*es.orig)[i]).CopyTo(newDoubleSummaryDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleSummaryDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.DoubleSummaryDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleSummaryDataPoint((*es.orig)[i]).CopyTo(newDoubleSummaryDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new DoubleSummaryDataPointSlice can be initialized:
// es := NewDoubleSummaryDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleSummaryDataPointSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.DoubleSummaryDataPoint, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.DoubleSummaryDataPoint, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the DoubleSummaryDataPointSlice by one and set the
// given DoubleSummaryDataPoint at that new position.  The original DoubleSummaryDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleSummaryDataPointSlice) Append(e DoubleSummaryDataPoint) {
	*es.orig = append(*es.orig, e.orig)
}

// DoubleSummaryDataPoint is a single data point in a timeseries that describes the time-varying values of a Summary of double values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleSummaryDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleSummaryDataPoint struct {
	orig *otlpmetrics.DoubleSummaryDataPoint
}

func newDoubleSummaryDataPoint(orig *otlpmetrics.DoubleSummaryDataPoint) DoubleSummaryDataPoint {
	return DoubleSummaryDataPoint{orig: orig}
}

// NewDoubleSummaryDataPoint creates a new empty DoubleSummaryDataPoint.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleSummaryDataPoint() DoubleSummaryDataPoint {
	return newDoubleSummaryDataPoint(&otlpmetrics.DoubleSummaryDataPoint{})
}

// LabelsMap returns the Labels associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// QuantileValues returns the QuantileValues associated with this DoubleSummaryDataPoint.
func (ms DoubleSummaryDataPoint) QuantileValues() ValueAtQuantileSlice {
	return newValueAtQuantileSlice(&(*ms.orig).QuantileValues)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleSummaryDataPoint) CopyTo(dest DoubleSummaryDataPoint) {
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	ms.QuantileValues().CopyTo(dest.QuantileValues())
}

// ValueAtQuantileSlice logically represents a slice of ValueAtQuantile.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewValueAtQuantileSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ValueAtQuantileSlice struct {
	// orig points to the slice otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile
}

func newValueAtQuantileSlice(orig *[]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile) ValueAtQuantileSlice {
	return ValueAtQuantileSlice{orig}
}

// NewValueAtQuantileSlice creates a ValueAtQuantileSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewValueAtQuantileSlice() ValueAtQuantileSlice {
	orig := []*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile(nil)
	return ValueAtQuantileSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewValueAtQuantileSlice()".
func (es ValueAtQuantileSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es ValueAtQuantileSlice) At(ix int) ValueAtQuantile {
	return newValueAtQuantile((*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ValueAtQuantileSlice) MoveAndAppendTo(dest ValueAtQuantileSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es ValueAtQuantileSlice) CopyTo(dest ValueAtQuantileSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newValueAtQuantile((*es.orig)[i]).CopyTo(newValueAtQuantile((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile, srcLen)
	wrappers := make([]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newValueAtQuantile((*es.orig)[i]).CopyTo(newValueAtQuantile(wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new ValueAtQuantileSlice can be initialized:
// es := NewValueAtQuantileSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es ValueAtQuantileSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	extraOrigs := make([]otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile, newLen-oldLen)
	for i := range extraOrigs {
		*es.orig = append(*es.orig, &extraOrigs[i])
	}
}

// Append will increase the length of the ValueAtQuantileSlice by one and set the
// given ValueAtQuantile at that new position.  The original ValueAtQuantile
// could still be referenced so do not reuse it after passing it to this
// method.
func (es ValueAtQuantileSlice) Append(e ValueAtQuantile) {
	*es.orig = append(*es.orig, e.orig)
}

// ValueAtQuantile is a quantile value within a Summary data point
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewValueAtQuantile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ValueAtQuantile struct {
	orig *otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile
}

func newValueAtQuantile(orig *otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile) ValueAtQuantile {
	return ValueAtQuantile{orig: orig}
}

// NewValueAtQuantile creates a new empty ValueAtQuantile.
//
// This must be used only in testing code since no "Set" method available.
func NewValueAtQuantile() ValueAtQuantile {
	return newValueAtQuantile(&otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile{})
}

// Quantile returns the quantile associated with this ValueAtQuantile.
func (ms ValueAtQuantile) Quantile() float64 {
	return (*ms.orig).Quantile
}

// SetQuantile replaces the quantile associated with this ValueAtQuantile.
func (ms ValueAtQuantile) SetQuantile(v float64) {
	(*ms.orig).Quantile = v
}

// Value returns the value associated with this ValueAtQuantile.
func (ms ValueAtQuantile) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this ValueAtQuantile.
func (ms ValueAtQuantile) SetValue(v float64) {
	(*ms.orig).Value = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ValueAtQuantile) CopyTo(dest ValueAtQuantile) {
	dest.SetQuantile(ms.Quantile())
	dest.SetValue(ms.Value())
}

// IntExemplarSlice logically represents a slice of IntExemplar.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntExemplarSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntExemplarSlice struct {
	// orig points to the slice otlpmetrics.IntExemplar field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]otlpmetrics.IntExemplar
}

func newIntExemplarSlice(orig *[]otlpmetrics.IntExemplar) IntExemplarSlice {
	return IntExemplarSlice{orig}
}

// NewIntExemplarSlice creates a IntExemplarSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntExemplarSlice() IntExemplarSlice {
	orig := []otlpmetrics.IntExemplar(nil)
	return IntExemplarSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntExemplarSlice()".
func (es IntExemplarSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntExemplarSlice) At(ix int) IntExemplar {
	return newIntExemplar(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntExemplarSlice) MoveAndAppendTo(dest IntExemplarSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntExemplarSlice) CopyTo(dest IntExemplarSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
	} else {
		(*dest.orig) = make([]otlpmetrics.IntExemplar, srcLen)
	}

	for i := range *es.orig {
		newIntExemplar(&(*es.orig)[i]).CopyTo(newIntExemplar(&(*dest.orig)[i]))
	}
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new IntExemplarSlice can be initialized:
// es := NewIntExemplarSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntExemplarSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]otlpmetrics.IntExemplar, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	empty := otlpmetrics.IntExemplar{}
	for i := oldLen; i < newLen; i++ {
		*es.orig = append(*es.orig, empty)
	}
}

// Append will increase the length of the IntExemplarSlice by one and set the
// given IntExemplar at that new position.  The original IntExemplar
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntExemplarSlice) Append(e IntExemplar) {
	*es.orig = append(*es.orig, *e.orig)
}

// IntExemplar is a sample input int measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntExemplar struct {
	orig *otlpmetrics.IntExemplar
}

func newIntExemplar(orig *otlpmetrics.IntExemplar) IntExemplar {
	return IntExemplar{orig: orig}
}

// NewIntExemplar creates a new empty IntExemplar.
//
// This must be used only in testing code since no "Set" method available.
func NewIntExemplar() IntExemplar {
	return newIntExemplar(&otlpmetrics.IntExemplar{})
}

// Timestamp returns the timestamp associated with this IntExemplar.
func (ms IntExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntExemplar.
func (ms IntExemplar) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this IntExemplar.
func (ms IntExemplar) Value() int64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this IntExemplar.
func (ms IntExemplar) SetValue(v int64) {
	(*ms.orig).Value = v
}

// FilteredLabels returns the FilteredLabels associated with this IntExemplar.
func (ms IntExemplar) FilteredLabels() StringMap {
	return newStringMap(&(*ms.orig).FilteredLabels)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntExemplar) CopyTo(dest IntExemplar) {
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.FilteredLabels().CopyTo(dest.FilteredLabels())
}

// DoubleExemplarSlice logically represents a slice of DoubleExemplar.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleExemplarSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleExemplarSlice struct {
	// orig points to the slice otlpmetrics.DoubleExemplar field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]otlpmetrics.DoubleExemplar
}

func newDoubleExemplarSlice(orig *[]otlpmetrics.DoubleExemplar) DoubleExemplarSlice {
	return DoubleExemplarSlice{orig}
}

// NewDoubleExemplarSlice creates a DoubleExemplarSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleExemplarSlice() DoubleExemplarSlice {
	orig := []otlpmetrics.DoubleExemplar(nil)
	return DoubleExemplarSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleExemplarSlice()".
func (es DoubleExemplarSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleExemplarSlice) At(ix int) DoubleExemplar {
	return newDoubleExemplar(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleExemplarSlice) MoveAndAppendTo(dest DoubleExemplarSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleExemplarSlice) CopyTo(dest DoubleExemplarSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
	} else {
		(*dest.orig) = make([]otlpmetrics.DoubleExemplar, srcLen)
	}

	for i := range *es.orig {
		newDoubleExemplar(&(*es.orig)[i]).CopyTo(newDoubleExemplar(&(*dest.orig)[i]))
	}
}

// Resize is an operation that resizes the slice:
// 1. If the newLen <= len then equivalent with slice[0:newLen:cap].
// 2. If the newLen > len then (newLen - cap) empty elements will be appended to the slice.
//
// Here is how a new DoubleExemplarSlice can be initialized:
// es := NewDoubleExemplarSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleExemplarSlice) Resize(newLen int) {
	oldLen := len(*es.orig)
	oldCap := cap(*es.orig)
	if newLen <= oldLen {
		*es.orig = (*es.orig)[:newLen:oldCap]
		return
	}

	if newLen > oldCap {
		newOrig := make([]otlpmetrics.DoubleExemplar, oldLen, newLen)
		copy(newOrig, *es.orig)
		*es.orig = newOrig
	}

	// Add extra empty elements to the array.
	empty := otlpmetrics.DoubleExemplar{}
	for i := oldLen; i < newLen; i++ {
		*es.orig = append(*es.orig, empty)
	}
}

// Append will increase the length of the DoubleExemplarSlice by one and set the
// given DoubleExemplar at that new position.  The original DoubleExemplar
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleExemplarSlice) Append(e DoubleExemplar) {
	*es.orig = append(*es.orig, *e.orig)
}

// DoubleExemplar is a sample input double measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleExemplar struct {
	orig *otlpmetrics.DoubleExemplar
}

func newDoubleExemplar(orig *otlpmetrics.DoubleExemplar) DoubleExemplar {
	return DoubleExemplar{orig: orig}
}

// NewDoubleExemplar creates a new empty DoubleExemplar.
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleExemplar() DoubleExemplar {
	return newDoubleExemplar(&otlpmetrics.DoubleExemplar{})
}

// Timestamp returns the timestamp associated with this DoubleExemplar.
func (ms DoubleExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleExemplar.
func (ms DoubleExemplar) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleExemplar.
func (ms DoubleExemplar) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this DoubleExemplar.
func (ms DoubleExemplar) SetValue(v float64) {
	(*ms.orig).Value = v
}

// FilteredLabels returns the FilteredLabels associated with this DoubleExemplar.
func (ms DoubleExemplar) FilteredLabels() StringMap {
	return newStringMap(&(*ms.orig).FilteredLabels)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleExemplar) CopyTo(dest DoubleExemplar) {
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.FilteredLabels().CopyTo(dest.FilteredLabels())
}
