SELECT '< HIVE-3072 Skewed Table DDL >' AS ' ';

CREATE TABLE IF NOT EXISTS `SKEWED_STRING_LIST` (
   `STRING_LIST_ID` bigint(20) NOT NULL,
   PRIMARY KEY (`STRING_LIST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `SKEWED_STRING_LIST_VALUES` (
   `STRING_LIST_ID` bigint(20) NOT NULL,
   `STRING_LIST_VALUE` varchar(256) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
   `INTEGER_IDX` int(11) NOT NULL,
   PRIMARY KEY (`STRING_LIST_ID`,`INTEGER_IDX`),
   KEY `SKEWED_STRING_LIST_VALUES_N49` (`STRING_LIST_ID`),
   CONSTRAINT `SKEWED_STRING_LIST_VALUES_FK1` FOREIGN KEY (`STRING_LIST_ID`) REFERENCES `SKEWED_STRING_LIST` (`STRING_LIST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `SKEWED_COL_NAMES` (
   `SD_ID` bigint(20) NOT NULL,
   `SKEWED_COL_NAME` varchar(256) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
   `INTEGER_IDX` int(11) NOT NULL,
   PRIMARY KEY (`SD_ID`,`INTEGER_IDX`),
   KEY `SKEWED_COL_NAMES_N49` (`SD_ID`),
   CONSTRAINT `SKEWED_COL_NAMES_FK1` FOREIGN KEY (`SD_ID`) REFERENCES `SDS` (`SD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `SKEWED_COL_VALUE_LOC_MAP` (
   `SD_ID` bigint(20) NOT NULL,
   `STRING_LIST_ID_KID` bigint(20) NOT NULL,
   `LOCATION` varchar(4000) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
   PRIMARY KEY (`SD_ID`,`STRING_LIST_ID_KID`),
   KEY `SKEWED_COL_VALUE_LOC_MAP_N49` (`STRING_LIST_ID_KID`),
   KEY `SKEWED_COL_VALUE_LOC_MAP_N50` (`SD_ID`),
   CONSTRAINT `SKEWED_COL_VALUE_LOC_MAP_FK2` FOREIGN KEY (`STRING_LIST_ID_KID`) REFERENCES `SKEWED_STRING_LIST` (`STRING_LIST_ID`),
   CONSTRAINT `SKEWED_COL_VALUE_LOC_MAP_FK1` FOREIGN KEY (`SD_ID`) REFERENCES `SDS` (`SD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `SKEWED_VALUES` (
   `SD_ID_OID` bigint(20) NOT NULL,
   `STRING_LIST_ID_EID` bigint(20) NOT NULL,
   `INTEGER_IDX` int(11) NOT NULL,
   PRIMARY KEY (`SD_ID_OID`,`INTEGER_IDX`),
   KEY `SKEWED_VALUES_N50` (`SD_ID_OID`),
   KEY `SKEWED_VALUES_N49` (`STRING_LIST_ID_EID`),
   CONSTRAINT `SKEWED_VALUES_FK2` FOREIGN KEY (`STRING_LIST_ID_EID`) REFERENCES `SKEWED_STRING_LIST` (`STRING_LIST_ID`),
   CONSTRAINT `SKEWED_VALUES_FK1` FOREIGN KEY (`SD_ID_OID`) REFERENCES `SDS` (`SD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


