/*
 * REST API
 *
 * Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!
 *
 * API version: v1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package rockset
import (
    "bytes"
    "encoding/json"
    "fmt"
    
)

// An organization in Rockset is a container for users and collections.
type Organization struct {
	// unique identifier for the organization
	Id string `json:"id,omitempty"`
	// ISO-8601 date
	CreatedAt string `json:"created_at,omitempty"`
	// name of the organization
	DisplayName string `json:"display_name,omitempty"`
	// name of the company
	CompanyName string `json:"company_name,omitempty"`
	// pricing tier
	Tier string `json:"tier,omitempty"`
	// number of QCUs
	Qcu int32 `json:"qcu,omitempty"`
	// org state
	State string `json:"state,omitempty"`
}
func (m Organization) PrintResponse() {
    r, err := json.Marshal(m)
    var out bytes.Buffer
    err = json.Indent(&out, []byte(string(r)), "", "    ")
    if err != nil {
        fmt.Println("error parsing string")
        return
    }

    fmt.Println(out.String())
}

