/*
 * REST API
 *
 * Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!
 *
 * API version: v1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package rockset
import (
    "bytes"
    "encoding/json"
    "fmt"
    
)

type RedshiftIntegration struct {
	// AWS access key credentials
	AwsAccessKey *AwsAccessKey `json:"aws_access_key,omitempty"`
	// Username associated with Redshift cluster
	Username string `json:"username"`
	// Password associated with Redshift cluster
	Password string `json:"password"`
	// Redshift Cluster host
	Host string `json:"host"`
	// Redshift Cluster port
	Port int32 `json:"port"`
	// unload S3 bucket path
	S3BucketPath string `json:"s3_bucket_path"`
}
func (m RedshiftIntegration) PrintResponse() {
    r, err := json.Marshal(m)
    var out bytes.Buffer
    err = json.Indent(&out, []byte(string(r)), "", "    ")
    if err != nil {
        fmt.Println("error parsing string")
        return
    }

    fmt.Println(out.String())
}

