package formrecognizer

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v1.0/formrecognizer"

// Status enumerates the values for status.
type Status string

const (
	// Failure ...
	Failure Status = "failure"
	// PartialSuccess ...
	PartialSuccess Status = "partialSuccess"
	// Success ...
	Success Status = "success"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Failure, PartialSuccess, Success}
}

// Status1 enumerates the values for status 1.
type Status1 string

const (
	// Created ...
	Created Status1 = "created"
	// Invalid ...
	Invalid Status1 = "invalid"
	// Ready ...
	Ready Status1 = "ready"
)

// PossibleStatus1Values returns an array of possible values for the Status1 const type.
func PossibleStatus1Values() []Status1 {
	return []Status1{Created, Invalid, Ready}
}

// Status2 enumerates the values for status 2.
type Status2 string

const (
	// Status2Failure ...
	Status2Failure Status2 = "failure"
	// Status2PartialSuccess ...
	Status2PartialSuccess Status2 = "partialSuccess"
	// Status2Success ...
	Status2Success Status2 = "success"
)

// PossibleStatus2Values returns an array of possible values for the Status2 const type.
func PossibleStatus2Values() []Status2 {
	return []Status2{Status2Failure, Status2PartialSuccess, Status2Success}
}

// AnalyzeResult analyze API call result.
type AnalyzeResult struct {
	autorest.Response `json:"-"`
	// Status - Status of the analyze operation. Possible values include: 'Status2Success', 'Status2PartialSuccess', 'Status2Failure'
	Status Status2 `json:"status,omitempty"`
	// Pages - Page level information extracted in the analyzed
	// document.
	Pages *[]ExtractedPage `json:"pages,omitempty"`
	// Errors - List of errors reported during the analyze
	// operation.
	Errors *[]FormOperationError `json:"errors,omitempty"`
}

// ErrorInformation ...
type ErrorInformation struct {
	Code       *string     `json:"code,omitempty"`
	InnerError *InnerError `json:"innerError,omitempty"`
	Message    *string     `json:"message,omitempty"`
}

// ErrorResponse ...
type ErrorResponse struct {
	Error *ErrorInformation `json:"error,omitempty"`
}

// ExtractedKeyValuePair representation of a key-value pair as a list
// of key and value tokens.
type ExtractedKeyValuePair struct {
	// Key - List of tokens for the extracted key in a key-value pair.
	Key *[]ExtractedToken `json:"key,omitempty"`
	// Value - List of tokens for the extracted value in a key-value pair.
	Value *[]ExtractedToken `json:"value,omitempty"`
}

// ExtractedPage extraction information of a single page in a
// with a document.
type ExtractedPage struct {
	// Number - Page number.
	Number *int32 `json:"number,omitempty"`
	// Height - Height of the page (in pixels).
	Height *int32 `json:"height,omitempty"`
	// Width - Width of the page (in pixels).
	Width *int32 `json:"width,omitempty"`
	// ClusterID - Cluster identifier.
	ClusterID *int32 `json:"clusterId,omitempty"`
	// KeyValuePairs - List of Key-Value pairs extracted from the page.
	KeyValuePairs *[]ExtractedKeyValuePair `json:"keyValuePairs,omitempty"`
	// Tables - List of Tables and their information extracted from the page.
	Tables *[]ExtractedTable `json:"tables,omitempty"`
}

// ExtractedTable extraction information about a table
// contained in a page.
type ExtractedTable struct {
	// ID - Table identifier.
	ID *string `json:"id,omitempty"`
	// Columns - List of columns contained in the table.
	Columns *[]ExtractedTableColumn `json:"columns,omitempty"`
}

// ExtractedTableColumn extraction information of a column in
// a table.
type ExtractedTableColumn struct {
	// Header - List of extracted tokens for the column header.
	Header *[]ExtractedToken `json:"header,omitempty"`
	// Entries - Extracted text for each cell of a column. Each cell
	// in the column can have a list of one or more tokens.
	Entries *[][]ExtractedToken `json:"entries,omitempty"`
}

// ExtractedToken canonical representation of single extracted text.
type ExtractedToken struct {
	// Text - String value of the extracted text.
	Text *string `json:"text,omitempty"`
	// BoundingBox - Bounding box of the extracted text. Represents the
	// location of the extracted text as a pair of
	// cartesian co-ordinates. The co-ordinate pairs are arranged by
	// top-left, top-right, bottom-right and bottom-left endpoints box
	// with origin reference from the bottom-left of the page.
	BoundingBox *[]float64 `json:"boundingBox,omitempty"`
	// Confidence - A measure of accuracy of the extracted text.
	Confidence *float64 `json:"confidence,omitempty"`
}

// FormDocumentReport ...
type FormDocumentReport struct {
	// DocumentName - Reference to the data that the report is for.
	DocumentName *string `json:"documentName,omitempty"`
	// Pages - Total number of pages trained on.
	Pages *int32 `json:"pages,omitempty"`
	// Errors - List of errors per page.
	Errors *[]string `json:"errors,omitempty"`
	// Status - Status of the training operation. Possible values include: 'Success', 'PartialSuccess', 'Failure'
	Status Status `json:"status,omitempty"`
}

// FormOperationError error reported during an operation.
type FormOperationError struct {
	// ErrorMessage - Message reported during the train operation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// InnerError ...
type InnerError struct {
	RequestID *string `json:"requestId,omitempty"`
}

// KeysResult result of an operation to get
// the keys extracted by a model.
type KeysResult struct {
	autorest.Response `json:"-"`
	// Clusters - Object mapping ClusterIds to Key lists.
	Clusters map[string][]string `json:"clusters"`
}

// MarshalJSON is the custom marshaler for KeysResult.
func (kr KeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kr.Clusters != nil {
		objectMap["clusters"] = kr.Clusters
	}
	return json.Marshal(objectMap)
}

// ModelResult result of a model status query operation.
type ModelResult struct {
	autorest.Response `json:"-"`
	// ModelID - Get or set model identifier.
	ModelID *uuid.UUID `json:"modelId,omitempty"`
	// Status - Get or set the status of model. Possible values include: 'Created', 'Ready', 'Invalid'
	Status Status1 `json:"status,omitempty"`
	// CreatedDateTime - Get or set the created date time of the model.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// LastUpdatedDateTime - Get or set the model last updated datetime.
	LastUpdatedDateTime *date.Time `json:"lastUpdatedDateTime,omitempty"`
}

// ModelsResult result of query operation to fetch multiple models.
type ModelsResult struct {
	autorest.Response `json:"-"`
	// ModelsProperty - Collection of models.
	ModelsProperty *[]ModelResult `json:"models,omitempty"`
}

// TrainRequest contract to initiate a train request.
type TrainRequest struct {
	// Source - Get or set source path.
	Source *string `json:"source,omitempty"`
}

// TrainResult response of the Train API call.
type TrainResult struct {
	autorest.Response `json:"-"`
	// ModelID - Identifier of the model.
	ModelID *uuid.UUID `json:"modelId,omitempty"`
	// TrainingDocuments - List of documents used to train the model and the
	// train operation error reported by each.
	TrainingDocuments *[]FormDocumentReport `json:"trainingDocuments,omitempty"`
	// Errors - Errors returned during the training operation.
	Errors *[]FormOperationError `json:"errors,omitempty"`
}
