// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grafeas/v1/vulnerability.proto

package grafeas

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Note provider assigned severity/impact ranking.
type Severity int32

const (
	// Unknown.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// Minimal severity.
	Severity_MINIMAL Severity = 1
	// Low severity.
	Severity_LOW Severity = 2
	// Medium severity.
	Severity_MEDIUM Severity = 3
	// High severity.
	Severity_HIGH Severity = 4
	// Critical severity.
	Severity_CRITICAL Severity = 5
)

var Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "MINIMAL",
	2: "LOW",
	3: "MEDIUM",
	4: "HIGH",
	5: "CRITICAL",
}

var Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"MINIMAL":              1,
	"LOW":                  2,
	"MEDIUM":               3,
	"HIGH":                 4,
	"CRITICAL":             5,
}

func (x Severity) String() string {
	return proto.EnumName(Severity_name, int32(x))
}

func (Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{0}
}

// A security vulnerability that can be found in resources.
type VulnerabilityNote struct {
	// The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10
	// where 0 indicates low severity and 10 indicates high severity.
	CvssScore float32 `protobuf:"fixed32,1,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// The note provider assigned severity of this vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1.Severity" json:"severity,omitempty"`
	// Details of all known distros and packages affected by this vulnerability.
	Details []*VulnerabilityNote_Detail `protobuf:"bytes,3,rep,name=details,proto3" json:"details,omitempty"`
	// The full description of the CVSSv3 for this vulnerability.
	CvssV3 *CVSSv3 `protobuf:"bytes,4,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	// Windows details get their own format because the information format and
	// model don't match a normal detail. Specifically Windows updates are done as
	// patches, thus Windows vulnerabilities really are a missing package, rather
	// than a package being at an incorrect version.
	WindowsDetails       []*VulnerabilityNote_WindowsDetail `protobuf:"bytes,5,rep,name=windows_details,json=windowsDetails,proto3" json:"windows_details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *VulnerabilityNote) Reset()         { *m = VulnerabilityNote{} }
func (m *VulnerabilityNote) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityNote) ProtoMessage()    {}
func (*VulnerabilityNote) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{0}
}

func (m *VulnerabilityNote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityNote.Unmarshal(m, b)
}
func (m *VulnerabilityNote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityNote.Marshal(b, m, deterministic)
}
func (m *VulnerabilityNote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityNote.Merge(m, src)
}
func (m *VulnerabilityNote) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityNote.Size(m)
}
func (m *VulnerabilityNote) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityNote.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityNote proto.InternalMessageInfo

func (m *VulnerabilityNote) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *VulnerabilityNote) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityNote) GetDetails() []*VulnerabilityNote_Detail {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *VulnerabilityNote) GetCvssV3() *CVSSv3 {
	if m != nil {
		return m.CvssV3
	}
	return nil
}

func (m *VulnerabilityNote) GetWindowsDetails() []*VulnerabilityNote_WindowsDetail {
	if m != nil {
		return m.WindowsDetails
	}
	return nil
}

// A detail for a distro and package affected by this vulnerability and its
// associated fix (if one is available).
type VulnerabilityNote_Detail struct {
	// The distro assigned severity of this vulnerability.
	SeverityName string `protobuf:"bytes,1,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	// A vendor-specific description of this vulnerability.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The type of package; whether native or non native (e.g., ruby gems,
	// node.js packages, etc.).
	PackageType string `protobuf:"bytes,3,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability affects.
	AffectedCpeUri string `protobuf:"bytes,4,opt,name=affected_cpe_uri,json=affectedCpeUri,proto3" json:"affected_cpe_uri,omitempty"`
	// Required. The package this vulnerability affects.
	AffectedPackage string `protobuf:"bytes,5,opt,name=affected_package,json=affectedPackage,proto3" json:"affected_package,omitempty"`
	// Required. The minimum version of the package this vulnerability affects.
	MinAffectedVersion *Version `protobuf:"bytes,6,opt,name=min_affected_version,json=minAffectedVersion,proto3" json:"min_affected_version,omitempty"`
	// The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
	// was fixed in. It is possible for this to be different from the
	// affected_cpe_uri.
	FixedCpeUri string `protobuf:"bytes,7,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// The package this vulnerability was fixed in. It is possible for this to
	// be different from the affected_package.
	FixedPackage string `protobuf:"bytes,8,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// Required. The version of the package this vulnerability was fixed in.
	// Setting this to VersionKind.MAXIMUM means no fix is yet available.
	FixedVersion *Version `protobuf:"bytes,9,opt,name=fixed_version,json=fixedVersion,proto3" json:"fixed_version,omitempty"`
	// Whether this detail is obsolete. Occurrences are expected not to point to
	// obsolete details.
	IsObsolete           bool     `protobuf:"varint,10,opt,name=is_obsolete,json=isObsolete,proto3" json:"is_obsolete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityNote_Detail) Reset()         { *m = VulnerabilityNote_Detail{} }
func (m *VulnerabilityNote_Detail) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityNote_Detail) ProtoMessage()    {}
func (*VulnerabilityNote_Detail) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{0, 0}
}

func (m *VulnerabilityNote_Detail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityNote_Detail.Unmarshal(m, b)
}
func (m *VulnerabilityNote_Detail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityNote_Detail.Marshal(b, m, deterministic)
}
func (m *VulnerabilityNote_Detail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityNote_Detail.Merge(m, src)
}
func (m *VulnerabilityNote_Detail) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityNote_Detail.Size(m)
}
func (m *VulnerabilityNote_Detail) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityNote_Detail.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityNote_Detail proto.InternalMessageInfo

func (m *VulnerabilityNote_Detail) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetPackageType() string {
	if m != nil {
		return m.PackageType
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetAffectedCpeUri() string {
	if m != nil {
		return m.AffectedCpeUri
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetAffectedPackage() string {
	if m != nil {
		return m.AffectedPackage
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetMinAffectedVersion() *Version {
	if m != nil {
		return m.MinAffectedVersion
	}
	return nil
}

func (m *VulnerabilityNote_Detail) GetFixedCpeUri() string {
	if m != nil {
		return m.FixedCpeUri
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetFixedPackage() string {
	if m != nil {
		return m.FixedPackage
	}
	return ""
}

func (m *VulnerabilityNote_Detail) GetFixedVersion() *Version {
	if m != nil {
		return m.FixedVersion
	}
	return nil
}

func (m *VulnerabilityNote_Detail) GetIsObsolete() bool {
	if m != nil {
		return m.IsObsolete
	}
	return false
}

type VulnerabilityNote_WindowsDetail struct {
	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability affects.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of this vulnerability.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The description of this vulnerability.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The names of the KBs which have hotfixes to mitigate this
	// vulnerability. Note that there may be multiple hotfixes (and thus
	// multiple KBs) that mitigate a given vulnerability. Currently any listed
	// KBs presence is considered a fix.
	FixingKbs            []*VulnerabilityNote_WindowsDetail_KnowledgeBase `protobuf:"bytes,4,rep,name=fixing_kbs,json=fixingKbs,proto3" json:"fixing_kbs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *VulnerabilityNote_WindowsDetail) Reset()         { *m = VulnerabilityNote_WindowsDetail{} }
func (m *VulnerabilityNote_WindowsDetail) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityNote_WindowsDetail) ProtoMessage()    {}
func (*VulnerabilityNote_WindowsDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{0, 1}
}

func (m *VulnerabilityNote_WindowsDetail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail.Unmarshal(m, b)
}
func (m *VulnerabilityNote_WindowsDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail.Marshal(b, m, deterministic)
}
func (m *VulnerabilityNote_WindowsDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityNote_WindowsDetail.Merge(m, src)
}
func (m *VulnerabilityNote_WindowsDetail) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail.Size(m)
}
func (m *VulnerabilityNote_WindowsDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityNote_WindowsDetail.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityNote_WindowsDetail proto.InternalMessageInfo

func (m *VulnerabilityNote_WindowsDetail) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *VulnerabilityNote_WindowsDetail) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VulnerabilityNote_WindowsDetail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *VulnerabilityNote_WindowsDetail) GetFixingKbs() []*VulnerabilityNote_WindowsDetail_KnowledgeBase {
	if m != nil {
		return m.FixingKbs
	}
	return nil
}

type VulnerabilityNote_WindowsDetail_KnowledgeBase struct {
	// The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A link to the KB in the [Windows update catalog]
	// (https://www.catalog.update.microsoft.com/).
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) Reset() {
	*m = VulnerabilityNote_WindowsDetail_KnowledgeBase{}
}
func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) String() string {
	return proto.CompactTextString(m)
}
func (*VulnerabilityNote_WindowsDetail_KnowledgeBase) ProtoMessage() {}
func (*VulnerabilityNote_WindowsDetail_KnowledgeBase) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{0, 1, 0}
}

func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase.Unmarshal(m, b)
}
func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase.Marshal(b, m, deterministic)
}
func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase.Merge(m, src)
}
func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase.Size(m)
}
func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityNote_WindowsDetail_KnowledgeBase proto.InternalMessageInfo

func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VulnerabilityNote_WindowsDetail_KnowledgeBase) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// An occurrence of a severity vulnerability on a resource.
type VulnerabilityOccurrence struct {
	// The type of package; whether native or non native (e.g., ruby gems, node.js
	// packages, etc.).
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The note provider assigned severity of this vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1.Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0 - 10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,3,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Required. The set of affected locations and their fixes (if available)
	// within the associated resource.
	PackageIssue []*VulnerabilityOccurrence_PackageIssue `protobuf:"bytes,4,rep,name=package_issue,json=packageIssue,proto3" json:"package_issue,omitempty"`
	// Output only. A one sentence description of this vulnerability.
	ShortDescription string `protobuf:"bytes,5,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Output only. A detailed description of this vulnerability.
	LongDescription string `protobuf:"bytes,6,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. URLs related to this vulnerability.
	RelatedUrls []*RelatedUrl `protobuf:"bytes,7,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	// The distro assigned severity for this vulnerability when it is available,
	// and note provider assigned severity when distro has not yet assigned a
	// severity for this vulnerability.
	EffectiveSeverity Severity `protobuf:"varint,8,opt,name=effective_severity,json=effectiveSeverity,proto3,enum=grafeas.v1.Severity" json:"effective_severity,omitempty"`
	// Output only. Whether at least one of the affected packages has a fix
	// available.
	FixAvailable         bool     `protobuf:"varint,9,opt,name=fix_available,json=fixAvailable,proto3" json:"fix_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityOccurrence) Reset()         { *m = VulnerabilityOccurrence{} }
func (m *VulnerabilityOccurrence) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityOccurrence) ProtoMessage()    {}
func (*VulnerabilityOccurrence) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{1}
}

func (m *VulnerabilityOccurrence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityOccurrence.Unmarshal(m, b)
}
func (m *VulnerabilityOccurrence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityOccurrence.Marshal(b, m, deterministic)
}
func (m *VulnerabilityOccurrence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityOccurrence.Merge(m, src)
}
func (m *VulnerabilityOccurrence) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityOccurrence.Size(m)
}
func (m *VulnerabilityOccurrence) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityOccurrence.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityOccurrence proto.InternalMessageInfo

func (m *VulnerabilityOccurrence) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *VulnerabilityOccurrence) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityOccurrence) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *VulnerabilityOccurrence) GetPackageIssue() []*VulnerabilityOccurrence_PackageIssue {
	if m != nil {
		return m.PackageIssue
	}
	return nil
}

func (m *VulnerabilityOccurrence) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *VulnerabilityOccurrence) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *VulnerabilityOccurrence) GetRelatedUrls() []*RelatedUrl {
	if m != nil {
		return m.RelatedUrls
	}
	return nil
}

func (m *VulnerabilityOccurrence) GetEffectiveSeverity() Severity {
	if m != nil {
		return m.EffectiveSeverity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityOccurrence) GetFixAvailable() bool {
	if m != nil {
		return m.FixAvailable
	}
	return false
}

// A detail for a distro and package this vulnerability occurrence was found
// in and its associated fix (if one is available).
type VulnerabilityOccurrence_PackageIssue struct {
	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability was found in.
	AffectedCpeUri string `protobuf:"bytes,1,opt,name=affected_cpe_uri,json=affectedCpeUri,proto3" json:"affected_cpe_uri,omitempty"`
	// Required. The package this vulnerability was found in.
	AffectedPackage string `protobuf:"bytes,2,opt,name=affected_package,json=affectedPackage,proto3" json:"affected_package,omitempty"`
	// Required. The minimum version of the package this vulnerability exists
	// in.
	MinAffectedVersion *Version `protobuf:"bytes,3,opt,name=min_affected_version,json=minAffectedVersion,proto3" json:"min_affected_version,omitempty"`
	// The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
	// was fixed in. It is possible for this to be different from the
	// affected_cpe_uri.
	FixedCpeUri string `protobuf:"bytes,4,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// The package this vulnerability was fixed in. It is possible for this to
	// be different from the affected_package.
	FixedPackage string `protobuf:"bytes,5,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// Required. The version of the package this vulnerability was fixed in.
	// Setting this to VersionKind.MAXIMUM means no fix is yet available.
	FixedVersion *Version `protobuf:"bytes,6,opt,name=fixed_version,json=fixedVersion,proto3" json:"fixed_version,omitempty"`
	// Output only. Whether a fix is available for this package.
	FixAvailable         bool     `protobuf:"varint,7,opt,name=fix_available,json=fixAvailable,proto3" json:"fix_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityOccurrence_PackageIssue) Reset()         { *m = VulnerabilityOccurrence_PackageIssue{} }
func (m *VulnerabilityOccurrence_PackageIssue) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityOccurrence_PackageIssue) ProtoMessage()    {}
func (*VulnerabilityOccurrence_PackageIssue) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc4b69df8d04ae33, []int{1, 0}
}

func (m *VulnerabilityOccurrence_PackageIssue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityOccurrence_PackageIssue.Unmarshal(m, b)
}
func (m *VulnerabilityOccurrence_PackageIssue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityOccurrence_PackageIssue.Marshal(b, m, deterministic)
}
func (m *VulnerabilityOccurrence_PackageIssue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityOccurrence_PackageIssue.Merge(m, src)
}
func (m *VulnerabilityOccurrence_PackageIssue) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityOccurrence_PackageIssue.Size(m)
}
func (m *VulnerabilityOccurrence_PackageIssue) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityOccurrence_PackageIssue.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityOccurrence_PackageIssue proto.InternalMessageInfo

func (m *VulnerabilityOccurrence_PackageIssue) GetAffectedCpeUri() string {
	if m != nil {
		return m.AffectedCpeUri
	}
	return ""
}

func (m *VulnerabilityOccurrence_PackageIssue) GetAffectedPackage() string {
	if m != nil {
		return m.AffectedPackage
	}
	return ""
}

func (m *VulnerabilityOccurrence_PackageIssue) GetMinAffectedVersion() *Version {
	if m != nil {
		return m.MinAffectedVersion
	}
	return nil
}

func (m *VulnerabilityOccurrence_PackageIssue) GetFixedCpeUri() string {
	if m != nil {
		return m.FixedCpeUri
	}
	return ""
}

func (m *VulnerabilityOccurrence_PackageIssue) GetFixedPackage() string {
	if m != nil {
		return m.FixedPackage
	}
	return ""
}

func (m *VulnerabilityOccurrence_PackageIssue) GetFixedVersion() *Version {
	if m != nil {
		return m.FixedVersion
	}
	return nil
}

func (m *VulnerabilityOccurrence_PackageIssue) GetFixAvailable() bool {
	if m != nil {
		return m.FixAvailable
	}
	return false
}

func init() {
	proto.RegisterEnum("grafeas.v1.Severity", Severity_name, Severity_value)
	proto.RegisterType((*VulnerabilityNote)(nil), "grafeas.v1.VulnerabilityNote")
	proto.RegisterType((*VulnerabilityNote_Detail)(nil), "grafeas.v1.VulnerabilityNote.Detail")
	proto.RegisterType((*VulnerabilityNote_WindowsDetail)(nil), "grafeas.v1.VulnerabilityNote.WindowsDetail")
	proto.RegisterType((*VulnerabilityNote_WindowsDetail_KnowledgeBase)(nil), "grafeas.v1.VulnerabilityNote.WindowsDetail.KnowledgeBase")
	proto.RegisterType((*VulnerabilityOccurrence)(nil), "grafeas.v1.VulnerabilityOccurrence")
	proto.RegisterType((*VulnerabilityOccurrence_PackageIssue)(nil), "grafeas.v1.VulnerabilityOccurrence.PackageIssue")
}

func init() { proto.RegisterFile("grafeas/v1/vulnerability.proto", fileDescriptor_cc4b69df8d04ae33) }

var fileDescriptor_cc4b69df8d04ae33 = []byte{
	// 865 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xc6, 0x71, 0x6a, 0x27, 0x27, 0x49, 0xd7, 0x1d, 0x0a, 0xb5, 0x22, 0x01, 0xa1, 0xcb, 0x45,
	0x96, 0x4a, 0xce, 0x6e, 0x2b, 0xa4, 0x5d, 0x21, 0x21, 0x65, 0xd3, 0xb0, 0x6b, 0x6d, 0xff, 0x70,
	0x9a, 0x2e, 0x70, 0x81, 0xe5, 0x38, 0x13, 0x33, 0x5a, 0xc7, 0x13, 0xcd, 0x38, 0xee, 0xf6, 0x75,
	0xb8, 0xe1, 0x9e, 0x07, 0xe1, 0x82, 0x17, 0xe1, 0x15, 0x90, 0x67, 0xec, 0x74, 0xb2, 0x65, 0x57,
	0x29, 0xdc, 0x4d, 0xbe, 0xf3, 0x9d, 0x99, 0x2f, 0xdf, 0xf9, 0x31, 0x7c, 0x1e, 0xb1, 0x60, 0x86,
	0x03, 0xde, 0xcb, 0x9e, 0xf4, 0xb2, 0x65, 0x9c, 0x60, 0x16, 0x4c, 0x48, 0x4c, 0xd2, 0x1b, 0x67,
	0xc1, 0x68, 0x4a, 0x11, 0x14, 0x71, 0x27, 0x7b, 0xd2, 0xde, 0x53, 0xb8, 0x21, 0x9d, 0xcf, 0x69,
	0x22, 0x49, 0xed, 0x4f, 0xd4, 0x40, 0xc6, 0x79, 0x01, 0xdb, 0x0a, 0xbc, 0x08, 0xc2, 0x37, 0x41,
	0x84, 0x65, 0x64, 0xff, 0x4f, 0x13, 0x76, 0xae, 0xd4, 0xd7, 0xce, 0x68, 0x8a, 0xd1, 0x67, 0x00,
	0x79, 0xb6, 0xcf, 0x43, 0xca, 0xb0, 0xad, 0x75, 0xb4, 0x6e, 0xc5, 0xab, 0xe7, 0xc8, 0x28, 0x07,
	0xd0, 0x63, 0xa8, 0x71, 0x9c, 0x61, 0x46, 0xd2, 0x1b, 0xbb, 0xd2, 0xd1, 0xba, 0xdb, 0x87, 0xbb,
	0xce, 0xad, 0x3a, 0x67, 0x54, 0xc4, 0xbc, 0x15, 0x0b, 0x7d, 0x07, 0xe6, 0x14, 0xa7, 0x01, 0x89,
	0xb9, 0xad, 0x77, 0xf4, 0x6e, 0xe3, 0xf0, 0x2b, 0x35, 0xe1, 0x8e, 0x00, 0xe7, 0x58, 0x90, 0xbd,
	0x32, 0x09, 0x1d, 0x80, 0x29, 0x04, 0x65, 0x47, 0x76, 0xb5, 0xa3, 0x75, 0x1b, 0x87, 0x48, 0xcd,
	0x1f, 0x5c, 0x8d, 0x46, 0xd9, 0x91, 0x67, 0xe4, 0x94, 0xab, 0x23, 0x74, 0x09, 0x0f, 0xae, 0x49,
	0x32, 0xa5, 0xd7, 0xdc, 0x2f, 0x1f, 0xdd, 0x12, 0x8f, 0x1e, 0x7c, 0xf8, 0xd1, 0xd7, 0x32, 0xa9,
	0x78, 0x7b, 0xfb, 0x5a, 0xfd, 0xc9, 0xdb, 0x7f, 0xe8, 0x60, 0xc8, 0x33, 0x7a, 0x08, 0xad, 0xf2,
	0x9f, 0xf9, 0x49, 0x30, 0x97, 0x0e, 0xd5, 0xbd, 0x66, 0x09, 0x9e, 0x05, 0x73, 0x8c, 0x3a, 0xd0,
	0x98, 0x62, 0x1e, 0x32, 0xb2, 0x48, 0x09, 0x4d, 0x84, 0x4f, 0x75, 0x4f, 0x85, 0xd0, 0x97, 0xd0,
	0x2c, 0x8a, 0xe1, 0xa7, 0x37, 0x0b, 0x6c, 0xeb, 0x92, 0x52, 0x60, 0x97, 0x37, 0x0b, 0x8c, 0xba,
	0x60, 0x05, 0xb3, 0x19, 0x0e, 0x53, 0x3c, 0xf5, 0xc3, 0x05, 0xf6, 0x97, 0x8c, 0x08, 0x03, 0xea,
	0xde, 0x76, 0x89, 0x0f, 0x16, 0x78, 0xcc, 0x08, 0x7a, 0xa4, 0x30, 0x8b, 0x1b, 0xec, 0x2d, 0xc1,
	0x7c, 0x50, 0xe2, 0x17, 0x12, 0x46, 0x43, 0xd8, 0x9d, 0x93, 0xc4, 0x5f, 0xd1, 0x33, 0xcc, 0x78,
	0x2e, 0xd1, 0x10, 0xce, 0x7e, 0xbc, 0x66, 0x92, 0x0c, 0x79, 0x68, 0x4e, 0x92, 0x7e, 0xc1, 0x2f,
	0x30, 0xb4, 0x0f, 0xad, 0x19, 0x79, 0xab, 0x08, 0x33, 0xa5, 0x7e, 0x01, 0x16, 0xaa, 0x1e, 0x96,
	0x9c, 0x52, 0x52, 0x4d, 0x3a, 0x25, 0xc0, 0x52, 0xcf, 0xd3, 0x92, 0x54, 0x0a, 0xa9, 0xbf, 0x5f,
	0x88, 0xcc, 0x2c, 0x25, 0x7c, 0x01, 0x0d, 0xc2, 0x7d, 0x3a, 0xe1, 0x34, 0xc6, 0x29, 0xb6, 0xa1,
	0xa3, 0x75, 0x6b, 0x1e, 0x10, 0x7e, 0x5e, 0x20, 0xed, 0xbf, 0x35, 0x68, 0xad, 0x95, 0x15, 0xed,
	0x81, 0x59, 0xea, 0x95, 0x55, 0x33, 0x42, 0x29, 0x15, 0x41, 0x55, 0xd4, 0x52, 0x16, 0x4a, 0x9c,
	0xdf, 0xad, 0xa1, 0x7e, 0xb7, 0x86, 0x3f, 0x02, 0xcc, 0xc8, 0x5b, 0x92, 0x44, 0xfe, 0x9b, 0x09,
	0xb7, 0xab, 0xa2, 0xcd, 0x9e, 0xdd, 0xa3, 0xcd, 0x9c, 0x57, 0x09, 0xbd, 0x8e, 0xf1, 0x34, 0xc2,
	0xcf, 0x03, 0x8e, 0xbd, 0xba, 0xbc, 0xec, 0xd5, 0x84, 0xb7, 0xbf, 0x81, 0xd6, 0x5a, 0x6c, 0x25,
	0x50, 0x53, 0x04, 0x5a, 0xa0, 0x2f, 0x59, 0x5c, 0x68, 0xce, 0x8f, 0xfb, 0xbf, 0x1b, 0xb0, 0xb7,
	0xf6, 0xe6, 0x79, 0x18, 0x2e, 0x19, 0xc3, 0x49, 0x28, 0x6e, 0x10, 0x8d, 0x56, 0xdc, 0x90, 0x9f,
	0xff, 0xc3, 0x2c, 0xaf, 0x2f, 0x07, 0xfd, 0xdd, 0xe5, 0x30, 0x86, 0x56, 0xd9, 0xd5, 0x84, 0xf3,
	0x25, 0x2e, 0x4c, 0x79, 0xfc, 0x5e, 0x53, 0x6e, 0x05, 0x3a, 0x45, 0x47, 0xb8, 0x79, 0x9e, 0x57,
	0x0e, 0x87, 0xf8, 0x85, 0x0e, 0x60, 0x87, 0xff, 0x4a, 0x59, 0xea, 0xab, 0x05, 0x91, 0x0d, 0x6e,
	0x89, 0xc0, 0xb1, 0x52, 0x95, 0x47, 0x60, 0xc5, 0x34, 0x89, 0xd6, 0xb8, 0x86, 0x1c, 0x86, 0x1c,
	0x57, 0xa9, 0xcf, 0xa0, 0xc9, 0x70, 0x1c, 0xe4, 0x73, 0xb0, 0x64, 0x31, 0xb7, 0x4d, 0xa1, 0xf6,
	0x53, 0x55, 0xad, 0x27, 0xe3, 0x63, 0x16, 0x7b, 0x0d, 0xb6, 0x3a, 0x73, 0x34, 0x00, 0x84, 0xc5,
	0x4c, 0x90, 0x0c, 0xfb, 0x2b, 0x13, 0x6b, 0x1f, 0x30, 0x71, 0x67, 0xc5, 0x2f, 0xa1, 0x62, 0x42,
	0xfc, 0x20, 0x0b, 0x48, 0x1c, 0x4c, 0x62, 0x2c, 0x9a, 0xbf, 0x26, 0xfa, 0xbc, 0x5f, 0x62, 0xed,
	0xbf, 0x2a, 0xd0, 0x54, 0xbd, 0xf9, 0xd7, 0xbd, 0xa0, 0x6d, 0xbc, 0x17, 0x2a, 0xf7, 0xdb, 0x0b,
	0xfa, 0xff, 0xdc, 0x0b, 0xd5, 0x0d, 0xf6, 0xc2, 0xd6, 0x26, 0x7b, 0xc1, 0xd8, 0x74, 0x2f, 0xdc,
	0x31, 0xd5, 0xbc, 0x6b, 0xea, 0xd7, 0xbf, 0x40, 0x6d, 0x55, 0x05, 0x1b, 0x76, 0x47, 0xc3, 0xab,
	0xa1, 0xe7, 0x5e, 0xfe, 0xe4, 0x8f, 0xcf, 0x46, 0x17, 0xc3, 0x81, 0xfb, 0xbd, 0x3b, 0x3c, 0xb6,
	0x3e, 0x42, 0x0d, 0x30, 0x4f, 0xdd, 0x33, 0xf7, 0xb4, 0x7f, 0x62, 0x69, 0xc8, 0x04, 0xfd, 0xe4,
	0xfc, 0xb5, 0x55, 0x41, 0x00, 0xc6, 0xe9, 0xf0, 0xd8, 0x1d, 0x9f, 0x5a, 0x3a, 0xaa, 0x41, 0xf5,
	0xa5, 0xfb, 0xe2, 0xa5, 0x55, 0x45, 0x4d, 0xa8, 0x0d, 0x3c, 0xf7, 0xd2, 0x1d, 0xf4, 0x4f, 0xac,
	0xad, 0xe7, 0x3f, 0x40, 0x8b, 0x50, 0x45, 0xeb, 0x85, 0xf6, 0xf3, 0xd3, 0x88, 0xd2, 0x28, 0xc6,
	0x4e, 0x44, 0xe3, 0x20, 0x89, 0x1c, 0xca, 0xa2, 0x5e, 0x84, 0x13, 0xf1, 0x25, 0xee, 0xc9, 0x50,
	0xb0, 0x20, 0xbc, 0x77, 0xfb, 0xb5, 0xfe, 0xb6, 0x38, 0xfe, 0x56, 0xd1, 0x5f, 0x78, 0xfd, 0x89,
	0x21, 0xa8, 0x47, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x28, 0x44, 0x70, 0x76, 0x2c, 0x08, 0x00,
	0x00,
}
