// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package acmiface provides an interface to enable mocking the AWS Certificate Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package acmiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/acm"
)

// ClientAPI provides an interface to enable mocking the
// acm.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // ACM.
//    func myFunc(svc acmiface.ClientAPI) bool {
//        // Make svc.AddTagsToCertificate request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := acm.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        acmiface.ClientPI
//    }
//    func (m *mockClientClient) AddTagsToCertificate(input *acm.AddTagsToCertificateInput) (*acm.AddTagsToCertificateOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsToCertificateRequest(*acm.AddTagsToCertificateInput) acm.AddTagsToCertificateRequest

	DeleteCertificateRequest(*acm.DeleteCertificateInput) acm.DeleteCertificateRequest

	DescribeCertificateRequest(*acm.DescribeCertificateInput) acm.DescribeCertificateRequest

	ExportCertificateRequest(*acm.ExportCertificateInput) acm.ExportCertificateRequest

	GetCertificateRequest(*acm.GetCertificateInput) acm.GetCertificateRequest

	ImportCertificateRequest(*acm.ImportCertificateInput) acm.ImportCertificateRequest

	ListCertificatesRequest(*acm.ListCertificatesInput) acm.ListCertificatesRequest

	ListTagsForCertificateRequest(*acm.ListTagsForCertificateInput) acm.ListTagsForCertificateRequest

	RemoveTagsFromCertificateRequest(*acm.RemoveTagsFromCertificateInput) acm.RemoveTagsFromCertificateRequest

	RenewCertificateRequest(*acm.RenewCertificateInput) acm.RenewCertificateRequest

	RequestCertificateRequest(*acm.RequestCertificateInput) acm.RequestCertificateRequest

	ResendValidationEmailRequest(*acm.ResendValidationEmailInput) acm.ResendValidationEmailRequest

	UpdateCertificateOptionsRequest(*acm.UpdateCertificateOptionsInput) acm.UpdateCertificateOptionsRequest

	WaitUntilCertificateValidated(context.Context, *acm.DescribeCertificateInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*acm.Client)(nil)
