// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopFleetActionsInput struct {
	_ struct{} `type:"structure"`

	// List of actions to suspend on the fleet.
	//
	// Actions is a required field
	Actions []FleetAction `min:"1" type:"list" required:"true"`

	// Unique identifier for a fleet
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopFleetActionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFleetActionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopFleetActionsInput"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Actions", 1))
	}

	if s.FleetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopFleetActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopFleetActionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopFleetActions = "StopFleetActions"

// StopFleetActionsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Suspends activity on a fleet. Currently, this operation is used to stop a
// fleet's auto-scaling activity. It is used to temporarily stop scaling events
// triggered by the fleet's scaling policies. The policies can be retained and
// auto-scaling activity can be restarted using StartFleetActions. You can view
// a fleet's stopped actions using DescribeFleetAttributes.
//
// To stop fleet actions, specify the fleet ID and the type of actions to suspend.
// When auto-scaling fleet actions are stopped, Amazon GameLift no longer initiates
// scaling events except to maintain the fleet's desired instances setting (FleetCapacity.
// Changes to the fleet's capacity must be done manually using UpdateFleetCapacity.
//
// Learn more
//
//  Working with Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html).
//
// Related operations
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
//
//    // Example sending a request using StopFleetActionsRequest.
//    req := client.StopFleetActionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions
func (c *Client) StopFleetActionsRequest(input *StopFleetActionsInput) StopFleetActionsRequest {
	op := &aws.Operation{
		Name:       opStopFleetActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetActionsInput{}
	}

	req := c.newRequest(op, input, &StopFleetActionsOutput{})
	return StopFleetActionsRequest{Request: req, Input: input, Copy: c.StopFleetActionsRequest}
}

// StopFleetActionsRequest is the request type for the
// StopFleetActions API operation.
type StopFleetActionsRequest struct {
	*aws.Request
	Input *StopFleetActionsInput
	Copy  func(*StopFleetActionsInput) StopFleetActionsRequest
}

// Send marshals and sends the StopFleetActions API request.
func (r StopFleetActionsRequest) Send(ctx context.Context) (*StopFleetActionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopFleetActionsResponse{
		StopFleetActionsOutput: r.Request.Data.(*StopFleetActionsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopFleetActionsResponse is the response type for the
// StopFleetActions API operation.
type StopFleetActionsResponse struct {
	*StopFleetActionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopFleetActions request.
func (r *StopFleetActionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
