// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon SageMaker notebook instance to delete.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNotebookInstanceInput"}

	if s.NotebookInstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNotebookInstance = "DeleteNotebookInstance"

// DeleteNotebookInstanceRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook
// instance, you must call the StopNotebookInstance API.
//
// When you delete a notebook instance, you lose all of your data. Amazon SageMaker
// removes the ML compute instance, and deletes the ML storage volume and the
// network interface associated with the notebook instance.
//
//    // Example sending a request using DeleteNotebookInstanceRequest.
//    req := client.DeleteNotebookInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *Client) DeleteNotebookInstanceRequest(input *DeleteNotebookInstanceInput) DeleteNotebookInstanceRequest {
	op := &aws.Operation{
		Name:       opDeleteNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceInput{}
	}

	req := c.newRequest(op, input, &DeleteNotebookInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteNotebookInstanceRequest{Request: req, Input: input, Copy: c.DeleteNotebookInstanceRequest}
}

// DeleteNotebookInstanceRequest is the request type for the
// DeleteNotebookInstance API operation.
type DeleteNotebookInstanceRequest struct {
	*aws.Request
	Input *DeleteNotebookInstanceInput
	Copy  func(*DeleteNotebookInstanceInput) DeleteNotebookInstanceRequest
}

// Send marshals and sends the DeleteNotebookInstance API request.
func (r DeleteNotebookInstanceRequest) Send(ctx context.Context) (*DeleteNotebookInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNotebookInstanceResponse{
		DeleteNotebookInstanceOutput: r.Request.Data.(*DeleteNotebookInstanceOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNotebookInstanceResponse is the response type for the
// DeleteNotebookInstance API operation.
type DeleteNotebookInstanceResponse struct {
	*DeleteNotebookInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNotebookInstance request.
func (r *DeleteNotebookInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
