// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to obtain more information about a dedicated IP address.
type GetDedicatedIpInput struct {
	_ struct{} `type:"structure"`

	// The IP address that you want to obtain more information about. The value
	// you specify has to be a dedicated IP address that's assocaited with your
	// AWS account.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDedicatedIpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDedicatedIpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDedicatedIpInput"}

	if s.Ip == nil {
		invalidParams.Add(aws.NewErrParamRequired("Ip"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDedicatedIpInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Ip != nil {
		v := *s.Ip

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IP", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a dedicated IP address.
type GetDedicatedIpOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about a dedicated IP address.
	DedicatedIp *DedicatedIp `type:"structure"`
}

// String returns the string representation
func (s GetDedicatedIpOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDedicatedIpOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DedicatedIp != nil {
		v := s.DedicatedIp

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DedicatedIp", v, metadata)
	}
	return nil
}

const opGetDedicatedIp = "GetDedicatedIp"

// GetDedicatedIpRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Get information about a dedicated IP address, including the name of the dedicated
// IP pool that it's associated with, as well information about the automatic
// warm-up process for the address.
//
//    // Example sending a request using GetDedicatedIpRequest.
//    req := client.GetDedicatedIpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp
func (c *Client) GetDedicatedIpRequest(input *GetDedicatedIpInput) GetDedicatedIpRequest {
	op := &aws.Operation{
		Name:       opGetDedicatedIp,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/dedicated-ips/{IP}",
	}

	if input == nil {
		input = &GetDedicatedIpInput{}
	}

	req := c.newRequest(op, input, &GetDedicatedIpOutput{})
	return GetDedicatedIpRequest{Request: req, Input: input, Copy: c.GetDedicatedIpRequest}
}

// GetDedicatedIpRequest is the request type for the
// GetDedicatedIp API operation.
type GetDedicatedIpRequest struct {
	*aws.Request
	Input *GetDedicatedIpInput
	Copy  func(*GetDedicatedIpInput) GetDedicatedIpRequest
}

// Send marshals and sends the GetDedicatedIp API request.
func (r GetDedicatedIpRequest) Send(ctx context.Context) (*GetDedicatedIpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDedicatedIpResponse{
		GetDedicatedIpOutput: r.Request.Data.(*GetDedicatedIpOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDedicatedIpResponse is the response type for the
// GetDedicatedIp API operation.
type GetDedicatedIpResponse struct {
	*GetDedicatedIpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDedicatedIp request.
func (r *GetDedicatedIpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
