package main

// This file is updated via the output from https://sippy.ci.openshift.org/canary?release=$VERSION
var (
	minimal = map[string]struct{}{
		"upgrade": {},
		"operator.Tag the image machine-os-content into the image stream tag stable:machine-os-content":                                              {},
		"operator.Run template e2e-gcp-serial - e2e-gcp-serial container setup":                                                                      {},
		"operator.Run template e2e-gcp - e2e-gcp container setup":                                                                                    {},
		"operator.Run template e2e-azure - e2e-azure container setup":                                                                                {},
		"operator.Run template e2e-aws-disruptive - e2e-aws-disruptive container setup":                                                              {},
		"operator.Run template e2e-aws - e2e-aws container setup":                                                                                    {},
		"operator.Run multi-stage test e2e-vsphere-serial - e2e-vsphere-serial-ipi-install-vsphere-registry container test":                          {},
		"operator.Run multi-stage test e2e-vsphere - e2e-vsphere-ipi-install-vsphere-registry container test":                                        {},
		"operator.Run multi-stage test e2e-vsphere - e2e-vsphere-ipi-install-install container test":                                                 {},
		"operator.Run multi-stage test e2e-ovirt-ovn - e2e-ovirt-ovn-ipi-install-install container test":                                             {},
		"operator.Run multi-stage test e2e-openstack-upgrade - e2e-openstack-upgrade-ipi-install-hosted-loki container test":                         {},
		"operator.Run multi-stage test e2e-openstack-parallel - e2e-openstack-parallel-ipi-install-install container test":                           {},
		"operator.Run multi-stage test e2e-openstack-ovn - e2e-openstack-ovn-ipi-install-install container test":                                     {},
		"operator.Run multi-stage test e2e-openstack-fips - e2e-openstack-fips-ipi-install-install container test":                                   {},
		"operator.Run multi-stage test e2e-metal-single-node-live-iso - e2e-metal-single-node-live-iso-baremetalds-packet-setup container test":      {},
		"operator.Run multi-stage test e2e-metal-ipi-compact - e2e-metal-ipi-compact-baremetalds-packet-teardown container test":                     {},
		"operator.Run multi-stage test e2e-metal-assisted-ipv6 - e2e-metal-assisted-ipv6-baremetalds-packet-setup container test":                    {},
		"operator.Run multi-stage test e2e-gcp-serial - e2e-gcp-serial-ipi-install-install container test":                                           {},
		"operator.Run multi-stage test e2e-gcp-ovn-upgrade - e2e-gcp-ovn-upgrade-ipi-install-install-stableinitial container test":                   {},
		"operator.Run multi-stage test e2e-gcp-ovn - e2e-gcp-ovn-ipi-install-install container test":                                                 {},
		"operator.Run multi-stage test e2e-gcp-fips-serial - e2e-gcp-fips-serial-ipi-install-install container test":                                 {},
		"operator.Run multi-stage test e2e-gcp-fips - e2e-gcp-fips-ipi-install-install container test":                                               {},
		"operator.Run multi-stage test e2e-gcp-compact-upgrade - e2e-gcp-compact-upgrade-ipi-install-install-stableinitial container test":           {},
		"operator.Run multi-stage test e2e-gcp-compact - e2e-gcp-compact-ipi-install-install container test":                                         {},
		"operator.Run multi-stage test e2e-azure-upgrade - e2e-azure-upgrade-ipi-install-install-stableinitial container test":                       {},
		"operator.Run multi-stage test e2e-azure-upgrade - e2e-azure-upgrade-ipi-conf-azure container test":                                          {},
		"operator.Run multi-stage test e2e-azure-serial - e2e-azure-serial-ipi-install-install container test":                                       {},
		"operator.Run multi-stage test e2e-azure-ovn-upgrade - e2e-azure-ovn-upgrade-ipi-install-install-stableinitial container test":               {},
		"operator.Run multi-stage test e2e-azure-ovn - e2e-azure-ovn-ipi-install-install container test":                                             {},
		"operator.Run multi-stage test e2e-azure-fips-serial - e2e-azure-fips-serial-ipi-install-install container test":                             {},
		"operator.Run multi-stage test e2e-azure-fips - e2e-azure-fips-ipi-install-install container test":                                           {},
		"operator.Run multi-stage test e2e-azure-compact-upgrade - e2e-azure-compact-upgrade-ipi-install-install-stableinitial container test":       {},
		"operator.Run multi-stage test e2e-azure-compact-serial - e2e-azure-compact-serial-ipi-install-install container test":                       {},
		"operator.Run multi-stage test e2e-azure-compact - e2e-azure-compact-ipi-install-install container test":                                     {},
		"operator.Run multi-stage test e2e-azure - e2e-azure-ipi-install-install container test":                                                     {},
		"operator.Run multi-stage test e2e-aws-upgrade-paused - e2e-aws-upgrade-paused-ipi-install-install-stableinitial container test":             {},
		"operator.Run multi-stage test e2e-aws-single-node - e2e-aws-single-node-ipi-install-install container test":                                 {},
		"operator.Run multi-stage test e2e-aws-sdn-multitenant - e2e-aws-sdn-multitenant-ipi-install-install container test":                         {},
		"operator.Run multi-stage test e2e-aws-ovn-upgrade-rollback - e2e-aws-ovn-upgrade-rollback-ipi-install-install-stableinitial container test": {},
		"operator.Run multi-stage test e2e-aws-ovn-local-gateway - e2e-aws-ovn-local-gateway-ipi-install-install container test":                     {},
		"operator.Run multi-stage test e2e-aws-ovn - e2e-aws-ovn-ipi-install-install container test":                                                 {},
		"operator.Run multi-stage test e2e-aws-network-stress - e2e-aws-network-stress-ipi-install-install container test":                           {},
		"operator.Run multi-stage test e2e-aws-hypershift - e2e-aws-hypershift-ipi-install-rbac container test":                                      {},
		"operator.Run multi-stage test e2e-aws-fips-serial - e2e-aws-fips-serial-ipi-install-install container test":                                 {},
		"operator.Run multi-stage test e2e-aws-compact-serial - e2e-aws-compact-serial-ipi-install-install container test":                           {},
		"operator.Run multi-stage test e2e-aws-compact - e2e-aws-compact-ipi-install-install container test":                                         {},
		"operator.Run multi-stage test e2e-aws-canary - e2e-aws-canary-ipi-install-install container test":                                           {},
		"operator.Run multi-stage test e2e-aws-calico - e2e-aws-calico-ipi-install-install container test":                                           {},
		"operator.Run multi-stage test e2e-aws-arm64 - e2e-aws-arm64-ipi-install-install container test":                                             {},
		"operator.Find the input image upi-installer and tag it into the pipeline":                                                                   {},
		"operator.Find the input image root and tag it into the pipeline":                                                                            {},
		"operator.Find the input image origin-centos-8 and tag it into the pipeline":                                                                 {},
		"operator.Find the input image openstack-installer and tag it into the pipeline":                                                             {},
		"operator.Find the input image ocp-cli-jq-latest and tag it into the pipeline":                                                               {},
		"operator.Find the input image ocp-4.5-upi-installer and tag it into the pipeline":                                                           {},
		"operator.Find the input image machine-os-content and tag it into the pipeline":                                                              {},
		"operator.Find the input image libvirt-installer and tag it into the pipeline":                                                               {},
		"operator.Find the input image hypershift-hypershift-latest and tag it into the pipeline":                                                    {},
		"operator.Find the input image dev-scripts and tag it into the pipeline":                                                                     {},
		"operator.Find the input image console-tests and tag it into the pipeline":                                                                   {},
		"operator.Find the input image azure-ci-base-latest and tag it into the pipeline":                                                            {},
		"operator.Find the input image assisted-test-infra and tag it into the pipeline":                                                             {},
		"operator.Find the input image assisted-service and tag it into the pipeline":                                                                {},
		"operator.Find the input image assisted-installer-controller and tag it into the pipeline":                                                   {},
		"operator.Find the input image assisted-installer-agent and tag it into the pipeline":                                                        {},
		"operator.Find the input image assisted-installer and tag it into the pipeline":                                                              {},
		"operator.Find the input image ansible and tag it into the pipeline":                                                                         {},
		"operator.Find all of the input images from ocp/none:${component} and tag them into the output image stream":                                 {},
		"operator.Find all of the input images from ocp/4.9:${component} and tag them into the output image stream":                                  {},
		"operator.Find all of the input images from ocp/4.6:${component} and tag them into the output image stream":                                  {},
		"operator.Create the release image \"latest\" containing all images built by this job":                                                       {},
		"operator.Create the release image \"initial\" containing all images built by this job":                                                      {},
		"operator.All images are built and tagged into stable":                                                                                       {},
		"operator install page":                                         {},
		"operator install cloud-controller-manager":                     {},
		"operator conditions  storage":                                  {},
		"operator conditions  service-ca":                               {},
		"operator conditions  page":                                     {},
		"operator conditions  operator-lifecycle-manager-packageserver": {},
		"operator conditions  operator-lifecycle-manager-catalog":       {},
		"operator conditions  operator-lifecycle-manager":               {},
		"operator conditions  openshift-samples":                        {},
		"operator conditions  openshift-controller-manager":             {},
		"operator conditions  node-tuning":                              {},
		"operator conditions  network":                                  {},
		"operator conditions  monitoring":                               {},
		"operator conditions  marketplace":                              {},
		"operator conditions  machine-config":                           {},
		"operator conditions  machine-approver":                         {},
		"operator conditions  machine-api":                              {},
		"operator conditions  kube-storage-version-migrator":            {},
		"operator conditions  kube-scheduler":                           {},
		"operator conditions  kube-apiserver":                           {},
		"operator conditions  insights":                                 {},
		"operator conditions  ingress":                                  {},
		"operator conditions  image-registry":                           {},
		"operator conditions  etcd":                                     {},
		"operator conditions  dns":                                      {},
		"operator conditions  csi-snapshot-controller":                  {},
		"operator conditions  console":                                  {},
		"operator conditions  config-operator":                          {},
		"operator conditions  cluster-autoscaler":                       {},
		"operator conditions  cloud-credential":                         {},
		"operator conditions  cloud-controller-manager":                 {},
		"operator conditions  baremetal":                                {},
		"github.com/openshift/elasticsearch-operator/test/e2e-olm.TestElasticsearchCluster/Invalid_master_count":                                                                                                                                                                                                                                                  {},
		"[sig-storage] [sig-api-machinery] secret-upgrade":                                                                                                                                                                                                                                                                                                        {},
		"[sig-storage] [Serial] Volume metrics should create volume metrics with the correct FilesystemMode PVC ref [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                             {},
		"[sig-storage] [Serial] Volume metrics should create volume metrics with the correct BlockMode PVC ref [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                                  {},
		"[sig-storage] [Serial] Volume metrics should create volume metrics in Volume Manager [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                                                   {},
		"[sig-storage] Secrets should be immutable if `immutable` field is set [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                          {},
		"[sig-storage] Secrets should be consumable from pods in volume with defaultMode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                              {},
		"[sig-storage] Projected configMap should be consumable from pods in volume with defaultMode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-storage] PersistentVolumes-local  Pods sharing a single local PV [Serial] all pods should be running [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                              {},
		"[sig-storage] PersistentVolumes-local  Pod with node different from PV's NodeAffinity should fail scheduling due to different NodeSelector [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] PVC Protection Verify that PVC in active use by a pod is not removed immediately [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                       {},
		"[sig-storage] PV Protection Verify that PV bound to a PVC is not removed immediately [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                 {},
		"[sig-storage] PV Protection Verify \"immediate\" deletion of a PV that is not bound to a PVC [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (immediate binding)] topology should provision a volume and schedule a pod with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (immediate binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (ext3)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (delayed binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with mount options [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Pre-provisioned PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Inline-volume (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (immediate binding)] topology should provision a volume and schedule a pod with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup skips ownership changes to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                         {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: cinder] [Testpattern: Dynamic PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Pre-provisioned PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Pre-provisioned PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (immediate binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: azure-disk] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                     {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Inline-volume (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (delayed binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (block volmode)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                         {},
		"[sig-storage] Ephemeralstorage When pod refers to non-existent ephemeral storage should allow deletion of pod with invalid volume : secret [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] Ephemeralstorage When pod refers to non-existent ephemeral storage should allow deletion of pod with invalid volume : configmap [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-storage] EmptyDir wrapper volumes should not cause race condition when used for configmaps [Serial] [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                         {},
		"[sig-storage] EmptyDir volumes should support (root,0777,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                  {},
		"[sig-storage] EmptyDir volumes pod should support memory backed volumes of specified size [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                            {},
		"[sig-storage] ConfigMap should be immutable if `immutable` field is set [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                        {},
		"[sig-storage] ConfigMap binary data should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                            {},
		"[sig-storage] CSI mock volume CSIStorageCapacity CSIStorageCapacity used, have capacity [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                              {},
		"[sig-storage] CSI mock volume CSIStorageCapacity CSIStorageCapacity unused [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                           {},
		"[sig-storage] CSI mock volume CSIServiceAccountToken token should not be plumbed down when csiServiceAccountTokenEnabled=false [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-storage] CSI mock volume CSIServiceAccountToken token should be plumbed down when csiServiceAccountTokenEnabled=true [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                            {},
		"[sig-storage] CSI mock volume CSI workload information using mock driver should not be passed when podInfoOnMount=nil [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                {},
		"[sig-storage] CSI mock volume CSI workload information using mock driver should be passed when podInfoOnMount=true [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] CSI mock volume CSI online volume expansion should expand volume without restarting pod if attach=on, nodeExpansion=on [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] CSI mock volume CSI online volume expansion should expand volume without restarting pod if attach=off, nodeExpansion=on [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                {},
		"[sig-storage] CSI mock volume CSI attach test using mock driver should require VolumeAttach for drivers with attachment [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                              {},
		"[sig-storage] CSI mock volume CSI Volume expansion should expand volume by restarting pod if attach=on, nodeExpansion=on [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                             {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should support two pods which share the same volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                   {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should support multiple inline ephemeral volumes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                      {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should create read/write inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic Snapshot (retain policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion [Suite:openshift/conformance/parallel] [Suite:k8s]":                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic Snapshot (delete policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion [Suite:openshift/conformance/parallel] [Suite:k8s]":                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                       {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                     {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                      {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                    {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                         {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)] provisioning should provision storage with pvc data source [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                               {},
		"[sig-scheduling] SchedulerPriorities [Serial] PodTopologySpread Scoring validates pod should be preferably scheduled to node which makes the matching pods more evenly distributed [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                     {},
		"[sig-scheduling] SchedulerPriorities [Serial] Pod should avoid nodes that have avoidPod annotation [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                                     {},
		"[sig-scheduling] SchedulerPreemption [Serial] validates lower priority pod preemption by critical pod [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                            {},
		"[sig-scheduling] SchedulerPreemption [Serial] validates basic preemption works [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                                                   {},
		"[sig-scheduling] SchedulerPreemption [Serial] PriorityClass endpoints verify PriorityClass endpoints can be operated with different HTTP methods [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                 {},
		"[sig-scheduling] SchedulerPreemption [Serial] PreemptionExecutionPath runs ReplicaSets to verify preemption running path [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                         {},
		"[sig-scheduling] SchedulerPreemption [Serial] PodTopologySpread Preemption validates proper pods are preempted [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                         {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that there is no conflict between pods with same hostPort but different hostIP and protocol [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that taints-tolerations is respected if not matching [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                           {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that taints-tolerations is respected if matching [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                               {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that NodeSelector is respected if not matching  [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                          {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that NodeSelector is respected if matching  [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                              {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that NodeAffinity is respected if not matching [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                                 {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates resource limits of pods that are allowed to run  [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                         {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates pod overhead is considered along with resource limits of pods that are allowed to run verify pod overhead is accounted for [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                     {},
		"[sig-scheduling] SchedulerPredicates [Serial] PodTopologySpread Filtering validates 4 pods with MaxSkew=1 are evenly distributed into 2 nodes [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                          {},
		"[sig-scheduling] LimitRange should create a LimitRange with defaults and ensure pod has those defaults applied. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                {},
		"[sig-operator] OLM should be installed with subscriptions at version v1alpha1 [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                    {},
		"[sig-operator] OLM should be installed with packagemanifests at version v1 [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                       {},
		"[sig-operator] OLM should be installed with catalogsources at version v1alpha1 [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                   {},
		"[sig-operator] OLM should Implement packages API server and list packagemanifest info with namespace not NULL [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                    {},
		"[sig-node] pods should not fail on systemd timeouts":     {},
		"[sig-node] pods should never transition back to pending": {},
		"[sig-node] kubelet terminates kube-apiserver gracefully": {},
		"[sig-node] kubelet Clean up pods on node kubelet should be able to delete 10 pods per node in 1m0s. [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                     {},
		"[sig-node] Sysctls [LinuxOnly] [NodeFeature:Sysctls] should not launch unsafe, but not explicitly enabled sysctls on the node [MinimumKubeletVersion:1.21] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                     {},
		"[sig-node] Security Context when creating containers with AllowPrivilegeEscalation should allow privilege escalation when not explicitly set and uid != 0 [LinuxOnly] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-node] Security Context should support seccomp unconfined on the container [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                     {},
		"[sig-node] Secrets should fail to create secret due to empty secret key [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                  {},
		"[sig-node] RuntimeClass  should support RuntimeClasses API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-node] Probing container should be restarted with a exec \"cat /tmp/health\" liveness probe [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                        {},
		"[sig-node] Pods should delete a collection of pods [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                       {},
		"[sig-node] Pods Extended Pods Set QOS Class should be set on Pods with matching resource requests and limits for memory and cpu [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                          {},
		"[sig-node] PodTemplates should run the lifecycle of PodTemplates [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                         {},
		"[sig-node] PodTemplates should delete a collection of pod templates [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                      {},
		"[sig-node] NodeLease when the NodeLease feature is enabled the kubelet should report node status infrequently [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-node] NodeLease when the NodeLease feature is enabled the kubelet should create and update a lease in the kube-node-lease namespace [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-node] NoExecuteTaintManager Single Pod [Serial] evicts pods from tainted nodes [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                              {},
		"[sig-node] NoExecuteTaintManager Single Pod [Serial] eventually evict pod with finite tolerations from tainted nodes [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                             {},
		"[sig-node] NoExecuteTaintManager Single Pod [Serial] doesn't evict pod with tolerations from tainted nodes [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                       {},
		"[sig-node] NoExecuteTaintManager Multiple Pods [Serial] only evicts pods without tolerations from tainted nodes [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                  {},
		"[sig-node] Lease lease API should be available [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                           {},
		"[sig-node] Kubelet when scheduling a busybox command that always fails in a pod should be possible to delete [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                           {},
		"[sig-node] Downward API should provide host IP and pod IP as an env var if pod uses host network [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                   {},
		"[sig-node] ConfigMap should update ConfigMap successfully [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                      {},
		"[sig-node] ConfigMap should run through a ConfigMap lifecycle [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                            {},
		"[sig-network][endpoints] admission TestEndpointAdmission [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                   {},
		"[sig-network][Feature:Router] The HAProxy router should serve routes that were created from an ingress [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                              {},
		"[sig-network] services when using a plugin that does not isolate namespaces by default should allow connections to pods in different namespaces on the same node via service IPs [Suite:openshift/conformance/parallel]":                                                                                                           {},
		"[sig-network] services when using a plugin that does not isolate namespaces by default should allow connections to pods in different namespaces on different nodes via service IPs [Suite:openshift/conformance/parallel]":                                                                                                         {},
		"[sig-network] pods should successfully create sandboxes by writing child":                                                                                                                                                                                                                                                          {},
		"[sig-network] pods should successfully create sandboxes by reading container":                                                                                                                                                                                                                                                      {},
		"[sig-network] network isolation when using a plugin that does not isolate namespaces by default should allow communication between pods in different namespaces on the same node [Suite:openshift/conformance/parallel]":                                                                                                           {},
		"[sig-network] network isolation when using a plugin that does not isolate namespaces by default should allow communication between pods in different namespaces on different nodes [Suite:openshift/conformance/parallel]":                                                                                                         {},
		"[sig-network] multicast when using one of the plugins 'redhat/openshift-ovs-multitenant, redhat/openshift-ovs-networkpolicy' should block multicast traffic in namespaces where it is disabled [Suite:openshift/conformance/parallel]":                                                                                             {},
		"[sig-network] multicast when using one of the plugins 'redhat/openshift-ovs-multitenant, redhat/openshift-ovs-networkpolicy' should allow multicast traffic in namespaces where it is enabled [Suite:openshift/conformance/parallel]":                                                                                              {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should have ipv4 and ipv6 internal node ip [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create service with ipv6,v4 cluster ip [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create service with ipv6 cluster ip [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create service with ipv4,v6 cluster ip [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create service with ipv4 cluster ip [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create pod, add ipv6 and ipv4 ip to pod ips [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should create a single stack service with cluster ip from primary service range [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                      {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] should be able to reach pod on ipv4 and ipv6 ip [Feature:IPv6DualStack] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                      {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should update endpoints: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should update endpoints: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for service endpoints using hostNetwork [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for pod-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                           {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for pod-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for node-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for node-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for endpoint-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                      {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should function for endpoint-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should be able to handle large requests: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                   {},
		"[sig-network] [Feature:IPv6DualStack] [LinuxOnly] Granular Checks: Services Secondary IP Family should be able to handle large requests: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-network] Services should test the lifecycle of an Endpoint [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                          {},
		"[sig-network] Services should provide secure master service  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                             {},
		"[sig-network] Services should prevent NodePort collisions [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                      {},
		"[sig-network] Services should have session affinity work for NodePort service [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                {},
		"[sig-network] Services should have session affinity timeout work for NodePort service [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-network] Services should find a service from listing all namespaces [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                 {},
		"[sig-network] Services should complete a service status lifecycle [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-network] Services should check NodePort out-of-range [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                      {},
		"[sig-network] Services should be able to switch session affinity for service with type clusterIP [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                             {},
		"[sig-network] Services should be able to switch session affinity for NodePort service [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-network] Service endpoints latency should not be very high  [Conformance] [Serial] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                                                                                  {},
		"[sig-network] Proxy version v1 should proxy logs on node with explicit kubelet port using proxy subresource  [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                   {},
		"[sig-network] Proxy version v1 should proxy logs on node using proxy subresource  [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                              {},
		"[sig-network] Networking should provide Internet connection for containers [Feature:Networking-IPv4] [Skipped:azure] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-network] Networking should provide Internet connection for containers [Feature:Networking-IPv4] [Skipped:Disconnected] [Skipped:azure] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-network] Networking Granular Checks: Services should function for client IP based session affinity: udp [LinuxOnly] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                       {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should allow ingress access on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]":                {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should allow ingress access from namespace on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should allow egress access on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]":                 {},
		"[sig-network] NetworkPolicy API should support creating NetworkPolicy API operations [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                           {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should allow ingress access on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]":                       {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should allow ingress access from namespace on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]":        {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should allow egress access on one named port [Feature:NetworkPolicy] [Skipped:Network/OVNKubernetes] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]":                        {},
		"[sig-network] Netpol API should support creating NetworkPolicy API operations [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                  {},
		"[sig-network] IngressClass [Feature:Ingress] should prevent Ingress creation if more than 1 IngressClass marked as default [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                              {},
		"[sig-network] IngressClass [Feature:Ingress] should not set default value if no default IngressClass [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                    {},
		"[sig-network] IngressClass API  should support creating IngressClass API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-network] Ingress API should support creating Ingress API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                 {},
		"[sig-network] EndpointSliceMirroring should mirror a custom Endpoints resource through create update and delete [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                          {},
		"[sig-network] EndpointSlice should support creating EndpointSlice API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                         {},
		"[sig-network] EndpointSlice should create and delete Endpoints and EndpointSlices for a Service with a selector specified [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                {},
		"[sig-network] DNS should provide DNS for the cluster [Provider:GCE] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                            {},
		"[sig-network] DNS should provide DNS for ExternalName services [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                           {},
		"[sig-instrumentation] Prometheus metrics should be available after an upgrade":                                                                                                                                                                                                                                                     {},
		"[sig-instrumentation] Events should ensure that an event can be fetched, patched, deleted, and listed [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-instrumentation] Events should delete a collection of events [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-instrumentation] Events API should ensure that an event can be fetched, patched, deleted, and listed [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                {},
		"[sig-instrumentation] Events API should delete a collection of events [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream admission TestImageStreamTagsAdmission [Suite:openshift/conformance/serial]":                                                                                                                                                                                        {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream admission TestImageStreamAdmitStatusUpdate [Suite:openshift/conformance/serial]":                                                                                                                                                                                    {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream admission TestImageStreamAdmitSpecUpdate [Suite:openshift/conformance/serial]":                                                                                                                                                                                      {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream API TestImageStreamWithoutDockerImageConfig [Suite:openshift/conformance/serial]":                                                                                                                                                                                   {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream API TestImageStreamTagLifecycleHook [Suite:openshift/conformance/serial]":                                                                                                                                                                                           {},
		"[sig-imageregistry][Feature:ImageTriggers][Serial] ImageStream API TestImageStreamMappingCreate [Suite:openshift/conformance/serial]":                                                                                                                                                                                              {},
		"[sig-imageregistry] Image registry remain available": {},
		"[sig-devex] check registry.redhat.io is available and samples operator can import sample imagestreams run sample related validations [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                      {},
		"[sig-cluster-lifecycle][Feature:Machines] Managed cluster should have machine resources [Suite:openshift/conformance/parallel]":                                                                                                          {},
		"[sig-cluster-lifecycle] cluster upgrade should complete in 90.00 minutes":                                                                                                                                                                {},
		"[sig-cluster-lifecycle] cluster upgrade should complete in 75m (105m on AWS)":                                                                                                                                                            {},
		"[sig-cluster-lifecycle] cluster upgrade should complete in 210.00 minutes":                                                                                                                                                               {},
		"[sig-cli] oc observe works as expected [Suite:openshift/conformance/parallel]":                                                                                                                                                           {},
		"[sig-cli] oc debug ensure it works with image streams [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                     {},
		"[sig-cli] Kubectl client Proxy server should support proxy with --port 0  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-cli] Kubectl client Proxy server should support --unix-socket=/path  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-cli] Kubectl client Kubectl version should check is all data is printed  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                  {},
		"[sig-cli] Kubectl client Kubectl taint [Serial] should update the taint on a node [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                      {},
		"[sig-cli] Kubectl client Kubectl taint [Serial] should remove all the taints with the same key off a node [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial] [Suite:k8s]":                                              {},
		"[sig-cli] Kubectl client Kubectl run pod should create a pod from an image when restart is Never  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                              {},
		"[sig-cli] Kubectl client Kubectl patch should add annotations for pods in rc  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                  {},
		"[sig-cli] Kubectl client Kubectl get componentstatuses should get componentstatuses [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                  {},
		"[sig-cli] Kubectl client Kubectl diff should check if kubectl diff finds a difference for Deployments [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                          {},
		"[sig-cli] Kubectl client Kubectl create quota should create a quota without scopes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                   {},
		"[sig-cli] Kubectl client Kubectl create quota should create a quota with scopes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                      {},
		"[sig-cli] Kubectl client Kubectl cluster-info should check if Kubernetes control plane services is included in cluster-info  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                   {},
		"[sig-cli] Kubectl client Kubectl client-side validation should create/apply a valid CR with arbitrary-extra properties for CRD with partially-specified validation schema [Suite:openshift/conformance/parallel] [Suite:k8s]":            {},
		"[sig-cli] Kubectl client Kubectl apply should apply a new configuration to an existing RC [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                            {},
		"[sig-cli] Kubectl client Kubectl api-versions should check if v1 is in available api versions  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                 {},
		"[sig-auth] [Feature:NodeAuthorizer] Getting an existing secret should exit with the Forbidden error [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                               {},
		"[sig-auth] [Feature:NodeAuthorizer] Getting an existing configmap should exit with the Forbidden error [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-auth] [Feature:NodeAuthorizer] Getting a secret for a workload the node has access to should succeed [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                         {},
		"[sig-auth] [Feature:NodeAuthorizer] Getting a non-existent configmap should exit with the Forbidden error, not a NotFound error [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                   {},
		"[sig-auth] ServiceAccounts should run through the lifecycle of a ServiceAccount [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                {},
		"[sig-auth] ServiceAccounts should guarantee kube-root-ca.crt exist in any namespace [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                            {},
		"[sig-auth] Certificates API [Privileged:ClusterAdmin] should support building a client with a CSR [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                    {},
		"[sig-auth] Certificates API [Privileged:ClusterAdmin] should support CSR API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                        {},
		"[sig-architecture] platform pods should not fail to start":                                                                                                                                                                               {},
		"[sig-architecture] platform pods should not exit more than once with a non-zero exit code":                                                                                                                                               {},
		"[sig-architecture] platform pods should not be force deleted with gracePeriod 0":                                                                                                                                                         {},
		"[sig-arch] ocp payload should be based on existing source OLM version should contain the source commit id [Suite:openshift/conformance/parallel]":                                                                                        {},
		"[sig-arch] Managed cluster should only include cluster daemonsets that have maxUnavailable update of 10 or 33 percent [Suite:openshift/conformance/parallel]":                                                                            {},
		"[sig-arch] Managed cluster should have operators on the cluster version [Suite:openshift/conformance/parallel]":                                                                                                                          {},
		"[sig-arch] Managed cluster should ensure pods use downstream images from our release image with proper ImagePullPolicy [Suite:openshift/conformance/parallel]":                                                                           {},
		"[sig-arch] ClusterOperators should define at least one related object that is not a namespace [Suite:openshift/conformance/parallel]":                                                                                                    {},
		"[sig-arch] ClusterOperators should define at least one namespace in their lists of related objects [Suite:openshift/conformance/parallel]":                                                                                               {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with multiple image change triggers should run a successful deployment with a trigger used by different containers [Skipped:Disconnected] [Suite:openshift/conformance/parallel]": {},
		"[sig-apps] replicaset-upgrade": {},
		"[sig-apps] job-upgrade":        {},
		"[sig-apps] daemonset-upgrade":  {},
		"[sig-apps] ReplicationController should surface a failure condition on a common issue like exceeded quota [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                             {},
		"[sig-apps] ReplicationController should serve a basic image on each replica with a public image  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-apps] ReplicationController should serve a basic image on each replica with a private image [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-apps] ReplicationController should release no longer matching pods [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                               {},
		"[sig-apps] ReplicaSet should surface a failure condition on a common issue like exceeded quota [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                              {},
		"[sig-apps] Job should fail when exceeds active deadline [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                     {},
		"[sig-apps] DisruptionController should observe PodDisruptionBudget status updated [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                     {},
		"[sig-apps] DisruptionController should create a PodDisruptionBudget [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                   {},
		"[sig-apps] DisruptionController evictions: too few pods, replicaSet, percentage => should not allow an eviction [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                      {},
		"[sig-apps] DisruptionController evictions: maxUnavailable deny evictions, integer => should not allow an eviction [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                    {},
		"[sig-apps] DisruptionController Listing PodDisruptionBudgets for all namespaces should list and delete a collection of PodDisruptionBudgets [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                           {},
		"[sig-apps] Daemon set [Serial] should update pod when spec was updated and update strategy is RollingUpdate [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                             {},
		"[sig-apps] Daemon set [Serial] should run and stop simple daemon [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-apps] Daemon set [Serial] should run and stop complex daemon with node affinity [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                          {},
		"[sig-apps] Daemon set [Serial] should run and stop complex daemon [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                       {},
		"[sig-apps] Daemon set [Serial] should rollback without unnecessary restarts [Conformance] [Skipped:SingleReplicaTopology] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                             {},
		"[sig-apps] Daemon set [Serial] should retry creating failed daemon pods [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                 {},
		"[sig-apps] Daemon set [Serial] should not update pod when spec was updated and update strategy is OnDelete [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                    {},
		"[sig-apps] CronJob should support CronJob API operations [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                              {},
		"[sig-apps] CronJob should schedule multiple jobs concurrently [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                         {},
		"[sig-apps] CronJob should replace jobs when ReplaceConcurrent [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                         {},
		"[sig-apps] CronJob should remove from active list jobs that have been deleted [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-apps] CronJob should be able to schedule after more than 100 missed schedule [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for user.openshift.io/v1, Resource=users [Suite:openshift/conformance/parallel]":                                                                                                     {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for user.openshift.io/v1, Resource=identities [Suite:openshift/conformance/parallel]":                                                                                                {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for user.openshift.io/v1, Resource=groups [Suite:openshift/conformance/parallel]":                                                                                                    {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for template.openshift.io/v1, Resource=brokertemplateinstances [Suite:openshift/conformance/parallel]":                                                                               {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for oauth.openshift.io/v1, Resource=oauthclients [Suite:openshift/conformance/parallel]":                                                                                             {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for oauth.openshift.io/v1, Resource=oauthaccesstokens [Suite:openshift/conformance/parallel]":                                                                                        {},
		"[sig-api-machinery] server version should find the server version [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                     {},
		"[sig-api-machinery] openshift-apiserver-reused-connection should be available":                                                                                                                                                                                  {},
		"[sig-api-machinery] openshift-apiserver-new-connection should be available":                                                                                                                                                                                     {},
		"[sig-api-machinery] oauth-apiserver-reused-connection should be available":                                                                                                                                                                                      {},
		"[sig-api-machinery] oauth-apiserver-new-connection should be available":                                                                                                                                                                                         {},
		"[sig-api-machinery] kube-apiserver-reused-connection should be available":                                                                                                                                                                                       {},
		"[sig-api-machinery] kube-apiserver-new-connection should be available":                                                                                                                                                                                          {},
		"[sig-api-machinery] kube-apiserver terminates within graceful termination period":                                                                                                                                                                               {},
		"[sig-api-machinery] client-go should negotiate watch and report errors with accept \"application/vnd.kubernetes.protobuf,application/json\" [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                 {},
		"[sig-api-machinery] client-go should negotiate watch and report errors with accept \"application/vnd.kubernetes.protobuf\" [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                  {},
		"[sig-api-machinery] client-go should negotiate watch and report errors with accept \"application/json,application/vnd.kubernetes.protobuf\" [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                 {},
		"[sig-api-machinery] client-go should negotiate watch and report errors with accept \"application/json\" [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                     {},
		"[sig-api-machinery] Watchers should observe an object deletion if it stops meeting the requirements of the selector [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                   {},
		"[sig-api-machinery] Watchers should be able to start watching from a specific resource version [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                        {},
		"[sig-api-machinery] Watchers should be able to restart watching from the last resource version observed by the previous watch [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                         {},
		"[sig-api-machinery] Servers with support for Table transformation should return generic metadata details across all namespaces for nodes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                    {},
		"[sig-api-machinery] Servers with support for Table transformation should return chunks of table results for list calls [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-api-machinery] Servers with support for Table transformation should return a 406 for a backend which does not implement metadata [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                 {},
		"[sig-api-machinery] Servers with support for API chunking should return chunks of results for list calls [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                    {},
		"[sig-api-machinery] ServerSideApply should work for subresources [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                            {},
		"[sig-api-machinery] ServerSideApply should work for CRDs [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-api-machinery] ServerSideApply should not remove a field if an owner unsets the field but other managers still have ownership of the field [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-api-machinery] ServerSideApply should ignore conflict errors if force apply is used [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                    {},
		"[sig-api-machinery] ServerSideApply should give up ownership of a field if forced applied by a controller [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                   {},
		"[sig-api-machinery] ServerSideApply should create an applied object if it does not already exist [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-api-machinery] Server request timeout the request should be served with a default timeout if the specified timeout in the request URL exceeds maximum allowed [Suite:openshift/conformance/parallel] [Suite:k8s]":                                          {},
		"[sig-api-machinery] Server request timeout should return HTTP status code 400 if the user specifies an invalid timeout in the request URL [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                   {},
		"[sig-api-machinery] ResourceQuota should verify ResourceQuota with terminating scopes. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and ensure its status is promptly calculated. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                         {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a service. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                    {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a replication controller. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                     {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a pod. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                        {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a persistent volume claim with a storage class [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                      {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a persistent volume claim [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                           {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a custom resource. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                  {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a configMap. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                  {},
		"[sig-api-machinery] ResourceQuota should be able to update and delete ResourceQuota. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                  {},
		"[sig-api-machinery] ResourceQuota [Feature:ScopeSelectors] should verify ResourceQuota with terminating scopes through scope selectors. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                     {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (quota set to pod count: 1) against a pod with same priority class. [Suite:openshift/conformance/parallel] [Suite:k8s]":                              {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (quota set to pod count: 1) against a pod with different priority class (ScopeSelectorOpNotIn). [Suite:openshift/conformance/parallel] [Suite:k8s]":  {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (quota set to pod count: 1) against a pod with different priority class (ScopeSelectorOpExists). [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (quota set to pod count: 1) against 2 pods with same priority class. [Suite:openshift/conformance/parallel] [Suite:k8s]":                             {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (quota set to pod count: 1) against 2 pods with different priority class. [Suite:openshift/conformance/parallel] [Suite:k8s]":                        {},
		"[sig-api-machinery] Namespaces [Serial] should patch a Namespace [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-api-machinery] Namespaces [Serial] should ensure that all services are removed when a namespace is deleted [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                         {},
		"[sig-api-machinery] Namespaces [Serial] should ensure that all pods are removed when a namespace is deleted [Conformance] [Suite:openshift/conformance/serial/minimal] [Suite:k8s]":                                                                             {},
		"[sig-api-machinery] Namespaces [Serial] should delete fast enough (90 percent of 100 namespaces in 150 seconds) [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                               {},
		"[sig-api-machinery] Namespaces [Serial] should always delete fast (ALL of 100 namespaces in 150 seconds) [Feature:ComprehensiveNamespaceDraining] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                             {},
		"[sig-api-machinery] Generated clientset should create v1beta1 cronJobs, delete cronJobs, watch cronJobs [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                     {},
		"[sig-api-machinery] Garbage collector should orphan pods created by rc if deleteOptions.OrphanDependents is nil [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-api-machinery] Garbage collector should orphan pods created by rc if delete options say so [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                       {},
		"[sig-api-machinery] Garbage collector should orphan RS created by deployment when deleteOptions.PropagationPolicy is Orphan [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                           {},
		"[sig-api-machinery] Garbage collector should not delete dependents that have both valid owner and owner that's waiting for dependents to be deleted [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                   {},
		"[sig-api-machinery] Garbage collector should not be blocked by dependency circle [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                      {},
		"[sig-api-machinery] Garbage collector should keep the rc around until all its pods are deleted if the deleteOptions says so [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                           {},
		"[sig-api-machinery] Garbage collector should delete RS created by deployment when not orphaning [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                       {},
		"[sig-api-machinery] CustomResourceDefinition resources [Privileged:ClusterAdmin] should include custom resource definition resources in discovery documents [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                           {},
		"[sig-api-machinery] CustomResourceDefinition resources [Privileged:ClusterAdmin] Simple CustomResourceDefinition listing custom resource definition objects works  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                    {},
		"[sig-api-machinery] CustomResourceDefinition Watch [Privileged:ClusterAdmin] CustomResourceDefinition Watch watch on custom resource definition objects [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                               {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should not be able to mutate or prevent deletion of webhook configuration objects [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                      {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage redhat users with other IDP and no group":                                                                                                   {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage redhat users with other IDP and RH group":                                                                                                   {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage redhat users with SRE IDP and no group":                                                                                                     {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage redhat users with SRE IDP and RH group":                                                                                                     {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage customer users with other IDP and no group":                                                                                                 {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage customer users with other IDP and RH group":                                                                                                 {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage customer users with SRE IDP and no group":                                                                                                   {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook system:admin can manage customer users with SRE IDP and RH group":                                                                                                   {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins cannot create/update protected redhat users with other IDP and RH group":                                                                     {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins cannot create/update protected redhat users with SRE IDP and no group":                                                                       {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins can manage protected redhat users with SRE IDP and RH group":                                                                                 {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins can manage non-protected redhat users with other IDP and no group":                                                                           {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins can manage customer users with other IDP and no group":                                                                                       {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins can delete protected redhat users with other IDP and RH group":                                                                               {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook osd-sre-cluster-admins can delete protected redhat users with SRE IDP and no group":                                                                                 {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated-admins cannot delete protected redhat users with other IDP and RH group":                                                                                  {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated-admins cannot delete protected redhat users with SRE IDP and no group":                                                                                    {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins cannot manage redhat users with other IDP and no group":                                                                                            {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins cannot manage redhat users with other IDP and RH group":                                                                                            {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins cannot manage redhat users with SRE IDP and no group":                                                                                              {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins cannot manage redhat users with SRE IDP and RH group":                                                                                              {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins can manage customer users with other IdP and no group":                                                                                             {},
		"[install] [Suite: service-definition] [OSD] user validating webhook user validating webhook dedicated admins can manage customer users with other IdP and customer group":                                                                                       {},
		"[install] [Suite: service-definition] [OSD] regularuser validating webhook regularuser validating webhook Privledged users allowed to create autoscalers and delete clusterversion objects":                                                                     {},
		"[install] [Suite: service-definition] [OSD] Privileged Containers Privileged containers are not allowed privileged container should not get created":                                                                                                            {},
		"[install] [Suite: service-definition] [OSD] NodeLabels Modifying nodeLabels is not allowed node-label cannot be added":                                                                                                                                          {},
		"[install] [Suite: service-definition] [OSD] DaemonSets DaemonSets are not allowed worker node daemonset should get created":                                                                                                                                     {},
		"[install] [Suite: service-definition] [OSD] DaemonSets DaemonSets are not allowed infra node daemonset should get created":                                                                                                                                      {},
		"[install] [Suite: service-definition] [OSD] DaemonSets DaemonSets are not allowed empty node-label daemonset should get created":                                                                                                                                {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator splunkforwarders admin should be able to manage SplunkForwarders CR":                                                                                                                               {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator deployment should have all desired replicas ready":                                                                                                                                                 {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator deployment should exist":                                                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator configmaps should exist":                                                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator clusterServiceVersion openshift-splunk-forwarder-operator/splunk-forwarder-operator should be present and in succeeded state":                                                                      {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator clusterRoles should exist":                                                                                                                                                                         {},
		"[install] [Suite: operators] [OSD] Splunk Forwarder Operator clusterRoleBindings should exist":                                                                                                                                                                  {},
		"[install] [Suite: operators] [OSD] RBAC Operator deployment should have all desired replicas ready":                                                                                                                                                             {},
		"[install] [Suite: operators] [OSD] RBAC Operator deployment should exist":                                                                                                                                                                                       {},
		"[install] [Suite: operators] [OSD] RBAC Operator configmaps should exist":                                                                                                                                                                                       {},
		"[install] [Suite: operators] [OSD] RBAC Operator clusterServiceVersion openshift-rbac-permissions/rbac-permissions-operator should be present and in succeeded state":                                                                                           {},
		"[install] [Suite: operators] [OSD] RBAC Operator clusterRoles should exist":                                                                                                                                                                                     {},
		"[install] [Suite: operators] [OSD] RBAC Dedicated Admins SubjectPermission SubjectPermission should have the expected ClusterRoles, ClusterRoleBindings and RoleBindinsg":                                                                                       {},
		"[install] [Suite: operators] [OSD] Prune jobs pruner jobs should works deployments-pruner should run successfully":                                                                                                                                              {},
		"[install] [Suite: operators] [OSD] Prune jobs pruner jobs should works builds-pruner should run successfully":                                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] OSD Metrics Exporter Basic Test service should exist":                                                                                                                                                                        {},
		"[install] [Suite: operators] [OSD] OSD Metrics Exporter Basic Test deployment should have all desired replicas ready":                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] OSD Metrics Exporter Basic Test clusterRoles should exist":                                                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] OSD Metrics Exporter Basic Test clusterRoleBindings should exist":                                                                                                                                                            {},
		"[install] [Suite: operators] [OSD] Must Gather Operator deployment should have all desired replicas ready":                                                                                                                                                      {},
		"[install] [Suite: operators] [OSD] Must Gather Operator deployment should exist":                                                                                                                                                                                {},
		"[install] [Suite: operators] [OSD] Must Gather Operator configmaps should exist":                                                                                                                                                                                {},
		"[install] [Suite: operators] [OSD] Must Gather Operator clusterServiceVersion openshift-must-gather-operator/must-gather-operator should be present and in succeeded state":                                                                                     {},
		"[install] [Suite: operators] [OSD] Must Gather Operator clusterRoles should exist":                                                                                                                                                                              {},
		"[install] [Suite: operators] [OSD] Must Gather Operator as Members of osd-devaccess can manage MustGather CRs in openshift-must-gather-operator namespace":                                                                                                      {},
		"[install] [Suite: operators] [OSD] Must Gather Operator as Members of SRE can manage MustGather CRs in openshift-must-gather-operator namespace":                                                                                                                {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit VolumeSnapshotLocations":                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit ServerStatusRequests":                                                                                                                                      {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit Schedules":                                                                                                                                                 {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit RestricRepository":                                                                                                                                         {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit Restore":                                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit PodVolumeRestores":                                                                                                                                         {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit PodVolumeBackups":                                                                                                                                          {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit DownloadRequests":                                                                                                                                          {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit DeleteBackupRequests":                                                                                                                                      {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit Backups":                                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator velero Access should be forbidden to edit BackupStorageLocations":                                                                                                                                    {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator roles should exist":                                                                                                                                                                                  {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator roleBindings should exist":                                                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator deployment should exist":                                                                                                                                                                             {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator configmaps should exist":                                                                                                                                                                             {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator clusterRoles should exist":                                                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] Managed Velero Operator clusterRoleBindings should exist":                                                                                                                                                                    {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator serviceAccounts should exist":                                                                                                                                                                {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator roles with prefix should exist":                                                                                                                                                              {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator deployment should have all desired replicas ready":                                                                                                                                           {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator deployment should exist":                                                                                                                                                                     {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator configmaps should exist":                                                                                                                                                                     {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator clusterServiceVersion openshift-monitoring/configure-alertmanager-operator should be present and in succeeded state":                                                                         {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator clusterRoles should exist":                                                                                                                                                                   {},
		"[install] [Suite: operators] [OSD] Configure AlertManager Operator clusterRoleBindings should exist":                                                                                                                                                            {},
		"[install] [Suite: operators] [OSD] Certman Operator certificate secret should be applied when cluster installed certificate secret should be applied to apiserver object":                                                                                       {},
		"[install] [Suite: operators] [OSD] Certman Operator certificate secret should be applied when cluster installed certificate secret exist under openshift-config namespace":                                                                                      {},
		"[install] [Suite: operators] CloudIngressOperator rh-api-test hostname should resolve":                                                                                                                                                                          {},
		"[install] [Suite: operators] CloudIngressOperator rh-api-test cidr block changes should updated the service":                                                                                                                                                    {},
		"[install] [Suite: operators] CloudIngressOperator publishingstrategies dedicated admin should not be allowed to manage publishingstrategies CR":                                                                                                                 {},
		"[install] [Suite: operators] CloudIngressOperator publishingstrategies cluster admin should be allowed to manage publishingstrategies CR":                                                                                                                       {},
		"[install] [Suite: operators] CloudIngressOperator deployment should have all desired replicas ready":                                                                                                                                                            {},
		"[install] [Suite: operators] CloudIngressOperator deployment should exist":                                                                                                                                                                                      {},
		"[install] [Suite: operators] CloudIngressOperator apischeme dedicated admin should not be allowed to manage apischemes CR":                                                                                                                                      {},
		"[install] [Suite: operators] CloudIngressOperator apischeme cluster admin should be allowed to manage apischemes CR":                                                                                                                                            {},
		"[install] [Suite: operators] CloudIngressOperator apischeme apischemes CR instance must be present on cluster":                                                                                                                                                  {},
		"[install] [Suite: operators] AlertmanagerInhibitions should exist":                                                                                                                                                                                              {},
		"[install] [Suite: operators] AlertmanagerInhibitions inhibits ClusterOperatorDegraded":                                                                                                                                                                          {},
		"[install] [Suite: e2e] [OSD] namespace validating webhook namespace validating webhook dedicated admins cannot manage privileged namespaces":                                                                                                                    {},
		"[install] [Suite: e2e] [OSD] namespace validating webhook namespace validating webhook Privileged users can manage all namespaces":                                                                                                                              {},
		"[install] [Suite: e2e] [OSD] namespace validating webhook namespace validating webhook Non-privileged users cannot manage privileged namespaces":                                                                                                                {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook system:admin can manage redhat user identity":                                                                                                                              {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook system:admin can manage customer user identity":                                                                                                                            {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook random authenticated user cannot manage redhat user identity":                                                                                                              {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook random authenticated user cannot manage customer user identity":                                                                                                            {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook osd-sre-cluster-admins can manage redhat user identity":                                                                                                                    {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook osd-sre-cluster-admins can manage customer user identity":                                                                                                                  {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook osd-sre-admins cannot manage redhat user identity":                                                                                                                         {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook osd-sre-admins cannot manage customer user identity":                                                                                                                       {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook oauth service account can manage redhat user identity":                                                                                                                     {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook oauth service account can manage customer user identity":                                                                                                                   {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook dedicated admins cannot manage redhat user identity":                                                                                                                       {},
		"[install] [Suite: e2e] [OSD] identity validating webhook identity validating webhook dedicated admins can manage customer user identity":                                                                                                                        {},
		"[install] [Suite: e2e] [OSD] RBAC Dedicated Admins SCC permissions scc-test new SCC does not break pods":                                                                                                                                                        {},
		"[install] [Suite: e2e] [OSD] RBAC Dedicated Admins SCC permissions Dedicated Admin permissions should include nonroot":                                                                                                                                          {},
		"[install] [Suite: e2e] [OSD] RBAC Dedicated Admins SCC permissions Dedicated Admin permissions should include anyuid":                                                                                                                                           {},
		"[install] [Suite: e2e] [OSD] RBAC Dedicated Admins SCC permissions Dedicated Admin permissions can create pods with SCCs":                                                                                                                                       {},
		"[install] [Suite: e2e] [OSD] Prometheus Exporters should exist and be running in the cluster":                                                                                                                                                                   {},
		"[install] [Suite: e2e] [OSD] OCM Quay Fallback uses a quay mirror when quay is unavailable":                                                                                                                                                                     {},
		"[install] [Suite: e2e] [OSD] OCM Metrics do exist and are not empty":                                                                                                                                                                                            {},
		"[install] [Suite: e2e] [OSD] HTTP Strict Transport Security Validating HTTP strict transport security should be set for openshift-monitoring OSD managed routes":                                                                                                {},
		"[install] [Suite: e2e] [OSD] HTTP Strict Transport Security Validating HTTP strict transport security should be set for openshift-console OSD managed routes":                                                                                                   {},
		"[install] [Suite: e2e] Workload (redmine) should get created in the cluster":                                                                                                                                                                                    {},
		"[install] [Suite: e2e] Workload (guestbook) should get created in the cluster":                                                                                                                                                                                  {},
		"[install] [Suite: e2e] Validation Webhook should exist and be running in the cluster":                                                                                                                                                                           {},
		"[install] [Suite: e2e] Storage storage create PVCs":                                                                       {},
		"[install] [Suite: e2e] Storage sc-list should be able to be expanded":                                                     {},
		"[install] [Suite: e2e] Routes should be functioning for oauth":                                                            {},
		"[install] [Suite: e2e] Routes should be functioning for Console":                                                          {},
		"[install] [Suite: e2e] Routes should be created for oauth":                                                                {},
		"[install] [Suite: e2e] Routes should be created for Console":                                                              {},
		"[install] [Suite: e2e] Pods should not be Failed":                                                                         {},
		"[install] [Suite: e2e] Pods should be Running or Succeeded":                                                               {},
		"[install] [Suite: e2e] MachineHealthChecks worker MHC should exist":                                                       {},
		"[install] [Suite: e2e] MachineHealthChecks should replace unhealthy nodes":                                                {},
		"[install] [Suite: e2e] MachineHealthChecks infra MHC should exist":                                                        {},
		"[install] [Suite: e2e] ImageStreams should exist in the cluster":                                                          {},
		"[install] [Suite: e2e] Encrypted Storage in GCP clusters can be created by dedicated admins":                              {},
		"[install] [Suite: e2e] Cluster state should include Prometheus data":                                                      {},
		"[install] [Suite: e2e] Cluster state should have no alerts":                                                               {},
		"[install] [Suite: app-builds] OpenShift Application Build E2E should get created in the cluster":                          {},
		"[bz-service-ca] clusteroperator/service-ca should not change condition/Progressing":                                       {},
		"[bz-service-ca] clusteroperator/service-ca should not change condition/Degraded":                                          {},
		"[bz-service-ca] clusteroperator/service-ca should not change condition/Available":                                         {},
		"[bz-openshift-controller-manager] clusteroperator/openshift-controller-manager should not change condition/Progressing":   {},
		"[bz-openshift-controller-manager] clusteroperator/openshift-controller-manager should not change condition/Degraded":      {},
		"[bz-openshift-controller-manager] clusteroperator/openshift-controller-manager should not change condition/Available":     {},
		"[bz-openshift-apiserver] clusteroperator/openshift-apiserver should not change condition/Progressing":                     {},
		"[bz-openshift-apiserver] clusteroperator/openshift-apiserver should not change condition/Degraded":                        {},
		"[bz-openshift-apiserver] clusteroperator/openshift-apiserver should not change condition/Available":                       {},
		"[bz-kube-storage-version-migrator] clusteroperator/kube-storage-version-migrator should not change condition/Progressing": {},
		"[bz-kube-storage-version-migrator] clusteroperator/kube-storage-version-migrator should not change condition/Degraded":    {},
		"[bz-kube-storage-version-migrator] clusteroperator/kube-storage-version-migrator should not change condition/Available":   {},
		"[bz-kube-scheduler] clusteroperator/kube-scheduler should not change condition/Progressing":                               {},
		"[bz-kube-scheduler] clusteroperator/kube-scheduler should not change condition/Degraded":                                  {},
		"[bz-kube-scheduler] clusteroperator/kube-scheduler should not change condition/Available":                                 {},
		"[bz-kube-controller-manager] clusteroperator/kube-controller-manager should not change condition/Progressing":             {},
		"[bz-kube-controller-manager] clusteroperator/kube-controller-manager should not change condition/Degraded":                {},
		"[bz-kube-controller-manager] clusteroperator/kube-controller-manager should not change condition/Available":               {},
		"[bz-kube-apiserver] clusteroperator/kube-apiserver should not change condition/Progressing":                               {},
		"[bz-kube-apiserver] clusteroperator/kube-apiserver should not change condition/Degraded":                                  {},
		"[bz-kube-apiserver] clusteroperator/kube-apiserver should not change condition/Available":                                 {},
		"[bz-config-operator] clusteroperator/config-operator should not change condition/Progressing":                             {},
		"[bz-config-operator] clusteroperator/config-operator should not change condition/Degraded":                                {},
		"[bz-config-operator] clusteroperator/config-operator should not change condition/Available":                               {},
		"[bz-cloud-controller-manager] clusteroperator/cloud-controller-manager should not change condition/Degraded":              {},
		"[bz-cloud-controller-manager] clusteroperator/cloud-controller-manager should not change condition/Available":             {},
		"[bz-baremetal] clusteroperator/baremetal should not change condition/Degraded":                                            {},
		"[bz-baremetal] clusteroperator/baremetal should not change condition/Available":                                           {},
		"[bz-apiserver-auth] clusteroperator/authentication should not change condition/Progressing":                               {},
		"[bz-apiserver-auth] clusteroperator/authentication should not change condition/Degraded":                                  {},
		"[bz-apiserver-auth] clusteroperator/authentication should not change condition/Available":                                 {},
		"[bz-Storage] clusteroperator/storage should not change condition/Progressing":                                             {},
		"[bz-Storage] clusteroperator/storage should not change condition/Degraded":                                                {},
		"[bz-Storage] clusteroperator/storage should not change condition/Available":                                               {},
		"[bz-Storage] clusteroperator/csi-snapshot-controller should not change condition/Progressing":                             {},
		"[bz-Storage] clusteroperator/csi-snapshot-controller should not change condition/Degraded":                                {},
		"[bz-Storage] clusteroperator/csi-snapshot-controller should not change condition/Available":                               {},
		"[bz-Samples] clusteroperator/openshift-samples should not change condition/Progressing":                                   {},
		"[bz-Samples] clusteroperator/openshift-samples should not change condition/Degraded":                                      {},
		"[bz-Samples] clusteroperator/openshift-samples should not change condition/Available":                                     {},
		"[bz-Routing] clusteroperator/ingress should not change condition/Progressing":                                             {},
		"[bz-Routing] clusteroperator/ingress should not change condition/Degraded":                                                {},
		"[bz-Routing] clusteroperator/ingress should not change condition/Available":                                               {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-packageserver should not change condition/Progressing":                {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-packageserver should not change condition/Degraded":                   {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-packageserver should not change condition/Available":                  {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-catalog should not change condition/Progressing":                      {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-catalog should not change condition/Degraded":                         {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager-catalog should not change condition/Available":                        {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager should not change condition/Progressing":                              {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager should not change condition/Degraded":                                 {},
		"[bz-OLM] clusteroperator/operator-lifecycle-manager should not change condition/Available":                                {},
		"[bz-OLM] clusteroperator/marketplace should not change condition/Progressing":                                             {},
		"[bz-OLM] clusteroperator/marketplace should not change condition/Degraded":                                                {},
		"[bz-OLM] clusteroperator/marketplace should not change condition/Available":                                               {},
		"[bz-Node Tuning Operator] clusteroperator/node-tuning should not change condition/Progressing":                            {},
		"[bz-Node Tuning Operator] clusteroperator/node-tuning should not change condition/Degraded":                               {},
		"[bz-Node Tuning Operator] clusteroperator/node-tuning should not change condition/Available":                              {},
		"[bz-Networking] clusteroperator/network should not change condition/Progressing":                                          {},
		"[bz-Networking] clusteroperator/network should not change condition/Degraded":                                             {},
		"[bz-Networking] clusteroperator/network should not change condition/Available":                                            {},
		"[bz-Monitoring] clusteroperator/monitoring should not change condition/Progressing":                                       {},
		"[bz-Monitoring] clusteroperator/monitoring should not change condition/Degraded":                                          {},
		"[bz-Monitoring] clusteroperator/monitoring should not change condition/Available":                                         {},
		"[bz-Management Console] clusteroperator/console should not change condition/Progressing":                                  {},
		"[bz-Management Console] clusteroperator/console should not change condition/Degraded":                                     {},
		"[bz-Management Console] clusteroperator/console should not change condition/Available":                                    {},
		"[bz-Machine Config Operator] clusteroperator/machine-config should not change condition/Progressing":                      {},
		"[bz-Machine Config Operator] clusteroperator/machine-config should not change condition/Degraded":                         {},
		"[bz-Machine Config Operator] clusteroperator/machine-config should not change condition/Available":                        {},
		"[bz-Insights Operator] clusteroperator/insights should not change condition/Progressing":                                  {},
		"[bz-Insights Operator] clusteroperator/insights should not change condition/Degraded":                                     {},
		"[bz-Insights Operator] clusteroperator/insights should not change condition/Available":                                    {},
		"[bz-Image Registry] clusteroperator/image-registry should not change condition/Progressing":                               {},
		"[bz-Image Registry] clusteroperator/image-registry should not change condition/Degraded":                                  {},
		"[bz-Image Registry] clusteroperator/image-registry should not change condition/Available":                                 {},
		"[bz-Etcd] clusteroperator/etcd should not change condition/Progressing":                                                   {},
		"[bz-Etcd] clusteroperator/etcd should not change condition/Degraded":                                                      {},
		"[bz-Etcd] clusteroperator/etcd should not change condition/Available":                                                     {},
		"[bz-DNS] clusteroperator/dns should not change condition/Progressing":                                                     {},
		"[bz-DNS] clusteroperator/dns should not change condition/Degraded":                                                        {},
		"[bz-DNS] clusteroperator/dns should not change condition/Available":                                                       {},
		"[bz-Cloud Credential Operator] clusteroperator/cloud-credential should not change condition/Progressing":                  {},
		"[bz-Cloud Credential Operator] clusteroperator/cloud-credential should not change condition/Degraded":                     {},
		"[bz-Cloud Credential Operator] clusteroperator/cloud-credential should not change condition/Available":                    {},
		"[bz-Cloud Compute] clusteroperator/machine-approver should not change condition/Progressing":                              {},
		"[bz-Cloud Compute] clusteroperator/machine-approver should not change condition/Degraded":                                 {},
		"[bz-Cloud Compute] clusteroperator/machine-approver should not change condition/Available":                                {},
		"[bz-Cloud Compute] clusteroperator/machine-api should not change condition/Progressing":                                   {},
		"[bz-Cloud Compute] clusteroperator/machine-api should not change condition/Degraded":                                      {},
		"[bz-Cloud Compute] clusteroperator/machine-api should not change condition/Available":                                     {},
		"[bz-Cloud Compute] clusteroperator/cluster-autoscaler should not change condition/Progressing":                            {},
		"[bz-Cloud Compute] clusteroperator/cluster-autoscaler should not change condition/Degraded":                               {},
		"[bz-Cloud Compute] clusteroperator/cluster-autoscaler should not change condition/Available":                              {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:71: executing 'oc wait -n e2e-test-441 --timeout=240s --for=condition=available deployment -l component=elasticsearch' expecting success":                                                                                                                                  {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:71: executing 'oc wait -n e2e-test-23998 --timeout=240s --for=condition=available deployment -l component=elasticsearch' expecting success":                                                                                                                                {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:71: executing 'oc wait -n e2e-test-13031 --timeout=240s --for=condition=available deployment -l component=elasticsearch' expecting success":                                                                                                                                {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:70: executing 'oc -n e2e-test-441 get deployment -l component=elasticsearch -o jsonpath='{.items[0].metadata.name}'' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                                 {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:70: executing 'oc -n e2e-test-23998 get deployment -l component=elasticsearch -o jsonpath='{.items[0].metadata.name}'' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                               {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:70: executing 'oc -n e2e-test-13031 get deployment -l component=elasticsearch -o jsonpath='{.items[0].metadata.name}'' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                               {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-7201 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                       {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-441 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-31926 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                      {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-23998 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                      {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-14934 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                      {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-13031 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                      {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:65: executing 'oc -n e2e-test-12638 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                      {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-7201' expecting success":                                                                                                                                                                    {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-441' expecting success":                                                                                                                                                                     {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-31926' expecting success":                                                                                                                                                                   {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-23998' expecting success":                                                                                                                                                                   {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-14934' expecting success":                                                                                                                                                                   {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-13031' expecting success":                                                                                                                                                                   {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:64: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-12638' expecting success":                                                                                                                                                                   {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-7201 elasticsearch' expecting success":                                                                                                                                         {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-441 elasticsearch' expecting success":                                                                                                                                          {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-31926 elasticsearch' expecting success":                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-23998 elasticsearch' expecting success":                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-14934 elasticsearch' expecting success":                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-13031 elasticsearch' expecting success":                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:63: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-12638 elasticsearch' expecting success":                                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:136: executing 'oc -n e2e-test-441 exec elasticsearch-cdm-o071bmxo-1-66bc78ccb4-qwnzt -c elasticsearch -- bash -c /tmp/test' expecting success and text '403'":                                                                                                             {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:136: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-za2tst04-1-5f656945fd-xdt78 -c elasticsearch -- bash -c /tmp/test' expecting success and text '403'":                                                                                                           {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:136: executing 'oc -n e2e-test-13031 exec elasticsearch-cdm-cf77q6y5-1-5bf4889c85-5vddk -c elasticsearch -- bash -c /tmp/test' expecting success and text '403'":                                                                                                           {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:129: executing 'oc -n e2e-test-441 exec elasticsearch-cdm-o071bmxo-1-66bc78ccb4-qwnzt -c elasticsearch -- bash -c /tmp/test' expecting success and text '200'":                                                                                                             {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:129: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-za2tst04-1-5f656945fd-xdt78 -c elasticsearch -- bash -c /tmp/test' expecting success and text '200'":                                                                                                           {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:129: executing 'oc -n e2e-test-13031 exec elasticsearch-cdm-cf77q6y5-1-5bf4889c85-5vddk -c elasticsearch -- bash -c /tmp/test' expecting success and text '200'":                                                                                                           {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:121: executing 'oc -n e2e-test-441 exec elasticsearch-cdm-o071bmxo-1-66bc78ccb4-qwnzt -c elasticsearch -- chmod 777 /tmp/test' expecting success":                                                                                                                          {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:121: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-za2tst04-1-5f656945fd-xdt78 -c elasticsearch -- chmod 777 /tmp/test' expecting success":                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:121: executing 'oc -n e2e-test-13031 exec elasticsearch-cdm-cf77q6y5-1-5bf4889c85-5vddk -c elasticsearch -- chmod 777 /tmp/test' expecting success":                                                                                                                        {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:120: executing 'oc -n e2e-test-441 cp /tmp/test elasticsearch-cdm-o071bmxo-1-66bc78ccb4-qwnzt:/tmp/test -c elasticsearch' expecting success":                                                                                                                               {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:120: executing 'oc -n e2e-test-23998 cp /tmp/test elasticsearch-cdm-za2tst04-1-5f656945fd-xdt78:/tmp/test -c elasticsearch' expecting success":                                                                                                                             {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:120: executing 'oc -n e2e-test-13031 cp /tmp/test elasticsearch-cdm-cf77q6y5-1-5bf4889c85-5vddk:/tmp/test -c elasticsearch' expecting success":                                                                                                                             {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:113: executing 'oc -n e2e-test-441 wait --for=condition=Ready pod/elasticsearch-cdm-o071bmxo-1-66bc78ccb4-qwnzt --timeout=120s' expecting success":                                                                                                                         {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:113: executing 'oc -n e2e-test-23998 wait --for=condition=Ready pod/elasticsearch-cdm-za2tst04-1-5f656945fd-xdt78 --timeout=120s' expecting success":                                                                                                                       {},
		"[Elasticsearch] Verify Metrics Access.hack/testing-olm/test-200-verify-es-metrics-access.sh:113: executing 'oc -n e2e-test-13031 wait --for=condition=Ready pod/elasticsearch-cdm-cf77q6y5-1-5bf4889c85-5vddk --timeout=120s' expecting success":                                                                                                                       {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/utils:69: executing 'oc -n e2e-test-23998 get deployment elasticsearch-cdm-cv6bbn61-1 -o jsonpath={.status.availableReplicas} --ignore-not-found' expecting any result and text '1'; re-trying every 0.2s until completion or 120.000s":                                           {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:92: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-cv6bbn61-1-854798cd7d-gt6qg -c elasticsearch -- es_util --query=foo-write/_doc/1 -d '{\"key\":\"value\"}' -XPUT  -w %{http_code}' expecting success and text '.*201'": {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:87: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-cv6bbn61-1-854798cd7d-gt6qg -c elasticsearch -- es_util --query=foo-write -XPUT -w %{http_code}' expecting success and text '.*200'":                                  {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:82: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-cv6bbn61-1-854798cd7d-gt6qg -c elasticsearch -- es_util --query=foo-write/_doc/1 -d '{\"key\":\"value\"}' -XPUT -w %{http_code}' expecting success and text '.*404'":  {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:77: executing 'oc -n e2e-test-23998 exec elasticsearch-cdm-cv6bbn61-1-854798cd7d-gt6qg -c elasticsearch -- es_util --query=foo/_doc/1 -d '{\"key\":\"value\"}' -XPUT -w %{http_code}' expecting success and text '.*201'":        {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:64: executing 'oc -n e2e-test-23998 get deployment -l component=elasticsearch -o jsonpath='{.items[0].metadata.name}'' expecting success; re-trying every 0.2s until completion or 120.000s":                                     {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-7201 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                             {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-441 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                              {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-31926 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                            {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-23998 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                            {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-14934 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                            {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-13031 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                            {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:59: executing 'oc -n e2e-test-12638 create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                            {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-7201' expecting success":                                                                                                                          {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-441' expecting success":                                                                                                                           {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-31926' expecting success":                                                                                                                         {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-23998' expecting success":                                                                                                                         {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-14934' expecting success":                                                                                                                         {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-13031' expecting success":                                                                                                                         {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:58: executing 'hack/testing-olm/../../hack/deploy-example-secrets.sh  e2e-test-12638' expecting success":                                                                                                                         {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-7201 elasticsearch' expecting success":                                                                                               {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-441 elasticsearch' expecting success":                                                                                                {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-31926 elasticsearch' expecting success":                                                                                              {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-23998 elasticsearch' expecting success":                                                                                              {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-14934 elasticsearch' expecting success":                                                                                              {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-13031 elasticsearch' expecting success":                                                                                              {},
		"[Elasticsearch] Index Management Block Auto-Create For Write Suffix.hack/testing-olm/test-657-im-block-autocreate-for-write-suffix.sh:57: executing 'hack/testing-olm/../../hack/cert_generation.sh /tmp/example-secrets e2e-test-12638 elasticsearch' expecting success":                                                                                              {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/test-010-deploy-via-olm-minimal.sh:66: executing 'oc -n openshift-logging create -f hack/testing-olm/../../hack/cr.yaml' expecting success":                                                                                                                                                                   {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/test-010-deploy-via-olm-minimal.sh:63: executing 'oc -n openshift-logging create -f hack/testing-olm/../../hack/cr_invalid.yaml' expecting failure and text 'invalid":                                                                                                                                         {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/test-010-deploy-via-olm-minimal.sh:60: executing 'oc -n openshift-logging get deployment cluster-logging-operator -o jsonpath={.status.availableReplicas} --ignore-not-found' expecting any result and text '1'; re-trying every 0.2s until completion or 120.000s":                                           {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/assertions:8: executing 'oc -n openshift-logging get ds fluentd' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                                                                                                                        {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/assertions:5: executing 'oc -n openshift-logging get cronjob curator' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                                                                                                                   {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/assertions:17: executing 'oc -n openshift-logging get kibana kibana' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                                                                                                                    {},
		"[ClusterLogging] Deploy via OLM minimal.hack/testing-olm/assertions:11: executing 'oc -n openshift-logging get elasticsearch elasticsearch' expecting success; re-trying every 0.2s until completion or 120.000s":                                                                                                                                                      {},
		"[ClusterLogging] Collection.hack/testing-olm/test-030-collection.sh:65: executing 'oc get ns/clo-test-19923 ns/openshift-logging' expecting failure; re-trying every 0.2s until completion or 60.000s":                                                                                                                                                                 {},
		"[ClusterLogging] Collection.hack/testing-olm/test-030-collection.sh:65: executing 'oc get ns/clo-test-18992 ns/openshift-logging' expecting failure; re-trying every 0.2s until completion or 60.000s":                                                                                                                                                                 {},
		"[ClusterLogging] Collection.hack/testing-olm/test-030-collection.sh:65: executing 'oc get ns/clo-test-1713 ns/openshift-logging' expecting failure; re-trying every 0.2s until completion or 60.000s":                                                                                                                                                                  {},
		"Using OLM descriptor components.Using OLM descriptor components successfully creates operand using form":                                                                                                                                                                                                                                                               {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Select field":                         {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Password field":                       {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Number field":                         {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Name field":                           {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Labels field":                         {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Field Group":                          {},
		"Using OLM descriptor components.Using OLM descriptor components pre-populates Array Field Group":                    {},
		"Using OLM descriptor components.Using OLM descriptor components does not render hidden field group":                 {},
		"Using OLM descriptor components.Using OLM descriptor components does not display status descriptor for Hidden":      {},
		"Using OLM descriptor components.Using OLM descriptor components does not display spec descriptor for Hidden":        {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for W3 Link":             {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for Text":                {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for Prometheus Endpoint": {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for Pod Statuses":        {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for Pod Count":           {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for Password":            {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for K8s Phase Reason":    {},
		"Using OLM descriptor components.Using OLM descriptor components displays status descriptor for K8s Phase":           {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Update Strategy":       {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Text":                  {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Resource Requirements": {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Pod Count":             {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Pod Anti Affinity":     {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Pod Affinity":          {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Password":              {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Number":                {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Node Affinity":         {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Namespace Selector":    {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Label":                 {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Image Pull Policy":     {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Field Dependency":      {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Endpoint List":         {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Checkbox":              {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Boolean Switch":        {},
		"Using OLM descriptor components.Using OLM descriptor components displays spec descriptor for Advanced":              {},
		"Using OLM descriptor components.Using OLM descriptor components displays list containing operands":                  {},
		"Using OLM descriptor components.Using OLM descriptor components displays form for creating operand":                 {},
		"Using OLM descriptor components.Using OLM descriptor components displays detail view for operand":                   {},
		"Using OLM descriptor components.Using OLM descriptor components deletes operand":                                    {},
		"TestMakefileTargets_test_install_with_deploy_nodes.start_install":                                                   {},
		"TestMakefileTargets_test_install_with_deploy_nodes.cluster":                                                         {},
		"TestInstall_test_install.wait_until_hosts_are_discovered(openshift_version=4.9)":                                    {},
		"TestInstall_test_install.start_install(openshift_version=4.9)":                                                      {},
		"TestInstall_test_install.prepare_for_installation(openshift_version=4.9)":                                           {},
		"TestInstall_test_install.generate_and_download_image(openshift_version=4.9)":                                        {},
		"TestInstall_test_install.cluster":                                            {},
		"Symptom Detection.Undiagnosed panic detected in journal":                     {},
		"Symptom Detection.Infrastructure - GCP quota exceeded (route to forum-gcp)":  {},
		"Symptom Detection.Infrastructure - AWS simulate policy rate-limit":           {},
		"Symptom Detection.Bug 1812261: iptables is segfaulting":                      {},
		"Quorum Loss and Restore.quorum_restore":                                      {},
		"Quorum Loss and Restore.[sig-apps] statefulset-upgrade":                      {},
		"Quorum Loss and Restore.[sig-apps] daemonset-upgrade":                        {},
		"Operator upgrade storage":                                                    {},
		"Operator upgrade service-ca":                                                 {},
		"Operator upgrade operator-lifecycle-manager-packageserver":                   {},
		"Operator upgrade operator-lifecycle-manager-catalog":                         {},
		"Operator upgrade operator-lifecycle-manager":                                 {},
		"Operator upgrade openshift-samples":                                          {},
		"Operator upgrade openshift-controller-manager":                               {},
		"Operator upgrade openshift-apiserver":                                        {},
		"Operator upgrade node-tuning":                                                {},
		"Operator upgrade network":                                                    {},
		"Operator upgrade monitoring":                                                 {},
		"Operator upgrade marketplace":                                                {},
		"Operator upgrade machine-config":                                             {},
		"Operator upgrade machine-approver":                                           {},
		"Operator upgrade machine-api":                                                {},
		"Operator upgrade kube-storage-version-migrator":                              {},
		"Operator upgrade kube-scheduler":                                             {},
		"Operator upgrade kube-apiserver":                                             {},
		"Operator upgrade insights":                                                   {},
		"Operator upgrade ingress":                                                    {},
		"Operator upgrade image-registry":                                             {},
		"Operator upgrade etcd":                                                       {},
		"Operator upgrade dns":                                                        {},
		"Operator upgrade csi-snapshot-controller":                                    {},
		"Operator upgrade console":                                                    {},
		"Operator upgrade config-operator":                                            {},
		"Operator upgrade cluster-autoscaler":                                         {},
		"Operator upgrade cloud-credential":                                           {},
		"Operator upgrade baremetal":                                                  {},
		"Operator upgrade authentication":                                             {},
		"OpenShift Namespaces.OpenShift Namespaces Create the namespace: : C-02-TC01": {},
		"Interacting with the environment variable editor.When a variable is deleted.does not show any variables":                                                                                                                                                                                          {},
		"Interacting with the environment variable editor.When a variable is added.shows the correct variables":                                                                                                                                                                                            {},
		"Interacting with the environment variable editor.When a variable is added from a config map.shows the correct variables":                                                                                                                                                                          {},
		"Interacting with the create secret forms.Webhook secret.edits webhook secret":                                                                                                                                                                                                                     {},
		"Interacting with the create secret forms.Webhook secret.deletes the webhook secret":                                                                                                                                                                                                               {},
		"Interacting with the create secret forms.Webhook secret.creates webhook secret":                                                                                                                                                                                                                   {},
		"Interacting with the create secret forms.Webhook secret.check for edited webhook secret value":                                                                                                                                                                                                    {},
		"Interacting with the create secret forms.Webhook secret.check for created webhook secret value":                                                                                                                                                                                                   {},
		"Interacting with the create secret forms.Upload configuration file image secret.deletes the image secret created from uploaded configuration file":                                                                                                                                                {},
		"Interacting with the create secret forms.Upload configuration file image secret.creates image secret by uploading configuration file":                                                                                                                                                             {},
		"Interacting with the create secret forms.Upload configuration file image secret.check for created image secret values from uploaded configuration file":                                                                                                                                           {},
		"Interacting with the create secret forms.SSH source secrets.edits SSH source secret":                                                                                                                                                                                                              {},
		"Interacting with the create secret forms.SSH source secrets.deletes the SSH source secret":                                                                                                                                                                                                        {},
		"Interacting with the create secret forms.SSH source secrets.creates SSH source secret":                                                                                                                                                                                                            {},
		"Interacting with the create secret forms.SSH source secrets.check for edited SSH source secret values":                                                                                                                                                                                            {},
		"Interacting with the create secret forms.SSH source secrets.check for created SSH source secret values":                                                                                                                                                                                           {},
		"Interacting with the create secret forms.Registry credentials image secrets.edits registry credentials image secret":                                                                                                                                                                              {},
		"Interacting with the create secret forms.Registry credentials image secrets.deletes the registry credentials image secret":                                                                                                                                                                        {},
		"Interacting with the create secret forms.Registry credentials image secrets.creates registry credentials image secret":                                                                                                                                                                            {},
		"Interacting with the create secret forms.Registry credentials image secrets.check for edited registry credentials image secret value":                                                                                                                                                             {},
		"Interacting with the create secret forms.Registry credentials image secrets.check for created registry credentials image secret values":                                                                                                                                                           {},
		"Interacting with the create secret forms.Key/Value secrets.edits Key/Value secret":                                                                                                                                                                                                                {},
		"Interacting with the create secret forms.Key/Value secrets.deletes the Key/Value secret":                                                                                                                                                                                                          {},
		"Interacting with the create secret forms.Key/Value secrets.creates Key/Value secret":                                                                                                                                                                                                              {},
		"Interacting with the create secret forms.Key/Value secrets.check for edited Key/Value secret values":                                                                                                                                                                                              {},
		"Interacting with the create secret forms.Key/Value secrets.check for created Key/Value secret values":                                                                                                                                                                                             {},
		"Interacting with the create secret forms.Basic source secrets.edits basic source secret":                                                                                                                                                                                                          {},
		"Interacting with the create secret forms.Basic source secrets.deletes the basic source secret":                                                                                                                                                                                                    {},
		"Interacting with the create secret forms.Basic source secrets.creates basic source secret":                                                                                                                                                                                                        {},
		"Interacting with the create secret forms.Basic source secrets.check for edited basic source secret values":                                                                                                                                                                                        {},
		"Interacting with the create secret forms.Basic source secrets.check for created basic source secret values":                                                                                                                                                                                       {},
		"Interacting with OperatorHub.Interacting with OperatorHub filters Operators by name":                                                                                                                                                                                                              {},
		"Interacting with OperatorHub.Interacting with OperatorHub filters Operators by category":                                                                                                                                                                                                          {},
		"Interacting with OperatorHub.Interacting with OperatorHub displays OperatorHub tiles filtered by \"Source\"":                                                                                                                                                                                      {},
		"Interacting with OperatorHub.Interacting with OperatorHub displays OperatorHub tile view with expected available Operators":                                                                                                                                                                       {},
		"Interacting with OperatorHub.Interacting with OperatorHub displays \"Clear All Filters\" link when text filter removes all Operators from display":                                                                                                                                                {},
		"Interacting with OperatorHub.Interacting with OperatorHub clears text filter when \"Clear All Filters\" link is clicked":                                                                                                                                                                          {},
		"Interacting with CatalogSource page.Interacting with CatalogSource page lists all the package manifests for redhat-operators under Operators tab":                                                                                                                                                 {},
		"Interacting with CatalogSource page.Interacting with CatalogSource page allows modifying registry poll interval":                                                                                                                                                                                  {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-zytrm.Installing \"Red Hat CodeReady Workspaces\" operator in test-zytrm Installs Red Hat CodeReady Workspaces operator in test-zytrm and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-zyrbg.Installing \"Red Hat CodeReady Workspaces\" operator in test-zyrbg Installs Red Hat CodeReady Workspaces operator in test-zyrbg and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-zlazj.Installing \"Red Hat CodeReady Workspaces\" operator in test-zlazj Installs Red Hat CodeReady Workspaces operator in test-zlazj and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-xjxxz.Installing \"Red Hat CodeReady Workspaces\" operator in test-xjxxz Installs Red Hat CodeReady Workspaces operator in test-xjxxz and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-xdxet.Installing \"Red Hat CodeReady Workspaces\" operator in test-xdxet Installs Red Hat CodeReady Workspaces operator in test-xdxet and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-veykt.Installing \"Red Hat CodeReady Workspaces\" operator in test-veykt Installs Red Hat CodeReady Workspaces operator in test-veykt and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-ugzkg.Installing \"Red Hat CodeReady Workspaces\" operator in test-ugzkg Installs Red Hat CodeReady Workspaces operator in test-ugzkg and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-smjcm.Installing \"Red Hat CodeReady Workspaces\" operator in test-smjcm Installs Red Hat CodeReady Workspaces operator in test-smjcm and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-smbza.Installing \"Red Hat CodeReady Workspaces\" operator in test-smbza Installs Red Hat CodeReady Workspaces operator in test-smbza and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-rwuzi.Installing \"Red Hat CodeReady Workspaces\" operator in test-rwuzi Installs Red Hat CodeReady Workspaces operator in test-rwuzi and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-rbsly.Installing \"Red Hat CodeReady Workspaces\" operator in test-rbsly Installs Red Hat CodeReady Workspaces operator in test-rbsly and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-qyshs.Installing \"Red Hat CodeReady Workspaces\" operator in test-qyshs Installs Red Hat CodeReady Workspaces operator in test-qyshs and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-qwqkn.Installing \"Red Hat CodeReady Workspaces\" operator in test-qwqkn Installs Red Hat CodeReady Workspaces operator in test-qwqkn and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-qwqaj.Installing \"Red Hat CodeReady Workspaces\" operator in test-qwqaj Installs Red Hat CodeReady Workspaces operator in test-qwqaj and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-ohnxv.Installing \"Red Hat CodeReady Workspaces\" operator in test-ohnxv Installs Red Hat CodeReady Workspaces operator in test-ohnxv and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-nxpyo.Installing \"Red Hat CodeReady Workspaces\" operator in test-nxpyo Installs Red Hat CodeReady Workspaces operator in test-nxpyo and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-nugqs.Installing \"Red Hat CodeReady Workspaces\" operator in test-nugqs Installs Red Hat CodeReady Workspaces operator in test-nugqs and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-lrmyi.Installing \"Red Hat CodeReady Workspaces\" operator in test-lrmyi Installs Red Hat CodeReady Workspaces operator in test-lrmyi and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-lfava.Installing \"Red Hat CodeReady Workspaces\" operator in test-lfava Installs Red Hat CodeReady Workspaces operator in test-lfava and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-keapy.Installing \"Red Hat CodeReady Workspaces\" operator in test-keapy Installs Red Hat CodeReady Workspaces operator in test-keapy and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-icgdx.Installing \"Red Hat CodeReady Workspaces\" operator in test-icgdx Installs Red Hat CodeReady Workspaces operator in test-icgdx and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-gotbo.Installing \"Red Hat CodeReady Workspaces\" operator in test-gotbo Installs Red Hat CodeReady Workspaces operator in test-gotbo and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-fhggi.Installing \"Red Hat CodeReady Workspaces\" operator in test-fhggi Installs Red Hat CodeReady Workspaces operator in test-fhggi and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-eqrth.Installing \"Red Hat CodeReady Workspaces\" operator in test-eqrth Installs Red Hat CodeReady Workspaces operator in test-eqrth and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-epf.Installing \"Red Hat CodeReady Workspaces\" operator in test-epf Installs Red Hat CodeReady Workspaces operator in test-epf and creates CodeReady Workspaces Cluster operand instance":                                           {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-deqjr.Installing \"Red Hat CodeReady Workspaces\" operator in test-deqjr Installs Red Hat CodeReady Workspaces operator in test-deqjr and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-dcdha.Installing \"Red Hat CodeReady Workspaces\" operator in test-dcdha Installs Red Hat CodeReady Workspaces operator in test-dcdha and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-cugfc.Installing \"Red Hat CodeReady Workspaces\" operator in test-cugfc Installs Red Hat CodeReady Workspaces operator in test-cugfc and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-cnldv.Installing \"Red Hat CodeReady Workspaces\" operator in test-cnldv Installs Red Hat CodeReady Workspaces operator in test-cnldv and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-cggey.Installing \"Red Hat CodeReady Workspaces\" operator in test-cggey Installs Red Hat CodeReady Workspaces operator in test-cggey and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Installing \"Red Hat CodeReady Workspaces\" operator in test-bhzka.Installing \"Red Hat CodeReady Workspaces\" operator in test-bhzka Installs Red Hat CodeReady Workspaces operator in test-bhzka and creates CodeReady Workspaces Cluster operand instance":                                     {},
		"Globally installing \"Service Binding Operator\" operator in openshift-operators.Globally installing \"Service Binding Operator\" operator in openshift-operators Globally installs Service Binding Operator operator in openshift-operators and creates ServiceBinding operand":                  {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Pre-provisioned Snapshot (retain policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion":           {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Pre-provisioned Snapshot (delete policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion":           {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should support two pods which share the same volume":                                                                                                                     {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should support multiple inline ephemeral volumes":                                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should create read/write inline ephemeral volume":                                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should create read-only inline ephemeral volume":                                                                                                                         {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should support two pods which share the same volume":                                                                                                                {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should create read/write inline ephemeral volume":                                                                                                                   {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should create read-only inline ephemeral volume":                                                                                                                    {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic Snapshot (retain policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion":                   {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic Snapshot (delete policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion":                   {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (xfs)][Slow] volumes should store data":                                                                                                                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (xfs)][Slow] volumes should allow exec of files on the volume":                                                                                                                                                                {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (immediate binding)] topology should provision a volume and schedule a pod with AllowedTopologies":                                                                                                                            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (immediate binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies":                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly]":                                                                                                                                  {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should fail to use a volume in a pod with mismatched mode [Slow]":                                                                                                                            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] multiVolume [Slow] should concurrently access the single volume from pods on the same node [LinuxOnly]":                                                                                                 {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] multiVolume [Slow] should concurrently access the single read-only volume from pods on the same node":                                                                                                   {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] multiVolume [Slow] should access to two volumes with the same volume mode and retain data across pod recreation on the same node [LinuxOnly]":                                                           {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (filesystem volmode)] multiVolume [Slow] should access to two volumes with the same volume mode and retain data across pod recreation on different node [LinuxOnly]":                                                          {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (ext4)] volumes should store data":                                                                                                                                                                                            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (ext4)] volumes should allow exec of files on the volume":                                                                                                                                                                     {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (delayed binding)] topology should provision a volume and schedule a pod with AllowedTopologies":                                                                                                                              {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (delayed binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies":                                                                                                          {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] volumes should store data":                                                                                                                                                                                      {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] volumes should allow exec of files on the volume":                                                                                                                                                               {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] volumeIO should write files of various sizes, verify size, validate content [Slow][LinuxOnly]":                                                                                                                  {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property":                                                                                                                         {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should verify container cannot write to subpath readonly volumes [Slow]":                                                                                                                                {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support restarting containers using file as subpath [Slow][LinuxOnly]":                                                                                                                           {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support restarting containers using directory as subpath [Slow]":                                                                                                                                 {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly]":                                                                                                                                  {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount":                                                                                                                                         {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support non-existent path":                                                                                                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support file as subpath [LinuxOnly]":                                                                                                                                                             {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly]":                                                                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory":                                                                                                                                                                      {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource":                                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should support creating multiple subpath from same volumes [Slow]":                                                                                                                                      {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should fail if subpath with backstepping is outside the volume [Slow][LinuxOnly]":                                                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should fail if subpath file is outside the volume [Slow][LinuxOnly]":                                                                                                                                    {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should fail if subpath directory is outside the volume [Slow][LinuxOnly]":                                                                                                                               {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should fail if non-existent subpath is outside the volume [Slow][LinuxOnly]":                                                                                                                            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly]":                                                                                                                           {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with snapshot data source [Feature:VolumeSnapshotDataSource]":                                                                                                             {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with mount options":                                                                                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup skips ownership changes to the volume contents": {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents":            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents":                                                                               {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup applied to the volume contents":                         {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents":                    {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents":                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it":                                                                                                                    {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand Verify if offline PVC expansion works":                                                                                                                                            {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] volumes should store data":                                                                                                                                                                                   {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly]":                                                                                                                                       {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] volumeMode should fail to use a volume in a pod with mismatched mode [Slow]":                                                                                                                                 {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property":                                                                                                                      {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] provisioning should provision storage with snapshot data source [Feature:VolumeSnapshotDataSource]":                                                                                                          {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should concurrently access the single volume from pods on the same node [LinuxOnly]":                                                                                                      {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should concurrently access the single read-only volume from pods on the same node":                                                                                                        {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should access to two volumes with the same volume mode and retain data across pod recreation on the same node [LinuxOnly]":                                                                {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should access to two volumes with the same volume mode and retain data across pod recreation on different node [LinuxOnly]":                                                               {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should access to two volumes with different volume mode and retain data across pod recreation on the same node [LinuxOnly]":                                                               {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)] multiVolume [Slow] should access to two volumes with different volume mode and retain data across pod recreation on different node [LinuxOnly]":                                                              {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it":                                                                                                                 {},
		"External Storage [Driver: ebs.csi.aws.com] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand Verify if offline PVC expansion works":                                                                                                                                         {},
		"Deploy Image.Deploy Image page.should render project/namespace dropdown disabled when in a project context":                                                                                                                                                                                       {},
		"Deploy Image.Deploy Image page.should render applications dropdown disabled":                                                                                                                                                                                                                      {},
		"Deploy Image.Deploy Image page.should auto fill in the application":                                                                                                                                                                                                                               {},
		"Deploy Image.Deploy Image page.can be used to search for an image":                                                                                                                                                                                                                                {},
		"Create namespace from install operators.Create namespace from install operators disables default catalog sources from operatorHub details page":                                                                                                                                                   {},
		"Create a test namespace.creates test namespace if necessary": {},
		"ClusterLogging E2E Suite - Collection Fluentd.[Collection] Provides only a fluentd daemonset when ClusterLogging is configured only with a collection spec should default to a running collector": {},
		"ClusterLogging E2E Suite - Collection Fluentd.[Collection] Namespace filtering should send logs from one namespace only":                                                                          {},
		"Cluster Dashboard.Utilization Card.has duration dropdown":                                                                                                                                                                  {},
		"Cluster Dashboard.Utilization Card.has all items":                                                                                                                                                                          {},
		"Cluster Dashboard.Status Card.has health indicators":                                                                                                                                                                       {},
		"Cluster Dashboard.Status Card.has View alerts link":                                                                                                                                                                        {},
		"Cluster Dashboard.Inventory Card.has all items":                                                                                                                                                                            {},
		"Cluster Dashboard.Details Card.has all fields populated":                                                                                                                                                                   {},
		"Cluster Dashboard.Details Card.has View settings link":                                                                                                                                                                     {},
		"Cluster Dashboard.Activity Card.has View events link":                                                                                                                                                                      {},
		"Cluster Dashboard.Activity Card.has Pause events button":                                                                                                                                                                   {},
		"CRD extensions.ConsoleNotification CRD.displays the ConsoleNotification instance in its new location":                                                                                                                      {},
		"CRD extensions.ConsoleNotification CRD.displays the ConsoleNotification instance":                                                                                                                                          {},
		"CRD extensions.ConsoleNotification CRD.displays detail view for ConsoleNotification instance":                                                                                                                              {},
		"CRD extensions.ConsoleNotification CRD.displays YAML editor for modifying the location of ConsoleNotification instance":                                                                                                    {},
		"CRD extensions.ConsoleNotification CRD.displays YAML editor for creating a new ConsoleNotification instance":                                                                                                               {},
		"CRD extensions.ConsoleNotification CRD.deletes the ConsoleNotification instance":                                                                                                                                           {},
		"CRD extensions.ConsoleNotification CRD.creates a new ConsoleNotification instance":                                                                                                                                         {},
		"CRD extensions.ConsoleLink CRD.displays the ConsoleLink instance in the user menu":                                                                                                                                         {},
		"CRD extensions.ConsoleLink CRD.displays the ConsoleLink instance in the help menu":                                                                                                                                         {},
		"CRD extensions.ConsoleLink CRD.displays detail view for ConsoleLink user menu instance":                                                                                                                                    {},
		"CRD extensions.ConsoleLink CRD.displays detail view for ConsoleLink help menu instance":                                                                                                                                    {},
		"CRD extensions.ConsoleLink CRD.displays YAML editor for creating a new ConsoleLink user menu instance":                                                                                                                     {},
		"CRD extensions.ConsoleLink CRD.displays YAML editor for creating a new ConsoleLink help menu instance":                                                                                                                     {},
		"CRD extensions.ConsoleLink CRD.deletes the ConsoleLink user menu instance":                                                                                                                                                 {},
		"CRD extensions.ConsoleLink CRD.deletes the ConsoleLink help menu instance":                                                                                                                                                 {},
		"CRD extensions.ConsoleLink CRD.creates a new ConsoleLink user menu instance":                                                                                                                                               {},
		"CRD extensions.ConsoleLink CRD.creates a new ConsoleLink help menu instance":                                                                                                                                               {},
		"CRD extensions.ConsoleExternalLogLink CRD.does not display the ConsoleExternalLogLink instance on the test pod":                                                                                                            {},
		"CRD extensions.ConsoleExternalLogLink CRD.displays the ConsoleExternalLogLink instance on the test pod":                                                                                                                    {},
		"CRD extensions.ConsoleExternalLogLink CRD.displays detail view for ConsoleExternalLogLink instance":                                                                                                                        {},
		"CRD extensions.ConsoleExternalLogLink CRD.displays YAML editor for creating a new ConsoleExternalLogLink instance":                                                                                                         {},
		"CRD extensions.ConsoleExternalLogLink CRD.displays YAML editor for adding namespaceFilter to the ConsoleExternalLogLink instance":                                                                                          {},
		"CRD extensions.ConsoleExternalLogLink CRD.deletes the test pod":                                                                                                                                                            {},
		"CRD extensions.ConsoleExternalLogLink CRD.deletes the ConsoleExternalLogLink instance":                                                                                                                                     {},
		"CRD extensions.ConsoleExternalLogLink CRD.creates a new test pod to display the ConsoleExternalLogLink instance":                                                                                                           {},
		"CRD extensions.ConsoleExternalLogLink CRD.creates a new ConsoleExternalLogLink instance":                                                                                                                                   {},
		"CRD extensions.ConsoleClIDownload CRD.displays the ConsoleCLIDownload instance on the Command Line Tools page":                                                                                                             {},
		"CRD extensions.ConsoleClIDownload CRD.displays detail view for ConsoleCLIDownload instance":                                                                                                                                {},
		"CRD extensions.ConsoleClIDownload CRD.displays YAML editor for creating a new ConsoleCLIDownload instance":                                                                                                                 {},
		"CRD extensions.ConsoleClIDownload CRD.deletes the ConsoleCLIDownload instance":                                                                                                                                             {},
		"CRD extensions.ConsoleClIDownload CRD.creates a new ConsoleCLIDownload instance":                                                                                                                                           {},
		"Backup from one node and recover on another.restore_different_node":                                                                                                                                                        {},
		"Backup from one node and recover on another.[sig-apps] replicaset-upgrade":                                                                                                                                                 {},
		"Backup from one node and recover on another.[sig-apps] daemonset-upgrade":                                                                                                                                                  {},
		"Auth test.Login test.logs in as kubeadmin user":                                                                                                                                                                            {},
		"Alertmanager: YAML.saves Alertmanager YAML":                                                                                                                                                                                {},
		"Alertmanager: YAML.displays the Alertmanager YAML page":                                                                                                                                                                    {},
		"Alertmanager: Configuration.prevents deletion of default receiver":                                                                                                                                                         {},
		"Alertmanager: Configuration.prevents deletion and form edit of a receiver with sub-route":                                                                                                                                  {},
		"Alertmanager: Configuration.launches Alert Routing modal, edits and saves correctly":                                                                                                                                       {},
		"Alertmanager: Configuration.edits a receiver correctly":                                                                                                                                                                    {},
		"Alertmanager: Configuration.displays the Alertmanager Configuration Details page":                                                                                                                                          {},
		"Alertmanager: Configuration.deletes a receiver correctly":                                                                                                                                                                  {},
		"Alertmanager: Configuration.creates a receiver correctly":                                                                                                                                                                  {},
		"Add Secret to Workloads.Add Secret to Workloads as Volume.Add Secret to Deployment as Vol":                                                                                                                                 {},
		"Add Secret to Workloads.Add Secret to Workloads as Enviroment Variables.Add Secret to Deployment as Env":                                                                                                                   {},
		"operator conditions cloud-controller-manager":                                                                                                                                                                              {},
		"[sig-node][Late] should not have pod creation failures due to systemd timeouts [Suite:openshift/conformance/parallel]":                                                                                                     {},
		"[sig-api-machinery][Feature:APIServer][Late] kubelet terminates kube-apiserver gracefully [Suite:openshift/conformance/parallel]":                                                                                          {},
		"[sig-api-machinery][Feature:APIServer][Late] kube-apiserver terminates within graceful termination period [Suite:openshift/conformance/parallel]":                                                                          {},
		"[sig-api-machinery][Feature:APIServer][Late] API LBs follow /readyz of kube-apiserver and stop sending requests [Suite:openshift/conformance/parallel]":                                                                    {},
		"[sig-api-machinery][Feature:APIServer][Late] API LBs follow /readyz of kube-apiserver and don't send request early [Suite:openshift/conformance/parallel]":                                                                 {},
		"[sig-arch][Late] clients should not use APIs that are removed in upcoming releases [Suite:openshift/conformance/parallel]":                                                                                                 {},
		"[sig-node] ConfigMap should fail to create ConfigMap with empty key [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                              {},
		"[sig-auth] ServiceAccounts should allow opting out of API token automount  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                       {},
		"[sig-api-machinery] Watchers should receive events on concurrent watches in same order [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                           {},
		"[sig-api-machinery] Watchers should observe add, update, and delete watch notifications on configmaps [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                            {},
		"[sig-api-machinery] ResourceQuota should verify ResourceQuota with best effort scope. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                            {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a secret. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                {},
		"[sig-api-machinery] ResourceQuota should create a ResourceQuota and capture the life of a replica set. [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                           {},
		"[sig-api-machinery] Garbage collector should delete pods created by rc when not orphaning [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                        {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for multiple CRDs of different groups [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                           {},
		"[sig-api-machinery] CustomResourceDefinition resources [Privileged:ClusterAdmin] custom resource defaulting for requests and from storage works  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]": {},
		"[sig-api-machinery] CustomResourceDefinition resources [Privileged:ClusterAdmin] Simple CustomResourceDefinition getting/updating/patching custom resource definition status sub-resource works  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":               {},
		"[sig-api-machinery] CustomResourceDefinition resources [Privileged:ClusterAdmin] Simple CustomResourceDefinition creating/deleting custom resource definition objects works  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                   {},
		"[sig-network] Services should serve multiport endpoints from pods  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                             {},
		"[sig-network] Services should serve a basic endpoint from pods  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                {},
		"[sig-network] Services should release NodePorts on delete [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                            {},
		"[sig-network] Networking Granular Checks: Pods should function for intra-pod communication: udp [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                              {},
		"[sig-network] DNS should support configurable pod resolv.conf [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                        {},
		"[sig-storage] Projected secret optional updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                {},
		"[sig-storage] Projected downwardAPI should update annotations on modification [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                {},
		"[sig-storage] Projected downwardAPI should provide podname as non-root with fsgroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                {},
		"[sig-storage] Projected downwardAPI should provide container's memory request [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                {},
		"[sig-storage] Projected downwardAPI should provide container's memory limit [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                  {},
		"[sig-storage] Projected downwardAPI should provide container's cpu limit [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                     {},
		"[sig-storage] Projected combined should project all components that make up the projection API [Projection][NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                   {},
		"[sig-storage] Managed cluster should have no crashlooping recycler pods over four minutes [Suite:openshift/conformance/parallel]":                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                       {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                         {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                              {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                      {},
		"[sig-storage] HostPath should support subPath [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] Ephemeralstorage When pod refers to non-existent ephemeral storage should allow deletion of pod with invalid volume : projected [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] volume on default medium should have the correct mode using FSGroup [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] nonexistent volume subPath should have the correct mode and owner using FSGroup [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                           {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] new files should be created with FSGroup ownership when container is root [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                 {},
		"[sig-storage] EmptyDir volumes volume on tmpfs should have the correct mode [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                      {},
		"[sig-storage] Downward API volume should update labels on modification [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                       {},
		"[sig-storage] Downward API volume should update annotations on modification [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                  {},
		"[sig-storage] Downward API volume should provide container's cpu limit [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                       {},
		"[sig-storage] CSI mock volume storage capacity exhausted, late binding, with topology [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-storage] CSI mock volume CSI workload information using mock driver contain ephemeral=true when using inline volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                             {},
		"[sig-storage] CSI mock volume CSI FSGroupPolicy [LinuxOnly] should modify fsGroup if fsGroupPolicy=default [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-operator] OLM should have imagePullPolicy:IfNotPresent on thier deployments [Suite:openshift/conformance/parallel]":                                                                                                                                                                 {},
		"[sig-operator] OLM should be installed with operatorgroups at version v1 [Suite:openshift/conformance/parallel]":                                                                                                                                                                         {},
		"[sig-operator] OLM should be installed with installplans at version v1alpha1 [Suite:openshift/conformance/parallel]":                                                                                                                                                                     {},
		"[sig-operator] OLM should be installed with clusterserviceversions at version v1alpha1 [Suite:openshift/conformance/parallel]":                                                                                                                                                           {},
		"[sig-node] Downward API should provide pod UID as env vars [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                   {},
		"[sig-node] ConfigMap should be consumable via the environment [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                {},
		"[sig-node] ConfigMap should be consumable via environment variable [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                           {},
		"[sig-cli] Kubectl client Simple pod should contain last line of the log [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                              {},
		"[sig-cli] Kubectl client Kubectl server-side dry-run should check if kubectl can dry-run update Pods [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                           {},
		"[sig-cli] Kubectl client Kubectl label should update the label on a resource  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                  {},
		"[sig-cli] Kubectl client Kubectl describe should check if kubectl describe prints relevant information for cronjob [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                   {},
		"[sig-cli] Kubectl client Kubectl create quota should reject quota with invalid scopes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-cli] Kubectl client Kubectl cluster-info dump should check if cluster-info dump succeeds [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                        {},
		"[sig-cli] Kubectl client Kubectl client-side validation should create/apply a valid CR for CRD with validation schema [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                {},
		"[sig-cli] Kubectl client Kubectl apply should reuse port when apply to an existing SVC [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                               {},
		"[sig-cli] Kubectl client Kubectl apply apply set/view last-applied [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                   {},
		"[sig-cli] Kubectl Port forwarding With a server listening on localhost that expects NO client request should support a client that connects, sends DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-auth] [Feature:NodeAuthorizer] Getting a non-existent secret should exit with the Forbidden error, not a NotFound error [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-auth] [Feature:NodeAuthorizer] A node shouldn't be able to delete another node [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-auth] [Feature:NodeAuthorizer] A node shouldn't be able to create another node [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-arch] Managed cluster should set requests but not limits [Suite:openshift/conformance/parallel]":                                                                                                                                                                                    {},
		"[sig-arch] Managed cluster should ensure control plane pods do not run in best-effort QoS [Suite:openshift/conformance/parallel]":                                                                                                                                                        {},
		"[sig-arch] Managed cluster should ensure control plane operators do not make themselves unevictable [Suite:openshift/conformance/parallel]":                                                                                                                                              {},
		"[sig-apps] ReplicationController should test the lifecycle of a ReplicationController [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                          {},
		"[sig-apps] Job should run a job to completion when tasks sometimes fail and are locally restarted [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                              {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for security.openshift.io/v1, Resource=rangeallocations [Suite:openshift/conformance/parallel]":                                                                                                               {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for oauth.openshift.io/v1, Resource=oauthauthorizetokens [Suite:openshift/conformance/parallel]":                                                                                                              {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for image.openshift.io/v1, Resource=images [Suite:openshift/conformance/parallel]":                                                                                                                            {},
		"[sig-api-machinery] health handlers should contain necessary checks [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-api-machinery] Servers with support for Table transformation should return pod details [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-api-machinery] Server request timeout default timeout should be used if the specified timeout in the request URL is 0s [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                          {},
		"[sig-api-machinery] ResourceQuota [Feature:ScopeSelectors] should verify ResourceQuota with best effort scope using scope-selectors. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                 {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's priority class scope (cpu, memory quota set) against a pod with same priority class. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                           {},
		"[sig-api-machinery] ResourceQuota [Feature:PodPriority] should verify ResourceQuota's multiple priority class scope (quota set to pod count: 2) against 2 pods with same priority classes. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                           {},
		"[sig-api-machinery] Garbage collector should support orphan deletion of custom resources [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                             {},
		"[sig-api-machinery] Garbage collector should support cascading deletion of custom resources [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                          {},
		"[sig-api-machinery] Garbage collector should delete jobs and pods created by cronjob [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-api-machinery] Discovery should validate PreferredVersion for each APIGroup [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                               {},
		"[sig-api-machinery] Discovery Custom resource should have storage version hash [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                       {},
		"[sig-api-machinery] CustomResourceConversionWebhook [Privileged:ClusterAdmin] should be able to convert from CR v1 to CR v2 [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                    {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should mutate custom resource [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                   {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should be able to deny pod and configmap creation [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                               {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should be able to deny attaching pod [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                            {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] patching/updating a validating webhook should work [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                              {},
		"[sig-storage] PersistentVolumes-local  Pod with node different from PV's NodeAffinity should fail scheduling due to different NodeAffinity [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                           {},
		"[sig-network] EndpointSlice should have Endpoints and EndpointSlices pointing to API Server [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                    {},
		"[sig-network] EndpointSlice should create Endpoints and EndpointSlices for Pods matching a Service [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                             {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithoutformat] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                 {},
		"[sig-storage] CSI mock volume CSIStorageCapacity CSIStorageCapacity used, insufficient capacity [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                      {},
		"[sig-storage] CSI mock volume CSI Volume Snapshots [Feature:VolumeSnapshotDataSource] volumesnapshotcontent and pvc in Bound state with deletion timestamp set should not get deleted while snapshot finalizer exists [Suite:openshift/conformance/parallel] [Suite:k8s]":                {},
		"[sig-node] [Feature:Example] Liveness liveness pods should be automatically restarted [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-node] Variable Expansion should allow substituting values in a container's args [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-node] Sysctls [LinuxOnly] [NodeFeature:Sysctls] should reject invalid sysctls [MinimumKubeletVersion:1.21] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                {},
		"[sig-node] Security Context when creating containers with AllowPrivilegeEscalation should not allow privilege escalation when false [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                              {},
		"[sig-node] Security Context When creating a container with runAsUser should run the container with uid 0 [LinuxOnly] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                               {},
		"[sig-node] Secrets should patch a secret [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-node] Probing container with readiness probe that fails should never be ready and never restart [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                         {},
		"[sig-node] Probing container with readiness probe should not be ready before initial delay and never restart [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                 {},
		"[sig-node] Probing container should override timeoutGracePeriodSeconds when LivenessProbe field is set [Feature:ProbeTerminationGracePeriod] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                         {},
		"[sig-node] Probing container should be restarted with a /healthz http liveness probe [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-node] PreStop graceful pod terminated should wait until preStop hook completes the process [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                      {},
		"[sig-node] NodeLease when the NodeLease feature is enabled should have OwnerReferences set [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                           {},
		"[sig-node] InitContainer [NodeConformance] should not start app containers and fail the pod if init containers fail on a RestartNever pod [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                      {},
		"[sig-node] Docker Containers should be able to override the image's default command (docker entrypoint) [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-node] Container Runtime blackbox test on terminated container should report termination message [LinuxOnly] if TerminationMessagePath is set as non-root user and at a non-default path [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]": {},
		"[sig-coreos] [Conformance] CoreOS bootimages TestBootimagesPresent [Suite:openshift/conformance/parallel/minimal]":                                                                                                                                                                       {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] Should recreate evicted statefulset [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                  {},
		"[sig-api-machinery] ServerSideApply should remove a field if it is owned but removed in the apply request [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-api-machinery] API priority and fairness should ensure that requests can be classified by adding FlowSchema and PriorityLevelConfiguration [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-instrumentation] Prometheus when installed on the cluster should provide named network metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                       {},
		"[sig-instrumentation] Prometheus when installed on the cluster should have non-Pod host cAdvisor metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                  {},
		"operator install kube-storage-version-migrator": {},
		"operator install config-operator":               {},
		"operator conditions config-operator":            {},
		"[sig-network] Services should have session affinity work for service with type clusterIP [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":         {},
		"[sig-network] Services should have session affinity timeout work for service with type clusterIP [LinuxOnly] [Conformance] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]": {},
		"Pod": {},
		"[sig-network] Networking Granular Checks: Services should function for client IP based session affinity: http [LinuxOnly] [Skipped:Network/OVNKubernetes] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] DNS should resolve DNS of partial qualified names for the cluster [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                               {},
		"[sig-network] DNS should provide DNS for services  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                  {},
		"[sig-network] DNS should provide DNS for pods for Subdomain [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                         {},
		"[sig-network] DNS should provide /etc/hosts entries for the cluster [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                     {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with mount options [Suite:openshift/conformance/parallel] [Suite:k8s]":               {},
		"[sig-auth] [Feature:NodeAuthenticator] The kubelet can delegate ServiceAccount tokens to the API server [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                {},
		"[sig-storage] PVC Protection Verify \"immediate\" deletion of a PVC that is not in active use by a pod [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                    {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should adopt matching orphans and release non-matching pods [Suite:openshift/conformance/parallel] [Suite:k8s]":                     {},
		"operator install machine-approver":                                         {},
		"operator install cloud-credential":                                         {},
		"operator conditions machine-approver":                                      {},
		"operator conditions kube-storage-version-migrator":                         {},
		"operator conditions cloud-credential":                                      {},
		"[sig-network] pods should successfully create sandboxes by not timing out": {},
		"[sig-storage] CSI mock volume CSI workload information using mock driver should not be passed when podInfoOnMount=false [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] CSI mock volume CSI workload information using mock driver should not be passed when CSIDriver does not exist [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] CSI mock volume CSI attach test using mock driver should preserve attachment policy when no CSIDriver present [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Pre-provisioned Snapshot (delete policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)] provisioning should provision storage with snapshot data source [Feature:VolumeSnapshotDataSource] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-sippy] install should not timeout": {},
		"[sig-storage] CSI mock volume CSIStorageCapacity CSIStorageCapacity disabled [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-storage] CSI mock volume CSIServiceAccountToken token should not be plumbed down when CSIDriver is not deployed [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                    {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should create read/write inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":         {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (late-binding)] ephemeral should create read-only inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":          {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should support two pods which share the same volume [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Generic Ephemeral-volume (default fs) (immediate-binding)] ephemeral should create read-only inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":     {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with pvc data source [Suite:openshift/conformance/parallel] [Suite:k8s]":                                      {},
		"operator conditions  authentication":                 {},
		"Operator upgrade kube-controller-manager":            {},
		"operator conditions  openshift-apiserver":            {},
		"operator conditions  kube-controller-manager":        {},
		"Operator upgrade cloud-controller-manager":           {},
		"[sig-storage] [sig-api-machinery] configmap-upgrade": {},
		"[sig-apps] deployment-upgrade":                       {},
		"[sig-storage] Volume limits should verify that all nodes have volume limits [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                              {},
		"[sig-storage] Mounted volume expand Should verify mounted devices can be resized [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for multiple CRDs of same group and version but different kinds [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                   {},
		"[sig-network] Services should be able to update service type to NodePort listening on same port number but different protocols [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                           {},
		"[sig-network] SCTP [Feature:SCTP] [LinuxOnly] should allow creating a basic SCTP service with pod and endpoints [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                          {},
		"[sig-network] Networking Granular Checks: Pods should function for intra-pod communication: http [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                 {},
		"[sig-network] DNS should support configurable pod DNS nameservers [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] Subpath Atomic writer volumes should support subpaths with configmap pod [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                 {},
		"[sig-storage] Secrets should be consumable from pods in volume with mappings [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                     {},
		"[sig-storage] Secrets should be able to mount in a volume regardless of a different secret existing with same name in different namespace [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                        {},
		"[sig-storage] Projected secret should be consumable from pods in volume as non-root with defaultMode and fsGroup set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                 {},
		"[sig-storage] Projected downwardAPI should update labels on modification [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] Projected downwardAPI should set mode on item file [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                     {},
		"[sig-storage] Projected downwardAPI should set DefaultMode on files [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                  {},
		"[sig-storage] Projected configMap updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                          {},
		"[sig-storage] Projected configMap should be consumable from pods in volume with mappings as non-root with FSGroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                      {},
		"[sig-storage] Projected configMap should be consumable from pods in volume with mappings [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                         {},
		"[sig-storage] PersistentVolumes-local  [Volume type: tmpfs] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                    {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                      {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                    {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link-bindmounted] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                        {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-bindmounted] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-bindmounted] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-storage] PersistentVolumes-local  [Volume type: block] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-storage] PersistentVolumes NFS with Single PV - PVC pairs should create a non-pre-bound PV and PVC: test write access  [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                              {},
		"[sig-storage] PersistentVolumes NFS with Single PV - PVC pairs create a PVC and a pre-bound PV: test write access [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                        {},
		"[sig-storage] PersistentVolumes NFS when invoking the Recycle reclaim policy should test that a PV becomes Available and is clean after the PVC is deleted. [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                              {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                              {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                              {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                     {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                   {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                    {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                     {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                              {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                 {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                 {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                            {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] new files should be created with FSGroup ownership when container is non-root [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                 {},
		"[sig-storage] EmptyDir volumes should support (root,0777,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] EmptyDir volumes should support (root,0666,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                      {},
		"[sig-storage] EmptyDir volumes should support (root,0644,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] EmptyDir volumes should support (non-root,0666,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                  {},
		"[sig-storage] EmptyDir volumes should support (non-root,0666,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                {},
		"[sig-storage] Downward API volume should provide podname only [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                    {},
		"[sig-storage] Downward API volume should provide container's memory request [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                      {},
		"[sig-storage] Downward API volume should provide container's cpu request [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] ConfigMap updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                    {},
		"[sig-storage] ConfigMap should be consumable from pods in volume as non-root [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                     {},
		"[sig-storage] CSI mock volume storage capacity unlimited [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: CSI Ephemeral-volume (default fs)] ephemeral should support multiple inline ephemeral volumes [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-operator] an end user can use OLM Report Upgradeable in OLM ClusterOperators status [Suite:openshift/conformance/parallel]":                                                                                                                                             {},
		"[sig-node] Downward API should provide host IP as an env var [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                     {},
		"[sig-imageregistry][Feature:Image] signature TestImageRemoveSignature [Suite:openshift/conformance/parallel]":                                                                                                                                                                {},
		"[sig-imageregistry][Feature:Image] signature TestImageAddSignature [Suite:openshift/conformance/parallel]":                                                                                                                                                                   {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagSTIWithConfigChange [Suite:openshift/conformance/parallel]":                                                                                        {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagSTI [Suite:openshift/conformance/parallel]":                                                                                                        {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagDocker [Suite:openshift/conformance/parallel]":                                                                                                     {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagCustomWithConfigChange [Suite:openshift/conformance/parallel]":                                                                                     {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagCustom [Suite:openshift/conformance/parallel]":                                                                                                     {},
		"[sig-devex][Feature:Templates] templateinstance object kinds test should create and delete objects from varying API groups [Suite:openshift/conformance/parallel]":                                                                                                           {},
		"[sig-devex][Feature:Templates] templateinstance cross-namespace test should create and delete objects across namespaces [Suite:openshift/conformance/parallel]":                                                                                                              {},
		"[sig-devex][Feature:Templates] templateinstance creation with invalid object reports error  should report a failure on creation [Suite:openshift/conformance/parallel]":                                                                                                      {},
		"[sig-devex][Feature:Templates] template-api TestTemplate [Suite:openshift/conformance/parallel]":                                                                                                                                                                             {},
		"[sig-devex][Feature:OpenShiftControllerManager] TestDockercfgTokenDeletedController [Suite:openshift/conformance/parallel]":                                                                                                                                                  {},
		"[sig-devex][Feature:OpenShiftControllerManager] TestAutomaticCreationOfPullSecrets [Suite:openshift/conformance/parallel]":                                                                                                                                                   {},
		"[sig-cli] oc debug ensure debug does not depend on a container actually existing for the selected resource [Suite:openshift/conformance/parallel]":                                                                                                                           {},
		"[sig-cli] oc adm user-creation [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                            {},
		"[sig-cli] oc adm ui-project-commands [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                      {},
		"[sig-cli] oc adm serviceaccounts [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                          {},
		"[sig-cli] oc adm cluster-role-reapers [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                     {},
		"[sig-cli] oc adm build-chain [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                              {},
		"[sig-cli] oc --request-timeout works as expected [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                          {},
		"[sig-cli] Kubectl client Update Demo should create and stop a replication controller  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                   {},
		"[sig-cli] Kubectl client Simple pod should support exec [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                       {},
		"[sig-cli] Kubectl client Kubectl logs should be able to retrieve and filter logs  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                       {},
		"[sig-cli] Kubectl client Kubectl client-side validation should create/apply a CR with unknown fields for CRD with no validation schema [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                        {},
		"[sig-cli] Kubectl Port forwarding With a server listening on localhost should support forwarding over websockets [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                              {},
		"[sig-cli] Kubectl Port forwarding With a server listening on 0.0.0.0 that expects NO client request should support a client that connects, sends DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                        {},
		"[sig-builds][Feature:Builds][webhook] TestWebhookGitHubPushWithImage [Suite:openshift/conformance/parallel]":                                                                                                                                                                                      {},
		"[sig-builds][Feature:Builds][webhook] TestWebhookGitHubPing [Suite:openshift/conformance/parallel]":                                                                                                                                                                                               {},
		"[sig-builds][Feature:Builds][webhook] TestWebhook [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                         {},
		"[sig-builds][Feature:Builds] remove all builds when build configuration is removed  oc delete buildconfig should start builds and delete the buildconfig [Suite:openshift/conformance/parallel]":                                                                                                  {},
		"[sig-builds][Feature:Builds] buildconfig secret injector  should inject secrets to the appropriate buildconfigs [Suite:openshift/conformance/parallel]":                                                                                                                                           {},
		"[sig-auth][Feature:UserAPI] groups should work [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                            {},
		"[sig-auth][Feature:SecurityContextConstraints]  TestPodUpdateSCCEnforcement [Suite:openshift/conformance/parallel]":                                                                                                                                                                               {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Rolebinding restrictions tests single project should succeed [Suite:openshift/conformance/parallel]":                                                                                                    {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a rolebinding when there are no restrictions should succeed [Suite:openshift/conformance/parallel]":                                                                                              {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a rolebinding when subject is permitted by RBR should succeed [Suite:openshift/conformance/parallel]":                                                                                            {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a rolebinding when subject is not already bound and is not permitted by any RBR should fail [Suite:openshift/conformance/parallel]":                                                              {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a rolebinding that also contains system:non-existing users should succeed [Suite:openshift/conformance/parallel]":                                                                                {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a RBAC rolebinding when subject is not already bound and is not permitted by any RBR should fail [Suite:openshift/conformance/parallel]":                                                         {},
		"[sig-auth][Feature:ProjectAPI]  TestUnprivilegedNewProject [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                {},
		"[sig-auth][Feature:ProjectAPI]  TestProjectIsNamespace should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                                     {},
		"[sig-auth][Feature:OpenShiftAuthorization] self-SAR compatibility  TestSelfSubjectAccessReviewsNonExistingNamespace should succeed [Suite:openshift/conformance/parallel]":                                                                                                                        {},
		"[sig-auth][Feature:OpenShiftAuthorization] self-SAR compatibility  TestBootstrapPolicySelfSubjectAccessReviews should succeed [Suite:openshift/conformance/parallel]":                                                                                                                             {},
		"[sig-auth][Feature:OpenShiftAuthorization] scopes TestScopedTokens should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                         {},
		"[sig-auth][Feature:OpenShiftAuthorization] scopes TestScopedImpersonation should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                  {},
		"[sig-auth][Feature:OpenShiftAuthorization] authorization  TestAuthorizationSubjectAccessReviewAPIGroup should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-auth][Feature:OpenShiftAuthorization] RBAC proxy for openshift authz  RunLegacyLocalRoleEndpoint should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                      {},
		"[sig-auth][Feature:OpenShiftAuthorization] RBAC proxy for openshift authz  RunLegacyLocalRoleBindingEndpoint should succeed [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-auth][Feature:OpenShiftAuthorization] RBAC proxy for openshift authz  RunLegacyClusterRoleBindingEndpoint should succeed [Suite:openshift/conformance/parallel]":                                                                                                                             {},
		"[sig-auth][Feature:OAuthServer] OAuth Authenticator accepts sha256 access tokens [Suite:openshift/conformance/parallel]":                                                                                                                                                                          {},
		"[sig-auth] ServiceAccounts should set ownership and permission when RunAsUser or FsGroup is present [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                         {},
		"[sig-auth] ServiceAccounts should mount projected service account token [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestTriggers_imageChange_nonAutomatic [Suite:openshift/conformance/parallel]":                                                                                                                                                                      {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestTriggers_imageChange [Suite:openshift/conformance/parallel]":                                                                                                                                                                                   {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestTriggers_configChange [Suite:openshift/conformance/parallel]":                                                                                                                                                                                  {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestDeploymentConfigDefaults [Suite:openshift/conformance/parallel]":                                                                                                                                                                               {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs when run iteratively should immediately start a new deployment [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-apps] ReplicaSet should adopt matching pods on creation and release no longer matching pods [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-apps] Job should run a job to completion when tasks succeed [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                              {},
		"[sig-apps] Job should fail to exceed backoffLimit [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                             {},
		"[sig-apps] DisruptionController should block an eviction until the PDB is updated to allow it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-apps] DisruptionController evictions: enough pods, absolute => should allow an eviction [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-apps] Deployment test Deployment ReplicaSet orphaning and adoption regarding controllerRef [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                               {},
		"[sig-apps] Deployment deployment should support rollover [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                {},
		"[sig-apps] CronJob should not emit unexpected warnings [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for template.openshift.io/v1, Resource=templates [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for route.openshift.io/v1, Resource=routes [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for oauth.openshift.io/v1, Resource=oauthclientauthorizations [Suite:openshift/conformance/parallel]":                                                                                                                  {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for image.openshift.io/v1, Resource=imagestreams [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for build.openshift.io/v1, Resource=builds [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for build.openshift.io/v1, Resource=buildconfigs [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-api-machinery][Feature:APIServer] authenticated browser should get a 200 from / [Suite:openshift/conformance/parallel]":                                                                                                                                                                      {},
		"[sig-api-machinery] Generated clientset should create pods, set the deletionTimestamp and deletionGracePeriodSeconds of the pod [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                               {},
		"[sig-api-machinery] CustomResourceConversionWebhook [Privileged:ClusterAdmin] should be able to convert a non homogeneous list of CRs [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                   {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should mutate custom resource with different stored version [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                              {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] patching/updating a mutating webhook should work [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] Volumes NFSv4 should be mountable for NFSv4 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                     {},
		"[sig-storage] Volumes NFSv3 should be mountable for NFSv3 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                     {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                              {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                               {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithoutformat] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-storage] PersistentVolumes-local  [Volume type: block] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                        {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                              {},
		"[sig-storage] CSI mock volume CSI Volume Snapshots secrets [Feature:VolumeSnapshotDataSource] volume snapshot create/delete with secrets [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                      {},
		"[sig-node] Variable Expansion should allow substituting values in a volume subpath [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                      {},
		"[sig-node] Variable Expansion should allow substituting values in a container's command [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                               {},
		"[sig-node] Sysctls [LinuxOnly] [NodeFeature:Sysctls] should support unsafe sysctls which are actually allowed [MinimumKubeletVersion:1.21] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                              {},
		"[sig-node] Sysctls [LinuxOnly] [NodeFeature:Sysctls] should support sysctls [MinimumKubeletVersion:1.21] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                {},
		"[sig-node] Security Context should support seccomp unconfined on the pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                          {},
		"[sig-node] Security Context should support pod.Spec.SecurityContext.SupplementalGroups [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                            {},
		"[sig-node] Security Context should support container.SecurityContext.RunAsUser [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-node] Security Context When creating a pod with readOnlyRootFilesystem should run the container with writable rootfs when readOnlyRootFilesystem=false [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                           {},
		"[sig-node] Security Context When creating a pod with privileged should run the container as unprivileged when false [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                       {},
		"[sig-node] Probing container should have monotonically increasing restart count [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                       {},
		"[sig-node] Probing container should be restarted with an exec liveness probe with timeout [MinimumKubeletVersion:1.20] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                      {},
		"[sig-node] Probing container should *not* be restarted with a tcp:8080 liveness probe [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                 {},
		"[sig-node] Pods should get a host IP [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-node] Pods should contain environment variables for services [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                     {},
		"[sig-node] Pods Extended Delete Grace Period should be submitted and removed [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-node] Kubelet when scheduling a read only busybox container should not write to root filesystem [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-node] Kubelet when scheduling a busybox command that always fails in a pod should have an terminated reason [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                      {},
		"[sig-node] Docker Containers should use the image defaults if command and args are blank [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                              {},
		"[sig-node] Docker Containers should be able to override the image's default command and arguments [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                     {},
		"[sig-node] Container Runtime blackbox test when running a container with a new image should not be able to pull image from invalid registry [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                 {},
		"[sig-node] Container Runtime blackbox test when running a container with a new image should be able to pull image [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                           {},
		"[sig-node] Container Runtime blackbox test on terminated container should report termination message [LinuxOnly] from log output if TerminationMessagePolicy FallbackToLogsOnError is set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":             {},
		"[sig-node] Container Runtime blackbox test on terminated container should report termination message [LinuxOnly] as empty when pod succeeds and TerminationMessagePolicy FallbackToLogsOnError is set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]": {},
		"[sig-node] Container Lifecycle Hook when create a pod with lifecycle hook should execute poststart http hook properly [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                 {},
		"[sig-cli] Kubectl client Update Demo should scale a replication controller  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                             {},
		"[sig-autoscaling] [Feature:HPA] Horizontal pod autoscaling (scale resource: CPU) ReplicationController light Should scale from 1 pod to 2 pods [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                {},
		"[sig-auth][Feature:OAuthServer] OAuth server should use http1.1 only to prevent http2 connection reuse [Suite:openshift/conformance/parallel]":                                                                                                                                                    {},
		"[sig-auth][Feature:OAuthServer] ClientSecretWithPlus should create oauthclient [Suite:openshift/conformance/parallel]":                                                                                                                                                                            {},
		"[sig-arch] Managed cluster should ensure platform components have system-* priority class associated [Suite:openshift/conformance/parallel]":                                                                                                                                                      {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should have a working scale subresource [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                       {},
		"[sig-apps] ReplicaSet Replace and Patch tests [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-apps] Deployment should run the lifecycle of a Deployment [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                          {},
		"[sig-network] network isolation when using OpenshiftSDN in a mode that does not isolate namespaces by default should allow communication between pods in different namespaces on the same node [Suite:openshift/conformance/parallel]":                                                            {},
		"[sig-network] Networking Granular Checks: Services should update endpoints: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-network] Networking Granular Checks: Services should be able to handle large requests: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                              {},
		"[sig-network] Internal connectivity for TCP and UDP on ports 9000-9999 is allowed [Suite:openshift/conformance/parallel]":                                                                                                                                                                         {},
		"[sig-instrumentation] Prometheus when installed on the cluster should have a AlertmanagerReceiversNotConfigured alert in firing state [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                              {},
		"[sig-cli] CLI can run inside of a busybox container [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                                                {},
		"[sig-builds][Feature:Builds] imagechangetriggers  imagechangetriggers should trigger builds of all types [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                           {},
		"[sig-apps][Feature:Jobs] Users should be able to create and run a job in a user project [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                            {},
		"[sig-instrumentation] Prometheus when installed on the cluster shouldn't have failing rules evaluation [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                             {},
		"[sig-instrumentation] Prometheus when installed on the cluster should start and expose a secured proxy and unsecured metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                       {},
		"[sig-instrumentation] Prometheus when installed on the cluster should provide ingress metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                      {},
		"[sig-imageregistry][Feature:Image] oc tag should work when only imagestreams api is available [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                      {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with enhanced status should include various info in status [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                  {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs rolled back should rollback to an older deployment [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                          {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs paused should disable actions on deployments [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs generation should deploy based on a status version bump [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                     {},
		"[sig-network][Feature:Router] The HAProxy router should respond with 503 to unrecognized hosts [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-imageregistry][Feature:ImageInfo] Image info should display information about images [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                          {},
		"operator install service-ca":     {},
		"operator install node-tuning":    {},
		"operator install marketplace":    {},
		"operator install machine-config": {},
		"operator conditions service-ca":  {},
		"operator conditions node-tuning": {},
		"operator conditions marketplace": {},
		"[sig-storage][Late] Metrics should report short mount times [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                        {},
		"[sig-storage][Late] Metrics should report short attach times [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                       {},
		"[sig-instrumentation][Late] Alerts shouldn't exceed the 500 series limit of total series sent via telemetry from each cluster [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                      {},
		"[sig-network] multicast when using one of the OpenshiftSDN modes 'redhat/openshift-ovs-multitenant, redhat/openshift-ovs-networkpolicy' should block multicast traffic in namespaces where it is disabled [Suite:openshift/conformance/parallel]": {},
		"[sig-network] DNS should resolve DNS of partial qualified names for services [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for CRD preserving unknown fields in an embedded object [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                {},
		"[sig-storage] PersistentVolumes-local  Stress with local volumes [Serial] should be able to process many pods and reuse local volumes [Suite:openshift/conformance/serial] [Suite:k8s]":                                                           {},
		"[sig-scheduling] SchedulerPredicates [Serial] validates that required NodeAffinity setting is respected if matching [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                             {},
		"[sig-auth][Feature:ProjectAPI][Serial]  TestUnprivilegedNewProjectDenied [Suite:openshift/conformance/serial]":                                                                                                                                    {},
		"[sig-scheduling] SchedulerPriorities [Serial] Pod should be preferably scheduled to nodes pod can tolerate [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                      {},
		"operator install csi-snapshot-controller": {},
		"[sig-network] IngressClass [Feature:Ingress] should set default value on new IngressClass [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                                                                                                                    {},
		"[sig-cli] oc debug ensure it works with image streams [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":            {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (block volmode)] volume-expand should not allow expansion of pvcs without AllowVolumeExpansion property [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                      {},
		"[sig-apps] ReplicaSet should serve a basic image on each replica with a private image [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                               {},
		"[sig-storage] PersistentVolumes GCEPD should test that deleting the Namespace of a PVC and Pod causes the successful detach of Persistent Disk [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                      {},
		"[sig-storage] PersistentVolumes GCEPD should test that deleting a PVC before the pod does not cause pod deletion to fail on PD detach [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-storage] Multi-AZ Cluster Volumes should schedule pods in the same zones as statically provisioned PVs [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (ext3)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup skips ownership changes to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                    {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                       {},
		"[sig-network] Services should be able to create a functioning NodePort service [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                {},
		"[sig-network] Services should be able to change the type from NodePort to ExternalName [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-network] Services should be able to change the type from ExternalName to NodePort [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-network] Services should be able to change the type from ExternalName to ClusterIP [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                       {},
		"[sig-network] Proxy version v1 should proxy through a service and a pod  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                      {},
		"[sig-storage] Volumes ConfigMap should be mountable [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                                                 {},
		"[sig-storage] Subpath Atomic writer volumes should support subpaths with secret pod [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                               {},
		"[sig-storage] Subpath Atomic writer volumes should support subpaths with downward pod [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                             {},
		"[sig-storage] Secrets should be consumable in multiple volumes in a pod [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                     {},
		"[sig-storage] Secrets optional updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-storage] Projected secret should be consumable in multiple volumes in a pod [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                            {},
		"[sig-storage] Projected secret should be consumable from pods in volume with mappings and Item Mode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                         {},
		"[sig-storage] Projected secret should be consumable from pods in volume with mappings [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-storage] Projected secret should be consumable from pods in volume with defaultMode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-storage] Projected secret should be consumable from pods in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                     {},
		"[sig-storage] Projected secret should be able to mount in a volume regardless of a different secret existing with same name in different namespace [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                {},
		"[sig-storage] Projected downwardAPI should provide podname as non-root with fsgroup and defaultMode [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-storage] Projected downwardAPI should provide node allocatable (memory) as default memory limit if the limit is not set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                {},
		"[sig-storage] Projected configMap should be consumable in multiple volumes in the same pod [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] Projected configMap should be consumable from pods in volume as non-root with FSGroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-storage] Projected configMap should be consumable from pods in volume as non-root [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] Projected configMap should be consumable from pods in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                  {},
		"[sig-storage] Projected configMap optional updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                            {},
		"[sig-storage] PersistentVolumes-local  [Volume type: tmpfs] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] PersistentVolumes-local  [Volume type: tmpfs] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link-bindmounted] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-bindmounted] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithformat] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                      {},
		"[sig-storage] PersistentVolumes NFS with Single PV - PVC pairs create a PV and a pre-bound PVC: test write access [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] files with FSGroup ownership should support (root,0644,tmpfs) [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                            {},
		"[sig-storage] EmptyDir volumes volume on default medium should have the correct mode [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-storage] EmptyDir volumes should support (non-root,0644,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                             {},
		"[sig-storage] EmptyDir volumes should support (non-root,0644,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] EmptyDir volumes pod should support shared volumes between containers [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                           {},
		"[sig-storage] Downward API volume should set mode on item file [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                  {},
		"[sig-storage] Downward API volume should provide podname as non-root with fsgroup and defaultMode [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] Downward API volume should provide podname as non-root with fsgroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                 {},
		"[sig-storage] Downward API volume should provide node allocatable (memory) as default memory limit if the limit is not set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] ConfigMap should be consumable from pods in volume with mappings as non-root with FSGroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] ConfigMap should be consumable from pods in volume with mappings [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                              {},
		"[sig-storage] ConfigMap should be consumable from pods in volume with defaultMode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                           {},
		"[sig-storage] ConfigMap optional updates should be reflected in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                      {},
		"[sig-storage] CSI mock volume storage capacity exhausted, late binding, no topology [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                 {},
		"[sig-storage] CSI mock volume CSI attach test using mock driver should not require VolumeAttach for drivers without attachment [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] CSI mock volume CSI Volume expansion should expand volume by restarting pod if attach=off, nodeExpansion=on [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] CSI mock volume CSI FSGroupPolicy [LinuxOnly] should modify fsGroup if fsGroupPolicy=File [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                             {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: CSI Ephemeral-volume (default fs)] ephemeral should create read/write inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                        {},
		"[sig-node] Downward API should provide default limits.cpu/memory from node allocatable [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-imageregistry][Feature:Image] oc tag should preserve image reference for external images [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                   {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestSimpleImageChangeBuildTriggerFromImageStreamTagDockerWithConfigChange [Suite:openshift/conformance/parallel]":                                                                                                                                                                {},
		"[sig-imageregistry][Feature:ImageTriggers] Image change build triggers TestMultipleImageChangeBuildTriggers [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                     {},
		"[sig-imageregistry][Feature:ImageLookup] Image policy should perform lookup when the object has the resolve-names annotation [Suite:openshift/conformance/parallel]":                                                                                                                                                                                    {},
		"[sig-imageregistry][Feature:ImageLayers] Image layer subresource should identify a deleted image as missing [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                     {},
		"[sig-devex][Feature:Templates] templateinstance security tests  should pass security tests [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                      {},
		"[sig-devex][Feature:Templates] templateinstance impersonation tests should pass impersonation update tests [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                      {},
		"[sig-devex][Feature:Templates] templateinstance impersonation tests should pass impersonation deletion tests [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                    {},
		"[sig-devex][Feature:Templates] templateinstance impersonation tests should pass impersonation creation tests [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                    {},
		"[sig-devex][Feature:Templates] template-api TestTemplateTransformationFromConfig [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                {},
		"[sig-cli] oc explain should contain spec+status for builtinTypes [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                                {},
		"[sig-cli] oc explain list uncovered GroupVersionResources [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                                       {},
		"[sig-cli] oc debug does not require a real resource on the server [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                               {},
		"[sig-cli] oc adm who-can [Suite:openshift/conformance/parallel]":                                                                                 {},
		"[sig-cli] oc adm role-reapers [Suite:openshift/conformance/parallel]":                                                                            {},
		"[sig-cli] oc adm policy [Suite:openshift/conformance/parallel]":                                                                                  {},
		"[sig-cli] oc adm node-logs [Suite:openshift/conformance/parallel]":                                                                               {},
		"[sig-cli] oc adm images [Suite:openshift/conformance/parallel]":                                                                                  {},
		"[sig-cli] oc adm groups [Suite:openshift/conformance/parallel]":                                                                                  {},
		"[sig-cli] Kubectl client Kubectl expose should create services for rc  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]": {},
		"[sig-cli] Kubectl client Kubectl describe should check if kubectl describe prints relevant information for rc and pods  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                               {},
		"[sig-cli] Kubectl client Kubectl copy should copy a file from a running Pod [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-cli] Kubectl Port forwarding With a server listening on localhost that expects a client request should support a client that connects, sends NO DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                  {},
		"[sig-cli] Kubectl Port forwarding With a server listening on localhost that expects a client request should support a client that connects, sends DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                     {},
		"[sig-cli] Kubectl Port forwarding With a server listening on 0.0.0.0 that expects a client request should support a client that connects, sends DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                       {},
		"[sig-auth][Feature:UserAPI] users can manipulate groups [Suite:openshift/conformance/parallel]":                                                                                                                                                                                 {},
		"[sig-auth][Feature:SecurityContextConstraints]  TestAllowedSCCViaRBAC [Suite:openshift/conformance/parallel]":                                                                                                                                                                   {},
		"[sig-auth][Feature:RoleBindingRestrictions] RoleBindingRestrictions should be functional  Create a rolebinding when subject is already bound should succeed [Suite:openshift/conformance/parallel]":                                                                             {},
		"[sig-auth][Feature:ProjectAPI]  TestProjectWatchWithSelectionPredicate should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                   {},
		"[sig-auth][Feature:ProjectAPI]  TestInvalidRoleRefs should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                      {},
		"[sig-auth][Feature:OpenShiftAuthorization] scopes TestUnknownScopes should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                      {},
		"[sig-auth][Feature:OpenShiftAuthorization] scopes TestTokensWithIllegalScopes should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                            {},
		"[sig-auth][Feature:OpenShiftAuthorization] scopes TestScopeEscalations should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                   {},
		"[sig-auth][Feature:OpenShiftAuthorization] authorization  TestBrowserSafeAuthorizer should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                      {},
		"[sig-auth][Feature:OpenShiftAuthorization] RBAC proxy for openshift authz  RunLegacyEndpointConfirmNoEscalation should succeed [Suite:openshift/conformance/parallel]":                                                                                                          {},
		"[sig-auth][Feature:OAuthServer] [Token Expiration] Using a OAuth client with a non-default token max age to generate tokens that do not expire works as expected when using a token authorization flow [Suite:openshift/conformance/parallel]":                                  {},
		"[sig-auth][Feature:Authentication]  TestFrontProxy should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                       {},
		"[sig-arch] [Conformance] FIPS TestFIPS [Suite:openshift/conformance/parallel/minimal]":                                                                                                                                                                                          {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestTriggers_manual [Suite:openshift/conformance/parallel]":                                                                                                                                                                      {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestTriggers_MultipleICTs [Suite:openshift/conformance/parallel]":                                                                                                                                                                {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs ignores deployer and lets the config with a NewReplicationControllerCreated reason should let the deployment config with a NewReplicationControllerCreated reason [Suite:openshift/conformance/parallel]":                {},
		"[sig-apps] DisruptionController evictions: too few pods, absolute => should not allow an eviction [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-apps] DisruptionController evictions: no PDB => should allow an eviction [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                               {},
		"[sig-apps] DisruptionController evictions: maxUnavailable allow single eviction, percentage => should allow an eviction [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                     {},
		"[sig-apps] Deployment deployment should delete old replica sets [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                       {},
		"[sig-apps] Deployment RecreateDeployment should delete old pods and create new ones [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                   {},
		"[sig-apps] CronJob should delete successful finished jobs with limit of one successful job [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for apps.openshift.io/v1, Resource=deploymentconfigs [Suite:openshift/conformance/parallel]":                                                                                                         {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should unconditionally reject operations on fail closed webhook [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                        {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should mutate pod and apply defaults after mutation [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                    {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should mutate configmap [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] listing validating webhooks should work [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] listing mutating webhooks should work [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                  {},
		"[sig-api-machinery] APIServer CR fields validation additionalCORSAllowedOrigins [Suite:openshift/conformance/parallel]":                                                                                                                                                         {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithformat] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                          {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                        {},
		"[sig-storage] HostPath should give a volume the correct mode [LinuxOnly] [NodeConformance] [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                               {},
		"[sig-node] [Feature:Example] Downward API should create a pod that prints his name and namespace [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-node] Security Context when creating containers with AllowPrivilegeEscalation should allow privilege escalation when true [LinuxOnly] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                {},
		"[sig-node] Security Context should support pod.Spec.SecurityContext.RunAsUser And pod.Spec.SecurityContext.RunAsGroup [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                     {},
		"[sig-node] Security Context should support container.SecurityContext.RunAsUser And container.SecurityContext.RunAsGroup [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                   {},
		"[sig-node] Security Context When creating a pod with privileged should run the container as privileged when true [LinuxOnly] [NodeFeature:HostAccess] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-node] Security Context When creating a container with runAsUser should run the container with uid 65534 [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                            {},
		"[sig-node] Security Context When creating a container with runAsNonRoot should not run without a specified user ID [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                          {},
		"[sig-node] Secrets should be consumable via the environment [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                         {},
		"[sig-node] Probing container should not be ready with an exec readiness probe timeout [MinimumKubeletVersion:1.20] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-node] Probing container should be restarted with a local redirect http liveness probe [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-node] Probing container should be restarted with a failing exec liveness probe that took longer than the timeout [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                       {},
		"[sig-node] Probing container should be ready immediately after startupProbe succeeds [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                        {},
		"[sig-node] Pods should support retrieving logs from the container over websockets [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                   {},
		"[sig-node] Pods should support remote command execution over websockets [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                             {},
		"[sig-node] Pods should support pod readiness gates [NodeFeature:PodReadinessGate] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                           {},
		"[sig-node] Pods should be updated [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-node] Pods should allow activeDeadlineSeconds to be updated [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                    {},
		"[sig-node] Pods Extended Pod Container Status should never report success for a pending container [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-node] Mount propagation should propagate mounts to the host [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-node] InitContainer [NodeConformance] should invoke init containers on a RestartAlways pod [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                       {},
		"[sig-node] Container Runtime blackbox test when starting a container that exits should run with the expected status [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                 {},
		"[sig-node] Container Runtime blackbox test on terminated container should report termination message [LinuxOnly] if TerminationMessagePath is set [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                         {},
		"[sig-node] Container Lifecycle Hook when create a pod with lifecycle hook should execute prestop http hook properly [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                 {},
		"[sig-node] Container Lifecycle Hook when create a pod with lifecycle hook should execute prestop exec hook properly [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                 {},
		"[sig-node] Container Lifecycle Hook when create a pod with lifecycle hook should execute poststart exec hook properly [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                               {},
		"[sig-auth][Feature:OAuthServer] well-known endpoint should be reachable [Suite:openshift/conformance/parallel]":                                                                                                                                                                 {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the token request URL [Suite:openshift/conformance/parallel]":                                                                                                                                          {},
		"[sig-apps] ReplicaSet Replicaset should have a working scale subresource [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                              {},
		"[sig-apps] Deployment Deployment should have a working scale subresource [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                              {},
		"[sig-apps] [Feature:TTLAfterFinished] job should be deleted once it finishes after TTL seconds [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                              {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should not allow access by TCP when a policy specifies only SCTP [Feature:NetworkPolicy] [Feature:SCTP] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Networking Granular Checks: Services should function for node-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-network] Networking Granular Checks: Services should be able to handle large requests: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                             {},
		"[sig-network] Networking Granular Checks: Services should function for endpoint-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-network][Feature:Router] The HAProxy router should expose a health check on the metrics port [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs when tagging images should successfully tag the deployed image [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                            {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs viewing rollout history should print the rollout history [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                  {},
		"[sig-instrumentation] Prometheus when installed on the cluster should have important platform topology metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                   {},
		"[sig-cli] oc rsh specific flags should work well when access to a remote shell [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                   {},
		"[sig-builds][Feature:Builds] prune builds based on settings in the buildconfig  should prune errored builds based on the failedBuildsHistoryLimit setting [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                        {},
		"[sig-builds][Feature:Builds] prune builds based on settings in the buildconfig  should prune canceled builds based on the failedBuildsHistoryLimit setting [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                       {},
		"[sig-builds][Feature:Builds] prune builds based on settings in the buildconfig  buildconfigs should have a default history limit set when created via the group api [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                              {},
		"[sig-auth][Feature:SecurityContextConstraints]  TestPodDefaultCapabilities [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                       {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with test deployments should run a deployment to completion and then scale to zero [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                        {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with custom deployments should run the custom deployment steps [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                            {},
		"[sig-network][Feature:Router] The HAProxy router should support reencrypt to services backed by a serving certificate automatically [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                              {},
		"[sig-imageregistry][Feature:ImageExtract] Image extract should extract content from an image [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                     {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (filesystem volmode)] volumeLimits should support volume limits [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                            {},
		"[sig-arch] Managed cluster should should expose cluster services outside the cluster [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                             {},
		"operator install storage":                       {},
		"operator install operator-lifecycle-manager":    {},
		"operator conditions operator-lifecycle-manager": {},
		"operator conditions csi-snapshot-controller":    {},
		"[sig-network][Feature:Router] The HAProxy router should set Forwarded headers appropriately [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                                                       {},
		"[sig-storage] CSI mock volume CSI Volume expansion should not expand volume if resizingOnDriver=off, resizingOnSC=on [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                         {},
		"[sig-storage] CSI mock volume CSI Volume expansion should expand volume without restarting pod if nodeExpansion=off [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                          {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Pre-provisioned Snapshot (retain policy)] snapshottable[Feature:VolumeSnapshotDataSource] volume snapshot controller  should check snapshot fields, check restore correctly works after modifying source data, check deletion [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                              {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with snapshot data source [Feature:VolumeSnapshotDataSource] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                   {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                          {},
		"[sig-api-machinery] API data in etcd should be stored at the correct location and version for all resources [Serial] [Suite:openshift/conformance/serial]":                                                                                                                                                                                       {},
		"[sig-network] multicast when using one of the OpenshiftSDN modes 'redhat/openshift-ovs-multitenant, redhat/openshift-ovs-networkpolicy' should allow multicast traffic in namespaces where it is enabled [Suite:openshift/conformance/parallel]":                                                                                                 {},
		"[sig-cluster-lifecycle] Cluster completes upgrade":                                     {},
		"[sig-network-edge] Application behind service load balancer with PDB is not disrupted": {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for multiple CRDs of same group but different versions [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                               {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for CRD with validation schema [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                       {},
		"[sig-network] HostPort validates that there is no conflict between pods with same hostPort but different hostIP and protocol [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                              {},
		"[sig-network] DNS should provide DNS for the cluster  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-network] DNS should provide DNS for pods for Hostname [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                {},
		"[sig-auth] [Feature:NodeAuthenticator] The kubelet's main port 10250 should reject requests with no credentials [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                          {},
		"[sig-node] Managed cluster should report ready nodes the entire duration of the test run [Late] [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                  {},
		"[sig-storage] PVC Protection Verify that scheduling of a pod that uses PVC that is being deleted fails and the pod becomes Unschedulable [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                    {},
		"[sig-network][Feature:Router] The HAProxy router converges when multiple routers are writing status [Suite:openshift/conformance/parallel]":                                                                                                                                     {},
		"[sig-network] Networking Granular Checks: Pods should function for node-pod communication: udp [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                          {},
		"[sig-storage] Subpath Container restart should verify that container can restart successfully after configmaps modified [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                     {},
		"[sig-storage] Subpath Atomic writer volumes should support subpaths with projected pod [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] Subpath Atomic writer volumes should support subpaths with configmap pod with mountPath of existing file [LinuxOnly] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                    {},
		"[sig-storage] Secrets should be consumable from pods in volume with mappings and Item Mode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                          {},
		"[sig-storage] Secrets should be consumable from pods in volume as non-root with defaultMode and fsGroup set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                             {},
		"[sig-storage] Secrets should be consumable from pods in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                      {},
		"[sig-storage] Projected downwardAPI should provide podname only [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                     {},
		"[sig-storage] Projected configMap should be consumable from pods in volume with mappings as non-root [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link-bindmounted] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                           {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithoutformat] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithformat] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                               {},
		"[sig-storage] PersistentVolumes-local  [Volume type: block] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                           {},
		"[sig-storage] PersistentVolumes NFS with multiple PVs and PVCs all in same ns should create 2 PVs and 4 PVCs: test write access [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Inline-volume (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                       {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                   {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                       {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                      {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                    {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":         {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                        {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                          {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                              {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: hostPath] [Testpattern: Inline-volume (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: hostPathSymlink] [Testpattern: Inline-volume (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                      {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support readOnly directory specified in the volumeMount [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                           {},
		"[sig-storage] HostPath should support r/w [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-storage] EmptyDir volumes when FSGroup is specified [LinuxOnly] [NodeFeature:FSGroup] volume on tmpfs should have the correct mode using FSGroup [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-storage] EmptyDir volumes should support (root,0666,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                       {},
		"[sig-storage] EmptyDir volumes should support (root,0644,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] EmptyDir volumes should support (non-root,0777,default) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                   {},
		"[sig-storage] Downward API volume should provide node allocatable (cpu) as default cpu limit if the limit is not set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                {},
		"[sig-storage] Downward API volume should provide container's memory limit [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                           {},
		"[sig-storage] ConfigMap should be consumable in multiple volumes in the same pod [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                    {},
		"[sig-storage] ConfigMap should be consumable from pods in volume with mappings as non-root [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                          {},
		"[sig-storage] ConfigMap should be consumable from pods in volume as non-root with defaultMode and fsGroup set [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                             {},
		"[sig-storage] ConfigMap should be consumable from pods in volume [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                    {},
		"[sig-storage] CSI mock volume storage capacity exhausted, immediate binding [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                 {},
		"[sig-storage] CSI mock volume CSI FSGroupPolicy [LinuxOnly] should not modify fsGroup if fsGroupPolicy=None [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                 {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: CSI Ephemeral-volume (default fs)] ephemeral should support two pods which share the same volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                             {},
		"[sig-node] should override timeoutGracePeriodSeconds when annotation is set [Suite:openshift/conformance/parallel]":                                                                                                                                                             {},
		"[sig-node] Downward API should provide pod name, namespace and IP address as env vars [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                               {},
		"[sig-node] Downward API should provide container's limits.cpu/memory and requests.cpu/memory as env vars [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                            {},
		"[sig-imageregistry][Feature:ImageLookup] Image policy should perform lookup when the Deployment gets the resolve-names annotation later [Suite:openshift/conformance/parallel]":                                                                                                 {},
		"[sig-cluster-lifecycle] CSRs from machines that are not recognized by the cloud provider are not approved [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-cli] oc debug dissect deployment config debug [Suite:openshift/conformance/parallel]":                                                                                                                                                                                      {},
		"[sig-cli] oc adm storage-admin [Suite:openshift/conformance/parallel]":                                                                                                                                                                        {},
		"[sig-cli] oc adm role-selectors [Suite:openshift/conformance/parallel]":                                                                                                                                                                       {},
		"[sig-cli] Kubectl client Simple pod should support port-forward [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-cli] Kubectl client Simple pod should support exec using resource/name [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                               {},
		"[sig-cli] Kubectl client Simple pod should support exec through kubectl proxy [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                             {},
		"[sig-cli] Kubectl client Kubectl replace should update a single-container pod's image  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                              {},
		"[sig-cli] Kubectl Port forwarding With a server listening on 0.0.0.0 that expects a client request should support a client that connects, sends NO DATA, and disconnects [Suite:openshift/conformance/parallel] [Suite:k8s]":                  {},
		"[sig-builds][Feature:Builds][webhook] TestWebhookGitHubPushWithImageStream [Suite:openshift/conformance/parallel]":                                                                                                                            {},
		"[sig-auth][Feature:OpenShiftAuthorization] RBAC proxy for openshift authz  RunLegacyClusterRoleEndpoint should succeed [Suite:openshift/conformance/parallel]":                                                                                {},
		"[sig-auth][Feature:OAuthServer] [Token Expiration] Using a OAuth client with a non-default token max age to generate tokens that do not expire works as expected when using a code authorization flow [Suite:openshift/conformance/parallel]": {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the grant URL [Suite:openshift/conformance/parallel]":                                                                                                                {},
		"[sig-auth][Feature:OAuthServer] OAuth server has the correct token and certificate fallback semantics [Suite:openshift/conformance/parallel]":                                                                                                 {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs initially should not deploy if pods never transition to ready [Suite:openshift/conformance/parallel]":                                                                                  {},
		"[sig-apps] ReplicationController should adopt matching pods on creation [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                             {},
		"[sig-apps] ReplicaSet should serve a basic image on each replica with a public image  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                               {},
		"[sig-apps] Job should remove pods when job is deleted [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-apps] Job should delete a job [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                  {},
		"[sig-apps] Job should adopt matching orphans and release non-matching pods [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                          {},
		"[sig-apps] Deployment deployment reaping should cascade to its replica sets and pods [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                      {},
		"[sig-api-machinery][Feature:ServerSideApply] Server-Side Apply should work for template.openshift.io/v1, Resource=templateinstances [Suite:openshift/conformance/parallel]":                                                                   {},
		"[sig-api-machinery][Feature:ResourceQuota] Object count should properly count the number of imagestreams resources [Suite:openshift/conformance/parallel]":                                                                                    {},
		"[sig-api-machinery][Feature:APIServer] anonymous browsers should get a 403 from / [Suite:openshift/conformance/parallel]":                                                                                                                     {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should mutate custom resource with pruning [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                           {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should include webhook resources in discovery documents [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                              {},
		"operator install operator-lifecycle-manager-catalog": {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector or NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"operator conditions operator-lifecycle-manager-catalog": {},
		"[sig-network] Proxy version v1 A set of valid responses are returned for both pod and service ProxyWithPath [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                           {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should not deadlock when a pod's predecessor fails [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link] One pod requesting one prebound PVC should be able to mount volume and read from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithoutformat] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                {},
		"[sig-storage] CSI mock volume CSIStorageCapacity CSIStorageCapacity used, no capacity [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                       {},
		"[sig-node] [Feature:Example] Secret should create a pod that reads a secret [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                 {},
		"[sig-node] Variable Expansion should allow composing env vars into new env vars [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                     {},
		"[sig-node] Security Context should support seccomp runtime/default [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                              {},
		"[sig-node] Security Context should support seccomp default which is unconfined [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                  {},
		"[sig-node] Security Context When creating a container with runAsNonRoot should run with an image specified user ID [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-node] Security Context When creating a container with runAsNonRoot should run with an explicit non-root user ID [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-node] Secrets should be consumable from pods in env vars [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                       {},
		"[sig-node] Probing container should *not* be restarted with a non-local redirect http liveness probe [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                        {},
		"[sig-node] Probing container should *not* be restarted with a /healthz http liveness probe [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                          {},
		"[sig-node] Probing container should *not* be restarted by liveness probe because startup probe delays it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-node] PrivilegedPod [NodeConformance] should enable privileged commands [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-node] PreStop should call prestop when killing a pod  [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-node] Pods should run through the lifecycle of Pods and PodStatus [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                {},
		"[sig-node] Pods should be submitted and removed [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                     {},
		"[sig-node] KubeletManagedEtcHosts should test kubelet managed /etc/hosts file [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                           {},
		"[sig-node] InitContainer [NodeConformance] should invoke init containers on a RestartNever pod [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-node] Container Runtime blackbox test when running a container with a new image should not be able to pull from private registry without secret [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                      {},
		"[sig-cli] oc adm must-gather when looking at the audit logs [sig-node] kubelet runs apiserver processes strictly sequentially in order to not risk audit log corruption [Suite:openshift/conformance/parallel]":                                                                                 {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should perform rolling updates and roll backs of template modifications [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                     {},
		"[sig-apps] DisruptionController should update/patch PodDisruptionBudget status [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                        {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should not allow access by TCP when a policy specifies only SCTP [Feature:NetworkPolicy] [Feature:SCTP] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":          {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce multiple ingress policies with ingress allow-all policy taking precedence [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Networking Granular Checks: Services should function for pod-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                     {},
		"[sig-network] Networking Granular Checks: Services should function for multiple endpoint-Services with same selector [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-network] Networking Granular Checks: Services should function for endpoint-Service: udp [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with env in params referencing the configmap should expand the config map key to a value [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                  {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs should respect image stream tag reference policy resolve the image pull spec [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                              {},
		"[sig-cluster-lifecycle] Pods cannot access the /config/master API endpoint [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                       {},
		"[sig-network][Feature:Router] The HAProxy router should override the route host with a custom value [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                              {},
		"[sig-network][Feature:Router] The HAProxy router should expose the profiling endpoints [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                           {},
		"[sig-network][Feature:Router] The HAProxy router should expose prometheus metrics for a route [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                    {},
		"[sig-network][Feature:Router] The HAProxy router should enable openshift-monitoring to pull metrics [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                              {},
		"[sig-builds][Feature:Builds][valueFrom] process valueFrom in build strategy environment variables  should fail resolving unresolvable valueFrom in sti build environment variable references [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                     {},
		"[sig-builds][Feature:Builds][valueFrom] process valueFrom in build strategy environment variables  should fail resolving unresolvable valueFrom in docker build environment variable references [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                  {},
		"[sig-builds][Feature:Builds] oc new-app  should succeed with an imagestream [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                      {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with revision history limits should never persist more old deployments than acceptable after being observed by the controller [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                             {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs when run iteratively should only deploy the last deployment [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                               {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs  should adhere to Three Laws of Controllers [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                               {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with multiple image change triggers should run a successful deployment with a trigger used by different containers [Suite:openshift/conformance/parallel]":                                                                               {},
		"[sig-builds][Feature:Builds] clone repository using git:// protocol  should clone using git:// if no proxy is configured [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                         {},
		"operator conditions machine-config": {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for CRD without validation schema [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                          {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] removes definition from spec when one version gets changed to not be served [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                      {},
		"[sig-cluster-lifecycle][Feature:Machines][Early] Managed cluster should have same number of Machines and Nodes [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (delayed binding)] topology should provision a volume and schedule a pod with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, new pod fsgroup applied to volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (immediate binding)] topology should provision a volume and schedule a pod with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] provisioning should provision storage with mount options [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                       {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup skips ownership changes to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (OnRootMismatch)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with different fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                    {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (block volmode)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-network] Services should be rejected when no endpoints exist [Skipped:ibmcloud] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                              {},
		"[sig-network] Networking Granular Checks: Pods should function for node-pod communication: http [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                               {},
		"[sig-storage] Projected downwardAPI should provide node allocatable (cpu) as default cpu limit if the limit is not set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] Projected downwardAPI should provide container's cpu request [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                {},
		"[sig-storage] Projected configMap should be consumable from pods in volume with mappings and Item mode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] Projected configMap should be consumable from pods in volume as non-root with defaultMode and fsGroup set [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link-bindmounted] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                              {},
		"[sig-storage] PersistentVolumes-local  [Volume type: blockfswithformat] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] PersistentVolumes-local  [Volume type: block] Two pods mounting a local volume at the same time should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                {},
		"[sig-storage] PersistentVolumes NFS with Single PV - PVC pairs create a PVC and non-pre-bound PV: test write access [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                   {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: tmpfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                 {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support non-existent path [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directories when readOnly specified in the volumeSource [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                      {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support readOnly file specified in the volumeMount [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: emptydir] [Testpattern: Inline-volume (default fs)] subPath should support existing single file [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-storage] EmptyDir volumes should support (non-root,0777,tmpfs) [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] Downward API volume should set DefaultMode on files [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                             {},
		"[sig-storage] ConfigMap should be consumable from pods in volume as non-root with FSGroup [LinuxOnly] [NodeFeature:FSGroup] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                       {},
		"[sig-storage] CSI Volumes [Driver: csi-hostpath] [Testpattern: CSI Ephemeral-volume (default fs)] ephemeral should create read-only inline ephemeral volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                       {},
		"[sig-cli] Kubectl client Simple pod should support exec through an HTTP proxy [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                     {},
		"[sig-auth][Feature:OpenShiftAuthorization] authorization  TestAuthorizationSubjectAccessReview should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                 {},
		"[sig-auth][Feature:OpenShiftAuthorization] The default cluster RBAC policy should have correct RBAC rules [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                     {},
		"[sig-auth][Feature:OAuthServer] [Token Expiration] Using a OAuth client with a non-default token max age to generate tokens that expire shortly works as expected when using a token authorization flow [Suite:openshift/conformance/parallel]":                                                                                                       {},
		"[sig-auth][Feature:OAuthServer] [Token Expiration] Using a OAuth client with a non-default token max age to generate tokens that expire shortly works as expected when using a code authorization flow [Suite:openshift/conformance/parallel]":                                                                                                        {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the authorize URL [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                    {},
		"[sig-apps][Feature:OpenShiftControllerManager] TestDeployScale [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                                {},
		"[sig-apps] DisruptionController evictions: enough pods, replicaSet, percentage => should allow an eviction [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                        {},
		"[sig-apps] Deployment iterative rollouts should eventually progress [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                               {},
		"[sig-api-machinery] Aggregator Should be able to support the 1.17 Sample API Server using the current Aggregator [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should honor timeout [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                         {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should be able to deny custom resource creation, update and deletion [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (immediate binding)] topology should fail to schedule a pod which has topologies that conflict with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                        {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic only from a different namespace, based on NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy based on Ports [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                           {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should allow ingress access from updated namespace [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-api-machinery][Feature:ClusterResourceQuota] Cluster resource quota should control resource limits across namespaces [Suite:openshift/conformance/parallel]":                                                                                                                                                                                     {},
		"[sig-storage] PersistentVolumes-local  [Volume type: tmpfs] One pod requesting one prebound PVC should be able to mount volume and write from pod1 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-bindmounted] [Testpattern: Pre-provisioned PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                 {},
		"[sig-node] Security Context should support pod.Spec.SecurityContext.RunAsUser [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                         {},
		"[sig-node] Security Context When creating a pod with readOnlyRootFilesystem should run the container with readonly rootfs when readOnlyRootFilesystem=true [LinuxOnly] [NodeConformance] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                          {},
		"[sig-node] Security Context When creating a container with runAsNonRoot should not run with an explicit root user ID [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-node] Probing container should be restarted startup probe fails [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                              {},
		"[sig-node] Probing container should *not* be restarted with a exec \"cat /tmp/health\" liveness probe [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                     {},
		"[sig-node] Kubelet when scheduling a busybox command in a pod should print the output to logs [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-node] Kubelet when scheduling a busybox Pod with hostAliases should write entries to /etc/hosts [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                          {},
		"[sig-node] InitContainer [NodeConformance] should not start app containers if init containers fail on a RestartAlways pod [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                   {},
		"[sig-node] Docker Containers should be able to override the image's default arguments (docker cmd) [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                        {},
		"[sig-node] Container Runtime blackbox test on terminated container should report termination message [LinuxOnly] from file when pod succeeds and TerminationMessagePolicy FallbackToLogsOnError is set [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                    {},
		"[sig-auth][Feature:LDAP] LDAP should start an OpenLDAP test server [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                                            {},
		"[sig-auth] ServiceAccounts ServiceAccountIssuerDiscovery should support OIDC discovery of service account issuer [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                            {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should implement legacy replacement when the update strategy is OnDelete [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                {},
		"[sig-network] Networking Granular Checks: Services should support basic nodePort: udp functionality [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                               {},
		"[sig-network] Networking Granular Checks: Services should function for node-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                         {},
		"[sig-network] network isolation when using OpenshiftSDN in a mode that does not isolate namespaces by default should allow communication between pods in different namespaces on different nodes [Suite:openshift/conformance/parallel]":                                                                                                              {},
		"[sig-network] Networking Granular Checks: Services should function for pod-Service: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                          {},
		"operator install openshift-controller-manager":    {},
		"operator install dns":                             {},
		"operator conditions openshift-controller-manager": {},
		"[sig-apps] Deployment should not disrupt a cloud load-balancer's connectivity during rollout [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                        {},
		"[sig-network][Feature:Router] The HAProxy router should run even if it has no access to update status [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                    {},
		"[sig-network][Feature:Router] The HAProxy router should serve the correct routes when scoped to a single namespace and label set [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                         {},
		"[sig-network][Feature:Router] The HAProxy router should serve a route that points to two services and respect weights [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                    {},
		"[sig-network][Feature:Router] The HAProxy router should override the route host for overridden domains with a custom value [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                               {},
		"[sig-builds][Feature:Builds] prune builds based on settings in the buildconfig  should prune failed builds based on the failedBuildsHistoryLimit setting [Skipped:Disconnected] [Suite:openshift/conformance/parallel]": {},
		"[sig-builds][Feature:Builds] prune builds based on settings in the buildconfig  should prune builds after a buildConfig change [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                           {},
		"[sig-builds][Feature:Builds] oc new-app  should fail with a --name longer than 58 characters [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                             {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with minimum ready seconds set should not transition the deployment to Complete before satisfied [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":  {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with failing hook should get all logs from retried hooks [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                          {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs when changing image change trigger should successfully trigger from an updated image [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":              {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs keep the deployer pod invariant valid should deal with cancellation after deployer pod succeeded [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":  {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs adoption will orphan all RCs and adopt them back when recreated [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                   {},
		"[sig-cluster-lifecycle] ClusterOperators are available and not degraded after upgrade":                                                                                                                                  {},
		"[sig-instrumentation] Prometheus when installed on the cluster should report telemetry if a cloud.openshift.com token is present [Late] [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                  {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] works for CRD preserving unknown fields at the schema root [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":         {},
		"[sig-api-machinery] CustomResourcePublishOpenAPI [Privileged:ClusterAdmin] updates the published spec when one version gets renamed [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":           {},
		"[sig-auth][Feature:LDAP][Serial] ldap group sync can sync groups from ldap [Suite:openshift/conformance/serial]":                                                                                                        {},
		"operator install machine-api": {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                     {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (ext3)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (delayed binding)] topology should provision a volume and schedule a pod with AllowedTopologies [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                    {},
		"[sig-storage] PersistentVolumes GCEPD should test that deleting the PV before the pod does not cause pod deletion to fail on PD detach [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                    {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (ext3)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                          {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (ext3)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Inline-volume (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)] fsgroupchangepolicy (Always)[LinuxOnly], pod created with an initial fsgroup, volume contents ownership changed in first pod, new pod with same fsgroup applied to the volume contents [Suite:openshift/conformance/parallel] [Suite:k8s]":                               {},
		"[sig-devex][Feature:Templates] templateinstance readiness test  should report failed soon after an annotated objects has failed [Suite:openshift/conformance/parallel]":                                                                                                                                                                                       {},
		"[sig-devex] check registry.redhat.io is available and samples operator can import sample imagestreams run sample related validations [Suite:openshift/conformance/parallel]":                                                                                                                                                                                  {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with multiple image change triggers should run a successful deployment with multiple triggers [Suite:openshift/conformance/parallel]":                                                                                                                                                                  {},
		"[sig-network][Feature:Router] The HAProxy router converges when multiple routers are writing conflicting status [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                       {},
		"[sig-network] Services should create endpoints for unready pods [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                                           {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-link] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                  {},
		"[sig-storage] PersistentVolumes-local  [Volume type: dir-bindmounted] Two pods mounting a local volume one after the other should be able to write from pod1 and read from pod2 [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                           {},
		"[sig-storage] PersistentVolumes NFS with multiple PVs and PVCs all in same ns should create 3 PVs and 3 PVCs: test write access [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link-bindmounted] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: blockfs] [Testpattern: Pre-provisioned PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                               {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (ext4)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: block] [Testpattern: Pre-provisioned PV (block volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                             {},
		"[sig-storage] EmptyDir wrapper volumes should not conflict [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                                          {},
		"[sig-storage] ConfigMap should be consumable from pods in volume with mappings and Item mode set [LinuxOnly] [NodeConformance] [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                      {},
		"[sig-imageregistry][Feature:ImageLookup] Image policy should update standard Kube object image fields when local names are on [Suite:openshift/conformance/parallel]":                                                                                                                                                                                         {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the login URL for when there is only one IDP [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                 {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the login URL for the bootstrap IDP [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                          {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs keep the deployer pod invariant valid should deal with cancellation of running deployment [Suite:openshift/conformance/parallel]":                                                                                                                                                                      {},
		"[sig-apps] Deployment deployment should support proportional scaling [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                                                {},
		"[sig-apps] Deployment RollingUpdateDeployment should delete old pods and create new ones [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                            {},
		"[sig-apps] CronJob should delete failed finished jobs with limit of one job [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                               {},
		"[sig-api-machinery] AdmissionWebhook [Privileged:ClusterAdmin] should deny crd creation [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                                                                                             {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy based on NamespaceSelector with MatchExpressions[Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                  {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should allow ingress access from updated pod [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: local][LocalVolumeType: dir-link] [Testpattern: Pre-provisioned PV (default fs)] subPath should support existing directory [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                         {},
		"[sig-node] Probing container should override timeoutGracePeriodSeconds when StartupProbe field is set [Feature:ProbeTerminationGracePeriod] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                               {},
		"[sig-node] Probing container should be restarted by liveness probe after startup probe enables it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                         {},
		"[sig-cli] Kubectl client Simple pod should support inline execution and attach [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                            {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should perform canary updates and phased rolling updates of template modifications [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                                                                                                                        {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce updated policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic only from a pod in a different namespace based on PodSelector and NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                             {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on Ports [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                          {},
		"[sig-network] Netpol [Feature:UDPConnectivity][LinuxOnly] NetworkPolicy between server and client using UDP should enforce policy to allow traffic only from a pod in a different namespace based on PodSelector and NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Networking Granular Checks: Services should update endpoints: http [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                                                                          {},
		"operator install cluster-autoscaler":    {},
		"operator conditions storage":            {},
		"operator conditions machine-api":        {},
		"operator conditions cluster-autoscaler": {},
		"[sig-network-edge][Conformance][Area:Networking][Feature:Router] The HAProxy router should be able to connect to a service that is idled because a GET on the route will unidle it [Skipped:Disconnected] [Suite:openshift/conformance/parallel/minimal]": {},
		"[sig-scheduling] Multi-AZ Clusters should spread the pods of a service across zones [Serial] [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                            {},
		"[sig-imageregistry][Feature:ImageTriggers] Annotation trigger reconciles after the image is overwritten [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                    {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs won't deploy RC with unresolved images when patched with empty image [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should provide basic identity [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                               {},
		"[sig-apps] StatefulSet Basic StatefulSet functionality [StatefulSetBasic] should perform rolling updates and roll backs of template modifications with PVCs [Suite:openshift/conformance/parallel] [Suite:k8s]":                                           {},
		"[sig-network] pods should successfully create sandboxes by writing network status":                                                                                                                                                                        {},
		"operator install baremetal": {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should ensure an IP overlapping both IPBlock.CIDR and IPBlock.Except is allowed [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Skipped:Network/OpenShiftSDN] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Services should allow pods to hairpin back to themselves through services [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                                           {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: nfs] [Testpattern: Dynamic PV (default fs)] subPath should support file as subpath [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                             {},
		"[sig-cli] oc adm must-gather runs successfully with options [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                                   {},
		"[sig-cli] Kubectl Port forwarding With a server listening on 0.0.0.0 should support forwarding over websockets [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                                    {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the token URL [Suite:openshift/conformance/parallel]":                                                                                                                                                                                        {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the root URL [Suite:openshift/conformance/parallel]":                                                                                                                                                                                         {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the login URL for the allow all IDP [Suite:openshift/conformance/parallel]":                                                                                                                                                                  {},
		"[sig-auth][Feature:HTPasswdAuth] HTPasswd IDP should successfully configure htpasswd and be responsive [Suite:openshift/conformance/parallel]":                                                                                                                                                                        {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs keep the deployer pod invariant valid should deal with config change in case the deployment is still running [Suite:openshift/conformance/parallel]":                                                                                                           {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should support allow-all policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should support a 'default-deny-ingress' policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                 {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic from pods within server namespace based on PodSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                  {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector with MatchExpressions[Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should support allow-all policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                       {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on any PodSelectors [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                       {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should deny ingress access to updated pod [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                             {},
		"[sig-cluster-lifecycle] Cluster version operator acknowledges upgrade": {},
		"Symptom Detection.Node process segfaulted":                             {},
		"operator conditions dns":                                               {},
		"[sig-network] Services should be possible to connect to a service via ExternalIP when the external IP is not assigned to a node [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network-edge][Conformance][Area:Networking][Feature:Router] The HAProxy router should pass the http2 tests [Suite:openshift/conformance/parallel/minimal]":                     {},
		"[sig-network-edge][Conformance][Area:Networking][Feature:Router] The HAProxy router should pass the h2spec conformance tests [Suite:openshift/conformance/parallel/minimal]":        {},
		"[sig-network] Services should be able to change the type from ClusterIP to ExternalName [Conformance] [Suite:openshift/conformance/parallel/minimal] [Suite:k8s]":                   {},
		"[sig-auth][Feature:OAuthServer] [Headers] expected headers returned from the logout URL [Suite:openshift/conformance/parallel]":                                                     {},
		"operator install insights": {},
		"[sig-network] Services should preserve source pod IP for traffic thru service cluster IP [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                       {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce multiple, stacked policies with overlapping podSelectors [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should deny ingress access to updated pod [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                               {},
		"operator conditions insights":  {},
		"operator conditions baremetal": {},
		"[sig-auth][Feature:LDAP] LDAP IDP should authenticate against an ldap server [Suite:openshift/conformance/parallel]": {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic only from a pod in a different namespace based on PodSelector and NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic from pods within server namespace based on PodSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                              {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector with MatchExpressions[Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should deny ingress from pods on other namespaces [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                          {},
		"[sig-network] Netpol [Feature:UDPConnectivity][LinuxOnly] NetworkPolicy between server and client using UDP should enforce policy based on Ports [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                    {},
		"Symptom Detection.Undiagnosed panic detected in pod": {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                              {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand Verify if offline PVC expansion works [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (block volmode)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Dynamic PV (ext3)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                                             {},
		"[sig-network] services basic functionality should allow connections to another pod on the same node via a service IP [Suite:openshift/conformance/parallel]":                                                                                                                                             {},
		"[sig-cli] oc adm must-gather runs successfully for audit logs [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                    {},
		"[sig-auth][Feature:ProjectAPI]  TestProjectWatch should succeed [Suite:openshift/conformance/parallel]":                                                                                                                                                                                                  {},
		"[sig-network] NetworkPolicy [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector and NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                  {},
		"[sig-installer][Feature:baremetal] Baremetal platform should have baremetalhost resources [Suite:openshift/conformance/parallel]":                                                                                                                                                                        {},
		"[sig-network] services basic functionality should allow connections to another pod on a different node via a service IP [Suite:openshift/conformance/parallel]":                                                                                                                                          {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should not allow access by TCP when a policy specifies only UDP [Feature:NetworkPolicy] [Feature:UDP] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                            {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector and NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                         {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on NamespaceSelector with MatchExpressions[Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                    {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce multiple, stacked policies with overlapping podSelectors [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                  {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce ingress policy allowing any port traffic to a server on a specific protocol [Feature:NetworkPolicy] [Feature:UDP] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Netpol [Feature:UDPConnectivity][LinuxOnly] NetworkPolicy between server and client using UDP should support a 'default-deny-ingress' policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                        {},
		"operator install kube-controller-manager": {},
		"operator install kube-scheduler":          {},
		"operator conditions kube-scheduler":       {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                             {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                            {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)] subPath should be able to unmount after the subpath directory is deleted [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                 {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Dynamic PV (default fs)(allowExpansion)] volume-expand should resize volume when PVC is edited while pod is using it [Suite:openshift/conformance/parallel] [Suite:k8s]":                                          {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Pre-provisioned PV (filesystem volmode)] volumeMode should not mount / map unused volumes in a pod [LinuxOnly] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Inline-volume (ext4)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                        {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Inline-volume (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                         {},
		"[sig-storage] In-tree Volumes [Driver: aws] [Testpattern: Inline-volume (default fs)] volumes should allow exec of files on the volume [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                  {},
		"[Conformance][sig-api-machinery][Feature:APIServer] local kubeconfig \"lb-ext.kubeconfig\" should be present on all masters and work [Suite:openshift/conformance/parallel/minimal]":                                                                                        {},
		"[sig-network-edge][Conformance][Area:Networking][Feature:Router] The HAProxy router should pass the gRPC interoperability tests [Suite:openshift/conformance/parallel/minimal]":                                                                                             {},
		"[sig-network] services when using OpenshiftSDN in a mode that does not isolate namespaces by default should allow connections to pods in different namespaces on the same node via service IPs [Suite:openshift/conformance/parallel]":                                      {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on Multiple PodSelectors and NamespaceSelectors [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"operator conditions kube-controller-manager": {},
		"[sig-operator] an end user can use OLM can subscribe to the operator [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                                      {},
		"[sig-devex][Feature:Templates] templateinstance readiness test  should report failed soon after an annotated objects has failed [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                           {},
		"[sig-apps][Feature:DeploymentConfig] deploymentconfigs with multiple image change triggers should run a successful deployment with multiple triggers [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                      {},
		"[sig-cli] oc explain should contain proper fields description for special types [Suite:openshift/conformance/parallel]":                                                                                                                                                                  {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce updated policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                            {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow ingress traffic for a target [Feature:NetworkPolicy]  [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                             {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce multiple ingress policies with ingress allow-all policy taking precedence [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should allow ingress access from updated pod [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                             {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should allow ingress access from updated namespace [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                       {},
		"[sig-imageregistry][Serial][Suite:openshift/registry/serial] Image signature workflow can push a signed image to openshift registry and verify it [Suite:openshift/conformance/serial]":                                                                                                  {},
		"[sig-storage] In-tree Volumes [Driver: gcepd] [Testpattern: Pre-provisioned PV (default fs)] volumes should store data [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                               {},
		"[sig-scheduling] SchedulerPriorities [Serial] Pod should be scheduled to node that don't match the PodAntiAffinity terms [Suite:openshift/conformance/serial] [Suite:k8s]":                                                                                                               {},
		"[sig-network] Conntrack should be able to preserve UDP traffic when server pod cycles for a NodePort service [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                                                                                         {},
		"[sig-cli] oc explain should contain proper spec+status for CRDs [Suite:openshift/conformance/parallel]":                                                                                                                                                                                  {},
		"[sig-cli] oc adm new-project [Suite:openshift/conformance/parallel]": {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should support a 'default-deny-ingress' policy [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                                     {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy to allow traffic only from a different namespace, based on NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]": {},
		"[sig-network] Netpol [LinuxOnly] NetworkPolicy between server and client should enforce policy based on PodSelector or NamespaceSelector [Feature:NetworkPolicy] [Skipped:Network/OpenShiftSDN/Multitenant] [Suite:openshift/conformance/parallel] [Suite:k8s]":                                    {},
		"[sig-imageregistry][Feature:ImageAppend] Image append should create images by appending them [Skipped:Disconnected] [Suite:openshift/conformance/parallel]":                                                                                                                                        {},
		"[sig-network] services when using OpenshiftSDN in a mode that does not isolate namespaces by default should allow connections to pods in different namespaces on different nodes via service IPs [Suite:openshift/conformance/parallel]":                                                           {},
		"[sig-node] nodes should not go unready after being upgraded and go unready only once":  {},
		"[bz-Cluster Version Operator] Verify object deletions after upgrade success":           {},
		"[sig-cli] oc adm must-gather runs successfully [Suite:openshift/conformance/parallel]": {},
	}
)
