// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/kata-containers/kata-containers/src/agent/protocols/protos/types.proto

package protocols

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type IPFamily int32

const (
	IPFamily_v4 IPFamily = 0
	IPFamily_v6 IPFamily = 1
)

var IPFamily_name = map[int32]string{
	0: "v4",
	1: "v6",
}

var IPFamily_value = map[string]int32{
	"v4": 0,
	"v6": 1,
}

func (x IPFamily) String() string {
	return proto.EnumName(IPFamily_name, int32(x))
}

func (IPFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b0c68e5b9fabcd81, []int{0}
}

type IPAddress struct {
	Family               IPFamily `protobuf:"varint,1,opt,name=family,proto3,enum=types.IPFamily" json:"family,omitempty"`
	Address              string   `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	Mask                 string   `protobuf:"bytes,3,opt,name=mask,proto3" json:"mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPAddress) Reset()      { *m = IPAddress{} }
func (*IPAddress) ProtoMessage() {}
func (*IPAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_b0c68e5b9fabcd81, []int{0}
}
func (m *IPAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAddress.Merge(m, src)
}
func (m *IPAddress) XXX_Size() int {
	return m.Size()
}
func (m *IPAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAddress.DiscardUnknown(m)
}

var xxx_messageInfo_IPAddress proto.InternalMessageInfo

type Interface struct {
	Device      string       `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
	Name        string       `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	IPAddresses []*IPAddress `protobuf:"bytes,3,rep,name=IPAddresses,proto3" json:"IPAddresses,omitempty"`
	Mtu         uint64       `protobuf:"varint,4,opt,name=mtu,proto3" json:"mtu,omitempty"`
	HwAddr      string       `protobuf:"bytes,5,opt,name=hwAddr,proto3" json:"hwAddr,omitempty"`
	// PCI path for the device (see the pci::Path (Rust) or types.PciPath (Go) type for format details)
	PciPath string `protobuf:"bytes,6,opt,name=pciPath,proto3" json:"pciPath,omitempty"`
	// Type defines the type of interface described by this structure.
	// The expected values are the one that are defined by the netlink
	// library, regarding each type of link. Here is a non exhaustive
	// list: "veth", "macvtap", "vlan", "macvlan", "tap", ...
	Type                 string   `protobuf:"bytes,7,opt,name=type,proto3" json:"type,omitempty"`
	RawFlags             uint32   `protobuf:"varint,8,opt,name=raw_flags,json=rawFlags,proto3" json:"raw_flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Interface) Reset()      { *m = Interface{} }
func (*Interface) ProtoMessage() {}
func (*Interface) Descriptor() ([]byte, []int) {
	return fileDescriptor_b0c68e5b9fabcd81, []int{1}
}
func (m *Interface) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Interface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Interface.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Interface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Interface.Merge(m, src)
}
func (m *Interface) XXX_Size() int {
	return m.Size()
}
func (m *Interface) XXX_DiscardUnknown() {
	xxx_messageInfo_Interface.DiscardUnknown(m)
}

var xxx_messageInfo_Interface proto.InternalMessageInfo

type Route struct {
	Dest                 string   `protobuf:"bytes,1,opt,name=dest,proto3" json:"dest,omitempty"`
	Gateway              string   `protobuf:"bytes,2,opt,name=gateway,proto3" json:"gateway,omitempty"`
	Device               string   `protobuf:"bytes,3,opt,name=device,proto3" json:"device,omitempty"`
	Source               string   `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	Scope                uint32   `protobuf:"varint,5,opt,name=scope,proto3" json:"scope,omitempty"`
	Family               IPFamily `protobuf:"varint,6,opt,name=family,proto3,enum=types.IPFamily" json:"family,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Route) Reset()      { *m = Route{} }
func (*Route) ProtoMessage() {}
func (*Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_b0c68e5b9fabcd81, []int{2}
}
func (m *Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Route.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Route.Merge(m, src)
}
func (m *Route) XXX_Size() int {
	return m.Size()
}
func (m *Route) XXX_DiscardUnknown() {
	xxx_messageInfo_Route.DiscardUnknown(m)
}

var xxx_messageInfo_Route proto.InternalMessageInfo

type ARPNeighbor struct {
	ToIPAddress          *IPAddress `protobuf:"bytes,1,opt,name=toIPAddress,proto3" json:"toIPAddress,omitempty"`
	Device               string     `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	Lladdr               string     `protobuf:"bytes,3,opt,name=lladdr,proto3" json:"lladdr,omitempty"`
	State                int32      `protobuf:"varint,4,opt,name=state,proto3" json:"state,omitempty"`
	Flags                int32      `protobuf:"varint,5,opt,name=flags,proto3" json:"flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ARPNeighbor) Reset()      { *m = ARPNeighbor{} }
func (*ARPNeighbor) ProtoMessage() {}
func (*ARPNeighbor) Descriptor() ([]byte, []int) {
	return fileDescriptor_b0c68e5b9fabcd81, []int{3}
}
func (m *ARPNeighbor) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ARPNeighbor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ARPNeighbor.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ARPNeighbor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ARPNeighbor.Merge(m, src)
}
func (m *ARPNeighbor) XXX_Size() int {
	return m.Size()
}
func (m *ARPNeighbor) XXX_DiscardUnknown() {
	xxx_messageInfo_ARPNeighbor.DiscardUnknown(m)
}

var xxx_messageInfo_ARPNeighbor proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("types.IPFamily", IPFamily_name, IPFamily_value)
	proto.RegisterType((*IPAddress)(nil), "types.IPAddress")
	proto.RegisterType((*Interface)(nil), "types.Interface")
	proto.RegisterType((*Route)(nil), "types.Route")
	proto.RegisterType((*ARPNeighbor)(nil), "types.ARPNeighbor")
}

func init() {
	proto.RegisterFile("github.com/kata-containers/kata-containers/src/agent/protocols/protos/types.proto", fileDescriptor_b0c68e5b9fabcd81)
}

var fileDescriptor_b0c68e5b9fabcd81 = []byte{
	// 479 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x93, 0x31, 0x8f, 0xd3, 0x30,
	0x18, 0x86, 0xeb, 0xa6, 0xc9, 0x35, 0xae, 0x0e, 0x2a, 0x0b, 0x9d, 0x2c, 0x90, 0xa2, 0xa8, 0x0b,
	0x11, 0x12, 0x8d, 0x54, 0x10, 0xfb, 0x31, 0x9c, 0xd4, 0x05, 0x15, 0x6f, 0xb0, 0x20, 0xd7, 0x75,
	0xd3, 0xa8, 0x49, 0x1c, 0xd9, 0x4e, 0xab, 0x6e, 0xfc, 0x11, 0x36, 0x7e, 0xcc, 0x8d, 0x8c, 0x8c,
	0x77, 0xfd, 0x25, 0xc8, 0x76, 0x5a, 0x85, 0x82, 0x90, 0x98, 0xfa, 0x3d, 0x9f, 0xed, 0x7e, 0xef,
	0xfb, 0x3a, 0x86, 0x1f, 0xb3, 0x5c, 0x6f, 0x9a, 0xe5, 0x94, 0x89, 0x32, 0xdd, 0x52, 0x4d, 0x5f,
	0x33, 0x51, 0x69, 0x9a, 0x57, 0x5c, 0xaa, 0x3f, 0x58, 0x49, 0x96, 0xd2, 0x8c, 0x57, 0x3a, 0xad,
	0xa5, 0xd0, 0x82, 0x89, 0x42, 0xb9, 0x4a, 0xa5, 0xfa, 0x50, 0x73, 0x35, 0xb5, 0x80, 0x7c, 0x0b,
	0x93, 0x25, 0x0c, 0xe7, 0x8b, 0xdb, 0xd5, 0x4a, 0x72, 0xa5, 0xd0, 0x4b, 0x18, 0xac, 0x69, 0x99,
	0x17, 0x07, 0x0c, 0x62, 0x90, 0x3c, 0x99, 0x3d, 0x9d, 0xba, 0x13, 0xf3, 0xc5, 0x9d, 0x6d, 0x93,
	0x76, 0x19, 0x61, 0x78, 0x45, 0xdd, 0x19, 0xdc, 0x8f, 0x41, 0x12, 0x92, 0x13, 0x22, 0x04, 0x07,
	0x25, 0x55, 0x5b, 0xec, 0xd9, 0xb6, 0xad, 0x27, 0x0f, 0x00, 0x86, 0xf3, 0x4a, 0x73, 0xb9, 0xa6,
	0x8c, 0xa3, 0x1b, 0x18, 0xac, 0xf8, 0x2e, 0x67, 0xdc, 0x0e, 0x09, 0x49, 0x4b, 0xe6, 0x64, 0x45,
	0x4b, 0xde, 0xfe, 0xa1, 0xad, 0xd1, 0x0c, 0x8e, 0xce, 0xea, 0xb8, 0xc2, 0x5e, 0xec, 0x25, 0xa3,
	0xd9, 0xf8, 0xac, 0xaa, 0x5d, 0x21, 0xdd, 0x4d, 0x68, 0x0c, 0xbd, 0x52, 0x37, 0x78, 0x10, 0x83,
	0x64, 0x40, 0x4c, 0x69, 0x26, 0x6e, 0xf6, 0x66, 0x03, 0xf6, 0xdd, 0x44, 0x47, 0xc6, 0x45, 0xcd,
	0xf2, 0x05, 0xd5, 0x1b, 0x1c, 0x38, 0x17, 0x2d, 0x1a, 0x2d, 0x66, 0x06, 0xbe, 0x72, 0x5a, 0x4c,
	0x8d, 0x5e, 0xc0, 0x50, 0xd2, 0xfd, 0x97, 0x75, 0x41, 0x33, 0x85, 0x87, 0x31, 0x48, 0xae, 0xc9,
	0x50, 0xd2, 0xfd, 0x9d, 0xe1, 0xc9, 0x77, 0x00, 0x7d, 0x22, 0x1a, 0x6d, 0x6d, 0xac, 0xb8, 0xd2,
	0xad, 0x39, 0x5b, 0x9b, 0x41, 0x19, 0xd5, 0x7c, 0x4f, 0x0f, 0xa7, 0xb8, 0x5a, 0xec, 0x84, 0xe1,
	0xfd, 0x16, 0xc6, 0x0d, 0x0c, 0x94, 0x68, 0x24, 0xe3, 0xd6, 0x47, 0x48, 0x5a, 0x42, 0xcf, 0xa0,
	0xaf, 0x98, 0xa8, 0xb9, 0x75, 0x72, 0x4d, 0x1c, 0x74, 0xee, 0x2d, 0xf8, 0xe7, 0xbd, 0x4d, 0xbe,
	0x01, 0x38, 0xba, 0x25, 0x8b, 0x0f, 0x3c, 0xcf, 0x36, 0x4b, 0x21, 0x4d, 0xbe, 0x5a, 0x9c, 0xc3,
	0xb3, 0x9a, 0xff, 0x9a, 0x6f, 0x67, 0x53, 0x47, 0x72, 0xff, 0x52, 0x72, 0x51, 0x98, 0xcf, 0xe0,
	0x64, 0xc5, 0x91, 0x95, 0xac, 0xa9, 0x76, 0x4e, 0x7c, 0xe2, 0xc0, 0x74, 0x5d, 0x92, 0xbe, 0xeb,
	0x5a, 0x78, 0xf5, 0x1c, 0x0e, 0x4f, 0x9a, 0x51, 0x00, 0xfb, 0xbb, 0xb7, 0xe3, 0x9e, 0xfd, 0x7d,
	0x37, 0x06, 0xef, 0xd5, 0xfd, 0x63, 0xd4, 0xfb, 0xf9, 0x18, 0xf5, 0xbe, 0x1e, 0x23, 0x70, 0x7f,
	0x8c, 0xc0, 0x8f, 0x63, 0x04, 0x1e, 0x8e, 0x11, 0xf8, 0xfc, 0xe9, 0x3f, 0x5f, 0x87, 0x6c, 0x2a,
	0x9d, 0x97, 0x3c, 0xdd, 0xe5, 0x52, 0x77, 0x96, 0xea, 0x6d, 0x76, 0xf9, 0x70, 0x96, 0x81, 0x2d,
	0xdf, 0xfc, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x21, 0x00, 0xa1, 0xc2, 0x81, 0x03, 0x00, 0x00,
}

func (m *IPAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Mask) > 0 {
		i -= len(m.Mask)
		copy(dAtA[i:], m.Mask)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Mask)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x12
	}
	if m.Family != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Family))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Interface) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Interface) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Interface) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RawFlags != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.RawFlags))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.PciPath) > 0 {
		i -= len(m.PciPath)
		copy(dAtA[i:], m.PciPath)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.PciPath)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.HwAddr) > 0 {
		i -= len(m.HwAddr)
		copy(dAtA[i:], m.HwAddr)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.HwAddr)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Mtu != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Mtu))
		i--
		dAtA[i] = 0x20
	}
	if len(m.IPAddresses) > 0 {
		for iNdEx := len(m.IPAddresses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IPAddresses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Device) > 0 {
		i -= len(m.Device)
		copy(dAtA[i:], m.Device)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Device)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Route) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Route) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Family != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Family))
		i--
		dAtA[i] = 0x30
	}
	if m.Scope != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Scope))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Device) > 0 {
		i -= len(m.Device)
		copy(dAtA[i:], m.Device)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Device)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Gateway) > 0 {
		i -= len(m.Gateway)
		copy(dAtA[i:], m.Gateway)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Gateway)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Dest) > 0 {
		i -= len(m.Dest)
		copy(dAtA[i:], m.Dest)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Dest)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ARPNeighbor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ARPNeighbor) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ARPNeighbor) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Flags != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x28
	}
	if m.State != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Lladdr) > 0 {
		i -= len(m.Lladdr)
		copy(dAtA[i:], m.Lladdr)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Lladdr)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Device) > 0 {
		i -= len(m.Device)
		copy(dAtA[i:], m.Device)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Device)))
		i--
		dAtA[i] = 0x12
	}
	if m.ToIPAddress != nil {
		{
			size, err := m.ToIPAddress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	offset -= sovTypes(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *IPAddress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Family != 0 {
		n += 1 + sovTypes(uint64(m.Family))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Mask)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Interface) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Device)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.IPAddresses) > 0 {
		for _, e := range m.IPAddresses {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.Mtu != 0 {
		n += 1 + sovTypes(uint64(m.Mtu))
	}
	l = len(m.HwAddr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.PciPath)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.RawFlags != 0 {
		n += 1 + sovTypes(uint64(m.RawFlags))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Dest)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Device)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Scope != 0 {
		n += 1 + sovTypes(uint64(m.Scope))
	}
	if m.Family != 0 {
		n += 1 + sovTypes(uint64(m.Family))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ARPNeighbor) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ToIPAddress != nil {
		l = m.ToIPAddress.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Device)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Lladdr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	if m.Flags != 0 {
		n += 1 + sovTypes(uint64(m.Flags))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovTypes(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *IPAddress) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IPAddress{`,
		`Family:` + fmt.Sprintf("%v", this.Family) + `,`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`Mask:` + fmt.Sprintf("%v", this.Mask) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Interface) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForIPAddresses := "[]*IPAddress{"
	for _, f := range this.IPAddresses {
		repeatedStringForIPAddresses += strings.Replace(f.String(), "IPAddress", "IPAddress", 1) + ","
	}
	repeatedStringForIPAddresses += "}"
	s := strings.Join([]string{`&Interface{`,
		`Device:` + fmt.Sprintf("%v", this.Device) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`IPAddresses:` + repeatedStringForIPAddresses + `,`,
		`Mtu:` + fmt.Sprintf("%v", this.Mtu) + `,`,
		`HwAddr:` + fmt.Sprintf("%v", this.HwAddr) + `,`,
		`PciPath:` + fmt.Sprintf("%v", this.PciPath) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`RawFlags:` + fmt.Sprintf("%v", this.RawFlags) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Route) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Route{`,
		`Dest:` + fmt.Sprintf("%v", this.Dest) + `,`,
		`Gateway:` + fmt.Sprintf("%v", this.Gateway) + `,`,
		`Device:` + fmt.Sprintf("%v", this.Device) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Scope:` + fmt.Sprintf("%v", this.Scope) + `,`,
		`Family:` + fmt.Sprintf("%v", this.Family) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ARPNeighbor) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ARPNeighbor{`,
		`ToIPAddress:` + strings.Replace(this.ToIPAddress.String(), "IPAddress", "IPAddress", 1) + `,`,
		`Device:` + fmt.Sprintf("%v", this.Device) + `,`,
		`Lladdr:` + fmt.Sprintf("%v", this.Lladdr) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Flags:` + fmt.Sprintf("%v", this.Flags) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTypes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *IPAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Family |= IPFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Interface) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Interface: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Interface: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Device", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Device = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPAddresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IPAddresses = append(m.IPAddresses, &IPAddress{})
			if err := m.IPAddresses[len(m.IPAddresses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mtu", wireType)
			}
			m.Mtu = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mtu |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HwAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HwAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PciPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PciPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawFlags", wireType)
			}
			m.RawFlags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RawFlags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dest = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Device", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Device = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			m.Scope = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Scope |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Family |= IPFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ARPNeighbor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ARPNeighbor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ARPNeighbor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToIPAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ToIPAddress == nil {
				m.ToIPAddress = &IPAddress{}
			}
			if err := m.ToIPAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Device", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Device = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lladdr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Lladdr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTypes
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTypes
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTypes        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTypes = fmt.Errorf("proto: unexpected end of group")
)
