/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// RngConfig struct for RngConfig
type RngConfig struct {
	Src   string `json:"src"`
	Iommu *bool  `json:"iommu,omitempty"`
}

// NewRngConfig instantiates a new RngConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRngConfig(src string) *RngConfig {
	this := RngConfig{}
	this.Src = src
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// NewRngConfigWithDefaults instantiates a new RngConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRngConfigWithDefaults() *RngConfig {
	this := RngConfig{}
	var src string = "/dev/urandom"
	this.Src = src
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// GetSrc returns the Src field value
func (o *RngConfig) GetSrc() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Src
}

// GetSrcOk returns a tuple with the Src field value
// and a boolean to check if the value has been set.
func (o *RngConfig) GetSrcOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Src, true
}

// SetSrc sets field value
func (o *RngConfig) SetSrc(v string) {
	o.Src = v
}

// GetIommu returns the Iommu field value if set, zero value otherwise.
func (o *RngConfig) GetIommu() bool {
	if o == nil || o.Iommu == nil {
		var ret bool
		return ret
	}
	return *o.Iommu
}

// GetIommuOk returns a tuple with the Iommu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RngConfig) GetIommuOk() (*bool, bool) {
	if o == nil || o.Iommu == nil {
		return nil, false
	}
	return o.Iommu, true
}

// HasIommu returns a boolean if a field has been set.
func (o *RngConfig) HasIommu() bool {
	if o != nil && o.Iommu != nil {
		return true
	}

	return false
}

// SetIommu gets a reference to the given bool and assigns it to the Iommu field.
func (o *RngConfig) SetIommu(v bool) {
	o.Iommu = &v
}

func (o RngConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["src"] = o.Src
	}
	if o.Iommu != nil {
		toSerialize["iommu"] = o.Iommu
	}
	return json.Marshal(toSerialize)
}

type NullableRngConfig struct {
	value *RngConfig
	isSet bool
}

func (v NullableRngConfig) Get() *RngConfig {
	return v.value
}

func (v *NullableRngConfig) Set(val *RngConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableRngConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableRngConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRngConfig(val *RngConfig) *NullableRngConfig {
	return &NullableRngConfig{value: val, isSet: true}
}

func (v NullableRngConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRngConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
