---
title: "v1.1.0"
linkTitle: "v1.1.0"
date: 2021-08-13
description: >
  Cloud Provider Azure v1.1.0
---

# Changelog since v1.0.0

## Changes by Kind

### Feature

- Added support for Windows Server 2004 and 20H2 to the ``azure-cloud-node-manager`` image. ([#655](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/655), [@claudiubelu](https://github.com/claudiubelu)) [SIG Windows]
- Azure_api_request_errors metric now has an added "code" label which provides more details on the errors encountered. ([#733](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/733), [@marwanad](https://github.com/marwanad))
- Chore: upgrade TLS1.0 to TLS1.2 in account creation ([#675](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/675), [@andyzhangx](https://github.com/andyzhangx))
- Feat: Provide IPv6 support for internal load balancer ([#703](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/703), [@tomkerkhove](https://github.com/tomkerkhove))
- Feat: add ListAll interface for PublicIP client ([#695](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/695), [@feiskyer](https://github.com/feiskyer))
- Feat: add support for additional public IPs via service annotation "service.beta.kubernetes.io/azure-additional-public-ips" ([#691](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/691), [@feiskyer](https://github.com/feiskyer))
- Feat: enable creation of private endpoint for storage account ([#652](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/652), [@nearora-msft](https://github.com/nearora-msft))
- Feat: support async attach/detach disk ([#677](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/677), [@andyzhangx](https://github.com/andyzhangx))
- Feat: support networkAccessPolicy ([#701](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/701), [@andyzhangx](https://github.com/andyzhangx))
- UserAgents can now be passed as part of the cloud provider config ([#734](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/734), [@kassarl](https://github.com/kassarl))

### Documentation

- Chore: update docs for service tags NSG ([#647](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/647), [@feiskyer](https://github.com/feiskyer))
- Docs: add 'securityGroupResourceGroup' cloud-config value ([#668](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/668), [@aslafy-z](https://github.com/aslafy-z))

### Failing Test

- Fix: serviceOwnsFrontendIP shouldn't report error when the public IP doesn't match ([#649](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/649), [@feiskyer](https://github.com/feiskyer))

### Bug or Regression

- Do not set cached Sku when updating VMSS and VMSS instances ([#630](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/630), [@feiskyer](https://github.com/feiskyer))
- fixed PrivateEndpoint matching in storage account search ([#707](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/707), [@andyzhangx](https://github.com/andyzhangx))
- Fix: cleanup outdated routes ([#661](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/661), [@nilo19](https://github.com/nilo19))
- Fix: detach disk panic on Azure Stack ([#688](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/688), [@andyzhangx](https://github.com/andyzhangx))
- Fix: enable git command by default so that images could get the correct version from git ([#745](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/745), [@feiskyer](https://github.com/feiskyer))
- Fix: ensure NSG rules are handled regardless of case ([#741](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/741), [@feiskyer](https://github.com/feiskyer))
- Fix: ensure VM with provisioningState=Creating and powerState=Stopped  is treated as Creating instead of Stopped ([#743](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/743), [@feiskyer](https://github.com/feiskyer))
- Fix: ensure http connections reused for ARM clients ([#711](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/711), [@feiskyer](https://github.com/feiskyer))
- Fix: ignore the NodeCIDRMaskSize in dualstack clusters ([#721](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/721), [@nilo19](https://github.com/nilo19))
- Fix: make tags case-insensitive for both keys and values ([#669](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/669), [@nilo19](https://github.com/nilo19))
- Fix: remove GetDisk operation in AttachDisk ([#678](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/678), [@andyzhangx](https://github.com/andyzhangx))
- Fix: respect VnetResourceGroup in private link creation ([#719](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/719), [@andyzhangx](https://github.com/andyzhangx))
- Fix: return empty VMAS name if using standalone VM ([#679](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/679), [@nilo19](https://github.com/nilo19))
- fix: reduce crp throttling in attach disk scenario ([#621](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/621), [@andyzhangx](https://github.com/andyzhangx))
- fix: dangling volume issue ([#622](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/622), [@andyzhangx](https://github.com/andyzhangx))
- fix: delete non existing disk issue ([#623](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/623), [@andyzhangx](https://github.com/andyzhangx))
- Retry.GetError(response, err) ([#718](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/718), [@marwanad](https://github.com/marwanad))
- fix: ensure major and minor versions are set correctly ([#749](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/749), [@feiskyer](https://github.com/feiskyer))
- Zones logic on Azure Stack Cloud platform was disabled because it does not supported on this platform. ([#716](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/716), [@lobziik](https://github.com/lobziik))

### Other (Cleanup or Flake)

- Chore: add e2e test for byo public IP ([#627](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/627), [@nilo19](https://github.com/nilo19))
- Chore: add more buckets for operation metrics ([#656](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/656), [@andyzhangx](https://github.com/andyzhangx))
- Chore: enrich unit test for serviceOwnsFrontendIP ([#710](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/710), [@nilo19](https://github.com/nilo19))
- Chore: only put pip if it is necessary ([#686](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/686), [@nilo19](https://github.com/nilo19))
- Chore: only reconciling routes in cloud controller manager ([#671](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/671), [@nilo19](https://github.com/nilo19))
- Chore: set default config secret name and namespace ([#662](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/662), [@nilo19](https://github.com/nilo19))
- Fix: wait for the success of the initial run of syncRegionZonesMap ([#646](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/646), [@nilo19](https://github.com/nilo19))
- Update Azure Go SDK to v55.0.0 ([#643](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/643), [@feiskyer](https://github.com/feiskyer))
- Upgrade to 2020-02-01/storage ([#628](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/628), [@andyzhangx](https://github.com/andyzhangx))
- `GetTestCloud` properly initializes the disk controller fields enabling them to be used in unit tests and mocked. ([#689](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/689), [@edreed](https://github.com/edreed))

### Uncategorized

- Add CreateOrUpdateBackendPools() interface for LoadBalancer client ([#620](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/620), [@feiskyer](https://github.com/feiskyer))
- Feat: add NFSv3 account creation support ([#633](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/633), [@andyzhangx](https://github.com/andyzhangx))
- Fix: leave the probe path empty for TCP probes ([#680](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/680), [@nilo19](https://github.com/nilo19))
- Fix: no sleep when GetDisk is throttled ([#629](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/629), [@andyzhangx](https://github.com/andyzhangx))
- `GetTestCloud` now initializes the `SnapshotsClient` field to a mock implementation to facilitate unit test development for consuming projects. ([#732](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/732), [@edreed](https://github.com/edreed))

## Dependencies

### Added
- github.com/OneOfOne/xxhash: [v1.2.2](https://github.com/OneOfOne/xxhash/tree/v1.2.2)
- github.com/antihax/optional: [v1.0.0](https://github.com/antihax/optional/tree/v1.0.0)
- github.com/benbjohnson/clock: [v1.0.3](https://github.com/benbjohnson/clock/tree/v1.0.3)
- github.com/certifi/gocertifi: [2c3bb06](https://github.com/certifi/gocertifi/tree/2c3bb06)
- github.com/cespare/xxhash: [v1.1.0](https://github.com/cespare/xxhash/tree/v1.1.0)
- github.com/client9/misspell: [v0.3.4](https://github.com/client9/misspell/tree/v0.3.4)
- github.com/cncf/udpa/go: [5459f2c](https://github.com/cncf/udpa/go/tree/5459f2c)
- github.com/cockroachdb/errors: [v1.2.4](https://github.com/cockroachdb/errors/tree/v1.2.4)
- github.com/cockroachdb/logtags: [eb05cc2](https://github.com/cockroachdb/logtags/tree/eb05cc2)
- github.com/coreos/go-systemd/v22: [v22.3.2](https://github.com/coreos/go-systemd/v22/tree/v22.3.2)
- github.com/dgryski/go-sip13: [e10d5fe](https://github.com/dgryski/go-sip13/tree/e10d5fe)
- github.com/felixge/httpsnoop: [v1.0.1](https://github.com/felixge/httpsnoop/tree/v1.0.1)
- github.com/getsentry/raven-go: [v0.2.0](https://github.com/getsentry/raven-go/tree/v0.2.0)
- github.com/go-gl/glfw: [e6da0ac](https://github.com/go-gl/glfw/tree/e6da0ac)
- github.com/go-kit/log: [v0.1.0](https://github.com/go-kit/log/tree/v0.1.0)
- github.com/go-stack/stack: [v1.8.0](https://github.com/go-stack/stack/tree/v1.8.0)
- github.com/go-task/slim-sprig: [348f09d](https://github.com/go-task/slim-sprig/tree/348f09d)
- github.com/godbus/dbus/v5: [v5.0.4](https://github.com/godbus/dbus/v5/tree/v5.0.4)
- github.com/google/martian/v3: [v3.1.0](https://github.com/google/martian/v3/tree/v3.1.0)
- github.com/josharian/intern: [v1.0.0](https://github.com/josharian/intern/tree/v1.0.0)
- github.com/jpillora/backoff: [v1.0.0](https://github.com/jpillora/backoff/tree/v1.0.0)
- github.com/konsorten/go-windows-terminal-sequences: [v1.0.3](https://github.com/konsorten/go-windows-terminal-sequences/tree/v1.0.3)
- github.com/kr/fs: [v0.1.0](https://github.com/kr/fs/tree/v0.1.0)
- github.com/kr/pty: [v1.1.1](https://github.com/kr/pty/tree/v1.1.1)
- github.com/nxadm/tail: [v1.4.8](https://github.com/nxadm/tail/tree/v1.4.8)
- github.com/oklog/ulid: [v1.3.1](https://github.com/oklog/ulid/tree/v1.3.1)
- github.com/opentracing/opentracing-go: [v1.1.0](https://github.com/opentracing/opentracing-go/tree/v1.1.0)
- github.com/pkg/sftp: [v1.10.1](https://github.com/pkg/sftp/tree/v1.10.1)
- github.com/prometheus/tsdb: [v0.7.1](https://github.com/prometheus/tsdb/tree/v0.7.1)
- github.com/spaolacci/murmur3: [f09979e](https://github.com/spaolacci/murmur3/tree/f09979e)
- github.com/stoewer/go-strcase: [v1.2.0](https://github.com/stoewer/go-strcase/tree/v1.2.0)
- go.etcd.io/etcd/api/v3: v3.5.0
- go.etcd.io/etcd/client/pkg/v3: v3.5.0
- go.etcd.io/etcd/client/v2: v2.305.0
- go.etcd.io/etcd/client/v3: v3.5.0
- go.etcd.io/etcd/pkg/v3: v3.5.0
- go.etcd.io/etcd/raft/v3: v3.5.0
- go.etcd.io/etcd/server/v3: v3.5.0
- go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc: v0.20.0
- go.opentelemetry.io/contrib/instrumentation/net/http/otelhttp: v0.20.0
- go.opentelemetry.io/contrib: v0.20.0
- go.opentelemetry.io/otel/exporters/otlp: v0.20.0
- go.opentelemetry.io/otel/metric: v0.20.0
- go.opentelemetry.io/otel/oteltest: v0.20.0
- go.opentelemetry.io/otel/sdk/export/metric: v0.20.0
- go.opentelemetry.io/otel/sdk/metric: v0.20.0
- go.opentelemetry.io/otel/sdk: v0.20.0
- go.opentelemetry.io/otel/trace: v0.20.0
- go.opentelemetry.io/otel: v0.20.0
- go.opentelemetry.io/proto/otlp: v0.7.0
- go.uber.org/goleak: v1.1.10
- rsc.io/binaryregexp: v0.2.0

### Changed
- cloud.google.com/go/bigquery: v1.4.0 → v1.8.0
- cloud.google.com/go/pubsub: v1.2.0 → v1.3.1
- cloud.google.com/go/storage: v1.6.0 → v1.10.0
- cloud.google.com/go: v0.54.0 → v0.81.0
- github.com/Azure/azure-sdk-for-go: [v53.1.0+incompatible → v55.0.0+incompatible](https://github.com/Azure/azure-sdk-for-go/compare/v53.1.0...v55.0.0)
- github.com/Azure/go-ansiterm: [d6e3b33 → d185dfc](https://github.com/Azure/go-ansiterm/compare/d6e3b33...d185dfc)
- github.com/Azure/go-autorest/autorest/adal: [v0.9.10 → v0.9.14](https://github.com/Azure/go-autorest/autorest/adal/compare/v0.9.10...v0.9.14)
- github.com/Azure/go-autorest/autorest/to: [v0.2.0 → v0.4.0](https://github.com/Azure/go-autorest/autorest/to/compare/v0.2.0...v0.4.0)
- github.com/Azure/go-autorest/autorest: [v0.11.17 → v0.11.19](https://github.com/Azure/go-autorest/autorest/compare/v0.11.17...v0.11.19)
- github.com/Azure/go-autorest/logger: [v0.2.0 → v0.2.1](https://github.com/Azure/go-autorest/logger/compare/v0.2.0...v0.2.1)
- github.com/alecthomas/units: [c3de453 → f65c72e](https://github.com/alecthomas/units/compare/c3de453...f65c72e)
- github.com/bketelsen/crypt: [5cbc8cc → v0.0.4](https://github.com/bketelsen/crypt/compare/5cbc8cc...v0.0.4)
- github.com/cockroachdb/datadriven: [80d97fb → bf6692d](https://github.com/cockroachdb/datadriven/compare/80d97fb...bf6692d)
- github.com/envoyproxy/go-control-plane: [5f8ba28 → 668b12f](https://github.com/envoyproxy/go-control-plane/compare/5f8ba28...668b12f)
- github.com/evanphx/json-patch: [v4.9.0+incompatible → v4.11.0+incompatible](https://github.com/evanphx/json-patch/compare/v4.9.0...v4.11.0)
- github.com/form3tech-oss/jwt-go: [v3.2.2+incompatible → v3.2.3+incompatible](https://github.com/form3tech-oss/jwt-go/compare/v3.2.2...v3.2.3)
- github.com/fsnotify/fsnotify: [v1.4.7 → v1.4.9](https://github.com/fsnotify/fsnotify/compare/v1.4.7...v1.4.9)
- github.com/go-logfmt/logfmt: [v0.4.0 → v0.5.0](https://github.com/go-logfmt/logfmt/compare/v0.4.0...v0.5.0)
- github.com/go-openapi/jsonpointer: [v0.19.3 → v0.19.5](https://github.com/go-openapi/jsonpointer/compare/v0.19.3...v0.19.5)
- github.com/go-openapi/jsonreference: [v0.19.3 → v0.19.5](https://github.com/go-openapi/jsonreference/compare/v0.19.3...v0.19.5)
- github.com/go-openapi/swag: [v0.19.5 → v0.19.14](https://github.com/go-openapi/swag/compare/v0.19.5...v0.19.14)
- github.com/golang/groupcache: [8c9f03a → 41bb18b](https://github.com/golang/groupcache/compare/8c9f03a...41bb18b)
- github.com/golang/mock: [v1.4.1 → v1.6.0](https://github.com/golang/mock/compare/v1.4.1...v1.6.0)
- github.com/golang/protobuf: [v1.4.3 → v1.5.2](https://github.com/golang/protobuf/compare/v1.4.3...v1.5.2)
- github.com/google/btree: [v1.0.0 → v1.0.1](https://github.com/google/btree/compare/v1.0.0...v1.0.1)
- github.com/google/go-cmp: [v0.5.2 → v0.5.5](https://github.com/google/go-cmp/compare/v0.5.2...v0.5.5)
- github.com/google/pprof: [1ebb73c → cbba55b](https://github.com/google/pprof/compare/1ebb73c...cbba55b)
- github.com/googleapis/gnostic: [v0.4.1 → v0.5.5](https://github.com/googleapis/gnostic/compare/v0.4.1...v0.5.5)
- github.com/grpc-ecosystem/go-grpc-middleware: [f849b54 → v1.3.0](https://github.com/grpc-ecosystem/go-grpc-middleware/compare/f849b54...v1.3.0)
- github.com/grpc-ecosystem/grpc-gateway: [v1.9.5 → v1.16.0](https://github.com/grpc-ecosystem/grpc-gateway/compare/v1.9.5...v1.16.0)
- github.com/ianlancetaylor/demangle: [5e5cf60 → 28f6c0f](https://github.com/ianlancetaylor/demangle/compare/5e5cf60...28f6c0f)
- github.com/jonboulle/clockwork: [v0.1.0 → v0.2.2](https://github.com/jonboulle/clockwork/compare/v0.1.0...v0.2.2)
- github.com/json-iterator/go: [v1.1.10 → v1.1.11](https://github.com/json-iterator/go/compare/v1.1.10...v1.1.11)
- github.com/julienschmidt/httprouter: [v1.2.0 → v1.3.0](https://github.com/julienschmidt/httprouter/compare/v1.2.0...v1.3.0)
- github.com/magiconair/properties: [v1.8.1 → v1.8.5](https://github.com/magiconair/properties/compare/v1.8.1...v1.8.5)
- github.com/mailru/easyjson: [v0.7.0 → v0.7.6](https://github.com/mailru/easyjson/compare/v0.7.0...v0.7.6)
- github.com/mattn/go-isatty: [v0.0.4 → v0.0.3](https://github.com/mattn/go-isatty/compare/v0.0.4...v0.0.3)
- github.com/mitchellh/mapstructure: [v1.1.2 → v1.4.1](https://github.com/mitchellh/mapstructure/compare/v1.1.2...v1.4.1)
- github.com/moby/term: [df9cb8a → 9d4ed18](https://github.com/moby/term/compare/df9cb8a...9d4ed18)
- github.com/mwitkow/go-conntrack: [cc309e4 → 2f06839](https://github.com/mwitkow/go-conntrack/compare/cc309e4...2f06839)
- github.com/onsi/ginkgo: [v1.11.0 → v1.16.4](https://github.com/onsi/ginkgo/compare/v1.11.0...v1.16.4)
- github.com/onsi/gomega: [v1.8.1 → v1.15.0](https://github.com/onsi/gomega/compare/v1.8.1...v1.15.0)
- github.com/pelletier/go-toml: [v1.2.0 → v1.9.3](https://github.com/pelletier/go-toml/compare/v1.2.0...v1.9.3)
- github.com/prometheus/client_golang: [v1.7.1 → v1.11.0](https://github.com/prometheus/client_golang/compare/v1.7.1...v1.11.0)
- github.com/prometheus/common: [v0.10.0 → v0.26.0](https://github.com/prometheus/common/compare/v0.10.0...v0.26.0)
- github.com/prometheus/procfs: [v0.2.0 → v0.6.0](https://github.com/prometheus/procfs/compare/v0.2.0...v0.6.0)
- github.com/rogpeppe/fastuuid: [6724a57 → v1.2.0](https://github.com/rogpeppe/fastuuid/compare/6724a57...v1.2.0)
- github.com/sirupsen/logrus: [v1.7.0 → v1.8.1](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.1)
- github.com/soheilhy/cmux: [v0.1.4 → v0.1.5](https://github.com/soheilhy/cmux/compare/v0.1.4...v0.1.5)
- github.com/spf13/afero: [v1.2.2 → v1.6.0](https://github.com/spf13/afero/compare/v1.2.2...v1.6.0)
- github.com/spf13/cast: [v1.3.0 → v1.3.1](https://github.com/spf13/cast/compare/v1.3.0...v1.3.1)
- github.com/spf13/cobra: [v1.1.1 → v1.2.1](https://github.com/spf13/cobra/compare/v1.1.1...v1.2.1)
- github.com/spf13/jwalterweatherman: [v1.0.0 → v1.1.0](https://github.com/spf13/jwalterweatherman/compare/v1.0.0...v1.1.0)
- github.com/spf13/viper: [v1.7.0 → v1.8.1](https://github.com/spf13/viper/compare/v1.7.0...v1.8.1)
- github.com/stretchr/testify: [v1.6.1 → v1.7.0](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
- github.com/tmc/grpc-websocket-proxy: [0ad062e → e5319fd](https://github.com/tmc/grpc-websocket-proxy/compare/0ad062e...e5319fd)
- github.com/yuin/goldmark: [v1.2.1 → v1.3.5](https://github.com/yuin/goldmark/compare/v1.2.1...v1.3.5)
- go.etcd.io/bbolt: v1.3.5 → v1.3.6
- go.opencensus.io: v0.22.3 → v0.23.0
- go.uber.org/atomic: v1.6.0 → v1.7.0
- go.uber.org/multierr: v1.5.0 → v1.6.0
- go.uber.org/zap: v1.16.0 → v1.17.0
- golang.org/x/lint: 738671d → 6edffad
- golang.org/x/mod: ce943fd → v0.4.2
- golang.org/x/net: 3d97a24 → 37e1c6a
- golang.org/x/oauth2: bf48bf1 → 2e8d934
- golang.org/x/sync: 67f06af → 036812b
- golang.org/x/sys: a50acf3 → 59db8d7
- golang.org/x/text: v0.3.4 → v0.3.6
- golang.org/x/time: f8bda1e → 1f47c86
- golang.org/x/tools: v0.1.0 → v0.1.2
- google.golang.org/api: v0.20.0 → v0.44.0
- google.golang.org/appengine: v1.6.5 → v1.6.7
- google.golang.org/genproto: 8816d57 → f16073e
- google.golang.org/grpc: v1.27.1 → v1.38.0
- google.golang.org/protobuf: v1.25.0 → v1.26.0
- gopkg.in/ini.v1: v1.51.0 → v1.62.0
- gopkg.in/yaml.v3: 9f266ea → 496545a
- honnef.co/go/tools: v0.0.1-2020.1.3 → v0.0.1-2020.1.4
- k8s.io/api: 648b778 → v0.22.0
- k8s.io/apimachinery: 8daf289 → v0.22.0
- k8s.io/apiserver: 940c107 → v0.22.0
- k8s.io/client-go: 8c8fa70 → v0.22.0
- k8s.io/cloud-provider: 1ea896e → v0.22.0
- k8s.io/component-base: 5860d9b → v0.22.0
- k8s.io/controller-manager: 146a790 → v0.22.0
- k8s.io/klog/v2: v2.8.0 → v2.10.0
- k8s.io/kube-openapi: 591a79e → 9528897
- k8s.io/utils: 67b214c → 4b05e18
- sigs.k8s.io/apiserver-network-proxy/konnectivity-client: v0.0.15 → v0.0.22
- sigs.k8s.io/structured-merge-diff/v4: v4.1.1 → v4.1.2

### Removed
- github.com/go-openapi/spec: [v0.19.5](https://github.com/go-openapi/spec/tree/v0.19.5)
- github.com/mattn/go-runewidth: [v0.0.2](https://github.com/mattn/go-runewidth/tree/v0.0.2)
- github.com/olekukonko/tablewriter: [a0225b3](https://github.com/olekukonko/tablewriter/tree/a0225b3)
- github.com/urfave/cli: [v1.20.0](https://github.com/urfave/cli/tree/v1.20.0)
- go.etcd.io/etcd: dd1b699
- go.uber.org/tools: 2cfd321
- gopkg.in/cheggaaa/pb.v1: v1.0.25
