/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by MockGen. DO NOT EDIT.
// Source: pkg/optimization/device_perf.go

// Package mockoptimization is a generated GoMock package.
package mockoptimization

import (
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	optimization "sigs.k8s.io/azuredisk-csi-driver/pkg/optimization"
)

// MockInterface is a mock of Interface interface.
type MockInterface struct {
	ctrl     *gomock.Controller
	recorder *MockInterfaceMockRecorder
}

// MockInterfaceMockRecorder is the mock recorder for MockInterface.
type MockInterfaceMockRecorder struct {
	mock *MockInterface
}

// NewMockInterface creates a new mock instance.
func NewMockInterface(ctrl *gomock.Controller) *MockInterface {
	mock := &MockInterface{ctrl: ctrl}
	mock.recorder = &MockInterfaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockInterface) EXPECT() *MockInterfaceMockRecorder {
	return m.recorder
}

// DiskSupportsPerfOptimization mocks base method.
func (m *MockInterface) DiskSupportsPerfOptimization(diskPerfProfile, diskAccountType string) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DiskSupportsPerfOptimization", diskPerfProfile, diskAccountType)
	ret0, _ := ret[0].(bool)
	return ret0
}

// DiskSupportsPerfOptimization indicates an expected call of DiskSupportsPerfOptimization.
func (mr *MockInterfaceMockRecorder) DiskSupportsPerfOptimization(diskPerfProfile, diskAccountType interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DiskSupportsPerfOptimization", reflect.TypeOf((*MockInterface)(nil).DiskSupportsPerfOptimization), diskPerfProfile, diskAccountType)
}

// OptimizeDiskPerformance mocks base method.
func (m *MockInterface) OptimizeDiskPerformance(nodeInfo *optimization.NodeInfo, devicePath, perfProfile, accountType, diskSizeGibStr, diskIopsStr, diskBwMbpsStr string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "OptimizeDiskPerformance", nodeInfo, devicePath, perfProfile, accountType, diskSizeGibStr, diskIopsStr, diskBwMbpsStr)
	ret0, _ := ret[0].(error)
	return ret0
}

// OptimizeDiskPerformance indicates an expected call of OptimizeDiskPerformance.
func (mr *MockInterfaceMockRecorder) OptimizeDiskPerformance(nodeInfo, devicePath, perfProfile, accountType, diskSizeGibStr, diskIopsStr, diskBwMbpsStr interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OptimizeDiskPerformance", reflect.TypeOf((*MockInterface)(nil).OptimizeDiskPerformance), nodeInfo, devicePath, perfProfile, accountType, diskSizeGibStr, diskIopsStr, diskBwMbpsStr)
}
