// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v3.13.0
// source: google/devtools/remoteworkers/v1test2/worker.proto

package remoteworkers

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes a worker, which is a list of one or more devices and the
// connections between them. A device could be a computer, a phone, or even an
// accelerator like a GPU; it's up to the farm administrator to decide how to
// model their farm. For example, if a farm only has one type of GPU, the GPU
// could be modelled as a "has_gpu" property on its host computer; if it has
// many subproperties itself, it might be better to model it as a separate
// device.
//
// The first device in the worker is the "primary device" - that is, the device
// running a bot and which is responsible for actually executing commands. All
// other devices are considered to be attached devices, and must be controllable
// by the primary device.
//
// This message (and all its submessages) can be used in two contexts:
//
// * Status: sent by the bot to report the current capabilities of the device to
// allow reservation matching.
// * Request: sent by a client to request a device with certain capabilities in
// a reservation.
//
// Several of the fields in this message have different semantics depending on
// which of which of these contexts it is used. These semantics are described
// below.
//
// Several messages in Worker and its submessages have the concept of keys and
// values, such as `Worker.Property` and `Device.Property`. All keys are simple
// strings, but certain keys are "standard" keys and should be broadly supported
// across farms and implementations; these are listed below each relevant
// message. Bot implementations or farm admins may add *additional* keys, but
// these SHOULD all begin with an underscore so they do not conflict with
// standard keys that may be added in the future.
//
// Keys are not context sensitive.
//
// See http://goo.gl/NurY8g for more information on the Worker message.
type Worker struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of devices; the first device is the primary device. See the `Device`
	// message for more information.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// A worker may contain "global" properties. For example, certain machines
	// might be reserved for certain types of jobs, like short-running compilation
	// versus long-running integration tests. This property is known as a "pool"
	// and is not related to any one device within the worker; rather, it applies
	// to the worker as a whole.
	//
	// The behaviour of repeated keys is identical to that of Device.Property.
	Properties []*Worker_Property `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty"`
	// Bots can be configured in certain ways when accepting leases. For example,
	// many leases are executed inside a Docker container. To support this, the
	// bot needs to be able to report that it has Docker installed (and knows how
	// to execute something inside a container), and the task submitter needs to
	// specify which image should be used to start the container. Similarly, a
	// lease may be able to run as one of several users on the worker; in such
	// cases, the bot needs to report what users are available, and the submitter
	// needs to choose one.
	//
	// Therefore, when this message is reported by the bot to the service, each
	// key represents a *type* of configuration that the bot knows how to set,
	// while each *value* represents a legal value for that configuration (the
	// empty string is interpretted as a wildcard, such as for Docker images).
	// When this message is sent by the server to the bot in the context of a
	// lease, it represents a command to the bot to apply the setting. Keys may
	// be repeated during reporting but not in a lease.
	Configs []*Worker_Config `protobuf:"bytes,3,rep,name=configs,proto3" json:"configs,omitempty"`
}

func (x *Worker) Reset() {
	*x = Worker{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Worker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Worker) ProtoMessage() {}

func (x *Worker) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Worker.ProtoReflect.Descriptor instead.
func (*Worker) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP(), []int{0}
}

func (x *Worker) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *Worker) GetProperties() []*Worker_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Worker) GetConfigs() []*Worker_Config {
	if x != nil {
		return x.Configs
	}
	return nil
}

// Any device, including computers, phones, accelerators (e.g. GPUs), etc. All
// names must be unique.
type Device struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The handle can be thought of as the "name" of the device, and must be
	// unique within a Worker.
	//
	// In the Status context, the handle should be some human-understandable name,
	// perhaps corresponding to a label physically written on the device to make
	// it easy to locate. In the Request context, the name should be the
	// *logical* name expected by the task. The bot is responsible for mapping the
	// logical name expected by the task to a machine-readable name that the task
	// can actually use, such as a USB address. The method by which this mapping
	// is communicated to the task is not covered in this API.
	Handle string `protobuf:"bytes,1,opt,name=handle,proto3" json:"handle,omitempty"`
	// Properties of this device that don't change based on the tasks that are
	// running on it, e.g. OS, CPU architecture, etc.
	//
	// Keys may be repeated, and have the following interpretation:
	//
	//    * Status context: the device can support *any* the listed values. For
	//    example, an "ISA" property might include "x86", "x86-64" and "sse4".
	//
	//    * Request context: the device *must* support *all* of the listed values.
	Properties []*Device_Property `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *Device) Reset() {
	*x = Device{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP(), []int{1}
}

func (x *Device) GetHandle() string {
	if x != nil {
		return x.Handle
	}
	return ""
}

func (x *Device) GetProperties() []*Device_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// A global property; see the `properties` field for more information.
type Worker_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For general information on keys, see the documentation to `Worker`.
	//
	// The current set of standard keys are:
	//
	// * pool: different workers can be reserved for different purposes. For
	// example, an admin might want to segregate long-running integration tests
	// from short-running unit tests, so unit tests will always get some
	// throughput. To support this, the server can assign different values for
	// `pool` (such as "itest" and "utest") to different workers, and then have
	// jobs request workers from those pools.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The property's value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Worker_Property) Reset() {
	*x = Worker_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Worker_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Worker_Property) ProtoMessage() {}

func (x *Worker_Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Worker_Property.ProtoReflect.Descriptor instead.
func (*Worker_Property) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Worker_Property) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Worker_Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A configuration request or report; see the `configs` field for more
// information.
type Worker_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For general information on keys, see the documentation to `Worker`.
	//
	// The current set of standard keys are:
	//
	// * DockerImage: the image of the container. When being reported by the
	// bot, the empty value should always be included if the bot is able to pull
	// its own images; the bot may optionally *also* report images that are
	// present in its cache. When being requested in a lease, the value is the
	// URI of the image (eg `gcr.io/user/image@sha256:hash`).
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The configuration's value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Worker_Config) Reset() {
	*x = Worker_Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Worker_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Worker_Config) ProtoMessage() {}

func (x *Worker_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Worker_Config.ProtoReflect.Descriptor instead.
func (*Worker_Config) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Worker_Config) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Worker_Config) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A device property; see `properties` for more information.
type Device_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For general information on keys, see the documentation to `Worker`.
	//
	// The current set of standard keys are:
	//
	// * os: a human-readable description of the OS. Examples include `linux`,
	// `ubuntu` and `ubuntu 14.04` (note that a bot may advertise itself as more
	// than one). This will be replaced in the future by more well-structured
	// keys and values to represent OS variants.
	//
	// * has-docker: "true" if the bot has Docker installed. This will be
	// replaced in the future by a more structured message for Docker support.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The property's value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Device_Property) Reset() {
	*x = Device_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Device_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device_Property) ProtoMessage() {}

func (x *Device_Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device_Property.ProtoReflect.Descriptor instead.
func (*Device_Property) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Device_Property) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Device_Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_devtools_remoteworkers_v1test2_worker_proto protoreflect.FileDescriptor

var file_google_devtools_remoteworkers_v1test2_worker_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x22, 0xdf, 0x02, 0x0a, 0x06,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x56, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x32, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x30, 0x0a, 0x06, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xac, 0x01,
	0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x12, 0x56, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x32, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0xe8, 0x01, 0x0a,
	0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x42, 0x13, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50,
	0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0xa2, 0x02, 0x02, 0x52, 0x57, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x76, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x56, 0x31, 0x54, 0x65, 0x73,
	0x74, 0x32, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x5c,
	0x56, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescOnce sync.Once
	file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescData = file_google_devtools_remoteworkers_v1test2_worker_proto_rawDesc
)

func file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescGZIP() []byte {
	file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescOnce.Do(func() {
		file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescData)
	})
	return file_google_devtools_remoteworkers_v1test2_worker_proto_rawDescData
}

var file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_devtools_remoteworkers_v1test2_worker_proto_goTypes = []interface{}{
	(*Worker)(nil),          // 0: google.devtools.remoteworkers.v1test2.Worker
	(*Device)(nil),          // 1: google.devtools.remoteworkers.v1test2.Device
	(*Worker_Property)(nil), // 2: google.devtools.remoteworkers.v1test2.Worker.Property
	(*Worker_Config)(nil),   // 3: google.devtools.remoteworkers.v1test2.Worker.Config
	(*Device_Property)(nil), // 4: google.devtools.remoteworkers.v1test2.Device.Property
}
var file_google_devtools_remoteworkers_v1test2_worker_proto_depIdxs = []int32{
	1, // 0: google.devtools.remoteworkers.v1test2.Worker.devices:type_name -> google.devtools.remoteworkers.v1test2.Device
	2, // 1: google.devtools.remoteworkers.v1test2.Worker.properties:type_name -> google.devtools.remoteworkers.v1test2.Worker.Property
	3, // 2: google.devtools.remoteworkers.v1test2.Worker.configs:type_name -> google.devtools.remoteworkers.v1test2.Worker.Config
	4, // 3: google.devtools.remoteworkers.v1test2.Device.properties:type_name -> google.devtools.remoteworkers.v1test2.Device.Property
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_devtools_remoteworkers_v1test2_worker_proto_init() }
func file_google_devtools_remoteworkers_v1test2_worker_proto_init() {
	if File_google_devtools_remoteworkers_v1test2_worker_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Worker); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Device); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Worker_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Worker_Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Device_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_remoteworkers_v1test2_worker_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_remoteworkers_v1test2_worker_proto_goTypes,
		DependencyIndexes: file_google_devtools_remoteworkers_v1test2_worker_proto_depIdxs,
		MessageInfos:      file_google_devtools_remoteworkers_v1test2_worker_proto_msgTypes,
	}.Build()
	File_google_devtools_remoteworkers_v1test2_worker_proto = out.File
	file_google_devtools_remoteworkers_v1test2_worker_proto_rawDesc = nil
	file_google_devtools_remoteworkers_v1test2_worker_proto_goTypes = nil
	file_google_devtools_remoteworkers_v1test2_worker_proto_depIdxs = nil
}
