// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/ads/googleads/v3/services/reach_plan_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [ReachForecastService.ListPlannableLocations][]
type ListPlannableLocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListPlannableLocationsRequest) Reset() {
	*x = ListPlannableLocationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPlannableLocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlannableLocationsRequest) ProtoMessage() {}

func (x *ListPlannableLocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlannableLocationsRequest.ProtoReflect.Descriptor instead.
func (*ListPlannableLocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{0}
}

// The list of plannable locations.
type ListPlannableLocationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of locations available for planning (Countries, DMAs,
	// sub-countries).
	// For locations like Countries, DMAs see
	// https://developers.google.com/adwords/api/docs/appendix/geotargeting for
	// more information.
	PlannableLocations []*PlannableLocation `protobuf:"bytes,1,rep,name=plannable_locations,json=plannableLocations,proto3" json:"plannable_locations,omitempty"`
}

func (x *ListPlannableLocationsResponse) Reset() {
	*x = ListPlannableLocationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPlannableLocationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlannableLocationsResponse) ProtoMessage() {}

func (x *ListPlannableLocationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlannableLocationsResponse.ProtoReflect.Descriptor instead.
func (*ListPlannableLocationsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListPlannableLocationsResponse) GetPlannableLocations() []*PlannableLocation {
	if x != nil {
		return x.PlannableLocations
	}
	return nil
}

// A plannable location: a country, a DMA, a metro region, a tv region,
// a province.
type PlannableLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location identifier.
	Id *wrappers.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The unique location name in english.
	Name *wrappers.StringValue `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The parent country code, not present if location is a country.
	// If present will always be a criterion id: additional information, such as
	// country name are returned both via ListPlannableLocations or directly by
	// accessing GeoTargetConstantService with the criterion id.
	ParentCountryId *wrappers.Int64Value `protobuf:"bytes,3,opt,name=parent_country_id,json=parentCountryId,proto3" json:"parent_country_id,omitempty"`
}

func (x *PlannableLocation) Reset() {
	*x = PlannableLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlannableLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannableLocation) ProtoMessage() {}

func (x *PlannableLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannableLocation.ProtoReflect.Descriptor instead.
func (*PlannableLocation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{2}
}

func (x *PlannableLocation) GetId() *wrappers.StringValue {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *PlannableLocation) GetName() *wrappers.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *PlannableLocation) GetParentCountryId() *wrappers.Int64Value {
	if x != nil {
		return x.ParentCountryId
	}
	return nil
}

// Request to list available products in a given location.
type ListPlannableProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the selected location for planning. To list the available
	// plannable location ids use ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
}

func (x *ListPlannableProductsRequest) Reset() {
	*x = ListPlannableProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPlannableProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlannableProductsRequest) ProtoMessage() {}

func (x *ListPlannableProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlannableProductsRequest.ProtoReflect.Descriptor instead.
func (*ListPlannableProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListPlannableProductsRequest) GetPlannableLocationId() *wrappers.StringValue {
	if x != nil {
		return x.PlannableLocationId
	}
	return nil
}

// A response with all available products.
type ListPlannableProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of products available for planning and related targeting metadata.
	ProductMetadata []*ProductMetadata `protobuf:"bytes,1,rep,name=product_metadata,json=productMetadata,proto3" json:"product_metadata,omitempty"`
}

func (x *ListPlannableProductsResponse) Reset() {
	*x = ListPlannableProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPlannableProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlannableProductsResponse) ProtoMessage() {}

func (x *ListPlannableProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlannableProductsResponse.ProtoReflect.Descriptor instead.
func (*ListPlannableProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListPlannableProductsResponse) GetProductMetadata() []*ProductMetadata {
	if x != nil {
		return x.ProductMetadata
	}
	return nil
}

// The metadata associated with an available plannable product.
type ProductMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The code associated with the ad product. E.g. Trueview, Bumper
	// To list the available plannable product codes use ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The allowed plannable targeting for this product.
	PlannableTargeting *PlannableTargeting `protobuf:"bytes,2,opt,name=plannable_targeting,json=plannableTargeting,proto3" json:"plannable_targeting,omitempty"`
}

func (x *ProductMetadata) Reset() {
	*x = ProductMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductMetadata) ProtoMessage() {}

func (x *ProductMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductMetadata.ProtoReflect.Descriptor instead.
func (*ProductMetadata) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{5}
}

func (x *ProductMetadata) GetPlannableProductCode() *wrappers.StringValue {
	if x != nil {
		return x.PlannableProductCode
	}
	return nil
}

func (x *ProductMetadata) GetPlannableTargeting() *PlannableTargeting {
	if x != nil {
		return x.PlannableTargeting
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type PlannableTargeting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allowed plannable age ranges for the product for which metrics will be
	// reported. Actual targeting is computed by mapping this age range onto
	// standard Google common.AgeRangeInfo values.
	AgeRanges []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,1,rep,packed,name=age_ranges,json=ageRanges,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_ranges,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,2,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices []*common.DeviceInfo `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	// Targetable networks for the ad product.
	Networks []enums.ReachPlanNetworkEnum_ReachPlanNetwork `protobuf:"varint,4,rep,packed,name=networks,proto3,enum=google.ads.googleads.v3.enums.ReachPlanNetworkEnum_ReachPlanNetwork" json:"networks,omitempty"`
}

func (x *PlannableTargeting) Reset() {
	*x = PlannableTargeting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlannableTargeting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannableTargeting) ProtoMessage() {}

func (x *PlannableTargeting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannableTargeting.ProtoReflect.Descriptor instead.
func (*PlannableTargeting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{6}
}

func (x *PlannableTargeting) GetAgeRanges() []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if x != nil {
		return x.AgeRanges
	}
	return nil
}

func (x *PlannableTargeting) GetGenders() []*common.GenderInfo {
	if x != nil {
		return x.Genders
	}
	return nil
}

func (x *PlannableTargeting) GetDevices() []*common.DeviceInfo {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *PlannableTargeting) GetNetworks() []enums.ReachPlanNetworkEnum_ReachPlanNetwork {
	if x != nil {
		return x.Networks
	}
	return nil
}

// Request message for [ReachForecastService.GenerateProductMixIdeas][].
type GenerateProductMixIdeasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The ID of the location, this is one of the ids returned by
	// ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,2,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required. Currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Total budget.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,4,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	// The preferences of the suggested product mix.
	// An unset preference is interpreted as all possible values are allowed,
	// unless explicitly specified.
	Preferences *Preferences `protobuf:"bytes,5,opt,name=preferences,proto3" json:"preferences,omitempty"`
}

func (x *GenerateProductMixIdeasRequest) Reset() {
	*x = GenerateProductMixIdeasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateProductMixIdeasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateProductMixIdeasRequest) ProtoMessage() {}

func (x *GenerateProductMixIdeasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateProductMixIdeasRequest.ProtoReflect.Descriptor instead.
func (*GenerateProductMixIdeasRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{7}
}

func (x *GenerateProductMixIdeasRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GenerateProductMixIdeasRequest) GetPlannableLocationId() *wrappers.StringValue {
	if x != nil {
		return x.PlannableLocationId
	}
	return nil
}

func (x *GenerateProductMixIdeasRequest) GetCurrencyCode() *wrappers.StringValue {
	if x != nil {
		return x.CurrencyCode
	}
	return nil
}

func (x *GenerateProductMixIdeasRequest) GetBudgetMicros() *wrappers.Int64Value {
	if x != nil {
		return x.BudgetMicros
	}
	return nil
}

func (x *GenerateProductMixIdeasRequest) GetPreferences() *Preferences {
	if x != nil {
		return x.Preferences
	}
	return nil
}

// Set of preferences about the planned mix.
type Preferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if ad skippable.
	// If not set, default is any value.
	IsSkippable *wrappers.BoolValue `protobuf:"bytes,1,opt,name=is_skippable,json=isSkippable,proto3" json:"is_skippable,omitempty"`
	// True if ad start with sound.
	// If not set, default is any value.
	StartsWithSound *wrappers.BoolValue `protobuf:"bytes,2,opt,name=starts_with_sound,json=startsWithSound,proto3" json:"starts_with_sound,omitempty"`
	// The length of the ad.
	// If not set, default is any value.
	AdLength enums.ReachPlanAdLengthEnum_ReachPlanAdLength `protobuf:"varint,3,opt,name=ad_length,json=adLength,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAdLengthEnum_ReachPlanAdLength" json:"ad_length,omitempty"`
	// True if ad will only show on the top content.
	// If not set, default is false.
	TopContentOnly *wrappers.BoolValue `protobuf:"bytes,4,opt,name=top_content_only,json=topContentOnly,proto3" json:"top_content_only,omitempty"`
	// True if the price guaranteed. The cost of serving the ad is agreed upfront
	// and not subject to an auction.
	// If not set, default is any value.
	HasGuaranteedPrice *wrappers.BoolValue `protobuf:"bytes,5,opt,name=has_guaranteed_price,json=hasGuaranteedPrice,proto3" json:"has_guaranteed_price,omitempty"`
}

func (x *Preferences) Reset() {
	*x = Preferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Preferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preferences) ProtoMessage() {}

func (x *Preferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preferences.ProtoReflect.Descriptor instead.
func (*Preferences) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{8}
}

func (x *Preferences) GetIsSkippable() *wrappers.BoolValue {
	if x != nil {
		return x.IsSkippable
	}
	return nil
}

func (x *Preferences) GetStartsWithSound() *wrappers.BoolValue {
	if x != nil {
		return x.StartsWithSound
	}
	return nil
}

func (x *Preferences) GetAdLength() enums.ReachPlanAdLengthEnum_ReachPlanAdLength {
	if x != nil {
		return x.AdLength
	}
	return enums.ReachPlanAdLengthEnum_UNSPECIFIED
}

func (x *Preferences) GetTopContentOnly() *wrappers.BoolValue {
	if x != nil {
		return x.TopContentOnly
	}
	return nil
}

func (x *Preferences) GetHasGuaranteedPrice() *wrappers.BoolValue {
	if x != nil {
		return x.HasGuaranteedPrice
	}
	return nil
}

// The suggested product mix.
type GenerateProductMixIdeasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of products (ad formats) and the associated budget allocation idea.
	ProductAllocation []*ProductAllocation `protobuf:"bytes,1,rep,name=product_allocation,json=productAllocation,proto3" json:"product_allocation,omitempty"`
}

func (x *GenerateProductMixIdeasResponse) Reset() {
	*x = GenerateProductMixIdeasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateProductMixIdeasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateProductMixIdeasResponse) ProtoMessage() {}

func (x *GenerateProductMixIdeasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateProductMixIdeasResponse.ProtoReflect.Descriptor instead.
func (*GenerateProductMixIdeasResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{9}
}

func (x *GenerateProductMixIdeasResponse) GetProductAllocation() []*ProductAllocation {
	if x != nil {
		return x.ProductAllocation
	}
	return nil
}

// An allocation of a part of the budget on a given product.
type ProductAllocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selected product for planning. The product codes returned are within the
	// set of the ones returned by ListPlannableProducts when using the same
	// location id.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The value to be allocated for the suggested product in requested currency.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
}

func (x *ProductAllocation) Reset() {
	*x = ProductAllocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductAllocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductAllocation) ProtoMessage() {}

func (x *ProductAllocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductAllocation.ProtoReflect.Descriptor instead.
func (*ProductAllocation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{10}
}

func (x *ProductAllocation) GetPlannableProductCode() *wrappers.StringValue {
	if x != nil {
		return x.PlannableProductCode
	}
	return nil
}

func (x *ProductAllocation) GetBudgetMicros() *wrappers.Int64Value {
	if x != nil {
		return x.BudgetMicros
	}
	return nil
}

// Request message for [ReachPlanService.GenerateReachForecast][google.ads.googleads.v3.services.ReachPlanService.GenerateReachForecast].
type GenerateReachForecastRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Campaign duration.
	CampaignDuration *CampaignDuration `protobuf:"bytes,3,opt,name=campaign_duration,json=campaignDuration,proto3" json:"campaign_duration,omitempty"`
	// Desired cookie frequency cap that will be applied to each planned product.
	// This is equivalent to the frequency cap exposed in Google Ads when creating
	// a campaign, it represents the maximum number of times an ad can be shown to
	// the same user.
	// If not specified, no cap is applied.
	CookieFrequencyCap *wrappers.Int32Value `protobuf:"bytes,4,opt,name=cookie_frequency_cap,json=cookieFrequencyCap,proto3" json:"cookie_frequency_cap,omitempty"`
	// Desired minimum effective frequency (the number of times a person was
	// exposed to the ad) for the reported reach metrics [1-10].
	// This won't affect the targeting, but just the reporting.
	// If not specified, a default of 1 is applied.
	MinEffectiveFrequency *wrappers.Int32Value `protobuf:"bytes,5,opt,name=min_effective_frequency,json=minEffectiveFrequency,proto3" json:"min_effective_frequency,omitempty"`
	// The targeting to be applied to all products selected in the product mix.
	//
	// This is planned targeting: execution details might vary based on the
	// advertising product, please consult an implementation specialist.
	//
	// See specific metrics for details on how targeting affects them.
	//
	// In some cases, targeting may be overridden using the
	// PlannedProduct.advanced_product_targeting field.
	Targeting *Targeting `protobuf:"bytes,6,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Required. The products to be forecast.
	// The max number of allowed planned products is 15.
	PlannedProducts []*PlannedProduct `protobuf:"bytes,7,rep,name=planned_products,json=plannedProducts,proto3" json:"planned_products,omitempty"`
}

func (x *GenerateReachForecastRequest) Reset() {
	*x = GenerateReachForecastRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateReachForecastRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateReachForecastRequest) ProtoMessage() {}

func (x *GenerateReachForecastRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateReachForecastRequest.ProtoReflect.Descriptor instead.
func (*GenerateReachForecastRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateReachForecastRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GenerateReachForecastRequest) GetCurrencyCode() *wrappers.StringValue {
	if x != nil {
		return x.CurrencyCode
	}
	return nil
}

func (x *GenerateReachForecastRequest) GetCampaignDuration() *CampaignDuration {
	if x != nil {
		return x.CampaignDuration
	}
	return nil
}

func (x *GenerateReachForecastRequest) GetCookieFrequencyCap() *wrappers.Int32Value {
	if x != nil {
		return x.CookieFrequencyCap
	}
	return nil
}

func (x *GenerateReachForecastRequest) GetMinEffectiveFrequency() *wrappers.Int32Value {
	if x != nil {
		return x.MinEffectiveFrequency
	}
	return nil
}

func (x *GenerateReachForecastRequest) GetTargeting() *Targeting {
	if x != nil {
		return x.Targeting
	}
	return nil
}

func (x *GenerateReachForecastRequest) GetPlannedProducts() []*PlannedProduct {
	if x != nil {
		return x.PlannedProducts
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type Targeting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the selected location.
	// Plannable locations ID can be obtained from ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Targeted age range.
	// If not specified, targets all age ranges.
	AgeRange enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,2,opt,name=age_range,json=ageRange,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_range,omitempty"`
	// Targeted genders.
	// If not specified, targets all genders.
	Genders []*common.GenderInfo `protobuf:"bytes,3,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targeted devices.
	// If not specified, targets all applicable devices. Applicable devices vary
	// by product and region and can be obtained from ListPlannableProducts.
	Devices []*common.DeviceInfo `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	// Targetable network for the ad product.
	// If not specified, targets all applicable networks. Applicable networks vary
	// by product and region and can be obtained from ListPlannableProducts.
	Network enums.ReachPlanNetworkEnum_ReachPlanNetwork `protobuf:"varint,5,opt,name=network,proto3,enum=google.ads.googleads.v3.enums.ReachPlanNetworkEnum_ReachPlanNetwork" json:"network,omitempty"`
}

func (x *Targeting) Reset() {
	*x = Targeting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Targeting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Targeting) ProtoMessage() {}

func (x *Targeting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Targeting.ProtoReflect.Descriptor instead.
func (*Targeting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{12}
}

func (x *Targeting) GetPlannableLocationId() *wrappers.StringValue {
	if x != nil {
		return x.PlannableLocationId
	}
	return nil
}

func (x *Targeting) GetAgeRange() enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if x != nil {
		return x.AgeRange
	}
	return enums.ReachPlanAgeRangeEnum_UNSPECIFIED
}

func (x *Targeting) GetGenders() []*common.GenderInfo {
	if x != nil {
		return x.Genders
	}
	return nil
}

func (x *Targeting) GetDevices() []*common.DeviceInfo {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *Targeting) GetNetwork() enums.ReachPlanNetworkEnum_ReachPlanNetwork {
	if x != nil {
		return x.Network
	}
	return enums.ReachPlanNetworkEnum_UNSPECIFIED
}

// The duration of a planned campaign.
type CampaignDuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration value in days.
	DurationInDays *wrappers.Int32Value `protobuf:"bytes,1,opt,name=duration_in_days,json=durationInDays,proto3" json:"duration_in_days,omitempty"`
}

func (x *CampaignDuration) Reset() {
	*x = CampaignDuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CampaignDuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CampaignDuration) ProtoMessage() {}

func (x *CampaignDuration) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CampaignDuration.ProtoReflect.Descriptor instead.
func (*CampaignDuration) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{13}
}

func (x *CampaignDuration) GetDurationInDays() *wrappers.Int32Value {
	if x != nil {
		return x.DurationInDays
	}
	return nil
}

// A product being planned for reach.
type PlannedProduct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Selected product for planning.
	// Plannable products codes can be obtained from ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// Required. Maximum budget allocation in micros for the selected product.
	// The value is specified in the selected planning currency_code.
	// E.g. 1 000 000$ = 1 000 000 000 000 micros.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
}

func (x *PlannedProduct) Reset() {
	*x = PlannedProduct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlannedProduct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedProduct) ProtoMessage() {}

func (x *PlannedProduct) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedProduct.ProtoReflect.Descriptor instead.
func (*PlannedProduct) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{14}
}

func (x *PlannedProduct) GetPlannableProductCode() *wrappers.StringValue {
	if x != nil {
		return x.PlannableProductCode
	}
	return nil
}

func (x *PlannedProduct) GetBudgetMicros() *wrappers.Int64Value {
	if x != nil {
		return x.BudgetMicros
	}
	return nil
}

// Response message containing the generated reach curve.
type GenerateReachForecastResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference on target audiences for this curve.
	OnTargetAudienceMetrics *OnTargetAudienceMetrics `protobuf:"bytes,1,opt,name=on_target_audience_metrics,json=onTargetAudienceMetrics,proto3" json:"on_target_audience_metrics,omitempty"`
	// The generated reach curve for the planned product mix.
	ReachCurve *ReachCurve `protobuf:"bytes,2,opt,name=reach_curve,json=reachCurve,proto3" json:"reach_curve,omitempty"`
}

func (x *GenerateReachForecastResponse) Reset() {
	*x = GenerateReachForecastResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateReachForecastResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateReachForecastResponse) ProtoMessage() {}

func (x *GenerateReachForecastResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateReachForecastResponse.ProtoReflect.Descriptor instead.
func (*GenerateReachForecastResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{15}
}

func (x *GenerateReachForecastResponse) GetOnTargetAudienceMetrics() *OnTargetAudienceMetrics {
	if x != nil {
		return x.OnTargetAudienceMetrics
	}
	return nil
}

func (x *GenerateReachForecastResponse) GetReachCurve() *ReachCurve {
	if x != nil {
		return x.ReachCurve
	}
	return nil
}

// The reach curve for the planned products.
type ReachCurve struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All points on the reach curve.
	ReachForecasts []*ReachForecast `protobuf:"bytes,1,rep,name=reach_forecasts,json=reachForecasts,proto3" json:"reach_forecasts,omitempty"`
}

func (x *ReachCurve) Reset() {
	*x = ReachCurve{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReachCurve) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReachCurve) ProtoMessage() {}

func (x *ReachCurve) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReachCurve.ProtoReflect.Descriptor instead.
func (*ReachCurve) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{16}
}

func (x *ReachCurve) GetReachForecasts() []*ReachForecast {
	if x != nil {
		return x.ReachForecasts
	}
	return nil
}

// A point on reach curve.
type ReachForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Forecasted traffic metrics for this point.
	Forecast *Forecast `protobuf:"bytes,2,opt,name=forecast,proto3" json:"forecast,omitempty"`
	// The forecasted allocation. This differs from the input allocation if one
	// or more product cannot fulfill the budget because of limited inventory.
	ForecastedProductAllocations []*ProductAllocation `protobuf:"bytes,3,rep,name=forecasted_product_allocations,json=forecastedProductAllocations,proto3" json:"forecasted_product_allocations,omitempty"`
}

func (x *ReachForecast) Reset() {
	*x = ReachForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReachForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReachForecast) ProtoMessage() {}

func (x *ReachForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReachForecast.ProtoReflect.Descriptor instead.
func (*ReachForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{17}
}

func (x *ReachForecast) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *ReachForecast) GetForecast() *Forecast {
	if x != nil {
		return x.Forecast
	}
	return nil
}

func (x *ReachForecast) GetForecastedProductAllocations() []*ProductAllocation {
	if x != nil {
		return x.ForecastedProductAllocations
	}
	return nil
}

// Forecasted traffic metrics for the planned products and targeting.
type Forecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times that exactly
	// matches the Targeting.
	OnTargetReach *wrappers.Int64Value `protobuf:"bytes,1,opt,name=on_target_reach,json=onTargetReach,proto3" json:"on_target_reach,omitempty"`
	// Total number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times. This includes
	// people that may fall outside the specified Targeting.
	TotalReach *wrappers.Int64Value `protobuf:"bytes,2,opt,name=total_reach,json=totalReach,proto3" json:"total_reach,omitempty"`
	// Number of ad impressions that exactly matches the Targeting.
	OnTargetImpressions *wrappers.Int64Value `protobuf:"bytes,3,opt,name=on_target_impressions,json=onTargetImpressions,proto3" json:"on_target_impressions,omitempty"`
	// Total number of ad impressions. This includes impressions that may fall
	// outside the specified Targeting, due to insufficient information on
	// signed-in users.
	TotalImpressions *wrappers.Int64Value `protobuf:"bytes,4,opt,name=total_impressions,json=totalImpressions,proto3" json:"total_impressions,omitempty"`
}

func (x *Forecast) Reset() {
	*x = Forecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Forecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Forecast) ProtoMessage() {}

func (x *Forecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Forecast.ProtoReflect.Descriptor instead.
func (*Forecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{18}
}

func (x *Forecast) GetOnTargetReach() *wrappers.Int64Value {
	if x != nil {
		return x.OnTargetReach
	}
	return nil
}

func (x *Forecast) GetTotalReach() *wrappers.Int64Value {
	if x != nil {
		return x.TotalReach
	}
	return nil
}

func (x *Forecast) GetOnTargetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.OnTargetImpressions
	}
	return nil
}

func (x *Forecast) GetTotalImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.TotalImpressions
	}
	return nil
}

// Audience metrics for the planned products.
// These metrics consider the following targeting dimensions:
//
// - Location
// - PlannableAgeRange
// - Gender
type OnTargetAudienceMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference audience size matching the considered targeting for YouTube.
	YoutubeAudienceSize *wrappers.Int64Value `protobuf:"bytes,1,opt,name=youtube_audience_size,json=youtubeAudienceSize,proto3" json:"youtube_audience_size,omitempty"`
	// Reference audience size matching the considered targeting for Census.
	CensusAudienceSize *wrappers.Int64Value `protobuf:"bytes,2,opt,name=census_audience_size,json=censusAudienceSize,proto3" json:"census_audience_size,omitempty"`
}

func (x *OnTargetAudienceMetrics) Reset() {
	*x = OnTargetAudienceMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnTargetAudienceMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnTargetAudienceMetrics) ProtoMessage() {}

func (x *OnTargetAudienceMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnTargetAudienceMetrics.ProtoReflect.Descriptor instead.
func (*OnTargetAudienceMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP(), []int{19}
}

func (x *OnTargetAudienceMetrics) GetYoutubeAudienceSize() *wrappers.Int64Value {
	if x != nil {
		return x.YoutubeAudienceSize
	}
	return nil
}

func (x *OnTargetAudienceMetrics) GetCensusAudienceSize() *wrappers.Int64Value {
	if x != nil {
		return x.CensusAudienceSize
	}
	return nil
}

var File_google_ads_googleads_v3_services_reach_plan_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x2d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x5f, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x1f, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x86, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x11, 0x50,
	0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x69, 0x64, 0x12, 0x30,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x47, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x22, 0x75, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x15, 0x70, 0x6c, 0x61,
	0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x70, 0x6c, 0x61,
	0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x7d, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5c, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xcc, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x16, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x14, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x65, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x6e, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x22, 0xe9,
	0x02, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x65, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x09, 0x61, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x07,
	0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x47,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x67, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x44, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x08, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68,
	0x50, 0x6c, 0x61, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x52, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0xfd, 0x02, 0x0a, 0x1e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x69,
	0x78, 0x49, 0x64, 0x65, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x55, 0x0a, 0x15, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x0d, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x0b, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x8d, 0x03, 0x0a, 0x0b, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x69, 0x73,
	0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x69, 0x73,
	0x53, 0x6b, 0x69, 0x70, 0x70, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x57, 0x69, 0x74, 0x68, 0x53, 0x6f, 0x75, 0x6e,
	0x64, 0x12, 0x63, 0x0a, 0x09, 0x61, 0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68,
	0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x08, 0x61, 0x64,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x44, 0x0a, 0x10, 0x74, 0x6f, 0x70, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x74, 0x6f,
	0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x4c, 0x0a, 0x14,
	0x68, 0x61, 0x73, 0x5f, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x68, 0x61, 0x73, 0x47, 0x75, 0x61, 0x72, 0x61,
	0x6e, 0x74, 0x65, 0x65, 0x64, 0x50, 0x72, 0x69, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x1f, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x69,
	0x78, 0x49, 0x64, 0x65, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x62,
	0x0a, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa9, 0x01, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x16, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0d,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0c, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x22, 0xbe,
	0x04, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63, 0x68,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x64, 0x0a, 0x11, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d,
	0x0a, 0x14, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x63, 0x61, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x63, 0x6f, 0x6f, 0x6b, 0x69,
	0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x61, 0x70, 0x12, 0x53, 0x0a,
	0x17, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x6d, 0x69, 0x6e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x49, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x60, 0x0a,
	0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x22,
	0xae, 0x03, 0x0a, 0x09, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x50, 0x0a,
	0x15, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x63, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c,
	0x61, 0x6e, 0x41, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x61, 0x67, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x07, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x12, 0x44, 0x0a, 0x07, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x5e, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x22, 0x59, 0x0a, 0x10, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x10, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x0e,
	0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x52,
	0x0a, 0x16, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x70, 0x6c,
	0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x40, 0x0a, 0x0d, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x22, 0xe6, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x61, 0x63, 0x68, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x1a, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4f, 0x6e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x17, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x4d,
	0x0a, 0x0b, 0x72, 0x65, 0x61, 0x63, 0x68, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x43, 0x75, 0x72, 0x76,
	0x65, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x63, 0x68, 0x43, 0x75, 0x72, 0x76, 0x65, 0x22, 0x66, 0x0a,
	0x0a, 0x52, 0x65, 0x61, 0x63, 0x68, 0x43, 0x75, 0x72, 0x76, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x73, 0x22, 0x90, 0x02, 0x0a, 0x0d, 0x52, 0x65, 0x61, 0x63, 0x68, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x52, 0x08, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x79, 0x0a,
	0x1e, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x66, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa8, 0x02, 0x0a, 0x08, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x0f, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6f, 0x6e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x61, 0x63, 0x68, 0x12, 0x3c, 0x0a, 0x0b, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x52, 0x65, 0x61, 0x63, 0x68, 0x12, 0x4f, 0x0a, 0x15, 0x6f, 0x6e, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x11, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xb9, 0x01, 0x0a, 0x17, 0x4f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x4f, 0x0a, 0x15, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x79, 0x6f, 0x75,
	0x74, 0x75, 0x62, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x4d, 0x0a, 0x14, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x32,
	0xfd, 0x07, 0x0a, 0x10, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61,
	0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x25, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x22, 0x1a, 0x2f, 0x76, 0x33, 0x3a,
	0x6c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xd6, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x22, 0x19, 0x2f, 0x76,
	0x33, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x15, 0x70, 0x6c, 0x61,
	0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x12, 0xa1, 0x02, 0x0a, 0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x69, 0x78, 0x49, 0x64, 0x65, 0x61, 0x73, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x4d, 0x69, 0x78, 0x49, 0x64, 0x65, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x4d, 0x69, 0x78, 0x49, 0x64, 0x65, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x80, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x69, 0x78, 0x49, 0x64,
	0x65, 0x61, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x2c, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x2c, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x2c, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x89, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63, 0x68, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63,
	0x68, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63,
	0x68, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x33, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x61, 0x63, 0x68, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x2e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2c, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42,
	0xfc, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x15, 0x52, 0x65, 0x61, 0x63, 0x68, 0x50,
	0x6c, 0x61, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41,
	0x41, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64,
	0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x3a, 0x3a, 0x56, 0x33, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescData = file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDesc
)

func file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDescData
}

var file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_ads_googleads_v3_services_reach_plan_service_proto_goTypes = []interface{}{
	(*ListPlannableLocationsRequest)(nil),              // 0: google.ads.googleads.v3.services.ListPlannableLocationsRequest
	(*ListPlannableLocationsResponse)(nil),             // 1: google.ads.googleads.v3.services.ListPlannableLocationsResponse
	(*PlannableLocation)(nil),                          // 2: google.ads.googleads.v3.services.PlannableLocation
	(*ListPlannableProductsRequest)(nil),               // 3: google.ads.googleads.v3.services.ListPlannableProductsRequest
	(*ListPlannableProductsResponse)(nil),              // 4: google.ads.googleads.v3.services.ListPlannableProductsResponse
	(*ProductMetadata)(nil),                            // 5: google.ads.googleads.v3.services.ProductMetadata
	(*PlannableTargeting)(nil),                         // 6: google.ads.googleads.v3.services.PlannableTargeting
	(*GenerateProductMixIdeasRequest)(nil),             // 7: google.ads.googleads.v3.services.GenerateProductMixIdeasRequest
	(*Preferences)(nil),                                // 8: google.ads.googleads.v3.services.Preferences
	(*GenerateProductMixIdeasResponse)(nil),            // 9: google.ads.googleads.v3.services.GenerateProductMixIdeasResponse
	(*ProductAllocation)(nil),                          // 10: google.ads.googleads.v3.services.ProductAllocation
	(*GenerateReachForecastRequest)(nil),               // 11: google.ads.googleads.v3.services.GenerateReachForecastRequest
	(*Targeting)(nil),                                  // 12: google.ads.googleads.v3.services.Targeting
	(*CampaignDuration)(nil),                           // 13: google.ads.googleads.v3.services.CampaignDuration
	(*PlannedProduct)(nil),                             // 14: google.ads.googleads.v3.services.PlannedProduct
	(*GenerateReachForecastResponse)(nil),              // 15: google.ads.googleads.v3.services.GenerateReachForecastResponse
	(*ReachCurve)(nil),                                 // 16: google.ads.googleads.v3.services.ReachCurve
	(*ReachForecast)(nil),                              // 17: google.ads.googleads.v3.services.ReachForecast
	(*Forecast)(nil),                                   // 18: google.ads.googleads.v3.services.Forecast
	(*OnTargetAudienceMetrics)(nil),                    // 19: google.ads.googleads.v3.services.OnTargetAudienceMetrics
	(*wrappers.StringValue)(nil),                       // 20: google.protobuf.StringValue
	(*wrappers.Int64Value)(nil),                        // 21: google.protobuf.Int64Value
	(enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange)(0), // 22: google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum.ReachPlanAgeRange
	(*common.GenderInfo)(nil),                          // 23: google.ads.googleads.v3.common.GenderInfo
	(*common.DeviceInfo)(nil),                          // 24: google.ads.googleads.v3.common.DeviceInfo
	(enums.ReachPlanNetworkEnum_ReachPlanNetwork)(0),   // 25: google.ads.googleads.v3.enums.ReachPlanNetworkEnum.ReachPlanNetwork
	(*wrappers.BoolValue)(nil),                         // 26: google.protobuf.BoolValue
	(enums.ReachPlanAdLengthEnum_ReachPlanAdLength)(0), // 27: google.ads.googleads.v3.enums.ReachPlanAdLengthEnum.ReachPlanAdLength
	(*wrappers.Int32Value)(nil),                        // 28: google.protobuf.Int32Value
}
var file_google_ads_googleads_v3_services_reach_plan_service_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v3.services.ListPlannableLocationsResponse.plannable_locations:type_name -> google.ads.googleads.v3.services.PlannableLocation
	20, // 1: google.ads.googleads.v3.services.PlannableLocation.id:type_name -> google.protobuf.StringValue
	20, // 2: google.ads.googleads.v3.services.PlannableLocation.name:type_name -> google.protobuf.StringValue
	21, // 3: google.ads.googleads.v3.services.PlannableLocation.parent_country_id:type_name -> google.protobuf.Int64Value
	20, // 4: google.ads.googleads.v3.services.ListPlannableProductsRequest.plannable_location_id:type_name -> google.protobuf.StringValue
	5,  // 5: google.ads.googleads.v3.services.ListPlannableProductsResponse.product_metadata:type_name -> google.ads.googleads.v3.services.ProductMetadata
	20, // 6: google.ads.googleads.v3.services.ProductMetadata.plannable_product_code:type_name -> google.protobuf.StringValue
	6,  // 7: google.ads.googleads.v3.services.ProductMetadata.plannable_targeting:type_name -> google.ads.googleads.v3.services.PlannableTargeting
	22, // 8: google.ads.googleads.v3.services.PlannableTargeting.age_ranges:type_name -> google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum.ReachPlanAgeRange
	23, // 9: google.ads.googleads.v3.services.PlannableTargeting.genders:type_name -> google.ads.googleads.v3.common.GenderInfo
	24, // 10: google.ads.googleads.v3.services.PlannableTargeting.devices:type_name -> google.ads.googleads.v3.common.DeviceInfo
	25, // 11: google.ads.googleads.v3.services.PlannableTargeting.networks:type_name -> google.ads.googleads.v3.enums.ReachPlanNetworkEnum.ReachPlanNetwork
	20, // 12: google.ads.googleads.v3.services.GenerateProductMixIdeasRequest.plannable_location_id:type_name -> google.protobuf.StringValue
	20, // 13: google.ads.googleads.v3.services.GenerateProductMixIdeasRequest.currency_code:type_name -> google.protobuf.StringValue
	21, // 14: google.ads.googleads.v3.services.GenerateProductMixIdeasRequest.budget_micros:type_name -> google.protobuf.Int64Value
	8,  // 15: google.ads.googleads.v3.services.GenerateProductMixIdeasRequest.preferences:type_name -> google.ads.googleads.v3.services.Preferences
	26, // 16: google.ads.googleads.v3.services.Preferences.is_skippable:type_name -> google.protobuf.BoolValue
	26, // 17: google.ads.googleads.v3.services.Preferences.starts_with_sound:type_name -> google.protobuf.BoolValue
	27, // 18: google.ads.googleads.v3.services.Preferences.ad_length:type_name -> google.ads.googleads.v3.enums.ReachPlanAdLengthEnum.ReachPlanAdLength
	26, // 19: google.ads.googleads.v3.services.Preferences.top_content_only:type_name -> google.protobuf.BoolValue
	26, // 20: google.ads.googleads.v3.services.Preferences.has_guaranteed_price:type_name -> google.protobuf.BoolValue
	10, // 21: google.ads.googleads.v3.services.GenerateProductMixIdeasResponse.product_allocation:type_name -> google.ads.googleads.v3.services.ProductAllocation
	20, // 22: google.ads.googleads.v3.services.ProductAllocation.plannable_product_code:type_name -> google.protobuf.StringValue
	21, // 23: google.ads.googleads.v3.services.ProductAllocation.budget_micros:type_name -> google.protobuf.Int64Value
	20, // 24: google.ads.googleads.v3.services.GenerateReachForecastRequest.currency_code:type_name -> google.protobuf.StringValue
	13, // 25: google.ads.googleads.v3.services.GenerateReachForecastRequest.campaign_duration:type_name -> google.ads.googleads.v3.services.CampaignDuration
	28, // 26: google.ads.googleads.v3.services.GenerateReachForecastRequest.cookie_frequency_cap:type_name -> google.protobuf.Int32Value
	28, // 27: google.ads.googleads.v3.services.GenerateReachForecastRequest.min_effective_frequency:type_name -> google.protobuf.Int32Value
	12, // 28: google.ads.googleads.v3.services.GenerateReachForecastRequest.targeting:type_name -> google.ads.googleads.v3.services.Targeting
	14, // 29: google.ads.googleads.v3.services.GenerateReachForecastRequest.planned_products:type_name -> google.ads.googleads.v3.services.PlannedProduct
	20, // 30: google.ads.googleads.v3.services.Targeting.plannable_location_id:type_name -> google.protobuf.StringValue
	22, // 31: google.ads.googleads.v3.services.Targeting.age_range:type_name -> google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum.ReachPlanAgeRange
	23, // 32: google.ads.googleads.v3.services.Targeting.genders:type_name -> google.ads.googleads.v3.common.GenderInfo
	24, // 33: google.ads.googleads.v3.services.Targeting.devices:type_name -> google.ads.googleads.v3.common.DeviceInfo
	25, // 34: google.ads.googleads.v3.services.Targeting.network:type_name -> google.ads.googleads.v3.enums.ReachPlanNetworkEnum.ReachPlanNetwork
	28, // 35: google.ads.googleads.v3.services.CampaignDuration.duration_in_days:type_name -> google.protobuf.Int32Value
	20, // 36: google.ads.googleads.v3.services.PlannedProduct.plannable_product_code:type_name -> google.protobuf.StringValue
	21, // 37: google.ads.googleads.v3.services.PlannedProduct.budget_micros:type_name -> google.protobuf.Int64Value
	19, // 38: google.ads.googleads.v3.services.GenerateReachForecastResponse.on_target_audience_metrics:type_name -> google.ads.googleads.v3.services.OnTargetAudienceMetrics
	16, // 39: google.ads.googleads.v3.services.GenerateReachForecastResponse.reach_curve:type_name -> google.ads.googleads.v3.services.ReachCurve
	17, // 40: google.ads.googleads.v3.services.ReachCurve.reach_forecasts:type_name -> google.ads.googleads.v3.services.ReachForecast
	21, // 41: google.ads.googleads.v3.services.ReachForecast.cost_micros:type_name -> google.protobuf.Int64Value
	18, // 42: google.ads.googleads.v3.services.ReachForecast.forecast:type_name -> google.ads.googleads.v3.services.Forecast
	10, // 43: google.ads.googleads.v3.services.ReachForecast.forecasted_product_allocations:type_name -> google.ads.googleads.v3.services.ProductAllocation
	21, // 44: google.ads.googleads.v3.services.Forecast.on_target_reach:type_name -> google.protobuf.Int64Value
	21, // 45: google.ads.googleads.v3.services.Forecast.total_reach:type_name -> google.protobuf.Int64Value
	21, // 46: google.ads.googleads.v3.services.Forecast.on_target_impressions:type_name -> google.protobuf.Int64Value
	21, // 47: google.ads.googleads.v3.services.Forecast.total_impressions:type_name -> google.protobuf.Int64Value
	21, // 48: google.ads.googleads.v3.services.OnTargetAudienceMetrics.youtube_audience_size:type_name -> google.protobuf.Int64Value
	21, // 49: google.ads.googleads.v3.services.OnTargetAudienceMetrics.census_audience_size:type_name -> google.protobuf.Int64Value
	0,  // 50: google.ads.googleads.v3.services.ReachPlanService.ListPlannableLocations:input_type -> google.ads.googleads.v3.services.ListPlannableLocationsRequest
	3,  // 51: google.ads.googleads.v3.services.ReachPlanService.ListPlannableProducts:input_type -> google.ads.googleads.v3.services.ListPlannableProductsRequest
	7,  // 52: google.ads.googleads.v3.services.ReachPlanService.GenerateProductMixIdeas:input_type -> google.ads.googleads.v3.services.GenerateProductMixIdeasRequest
	11, // 53: google.ads.googleads.v3.services.ReachPlanService.GenerateReachForecast:input_type -> google.ads.googleads.v3.services.GenerateReachForecastRequest
	1,  // 54: google.ads.googleads.v3.services.ReachPlanService.ListPlannableLocations:output_type -> google.ads.googleads.v3.services.ListPlannableLocationsResponse
	4,  // 55: google.ads.googleads.v3.services.ReachPlanService.ListPlannableProducts:output_type -> google.ads.googleads.v3.services.ListPlannableProductsResponse
	9,  // 56: google.ads.googleads.v3.services.ReachPlanService.GenerateProductMixIdeas:output_type -> google.ads.googleads.v3.services.GenerateProductMixIdeasResponse
	15, // 57: google.ads.googleads.v3.services.ReachPlanService.GenerateReachForecast:output_type -> google.ads.googleads.v3.services.GenerateReachForecastResponse
	54, // [54:58] is the sub-list for method output_type
	50, // [50:54] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_services_reach_plan_service_proto_init() }
func file_google_ads_googleads_v3_services_reach_plan_service_proto_init() {
	if File_google_ads_googleads_v3_services_reach_plan_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPlannableLocationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPlannableLocationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlannableLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPlannableProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPlannableProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlannableTargeting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateProductMixIdeasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Preferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateProductMixIdeasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductAllocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateReachForecastRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Targeting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CampaignDuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlannedProduct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateReachForecastResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReachCurve); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReachForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Forecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnTargetAudienceMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v3_services_reach_plan_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_services_reach_plan_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_services_reach_plan_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_services_reach_plan_service_proto = out.File
	file_google_ads_googleads_v3_services_reach_plan_service_proto_rawDesc = nil
	file_google_ads_googleads_v3_services_reach_plan_service_proto_goTypes = nil
	file_google_ads_googleads_v3_services_reach_plan_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReachPlanServiceClient is the client API for ReachPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReachPlanServiceClient interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error)
}

type reachPlanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReachPlanServiceClient(cc grpc.ClientConnInterface) ReachPlanServiceClient {
	return &reachPlanServiceClient{cc}
}

func (c *reachPlanServiceClient) ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error) {
	out := new(ListPlannableLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error) {
	out := new(ListPlannableProductsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error) {
	out := new(GenerateProductMixIdeasResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/GenerateProductMixIdeas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error) {
	out := new(GenerateReachForecastResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/GenerateReachForecast", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReachPlanServiceServer is the server API for ReachPlanService service.
type ReachPlanServiceServer interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(context.Context, *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(context.Context, *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(context.Context, *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(context.Context, *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error)
}

// UnimplementedReachPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReachPlanServiceServer struct {
}

func (*UnimplementedReachPlanServiceServer) ListPlannableLocations(context.Context, *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableLocations not implemented")
}
func (*UnimplementedReachPlanServiceServer) ListPlannableProducts(context.Context, *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableProducts not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateProductMixIdeas(context.Context, *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateProductMixIdeas not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateReachForecast(context.Context, *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateReachForecast not implemented")
}

func RegisterReachPlanServiceServer(s *grpc.Server, srv ReachPlanServiceServer) {
	s.RegisterService(&_ReachPlanService_serviceDesc, srv)
}

func _ReachPlanService_ListPlannableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, req.(*ListPlannableLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_ListPlannableProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, req.(*ListPlannableProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateProductMixIdeas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateProductMixIdeasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/GenerateProductMixIdeas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, req.(*GenerateProductMixIdeasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateReachForecast_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateReachForecastRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/GenerateReachForecast",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, req.(*GenerateReachForecastRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReachPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.ReachPlanService",
	HandlerType: (*ReachPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPlannableLocations",
			Handler:    _ReachPlanService_ListPlannableLocations_Handler,
		},
		{
			MethodName: "ListPlannableProducts",
			Handler:    _ReachPlanService_ListPlannableProducts_Handler,
		},
		{
			MethodName: "GenerateProductMixIdeas",
			Handler:    _ReachPlanService_GenerateProductMixIdeas_Handler,
		},
		{
			MethodName: "GenerateReachForecast",
			Handler:    _ReachPlanService_GenerateReachForecast_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/reach_plan_service.proto",
}
