// Code generated by csi-proxy-api-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"net"

	"github.com/Microsoft/go-winio"
	"github.com/kubernetes-csi/csi-proxy/client"
	"github.com/kubernetes-csi/csi-proxy/client/api/volume/v1beta1"
	"github.com/kubernetes-csi/csi-proxy/client/apiversion"
	"google.golang.org/grpc"
)

// GroupName is the group name of this API.
const GroupName = "volume"

// Version is the api version.
var Version = apiversion.NewVersionOrPanic("v1beta1")

type Client struct {
	client     v1beta1.VolumeClient
	connection *grpc.ClientConn
}

// NewClient returns a client to make calls to the volume API group version v1beta1.
// It's the caller's responsibility to Close the client when done.
func NewClient() (*Client, error) {
	pipePath := client.PipePath(GroupName, Version)
	return NewClientWithPipePath(pipePath)
}

// NewClientWithPipePath returns a client to make calls to the named pipe located at "pipePath".
// It's the caller's responsibility to Close the client when done.
func NewClientWithPipePath(pipePath string) (*Client, error) {

	// verify that the pipe exists
	_, err := winio.DialPipe(pipePath, nil)
	if err != nil {
		return nil, err
	}

	connection, err := grpc.Dial(pipePath,
		grpc.WithContextDialer(func(context context.Context, s string) (net.Conn, error) {
			return winio.DialPipeContext(context, s)
		}),
		grpc.WithInsecure())
	if err != nil {
		return nil, err
	}

	client := v1beta1.NewVolumeClient(connection)
	return &Client{
		client:     client,
		connection: connection,
	}, nil
}

// Close closes the client. It must be called before the client gets GC-ed.
func (w *Client) Close() error {
	return w.connection.Close()
}

// ensures we implement all the required methods
var _ v1beta1.VolumeClient = &Client{}

func (w *Client) DismountVolume(context context.Context, request *v1beta1.DismountVolumeRequest, opts ...grpc.CallOption) (*v1beta1.DismountVolumeResponse, error) {
	return w.client.DismountVolume(context, request, opts...)
}

func (w *Client) FormatVolume(context context.Context, request *v1beta1.FormatVolumeRequest, opts ...grpc.CallOption) (*v1beta1.FormatVolumeResponse, error) {
	return w.client.FormatVolume(context, request, opts...)
}

func (w *Client) GetVolumeDiskNumber(context context.Context, request *v1beta1.VolumeDiskNumberRequest, opts ...grpc.CallOption) (*v1beta1.VolumeDiskNumberResponse, error) {
	return w.client.GetVolumeDiskNumber(context, request, opts...)
}

func (w *Client) GetVolumeIDFromMount(context context.Context, request *v1beta1.VolumeIDFromMountRequest, opts ...grpc.CallOption) (*v1beta1.VolumeIDFromMountResponse, error) {
	return w.client.GetVolumeIDFromMount(context, request, opts...)
}

func (w *Client) IsVolumeFormatted(context context.Context, request *v1beta1.IsVolumeFormattedRequest, opts ...grpc.CallOption) (*v1beta1.IsVolumeFormattedResponse, error) {
	return w.client.IsVolumeFormatted(context, request, opts...)
}

func (w *Client) ListVolumesOnDisk(context context.Context, request *v1beta1.ListVolumesOnDiskRequest, opts ...grpc.CallOption) (*v1beta1.ListVolumesOnDiskResponse, error) {
	return w.client.ListVolumesOnDisk(context, request, opts...)
}

func (w *Client) MountVolume(context context.Context, request *v1beta1.MountVolumeRequest, opts ...grpc.CallOption) (*v1beta1.MountVolumeResponse, error) {
	return w.client.MountVolume(context, request, opts...)
}

func (w *Client) ResizeVolume(context context.Context, request *v1beta1.ResizeVolumeRequest, opts ...grpc.CallOption) (*v1beta1.ResizeVolumeResponse, error) {
	return w.client.ResizeVolume(context, request, opts...)
}

func (w *Client) VolumeStats(context context.Context, request *v1beta1.VolumeStatsRequest, opts ...grpc.CallOption) (*v1beta1.VolumeStatsResponse, error) {
	return w.client.VolumeStats(context, request, opts...)
}
