// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"net/http"

	v1 "github.com/openshift/api/console/v1"
	"github.com/openshift/client-go/console/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ConsoleV1Interface interface {
	RESTClient() rest.Interface
	ConsoleCLIDownloadsGetter
	ConsoleExternalLogLinksGetter
	ConsoleLinksGetter
	ConsoleNotificationsGetter
	ConsoleQuickStartsGetter
	ConsoleYAMLSamplesGetter
}

// ConsoleV1Client is used to interact with features provided by the console.openshift.io group.
type ConsoleV1Client struct {
	restClient rest.Interface
}

func (c *ConsoleV1Client) ConsoleCLIDownloads() ConsoleCLIDownloadInterface {
	return newConsoleCLIDownloads(c)
}

func (c *ConsoleV1Client) ConsoleExternalLogLinks() ConsoleExternalLogLinkInterface {
	return newConsoleExternalLogLinks(c)
}

func (c *ConsoleV1Client) ConsoleLinks() ConsoleLinkInterface {
	return newConsoleLinks(c)
}

func (c *ConsoleV1Client) ConsoleNotifications() ConsoleNotificationInterface {
	return newConsoleNotifications(c)
}

func (c *ConsoleV1Client) ConsoleQuickStarts() ConsoleQuickStartInterface {
	return newConsoleQuickStarts(c)
}

func (c *ConsoleV1Client) ConsoleYAMLSamples() ConsoleYAMLSampleInterface {
	return newConsoleYAMLSamples(c)
}

// NewForConfig creates a new ConsoleV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*ConsoleV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new ConsoleV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*ConsoleV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &ConsoleV1Client{client}, nil
}

// NewForConfigOrDie creates a new ConsoleV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ConsoleV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ConsoleV1Client for the given RESTClient.
func New(c rest.Interface) *ConsoleV1Client {
	return &ConsoleV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ConsoleV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
