// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/api/serviceusage/v1beta1/resources.proto

package serviceusage

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
	serviceconfig "google.golang.org/genproto/googleapis/api/serviceconfig"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	apipb "google.golang.org/protobuf/types/known/apipb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Whether or not a service has been enabled for use by a consumer.
type State int32

const (
	// The default value, which indicates that the enabled state of the service
	// is unspecified or not meaningful. Currently, all consumers other than
	// projects (such as folders and organizations) are always in this state.
	State_STATE_UNSPECIFIED State = 0
	// The service cannot be used by this consumer. It has either been explicitly
	// disabled, or has never been enabled.
	State_DISABLED State = 1
	// The service has been explicitly enabled for use by this consumer.
	State_ENABLED State = 2
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DISABLED":          1,
		"ENABLED":           2,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

// Selected view of quota. Can be used to request more detailed quota
// information when retrieving quota metrics and limits.
type QuotaView int32

const (
	// No quota view specified. Requests that do not specify a quota view will
	// typically default to the BASIC view.
	QuotaView_QUOTA_VIEW_UNSPECIFIED QuotaView = 0
	// Only buckets with overrides are shown in the response.
	QuotaView_BASIC QuotaView = 1
	// Include per-location buckets even if they do not have overrides.
	// When the view is FULL, and a limit has regional or zonal quota, the limit
	// will include buckets for all regions or zones that could support
	// overrides, even if none are currently present. In some cases this will
	// cause the response to become very large; callers that do not need this
	// extra information should use the BASIC view instead.
	QuotaView_FULL QuotaView = 2
)

// Enum value maps for QuotaView.
var (
	QuotaView_name = map[int32]string{
		0: "QUOTA_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	QuotaView_value = map[string]int32{
		"QUOTA_VIEW_UNSPECIFIED": 0,
		"BASIC":                  1,
		"FULL":                   2,
	}
)

func (x QuotaView) Enum() *QuotaView {
	p := new(QuotaView)
	*p = x
	return p
}

func (x QuotaView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[1].Descriptor()
}

func (QuotaView) Type() protoreflect.EnumType {
	return &file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[1]
}

func (x QuotaView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaView.Descriptor instead.
func (QuotaView) EnumDescriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{1}
}

// Enumerations of quota safety checks.
type QuotaSafetyCheck int32

const (
	// Unspecified quota safety check.
	QuotaSafetyCheck_QUOTA_SAFETY_CHECK_UNSPECIFIED QuotaSafetyCheck = 0
	// Validates that a quota mutation would not cause the consumer's effective
	// limit to be lower than the consumer's quota usage.
	QuotaSafetyCheck_LIMIT_DECREASE_BELOW_USAGE QuotaSafetyCheck = 1
	// Validates that a quota mutation would not cause the consumer's effective
	// limit to decrease by more than 10 percent.
	QuotaSafetyCheck_LIMIT_DECREASE_PERCENTAGE_TOO_HIGH QuotaSafetyCheck = 2
)

// Enum value maps for QuotaSafetyCheck.
var (
	QuotaSafetyCheck_name = map[int32]string{
		0: "QUOTA_SAFETY_CHECK_UNSPECIFIED",
		1: "LIMIT_DECREASE_BELOW_USAGE",
		2: "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH",
	}
	QuotaSafetyCheck_value = map[string]int32{
		"QUOTA_SAFETY_CHECK_UNSPECIFIED":     0,
		"LIMIT_DECREASE_BELOW_USAGE":         1,
		"LIMIT_DECREASE_PERCENTAGE_TOO_HIGH": 2,
	}
)

func (x QuotaSafetyCheck) Enum() *QuotaSafetyCheck {
	p := new(QuotaSafetyCheck)
	*p = x
	return p
}

func (x QuotaSafetyCheck) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaSafetyCheck) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[2].Descriptor()
}

func (QuotaSafetyCheck) Type() protoreflect.EnumType {
	return &file_google_api_serviceusage_v1beta1_resources_proto_enumTypes[2]
}

func (x QuotaSafetyCheck) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaSafetyCheck.Descriptor instead.
func (QuotaSafetyCheck) EnumDescriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{2}
}

// A service that is available for use by the consumer.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the consumer and service.
	//
	// A valid name would be:
	// - `projects/123/services/serviceusage.googleapis.com`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the consumer.
	//
	// A valid name would be:
	// - `projects/123`
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// The service configuration of the available service.
	// Some fields may be filtered out of the configuration in responses to
	// the `ListServices` method. These fields are present only in responses to
	// the `GetService` method.
	Config *ServiceConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Whether or not the service has been enabled for use by the consumer.
	State State `protobuf:"varint,4,opt,name=state,proto3,enum=google.api.serviceusage.v1beta1.State" json:"state,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Service) GetConfig() *ServiceConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Service) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

// The configuration of the service.
type ServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DNS address at which this service is available.
	//
	// An example DNS address would be:
	// `calendar.googleapis.com`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The product title for this service.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// A list of API interfaces exported by this service. Contains only the names,
	// versions, and method names of the interfaces.
	Apis []*apipb.Api `protobuf:"bytes,3,rep,name=apis,proto3" json:"apis,omitempty"`
	// Additional API documentation. Contains only the summary and the
	// documentation URL.
	Documentation *serviceconfig.Documentation `protobuf:"bytes,6,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Quota configuration.
	Quota *serviceconfig.Quota `protobuf:"bytes,10,opt,name=quota,proto3" json:"quota,omitempty"`
	// Auth configuration. Contains only the OAuth rules.
	Authentication *serviceconfig.Authentication `protobuf:"bytes,11,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Configuration controlling usage of this service.
	Usage *serviceconfig.Usage `protobuf:"bytes,15,opt,name=usage,proto3" json:"usage,omitempty"`
	// Configuration for network endpoints. Contains only the names and aliases
	// of the endpoints.
	Endpoints []*serviceconfig.Endpoint `protobuf:"bytes,18,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Defines the monitored resources used by this service. This is required
	// by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
	MonitoredResources []*monitoredres.MonitoredResourceDescriptor `protobuf:"bytes,25,rep,name=monitored_resources,json=monitoredResources,proto3" json:"monitored_resources,omitempty"`
	// Monitoring configuration.
	// This should not include the 'producer_destinations' field.
	Monitoring *serviceconfig.Monitoring `protobuf:"bytes,28,opt,name=monitoring,proto3" json:"monitoring,omitempty"`
}

func (x *ServiceConfig) Reset() {
	*x = ServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig) ProtoMessage() {}

func (x *ServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig.ProtoReflect.Descriptor instead.
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ServiceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceConfig) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ServiceConfig) GetApis() []*apipb.Api {
	if x != nil {
		return x.Apis
	}
	return nil
}

func (x *ServiceConfig) GetDocumentation() *serviceconfig.Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *ServiceConfig) GetQuota() *serviceconfig.Quota {
	if x != nil {
		return x.Quota
	}
	return nil
}

func (x *ServiceConfig) GetAuthentication() *serviceconfig.Authentication {
	if x != nil {
		return x.Authentication
	}
	return nil
}

func (x *ServiceConfig) GetUsage() *serviceconfig.Usage {
	if x != nil {
		return x.Usage
	}
	return nil
}

func (x *ServiceConfig) GetEndpoints() []*serviceconfig.Endpoint {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *ServiceConfig) GetMonitoredResources() []*monitoredres.MonitoredResourceDescriptor {
	if x != nil {
		return x.MonitoredResources
	}
	return nil
}

func (x *ServiceConfig) GetMonitoring() *serviceconfig.Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

// The operation metadata returned for the batchend services operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the resources that this operation is directly
	// associated with.
	ResourceNames []string `protobuf:"bytes,2,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *OperationMetadata) GetResourceNames() []string {
	if x != nil {
		return x.ResourceNames
	}
	return nil
}

// Consumer quota settings for a quota metric.
type ConsumerQuotaMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the quota settings on this metric for this consumer.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
	//
	// The resource name is intended to be opaque and should not be parsed for
	// its component strings, since its representation could change in the future.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the metric.
	//
	// An example name would be:
	// `compute.googleapis.com/cpus`
	Metric string `protobuf:"bytes,4,opt,name=metric,proto3" json:"metric,omitempty"`
	// The display name of the metric.
	//
	// An example name would be:
	// `CPUs`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The consumer quota for each quota limit defined on the metric.
	ConsumerQuotaLimits []*ConsumerQuotaLimit `protobuf:"bytes,3,rep,name=consumer_quota_limits,json=consumerQuotaLimits,proto3" json:"consumer_quota_limits,omitempty"`
	// The quota limits targeting the descendant containers of the
	// consumer in request.
	//
	// If the consumer in request is of type `organizations`
	// or `folders`, the field will list per-project limits in the metric; if the
	// consumer in request is of type `project`, the field will be empty.
	//
	// The `quota_buckets` field of each descendant consumer quota limit will not
	// be populated.
	DescendantConsumerQuotaLimits []*ConsumerQuotaLimit `protobuf:"bytes,6,rep,name=descendant_consumer_quota_limits,json=descendantConsumerQuotaLimits,proto3" json:"descendant_consumer_quota_limits,omitempty"`
	// The units in which the metric value is reported.
	Unit string `protobuf:"bytes,5,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ConsumerQuotaMetric) Reset() {
	*x = ConsumerQuotaMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumerQuotaMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumerQuotaMetric) ProtoMessage() {}

func (x *ConsumerQuotaMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumerQuotaMetric.ProtoReflect.Descriptor instead.
func (*ConsumerQuotaMetric) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ConsumerQuotaMetric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConsumerQuotaMetric) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *ConsumerQuotaMetric) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConsumerQuotaMetric) GetConsumerQuotaLimits() []*ConsumerQuotaLimit {
	if x != nil {
		return x.ConsumerQuotaLimits
	}
	return nil
}

func (x *ConsumerQuotaMetric) GetDescendantConsumerQuotaLimits() []*ConsumerQuotaLimit {
	if x != nil {
		return x.DescendantConsumerQuotaLimits
	}
	return nil
}

func (x *ConsumerQuotaMetric) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// Consumer quota settings for a quota limit.
type ConsumerQuotaLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the quota limit.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
	//
	// The resource name is intended to be opaque and should not be parsed for
	// its component strings, since its representation could change in the future.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the parent metric of this limit.
	//
	// An example name would be:
	// `compute.googleapis.com/cpus`
	Metric string `protobuf:"bytes,8,opt,name=metric,proto3" json:"metric,omitempty"`
	// The limit unit.
	//
	// An example unit would be
	// `1/{project}/{region}`
	// Note that `{project}` and `{region}` are not placeholders in this example;
	// the literal characters `{` and `}` occur in the string.
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
	// Whether this limit is precise or imprecise.
	IsPrecise bool `protobuf:"varint,3,opt,name=is_precise,json=isPrecise,proto3" json:"is_precise,omitempty"`
	// Whether admin overrides are allowed on this limit
	AllowsAdminOverrides bool `protobuf:"varint,7,opt,name=allows_admin_overrides,json=allowsAdminOverrides,proto3" json:"allows_admin_overrides,omitempty"`
	// Summary of the enforced quota buckets, organized by quota dimension,
	// ordered from least specific to most specific (for example, the global
	// default bucket, with no quota dimensions, will always appear first).
	QuotaBuckets []*QuotaBucket `protobuf:"bytes,9,rep,name=quota_buckets,json=quotaBuckets,proto3" json:"quota_buckets,omitempty"`
}

func (x *ConsumerQuotaLimit) Reset() {
	*x = ConsumerQuotaLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumerQuotaLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumerQuotaLimit) ProtoMessage() {}

func (x *ConsumerQuotaLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumerQuotaLimit.ProtoReflect.Descriptor instead.
func (*ConsumerQuotaLimit) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *ConsumerQuotaLimit) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConsumerQuotaLimit) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *ConsumerQuotaLimit) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *ConsumerQuotaLimit) GetIsPrecise() bool {
	if x != nil {
		return x.IsPrecise
	}
	return false
}

func (x *ConsumerQuotaLimit) GetAllowsAdminOverrides() bool {
	if x != nil {
		return x.AllowsAdminOverrides
	}
	return false
}

func (x *ConsumerQuotaLimit) GetQuotaBuckets() []*QuotaBucket {
	if x != nil {
		return x.QuotaBuckets
	}
	return nil
}

// A quota bucket is a quota provisioning unit for a specific set of dimensions.
type QuotaBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The effective limit of this quota bucket. Equal to default_limit if there
	// are no overrides.
	EffectiveLimit int64 `protobuf:"varint,1,opt,name=effective_limit,json=effectiveLimit,proto3" json:"effective_limit,omitempty"`
	// The default limit of this quota bucket, as specified by the service
	// configuration.
	DefaultLimit int64 `protobuf:"varint,2,opt,name=default_limit,json=defaultLimit,proto3" json:"default_limit,omitempty"`
	// Producer override on this quota bucket.
	ProducerOverride *QuotaOverride `protobuf:"bytes,3,opt,name=producer_override,json=producerOverride,proto3" json:"producer_override,omitempty"`
	// Consumer override on this quota bucket.
	ConsumerOverride *QuotaOverride `protobuf:"bytes,4,opt,name=consumer_override,json=consumerOverride,proto3" json:"consumer_override,omitempty"`
	// Admin override on this quota bucket.
	AdminOverride *QuotaOverride `protobuf:"bytes,5,opt,name=admin_override,json=adminOverride,proto3" json:"admin_override,omitempty"`
	// The dimensions of this quota bucket.
	//
	// If this map is empty, this is the global bucket, which is the default quota
	// value applied to all requests that do not have a more specific override.
	//
	// If this map is nonempty, the default limit, effective limit, and quota
	// overrides apply only to requests that have the dimensions given in the map.
	//
	// For example, if the map has key `region` and value `us-east-1`, then the
	// specified effective limit is only effective in that region, and the
	// specified overrides apply only in that region.
	Dimensions map[string]string `protobuf:"bytes,6,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *QuotaBucket) Reset() {
	*x = QuotaBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaBucket) ProtoMessage() {}

func (x *QuotaBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaBucket.ProtoReflect.Descriptor instead.
func (*QuotaBucket) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *QuotaBucket) GetEffectiveLimit() int64 {
	if x != nil {
		return x.EffectiveLimit
	}
	return 0
}

func (x *QuotaBucket) GetDefaultLimit() int64 {
	if x != nil {
		return x.DefaultLimit
	}
	return 0
}

func (x *QuotaBucket) GetProducerOverride() *QuotaOverride {
	if x != nil {
		return x.ProducerOverride
	}
	return nil
}

func (x *QuotaBucket) GetConsumerOverride() *QuotaOverride {
	if x != nil {
		return x.ConsumerOverride
	}
	return nil
}

func (x *QuotaBucket) GetAdminOverride() *QuotaOverride {
	if x != nil {
		return x.AdminOverride
	}
	return nil
}

func (x *QuotaBucket) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

// A quota override
type QuotaOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the override.
	// This name is generated by the server when the override is created.
	//
	// Example names would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
	//
	// The resource name is intended to be opaque and should not be parsed for
	// its component strings, since its representation could change in the future.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The overriding quota limit value.
	// Can be any nonnegative integer, or -1 (unlimited quota).
	OverrideValue int64 `protobuf:"varint,2,opt,name=override_value,json=overrideValue,proto3" json:"override_value,omitempty"`
	// If this map is nonempty, then this override applies only to specific values
	// for dimensions defined in the limit unit.
	//
	// For example, an override on a limit with the unit `1/{project}/{region}`
	// could contain an entry with the key `region` and the value `us-east-1`;
	// the override is only applied to quota consumed in that region.
	//
	// This map has the following restrictions:
	//
	// *   Keys that are not defined in the limit's unit are not valid keys.
	//     Any string appearing in `{brackets}` in the unit (besides `{project}`
	//     or
	//     `{user}`) is a defined key.
	// *   `project` is not a valid key; the project is already specified in
	//     the parent resource name.
	// *   `user` is not a valid key; the API does not support quota overrides
	//     that apply only to a specific user.
	// *   If `region` appears as a key, its value must be a valid Cloud region.
	// *   If `zone` appears as a key, its value must be a valid Cloud zone.
	// *   If any valid key other than `region` or `zone` appears in the map, then
	//     all valid keys other than `region` or `zone` must also appear in the
	//     map.
	Dimensions map[string]string `protobuf:"bytes,3,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the metric to which this override applies.
	//
	// An example name would be:
	// `compute.googleapis.com/cpus`
	Metric string `protobuf:"bytes,4,opt,name=metric,proto3" json:"metric,omitempty"`
	// The limit unit of the limit to which this override applies.
	//
	// An example unit would be:
	// `1/{project}/{region}`
	// Note that `{project}` and `{region}` are not placeholders in this example;
	// the literal characters `{` and `}` occur in the string.
	Unit string `protobuf:"bytes,5,opt,name=unit,proto3" json:"unit,omitempty"`
	// The resource name of the ancestor that requested the override. For example:
	// `organizations/12345` or `folders/67890`.
	// Used by admin overrides only.
	AdminOverrideAncestor string `protobuf:"bytes,6,opt,name=admin_override_ancestor,json=adminOverrideAncestor,proto3" json:"admin_override_ancestor,omitempty"`
}

func (x *QuotaOverride) Reset() {
	*x = QuotaOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaOverride) ProtoMessage() {}

func (x *QuotaOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaOverride.ProtoReflect.Descriptor instead.
func (*QuotaOverride) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *QuotaOverride) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotaOverride) GetOverrideValue() int64 {
	if x != nil {
		return x.OverrideValue
	}
	return 0
}

func (x *QuotaOverride) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *QuotaOverride) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *QuotaOverride) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *QuotaOverride) GetAdminOverrideAncestor() string {
	if x != nil {
		return x.AdminOverrideAncestor
	}
	return ""
}

// Import data embedded in the request message
type OverrideInlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overrides to create.
	// Each override must have a value for 'metric' and 'unit', to specify
	// which metric and which limit the override should be applied to.
	// The 'name' field of the override does not need to be set; it is ignored.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *OverrideInlineSource) Reset() {
	*x = OverrideInlineSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OverrideInlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OverrideInlineSource) ProtoMessage() {}

func (x *OverrideInlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OverrideInlineSource.ProtoReflect.Descriptor instead.
func (*OverrideInlineSource) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *OverrideInlineSource) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Quota policy created by quota administrator.
type AdminQuotaPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the policy.
	// This name is generated by the server when the policy is created.
	//
	// Example names would be:
	// `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The quota policy value.
	// Can be any nonnegative integer, or -1 (unlimited quota).
	PolicyValue int64 `protobuf:"varint,2,opt,name=policy_value,json=policyValue,proto3" json:"policy_value,omitempty"`
	//
	// If this map is nonempty, then this policy applies only to specific values
	// for dimensions defined in the limit unit.
	//
	// For example, an policy on a limit with the unit `1/{project}/{region}`
	// could contain an entry with the key `region` and the value `us-east-1`;
	// the policy is only applied to quota consumed in that region.
	//
	// This map has the following restrictions:
	//
	// *   If `region` appears as a key, its value must be a valid Cloud region.
	// *   If `zone` appears as a key, its value must be a valid Cloud zone.
	// *   Keys other than `region` or `zone` are not valid.
	Dimensions map[string]string `protobuf:"bytes,3,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the metric to which this policy applies.
	//
	// An example name would be:
	// `compute.googleapis.com/cpus`
	Metric string `protobuf:"bytes,4,opt,name=metric,proto3" json:"metric,omitempty"`
	// The limit unit of the limit to which this policy applies.
	//
	// An example unit would be:
	// `1/{project}/{region}`
	// Note that `{project}` and `{region}` are not placeholders in this example;
	// the literal characters `{` and `}` occur in the string.
	Unit string `protobuf:"bytes,5,opt,name=unit,proto3" json:"unit,omitempty"`
	// The cloud resource container at which the quota policy is created. The
	// format is `{container_type}/{container_number}`
	Container string `protobuf:"bytes,6,opt,name=container,proto3" json:"container,omitempty"`
}

func (x *AdminQuotaPolicy) Reset() {
	*x = AdminQuotaPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdminQuotaPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdminQuotaPolicy) ProtoMessage() {}

func (x *AdminQuotaPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdminQuotaPolicy.ProtoReflect.Descriptor instead.
func (*AdminQuotaPolicy) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *AdminQuotaPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdminQuotaPolicy) GetPolicyValue() int64 {
	if x != nil {
		return x.PolicyValue
	}
	return 0
}

func (x *AdminQuotaPolicy) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *AdminQuotaPolicy) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *AdminQuotaPolicy) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *AdminQuotaPolicy) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

// Service identity for a service. This is the identity that service producer
// should use to access consumer resources.
type ServiceIdentity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address of the service account that a service producer would use
	// to access consumer resources.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// The unique and stable id of the service account.
	// https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts#ServiceAccount
	UniqueId string `protobuf:"bytes,2,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
}

func (x *ServiceIdentity) Reset() {
	*x = ServiceIdentity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceIdentity) ProtoMessage() {}

func (x *ServiceIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceIdentity.ProtoReflect.Descriptor instead.
func (*ServiceIdentity) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *ServiceIdentity) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceIdentity) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

var File_google_api_serviceusage_v1beta1_resources_proto protoreflect.FileDescriptor

var file_google_api_serviceusage_v1beta1_resources_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xbb, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x80, 0x04,
	0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x61, 0x70, 0x69,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x70, 0x69, 0x52, 0x04, 0x61,
	0x70, 0x69, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x42, 0x0a,
	0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x09, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x58,
	0x0a, 0x13, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x52, 0x12, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x22, 0x3a, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xdf, 0x02, 0x0a,
	0x13, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x20,
	0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x1d, 0x64, 0x65, 0x73,
	0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e,
	0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0xfc,
	0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x50, 0x72, 0x65,
	0x63, 0x69, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x5f, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0d, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x22, 0x89, 0x04,
	0x0a, 0x0b, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x0a,
	0x0f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x5b, 0x0a, 0x11, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0d, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x5c, 0x0a, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcd, 0x02, 0x0a, 0x0d, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5e, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12,
	0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e,
	0x69, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x5f, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x1a, 0x3d, 0x0a, 0x0f, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x64, 0x0a, 0x14, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x22,
	0xb5, 0x02, 0x0a, 0x10, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x61, 0x0a, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x1a, 0x3d, 0x0a, 0x0f, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x44, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x12, 0x1b, 0x0a, 0x09, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x2a, 0x39, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x3c, 0x0a, 0x09, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1a, 0x0a, 0x16, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x7e, 0x0a, 0x10, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x22, 0x0a, 0x1e, 0x51, 0x55,
	0x4f, 0x54, 0x41, 0x5f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x45, 0x41, 0x53, 0x45,
	0x5f, 0x42, 0x45, 0x4c, 0x4f, 0x57, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x26,
	0x0a, 0x22, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x45, 0x41, 0x53, 0x45,
	0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f,
	0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x42, 0xed, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x69, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x69, 0x5c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x3a,
	0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_serviceusage_v1beta1_resources_proto_rawDescOnce sync.Once
	file_google_api_serviceusage_v1beta1_resources_proto_rawDescData = file_google_api_serviceusage_v1beta1_resources_proto_rawDesc
)

func file_google_api_serviceusage_v1beta1_resources_proto_rawDescGZIP() []byte {
	file_google_api_serviceusage_v1beta1_resources_proto_rawDescOnce.Do(func() {
		file_google_api_serviceusage_v1beta1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_serviceusage_v1beta1_resources_proto_rawDescData)
	})
	return file_google_api_serviceusage_v1beta1_resources_proto_rawDescData
}

var file_google_api_serviceusage_v1beta1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_api_serviceusage_v1beta1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_api_serviceusage_v1beta1_resources_proto_goTypes = []interface{}{
	(State)(0),                           // 0: google.api.serviceusage.v1beta1.State
	(QuotaView)(0),                       // 1: google.api.serviceusage.v1beta1.QuotaView
	(QuotaSafetyCheck)(0),                // 2: google.api.serviceusage.v1beta1.QuotaSafetyCheck
	(*Service)(nil),                      // 3: google.api.serviceusage.v1beta1.Service
	(*ServiceConfig)(nil),                // 4: google.api.serviceusage.v1beta1.ServiceConfig
	(*OperationMetadata)(nil),            // 5: google.api.serviceusage.v1beta1.OperationMetadata
	(*ConsumerQuotaMetric)(nil),          // 6: google.api.serviceusage.v1beta1.ConsumerQuotaMetric
	(*ConsumerQuotaLimit)(nil),           // 7: google.api.serviceusage.v1beta1.ConsumerQuotaLimit
	(*QuotaBucket)(nil),                  // 8: google.api.serviceusage.v1beta1.QuotaBucket
	(*QuotaOverride)(nil),                // 9: google.api.serviceusage.v1beta1.QuotaOverride
	(*OverrideInlineSource)(nil),         // 10: google.api.serviceusage.v1beta1.OverrideInlineSource
	(*AdminQuotaPolicy)(nil),             // 11: google.api.serviceusage.v1beta1.AdminQuotaPolicy
	(*ServiceIdentity)(nil),              // 12: google.api.serviceusage.v1beta1.ServiceIdentity
	nil,                                  // 13: google.api.serviceusage.v1beta1.QuotaBucket.DimensionsEntry
	nil,                                  // 14: google.api.serviceusage.v1beta1.QuotaOverride.DimensionsEntry
	nil,                                  // 15: google.api.serviceusage.v1beta1.AdminQuotaPolicy.DimensionsEntry
	(*apipb.Api)(nil),                    // 16: google.protobuf.Api
	(*serviceconfig.Documentation)(nil),  // 17: google.api.Documentation
	(*serviceconfig.Quota)(nil),          // 18: google.api.Quota
	(*serviceconfig.Authentication)(nil), // 19: google.api.Authentication
	(*serviceconfig.Usage)(nil),          // 20: google.api.Usage
	(*serviceconfig.Endpoint)(nil),       // 21: google.api.Endpoint
	(*monitoredres.MonitoredResourceDescriptor)(nil), // 22: google.api.MonitoredResourceDescriptor
	(*serviceconfig.Monitoring)(nil),                 // 23: google.api.Monitoring
}
var file_google_api_serviceusage_v1beta1_resources_proto_depIdxs = []int32{
	4,  // 0: google.api.serviceusage.v1beta1.Service.config:type_name -> google.api.serviceusage.v1beta1.ServiceConfig
	0,  // 1: google.api.serviceusage.v1beta1.Service.state:type_name -> google.api.serviceusage.v1beta1.State
	16, // 2: google.api.serviceusage.v1beta1.ServiceConfig.apis:type_name -> google.protobuf.Api
	17, // 3: google.api.serviceusage.v1beta1.ServiceConfig.documentation:type_name -> google.api.Documentation
	18, // 4: google.api.serviceusage.v1beta1.ServiceConfig.quota:type_name -> google.api.Quota
	19, // 5: google.api.serviceusage.v1beta1.ServiceConfig.authentication:type_name -> google.api.Authentication
	20, // 6: google.api.serviceusage.v1beta1.ServiceConfig.usage:type_name -> google.api.Usage
	21, // 7: google.api.serviceusage.v1beta1.ServiceConfig.endpoints:type_name -> google.api.Endpoint
	22, // 8: google.api.serviceusage.v1beta1.ServiceConfig.monitored_resources:type_name -> google.api.MonitoredResourceDescriptor
	23, // 9: google.api.serviceusage.v1beta1.ServiceConfig.monitoring:type_name -> google.api.Monitoring
	7,  // 10: google.api.serviceusage.v1beta1.ConsumerQuotaMetric.consumer_quota_limits:type_name -> google.api.serviceusage.v1beta1.ConsumerQuotaLimit
	7,  // 11: google.api.serviceusage.v1beta1.ConsumerQuotaMetric.descendant_consumer_quota_limits:type_name -> google.api.serviceusage.v1beta1.ConsumerQuotaLimit
	8,  // 12: google.api.serviceusage.v1beta1.ConsumerQuotaLimit.quota_buckets:type_name -> google.api.serviceusage.v1beta1.QuotaBucket
	9,  // 13: google.api.serviceusage.v1beta1.QuotaBucket.producer_override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	9,  // 14: google.api.serviceusage.v1beta1.QuotaBucket.consumer_override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	9,  // 15: google.api.serviceusage.v1beta1.QuotaBucket.admin_override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	13, // 16: google.api.serviceusage.v1beta1.QuotaBucket.dimensions:type_name -> google.api.serviceusage.v1beta1.QuotaBucket.DimensionsEntry
	14, // 17: google.api.serviceusage.v1beta1.QuotaOverride.dimensions:type_name -> google.api.serviceusage.v1beta1.QuotaOverride.DimensionsEntry
	9,  // 18: google.api.serviceusage.v1beta1.OverrideInlineSource.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	15, // 19: google.api.serviceusage.v1beta1.AdminQuotaPolicy.dimensions:type_name -> google.api.serviceusage.v1beta1.AdminQuotaPolicy.DimensionsEntry
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_api_serviceusage_v1beta1_resources_proto_init() }
func file_google_api_serviceusage_v1beta1_resources_proto_init() {
	if File_google_api_serviceusage_v1beta1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConsumerQuotaMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConsumerQuotaLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OverrideInlineSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdminQuotaPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceIdentity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_serviceusage_v1beta1_resources_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_api_serviceusage_v1beta1_resources_proto_goTypes,
		DependencyIndexes: file_google_api_serviceusage_v1beta1_resources_proto_depIdxs,
		EnumInfos:         file_google_api_serviceusage_v1beta1_resources_proto_enumTypes,
		MessageInfos:      file_google_api_serviceusage_v1beta1_resources_proto_msgTypes,
	}.Build()
	File_google_api_serviceusage_v1beta1_resources_proto = out.File
	file_google_api_serviceusage_v1beta1_resources_proto_rawDesc = nil
	file_google_api_serviceusage_v1beta1_resources_proto_goTypes = nil
	file_google_api_serviceusage_v1beta1_resources_proto_depIdxs = nil
}
