// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecastservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDataset
func (c *ForecastService) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Forecast Service.
//
// Creates an Amazon Forecast dataset. The information about the dataset that
// you provide helps Forecast understand how to consume the data for model training.
// This includes the following:
//
//    * DataFrequency - How frequently your historical time-series data is collected.
//
//    * Domain and DatasetType - Each dataset has an associated dataset domain
//    and a type within the domain. Amazon Forecast provides a list of predefined
//    domains and types within each domain. For each unique dataset domain and
//    type within the domain, Amazon Forecast requires your data to include
//    a minimum set of predefined fields.
//
//    * Schema - A schema specifies the fields in the dataset, including the
//    field name and data type.
//
// After creating a dataset, you import your training data into it and add the
// dataset to a dataset group. You use the dataset group to create a predictor.
// For more information, see howitworks-datasets-groups.
//
// To get a list of all your datasets, use the ListDatasets operation.
//
// For example Forecast datasets, see the Amazon Forecast Sample GitHub repository
// (https://github.com/aws-samples/amazon-forecast-samples/tree/master/data).
//
// The Status of a dataset must be ACTIVE before you can import training data.
// Use the DescribeDataset operation to get the status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDataset
func (c *ForecastService) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetGroup = "CreateDatasetGroup"

// CreateDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetGroup for more information on using the CreateDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetGroupRequest method.
//    req, resp := client.CreateDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetGroup
func (c *ForecastService) CreateDatasetGroupRequest(input *CreateDatasetGroupInput) (req *request.Request, output *CreateDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetGroupInput{}
	}

	output = &CreateDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetGroup API operation for Amazon Forecast Service.
//
// Creates a dataset group, which holds a collection of related datasets. You
// can add datasets to the dataset group when you create the dataset group,
// or later by using the UpdateDatasetGroup operation.
//
// After creating a dataset group and adding datasets, you use the dataset group
// when you create a predictor. For more information, see howitworks-datasets-groups.
//
// To get a list of all your datasets groups, use the ListDatasetGroups operation.
//
// The Status of a dataset group must be ACTIVE before you can create use the
// dataset group to create a predictor. To get the status, use the DescribeDatasetGroup
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreateDatasetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetGroup
func (c *ForecastService) CreateDatasetGroup(input *CreateDatasetGroupInput) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	return out, req.Send()
}

// CreateDatasetGroupWithContext is the same as CreateDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreateDatasetGroupWithContext(ctx aws.Context, input *CreateDatasetGroupInput, opts ...request.Option) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetImportJob = "CreateDatasetImportJob"

// CreateDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetImportJob for more information on using the CreateDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetImportJobRequest method.
//    req, resp := client.CreateDatasetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetImportJob
func (c *ForecastService) CreateDatasetImportJobRequest(input *CreateDatasetImportJobInput) (req *request.Request, output *CreateDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetImportJobInput{}
	}

	output = &CreateDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetImportJob API operation for Amazon Forecast Service.
//
// Imports your training data to an Amazon Forecast dataset. You provide the
// location of your training data in an Amazon Simple Storage Service (Amazon
// S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want
// to import the data to.
//
// You must specify a DataSource object that includes an AWS Identity and Access
// Management (IAM) role that Amazon Forecast can assume to access the data.
// For more information, see aws-forecast-iam-roles.
//
// The training data must be in CSV format. The delimiter must be a comma (,).
//
// You can specify the path to a specific CSV file, the S3 bucket, or to a folder
// in the S3 bucket. For the latter two cases, Amazon Forecast imports all files
// up to the limit of 10,000 files.
//
// To get a list of all your dataset import jobs, filtered by specified criteria,
// use the ListDatasetImportJobs operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreateDatasetImportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetImportJob
func (c *ForecastService) CreateDatasetImportJob(input *CreateDatasetImportJobInput) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	return out, req.Send()
}

// CreateDatasetImportJobWithContext is the same as CreateDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreateDatasetImportJobWithContext(ctx aws.Context, input *CreateDatasetImportJobInput, opts ...request.Option) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateForecast = "CreateForecast"

// CreateForecastRequest generates a "aws/request.Request" representing the
// client's request for the CreateForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateForecast for more information on using the CreateForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateForecastRequest method.
//    req, resp := client.CreateForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecast
func (c *ForecastService) CreateForecastRequest(input *CreateForecastInput) (req *request.Request, output *CreateForecastOutput) {
	op := &request.Operation{
		Name:       opCreateForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateForecastInput{}
	}

	output = &CreateForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateForecast API operation for Amazon Forecast Service.
//
// Creates a forecast for each item in the TARGET_TIME_SERIES dataset that was
// used to train the predictor. This is known as inference. To retrieve the
// forecast for a single item at low latency, use the operation. To export the
// complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket,
// use the CreateForecastExportJob operation.
//
// The range of the forecast is determined by the ForecastHorizon value, which
// you specify in the CreatePredictor request, multiplied by the DataFrequency
// value, which you specify in the CreateDataset request. When you query a forecast,
// you can request a specific date range within the forecast.
//
// To get a list of all your forecasts, use the ListForecasts operation.
//
// The forecasts generated by Amazon Forecast are in the same time zone as the
// dataset that was used to create the predictor.
//
// For more information, see howitworks-forecast.
//
// The Status of the forecast must be ACTIVE before you can query or export
// the forecast. Use the DescribeForecast operation to get the status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreateForecast for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecast
func (c *ForecastService) CreateForecast(input *CreateForecastInput) (*CreateForecastOutput, error) {
	req, out := c.CreateForecastRequest(input)
	return out, req.Send()
}

// CreateForecastWithContext is the same as CreateForecast with the addition of
// the ability to pass a context and additional request options.
//
// See CreateForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreateForecastWithContext(ctx aws.Context, input *CreateForecastInput, opts ...request.Option) (*CreateForecastOutput, error) {
	req, out := c.CreateForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateForecastExportJob = "CreateForecastExportJob"

// CreateForecastExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateForecastExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateForecastExportJob for more information on using the CreateForecastExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateForecastExportJobRequest method.
//    req, resp := client.CreateForecastExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecastExportJob
func (c *ForecastService) CreateForecastExportJobRequest(input *CreateForecastExportJobInput) (req *request.Request, output *CreateForecastExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateForecastExportJobInput{}
	}

	output = &CreateForecastExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateForecastExportJob API operation for Amazon Forecast Service.
//
// Exports a forecast created by the CreateForecast operation to your Amazon
// Simple Storage Service (Amazon S3) bucket. The forecast file name will match
// the following conventions:
//
// <ForecastExportJobName>_<ExportTimestamp>_<PageNumber>
//
// where the <ExportTimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
//
// You must specify a DataDestination object that includes an AWS Identity and
// Access Management (IAM) role that Amazon Forecast can assume to access the
// Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
//
// For more information, see howitworks-forecast.
//
// To get a list of all your forecast export jobs, use the ListForecastExportJobs
// operation.
//
// The Status of the forecast export job must be ACTIVE before you can access
// the forecast in your Amazon S3 bucket. To get the status, use the DescribeForecastExportJob
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreateForecastExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecastExportJob
func (c *ForecastService) CreateForecastExportJob(input *CreateForecastExportJobInput) (*CreateForecastExportJobOutput, error) {
	req, out := c.CreateForecastExportJobRequest(input)
	return out, req.Send()
}

// CreateForecastExportJobWithContext is the same as CreateForecastExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateForecastExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreateForecastExportJobWithContext(ctx aws.Context, input *CreateForecastExportJobInput, opts ...request.Option) (*CreateForecastExportJobOutput, error) {
	req, out := c.CreateForecastExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePredictor = "CreatePredictor"

// CreatePredictorRequest generates a "aws/request.Request" representing the
// client's request for the CreatePredictor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePredictor for more information on using the CreatePredictor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePredictorRequest method.
//    req, resp := client.CreatePredictorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictor
func (c *ForecastService) CreatePredictorRequest(input *CreatePredictorInput) (req *request.Request, output *CreatePredictorOutput) {
	op := &request.Operation{
		Name:       opCreatePredictor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePredictorInput{}
	}

	output = &CreatePredictorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePredictor API operation for Amazon Forecast Service.
//
// Creates an Amazon Forecast predictor.
//
// In the request, you provide a dataset group and either specify an algorithm
// or let Amazon Forecast choose the algorithm for you using AutoML. If you
// specify an algorithm, you also can override algorithm-specific hyperparameters.
//
// Amazon Forecast uses the chosen algorithm to train a model using the latest
// version of the datasets in the specified dataset group. The result is called
// a predictor. You then generate a forecast using the CreateForecast operation.
//
// After training a model, the CreatePredictor operation also evaluates it.
// To see the evaluation metrics, use the GetAccuracyMetrics operation. Always
// review the evaluation metrics before deciding to use the predictor to generate
// a forecast.
//
// Optionally, you can specify a featurization configuration to fill and aggregate
// the data fields in the TARGET_TIME_SERIES dataset to improve model training.
// For more information, see FeaturizationConfig.
//
// For RELATED_TIME_SERIES datasets, CreatePredictor verifies that the DataFrequency
// specified when the dataset was created matches the ForecastFrequency. TARGET_TIME_SERIES
// datasets don't have this restriction. Amazon Forecast also verifies the delimiter
// and timestamp format. For more information, see howitworks-datasets-groups.
//
// AutoML
//
// If you want Amazon Forecast to evaluate each algorithm and choose the one
// that minimizes the objective function, set PerformAutoML to true. The objective
// function is defined as the mean of the weighted p10, p50, and p90 quantile
// losses. For more information, see EvaluationResult.
//
// When AutoML is enabled, the following properties are disallowed:
//
//    * AlgorithmArn
//
//    * HPOConfig
//
//    * PerformHPO
//
//    * TrainingParameters
//
// To get a list of all of your predictors, use the ListPredictors operation.
//
// Before you can use the predictor to create a forecast, the Status of the
// predictor must be ACTIVE, signifying that training has completed. To get
// the status, use the DescribePredictor operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation CreatePredictor for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceAlreadyExistsException
//   There is already a resource with this name. Try again with a different name.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The limit on the number of resources per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictor
func (c *ForecastService) CreatePredictor(input *CreatePredictorInput) (*CreatePredictorOutput, error) {
	req, out := c.CreatePredictorRequest(input)
	return out, req.Send()
}

// CreatePredictorWithContext is the same as CreatePredictor with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePredictor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) CreatePredictorWithContext(ctx aws.Context, input *CreatePredictorInput, opts ...request.Option) (*CreatePredictorOutput, error) {
	req, out := c.CreatePredictorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDataset
func (c *ForecastService) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Forecast Service.
//
// Deletes an Amazon Forecast dataset that was created using the CreateDataset
// operation. You can only delete datasets that have a status of ACTIVE or CREATE_FAILED.
// To get the status use the DescribeDataset operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDataset
func (c *ForecastService) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatasetGroup = "DeleteDatasetGroup"

// DeleteDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatasetGroup for more information on using the DeleteDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetGroupRequest method.
//    req, resp := client.DeleteDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetGroup
func (c *ForecastService) DeleteDatasetGroupRequest(input *DeleteDatasetGroupInput) (req *request.Request, output *DeleteDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetGroupInput{}
	}

	output = &DeleteDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatasetGroup API operation for Amazon Forecast Service.
//
// Deletes a dataset group created using the CreateDatasetGroup operation. You
// can only delete dataset groups that have a status of ACTIVE, CREATE_FAILED,
// or UPDATE_FAILED. To get the status, use the DescribeDatasetGroup operation.
//
// This operation deletes only the dataset group, not the datasets in the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeleteDatasetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetGroup
func (c *ForecastService) DeleteDatasetGroup(input *DeleteDatasetGroupInput) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	return out, req.Send()
}

// DeleteDatasetGroupWithContext is the same as DeleteDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeleteDatasetGroupWithContext(ctx aws.Context, input *DeleteDatasetGroupInput, opts ...request.Option) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatasetImportJob = "DeleteDatasetImportJob"

// DeleteDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatasetImportJob for more information on using the DeleteDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetImportJobRequest method.
//    req, resp := client.DeleteDatasetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetImportJob
func (c *ForecastService) DeleteDatasetImportJobRequest(input *DeleteDatasetImportJobInput) (req *request.Request, output *DeleteDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opDeleteDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetImportJobInput{}
	}

	output = &DeleteDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatasetImportJob API operation for Amazon Forecast Service.
//
// Deletes a dataset import job created using the CreateDatasetImportJob operation.
// You can delete only dataset import jobs that have a status of ACTIVE or CREATE_FAILED.
// To get the status, use the DescribeDatasetImportJob operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeleteDatasetImportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetImportJob
func (c *ForecastService) DeleteDatasetImportJob(input *DeleteDatasetImportJobInput) (*DeleteDatasetImportJobOutput, error) {
	req, out := c.DeleteDatasetImportJobRequest(input)
	return out, req.Send()
}

// DeleteDatasetImportJobWithContext is the same as DeleteDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeleteDatasetImportJobWithContext(ctx aws.Context, input *DeleteDatasetImportJobInput, opts ...request.Option) (*DeleteDatasetImportJobOutput, error) {
	req, out := c.DeleteDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteForecast = "DeleteForecast"

// DeleteForecastRequest generates a "aws/request.Request" representing the
// client's request for the DeleteForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteForecast for more information on using the DeleteForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteForecastRequest method.
//    req, resp := client.DeleteForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecast
func (c *ForecastService) DeleteForecastRequest(input *DeleteForecastInput) (req *request.Request, output *DeleteForecastOutput) {
	op := &request.Operation{
		Name:       opDeleteForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteForecastInput{}
	}

	output = &DeleteForecastOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteForecast API operation for Amazon Forecast Service.
//
// Deletes a forecast created using the CreateForecast operation. You can delete
// only forecasts that have a status of ACTIVE or CREATE_FAILED. To get the
// status, use the DescribeForecast operation.
//
// You can't delete a forecast while it is being exported. After a forecast
// is deleted, you can no longer query the forecast.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeleteForecast for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecast
func (c *ForecastService) DeleteForecast(input *DeleteForecastInput) (*DeleteForecastOutput, error) {
	req, out := c.DeleteForecastRequest(input)
	return out, req.Send()
}

// DeleteForecastWithContext is the same as DeleteForecast with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeleteForecastWithContext(ctx aws.Context, input *DeleteForecastInput, opts ...request.Option) (*DeleteForecastOutput, error) {
	req, out := c.DeleteForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteForecastExportJob = "DeleteForecastExportJob"

// DeleteForecastExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteForecastExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteForecastExportJob for more information on using the DeleteForecastExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteForecastExportJobRequest method.
//    req, resp := client.DeleteForecastExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecastExportJob
func (c *ForecastService) DeleteForecastExportJobRequest(input *DeleteForecastExportJobInput) (req *request.Request, output *DeleteForecastExportJobOutput) {
	op := &request.Operation{
		Name:       opDeleteForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteForecastExportJobInput{}
	}

	output = &DeleteForecastExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteForecastExportJob API operation for Amazon Forecast Service.
//
// Deletes a forecast export job created using the CreateForecastExportJob operation.
// You can delete only export jobs that have a status of ACTIVE or CREATE_FAILED.
// To get the status, use the DescribeForecastExportJob operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeleteForecastExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecastExportJob
func (c *ForecastService) DeleteForecastExportJob(input *DeleteForecastExportJobInput) (*DeleteForecastExportJobOutput, error) {
	req, out := c.DeleteForecastExportJobRequest(input)
	return out, req.Send()
}

// DeleteForecastExportJobWithContext is the same as DeleteForecastExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteForecastExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeleteForecastExportJobWithContext(ctx aws.Context, input *DeleteForecastExportJobInput, opts ...request.Option) (*DeleteForecastExportJobOutput, error) {
	req, out := c.DeleteForecastExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePredictor = "DeletePredictor"

// DeletePredictorRequest generates a "aws/request.Request" representing the
// client's request for the DeletePredictor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePredictor for more information on using the DeletePredictor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePredictorRequest method.
//    req, resp := client.DeletePredictorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictor
func (c *ForecastService) DeletePredictorRequest(input *DeletePredictorInput) (req *request.Request, output *DeletePredictorOutput) {
	op := &request.Operation{
		Name:       opDeletePredictor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePredictorInput{}
	}

	output = &DeletePredictorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePredictor API operation for Amazon Forecast Service.
//
// Deletes a predictor created using the CreatePredictor operation. You can
// delete only predictor that have a status of ACTIVE or CREATE_FAILED. To get
// the status, use the DescribePredictor operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DeletePredictor for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictor
func (c *ForecastService) DeletePredictor(input *DeletePredictorInput) (*DeletePredictorOutput, error) {
	req, out := c.DeletePredictorRequest(input)
	return out, req.Send()
}

// DeletePredictorWithContext is the same as DeletePredictor with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePredictor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DeletePredictorWithContext(ctx aws.Context, input *DeletePredictorInput, opts ...request.Option) (*DeletePredictorOutput, error) {
	req, out := c.DeletePredictorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDataset
func (c *ForecastService) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Forecast Service.
//
// Describes an Amazon Forecast dataset created using the CreateDataset operation.
//
// In addition to listing the parameters specified in the CreateDataset request,
// this operation includes the following dataset properties:
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDataset
func (c *ForecastService) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetGroup = "DescribeDatasetGroup"

// DescribeDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetGroup for more information on using the DescribeDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetGroupRequest method.
//    req, resp := client.DescribeDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetGroup
func (c *ForecastService) DescribeDatasetGroupRequest(input *DescribeDatasetGroupInput) (req *request.Request, output *DescribeDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetGroupInput{}
	}

	output = &DescribeDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetGroup API operation for Amazon Forecast Service.
//
// Describes a dataset group created using the CreateDatasetGroup operation.
//
// In addition to listing the parameters provided in the CreateDatasetGroup
// request, this operation includes the following properties:
//
//    * DatasetArns - The datasets belonging to the group.
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribeDatasetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetGroup
func (c *ForecastService) DescribeDatasetGroup(input *DescribeDatasetGroupInput) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	return out, req.Send()
}

// DescribeDatasetGroupWithContext is the same as DescribeDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribeDatasetGroupWithContext(ctx aws.Context, input *DescribeDatasetGroupInput, opts ...request.Option) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetImportJob = "DescribeDatasetImportJob"

// DescribeDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetImportJob for more information on using the DescribeDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetImportJobRequest method.
//    req, resp := client.DescribeDatasetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetImportJob
func (c *ForecastService) DescribeDatasetImportJobRequest(input *DescribeDatasetImportJobInput) (req *request.Request, output *DescribeDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetImportJobInput{}
	}

	output = &DescribeDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetImportJob API operation for Amazon Forecast Service.
//
// Describes a dataset import job created using the CreateDatasetImportJob operation.
//
// In addition to listing the parameters provided in the CreateDatasetImportJob
// request, this operation includes the following properties:
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * DataSize
//
//    * FieldStatistics
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribeDatasetImportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetImportJob
func (c *ForecastService) DescribeDatasetImportJob(input *DescribeDatasetImportJobInput) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	return out, req.Send()
}

// DescribeDatasetImportJobWithContext is the same as DescribeDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribeDatasetImportJobWithContext(ctx aws.Context, input *DescribeDatasetImportJobInput, opts ...request.Option) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeForecast = "DescribeForecast"

// DescribeForecastRequest generates a "aws/request.Request" representing the
// client's request for the DescribeForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeForecast for more information on using the DescribeForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeForecastRequest method.
//    req, resp := client.DescribeForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecast
func (c *ForecastService) DescribeForecastRequest(input *DescribeForecastInput) (req *request.Request, output *DescribeForecastOutput) {
	op := &request.Operation{
		Name:       opDescribeForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeForecastInput{}
	}

	output = &DescribeForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeForecast API operation for Amazon Forecast Service.
//
// Describes a forecast created using the CreateForecast operation.
//
// In addition to listing the properties provided in the CreateForecast request,
// this operation lists the following properties:
//
//    * DatasetGroupArn - The dataset group that provided the training data.
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribeForecast for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecast
func (c *ForecastService) DescribeForecast(input *DescribeForecastInput) (*DescribeForecastOutput, error) {
	req, out := c.DescribeForecastRequest(input)
	return out, req.Send()
}

// DescribeForecastWithContext is the same as DescribeForecast with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribeForecastWithContext(ctx aws.Context, input *DescribeForecastInput, opts ...request.Option) (*DescribeForecastOutput, error) {
	req, out := c.DescribeForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeForecastExportJob = "DescribeForecastExportJob"

// DescribeForecastExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeForecastExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeForecastExportJob for more information on using the DescribeForecastExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeForecastExportJobRequest method.
//    req, resp := client.DescribeForecastExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecastExportJob
func (c *ForecastService) DescribeForecastExportJobRequest(input *DescribeForecastExportJobInput) (req *request.Request, output *DescribeForecastExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeForecastExportJobInput{}
	}

	output = &DescribeForecastExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeForecastExportJob API operation for Amazon Forecast Service.
//
// Describes a forecast export job created using the CreateForecastExportJob
// operation.
//
// In addition to listing the properties provided by the user in the CreateForecastExportJob
// request, this operation lists the following properties:
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribeForecastExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecastExportJob
func (c *ForecastService) DescribeForecastExportJob(input *DescribeForecastExportJobInput) (*DescribeForecastExportJobOutput, error) {
	req, out := c.DescribeForecastExportJobRequest(input)
	return out, req.Send()
}

// DescribeForecastExportJobWithContext is the same as DescribeForecastExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeForecastExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribeForecastExportJobWithContext(ctx aws.Context, input *DescribeForecastExportJobInput, opts ...request.Option) (*DescribeForecastExportJobOutput, error) {
	req, out := c.DescribeForecastExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePredictor = "DescribePredictor"

// DescribePredictorRequest generates a "aws/request.Request" representing the
// client's request for the DescribePredictor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePredictor for more information on using the DescribePredictor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePredictorRequest method.
//    req, resp := client.DescribePredictorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictor
func (c *ForecastService) DescribePredictorRequest(input *DescribePredictorInput) (req *request.Request, output *DescribePredictorOutput) {
	op := &request.Operation{
		Name:       opDescribePredictor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePredictorInput{}
	}

	output = &DescribePredictorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePredictor API operation for Amazon Forecast Service.
//
// Describes a predictor created using the CreatePredictor operation.
//
// In addition to listing the properties provided in the CreatePredictor request,
// this operation lists the following properties:
//
//    * DatasetImportJobArns - The dataset import jobs used to import training
//    data.
//
//    * AutoMLAlgorithmArns - If AutoML is performed, the algorithms that were
//    evaluated.
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation DescribePredictor for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictor
func (c *ForecastService) DescribePredictor(input *DescribePredictorInput) (*DescribePredictorOutput, error) {
	req, out := c.DescribePredictorRequest(input)
	return out, req.Send()
}

// DescribePredictorWithContext is the same as DescribePredictor with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePredictor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) DescribePredictorWithContext(ctx aws.Context, input *DescribePredictorInput, opts ...request.Option) (*DescribePredictorOutput, error) {
	req, out := c.DescribePredictorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccuracyMetrics = "GetAccuracyMetrics"

// GetAccuracyMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccuracyMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccuracyMetrics for more information on using the GetAccuracyMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccuracyMetricsRequest method.
//    req, resp := client.GetAccuracyMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/GetAccuracyMetrics
func (c *ForecastService) GetAccuracyMetricsRequest(input *GetAccuracyMetricsInput) (req *request.Request, output *GetAccuracyMetricsOutput) {
	op := &request.Operation{
		Name:       opGetAccuracyMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccuracyMetricsInput{}
	}

	output = &GetAccuracyMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccuracyMetrics API operation for Amazon Forecast Service.
//
// Provides metrics on the accuracy of the models that were trained by the CreatePredictor
// operation. Use metrics to see how well the model performed and to decide
// whether to use the predictor to generate a forecast. For more information,
// see metrics.
//
// This operation generates metrics for each backtest window that was evaluated.
// The number of backtest windows (NumberOfBacktestWindows) is specified using
// the EvaluationParameters object, which is optionally included in the CreatePredictor
// request. If NumberOfBacktestWindows isn't specified, the number defaults
// to one.
//
// The parameters of the filling method determine which items contribute to
// the metrics. If you want all items to contribute, specify zero. If you want
// only those items that have complete data in the range being evaluated to
// contribute, specify nan. For more information, see FeaturizationMethod.
//
// Before you can get accuracy metrics, the Status of the predictor must be
// ACTIVE, signifying that training has completed. To get the status, use the
// DescribePredictor operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation GetAccuracyMetrics for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/GetAccuracyMetrics
func (c *ForecastService) GetAccuracyMetrics(input *GetAccuracyMetricsInput) (*GetAccuracyMetricsOutput, error) {
	req, out := c.GetAccuracyMetricsRequest(input)
	return out, req.Send()
}

// GetAccuracyMetricsWithContext is the same as GetAccuracyMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccuracyMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) GetAccuracyMetricsWithContext(ctx aws.Context, input *GetAccuracyMetricsInput, opts ...request.Option) (*GetAccuracyMetricsOutput, error) {
	req, out := c.GetAccuracyMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasetGroups = "ListDatasetGroups"

// ListDatasetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetGroups for more information on using the ListDatasetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetGroupsRequest method.
//    req, resp := client.ListDatasetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups
func (c *ForecastService) ListDatasetGroupsRequest(input *ListDatasetGroupsInput) (req *request.Request, output *ListDatasetGroupsOutput) {
	op := &request.Operation{
		Name:       opListDatasetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetGroupsInput{}
	}

	output = &ListDatasetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetGroups API operation for Amazon Forecast Service.
//
// Returns a list of dataset groups created using the CreateDatasetGroup operation.
// For each dataset group, this operation returns a summary of its properties,
// including its Amazon Resource Name (ARN). You can retrieve the complete set
// of properties by using the dataset group ARN with the DescribeDatasetGroup
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListDatasetGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups
func (c *ForecastService) ListDatasetGroups(input *ListDatasetGroupsInput) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	return out, req.Send()
}

// ListDatasetGroupsWithContext is the same as ListDatasetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetGroupsWithContext(ctx aws.Context, input *ListDatasetGroupsInput, opts ...request.Option) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetGroupsPages iterates over the pages of a ListDatasetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetGroups operation.
//    pageNum := 0
//    err := client.ListDatasetGroupsPages(params,
//        func(page *forecastservice.ListDatasetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListDatasetGroupsPages(input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool) error {
	return c.ListDatasetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetGroupsPagesWithContext same as ListDatasetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetGroupsPagesWithContext(ctx aws.Context, input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetImportJobs = "ListDatasetImportJobs"

// ListDatasetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetImportJobs for more information on using the ListDatasetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetImportJobsRequest method.
//    req, resp := client.ListDatasetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs
func (c *ForecastService) ListDatasetImportJobsRequest(input *ListDatasetImportJobsInput) (req *request.Request, output *ListDatasetImportJobsOutput) {
	op := &request.Operation{
		Name:       opListDatasetImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetImportJobsInput{}
	}

	output = &ListDatasetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetImportJobs API operation for Amazon Forecast Service.
//
// Returns a list of dataset import jobs created using the CreateDatasetImportJob
// operation. For each import job, this operation returns a summary of its properties,
// including its Amazon Resource Name (ARN). You can retrieve the complete set
// of properties by using the ARN with the DescribeDatasetImportJob operation.
// You can filter the list by providing an array of Filter objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListDatasetImportJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs
func (c *ForecastService) ListDatasetImportJobs(input *ListDatasetImportJobsInput) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	return out, req.Send()
}

// ListDatasetImportJobsWithContext is the same as ListDatasetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetImportJobsWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, opts ...request.Option) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetImportJobsPages iterates over the pages of a ListDatasetImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetImportJobs operation.
//    pageNum := 0
//    err := client.ListDatasetImportJobsPages(params,
//        func(page *forecastservice.ListDatasetImportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListDatasetImportJobsPages(input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool) error {
	return c.ListDatasetImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetImportJobsPagesWithContext same as ListDatasetImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetImportJobsPagesWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetsRequest method.
//    req, resp := client.ListDatasetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets
func (c *ForecastService) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Forecast Service.
//
// Returns a list of datasets created using the CreateDataset operation. For
// each dataset, a summary of its properties, including its Amazon Resource
// Name (ARN), is returned. To retrieve the complete set of properties, use
// the ARN with the DescribeDataset operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets
func (c *ForecastService) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasets operation.
//    pageNum := 0
//    err := client.ListDatasetsPages(params,
//        func(page *forecastservice.ListDatasetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListForecastExportJobs = "ListForecastExportJobs"

// ListForecastExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListForecastExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListForecastExportJobs for more information on using the ListForecastExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListForecastExportJobsRequest method.
//    req, resp := client.ListForecastExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs
func (c *ForecastService) ListForecastExportJobsRequest(input *ListForecastExportJobsInput) (req *request.Request, output *ListForecastExportJobsOutput) {
	op := &request.Operation{
		Name:       opListForecastExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListForecastExportJobsInput{}
	}

	output = &ListForecastExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListForecastExportJobs API operation for Amazon Forecast Service.
//
// Returns a list of forecast export jobs created using the CreateForecastExportJob
// operation. For each forecast export job, this operation returns a summary
// of its properties, including its Amazon Resource Name (ARN). To retrieve
// the complete set of properties, use the ARN with the DescribeForecastExportJob
// operation. You can filter the list using an array of Filter objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListForecastExportJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs
func (c *ForecastService) ListForecastExportJobs(input *ListForecastExportJobsInput) (*ListForecastExportJobsOutput, error) {
	req, out := c.ListForecastExportJobsRequest(input)
	return out, req.Send()
}

// ListForecastExportJobsWithContext is the same as ListForecastExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListForecastExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListForecastExportJobsWithContext(ctx aws.Context, input *ListForecastExportJobsInput, opts ...request.Option) (*ListForecastExportJobsOutput, error) {
	req, out := c.ListForecastExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListForecastExportJobsPages iterates over the pages of a ListForecastExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListForecastExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListForecastExportJobs operation.
//    pageNum := 0
//    err := client.ListForecastExportJobsPages(params,
//        func(page *forecastservice.ListForecastExportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListForecastExportJobsPages(input *ListForecastExportJobsInput, fn func(*ListForecastExportJobsOutput, bool) bool) error {
	return c.ListForecastExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListForecastExportJobsPagesWithContext same as ListForecastExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListForecastExportJobsPagesWithContext(ctx aws.Context, input *ListForecastExportJobsInput, fn func(*ListForecastExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListForecastExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListForecastExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListForecastExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListForecasts = "ListForecasts"

// ListForecastsRequest generates a "aws/request.Request" representing the
// client's request for the ListForecasts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListForecasts for more information on using the ListForecasts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListForecastsRequest method.
//    req, resp := client.ListForecastsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts
func (c *ForecastService) ListForecastsRequest(input *ListForecastsInput) (req *request.Request, output *ListForecastsOutput) {
	op := &request.Operation{
		Name:       opListForecasts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListForecastsInput{}
	}

	output = &ListForecastsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListForecasts API operation for Amazon Forecast Service.
//
// Returns a list of forecasts created using the CreateForecast operation. For
// each forecast, this operation returns a summary of its properties, including
// its Amazon Resource Name (ARN). To retrieve the complete set of properties,
// specify the ARN with the DescribeForecast operation. You can filter the list
// using an array of Filter objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListForecasts for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts
func (c *ForecastService) ListForecasts(input *ListForecastsInput) (*ListForecastsOutput, error) {
	req, out := c.ListForecastsRequest(input)
	return out, req.Send()
}

// ListForecastsWithContext is the same as ListForecasts with the addition of
// the ability to pass a context and additional request options.
//
// See ListForecasts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListForecastsWithContext(ctx aws.Context, input *ListForecastsInput, opts ...request.Option) (*ListForecastsOutput, error) {
	req, out := c.ListForecastsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListForecastsPages iterates over the pages of a ListForecasts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListForecasts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListForecasts operation.
//    pageNum := 0
//    err := client.ListForecastsPages(params,
//        func(page *forecastservice.ListForecastsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListForecastsPages(input *ListForecastsInput, fn func(*ListForecastsOutput, bool) bool) error {
	return c.ListForecastsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListForecastsPagesWithContext same as ListForecastsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListForecastsPagesWithContext(ctx aws.Context, input *ListForecastsInput, fn func(*ListForecastsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListForecastsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListForecastsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListForecastsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPredictors = "ListPredictors"

// ListPredictorsRequest generates a "aws/request.Request" representing the
// client's request for the ListPredictors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPredictors for more information on using the ListPredictors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPredictorsRequest method.
//    req, resp := client.ListPredictorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors
func (c *ForecastService) ListPredictorsRequest(input *ListPredictorsInput) (req *request.Request, output *ListPredictorsOutput) {
	op := &request.Operation{
		Name:       opListPredictors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPredictorsInput{}
	}

	output = &ListPredictorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPredictors API operation for Amazon Forecast Service.
//
// Returns a list of predictors created using the CreatePredictor operation.
// For each predictor, this operation returns a summary of its properties, including
// its Amazon Resource Name (ARN). You can retrieve the complete set of properties
// by using the ARN with the DescribePredictor operation. You can filter the
// list using an array of Filter objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation ListPredictors for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token is not valid. Tokens expire after 24 hours.
//
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors
func (c *ForecastService) ListPredictors(input *ListPredictorsInput) (*ListPredictorsOutput, error) {
	req, out := c.ListPredictorsRequest(input)
	return out, req.Send()
}

// ListPredictorsWithContext is the same as ListPredictors with the addition of
// the ability to pass a context and additional request options.
//
// See ListPredictors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListPredictorsWithContext(ctx aws.Context, input *ListPredictorsInput, opts ...request.Option) (*ListPredictorsOutput, error) {
	req, out := c.ListPredictorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPredictorsPages iterates over the pages of a ListPredictors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPredictors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPredictors operation.
//    pageNum := 0
//    err := client.ListPredictorsPages(params,
//        func(page *forecastservice.ListPredictorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ForecastService) ListPredictorsPages(input *ListPredictorsInput, fn func(*ListPredictorsOutput, bool) bool) error {
	return c.ListPredictorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPredictorsPagesWithContext same as ListPredictorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) ListPredictorsPagesWithContext(ctx aws.Context, input *ListPredictorsInput, fn func(*ListPredictorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPredictorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPredictorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPredictorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateDatasetGroup = "UpdateDatasetGroup"

// UpdateDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatasetGroup for more information on using the UpdateDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatasetGroupRequest method.
//    req, resp := client.UpdateDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UpdateDatasetGroup
func (c *ForecastService) UpdateDatasetGroupRequest(input *UpdateDatasetGroupInput) (req *request.Request, output *UpdateDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatasetGroupInput{}
	}

	output = &UpdateDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatasetGroup API operation for Amazon Forecast Service.
//
// Replaces the datasets in a dataset group with the specified datasets.
//
// The Status of the dataset group must be ACTIVE before you can use the dataset
// group to create a predictor. Use the DescribeDatasetGroup operation to get
// the status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Forecast Service's
// API operation UpdateDatasetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   We can't process the request because it includes an invalid value or a value
//   that exceeds the valid range.
//
//   * ResourceNotFoundException
//   We can't find a resource with that Amazon Resource Name (ARN). Check the
//   ARN and try again.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UpdateDatasetGroup
func (c *ForecastService) UpdateDatasetGroup(input *UpdateDatasetGroupInput) (*UpdateDatasetGroupOutput, error) {
	req, out := c.UpdateDatasetGroupRequest(input)
	return out, req.Send()
}

// UpdateDatasetGroupWithContext is the same as UpdateDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ForecastService) UpdateDatasetGroupWithContext(ctx aws.Context, input *UpdateDatasetGroupInput, opts ...request.Option) (*UpdateDatasetGroupOutput, error) {
	req, out := c.UpdateDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies a categorical hyperparameter and it's range of tunable values.
// This object is part of the ParameterRanges object.
type CategoricalParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the categorical hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of the tunable categories for the hyperparameter.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CategoricalParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoricalParameterRange"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CategoricalParameterRange) SetName(v string) *CategoricalParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *CategoricalParameterRange) SetValues(v []*string) *CategoricalParameterRange {
	s.Values = v
	return s
}

// Specifies a continuous hyperparameter and it's range of tunable values. This
// object is part of the ParameterRanges object.
type ContinuousParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum tunable value of the hyperparameter.
	//
	// MaxValue is a required field
	MaxValue *float64 `type:"double" required:"true"`

	// The minimum tunable value of the hyperparameter.
	//
	// MinValue is a required field
	MinValue *float64 `type:"double" required:"true"`

	// The name of the hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// Valid values:
	//
	// Auto
	//
	// Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have values greater than 0.
	//
	// ReverseLogarithmic
	//
	// hyperparameter tuning searches the values in the hyperparameter range by
	// using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0 <= x < 1.0.
	//
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	ScalingType *string `type:"string" enum:"ScalingType"`
}

// String returns the string representation
func (s ContinuousParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinuousParameterRange"}
	if s.MaxValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxValue"))
	}
	if s.MinValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MinValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *ContinuousParameterRange) SetMaxValue(v float64) *ContinuousParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ContinuousParameterRange) SetMinValue(v float64) *ContinuousParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContinuousParameterRange) SetName(v string) *ContinuousParameterRange {
	s.Name = &v
	return s
}

// SetScalingType sets the ScalingType field's value.
func (s *ContinuousParameterRange) SetScalingType(v string) *ContinuousParameterRange {
	s.ScalingType = &v
	return s
}

type CreateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// An array of Amazon Resource Names (ARNs) of the datasets that you want to
	// include in the dataset group.
	DatasetArns []*string `type:"list"`

	// A name for the dataset group.
	//
	// DatasetGroupName is a required field
	DatasetGroupName *string `min:"1" type:"string" required:"true"`

	// The domain associated with the dataset group. When you add a dataset to a
	// dataset group, this value and the value specified for the Domain parameter
	// of the CreateDataset operation must match.
	//
	// The Domain and DatasetType that you choose determine the fields that must
	// be present in training data that you import to a dataset. For example, if
	// you choose the RETAIL domain and TARGET_TIME_SERIES as the DatasetType, Amazon
	// Forecast requires that item_id, timestamp, and demand fields are present
	// in your data. For more information, see howitworks-datasets-groups.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true" enum:"Domain"`
}

// String returns the string representation
func (s CreateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetGroupInput"}
	if s.DatasetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupName"))
	}
	if s.DatasetGroupName != nil && len(*s.DatasetGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetGroupName", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArns sets the DatasetArns field's value.
func (s *CreateDatasetGroupInput) SetDatasetArns(v []*string) *CreateDatasetGroupInput {
	s.DatasetArns = v
	return s
}

// SetDatasetGroupName sets the DatasetGroupName field's value.
func (s *CreateDatasetGroupInput) SetDatasetGroupName(v string) *CreateDatasetGroupInput {
	s.DatasetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDatasetGroupInput) SetDomain(v string) *CreateDatasetGroupInput {
	s.Domain = &v
	return s
}

type CreateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateDatasetGroupOutput) SetDatasetGroupArn(v string) *CreateDatasetGroupOutput {
	s.DatasetGroupArn = &v
	return s
}

type CreateDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The location of the training data to import and an AWS Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the data.
	// The training data must be stored in an Amazon S3 bucket.
	//
	// If encryption is used, DataSource must include an AWS Key Management Service
	// (KMS) key and the IAM role must allow Amazon Forecast permission to access
	// the key. The KMS key and IAM role must match those specified in the EncryptionConfig
	// parameter of the CreateDataset operation.
	//
	// DataSource is a required field
	DataSource *DataSource `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want
	// to import data to.
	//
	// DatasetArn is a required field
	DatasetArn *string `type:"string" required:"true"`

	// The name for the dataset import job. We recommend including the current timestamp
	// in the name, for example, 20190721DatasetImport. This can help you avoid
	// getting a ResourceAlreadyExistsException exception.
	//
	// DatasetImportJobName is a required field
	DatasetImportJobName *string `min:"1" type:"string" required:"true"`

	// The format of timestamps in the dataset. The format that you specify depends
	// on the DataFrequency specified when the dataset was created. The following
	// formats are supported
	//
	//    * "yyyy-MM-dd" For the following data frequencies: Y, M, W, and D
	//
	//    * "yyyy-MM-dd HH:mm:ss" For the following data frequencies: H, 30min,
	//    15min, and 1min; and optionally, for: Y, M, W, and D
	//
	// If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd
	// HH:mm:ss".
	TimestampFormat *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetImportJobInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetImportJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetImportJobName"))
	}
	if s.DatasetImportJobName != nil && len(*s.DatasetImportJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetImportJobName", 1))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDatasetImportJobInput) SetDataSource(v *DataSource) *CreateDatasetImportJobInput {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetImportJobInput) SetDatasetArn(v string) *CreateDatasetImportJobInput {
	s.DatasetArn = &v
	return s
}

// SetDatasetImportJobName sets the DatasetImportJobName field's value.
func (s *CreateDatasetImportJobInput) SetDatasetImportJobName(v string) *CreateDatasetImportJobInput {
	s.DatasetImportJobName = &v
	return s
}

// SetTimestampFormat sets the TimestampFormat field's value.
func (s *CreateDatasetImportJobInput) SetTimestampFormat(v string) *CreateDatasetImportJobInput {
	s.TimestampFormat = &v
	return s
}

type CreateDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *CreateDatasetImportJobOutput) SetDatasetImportJobArn(v string) *CreateDatasetImportJobOutput {
	s.DatasetImportJobArn = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The frequency of data collection. This parameter is required for RELATED_TIME_SERIES
	// datasets.
	//
	// Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min
	// (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and
	// 1min (1 minute). For example, "D" indicates every day and "15min" indicates
	// every 15 minutes.
	DataFrequency *string `type:"string"`

	// A name for the dataset.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// The dataset type. Valid values depend on the chosen Domain.
	//
	// DatasetType is a required field
	DatasetType *string `type:"string" required:"true" enum:"DatasetType"`

	// The domain associated with the dataset. When you add a dataset to a dataset
	// group, this value and the value specified for the Domain parameter of the
	// CreateDatasetGroup operation must match.
	//
	// The Domain and DatasetType that you choose determine the fields that must
	// be present in the training data that you import to the dataset. For example,
	// if you choose the RETAIL domain and TARGET_TIME_SERIES as the DatasetType,
	// Amazon Forecast requires item_id, timestamp, and demand fields to be present
	// in your data. For more information, see howitworks-datasets-groups.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true" enum:"Domain"`

	// An AWS Key Management Service (KMS) key and the AWS Identity and Access Management
	// (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// The schema for the dataset. The schema attributes and their order must match
	// the fields in your data. The dataset Domain and DatasetType that you choose
	// determine the minimum required fields in your training data. For information
	// about the required fields for a specific dataset domain and type, see howitworks-domains-ds-types.
	//
	// Schema is a required field
	Schema *Schema `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}
	if s.EncryptionConfig != nil {
		if err := s.EncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Schema != nil {
		if err := s.Schema.Validate(); err != nil {
			invalidParams.AddNested("Schema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataFrequency sets the DataFrequency field's value.
func (s *CreateDatasetInput) SetDataFrequency(v string) *CreateDatasetInput {
	s.DataFrequency = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetInput) SetDatasetName(v string) *CreateDatasetInput {
	s.DatasetName = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDatasetInput) SetDomain(v string) *CreateDatasetInput {
	s.Domain = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *CreateDatasetInput) SetEncryptionConfig(v *EncryptionConfig) *CreateDatasetInput {
	s.EncryptionConfig = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateDatasetInput) SetSchema(v *Schema) *CreateDatasetInput {
	s.Schema = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type CreateForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The location where you want to save the forecast and an AWS Identity and
	// Access Management (IAM) role that Amazon Forecast can assume to access the
	// location. The forecast must be exported to an Amazon S3 bucket.
	//
	// If encryption is used, Destination must include an AWS Key Management Service
	// (KMS) key. The IAM role must allow Amazon Forecast permission to access the
	// key.
	//
	// Destination is a required field
	Destination *DataDestination `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the forecast that you want to export.
	//
	// ForecastArn is a required field
	ForecastArn *string `type:"string" required:"true"`

	// The name for the forecast export job.
	//
	// ForecastExportJobName is a required field
	ForecastExportJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateForecastExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateForecastExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateForecastExportJobInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ForecastArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastArn"))
	}
	if s.ForecastExportJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastExportJobName"))
	}
	if s.ForecastExportJobName != nil && len(*s.ForecastExportJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForecastExportJobName", 1))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *CreateForecastExportJobInput) SetDestination(v *DataDestination) *CreateForecastExportJobInput {
	s.Destination = v
	return s
}

// SetForecastArn sets the ForecastArn field's value.
func (s *CreateForecastExportJobInput) SetForecastArn(v string) *CreateForecastExportJobInput {
	s.ForecastArn = &v
	return s
}

// SetForecastExportJobName sets the ForecastExportJobName field's value.
func (s *CreateForecastExportJobInput) SetForecastExportJobName(v string) *CreateForecastExportJobInput {
	s.ForecastExportJobName = &v
	return s
}

type CreateForecastExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the export job.
	ForecastExportJobArn *string `type:"string"`
}

// String returns the string representation
func (s CreateForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateForecastExportJobOutput) GoString() string {
	return s.String()
}

// SetForecastExportJobArn sets the ForecastExportJobArn field's value.
func (s *CreateForecastExportJobOutput) SetForecastExportJobArn(v string) *CreateForecastExportJobOutput {
	s.ForecastExportJobArn = &v
	return s
}

type CreateForecastInput struct {
	_ struct{} `type:"structure"`

	// A name for the forecast.
	//
	// ForecastName is a required field
	ForecastName *string `min:"1" type:"string" required:"true"`

	// The quantiles at which probabilistic forecasts are generated. You can specify
	// up to 5 quantiles per forecast. Accepted values include 0.01 to 0.99 (increments
	// of .01 only) and mean. The mean forecast is different from the median (0.50)
	// when the distribution is not symmetric (e.g. Beta, Negative Binomial). The
	// default value is ["0.1", "0.5", "0.9"].
	ForecastTypes []*string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateForecastInput"}
	if s.ForecastName == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastName"))
	}
	if s.ForecastName != nil && len(*s.ForecastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForecastName", 1))
	}
	if s.ForecastTypes != nil && len(s.ForecastTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForecastTypes", 1))
	}
	if s.PredictorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecastName sets the ForecastName field's value.
func (s *CreateForecastInput) SetForecastName(v string) *CreateForecastInput {
	s.ForecastName = &v
	return s
}

// SetForecastTypes sets the ForecastTypes field's value.
func (s *CreateForecastInput) SetForecastTypes(v []*string) *CreateForecastInput {
	s.ForecastTypes = v
	return s
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *CreateForecastInput) SetPredictorArn(v string) *CreateForecastInput {
	s.PredictorArn = &v
	return s
}

type CreateForecastOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast.
	ForecastArn *string `type:"string"`
}

// String returns the string representation
func (s CreateForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateForecastOutput) GoString() string {
	return s.String()
}

// SetForecastArn sets the ForecastArn field's value.
func (s *CreateForecastOutput) SetForecastArn(v string) *CreateForecastOutput {
	s.ForecastArn = &v
	return s
}

type CreatePredictorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm to use for model training.
	// Required if PerformAutoML is not set to true.
	//
	// Supported algorithms:
	//
	//    * arn:aws:forecast:::algorithm/ARIMA
	//
	//    * arn:aws:forecast:::algorithm/Deep_AR_Plus Supports hyperparameter optimization
	//    (HPO)
	//
	//    * arn:aws:forecast:::algorithm/ETS
	//
	//    * arn:aws:forecast:::algorithm/NPTS
	//
	//    * arn:aws:forecast:::algorithm/Prophet
	AlgorithmArn *string `type:"string"`

	// An AWS Key Management Service (KMS) key and the AWS Identity and Access Management
	// (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// Used to override the default evaluation parameters of the specified algorithm.
	// Amazon Forecast evaluates a predictor by splitting a dataset into training
	// data and testing data. The evaluation parameters define how to perform the
	// split and the number of iterations.
	EvaluationParameters *EvaluationParameters `type:"structure"`

	// The featurization configuration.
	//
	// FeaturizationConfig is a required field
	FeaturizationConfig *FeaturizationConfig `type:"structure" required:"true"`

	// Specifies the number of time-steps that the model is trained to predict.
	// The forecast horizon is also called the prediction length.
	//
	// For example, if you configure a dataset for daily data collection (using
	// the DataFrequency parameter of the CreateDataset operation) and set the forecast
	// horizon to 10, the model returns predictions for 10 days.
	//
	// The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the
	// TARGET_TIME_SERIES dataset length.
	//
	// ForecastHorizon is a required field
	ForecastHorizon *int64 `type:"integer" required:"true"`

	// Provides hyperparameter override values for the algorithm. If you don't provide
	// this parameter, Amazon Forecast uses default values. The individual algorithms
	// specify which hyperparameters support hyperparameter optimization (HPO).
	// For more information, see aws-forecast-choosing-recipes.
	//
	// If you included the HPOConfig object, you must set PerformHPO to true.
	HPOConfig *HyperParameterTuningJobConfig `type:"structure"`

	// Describes the dataset group that contains the data to use to train the predictor.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates
	// the algorithms it provides and chooses the best algorithm and configuration
	// for your training dataset.
	//
	// The default value is false. In this case, you are required to specify an
	// algorithm.
	//
	// Set PerformAutoML to true to have Amazon Forecast perform AutoML. This is
	// a good option if you aren't sure which algorithm is suitable for your training
	// data. In this case, PerformHPO must be false.
	PerformAutoML *bool `type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter
	// values for your training data. The process of performing HPO is known as
	// running a hyperparameter tuning job.
	//
	// The default value is false. In this case, Amazon Forecast uses default hyperparameter
	// values from the chosen algorithm.
	//
	// To override the default values, set PerformHPO to true and, optionally, supply
	// the HyperParameterTuningJobConfig object. The tuning job specifies a metric
	// to optimize, which hyperparameters participate in tuning, and the valid range
	// for each tunable hyperparameter. In this case, you are required to specify
	// an algorithm and PerformAutoML must be false.
	//
	// The following algorithm supports HPO:
	//
	//    * DeepAR+
	PerformHPO *bool `type:"boolean"`

	// A name for the predictor.
	//
	// PredictorName is a required field
	PredictorName *string `min:"1" type:"string" required:"true"`

	// The hyperparameters to override for model training. The hyperparameters that
	// you can override are listed in the individual algorithms. For the list of
	// supported algorithms, see aws-forecast-choosing-recipes.
	TrainingParameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreatePredictorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePredictorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePredictorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePredictorInput"}
	if s.FeaturizationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FeaturizationConfig"))
	}
	if s.ForecastHorizon == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastHorizon"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.PredictorName == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictorName"))
	}
	if s.PredictorName != nil && len(*s.PredictorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PredictorName", 1))
	}
	if s.EncryptionConfig != nil {
		if err := s.EncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.FeaturizationConfig != nil {
		if err := s.FeaturizationConfig.Validate(); err != nil {
			invalidParams.AddNested("FeaturizationConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HPOConfig != nil {
		if err := s.HPOConfig.Validate(); err != nil {
			invalidParams.AddNested("HPOConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *CreatePredictorInput) SetAlgorithmArn(v string) *CreatePredictorInput {
	s.AlgorithmArn = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *CreatePredictorInput) SetEncryptionConfig(v *EncryptionConfig) *CreatePredictorInput {
	s.EncryptionConfig = v
	return s
}

// SetEvaluationParameters sets the EvaluationParameters field's value.
func (s *CreatePredictorInput) SetEvaluationParameters(v *EvaluationParameters) *CreatePredictorInput {
	s.EvaluationParameters = v
	return s
}

// SetFeaturizationConfig sets the FeaturizationConfig field's value.
func (s *CreatePredictorInput) SetFeaturizationConfig(v *FeaturizationConfig) *CreatePredictorInput {
	s.FeaturizationConfig = v
	return s
}

// SetForecastHorizon sets the ForecastHorizon field's value.
func (s *CreatePredictorInput) SetForecastHorizon(v int64) *CreatePredictorInput {
	s.ForecastHorizon = &v
	return s
}

// SetHPOConfig sets the HPOConfig field's value.
func (s *CreatePredictorInput) SetHPOConfig(v *HyperParameterTuningJobConfig) *CreatePredictorInput {
	s.HPOConfig = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreatePredictorInput) SetInputDataConfig(v *InputDataConfig) *CreatePredictorInput {
	s.InputDataConfig = v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *CreatePredictorInput) SetPerformAutoML(v bool) *CreatePredictorInput {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *CreatePredictorInput) SetPerformHPO(v bool) *CreatePredictorInput {
	s.PerformHPO = &v
	return s
}

// SetPredictorName sets the PredictorName field's value.
func (s *CreatePredictorInput) SetPredictorName(v string) *CreatePredictorInput {
	s.PredictorName = &v
	return s
}

// SetTrainingParameters sets the TrainingParameters field's value.
func (s *CreatePredictorInput) SetTrainingParameters(v map[string]*string) *CreatePredictorInput {
	s.TrainingParameters = v
	return s
}

type CreatePredictorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the predictor.
	PredictorArn *string `type:"string"`
}

// String returns the string representation
func (s CreatePredictorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePredictorOutput) GoString() string {
	return s.String()
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *CreatePredictorOutput) SetPredictorArn(v string) *CreatePredictorOutput {
	s.PredictorArn = &v
	return s
}

// The destination for an exported forecast, an AWS Identity and Access Management
// (IAM) role that allows Amazon Forecast to access the location and, optionally,
// an AWS Key Management Service (KMS) key. This object is submitted in the
// CreateForecastExportJob request.
type DataDestination struct {
	_ struct{} `type:"structure"`

	// The path to an Amazon Simple Storage Service (Amazon S3) bucket along with
	// the credentials to access the bucket.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`
}

// String returns the string representation
func (s DataDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataDestination"}
	if s.S3Config == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Config sets the S3Config field's value.
func (s *DataDestination) SetS3Config(v *S3Config) *DataDestination {
	s.S3Config = v
	return s
}

// The source of your training data, an AWS Identity and Access Management (IAM)
// role that allows Amazon Forecast to access the data and, optionally, an AWS
// Key Management Service (KMS) key. This object is submitted in the CreateDatasetImportJob
// request.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The path to the training data stored in an Amazon Simple Storage Service
	// (Amazon S3) bucket along with the credentials to access the data.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSource"}
	if s.S3Config == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Config sets the S3Config field's value.
func (s *DataSource) SetS3Config(v *S3Config) *DataSource {
	s.S3Config = v
	return s
}

// Provides a summary of the dataset group properties used in the ListDatasetGroups
// operation. To get the complete set of properties, call the DescribeDatasetGroup
// operation, and provide the DatasetGroupArn.
type DatasetGroupSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset group was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `type:"string"`

	// The name of the dataset group.
	DatasetGroupName *string `min:"1" type:"string"`

	// When the dataset group was created or last updated from a call to the UpdateDatasetGroup
	// operation. While the dataset group is being updated, LastModificationTime
	// is the current time of the ListDatasetGroups call.
	LastModificationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DatasetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetGroupSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetGroupSummary) SetCreationTime(v time.Time) *DatasetGroupSummary {
	s.CreationTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DatasetGroupSummary) SetDatasetGroupArn(v string) *DatasetGroupSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetGroupName sets the DatasetGroupName field's value.
func (s *DatasetGroupSummary) SetDatasetGroupName(v string) *DatasetGroupSummary {
	s.DatasetGroupName = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DatasetGroupSummary) SetLastModificationTime(v time.Time) *DatasetGroupSummary {
	s.LastModificationTime = &v
	return s
}

// Provides a summary of the dataset import job properties used in the ListDatasetImportJobs
// operation. To get the complete set of properties, call the DescribeDatasetImportJob
// operation, and provide the DatasetImportJobArn.
type DatasetImportJobSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset import job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The location of the training data to import and an AWS Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the data.
	// The training data must be stored in an Amazon S3 bucket.
	//
	// If encryption is used, DataSource includes an AWS Key Management Service
	// (KMS) key.
	DataSource *DataSource `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `type:"string"`

	// The name of the dataset import job.
	DatasetImportJobName *string `min:"1" type:"string"`

	// The last time that the dataset was modified. The time depends on the status
	// of the job, as follows:
	//
	//    * CREATE_PENDING - The same time as CreationTime.
	//
	//    * CREATE_IN_PROGRESS - The current timestamp.
	//
	//    * ACTIVE or CREATE_FAILED - When the job finished or failed.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the dataset import job. The status is reflected in the status
	// of the dataset. For example, when the import job status is CREATE_IN_PROGRESS,
	// the status of the dataset is UPDATE_IN_PROGRESS. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	Status *string `type:"string"`
}

// String returns the string representation
func (s DatasetImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetImportJobSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetImportJobSummary) SetCreationTime(v time.Time) *DatasetImportJobSummary {
	s.CreationTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DatasetImportJobSummary) SetDataSource(v *DataSource) *DatasetImportJobSummary {
	s.DataSource = v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DatasetImportJobSummary) SetDatasetImportJobArn(v string) *DatasetImportJobSummary {
	s.DatasetImportJobArn = &v
	return s
}

// SetDatasetImportJobName sets the DatasetImportJobName field's value.
func (s *DatasetImportJobSummary) SetDatasetImportJobName(v string) *DatasetImportJobSummary {
	s.DatasetImportJobName = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DatasetImportJobSummary) SetLastModificationTime(v time.Time) *DatasetImportJobSummary {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DatasetImportJobSummary) SetMessage(v string) *DatasetImportJobSummary {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetImportJobSummary) SetStatus(v string) *DatasetImportJobSummary {
	s.Status = &v
	return s
}

// Provides a summary of the dataset properties used in the ListDatasets operation.
// To get the complete set of properties, call the DescribeDataset operation,
// and provide the DatasetArn.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `type:"string"`

	// The name of the dataset.
	DatasetName *string `min:"1" type:"string"`

	// The dataset type.
	DatasetType *string `type:"string" enum:"DatasetType"`

	// The domain associated with the dataset.
	Domain *string `type:"string" enum:"Domain"`

	// When you create a dataset, LastModificationTime is the same as CreationTime.
	// While data is being imported to the dataset, LastModificationTime is the
	// current time of the ListDatasets call. After a CreateDatasetImportJob operation
	// has finished, LastModificationTime is when the import job completed or failed.
	LastModificationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetSummary) SetCreationTime(v time.Time) *DatasetSummary {
	s.CreationTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetSummary) SetDatasetArn(v string) *DatasetSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DatasetSummary) SetDatasetName(v string) *DatasetSummary {
	s.DatasetName = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetSummary) SetDatasetType(v string) *DatasetSummary {
	s.DatasetType = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DatasetSummary) SetDomain(v string) *DatasetSummary {
	s.Domain = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DatasetSummary) SetLastModificationTime(v time.Time) *DatasetSummary {
	s.LastModificationTime = &v
	return s
}

type DeleteDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to delete.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DeleteDatasetGroupInput) SetDatasetGroupArn(v string) *DeleteDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DeleteDatasetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetGroupOutput) GoString() string {
	return s.String()
}

type DeleteDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job to delete.
	//
	// DatasetImportJobArn is a required field
	DatasetImportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetImportJobInput"}
	if s.DatasetImportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetImportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DeleteDatasetImportJobInput) SetDatasetImportJobArn(v string) *DeleteDatasetImportJobInput {
	s.DatasetImportJobArn = &v
	return s
}

type DeleteDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetImportJobOutput) GoString() string {
	return s.String()
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to delete.
	//
	// DatasetArn is a required field
	DatasetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DeleteDatasetInput) SetDatasetArn(v string) *DeleteDatasetInput {
	s.DatasetArn = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job to delete.
	//
	// ForecastExportJobArn is a required field
	ForecastExportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteForecastExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteForecastExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteForecastExportJobInput"}
	if s.ForecastExportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastExportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecastExportJobArn sets the ForecastExportJobArn field's value.
func (s *DeleteForecastExportJobInput) SetForecastExportJobArn(v string) *DeleteForecastExportJobInput {
	s.ForecastExportJobArn = &v
	return s
}

type DeleteForecastExportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteForecastExportJobOutput) GoString() string {
	return s.String()
}

type DeleteForecastInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast to delete.
	//
	// ForecastArn is a required field
	ForecastArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteForecastInput"}
	if s.ForecastArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecastArn sets the ForecastArn field's value.
func (s *DeleteForecastInput) SetForecastArn(v string) *DeleteForecastInput {
	s.ForecastArn = &v
	return s
}

type DeleteForecastOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteForecastOutput) GoString() string {
	return s.String()
}

type DeletePredictorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the predictor to delete.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePredictorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePredictorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePredictorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePredictorInput"}
	if s.PredictorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *DeletePredictorInput) SetPredictorArn(v string) *DeletePredictorInput {
	s.PredictorArn = &v
	return s
}

type DeletePredictorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePredictorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePredictorOutput) GoString() string {
	return s.String()
}

type DescribeDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DescribeDatasetGroupInput) SetDatasetGroupArn(v string) *DescribeDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DescribeDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// When the dataset group was created.
	CreationTime *time.Time `type:"timestamp"`

	// An array of Amazon Resource Names (ARNs) of the datasets contained in the
	// dataset group.
	DatasetArns []*string `type:"list"`

	// The ARN of the dataset group.
	DatasetGroupArn *string `type:"string"`

	// The name of the dataset group.
	DatasetGroupName *string `min:"1" type:"string"`

	// The domain associated with the dataset group.
	Domain *string `type:"string" enum:"Domain"`

	// When the dataset group was created or last updated from a call to the UpdateDatasetGroup
	// operation. While the dataset group is being updated, LastModificationTime
	// is the current time of the DescribeDatasetGroup call.
	LastModificationTime *time.Time `type:"timestamp"`

	// The status of the dataset group. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The UPDATE states apply when you call the UpdateDatasetGroup operation.
	//
	// The Status of the dataset group must be ACTIVE before you can use the dataset
	// group to create a predictor.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeDatasetGroupOutput) SetCreationTime(v time.Time) *DescribeDatasetGroupOutput {
	s.CreationTime = &v
	return s
}

// SetDatasetArns sets the DatasetArns field's value.
func (s *DescribeDatasetGroupOutput) SetDatasetArns(v []*string) *DescribeDatasetGroupOutput {
	s.DatasetArns = v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DescribeDatasetGroupOutput) SetDatasetGroupArn(v string) *DescribeDatasetGroupOutput {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetGroupName sets the DatasetGroupName field's value.
func (s *DescribeDatasetGroupOutput) SetDatasetGroupName(v string) *DescribeDatasetGroupOutput {
	s.DatasetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeDatasetGroupOutput) SetDomain(v string) *DescribeDatasetGroupOutput {
	s.Domain = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeDatasetGroupOutput) SetLastModificationTime(v time.Time) *DescribeDatasetGroupOutput {
	s.LastModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDatasetGroupOutput) SetStatus(v string) *DescribeDatasetGroupOutput {
	s.Status = &v
	return s
}

type DescribeDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	//
	// DatasetImportJobArn is a required field
	DatasetImportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetImportJobInput"}
	if s.DatasetImportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetImportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DescribeDatasetImportJobInput) SetDatasetImportJobArn(v string) *DescribeDatasetImportJobInput {
	s.DatasetImportJobArn = &v
	return s
}

type DescribeDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the dataset import job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The size of the dataset in gigabytes (GB) after the import job has finished.
	DataSize *float64 `type:"double"`

	// The location of the training data to import and an AWS Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the data.
	//
	// If encryption is used, DataSource includes an AWS Key Management Service
	// (KMS) key.
	DataSource *DataSource `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that the training data was
	// imported to.
	DatasetArn *string `type:"string"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `type:"string"`

	// The name of the dataset import job.
	DatasetImportJobName *string `min:"1" type:"string"`

	// Statistical information about each field in the input data.
	FieldStatistics map[string]*Statistics `type:"map"`

	// The last time that the dataset was modified. The time depends on the status
	// of the job, as follows:
	//
	//    * CREATE_PENDING - The same time as CreationTime.
	//
	//    * CREATE_IN_PROGRESS - The current timestamp.
	//
	//    * ACTIVE or CREATE_FAILED - When the job finished or failed.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the dataset import job. The status is reflected in the status
	// of the dataset. For example, when the import job status is CREATE_IN_PROGRESS,
	// the status of the dataset is UPDATE_IN_PROGRESS. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	Status *string `type:"string"`

	// The format of timestamps in the dataset. The format that you specify depends
	// on the DataFrequency specified when the dataset was created. The following
	// formats are supported
	//
	//    * "yyyy-MM-dd" For the following data frequencies: Y, M, W, and D
	//
	//    * "yyyy-MM-dd HH:mm:ss" For the following data frequencies: H, 30min,
	//    15min, and 1min; and optionally, for: Y, M, W, and D
	TimestampFormat *string `type:"string"`
}

// String returns the string representation
func (s DescribeDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeDatasetImportJobOutput) SetCreationTime(v time.Time) *DescribeDatasetImportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDataSize sets the DataSize field's value.
func (s *DescribeDatasetImportJobOutput) SetDataSize(v float64) *DescribeDatasetImportJobOutput {
	s.DataSize = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeDatasetImportJobOutput) SetDataSource(v *DataSource) *DescribeDatasetImportJobOutput {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetImportJobOutput) SetDatasetArn(v string) *DescribeDatasetImportJobOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DescribeDatasetImportJobOutput) SetDatasetImportJobArn(v string) *DescribeDatasetImportJobOutput {
	s.DatasetImportJobArn = &v
	return s
}

// SetDatasetImportJobName sets the DatasetImportJobName field's value.
func (s *DescribeDatasetImportJobOutput) SetDatasetImportJobName(v string) *DescribeDatasetImportJobOutput {
	s.DatasetImportJobName = &v
	return s
}

// SetFieldStatistics sets the FieldStatistics field's value.
func (s *DescribeDatasetImportJobOutput) SetFieldStatistics(v map[string]*Statistics) *DescribeDatasetImportJobOutput {
	s.FieldStatistics = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeDatasetImportJobOutput) SetLastModificationTime(v time.Time) *DescribeDatasetImportJobOutput {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeDatasetImportJobOutput) SetMessage(v string) *DescribeDatasetImportJobOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDatasetImportJobOutput) SetStatus(v string) *DescribeDatasetImportJobOutput {
	s.Status = &v
	return s
}

// SetTimestampFormat sets the TimestampFormat field's value.
func (s *DescribeDatasetImportJobOutput) SetTimestampFormat(v string) *DescribeDatasetImportJobOutput {
	s.TimestampFormat = &v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	//
	// DatasetArn is a required field
	DatasetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetInput) SetDatasetArn(v string) *DescribeDatasetInput {
	s.DatasetArn = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// When the dataset was created.
	CreationTime *time.Time `type:"timestamp"`

	// The frequency of data collection.
	//
	// Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min
	// (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and
	// 1min (1 minute). For example, "M" indicates every month and "30min" indicates
	// every 30 minutes.
	DataFrequency *string `type:"string"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `type:"string"`

	// The name of the dataset.
	DatasetName *string `min:"1" type:"string"`

	// The dataset type.
	DatasetType *string `type:"string" enum:"DatasetType"`

	// The domain associated with the dataset.
	Domain *string `type:"string" enum:"Domain"`

	// The AWS Key Management Service (KMS) key and the AWS Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// When you create a dataset, LastModificationTime is the same as CreationTime.
	// While data is being imported to the dataset, LastModificationTime is the
	// current time of the DescribeDataset call. After a CreateDatasetImportJob
	// operation has finished, LastModificationTime is when the import job completed
	// or failed.
	LastModificationTime *time.Time `type:"timestamp"`

	// An array of SchemaAttribute objects that specify the dataset fields. Each
	// SchemaAttribute specifies the name and data type of a field.
	Schema *Schema `type:"structure"`

	// The status of the dataset. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The UPDATE states apply while data is imported to the dataset from a call
	// to the CreateDatasetImportJob operation and reflect the status of the dataset
	// import job. For example, when the import job status is CREATE_IN_PROGRESS,
	// the status of the dataset is UPDATE_IN_PROGRESS.
	//
	// The Status of the dataset must be ACTIVE before you can import training data.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeDatasetOutput) SetCreationTime(v time.Time) *DescribeDatasetOutput {
	s.CreationTime = &v
	return s
}

// SetDataFrequency sets the DataFrequency field's value.
func (s *DescribeDatasetOutput) SetDataFrequency(v string) *DescribeDatasetOutput {
	s.DataFrequency = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetOutput) SetDatasetArn(v string) *DescribeDatasetOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeDatasetOutput) SetDatasetName(v string) *DescribeDatasetOutput {
	s.DatasetName = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DescribeDatasetOutput) SetDatasetType(v string) *DescribeDatasetOutput {
	s.DatasetType = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeDatasetOutput) SetDomain(v string) *DescribeDatasetOutput {
	s.Domain = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *DescribeDatasetOutput) SetEncryptionConfig(v *EncryptionConfig) *DescribeDatasetOutput {
	s.EncryptionConfig = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeDatasetOutput) SetLastModificationTime(v time.Time) *DescribeDatasetOutput {
	s.LastModificationTime = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeDatasetOutput) SetSchema(v *Schema) *DescribeDatasetOutput {
	s.Schema = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDatasetOutput) SetStatus(v string) *DescribeDatasetOutput {
	s.Status = &v
	return s
}

type DescribeForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job.
	//
	// ForecastExportJobArn is a required field
	ForecastExportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeForecastExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeForecastExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeForecastExportJobInput"}
	if s.ForecastExportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastExportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecastExportJobArn sets the ForecastExportJobArn field's value.
func (s *DescribeForecastExportJobInput) SetForecastExportJobArn(v string) *DescribeForecastExportJobInput {
	s.ForecastExportJobArn = &v
	return s
}

type DescribeForecastExportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the forecast export job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The path to the Amazon Simple Storage Service (Amazon S3) bucket where the
	// forecast is exported.
	Destination *DataDestination `type:"structure"`

	// The Amazon Resource Name (ARN) of the exported forecast.
	ForecastArn *string `type:"string"`

	// The ARN of the forecast export job.
	ForecastExportJobArn *string `type:"string"`

	// The name of the forecast export job.
	ForecastExportJobName *string `min:"1" type:"string"`

	// When the last successful export job finished.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the forecast export job. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast export job must be ACTIVE before you can access
	// the forecast in your S3 bucket.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeForecastExportJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeForecastExportJobOutput) SetCreationTime(v time.Time) *DescribeForecastExportJobOutput {
	s.CreationTime = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *DescribeForecastExportJobOutput) SetDestination(v *DataDestination) *DescribeForecastExportJobOutput {
	s.Destination = v
	return s
}

// SetForecastArn sets the ForecastArn field's value.
func (s *DescribeForecastExportJobOutput) SetForecastArn(v string) *DescribeForecastExportJobOutput {
	s.ForecastArn = &v
	return s
}

// SetForecastExportJobArn sets the ForecastExportJobArn field's value.
func (s *DescribeForecastExportJobOutput) SetForecastExportJobArn(v string) *DescribeForecastExportJobOutput {
	s.ForecastExportJobArn = &v
	return s
}

// SetForecastExportJobName sets the ForecastExportJobName field's value.
func (s *DescribeForecastExportJobOutput) SetForecastExportJobName(v string) *DescribeForecastExportJobOutput {
	s.ForecastExportJobName = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeForecastExportJobOutput) SetLastModificationTime(v time.Time) *DescribeForecastExportJobOutput {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeForecastExportJobOutput) SetMessage(v string) *DescribeForecastExportJobOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeForecastExportJobOutput) SetStatus(v string) *DescribeForecastExportJobOutput {
	s.Status = &v
	return s
}

type DescribeForecastInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast.
	//
	// ForecastArn is a required field
	ForecastArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeForecastInput"}
	if s.ForecastArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecastArn sets the ForecastArn field's value.
func (s *DescribeForecastInput) SetForecastArn(v string) *DescribeForecastInput {
	s.ForecastArn = &v
	return s
}

type DescribeForecastOutput struct {
	_ struct{} `type:"structure"`

	// When the forecast creation task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The ARN of the dataset group that provided the data used to train the predictor.
	DatasetGroupArn *string `type:"string"`

	// The forecast ARN as specified in the request.
	ForecastArn *string `type:"string"`

	// The name of the forecast.
	ForecastName *string `min:"1" type:"string"`

	// The quantiles at which proababilistic forecasts were generated.
	ForecastTypes []*string `min:"1" type:"list"`

	// Initially, the same as CreationTime (status is CREATE_PENDING). Updated when
	// inference (creating the forecast) starts (status changed to CREATE_IN_PROGRESS),
	// and when inference is complete (status changed to ACTIVE) or fails (status
	// changed to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The ARN of the predictor used to generate the forecast.
	PredictorArn *string `type:"string"`

	// The status of the forecast. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast must be ACTIVE before you can query or export
	// the forecast.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeForecastOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeForecastOutput) SetCreationTime(v time.Time) *DescribeForecastOutput {
	s.CreationTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DescribeForecastOutput) SetDatasetGroupArn(v string) *DescribeForecastOutput {
	s.DatasetGroupArn = &v
	return s
}

// SetForecastArn sets the ForecastArn field's value.
func (s *DescribeForecastOutput) SetForecastArn(v string) *DescribeForecastOutput {
	s.ForecastArn = &v
	return s
}

// SetForecastName sets the ForecastName field's value.
func (s *DescribeForecastOutput) SetForecastName(v string) *DescribeForecastOutput {
	s.ForecastName = &v
	return s
}

// SetForecastTypes sets the ForecastTypes field's value.
func (s *DescribeForecastOutput) SetForecastTypes(v []*string) *DescribeForecastOutput {
	s.ForecastTypes = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribeForecastOutput) SetLastModificationTime(v time.Time) *DescribeForecastOutput {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeForecastOutput) SetMessage(v string) *DescribeForecastOutput {
	s.Message = &v
	return s
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *DescribeForecastOutput) SetPredictorArn(v string) *DescribeForecastOutput {
	s.PredictorArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeForecastOutput) SetStatus(v string) *DescribeForecastOutput {
	s.Status = &v
	return s
}

type DescribePredictorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the predictor that you want information
	// about.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePredictorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePredictorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePredictorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePredictorInput"}
	if s.PredictorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *DescribePredictorInput) SetPredictorArn(v string) *DescribePredictorInput {
	s.PredictorArn = &v
	return s
}

type DescribePredictorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm used for model training.
	AlgorithmArn *string `type:"string"`

	// When PerformAutoML is specified, the ARN of the chosen algorithm.
	AutoMLAlgorithmArns []*string `type:"list"`

	// When the model training task was created.
	CreationTime *time.Time `type:"timestamp"`

	// An array of the ARNs of the dataset import jobs used to import training data
	// for the predictor.
	DatasetImportJobArns []*string `type:"list"`

	// An AWS Key Management Service (KMS) key and the AWS Identity and Access Management
	// (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// Used to override the default evaluation parameters of the specified algorithm.
	// Amazon Forecast evaluates a predictor by splitting a dataset into training
	// data and testing data. The evaluation parameters define how to perform the
	// split and the number of iterations.
	EvaluationParameters *EvaluationParameters `type:"structure"`

	// The featurization configuration.
	FeaturizationConfig *FeaturizationConfig `type:"structure"`

	// The number of time-steps of the forecast. The forecast horizon is also called
	// the prediction length.
	ForecastHorizon *int64 `type:"integer"`

	// The hyperparameter override values for the algorithm.
	HPOConfig *HyperParameterTuningJobConfig `type:"structure"`

	// Describes the dataset group that contains the data to use to train the predictor.
	InputDataConfig *InputDataConfig `type:"structure"`

	// Initially, the same as CreationTime (when the status is CREATE_PENDING).
	// This value is updated when training starts (when the status changes to CREATE_IN_PROGRESS),
	// and when training has completed (when the status changes to ACTIVE) or fails
	// (when the status changes to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// Whether the predictor is set to perform AutoML.
	PerformAutoML *bool `type:"boolean"`

	// Whether the predictor is set to perform hyperparameter optimization (HPO).
	PerformHPO *bool `type:"boolean"`

	// The ARN of the predictor.
	PredictorArn *string `min:"1" type:"string"`

	// Details on the the status and results of the backtests performed to evaluate
	// the accuracy of the predictor. You specify the number of backtests to perform
	// when you call the operation.
	PredictorExecutionDetails *PredictorExecutionDetails `type:"structure"`

	// The name of the predictor.
	PredictorName *string `min:"1" type:"string"`

	// The status of the predictor. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The Status of the predictor must be ACTIVE before you can use the predictor
	// to create a forecast.
	Status *string `type:"string"`

	// The default training parameters or overrides selected during model training.
	// If using the AutoML algorithm or if HPO is turned on while using the DeepAR+
	// algorithms, the optimized values for the chosen hyperparameters are returned.
	// For more information, see aws-forecast-choosing-recipes.
	TrainingParameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s DescribePredictorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePredictorOutput) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *DescribePredictorOutput) SetAlgorithmArn(v string) *DescribePredictorOutput {
	s.AlgorithmArn = &v
	return s
}

// SetAutoMLAlgorithmArns sets the AutoMLAlgorithmArns field's value.
func (s *DescribePredictorOutput) SetAutoMLAlgorithmArns(v []*string) *DescribePredictorOutput {
	s.AutoMLAlgorithmArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribePredictorOutput) SetCreationTime(v time.Time) *DescribePredictorOutput {
	s.CreationTime = &v
	return s
}

// SetDatasetImportJobArns sets the DatasetImportJobArns field's value.
func (s *DescribePredictorOutput) SetDatasetImportJobArns(v []*string) *DescribePredictorOutput {
	s.DatasetImportJobArns = v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *DescribePredictorOutput) SetEncryptionConfig(v *EncryptionConfig) *DescribePredictorOutput {
	s.EncryptionConfig = v
	return s
}

// SetEvaluationParameters sets the EvaluationParameters field's value.
func (s *DescribePredictorOutput) SetEvaluationParameters(v *EvaluationParameters) *DescribePredictorOutput {
	s.EvaluationParameters = v
	return s
}

// SetFeaturizationConfig sets the FeaturizationConfig field's value.
func (s *DescribePredictorOutput) SetFeaturizationConfig(v *FeaturizationConfig) *DescribePredictorOutput {
	s.FeaturizationConfig = v
	return s
}

// SetForecastHorizon sets the ForecastHorizon field's value.
func (s *DescribePredictorOutput) SetForecastHorizon(v int64) *DescribePredictorOutput {
	s.ForecastHorizon = &v
	return s
}

// SetHPOConfig sets the HPOConfig field's value.
func (s *DescribePredictorOutput) SetHPOConfig(v *HyperParameterTuningJobConfig) *DescribePredictorOutput {
	s.HPOConfig = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DescribePredictorOutput) SetInputDataConfig(v *InputDataConfig) *DescribePredictorOutput {
	s.InputDataConfig = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DescribePredictorOutput) SetLastModificationTime(v time.Time) *DescribePredictorOutput {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribePredictorOutput) SetMessage(v string) *DescribePredictorOutput {
	s.Message = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *DescribePredictorOutput) SetPerformAutoML(v bool) *DescribePredictorOutput {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *DescribePredictorOutput) SetPerformHPO(v bool) *DescribePredictorOutput {
	s.PerformHPO = &v
	return s
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *DescribePredictorOutput) SetPredictorArn(v string) *DescribePredictorOutput {
	s.PredictorArn = &v
	return s
}

// SetPredictorExecutionDetails sets the PredictorExecutionDetails field's value.
func (s *DescribePredictorOutput) SetPredictorExecutionDetails(v *PredictorExecutionDetails) *DescribePredictorOutput {
	s.PredictorExecutionDetails = v
	return s
}

// SetPredictorName sets the PredictorName field's value.
func (s *DescribePredictorOutput) SetPredictorName(v string) *DescribePredictorOutput {
	s.PredictorName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribePredictorOutput) SetStatus(v string) *DescribePredictorOutput {
	s.Status = &v
	return s
}

// SetTrainingParameters sets the TrainingParameters field's value.
func (s *DescribePredictorOutput) SetTrainingParameters(v map[string]*string) *DescribePredictorOutput {
	s.TrainingParameters = v
	return s
}

// An AWS Key Management Service (KMS) key and an AWS Identity and Access Management
// (IAM) role that Amazon Forecast can assume to access the key. You can specify
// this optional object in the CreateDataset and CreatePredictor requests.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key.
	//
	// KMSKeyArn is a required field
	KMSKeyArn *string `type:"string" required:"true"`

	// The ARN of the IAM role that Amazon Forecast can assume to access the AWS
	// KMS key.
	//
	// Passing a role across AWS accounts is not allowed. If you pass a role that
	// isn't in your account, you get an InvalidInputException error.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfig"}
	if s.KMSKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KMSKeyArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *EncryptionConfig) SetKMSKeyArn(v string) *EncryptionConfig {
	s.KMSKeyArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EncryptionConfig) SetRoleArn(v string) *EncryptionConfig {
	s.RoleArn = &v
	return s
}

// Parameters that define how to split a dataset into training data and testing
// data, and the number of iterations to perform. These parameters are specified
// in the predefined algorithms but you can override them in the CreatePredictor
// request.
type EvaluationParameters struct {
	_ struct{} `type:"structure"`

	// The point from the end of the dataset where you want to split the data for
	// model training and testing (evaluation). Specify the value as the number
	// of data points. The default is the value of the forecast horizon. BackTestWindowOffset
	// can be used to mimic a past virtual forecast start date. This value must
	// be greater than or equal to the forecast horizon and less than half of the
	// TARGET_TIME_SERIES dataset length.
	//
	// ForecastHorizon <= BackTestWindowOffset < 1/2 * TARGET_TIME_SERIES dataset
	// length
	BackTestWindowOffset *int64 `type:"integer"`

	// The number of times to split the input data. The default is 1. Valid values
	// are 1 through 5.
	NumberOfBacktestWindows *int64 `type:"integer"`
}

// String returns the string representation
func (s EvaluationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationParameters) GoString() string {
	return s.String()
}

// SetBackTestWindowOffset sets the BackTestWindowOffset field's value.
func (s *EvaluationParameters) SetBackTestWindowOffset(v int64) *EvaluationParameters {
	s.BackTestWindowOffset = &v
	return s
}

// SetNumberOfBacktestWindows sets the NumberOfBacktestWindows field's value.
func (s *EvaluationParameters) SetNumberOfBacktestWindows(v int64) *EvaluationParameters {
	s.NumberOfBacktestWindows = &v
	return s
}

// The results of evaluating an algorithm. Returned as part of the GetAccuracyMetrics
// response.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm that was evaluated.
	AlgorithmArn *string `type:"string"`

	// The array of test windows used for evaluating the algorithm. The NumberOfBacktestWindows
	// from the EvaluationParameters object determines the number of windows in
	// the array.
	TestWindows []*WindowSummary `type:"list"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *EvaluationResult) SetAlgorithmArn(v string) *EvaluationResult {
	s.AlgorithmArn = &v
	return s
}

// SetTestWindows sets the TestWindows field's value.
func (s *EvaluationResult) SetTestWindows(v []*WindowSummary) *EvaluationResult {
	s.TestWindows = v
	return s
}

// Provides featurization (transformation) information for a dataset field.
// This object is part of the FeaturizationConfig object.
//
// For example:
//
// {
//
// "AttributeName": "demand",
//
// FeaturizationPipeline [ {
//
// "FeaturizationMethodName": "filling",
//
// "FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}
//
// } ]
//
// }
type Featurization struct {
	_ struct{} `type:"structure"`

	// The name of the schema attribute that specifies the data field to be featurized.
	// Only the target field of the TARGET_TIME_SERIES dataset type is supported.
	// For example, for the RETAIL domain, the target is demand, and for the CUSTOM
	// domain, the target is target_value.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// An array of one FeaturizationMethod object that specifies the feature transformation
	// method.
	FeaturizationPipeline []*FeaturizationMethod `min:"1" type:"list"`
}

// String returns the string representation
func (s Featurization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Featurization) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Featurization) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Featurization"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.FeaturizationPipeline != nil && len(s.FeaturizationPipeline) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeaturizationPipeline", 1))
	}
	if s.FeaturizationPipeline != nil {
		for i, v := range s.FeaturizationPipeline {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FeaturizationPipeline", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *Featurization) SetAttributeName(v string) *Featurization {
	s.AttributeName = &v
	return s
}

// SetFeaturizationPipeline sets the FeaturizationPipeline field's value.
func (s *Featurization) SetFeaturizationPipeline(v []*FeaturizationMethod) *Featurization {
	s.FeaturizationPipeline = v
	return s
}

// In a CreatePredictor operation, the specified algorithm trains a model using
// the specified dataset group. You can optionally tell the operation to modify
// data fields prior to training a model. These modifications are referred to
// as featurization.
//
// You define featurization using the FeaturizationConfig object. You specify
// an array of transformations, one for each field that you want to featurize.
// You then include the FeaturizationConfig object in your CreatePredictor request.
// Amazon Forecast applies the featurization to the TARGET_TIME_SERIES dataset
// before model training.
//
// You can create multiple featurization configurations. For example, you might
// call the CreatePredictor operation twice by specifying different featurization
// configurations.
type FeaturizationConfig struct {
	_ struct{} `type:"structure"`

	// An array of featurization (transformation) information for the fields of
	// a dataset. Only a single featurization is supported.
	Featurizations []*Featurization `min:"1" type:"list"`

	// An array of dimension (field) names that specify how to group the generated
	// forecast.
	//
	// For example, suppose that you are generating a forecast for item sales across
	// all of your stores, and your dataset contains a store_id field. If you want
	// the sales forecast for each item by store, you would specify store_id as
	// the dimension.
	//
	// All forecast dimensions specified in the TARGET_TIME_SERIES dataset don't
	// need to be specified in the CreatePredictor request. All forecast dimensions
	// specified in the RELATED_TIME_SERIES dataset must be specified in the CreatePredictor
	// request.
	ForecastDimensions []*string `min:"1" type:"list"`

	// The frequency of predictions in a forecast.
	//
	// Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min
	// (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and
	// 1min (1 minute). For example, "Y" indicates every year and "5min" indicates
	// every five minutes.
	//
	// The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset
	// frequency.
	//
	// When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal
	// to the RELATED_TIME_SERIES dataset frequency.
	//
	// ForecastFrequency is a required field
	ForecastFrequency *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FeaturizationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FeaturizationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeaturizationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FeaturizationConfig"}
	if s.Featurizations != nil && len(s.Featurizations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Featurizations", 1))
	}
	if s.ForecastDimensions != nil && len(s.ForecastDimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForecastDimensions", 1))
	}
	if s.ForecastFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastFrequency"))
	}
	if s.Featurizations != nil {
		for i, v := range s.Featurizations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Featurizations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeaturizations sets the Featurizations field's value.
func (s *FeaturizationConfig) SetFeaturizations(v []*Featurization) *FeaturizationConfig {
	s.Featurizations = v
	return s
}

// SetForecastDimensions sets the ForecastDimensions field's value.
func (s *FeaturizationConfig) SetForecastDimensions(v []*string) *FeaturizationConfig {
	s.ForecastDimensions = v
	return s
}

// SetForecastFrequency sets the ForecastFrequency field's value.
func (s *FeaturizationConfig) SetForecastFrequency(v string) *FeaturizationConfig {
	s.ForecastFrequency = &v
	return s
}

// Provides information about the method that featurizes (transforms) a dataset
// field. The method is part of the FeaturizationPipeline of the Featurization
// object. If you don't specify FeaturizationMethodParameters, Amazon Forecast
// uses default parameters.
//
// The following is an example of how you specify a FeaturizationMethod object.
//
// {
//
// "FeaturizationMethodName": "filling",
//
// "FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}
//
// }
type FeaturizationMethod struct {
	_ struct{} `type:"structure"`

	// The name of the method. The "filling" method is the only supported method.
	//
	// FeaturizationMethodName is a required field
	FeaturizationMethodName *string `type:"string" required:"true" enum:"FeaturizationMethodName"`

	// The method parameters (key-value pairs). Specify these parameters to override
	// the default values. The following list shows the parameters and their valid
	// values. Bold signifies the default value.
	//
	//    * aggregation: sum, avg, first, min, max
	//
	//    * frontfill: none
	//
	//    * middlefill: zero, nan (not a number)
	//
	//    * backfill: zero, nan
	FeaturizationMethodParameters map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s FeaturizationMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FeaturizationMethod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeaturizationMethod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FeaturizationMethod"}
	if s.FeaturizationMethodName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeaturizationMethodName"))
	}
	if s.FeaturizationMethodParameters != nil && len(s.FeaturizationMethodParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeaturizationMethodParameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeaturizationMethodName sets the FeaturizationMethodName field's value.
func (s *FeaturizationMethod) SetFeaturizationMethodName(v string) *FeaturizationMethod {
	s.FeaturizationMethodName = &v
	return s
}

// SetFeaturizationMethodParameters sets the FeaturizationMethodParameters field's value.
func (s *FeaturizationMethod) SetFeaturizationMethodParameters(v map[string]*string) *FeaturizationMethod {
	s.FeaturizationMethodParameters = v
	return s
}

// Describes a filter for choosing a subset of objects. Each filter consists
// of a condition and a match statement. The condition is either IS or IS_NOT,
// which specifies whether to include or exclude the objects that match the
// statement, respectively. The match statement consists of a key and a value.
type Filter struct {
	_ struct{} `type:"structure"`

	// The condition to apply. To include the objects that match the statement,
	// specify IS. To exclude matching objects, specify IS_NOT.
	//
	// Condition is a required field
	Condition *string `type:"string" required:"true" enum:"FilterConditionString"`

	// The name of the parameter to filter on.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value to match.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *Filter) SetCondition(v string) *Filter {
	s.Condition = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Filter) SetValue(v string) *Filter {
	s.Value = &v
	return s
}

// Provides a summary of the forecast export job properties used in the ListForecastExportJobs
// operation. To get the complete set of properties, call the DescribeForecastExportJob
// operation, and provide the listed ForecastExportJobArn.
type ForecastExportJobSummary struct {
	_ struct{} `type:"structure"`

	// When the forecast export job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The path to the Amazon Simple Storage Service (Amazon S3) bucket where the
	// forecast is exported.
	Destination *DataDestination `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job.
	ForecastExportJobArn *string `type:"string"`

	// The name of the forecast export job.
	ForecastExportJobName *string `min:"1" type:"string"`

	// When the last successful export job finished.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the forecast export job. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast export job must be ACTIVE before you can access
	// the forecast in your S3 bucket.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ForecastExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForecastExportJobSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ForecastExportJobSummary) SetCreationTime(v time.Time) *ForecastExportJobSummary {
	s.CreationTime = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *ForecastExportJobSummary) SetDestination(v *DataDestination) *ForecastExportJobSummary {
	s.Destination = v
	return s
}

// SetForecastExportJobArn sets the ForecastExportJobArn field's value.
func (s *ForecastExportJobSummary) SetForecastExportJobArn(v string) *ForecastExportJobSummary {
	s.ForecastExportJobArn = &v
	return s
}

// SetForecastExportJobName sets the ForecastExportJobName field's value.
func (s *ForecastExportJobSummary) SetForecastExportJobName(v string) *ForecastExportJobSummary {
	s.ForecastExportJobName = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *ForecastExportJobSummary) SetLastModificationTime(v time.Time) *ForecastExportJobSummary {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ForecastExportJobSummary) SetMessage(v string) *ForecastExportJobSummary {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ForecastExportJobSummary) SetStatus(v string) *ForecastExportJobSummary {
	s.Status = &v
	return s
}

// Provides a summary of the forecast properties used in the ListForecasts operation.
// To get the complete set of properties, call the DescribeForecast operation,
// and provide the ForecastArn that is listed in the summary.
type ForecastSummary struct {
	_ struct{} `type:"structure"`

	// When the forecast creation task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that provided the data
	// used to train the predictor.
	DatasetGroupArn *string `type:"string"`

	// The ARN of the forecast.
	ForecastArn *string `type:"string"`

	// The name of the forecast.
	ForecastName *string `min:"1" type:"string"`

	// Initially, the same as CreationTime (status is CREATE_PENDING). Updated when
	// inference (creating the forecast) starts (status changed to CREATE_IN_PROGRESS),
	// and when inference is complete (status changed to ACTIVE) or fails (status
	// changed to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The ARN of the predictor used to generate the forecast.
	PredictorArn *string `type:"string"`

	// The status of the forecast. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast must be ACTIVE before you can query or export
	// the forecast.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ForecastSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForecastSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ForecastSummary) SetCreationTime(v time.Time) *ForecastSummary {
	s.CreationTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ForecastSummary) SetDatasetGroupArn(v string) *ForecastSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetForecastArn sets the ForecastArn field's value.
func (s *ForecastSummary) SetForecastArn(v string) *ForecastSummary {
	s.ForecastArn = &v
	return s
}

// SetForecastName sets the ForecastName field's value.
func (s *ForecastSummary) SetForecastName(v string) *ForecastSummary {
	s.ForecastName = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *ForecastSummary) SetLastModificationTime(v time.Time) *ForecastSummary {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ForecastSummary) SetMessage(v string) *ForecastSummary {
	s.Message = &v
	return s
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *ForecastSummary) SetPredictorArn(v string) *ForecastSummary {
	s.PredictorArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ForecastSummary) SetStatus(v string) *ForecastSummary {
	s.Status = &v
	return s
}

type GetAccuracyMetricsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the predictor to get metrics for.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccuracyMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccuracyMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccuracyMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccuracyMetricsInput"}
	if s.PredictorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *GetAccuracyMetricsInput) SetPredictorArn(v string) *GetAccuracyMetricsInput {
	s.PredictorArn = &v
	return s
}

type GetAccuracyMetricsOutput struct {
	_ struct{} `type:"structure"`

	// An array of results from evaluating the predictor.
	PredictorEvaluationResults []*EvaluationResult `type:"list"`
}

// String returns the string representation
func (s GetAccuracyMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccuracyMetricsOutput) GoString() string {
	return s.String()
}

// SetPredictorEvaluationResults sets the PredictorEvaluationResults field's value.
func (s *GetAccuracyMetricsOutput) SetPredictorEvaluationResults(v []*EvaluationResult) *GetAccuracyMetricsOutput {
	s.PredictorEvaluationResults = v
	return s
}

// Configuration information for a hyperparameter tuning job. You specify this
// object in the CreatePredictor request.
//
// A hyperparameter is a parameter that governs the model training process.
// You set hyperparameters before training starts, unlike model parameters,
// which are determined during training. The values of the hyperparameters effect
// which values are chosen for the model parameters.
//
// In a hyperparameter tuning job, Amazon Forecast chooses the set of hyperparameter
// values that optimize a specified metric. Forecast accomplishes this by running
// many training jobs over a range of hyperparameter values. The optimum set
// of values depends on the algorithm, the training data, and the specified
// metric objective.
type HyperParameterTuningJobConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the ranges of valid values for the hyperparameters.
	ParameterRanges *ParameterRanges `type:"structure"`
}

// String returns the string representation
func (s HyperParameterTuningJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HyperParameterTuningJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HyperParameterTuningJobConfig"}
	if s.ParameterRanges != nil {
		if err := s.ParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("ParameterRanges", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterRanges sets the ParameterRanges field's value.
func (s *HyperParameterTuningJobConfig) SetParameterRanges(v *ParameterRanges) *HyperParameterTuningJobConfig {
	s.ParameterRanges = v
	return s
}

// The data used to train a predictor. The data includes a dataset group and
// any supplementary features. You specify this object in the CreatePredictor
// request.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`

	// An array of supplementary features. The only supported feature is a holiday
	// calendar.
	SupplementaryFeatures []*SupplementaryFeature `min:"1" type:"list"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.SupplementaryFeatures != nil && len(s.SupplementaryFeatures) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupplementaryFeatures", 1))
	}
	if s.SupplementaryFeatures != nil {
		for i, v := range s.SupplementaryFeatures {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupplementaryFeatures", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *InputDataConfig) SetDatasetGroupArn(v string) *InputDataConfig {
	s.DatasetGroupArn = &v
	return s
}

// SetSupplementaryFeatures sets the SupplementaryFeatures field's value.
func (s *InputDataConfig) SetSupplementaryFeatures(v []*SupplementaryFeature) *InputDataConfig {
	s.SupplementaryFeatures = v
	return s
}

// Specifies an integer hyperparameter and it's range of tunable values. This
// object is part of the ParameterRanges object.
type IntegerParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum tunable value of the hyperparameter.
	//
	// MaxValue is a required field
	MaxValue *int64 `type:"integer" required:"true"`

	// The minimum tunable value of the hyperparameter.
	//
	// MinValue is a required field
	MinValue *int64 `type:"integer" required:"true"`

	// The name of the hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// Valid values:
	//
	// Auto
	//
	// Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have values greater than 0.
	//
	// ReverseLogarithmic
	//
	// Not supported for IntegerParameterRange.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0 <= x < 1.0.
	//
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	ScalingType *string `type:"string" enum:"ScalingType"`
}

// String returns the string representation
func (s IntegerParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntegerParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntegerParameterRange"}
	if s.MaxValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxValue"))
	}
	if s.MinValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MinValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *IntegerParameterRange) SetMaxValue(v int64) *IntegerParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *IntegerParameterRange) SetMinValue(v int64) *IntegerParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *IntegerParameterRange) SetName(v string) *IntegerParameterRange {
	s.Name = &v
	return s
}

// SetScalingType sets the ScalingType field's value.
func (s *IntegerParameterRange) SetScalingType(v string) *IntegerParameterRange {
	s.ScalingType = &v
	return s
}

// We can't process the request because it includes an invalid value or a value
// that exceeds the valid range.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The token is not valid. Tokens expire after 24 hours.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The limit on the number of resources per account has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDatasetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetGroupsInput) SetMaxResults(v int64) *ListDatasetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsInput) SetNextToken(v string) *ListDatasetGroupsInput {
	s.NextToken = &v
	return s
}

type ListDatasetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each dataset group's properties.
	DatasetGroups []*DatasetGroupSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetGroupsOutput) GoString() string {
	return s.String()
}

// SetDatasetGroups sets the DatasetGroups field's value.
func (s *ListDatasetGroupsOutput) SetDatasetGroups(v []*DatasetGroupSummary) *ListDatasetGroupsOutput {
	s.DatasetGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsOutput) SetNextToken(v string) *ListDatasetGroupsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the datasets that match the statement from the list,
	// respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the datasets that match the statement, specify IS. To exclude
	//    matching datasets, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are DatasetArn
	//    and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all dataset import jobs whose status is ACTIVE, you
	// specify the following filter:
	//
	// "Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]
	Filters []*Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetImportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListDatasetImportJobsInput) SetFilters(v []*Filter) *ListDatasetImportJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetImportJobsInput) SetMaxResults(v int64) *ListDatasetImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsInput) SetNextToken(v string) *ListDatasetImportJobsInput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each dataset import job's properties.
	DatasetImportJobs []*DatasetImportJobSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetImportJobsOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobs sets the DatasetImportJobs field's value.
func (s *ListDatasetImportJobsOutput) SetDatasetImportJobs(v []*DatasetImportJobSummary) *ListDatasetImportJobsOutput {
	s.DatasetImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsOutput) SetNextToken(v string) *ListDatasetImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each dataset's properties.
	Datasets []*DatasetSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *ListDatasetsOutput) SetDatasets(v []*DatasetSummary) *ListDatasetsOutput {
	s.Datasets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListForecastExportJobsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the forecast export jobs that match the statement from
	// the list, respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the forecast export jobs that match the statement, specify
	//    IS. To exclude matching forecast export jobs, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are ForecastArn
	//    and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all jobs that export a forecast named electricityforecast,
	// specify the following filter:
	//
	// "Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityforecast"
	// } ]
	Filters []*Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForecastExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListForecastExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListForecastExportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListForecastExportJobsInput) SetFilters(v []*Filter) *ListForecastExportJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListForecastExportJobsInput) SetMaxResults(v int64) *ListForecastExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListForecastExportJobsInput) SetNextToken(v string) *ListForecastExportJobsInput {
	s.NextToken = &v
	return s
}

type ListForecastExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each export job's properties.
	ForecastExportJobs []*ForecastExportJobSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForecastExportJobsOutput) GoString() string {
	return s.String()
}

// SetForecastExportJobs sets the ForecastExportJobs field's value.
func (s *ListForecastExportJobsOutput) SetForecastExportJobs(v []*ForecastExportJobSummary) *ListForecastExportJobsOutput {
	s.ForecastExportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListForecastExportJobsOutput) SetNextToken(v string) *ListForecastExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListForecastsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the forecasts that match the statement from the list,
	// respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the forecasts that match the statement, specify IS. To exclude
	//    matching forecasts, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are DatasetGroupArn,
	//    PredictorArn, and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all forecasts whose status is not ACTIVE, you would
	// specify:
	//
	// "Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE"
	// } ]
	Filters []*Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForecastsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListForecastsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListForecastsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListForecastsInput) SetFilters(v []*Filter) *ListForecastsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListForecastsInput) SetMaxResults(v int64) *ListForecastsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListForecastsInput) SetNextToken(v string) *ListForecastsInput {
	s.NextToken = &v
	return s
}

type ListForecastsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each forecast's properties.
	Forecasts []*ForecastSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForecastsOutput) GoString() string {
	return s.String()
}

// SetForecasts sets the Forecasts field's value.
func (s *ListForecastsOutput) SetForecasts(v []*ForecastSummary) *ListForecastsOutput {
	s.Forecasts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListForecastsOutput) SetNextToken(v string) *ListForecastsOutput {
	s.NextToken = &v
	return s
}

type ListPredictorsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the predictors that match the statement from the list,
	// respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the predictors that match the statement, specify IS. To exclude
	//    matching predictors, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are DatasetGroupArn
	//    and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all predictors whose status is ACTIVE, you would specify:
	//
	// "Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]
	Filters []*Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPredictorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPredictorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPredictorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPredictorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListPredictorsInput) SetFilters(v []*Filter) *ListPredictorsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPredictorsInput) SetMaxResults(v int64) *ListPredictorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPredictorsInput) SetNextToken(v string) *ListPredictorsInput {
	s.NextToken = &v
	return s
}

type ListPredictorsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`

	// An array of objects that summarize each predictor's properties.
	Predictors []*PredictorSummary `type:"list"`
}

// String returns the string representation
func (s ListPredictorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPredictorsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPredictorsOutput) SetNextToken(v string) *ListPredictorsOutput {
	s.NextToken = &v
	return s
}

// SetPredictors sets the Predictors field's value.
func (s *ListPredictorsOutput) SetPredictors(v []*PredictorSummary) *ListPredictorsOutput {
	s.Predictors = v
	return s
}

// Provides metrics that are used to evaluate the performance of a predictor.
// This object is part of the WindowSummary object.
type Metrics struct {
	_ struct{} `type:"structure"`

	// The root mean square error (RMSE).
	RMSE *float64 `type:"double"`

	// An array of weighted quantile losses. Quantiles divide a probability distribution
	// into regions of equal probability. The distribution in this case is the loss
	// function.
	WeightedQuantileLosses []*WeightedQuantileLoss `type:"list"`
}

// String returns the string representation
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metrics) GoString() string {
	return s.String()
}

// SetRMSE sets the RMSE field's value.
func (s *Metrics) SetRMSE(v float64) *Metrics {
	s.RMSE = &v
	return s
}

// SetWeightedQuantileLosses sets the WeightedQuantileLosses field's value.
func (s *Metrics) SetWeightedQuantileLosses(v []*WeightedQuantileLoss) *Metrics {
	s.WeightedQuantileLosses = v
	return s
}

// Specifies the categorical, continuous, and integer hyperparameters, and their
// ranges of tunable values. The range of tunable values determines which values
// that a hyperparameter tuning job can choose for the specified hyperparameter.
// This object is part of the HyperParameterTuningJobConfig object.
type ParameterRanges struct {
	_ struct{} `type:"structure"`

	// Specifies the tunable range for each categorical hyperparameter.
	CategoricalParameterRanges []*CategoricalParameterRange `min:"1" type:"list"`

	// Specifies the tunable range for each continuous hyperparameter.
	ContinuousParameterRanges []*ContinuousParameterRange `min:"1" type:"list"`

	// Specifies the tunable range for each integer hyperparameter.
	IntegerParameterRanges []*IntegerParameterRange `min:"1" type:"list"`
}

// String returns the string representation
func (s ParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterRanges) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRanges) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterRanges"}
	if s.CategoricalParameterRanges != nil && len(s.CategoricalParameterRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoricalParameterRanges", 1))
	}
	if s.ContinuousParameterRanges != nil && len(s.ContinuousParameterRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContinuousParameterRanges", 1))
	}
	if s.IntegerParameterRanges != nil && len(s.IntegerParameterRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegerParameterRanges", 1))
	}
	if s.CategoricalParameterRanges != nil {
		for i, v := range s.CategoricalParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategoricalParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ContinuousParameterRanges != nil {
		for i, v := range s.ContinuousParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameterRanges != nil {
		for i, v := range s.IntegerParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoricalParameterRanges sets the CategoricalParameterRanges field's value.
func (s *ParameterRanges) SetCategoricalParameterRanges(v []*CategoricalParameterRange) *ParameterRanges {
	s.CategoricalParameterRanges = v
	return s
}

// SetContinuousParameterRanges sets the ContinuousParameterRanges field's value.
func (s *ParameterRanges) SetContinuousParameterRanges(v []*ContinuousParameterRange) *ParameterRanges {
	s.ContinuousParameterRanges = v
	return s
}

// SetIntegerParameterRanges sets the IntegerParameterRanges field's value.
func (s *ParameterRanges) SetIntegerParameterRanges(v []*IntegerParameterRange) *ParameterRanges {
	s.IntegerParameterRanges = v
	return s
}

// The algorithm used to perform a backtest and the status of those tests.
type PredictorExecution struct {
	_ struct{} `type:"structure"`

	// The ARN of the algorithm used to test the predictor.
	AlgorithmArn *string `type:"string"`

	// An array of test windows used to evaluate the algorithm. The NumberOfBacktestWindows
	// from the object determines the number of windows in the array.
	TestWindows []*TestWindowSummary `type:"list"`
}

// String returns the string representation
func (s PredictorExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictorExecution) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *PredictorExecution) SetAlgorithmArn(v string) *PredictorExecution {
	s.AlgorithmArn = &v
	return s
}

// SetTestWindows sets the TestWindows field's value.
func (s *PredictorExecution) SetTestWindows(v []*TestWindowSummary) *PredictorExecution {
	s.TestWindows = v
	return s
}

// Contains details on the backtests performed to evaluate the accuracy of the
// predictor. The tests are returned in descending order of accuracy, with the
// most accurate backtest appearing first. You specify the number of backtests
// to perform when you call the operation.
type PredictorExecutionDetails struct {
	_ struct{} `type:"structure"`

	// An array of the backtests performed to evaluate the accuracy of the predictor
	// against a particular algorithm. The NumberOfBacktestWindows from the object
	// determines the number of windows in the array.
	PredictorExecutions []*PredictorExecution `min:"1" type:"list"`
}

// String returns the string representation
func (s PredictorExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictorExecutionDetails) GoString() string {
	return s.String()
}

// SetPredictorExecutions sets the PredictorExecutions field's value.
func (s *PredictorExecutionDetails) SetPredictorExecutions(v []*PredictorExecution) *PredictorExecutionDetails {
	s.PredictorExecutions = v
	return s
}

// Provides a summary of the predictor properties that are used in the ListPredictors
// operation. To get the complete set of properties, call the DescribePredictor
// operation, and provide the listed PredictorArn.
type PredictorSummary struct {
	_ struct{} `type:"structure"`

	// When the model training task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that contains the data
	// used to train the predictor.
	DatasetGroupArn *string `type:"string"`

	// Initially, the same as CreationTime (status is CREATE_PENDING). Updated when
	// training starts (status changed to CREATE_IN_PROGRESS), and when training
	// is complete (status changed to ACTIVE) or fails (status changed to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The ARN of the predictor.
	PredictorArn *string `type:"string"`

	// The name of the predictor.
	PredictorName *string `min:"1" type:"string"`

	// The status of the predictor. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The Status of the predictor must be ACTIVE before you can use the predictor
	// to create a forecast.
	Status *string `type:"string"`
}

// String returns the string representation
func (s PredictorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictorSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *PredictorSummary) SetCreationTime(v time.Time) *PredictorSummary {
	s.CreationTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *PredictorSummary) SetDatasetGroupArn(v string) *PredictorSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *PredictorSummary) SetLastModificationTime(v time.Time) *PredictorSummary {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PredictorSummary) SetMessage(v string) *PredictorSummary {
	s.Message = &v
	return s
}

// SetPredictorArn sets the PredictorArn field's value.
func (s *PredictorSummary) SetPredictorArn(v string) *PredictorSummary {
	s.PredictorArn = &v
	return s
}

// SetPredictorName sets the PredictorName field's value.
func (s *PredictorSummary) SetPredictorName(v string) *PredictorSummary {
	s.PredictorName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PredictorSummary) SetStatus(v string) *PredictorSummary {
	s.Status = &v
	return s
}

// There is already a resource with this name. Try again with a different name.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// We can't find a resource with that Amazon Resource Name (ARN). Check the
// ARN and try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket,
// and an AWS Identity and Access Management (IAM) role that Amazon Forecast
// can assume to access the file(s). Optionally, includes an AWS Key Management
// Service (KMS) key. This object is part of the DataSource object that is submitted
// in the CreateDatasetImportJob request, and part of the DataDestination object
// that is submitted in the CreateForecastExportJob request.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.
	KMSKeyArn *string `type:"string"`

	// The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s)
	// in an Amazon S3 bucket.
	//
	// Path is a required field
	Path *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that Amazon
	// Forecast can assume to access the Amazon S3 bucket or files. If you provide
	// a value for the KMSKeyArn key, the role must allow access to the key.
	//
	// Passing a role across AWS accounts is not allowed. If you pass a role that
	// isn't in your account, you get an InvalidInputException error.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *S3Config) SetKMSKeyArn(v string) *S3Config {
	s.KMSKeyArn = &v
	return s
}

// SetPath sets the Path field's value.
func (s *S3Config) SetPath(v string) *S3Config {
	s.Path = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Config) SetRoleArn(v string) *S3Config {
	s.RoleArn = &v
	return s
}

// Defines the fields of a dataset. You specify this object in the CreateDataset
// request.
type Schema struct {
	_ struct{} `type:"structure"`

	// An array of attributes specifying the name and type of each field in a dataset.
	Attributes []*SchemaAttribute `type:"list"`
}

// String returns the string representation
func (s Schema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schema"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *Schema) SetAttributes(v []*SchemaAttribute) *Schema {
	s.Attributes = v
	return s
}

// An attribute of a schema, which defines a dataset field. A schema attribute
// is required for every field in a dataset. The Schema object contains an array
// of SchemaAttribute objects.
type SchemaAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the dataset field.
	AttributeName *string `min:"1" type:"string"`

	// The data type of the field.
	AttributeType *string `type:"string" enum:"AttributeType"`
}

// String returns the string representation
func (s SchemaAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaAttribute"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *SchemaAttribute) SetAttributeName(v string) *SchemaAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *SchemaAttribute) SetAttributeType(v string) *SchemaAttribute {
	s.AttributeType = &v
	return s
}

// Provides statistics for each data field imported into to an Amazon Forecast
// dataset with the CreateDatasetImportJob operation.
type Statistics struct {
	_ struct{} `type:"structure"`

	// For a numeric field, the average value in the field.
	Avg *float64 `type:"double"`

	// The number of values in the field.
	Count *int64 `type:"integer"`

	// The number of distinct values in the field.
	CountDistinct *int64 `type:"integer"`

	// The number of NAN (not a number) values in the field.
	CountNan *int64 `type:"integer"`

	// The number of null values in the field.
	CountNull *int64 `type:"integer"`

	// For a numeric field, the maximum value in the field.
	Max *string `type:"string"`

	// For a numeric field, the minimum value in the field.
	Min *string `type:"string"`

	// For a numeric field, the standard deviation.
	Stddev *float64 `type:"double"`
}

// String returns the string representation
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statistics) GoString() string {
	return s.String()
}

// SetAvg sets the Avg field's value.
func (s *Statistics) SetAvg(v float64) *Statistics {
	s.Avg = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Statistics) SetCount(v int64) *Statistics {
	s.Count = &v
	return s
}

// SetCountDistinct sets the CountDistinct field's value.
func (s *Statistics) SetCountDistinct(v int64) *Statistics {
	s.CountDistinct = &v
	return s
}

// SetCountNan sets the CountNan field's value.
func (s *Statistics) SetCountNan(v int64) *Statistics {
	s.CountNan = &v
	return s
}

// SetCountNull sets the CountNull field's value.
func (s *Statistics) SetCountNull(v int64) *Statistics {
	s.CountNull = &v
	return s
}

// SetMax sets the Max field's value.
func (s *Statistics) SetMax(v string) *Statistics {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *Statistics) SetMin(v string) *Statistics {
	s.Min = &v
	return s
}

// SetStddev sets the Stddev field's value.
func (s *Statistics) SetStddev(v float64) *Statistics {
	s.Stddev = &v
	return s
}

// Describes a supplementary feature of a dataset group. This object is part
// of the InputDataConfig object.
//
// The only supported feature is a holiday calendar. If you use the calendar,
// all data in the datasets should belong to the same country as the calendar.
// For the holiday calendar data, see the Jollyday (http://jollyday.sourceforge.net/data.html)
// web site.
type SupplementaryFeature struct {
	_ struct{} `type:"structure"`

	// The name of the feature. This must be "holiday".
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One of the following 2 letter country codes:
	//
	//    * "AU" - AUSTRALIA
	//
	//    * "DE" - GERMANY
	//
	//    * "JP" - JAPAN
	//
	//    * "US" - UNITED_STATES
	//
	//    * "UK" - UNITED_KINGDOM
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SupplementaryFeature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupplementaryFeature) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SupplementaryFeature) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SupplementaryFeature"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SupplementaryFeature) SetName(v string) *SupplementaryFeature {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SupplementaryFeature) SetValue(v string) *SupplementaryFeature {
	s.Value = &v
	return s
}

// The status, start time, and end time of a backtest, as well as a failure
// reason if applicable.
type TestWindowSummary struct {
	_ struct{} `type:"structure"`

	// If the test failed, the reason why it failed.
	Message *string `type:"string"`

	// The status of the test. Possible status values are:
	//
	//    * ACTIVE
	//
	//    * CREATE_IN_PROGRESS
	//
	//    * CREATE_FAILED
	Status *string `type:"string"`

	// The time at which the test ended.
	TestWindowEnd *time.Time `type:"timestamp"`

	// The time at which the test began.
	TestWindowStart *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TestWindowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestWindowSummary) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TestWindowSummary) SetMessage(v string) *TestWindowSummary {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestWindowSummary) SetStatus(v string) *TestWindowSummary {
	s.Status = &v
	return s
}

// SetTestWindowEnd sets the TestWindowEnd field's value.
func (s *TestWindowSummary) SetTestWindowEnd(v time.Time) *TestWindowSummary {
	s.TestWindowEnd = &v
	return s
}

// SetTestWindowStart sets the TestWindowStart field's value.
func (s *TestWindowSummary) SetTestWindowStart(v time.Time) *TestWindowSummary {
	s.TestWindowStart = &v
	return s
}

type UpdateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// An array of the Amazon Resource Names (ARNs) of the datasets to add to the
	// dataset group.
	//
	// DatasetArns is a required field
	DatasetArns []*string `type:"list" required:"true"`

	// The ARN of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetGroupInput"}
	if s.DatasetArns == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArns"))
	}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArns sets the DatasetArns field's value.
func (s *UpdateDatasetGroupInput) SetDatasetArns(v []*string) *UpdateDatasetGroupInput {
	s.DatasetArns = v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *UpdateDatasetGroupInput) SetDatasetGroupArn(v string) *UpdateDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type UpdateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatasetGroupOutput) GoString() string {
	return s.String()
}

// The weighted loss value for a quantile. This object is part of the Metrics
// object.
type WeightedQuantileLoss struct {
	_ struct{} `type:"structure"`

	// The difference between the predicted value and the actual value over the
	// quantile, weighted (normalized) by dividing by the sum over all quantiles.
	LossValue *float64 `type:"double"`

	// The quantile. Quantiles divide a probability distribution into regions of
	// equal probability. For example, if the distribution was divided into 5 regions
	// of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.
	Quantile *float64 `type:"double"`
}

// String returns the string representation
func (s WeightedQuantileLoss) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeightedQuantileLoss) GoString() string {
	return s.String()
}

// SetLossValue sets the LossValue field's value.
func (s *WeightedQuantileLoss) SetLossValue(v float64) *WeightedQuantileLoss {
	s.LossValue = &v
	return s
}

// SetQuantile sets the Quantile field's value.
func (s *WeightedQuantileLoss) SetQuantile(v float64) *WeightedQuantileLoss {
	s.Quantile = &v
	return s
}

// The metrics for a time range within the evaluation portion of a dataset.
// This object is part of the EvaluationResult object.
//
// The TestWindowStart and TestWindowEnd parameters are determined by the BackTestWindowOffset
// parameter of the EvaluationParameters object.
type WindowSummary struct {
	_ struct{} `type:"structure"`

	// The type of evaluation.
	//
	//    * SUMMARY - The average metrics across all windows.
	//
	//    * COMPUTED - The metrics for the specified window.
	EvaluationType *string `type:"string" enum:"EvaluationType"`

	// The number of data points within the window.
	ItemCount *int64 `type:"integer"`

	// Provides metrics used to evaluate the performance of a predictor.
	Metrics *Metrics `type:"structure"`

	// The timestamp that defines the end of the window.
	TestWindowEnd *time.Time `type:"timestamp"`

	// The timestamp that defines the start of the window.
	TestWindowStart *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s WindowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WindowSummary) GoString() string {
	return s.String()
}

// SetEvaluationType sets the EvaluationType field's value.
func (s *WindowSummary) SetEvaluationType(v string) *WindowSummary {
	s.EvaluationType = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *WindowSummary) SetItemCount(v int64) *WindowSummary {
	s.ItemCount = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *WindowSummary) SetMetrics(v *Metrics) *WindowSummary {
	s.Metrics = v
	return s
}

// SetTestWindowEnd sets the TestWindowEnd field's value.
func (s *WindowSummary) SetTestWindowEnd(v time.Time) *WindowSummary {
	s.TestWindowEnd = &v
	return s
}

// SetTestWindowStart sets the TestWindowStart field's value.
func (s *WindowSummary) SetTestWindowStart(v time.Time) *WindowSummary {
	s.TestWindowStart = &v
	return s
}

const (
	// AttributeTypeString is a AttributeType enum value
	AttributeTypeString = "string"

	// AttributeTypeInteger is a AttributeType enum value
	AttributeTypeInteger = "integer"

	// AttributeTypeFloat is a AttributeType enum value
	AttributeTypeFloat = "float"

	// AttributeTypeTimestamp is a AttributeType enum value
	AttributeTypeTimestamp = "timestamp"
)

const (
	// DatasetTypeTargetTimeSeries is a DatasetType enum value
	DatasetTypeTargetTimeSeries = "TARGET_TIME_SERIES"

	// DatasetTypeRelatedTimeSeries is a DatasetType enum value
	DatasetTypeRelatedTimeSeries = "RELATED_TIME_SERIES"

	// DatasetTypeItemMetadata is a DatasetType enum value
	DatasetTypeItemMetadata = "ITEM_METADATA"
)

const (
	// DomainRetail is a Domain enum value
	DomainRetail = "RETAIL"

	// DomainCustom is a Domain enum value
	DomainCustom = "CUSTOM"

	// DomainInventoryPlanning is a Domain enum value
	DomainInventoryPlanning = "INVENTORY_PLANNING"

	// DomainEc2Capacity is a Domain enum value
	DomainEc2Capacity = "EC2_CAPACITY"

	// DomainWorkForce is a Domain enum value
	DomainWorkForce = "WORK_FORCE"

	// DomainWebTraffic is a Domain enum value
	DomainWebTraffic = "WEB_TRAFFIC"

	// DomainMetrics is a Domain enum value
	DomainMetrics = "METRICS"
)

const (
	// EvaluationTypeSummary is a EvaluationType enum value
	EvaluationTypeSummary = "SUMMARY"

	// EvaluationTypeComputed is a EvaluationType enum value
	EvaluationTypeComputed = "COMPUTED"
)

const (
	// FeaturizationMethodNameFilling is a FeaturizationMethodName enum value
	FeaturizationMethodNameFilling = "filling"
)

const (
	// FilterConditionStringIs is a FilterConditionString enum value
	FilterConditionStringIs = "IS"

	// FilterConditionStringIsNot is a FilterConditionString enum value
	FilterConditionStringIsNot = "IS_NOT"
)

const (
	// ScalingTypeAuto is a ScalingType enum value
	ScalingTypeAuto = "Auto"

	// ScalingTypeLinear is a ScalingType enum value
	ScalingTypeLinear = "Linear"

	// ScalingTypeLogarithmic is a ScalingType enum value
	ScalingTypeLogarithmic = "Logarithmic"

	// ScalingTypeReverseLogarithmic is a ScalingType enum value
	ScalingTypeReverseLogarithmic = "ReverseLogarithmic"
)
