package resource

import "fmt"

// ValidateResourceGroupID validates that the specified Resource Group ID is Valid
func ValidateResourceGroupID(i interface{}, k string) (warnings []string, errors []error) {
	v, ok := i.(string)
	if !ok {
		errors = append(errors, fmt.Errorf("expected type of %q to be string", k))
		return
	}

	if _, err := ParseResourceGroupID(v); err != nil {
		errors = append(errors, fmt.Errorf("Can not parse %q as a resource id: %v", k, err))
		return
	}

	return warnings, errors
}

// ValidateResourceGroupIDOrEmpty validates that the specified ID is either Empty or a Valid Resource Group ID
func ValidateResourceGroupIDOrEmpty(i interface{}, k string) (_ []string, errors []error) {
	v, ok := i.(string)
	if !ok {
		errors = append(errors, fmt.Errorf("expected type of %q to be string", k))
		return
	}

	if v == "" {
		return
	}

	return ValidateResourceGroupID(i, k)
}
