package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datalake/analytics/mgmt/2016-11-01/account"

// AccountsCreateFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (DataLakeAnalyticsAccount, error)
}

// AccountsDeleteFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// AccountsUpdateFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (DataLakeAnalyticsAccount, error)
}

// AddDataLakeStoreParameters the parameters used to add a new Data Lake Store account.
type AddDataLakeStoreParameters struct {
	// AddDataLakeStoreProperties - The Data Lake Store account properties to use when adding a new Data Lake Store account.
	*AddDataLakeStoreProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddDataLakeStoreParameters.
func (adlsp AddDataLakeStoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlsp.AddDataLakeStoreProperties != nil {
		objectMap["properties"] = adlsp.AddDataLakeStoreProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddDataLakeStoreParameters struct.
func (adlsp *AddDataLakeStoreParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addDataLakeStoreProperties AddDataLakeStoreProperties
				err = json.Unmarshal(*v, &addDataLakeStoreProperties)
				if err != nil {
					return err
				}
				adlsp.AddDataLakeStoreProperties = &addDataLakeStoreProperties
			}
		}
	}

	return nil
}

// AddDataLakeStoreProperties the Data Lake Store account properties to use when adding a new Data Lake
// Store account.
type AddDataLakeStoreProperties struct {
	// Suffix - The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty"`
}

// AddDataLakeStoreWithAccountParameters the parameters used to add a new Data Lake Store account while
// creating a new Data Lake Analytics account.
type AddDataLakeStoreWithAccountParameters struct {
	// Name - The unique name of the Data Lake Store account to add.
	Name *string `json:"name,omitempty"`
	// AddDataLakeStoreProperties - The Data Lake Store account properties to use when adding a new Data Lake Store account.
	*AddDataLakeStoreProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddDataLakeStoreWithAccountParameters.
func (adlswap AddDataLakeStoreWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlswap.Name != nil {
		objectMap["name"] = adlswap.Name
	}
	if adlswap.AddDataLakeStoreProperties != nil {
		objectMap["properties"] = adlswap.AddDataLakeStoreProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddDataLakeStoreWithAccountParameters struct.
func (adlswap *AddDataLakeStoreWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adlswap.Name = &name
			}
		case "properties":
			if v != nil {
				var addDataLakeStoreProperties AddDataLakeStoreProperties
				err = json.Unmarshal(*v, &addDataLakeStoreProperties)
				if err != nil {
					return err
				}
				adlswap.AddDataLakeStoreProperties = &addDataLakeStoreProperties
			}
		}
	}

	return nil
}

// AddStorageAccountParameters the parameters used to add a new Azure Storage account.
type AddStorageAccountParameters struct {
	// AddStorageAccountProperties - The Azure Storage account properties to use when adding a new Azure Storage account.
	*AddStorageAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddStorageAccountParameters.
func (asap AddStorageAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asap.AddStorageAccountProperties != nil {
		objectMap["properties"] = asap.AddStorageAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddStorageAccountParameters struct.
func (asap *AddStorageAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addStorageAccountProperties AddStorageAccountProperties
				err = json.Unmarshal(*v, &addStorageAccountProperties)
				if err != nil {
					return err
				}
				asap.AddStorageAccountProperties = &addStorageAccountProperties
			}
		}
	}

	return nil
}

// AddStorageAccountProperties the Azure Storage account properties to use when adding a new Azure Storage
// account.
type AddStorageAccountProperties struct {
	// AccessKey - The access key associated with this Azure Storage account that will be used to connect to it.
	AccessKey *string `json:"accessKey,omitempty"`
	// Suffix - The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty"`
}

// AddStorageAccountWithAccountParameters the parameters used to add a new Azure Storage account while
// creating a new Data Lake Analytics account.
type AddStorageAccountWithAccountParameters struct {
	// Name - The unique name of the Azure Storage account to add.
	Name *string `json:"name,omitempty"`
	// AddStorageAccountProperties - The Azure Storage account properties to use when adding a new Azure Storage account.
	*AddStorageAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddStorageAccountWithAccountParameters.
func (asawap AddStorageAccountWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asawap.Name != nil {
		objectMap["name"] = asawap.Name
	}
	if asawap.AddStorageAccountProperties != nil {
		objectMap["properties"] = asawap.AddStorageAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddStorageAccountWithAccountParameters struct.
func (asawap *AddStorageAccountWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asawap.Name = &name
			}
		case "properties":
			if v != nil {
				var addStorageAccountProperties AddStorageAccountProperties
				err = json.Unmarshal(*v, &addStorageAccountProperties)
				if err != nil {
					return err
				}
				asawap.AddStorageAccountProperties = &addStorageAccountProperties
			}
		}
	}

	return nil
}

// CapabilityInformation subscription-level properties and limits for Data Lake Analytics.
type CapabilityInformation struct {
	autorest.Response `json:"-"`
	// SubscriptionID - READ-ONLY; The subscription credentials that uniquely identifies the subscription.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// State - READ-ONLY; The subscription state. Possible values include: 'SubscriptionStateRegistered', 'SubscriptionStateSuspended', 'SubscriptionStateDeleted', 'SubscriptionStateUnregistered', 'SubscriptionStateWarned'
	State SubscriptionState `json:"state,omitempty"`
	// MaxAccountCount - READ-ONLY; The maximum supported number of accounts under this subscription.
	MaxAccountCount *int32 `json:"maxAccountCount,omitempty"`
	// AccountCount - READ-ONLY; The current number of accounts under this subscription.
	AccountCount *int32 `json:"accountCount,omitempty"`
	// MigrationState - READ-ONLY; The Boolean value of true or false to indicate the maintenance state.
	MigrationState *bool `json:"migrationState,omitempty"`
}

// CheckNameAvailabilityParameters data Lake Analytics account name availability check parameters.
type CheckNameAvailabilityParameters struct {
	// Name - The Data Lake Analytics name to check availability for.
	Name *string `json:"name,omitempty"`
	// Type - The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeAnalytics/accounts
	Type *string `json:"type,omitempty"`
}

// ComputePolicy data Lake Analytics compute policy information.
type ComputePolicy struct {
	autorest.Response `json:"-"`
	// ComputePolicyProperties - READ-ONLY; The compute policy properties.
	*ComputePolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputePolicy.
func (cp ComputePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComputePolicy struct.
func (cp *ComputePolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var computePolicyProperties ComputePolicyProperties
				err = json.Unmarshal(*v, &computePolicyProperties)
				if err != nil {
					return err
				}
				cp.ComputePolicyProperties = &computePolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		}
	}

	return nil
}

// ComputePolicyListResult the list of compute policies in the account.
type ComputePolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]ComputePolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ComputePolicyListResultIterator provides access to a complete listing of ComputePolicy values.
type ComputePolicyListResultIterator struct {
	i    int
	page ComputePolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComputePolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputePolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComputePolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComputePolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComputePolicyListResultIterator) Response() ComputePolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComputePolicyListResultIterator) Value() ComputePolicy {
	if !iter.page.NotDone() {
		return ComputePolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComputePolicyListResultIterator type.
func NewComputePolicyListResultIterator(page ComputePolicyListResultPage) ComputePolicyListResultIterator {
	return ComputePolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr ComputePolicyListResult) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cplr ComputePolicyListResult) hasNextLink() bool {
	return cplr.NextLink != nil && len(*cplr.NextLink) != 0
}

// computePolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr ComputePolicyListResult) computePolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.NextLink)))
}

// ComputePolicyListResultPage contains a page of ComputePolicy values.
type ComputePolicyListResultPage struct {
	fn   func(context.Context, ComputePolicyListResult) (ComputePolicyListResult, error)
	cplr ComputePolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComputePolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputePolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cplr)
		if err != nil {
			return err
		}
		page.cplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComputePolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComputePolicyListResultPage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComputePolicyListResultPage) Response() ComputePolicyListResult {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComputePolicyListResultPage) Values() []ComputePolicy {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// Creates a new instance of the ComputePolicyListResultPage type.
func NewComputePolicyListResultPage(cur ComputePolicyListResult, getNextPage func(context.Context, ComputePolicyListResult) (ComputePolicyListResult, error)) ComputePolicyListResultPage {
	return ComputePolicyListResultPage{
		fn:   getNextPage,
		cplr: cur,
	}
}

// ComputePolicyProperties the compute policy properties.
type ComputePolicyProperties struct {
	// ObjectID - READ-ONLY; The AAD object identifier for the entity to create a policy for.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// ObjectType - READ-ONLY; The type of AAD object the object identifier refers to. Possible values include: 'User', 'Group', 'ServicePrincipal'
	ObjectType AADObjectType `json:"objectType,omitempty"`
	// MaxDegreeOfParallelismPerJob - READ-ONLY; The maximum degree of parallelism per job this user can use to submit jobs.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - READ-ONLY; The minimum priority per job this user can use to submit jobs.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
}

// CreateComputePolicyWithAccountParameters the parameters used to create a new compute policy while
// creating a new Data Lake Analytics account.
type CreateComputePolicyWithAccountParameters struct {
	// Name - The unique name of the compute policy to create.
	Name *string `json:"name,omitempty"`
	// CreateOrUpdateComputePolicyProperties - The compute policy properties to use when creating a new compute policy.
	*CreateOrUpdateComputePolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateComputePolicyWithAccountParameters.
func (ccpwap CreateComputePolicyWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpwap.Name != nil {
		objectMap["name"] = ccpwap.Name
	}
	if ccpwap.CreateOrUpdateComputePolicyProperties != nil {
		objectMap["properties"] = ccpwap.CreateOrUpdateComputePolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateComputePolicyWithAccountParameters struct.
func (ccpwap *CreateComputePolicyWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccpwap.Name = &name
			}
		case "properties":
			if v != nil {
				var createOrUpdateComputePolicyProperties CreateOrUpdateComputePolicyProperties
				err = json.Unmarshal(*v, &createOrUpdateComputePolicyProperties)
				if err != nil {
					return err
				}
				ccpwap.CreateOrUpdateComputePolicyProperties = &createOrUpdateComputePolicyProperties
			}
		}
	}

	return nil
}

// CreateDataLakeAnalyticsAccountParameters the parameters to use for creating a Data Lake Analytics
// account.
type CreateDataLakeAnalyticsAccountParameters struct {
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// CreateDataLakeAnalyticsAccountProperties - The Data Lake Analytics account properties to use for creating.
	*CreateDataLakeAnalyticsAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateDataLakeAnalyticsAccountParameters.
func (cdlaap CreateDataLakeAnalyticsAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdlaap.Location != nil {
		objectMap["location"] = cdlaap.Location
	}
	if cdlaap.Tags != nil {
		objectMap["tags"] = cdlaap.Tags
	}
	if cdlaap.CreateDataLakeAnalyticsAccountProperties != nil {
		objectMap["properties"] = cdlaap.CreateDataLakeAnalyticsAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateDataLakeAnalyticsAccountParameters struct.
func (cdlaap *CreateDataLakeAnalyticsAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cdlaap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cdlaap.Tags = tags
			}
		case "properties":
			if v != nil {
				var createDataLakeAnalyticsAccountProperties CreateDataLakeAnalyticsAccountProperties
				err = json.Unmarshal(*v, &createDataLakeAnalyticsAccountProperties)
				if err != nil {
					return err
				}
				cdlaap.CreateDataLakeAnalyticsAccountProperties = &createDataLakeAnalyticsAccountProperties
			}
		}
	}

	return nil
}

// CreateDataLakeAnalyticsAccountProperties ...
type CreateDataLakeAnalyticsAccountProperties struct {
	// DefaultDataLakeStoreAccount - The default Data Lake Store account associated with this account.
	DefaultDataLakeStoreAccount *string `json:"defaultDataLakeStoreAccount,omitempty"`
	// DataLakeStoreAccounts - The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts *[]AddDataLakeStoreWithAccountParameters `json:"dataLakeStoreAccounts,omitempty"`
	// StorageAccounts - The list of Azure Blob Storage accounts associated with this account.
	StorageAccounts *[]AddStorageAccountWithAccountParameters `json:"storageAccounts,omitempty"`
	// ComputePolicies - The list of compute policies associated with this account.
	ComputePolicies *[]CreateComputePolicyWithAccountParameters `json:"computePolicies,omitempty"`
	// FirewallRules - The list of firewall rules associated with this account.
	FirewallRules *[]CreateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`
	// FirewallState - The current state of the IP address firewall for this account. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'Enabled', 'Disabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// NewTier - The commitment tier for the next month. Possible values include: 'Consumption', 'Commitment100AUHours', 'Commitment500AUHours', 'Commitment1000AUHours', 'Commitment5000AUHours', 'Commitment10000AUHours', 'Commitment50000AUHours', 'Commitment100000AUHours', 'Commitment500000AUHours'
	NewTier TierType `json:"newTier,omitempty"`
	// MaxJobCount - The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`
	// MaxDegreeOfParallelism - The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`
	// MaxDegreeOfParallelismPerJob - The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
	// QueryStoreRetention - The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`
}

// CreateFirewallRuleWithAccountParameters the parameters used to create a new firewall rule while creating
// a new Data Lake Analytics account.
type CreateFirewallRuleWithAccountParameters struct {
	// Name - The unique name of the firewall rule to create.
	Name *string `json:"name,omitempty"`
	// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
	*CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateFirewallRuleWithAccountParameters.
func (cfrwap CreateFirewallRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cfrwap.Name != nil {
		objectMap["name"] = cfrwap.Name
	}
	if cfrwap.CreateOrUpdateFirewallRuleProperties != nil {
		objectMap["properties"] = cfrwap.CreateOrUpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateFirewallRuleWithAccountParameters struct.
func (cfrwap *CreateFirewallRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cfrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var createOrUpdateFirewallRuleProperties CreateOrUpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateFirewallRuleProperties)
				if err != nil {
					return err
				}
				cfrwap.CreateOrUpdateFirewallRuleProperties = &createOrUpdateFirewallRuleProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateComputePolicyParameters the parameters used to create a new compute policy.
type CreateOrUpdateComputePolicyParameters struct {
	// CreateOrUpdateComputePolicyProperties - The compute policy properties to use when creating a new compute policy.
	*CreateOrUpdateComputePolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateComputePolicyParameters.
func (coucpp CreateOrUpdateComputePolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coucpp.CreateOrUpdateComputePolicyProperties != nil {
		objectMap["properties"] = coucpp.CreateOrUpdateComputePolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateComputePolicyParameters struct.
func (coucpp *CreateOrUpdateComputePolicyParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createOrUpdateComputePolicyProperties CreateOrUpdateComputePolicyProperties
				err = json.Unmarshal(*v, &createOrUpdateComputePolicyProperties)
				if err != nil {
					return err
				}
				coucpp.CreateOrUpdateComputePolicyProperties = &createOrUpdateComputePolicyProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateComputePolicyProperties the compute policy properties to use when creating a new compute
// policy.
type CreateOrUpdateComputePolicyProperties struct {
	// ObjectID - The AAD object identifier for the entity to create a policy for.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// ObjectType - The type of AAD object the object identifier refers to. Possible values include: 'User', 'Group', 'ServicePrincipal'
	ObjectType AADObjectType `json:"objectType,omitempty"`
	// MaxDegreeOfParallelismPerJob - The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
}

// CreateOrUpdateFirewallRuleParameters the parameters used to create a new firewall rule.
type CreateOrUpdateFirewallRuleParameters struct {
	// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
	*CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateFirewallRuleParameters.
func (coufrp CreateOrUpdateFirewallRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coufrp.CreateOrUpdateFirewallRuleProperties != nil {
		objectMap["properties"] = coufrp.CreateOrUpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateFirewallRuleParameters struct.
func (coufrp *CreateOrUpdateFirewallRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createOrUpdateFirewallRuleProperties CreateOrUpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &createOrUpdateFirewallRuleProperties)
				if err != nil {
					return err
				}
				coufrp.CreateOrUpdateFirewallRuleProperties = &createOrUpdateFirewallRuleProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateFirewallRuleProperties the firewall rule properties to use when creating a new firewall
// rule.
type CreateOrUpdateFirewallRuleProperties struct {
	// StartIPAddress - The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// DataLakeAnalyticsAccount a Data Lake Analytics account object, containing all information associated
// with the named Data Lake Analytics account.
type DataLakeAnalyticsAccount struct {
	autorest.Response `json:"-"`
	// DataLakeAnalyticsAccountProperties - READ-ONLY; The properties defined by Data Lake Analytics all properties are specific to each resource provider.
	*DataLakeAnalyticsAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifer.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalyticsAccount.
func (dlaa DataLakeAnalyticsAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataLakeAnalyticsAccount struct.
func (dlaa *DataLakeAnalyticsAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataLakeAnalyticsAccountProperties DataLakeAnalyticsAccountProperties
				err = json.Unmarshal(*v, &dataLakeAnalyticsAccountProperties)
				if err != nil {
					return err
				}
				dlaa.DataLakeAnalyticsAccountProperties = &dataLakeAnalyticsAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dlaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dlaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dlaa.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dlaa.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dlaa.Tags = tags
			}
		}
	}

	return nil
}

// DataLakeAnalyticsAccountBasic a Data Lake Analytics account object, containing all information
// associated with the named Data Lake Analytics account.
type DataLakeAnalyticsAccountBasic struct {
	// DataLakeAnalyticsAccountPropertiesBasic - READ-ONLY; The properties defined by Data Lake Analytics all properties are specific to each resource provider.
	*DataLakeAnalyticsAccountPropertiesBasic `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifer.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalyticsAccountBasic.
func (dlaab DataLakeAnalyticsAccountBasic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataLakeAnalyticsAccountBasic struct.
func (dlaab *DataLakeAnalyticsAccountBasic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataLakeAnalyticsAccountPropertiesBasic DataLakeAnalyticsAccountPropertiesBasic
				err = json.Unmarshal(*v, &dataLakeAnalyticsAccountPropertiesBasic)
				if err != nil {
					return err
				}
				dlaab.DataLakeAnalyticsAccountPropertiesBasic = &dataLakeAnalyticsAccountPropertiesBasic
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dlaab.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dlaab.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dlaab.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dlaab.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dlaab.Tags = tags
			}
		}
	}

	return nil
}

// DataLakeAnalyticsAccountListResult data Lake Analytics account list information.
type DataLakeAnalyticsAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]DataLakeAnalyticsAccountBasic `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeAnalyticsAccountListResultIterator provides access to a complete listing of
// DataLakeAnalyticsAccountBasic values.
type DataLakeAnalyticsAccountListResultIterator struct {
	i    int
	page DataLakeAnalyticsAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeAnalyticsAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeAnalyticsAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataLakeAnalyticsAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeAnalyticsAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeAnalyticsAccountListResultIterator) Response() DataLakeAnalyticsAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeAnalyticsAccountListResultIterator) Value() DataLakeAnalyticsAccountBasic {
	if !iter.page.NotDone() {
		return DataLakeAnalyticsAccountBasic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataLakeAnalyticsAccountListResultIterator type.
func NewDataLakeAnalyticsAccountListResultIterator(page DataLakeAnalyticsAccountListResultPage) DataLakeAnalyticsAccountListResultIterator {
	return DataLakeAnalyticsAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlaalr DataLakeAnalyticsAccountListResult) IsEmpty() bool {
	return dlaalr.Value == nil || len(*dlaalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlaalr DataLakeAnalyticsAccountListResult) hasNextLink() bool {
	return dlaalr.NextLink != nil && len(*dlaalr.NextLink) != 0
}

// dataLakeAnalyticsAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlaalr DataLakeAnalyticsAccountListResult) dataLakeAnalyticsAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlaalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlaalr.NextLink)))
}

// DataLakeAnalyticsAccountListResultPage contains a page of DataLakeAnalyticsAccountBasic values.
type DataLakeAnalyticsAccountListResultPage struct {
	fn     func(context.Context, DataLakeAnalyticsAccountListResult) (DataLakeAnalyticsAccountListResult, error)
	dlaalr DataLakeAnalyticsAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeAnalyticsAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeAnalyticsAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlaalr)
		if err != nil {
			return err
		}
		page.dlaalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataLakeAnalyticsAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeAnalyticsAccountListResultPage) NotDone() bool {
	return !page.dlaalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeAnalyticsAccountListResultPage) Response() DataLakeAnalyticsAccountListResult {
	return page.dlaalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeAnalyticsAccountListResultPage) Values() []DataLakeAnalyticsAccountBasic {
	if page.dlaalr.IsEmpty() {
		return nil
	}
	return *page.dlaalr.Value
}

// Creates a new instance of the DataLakeAnalyticsAccountListResultPage type.
func NewDataLakeAnalyticsAccountListResultPage(cur DataLakeAnalyticsAccountListResult, getNextPage func(context.Context, DataLakeAnalyticsAccountListResult) (DataLakeAnalyticsAccountListResult, error)) DataLakeAnalyticsAccountListResultPage {
	return DataLakeAnalyticsAccountListResultPage{
		fn:     getNextPage,
		dlaalr: cur,
	}
}

// DataLakeAnalyticsAccountProperties the account specific properties that are associated with an
// underlying Data Lake Analytics account. Returned only when retrieving a specific account.
type DataLakeAnalyticsAccountProperties struct {
	// DefaultDataLakeStoreAccount - READ-ONLY; The default Data Lake Store account associated with this account.
	DefaultDataLakeStoreAccount *string `json:"defaultDataLakeStoreAccount,omitempty"`
	// DataLakeStoreAccounts - READ-ONLY; The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts *[]DataLakeStoreAccountInformation `json:"dataLakeStoreAccounts,omitempty"`
	// StorageAccounts - READ-ONLY; The list of Azure Blob Storage accounts associated with this account.
	StorageAccounts *[]StorageAccountInformation `json:"storageAccounts,omitempty"`
	// ComputePolicies - READ-ONLY; The list of compute policies associated with this account.
	ComputePolicies *[]ComputePolicy `json:"computePolicies,omitempty"`
	// FirewallRules - READ-ONLY; The list of firewall rules associated with this account.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
	// FirewallState - READ-ONLY; The current state of the IP address firewall for this account. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - READ-ONLY; The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'Enabled', 'Disabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// NewTier - READ-ONLY; The commitment tier for the next month. Possible values include: 'Consumption', 'Commitment100AUHours', 'Commitment500AUHours', 'Commitment1000AUHours', 'Commitment5000AUHours', 'Commitment10000AUHours', 'Commitment50000AUHours', 'Commitment100000AUHours', 'Commitment500000AUHours'
	NewTier TierType `json:"newTier,omitempty"`
	// CurrentTier - READ-ONLY; The commitment tier in use for the current month. Possible values include: 'Consumption', 'Commitment100AUHours', 'Commitment500AUHours', 'Commitment1000AUHours', 'Commitment5000AUHours', 'Commitment10000AUHours', 'Commitment50000AUHours', 'Commitment100000AUHours', 'Commitment500000AUHours'
	CurrentTier TierType `json:"currentTier,omitempty"`
	// MaxJobCount - READ-ONLY; The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`
	// SystemMaxJobCount - READ-ONLY; The system defined maximum supported jobs running under the account at the same time, which restricts the maximum number of running jobs the user can set for the account.
	SystemMaxJobCount *int32 `json:"systemMaxJobCount,omitempty"`
	// MaxDegreeOfParallelism - READ-ONLY; The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`
	// SystemMaxDegreeOfParallelism - READ-ONLY; The system defined maximum supported degree of parallelism for this account, which restricts the maximum value of parallelism the user can set for the account.
	SystemMaxDegreeOfParallelism *int32 `json:"systemMaxDegreeOfParallelism,omitempty"`
	// MaxDegreeOfParallelismPerJob - READ-ONLY; The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - READ-ONLY; The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
	// QueryStoreRetention - READ-ONLY; The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`
	// AccountID - READ-ONLY; The unique identifier associated with this Data Lake Analytics account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the Data Lake Analytics account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeAnalyticsAccountStatus `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The state of the Data Lake Analytics account. Possible values include: 'Active', 'Suspended'
	State DataLakeAnalyticsAccountState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; The account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
}

// DataLakeAnalyticsAccountPropertiesBasic the basic account specific properties that are associated with
// an underlying Data Lake Analytics account.
type DataLakeAnalyticsAccountPropertiesBasic struct {
	// AccountID - READ-ONLY; The unique identifier associated with this Data Lake Analytics account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the Data Lake Analytics account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeAnalyticsAccountStatus `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The state of the Data Lake Analytics account. Possible values include: 'Active', 'Suspended'
	State DataLakeAnalyticsAccountState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; The account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
}

// DataLakeStoreAccountInformation data Lake Store account information.
type DataLakeStoreAccountInformation struct {
	autorest.Response `json:"-"`
	// DataLakeStoreAccountInformationProperties - READ-ONLY; The Data Lake Store account properties.
	*DataLakeStoreAccountInformationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataLakeStoreAccountInformation.
func (dlsai DataLakeStoreAccountInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccountInformation struct.
func (dlsai *DataLakeStoreAccountInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataLakeStoreAccountInformationProperties DataLakeStoreAccountInformationProperties
				err = json.Unmarshal(*v, &dataLakeStoreAccountInformationProperties)
				if err != nil {
					return err
				}
				dlsai.DataLakeStoreAccountInformationProperties = &dataLakeStoreAccountInformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dlsai.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dlsai.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dlsai.Type = &typeVar
			}
		}
	}

	return nil
}

// DataLakeStoreAccountInformationListResult data Lake Store account list information.
type DataLakeStoreAccountInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]DataLakeStoreAccountInformation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeStoreAccountInformationListResultIterator provides access to a complete listing of
// DataLakeStoreAccountInformation values.
type DataLakeStoreAccountInformationListResultIterator struct {
	i    int
	page DataLakeStoreAccountInformationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeStoreAccountInformationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeStoreAccountInformationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataLakeStoreAccountInformationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeStoreAccountInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeStoreAccountInformationListResultIterator) Response() DataLakeStoreAccountInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeStoreAccountInformationListResultIterator) Value() DataLakeStoreAccountInformation {
	if !iter.page.NotDone() {
		return DataLakeStoreAccountInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataLakeStoreAccountInformationListResultIterator type.
func NewDataLakeStoreAccountInformationListResultIterator(page DataLakeStoreAccountInformationListResultPage) DataLakeStoreAccountInformationListResultIterator {
	return DataLakeStoreAccountInformationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlsailr DataLakeStoreAccountInformationListResult) IsEmpty() bool {
	return dlsailr.Value == nil || len(*dlsailr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlsailr DataLakeStoreAccountInformationListResult) hasNextLink() bool {
	return dlsailr.NextLink != nil && len(*dlsailr.NextLink) != 0
}

// dataLakeStoreAccountInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlsailr DataLakeStoreAccountInformationListResult) dataLakeStoreAccountInformationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlsailr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlsailr.NextLink)))
}

// DataLakeStoreAccountInformationListResultPage contains a page of DataLakeStoreAccountInformation values.
type DataLakeStoreAccountInformationListResultPage struct {
	fn      func(context.Context, DataLakeStoreAccountInformationListResult) (DataLakeStoreAccountInformationListResult, error)
	dlsailr DataLakeStoreAccountInformationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeStoreAccountInformationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataLakeStoreAccountInformationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlsailr)
		if err != nil {
			return err
		}
		page.dlsailr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataLakeStoreAccountInformationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeStoreAccountInformationListResultPage) NotDone() bool {
	return !page.dlsailr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeStoreAccountInformationListResultPage) Response() DataLakeStoreAccountInformationListResult {
	return page.dlsailr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeStoreAccountInformationListResultPage) Values() []DataLakeStoreAccountInformation {
	if page.dlsailr.IsEmpty() {
		return nil
	}
	return *page.dlsailr.Value
}

// Creates a new instance of the DataLakeStoreAccountInformationListResultPage type.
func NewDataLakeStoreAccountInformationListResultPage(cur DataLakeStoreAccountInformationListResult, getNextPage func(context.Context, DataLakeStoreAccountInformationListResult) (DataLakeStoreAccountInformationListResult, error)) DataLakeStoreAccountInformationListResultPage {
	return DataLakeStoreAccountInformationListResultPage{
		fn:      getNextPage,
		dlsailr: cur,
	}
}

// DataLakeStoreAccountInformationProperties the Data Lake Store account properties.
type DataLakeStoreAccountInformationProperties struct {
	// Suffix - READ-ONLY; The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty"`
}

// FirewallRule data Lake Analytics firewall rule information.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - READ-ONLY; The firewall rule properties.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult data Lake Analytics firewall rule list information.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// FirewallRuleProperties the firewall rule properties.
type FirewallRuleProperties struct {
	// StartIPAddress - READ-ONLY; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - READ-ONLY; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// NameAvailabilityInformation data Lake Analytics account name availability result information.
type NameAvailabilityInformation struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; The Boolean value of true or false to indicate whether the Data Lake Analytics account name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason why the Data Lake Analytics account name is not available, if nameAvailable is false.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The message describing why the Data Lake Analytics account name is not available, if nameAvailable is false.
	Message *string `json:"message,omitempty"`
}

// Operation an available operation for Data Lake Analytics.
type Operation struct {
	// Name - READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The display information for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'OperationOriginUser', 'OperationOriginSystem', 'OperationOriginUsersystem'
	Origin OperationOrigin `json:"origin,omitempty"`
}

// OperationDisplay the display information for a particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The resource provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The resource type of the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; A friendly name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; A friendly description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the list of available operations for Data Lake Analytics.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Resource the resource model definition.
type Resource struct {
	// ID - READ-ONLY; The resource identifer.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SasTokenInformation SAS token information.
type SasTokenInformation struct {
	// AccessToken - READ-ONLY; The access token for the associated Azure Storage Container.
	AccessToken *string `json:"accessToken,omitempty"`
}

// SasTokenInformationListResult the SAS response that contains the storage account, container and
// associated SAS token for connection use.
type SasTokenInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]SasTokenInformation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SasTokenInformationListResultIterator provides access to a complete listing of SasTokenInformation
// values.
type SasTokenInformationListResultIterator struct {
	i    int
	page SasTokenInformationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SasTokenInformationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SasTokenInformationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SasTokenInformationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SasTokenInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SasTokenInformationListResultIterator) Response() SasTokenInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SasTokenInformationListResultIterator) Value() SasTokenInformation {
	if !iter.page.NotDone() {
		return SasTokenInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SasTokenInformationListResultIterator type.
func NewSasTokenInformationListResultIterator(page SasTokenInformationListResultPage) SasTokenInformationListResultIterator {
	return SasTokenInformationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (stilr SasTokenInformationListResult) IsEmpty() bool {
	return stilr.Value == nil || len(*stilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (stilr SasTokenInformationListResult) hasNextLink() bool {
	return stilr.NextLink != nil && len(*stilr.NextLink) != 0
}

// sasTokenInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (stilr SasTokenInformationListResult) sasTokenInformationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !stilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(stilr.NextLink)))
}

// SasTokenInformationListResultPage contains a page of SasTokenInformation values.
type SasTokenInformationListResultPage struct {
	fn    func(context.Context, SasTokenInformationListResult) (SasTokenInformationListResult, error)
	stilr SasTokenInformationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SasTokenInformationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SasTokenInformationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.stilr)
		if err != nil {
			return err
		}
		page.stilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SasTokenInformationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SasTokenInformationListResultPage) NotDone() bool {
	return !page.stilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SasTokenInformationListResultPage) Response() SasTokenInformationListResult {
	return page.stilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SasTokenInformationListResultPage) Values() []SasTokenInformation {
	if page.stilr.IsEmpty() {
		return nil
	}
	return *page.stilr.Value
}

// Creates a new instance of the SasTokenInformationListResultPage type.
func NewSasTokenInformationListResultPage(cur SasTokenInformationListResult, getNextPage func(context.Context, SasTokenInformationListResult) (SasTokenInformationListResult, error)) SasTokenInformationListResultPage {
	return SasTokenInformationListResultPage{
		fn:    getNextPage,
		stilr: cur,
	}
}

// StorageAccountInformation azure Storage account information.
type StorageAccountInformation struct {
	autorest.Response `json:"-"`
	// StorageAccountInformationProperties - READ-ONLY; The Azure Storage account properties.
	*StorageAccountInformationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountInformation.
func (sai StorageAccountInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountInformation struct.
func (sai *StorageAccountInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageAccountInformationProperties StorageAccountInformationProperties
				err = json.Unmarshal(*v, &storageAccountInformationProperties)
				if err != nil {
					return err
				}
				sai.StorageAccountInformationProperties = &storageAccountInformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sai.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sai.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sai.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountInformationListResult azure Storage account list information.
type StorageAccountInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]StorageAccountInformation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageAccountInformationListResultIterator provides access to a complete listing of
// StorageAccountInformation values.
type StorageAccountInformationListResultIterator struct {
	i    int
	page StorageAccountInformationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageAccountInformationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountInformationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageAccountInformationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageAccountInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageAccountInformationListResultIterator) Response() StorageAccountInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageAccountInformationListResultIterator) Value() StorageAccountInformation {
	if !iter.page.NotDone() {
		return StorageAccountInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageAccountInformationListResultIterator type.
func NewStorageAccountInformationListResultIterator(page StorageAccountInformationListResultPage) StorageAccountInformationListResultIterator {
	return StorageAccountInformationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sailr StorageAccountInformationListResult) IsEmpty() bool {
	return sailr.Value == nil || len(*sailr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sailr StorageAccountInformationListResult) hasNextLink() bool {
	return sailr.NextLink != nil && len(*sailr.NextLink) != 0
}

// storageAccountInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sailr StorageAccountInformationListResult) storageAccountInformationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sailr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sailr.NextLink)))
}

// StorageAccountInformationListResultPage contains a page of StorageAccountInformation values.
type StorageAccountInformationListResultPage struct {
	fn    func(context.Context, StorageAccountInformationListResult) (StorageAccountInformationListResult, error)
	sailr StorageAccountInformationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageAccountInformationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountInformationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sailr)
		if err != nil {
			return err
		}
		page.sailr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageAccountInformationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageAccountInformationListResultPage) NotDone() bool {
	return !page.sailr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageAccountInformationListResultPage) Response() StorageAccountInformationListResult {
	return page.sailr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageAccountInformationListResultPage) Values() []StorageAccountInformation {
	if page.sailr.IsEmpty() {
		return nil
	}
	return *page.sailr.Value
}

// Creates a new instance of the StorageAccountInformationListResultPage type.
func NewStorageAccountInformationListResultPage(cur StorageAccountInformationListResult, getNextPage func(context.Context, StorageAccountInformationListResult) (StorageAccountInformationListResult, error)) StorageAccountInformationListResultPage {
	return StorageAccountInformationListResultPage{
		fn:    getNextPage,
		sailr: cur,
	}
}

// StorageAccountInformationProperties the Azure Storage account properties.
type StorageAccountInformationProperties struct {
	// Suffix - READ-ONLY; The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty"`
}

// StorageContainer azure Storage blob container information.
type StorageContainer struct {
	autorest.Response `json:"-"`
	// StorageContainerProperties - READ-ONLY; The properties of the blob container.
	*StorageContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageContainer.
func (sc StorageContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageContainer struct.
func (sc *StorageContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageContainerProperties StorageContainerProperties
				err = json.Unmarshal(*v, &storageContainerProperties)
				if err != nil {
					return err
				}
				sc.StorageContainerProperties = &storageContainerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageContainerListResult the list of blob containers associated with the storage account attached to
// the Data Lake Analytics account.
type StorageContainerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The results of the list operation.
	Value *[]StorageContainer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageContainerListResultIterator provides access to a complete listing of StorageContainer values.
type StorageContainerListResultIterator struct {
	i    int
	page StorageContainerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageContainerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageContainerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageContainerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageContainerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageContainerListResultIterator) Response() StorageContainerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageContainerListResultIterator) Value() StorageContainer {
	if !iter.page.NotDone() {
		return StorageContainer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageContainerListResultIterator type.
func NewStorageContainerListResultIterator(page StorageContainerListResultPage) StorageContainerListResultIterator {
	return StorageContainerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sclr StorageContainerListResult) IsEmpty() bool {
	return sclr.Value == nil || len(*sclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sclr StorageContainerListResult) hasNextLink() bool {
	return sclr.NextLink != nil && len(*sclr.NextLink) != 0
}

// storageContainerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sclr StorageContainerListResult) storageContainerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sclr.NextLink)))
}

// StorageContainerListResultPage contains a page of StorageContainer values.
type StorageContainerListResultPage struct {
	fn   func(context.Context, StorageContainerListResult) (StorageContainerListResult, error)
	sclr StorageContainerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageContainerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageContainerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sclr)
		if err != nil {
			return err
		}
		page.sclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageContainerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageContainerListResultPage) NotDone() bool {
	return !page.sclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageContainerListResultPage) Response() StorageContainerListResult {
	return page.sclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageContainerListResultPage) Values() []StorageContainer {
	if page.sclr.IsEmpty() {
		return nil
	}
	return *page.sclr.Value
}

// Creates a new instance of the StorageContainerListResultPage type.
func NewStorageContainerListResultPage(cur StorageContainerListResult, getNextPage func(context.Context, StorageContainerListResult) (StorageContainerListResult, error)) StorageContainerListResultPage {
	return StorageContainerListResultPage{
		fn:   getNextPage,
		sclr: cur,
	}
}

// StorageContainerProperties azure Storage blob container properties information.
type StorageContainerProperties struct {
	// LastModifiedTime - READ-ONLY; The last modified time of the blob container.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
}

// SubResource the resource model definition for a nested resource.
type SubResource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// UpdateComputePolicyParameters the parameters used to update a compute policy.
type UpdateComputePolicyParameters struct {
	// UpdateComputePolicyProperties - The compute policy properties to use when updating a compute policy.
	*UpdateComputePolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateComputePolicyParameters.
func (ucpp UpdateComputePolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucpp.UpdateComputePolicyProperties != nil {
		objectMap["properties"] = ucpp.UpdateComputePolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateComputePolicyParameters struct.
func (ucpp *UpdateComputePolicyParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateComputePolicyProperties UpdateComputePolicyProperties
				err = json.Unmarshal(*v, &updateComputePolicyProperties)
				if err != nil {
					return err
				}
				ucpp.UpdateComputePolicyProperties = &updateComputePolicyProperties
			}
		}
	}

	return nil
}

// UpdateComputePolicyProperties the compute policy properties to use when updating a compute policy.
type UpdateComputePolicyProperties struct {
	// ObjectID - The AAD object identifier for the entity to create a policy for.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// ObjectType - The type of AAD object the object identifier refers to. Possible values include: 'User', 'Group', 'ServicePrincipal'
	ObjectType AADObjectType `json:"objectType,omitempty"`
	// MaxDegreeOfParallelismPerJob - The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
}

// UpdateComputePolicyWithAccountParameters the parameters used to update a compute policy while updating a
// Data Lake Analytics account.
type UpdateComputePolicyWithAccountParameters struct {
	// Name - The unique name of the compute policy to update.
	Name *string `json:"name,omitempty"`
	// UpdateComputePolicyProperties - The compute policy properties to use when updating a compute policy.
	*UpdateComputePolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateComputePolicyWithAccountParameters.
func (ucpwap UpdateComputePolicyWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucpwap.Name != nil {
		objectMap["name"] = ucpwap.Name
	}
	if ucpwap.UpdateComputePolicyProperties != nil {
		objectMap["properties"] = ucpwap.UpdateComputePolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateComputePolicyWithAccountParameters struct.
func (ucpwap *UpdateComputePolicyWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ucpwap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateComputePolicyProperties UpdateComputePolicyProperties
				err = json.Unmarshal(*v, &updateComputePolicyProperties)
				if err != nil {
					return err
				}
				ucpwap.UpdateComputePolicyProperties = &updateComputePolicyProperties
			}
		}
	}

	return nil
}

// UpdateDataLakeAnalyticsAccountParameters the parameters that can be used to update an existing Data Lake
// Analytics account.
type UpdateDataLakeAnalyticsAccountParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// UpdateDataLakeAnalyticsAccountProperties - The properties that can be updated in an existing Data Lake Analytics account.
	*UpdateDataLakeAnalyticsAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateDataLakeAnalyticsAccountParameters.
func (udlaap UpdateDataLakeAnalyticsAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if udlaap.Tags != nil {
		objectMap["tags"] = udlaap.Tags
	}
	if udlaap.UpdateDataLakeAnalyticsAccountProperties != nil {
		objectMap["properties"] = udlaap.UpdateDataLakeAnalyticsAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateDataLakeAnalyticsAccountParameters struct.
func (udlaap *UpdateDataLakeAnalyticsAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				udlaap.Tags = tags
			}
		case "properties":
			if v != nil {
				var updateDataLakeAnalyticsAccountProperties UpdateDataLakeAnalyticsAccountProperties
				err = json.Unmarshal(*v, &updateDataLakeAnalyticsAccountProperties)
				if err != nil {
					return err
				}
				udlaap.UpdateDataLakeAnalyticsAccountProperties = &updateDataLakeAnalyticsAccountProperties
			}
		}
	}

	return nil
}

// UpdateDataLakeAnalyticsAccountProperties the properties to update that are associated with an underlying
// Data Lake Analytics account.
type UpdateDataLakeAnalyticsAccountProperties struct {
	// DataLakeStoreAccounts - The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts *[]UpdateDataLakeStoreWithAccountParameters `json:"dataLakeStoreAccounts,omitempty"`
	// StorageAccounts - The list of Azure Blob storage accounts associated with this account.
	StorageAccounts *[]UpdateStorageAccountWithAccountParameters `json:"storageAccounts,omitempty"`
	// ComputePolicies - The list of compute policies associated with this account.
	ComputePolicies *[]UpdateComputePolicyWithAccountParameters `json:"computePolicies,omitempty"`
	// FirewallRules - The list of firewall rules associated with this account.
	FirewallRules *[]UpdateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`
	// FirewallState - The current state of the IP address firewall for this account. Disabling the firewall does not remove existing rules, they will just be ignored until the firewall is re-enabled. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'Enabled', 'Disabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// NewTier - The commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment100AUHours', 'Commitment500AUHours', 'Commitment1000AUHours', 'Commitment5000AUHours', 'Commitment10000AUHours', 'Commitment50000AUHours', 'Commitment100000AUHours', 'Commitment500000AUHours'
	NewTier TierType `json:"newTier,omitempty"`
	// MaxJobCount - The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`
	// MaxDegreeOfParallelism - The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`
	// MaxDegreeOfParallelismPerJob - The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`
	// MinPriorityPerJob - The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
	// QueryStoreRetention - The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`
}

// UpdateDataLakeStoreProperties the Data Lake Store account properties to use when updating a Data Lake
// Store account.
type UpdateDataLakeStoreProperties struct {
	// Suffix - The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty"`
}

// UpdateDataLakeStoreWithAccountParameters the parameters used to update a Data Lake Store account while
// updating a Data Lake Analytics account.
type UpdateDataLakeStoreWithAccountParameters struct {
	// Name - The unique name of the Data Lake Store account to update.
	Name *string `json:"name,omitempty"`
	// UpdateDataLakeStoreProperties - The Data Lake Store account properties to use when updating a Data Lake Store account.
	*UpdateDataLakeStoreProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateDataLakeStoreWithAccountParameters.
func (udlswap UpdateDataLakeStoreWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if udlswap.Name != nil {
		objectMap["name"] = udlswap.Name
	}
	if udlswap.UpdateDataLakeStoreProperties != nil {
		objectMap["properties"] = udlswap.UpdateDataLakeStoreProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateDataLakeStoreWithAccountParameters struct.
func (udlswap *UpdateDataLakeStoreWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				udlswap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateDataLakeStoreProperties UpdateDataLakeStoreProperties
				err = json.Unmarshal(*v, &updateDataLakeStoreProperties)
				if err != nil {
					return err
				}
				udlswap.UpdateDataLakeStoreProperties = &updateDataLakeStoreProperties
			}
		}
	}

	return nil
}

// UpdateFirewallRuleParameters the parameters used to update a firewall rule.
type UpdateFirewallRuleParameters struct {
	// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateFirewallRuleParameters.
func (ufrp UpdateFirewallRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ufrp.UpdateFirewallRuleProperties != nil {
		objectMap["properties"] = ufrp.UpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateFirewallRuleParameters struct.
func (ufrp *UpdateFirewallRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateFirewallRuleProperties UpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &updateFirewallRuleProperties)
				if err != nil {
					return err
				}
				ufrp.UpdateFirewallRuleProperties = &updateFirewallRuleProperties
			}
		}
	}

	return nil
}

// UpdateFirewallRuleProperties the firewall rule properties to use when updating a firewall rule.
type UpdateFirewallRuleProperties struct {
	// StartIPAddress - The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// UpdateFirewallRuleWithAccountParameters the parameters used to update a firewall rule while updating a
// Data Lake Analytics account.
type UpdateFirewallRuleWithAccountParameters struct {
	// Name - The unique name of the firewall rule to update.
	Name *string `json:"name,omitempty"`
	// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateFirewallRuleWithAccountParameters.
func (ufrwap UpdateFirewallRuleWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ufrwap.Name != nil {
		objectMap["name"] = ufrwap.Name
	}
	if ufrwap.UpdateFirewallRuleProperties != nil {
		objectMap["properties"] = ufrwap.UpdateFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateFirewallRuleWithAccountParameters struct.
func (ufrwap *UpdateFirewallRuleWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ufrwap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateFirewallRuleProperties UpdateFirewallRuleProperties
				err = json.Unmarshal(*v, &updateFirewallRuleProperties)
				if err != nil {
					return err
				}
				ufrwap.UpdateFirewallRuleProperties = &updateFirewallRuleProperties
			}
		}
	}

	return nil
}

// UpdateStorageAccountParameters the parameters used to update an Azure Storage account.
type UpdateStorageAccountParameters struct {
	// UpdateStorageAccountProperties - The Azure Storage account properties to use when updating an Azure Storage account.
	*UpdateStorageAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateStorageAccountParameters.
func (usap UpdateStorageAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usap.UpdateStorageAccountProperties != nil {
		objectMap["properties"] = usap.UpdateStorageAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateStorageAccountParameters struct.
func (usap *UpdateStorageAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateStorageAccountProperties UpdateStorageAccountProperties
				err = json.Unmarshal(*v, &updateStorageAccountProperties)
				if err != nil {
					return err
				}
				usap.UpdateStorageAccountProperties = &updateStorageAccountProperties
			}
		}
	}

	return nil
}

// UpdateStorageAccountProperties the Azure Storage account properties to use when updating an Azure
// Storage account.
type UpdateStorageAccountProperties struct {
	// AccessKey - The updated access key associated with this Azure Storage account that will be used to connect to it.
	AccessKey *string `json:"accessKey,omitempty"`
	// Suffix - The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty"`
}

// UpdateStorageAccountWithAccountParameters the parameters used to update an Azure Storage account while
// updating a Data Lake Analytics account.
type UpdateStorageAccountWithAccountParameters struct {
	// Name - The unique name of the Azure Storage account to update.
	Name *string `json:"name,omitempty"`
	// UpdateStorageAccountProperties - The Azure Storage account properties to use when updating an Azure Storage account.
	*UpdateStorageAccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateStorageAccountWithAccountParameters.
func (usawap UpdateStorageAccountWithAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usawap.Name != nil {
		objectMap["name"] = usawap.Name
	}
	if usawap.UpdateStorageAccountProperties != nil {
		objectMap["properties"] = usawap.UpdateStorageAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateStorageAccountWithAccountParameters struct.
func (usawap *UpdateStorageAccountWithAccountParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				usawap.Name = &name
			}
		case "properties":
			if v != nil {
				var updateStorageAccountProperties UpdateStorageAccountProperties
				err = json.Unmarshal(*v, &updateStorageAccountProperties)
				if err != nil {
					return err
				}
				usawap.UpdateStorageAccountProperties = &updateStorageAccountProperties
			}
		}
	}

	return nil
}
