package parse

// NOTE: this file is generated via 'go:generate' - manual changes will be overwritten

import (
	"fmt"
	"strings"

	"github.com/terraform-providers/terraform-provider-azurerm/azurerm/helpers/azure"
)

type DatabaseVulnerabilityAssessmentRuleBaselineId struct {
	SubscriptionId              string
	ResourceGroup               string
	ServerName                  string
	DatabaseName                string
	VulnerabilityAssessmentName string
	RuleName                    string
	BaselineName                string
}

func NewDatabaseVulnerabilityAssessmentRuleBaselineID(subscriptionId, resourceGroup, serverName, databaseName, vulnerabilityAssessmentName, ruleName, baselineName string) DatabaseVulnerabilityAssessmentRuleBaselineId {
	return DatabaseVulnerabilityAssessmentRuleBaselineId{
		SubscriptionId:              subscriptionId,
		ResourceGroup:               resourceGroup,
		ServerName:                  serverName,
		DatabaseName:                databaseName,
		VulnerabilityAssessmentName: vulnerabilityAssessmentName,
		RuleName:                    ruleName,
		BaselineName:                baselineName,
	}
}

func (id DatabaseVulnerabilityAssessmentRuleBaselineId) String() string {
	segments := []string{
		fmt.Sprintf("Baseline Name %q", id.BaselineName),
		fmt.Sprintf("Rule Name %q", id.RuleName),
		fmt.Sprintf("Vulnerability Assessment Name %q", id.VulnerabilityAssessmentName),
		fmt.Sprintf("Database Name %q", id.DatabaseName),
		fmt.Sprintf("Server Name %q", id.ServerName),
		fmt.Sprintf("Resource Group %q", id.ResourceGroup),
	}
	segmentsStr := strings.Join(segments, " / ")
	return fmt.Sprintf("%s: (%s)", "Database Vulnerability Assessment Rule Baseline", segmentsStr)
}

func (id DatabaseVulnerabilityAssessmentRuleBaselineId) ID() string {
	fmtString := "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Sql/servers/%s/databases/%s/vulnerabilityAssessments/%s/rules/%s/baselines/%s"
	return fmt.Sprintf(fmtString, id.SubscriptionId, id.ResourceGroup, id.ServerName, id.DatabaseName, id.VulnerabilityAssessmentName, id.RuleName, id.BaselineName)
}

// DatabaseVulnerabilityAssessmentRuleBaselineID parses a DatabaseVulnerabilityAssessmentRuleBaseline ID into an DatabaseVulnerabilityAssessmentRuleBaselineId struct
func DatabaseVulnerabilityAssessmentRuleBaselineID(input string) (*DatabaseVulnerabilityAssessmentRuleBaselineId, error) {
	id, err := azure.ParseAzureResourceID(input)
	if err != nil {
		return nil, err
	}

	resourceId := DatabaseVulnerabilityAssessmentRuleBaselineId{
		SubscriptionId: id.SubscriptionID,
		ResourceGroup:  id.ResourceGroup,
	}

	if resourceId.SubscriptionId == "" {
		return nil, fmt.Errorf("ID was missing the 'subscriptions' element")
	}

	if resourceId.ResourceGroup == "" {
		return nil, fmt.Errorf("ID was missing the 'resourceGroups' element")
	}

	if resourceId.ServerName, err = id.PopSegment("servers"); err != nil {
		return nil, err
	}
	if resourceId.DatabaseName, err = id.PopSegment("databases"); err != nil {
		return nil, err
	}
	if resourceId.VulnerabilityAssessmentName, err = id.PopSegment("vulnerabilityAssessments"); err != nil {
		return nil, err
	}
	if resourceId.RuleName, err = id.PopSegment("rules"); err != nil {
		return nil, err
	}
	if resourceId.BaselineName, err = id.PopSegment("baselines"); err != nil {
		return nil, err
	}

	if err := id.ValidateNoEmptySegments(input); err != nil {
		return nil, err
	}

	return &resourceId, nil
}
