package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AADObjectType enumerates the values for aad object type.
type AADObjectType string

const (
	// Group ...
	Group AADObjectType = "Group"
	// ServicePrincipal ...
	ServicePrincipal AADObjectType = "ServicePrincipal"
	// User ...
	User AADObjectType = "User"
)

// PossibleAADObjectTypeValues returns an array of possible values for the AADObjectType const type.
func PossibleAADObjectTypeValues() []AADObjectType {
	return []AADObjectType{Group, ServicePrincipal, User}
}

// DataLakeAnalyticsAccountState enumerates the values for data lake analytics account state.
type DataLakeAnalyticsAccountState string

const (
	// Active ...
	Active DataLakeAnalyticsAccountState = "Active"
	// Suspended ...
	Suspended DataLakeAnalyticsAccountState = "Suspended"
)

// PossibleDataLakeAnalyticsAccountStateValues returns an array of possible values for the DataLakeAnalyticsAccountState const type.
func PossibleDataLakeAnalyticsAccountStateValues() []DataLakeAnalyticsAccountState {
	return []DataLakeAnalyticsAccountState{Active, Suspended}
}

// DataLakeAnalyticsAccountStatus enumerates the values for data lake analytics account status.
type DataLakeAnalyticsAccountStatus string

const (
	// Canceled ...
	Canceled DataLakeAnalyticsAccountStatus = "Canceled"
	// Creating ...
	Creating DataLakeAnalyticsAccountStatus = "Creating"
	// Deleted ...
	Deleted DataLakeAnalyticsAccountStatus = "Deleted"
	// Deleting ...
	Deleting DataLakeAnalyticsAccountStatus = "Deleting"
	// Failed ...
	Failed DataLakeAnalyticsAccountStatus = "Failed"
	// Patching ...
	Patching DataLakeAnalyticsAccountStatus = "Patching"
	// Resuming ...
	Resuming DataLakeAnalyticsAccountStatus = "Resuming"
	// Running ...
	Running DataLakeAnalyticsAccountStatus = "Running"
	// Succeeded ...
	Succeeded DataLakeAnalyticsAccountStatus = "Succeeded"
	// Suspending ...
	Suspending DataLakeAnalyticsAccountStatus = "Suspending"
	// Undeleting ...
	Undeleting DataLakeAnalyticsAccountStatus = "Undeleting"
)

// PossibleDataLakeAnalyticsAccountStatusValues returns an array of possible values for the DataLakeAnalyticsAccountStatus const type.
func PossibleDataLakeAnalyticsAccountStatusValues() []DataLakeAnalyticsAccountStatus {
	return []DataLakeAnalyticsAccountStatus{Canceled, Creating, Deleted, Deleting, Failed, Patching, Resuming, Running, Succeeded, Suspending, Undeleting}
}

// FirewallAllowAzureIpsState enumerates the values for firewall allow azure ips state.
type FirewallAllowAzureIpsState string

const (
	// Disabled ...
	Disabled FirewallAllowAzureIpsState = "Disabled"
	// Enabled ...
	Enabled FirewallAllowAzureIpsState = "Enabled"
)

// PossibleFirewallAllowAzureIpsStateValues returns an array of possible values for the FirewallAllowAzureIpsState const type.
func PossibleFirewallAllowAzureIpsStateValues() []FirewallAllowAzureIpsState {
	return []FirewallAllowAzureIpsState{Disabled, Enabled}
}

// FirewallState enumerates the values for firewall state.
type FirewallState string

const (
	// FirewallStateDisabled ...
	FirewallStateDisabled FirewallState = "Disabled"
	// FirewallStateEnabled ...
	FirewallStateEnabled FirewallState = "Enabled"
)

// PossibleFirewallStateValues returns an array of possible values for the FirewallState const type.
func PossibleFirewallStateValues() []FirewallState {
	return []FirewallState{FirewallStateDisabled, FirewallStateEnabled}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
	// OperationOriginUsersystem ...
	OperationOriginUsersystem OperationOrigin = "user,system"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser, OperationOriginUsersystem}
}

// SubscriptionState enumerates the values for subscription state.
type SubscriptionState string

const (
	// SubscriptionStateDeleted ...
	SubscriptionStateDeleted SubscriptionState = "Deleted"
	// SubscriptionStateRegistered ...
	SubscriptionStateRegistered SubscriptionState = "Registered"
	// SubscriptionStateSuspended ...
	SubscriptionStateSuspended SubscriptionState = "Suspended"
	// SubscriptionStateUnregistered ...
	SubscriptionStateUnregistered SubscriptionState = "Unregistered"
	// SubscriptionStateWarned ...
	SubscriptionStateWarned SubscriptionState = "Warned"
)

// PossibleSubscriptionStateValues returns an array of possible values for the SubscriptionState const type.
func PossibleSubscriptionStateValues() []SubscriptionState {
	return []SubscriptionState{SubscriptionStateDeleted, SubscriptionStateRegistered, SubscriptionStateSuspended, SubscriptionStateUnregistered, SubscriptionStateWarned}
}

// TierType enumerates the values for tier type.
type TierType string

const (
	// Commitment100000AUHours ...
	Commitment100000AUHours TierType = "Commitment_100000AUHours"
	// Commitment10000AUHours ...
	Commitment10000AUHours TierType = "Commitment_10000AUHours"
	// Commitment1000AUHours ...
	Commitment1000AUHours TierType = "Commitment_1000AUHours"
	// Commitment100AUHours ...
	Commitment100AUHours TierType = "Commitment_100AUHours"
	// Commitment500000AUHours ...
	Commitment500000AUHours TierType = "Commitment_500000AUHours"
	// Commitment50000AUHours ...
	Commitment50000AUHours TierType = "Commitment_50000AUHours"
	// Commitment5000AUHours ...
	Commitment5000AUHours TierType = "Commitment_5000AUHours"
	// Commitment500AUHours ...
	Commitment500AUHours TierType = "Commitment_500AUHours"
	// Consumption ...
	Consumption TierType = "Consumption"
)

// PossibleTierTypeValues returns an array of possible values for the TierType const type.
func PossibleTierTypeValues() []TierType {
	return []TierType{Commitment100000AUHours, Commitment10000AUHours, Commitment1000AUHours, Commitment100AUHours, Commitment500000AUHours, Commitment50000AUHours, Commitment5000AUHours, Commitment500AUHours, Consumption}
}
