/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	egressipv1 "github.com/ovn-org/ovn-kubernetes/go-controller/pkg/crd/egressip/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeEgressIPs implements EgressIPInterface
type FakeEgressIPs struct {
	Fake *FakeK8sV1
}

var egressipsResource = schema.GroupVersionResource{Group: "k8s.ovn.org", Version: "v1", Resource: "egressips"}

var egressipsKind = schema.GroupVersionKind{Group: "k8s.ovn.org", Version: "v1", Kind: "EgressIP"}

// Get takes name of the egressIP, and returns the corresponding egressIP object, and an error if there is any.
func (c *FakeEgressIPs) Get(ctx context.Context, name string, options v1.GetOptions) (result *egressipv1.EgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(egressipsResource, name), &egressipv1.EgressIP{})
	if obj == nil {
		return nil, err
	}
	return obj.(*egressipv1.EgressIP), err
}

// List takes label and field selectors, and returns the list of EgressIPs that match those selectors.
func (c *FakeEgressIPs) List(ctx context.Context, opts v1.ListOptions) (result *egressipv1.EgressIPList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(egressipsResource, egressipsKind, opts), &egressipv1.EgressIPList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &egressipv1.EgressIPList{ListMeta: obj.(*egressipv1.EgressIPList).ListMeta}
	for _, item := range obj.(*egressipv1.EgressIPList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested egressIPs.
func (c *FakeEgressIPs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(egressipsResource, opts))
}

// Create takes the representation of a egressIP and creates it.  Returns the server's representation of the egressIP, and an error, if there is any.
func (c *FakeEgressIPs) Create(ctx context.Context, egressIP *egressipv1.EgressIP, opts v1.CreateOptions) (result *egressipv1.EgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(egressipsResource, egressIP), &egressipv1.EgressIP{})
	if obj == nil {
		return nil, err
	}
	return obj.(*egressipv1.EgressIP), err
}

// Update takes the representation of a egressIP and updates it. Returns the server's representation of the egressIP, and an error, if there is any.
func (c *FakeEgressIPs) Update(ctx context.Context, egressIP *egressipv1.EgressIP, opts v1.UpdateOptions) (result *egressipv1.EgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(egressipsResource, egressIP), &egressipv1.EgressIP{})
	if obj == nil {
		return nil, err
	}
	return obj.(*egressipv1.EgressIP), err
}

// Delete takes name of the egressIP and deletes it. Returns an error if one occurs.
func (c *FakeEgressIPs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(egressipsResource, name), &egressipv1.EgressIP{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeEgressIPs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(egressipsResource, listOpts)

	_, err := c.Fake.Invokes(action, &egressipv1.EgressIPList{})
	return err
}

// Patch applies the patch and returns the patched egressIP.
func (c *FakeEgressIPs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *egressipv1.EgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(egressipsResource, name, pt, data, subresources...), &egressipv1.EgressIP{})
	if obj == nil {
		return nil, err
	}
	return obj.(*egressipv1.EgressIP), err
}
