// Code generated by go-swagger; DO NOT EDIT.

package bluemix_service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// NewBluemixServiceInstancePutParams creates a new BluemixServiceInstancePutParams object
// with the default values initialized.
func NewBluemixServiceInstancePutParams() *BluemixServiceInstancePutParams {
	var ()
	return &BluemixServiceInstancePutParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewBluemixServiceInstancePutParamsWithTimeout creates a new BluemixServiceInstancePutParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewBluemixServiceInstancePutParamsWithTimeout(timeout time.Duration) *BluemixServiceInstancePutParams {
	var ()
	return &BluemixServiceInstancePutParams{

		timeout: timeout,
	}
}

// NewBluemixServiceInstancePutParamsWithContext creates a new BluemixServiceInstancePutParams object
// with the default values initialized, and the ability to set a context for a request
func NewBluemixServiceInstancePutParamsWithContext(ctx context.Context) *BluemixServiceInstancePutParams {
	var ()
	return &BluemixServiceInstancePutParams{

		Context: ctx,
	}
}

// NewBluemixServiceInstancePutParamsWithHTTPClient creates a new BluemixServiceInstancePutParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewBluemixServiceInstancePutParamsWithHTTPClient(client *http.Client) *BluemixServiceInstancePutParams {
	var ()
	return &BluemixServiceInstancePutParams{
		HTTPClient: client,
	}
}

/*BluemixServiceInstancePutParams contains all the parameters to send to the API endpoint
for the bluemix service instance put operation typically these are written to a http.Request
*/
type BluemixServiceInstancePutParams struct {

	/*Body
	  parameters for the requested state of a provisioned service

	*/
	Body *models.ServiceInstanceRequest
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) WithTimeout(timeout time.Duration) *BluemixServiceInstancePutParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) WithContext(ctx context.Context) *BluemixServiceInstancePutParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) WithHTTPClient(client *http.Client) *BluemixServiceInstancePutParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) WithBody(body *models.ServiceInstanceRequest) *BluemixServiceInstancePutParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) SetBody(body *models.ServiceInstanceRequest) {
	o.Body = body
}

// WithInstanceID adds the instanceID to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) WithInstanceID(instanceID string) *BluemixServiceInstancePutParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the bluemix service instance put params
func (o *BluemixServiceInstancePutParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WriteToRequest writes these params to a swagger request
func (o *BluemixServiceInstancePutParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
