// Code generated by go-swagger; DO NOT EDIT.

package p_cloud_images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new p cloud images API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for p cloud images API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
PcloudCloudinstancesImagesDelete deletes an image from a cloud instance
*/
func (a *Client) PcloudCloudinstancesImagesDelete(params *PcloudCloudinstancesImagesDeleteParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesImagesDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesImagesDeleteParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.images.delete",
		Method:             "DELETE",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/images/{image_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesImagesDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesImagesDeleteOK), nil

}

/*
PcloudCloudinstancesImagesExportPost exports an image
*/
func (a *Client) PcloudCloudinstancesImagesExportPost(params *PcloudCloudinstancesImagesExportPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesImagesExportPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesImagesExportPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.images.export.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/images/{image_id}/export",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesImagesExportPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesImagesExportPostAccepted), nil

}

/*
PcloudCloudinstancesImagesGet detaileds info of an image
*/
func (a *Client) PcloudCloudinstancesImagesGet(params *PcloudCloudinstancesImagesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesImagesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesImagesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.images.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/images/{image_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesImagesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesImagesGetOK), nil

}

/*
PcloudCloudinstancesImagesGetall lists all images for this cloud instance
*/
func (a *Client) PcloudCloudinstancesImagesGetall(params *PcloudCloudinstancesImagesGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesImagesGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesImagesGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.images.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesImagesGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesImagesGetallOK), nil

}

/*
PcloudCloudinstancesImagesPost creates a new image from available images
*/
func (a *Client) PcloudCloudinstancesImagesPost(params *PcloudCloudinstancesImagesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesImagesPostOK, *PcloudCloudinstancesImagesPostCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesImagesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.images.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesImagesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *PcloudCloudinstancesImagesPostOK:
		return value, nil, nil
	case *PcloudCloudinstancesImagesPostCreated:
		return nil, value, nil
	}
	return nil, nil, nil

}

/*
PcloudCloudinstancesStockimagesGet detaileds info of an available stock image
*/
func (a *Client) PcloudCloudinstancesStockimagesGet(params *PcloudCloudinstancesStockimagesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesStockimagesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesStockimagesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.stockimages.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/stock-images/{image_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesStockimagesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesStockimagesGetOK), nil

}

/*
PcloudCloudinstancesStockimagesGetall lists all available stock images
*/
func (a *Client) PcloudCloudinstancesStockimagesGetall(params *PcloudCloudinstancesStockimagesGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudCloudinstancesStockimagesGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudCloudinstancesStockimagesGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.cloudinstances.stockimages.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/stock-images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudCloudinstancesStockimagesGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudCloudinstancesStockimagesGetallOK), nil

}

/*
PcloudImagesGet deprecateds for pcloud v1 cloud instances cloud instance id stock images image id detailed info of an available stock image
*/
func (a *Client) PcloudImagesGet(params *PcloudImagesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudImagesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudImagesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.images.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/images/{image_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudImagesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudImagesGetOK), nil

}

/*
PcloudImagesGetall deprecateds for pcloud v1 cloud instances cloud instance id stock images list all available stock images
*/
func (a *Client) PcloudImagesGetall(params *PcloudImagesGetallParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudImagesGetallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudImagesGetallParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.images.getall",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudImagesGetallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudImagesGetallOK), nil

}

/*
PcloudV1CloudinstancesCosimagesGet gets detail of last cos image import job
*/
func (a *Client) PcloudV1CloudinstancesCosimagesGet(params *PcloudV1CloudinstancesCosimagesGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV1CloudinstancesCosimagesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV1CloudinstancesCosimagesGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v1.cloudinstances.cosimages.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/cos-images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV1CloudinstancesCosimagesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV1CloudinstancesCosimagesGetOK), nil

}

/*
PcloudV1CloudinstancesCosimagesPost creates an cos image import job
*/
func (a *Client) PcloudV1CloudinstancesCosimagesPost(params *PcloudV1CloudinstancesCosimagesPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV1CloudinstancesCosimagesPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV1CloudinstancesCosimagesPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v1.cloudinstances.cosimages.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v1/cloud-instances/{cloud_instance_id}/cos-images",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV1CloudinstancesCosimagesPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV1CloudinstancesCosimagesPostAccepted), nil

}

/*
PcloudV2ImagesExportGet gets detail of last image export job
*/
func (a *Client) PcloudV2ImagesExportGet(params *PcloudV2ImagesExportGetParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2ImagesExportGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2ImagesExportGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.images.export.get",
		Method:             "GET",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2ImagesExportGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2ImagesExportGetOK), nil

}

/*
PcloudV2ImagesExportPost adds image export job to the jobs queue
*/
func (a *Client) PcloudV2ImagesExportPost(params *PcloudV2ImagesExportPostParams, authInfo runtime.ClientAuthInfoWriter) (*PcloudV2ImagesExportPostAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPcloudV2ImagesExportPostParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "pcloud.v2.images.export.post",
		Method:             "POST",
		PathPattern:        "/pcloud/v2/cloud-instances/{cloud_instance_id}/images/{image_id}/export",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PcloudV2ImagesExportPostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PcloudV2ImagesExportPostAccepted), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
