// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPSecPolicy IPSec Policy object
// swagger:model IPSecPolicy
type IPSecPolicy struct {

	// authentication
	// Required: true
	Authentication IPSECPolicyAuthentication `json:"authentication"`

	// Diffie-Hellman group
	// Required: true
	// Enum: [1 2 5 14 19 20 24]
	DhGroup *int64 `json:"dhGroup"`

	// connection encryption policy
	// Required: true
	// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-192-gcm aes-256-cbc aes-256-gcm des-cbc]
	Encryption *string `json:"encryption"`

	// unique identifier of the IPSec Policy
	// Required: true
	ID *string `json:"id"`

	// key lifetime
	// Required: true
	KeyLifetime KeyLifetime `json:"keyLifetime"`

	// IPSec Policy name
	// Required: true
	Name *string `json:"name"`

	// Perfect Forward Secrecy
	// Required: true
	Pfs *bool `json:"pfs"`
}

// Validate validates this IP sec policy
func (m *IPSecPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyLifetime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePfs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPSecPolicy) validateAuthentication(formats strfmt.Registry) error {

	if err := m.Authentication.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("authentication")
		}
		return err
	}

	return nil
}

var ipSecPolicyTypeDhGroupPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2,5,14,19,20,24]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipSecPolicyTypeDhGroupPropEnum = append(ipSecPolicyTypeDhGroupPropEnum, v)
	}
}

// prop value enum
func (m *IPSecPolicy) validateDhGroupEnum(path, location string, value int64) error {
	if err := validate.Enum(path, location, value, ipSecPolicyTypeDhGroupPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IPSecPolicy) validateDhGroup(formats strfmt.Registry) error {

	if err := validate.Required("dhGroup", "body", m.DhGroup); err != nil {
		return err
	}

	// value enum
	if err := m.validateDhGroupEnum("dhGroup", "body", *m.DhGroup); err != nil {
		return err
	}

	return nil
}

var ipSecPolicyTypeEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["3des-cbc","aes-128-cbc","aes-128-gcm","aes-192-cbc","aes-192-gcm","aes-256-cbc","aes-256-gcm","des-cbc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipSecPolicyTypeEncryptionPropEnum = append(ipSecPolicyTypeEncryptionPropEnum, v)
	}
}

const (

	// IPSecPolicyEncryptionNr3desCbc captures enum value "3des-cbc"
	IPSecPolicyEncryptionNr3desCbc string = "3des-cbc"

	// IPSecPolicyEncryptionAes128Cbc captures enum value "aes-128-cbc"
	IPSecPolicyEncryptionAes128Cbc string = "aes-128-cbc"

	// IPSecPolicyEncryptionAes128Gcm captures enum value "aes-128-gcm"
	IPSecPolicyEncryptionAes128Gcm string = "aes-128-gcm"

	// IPSecPolicyEncryptionAes192Cbc captures enum value "aes-192-cbc"
	IPSecPolicyEncryptionAes192Cbc string = "aes-192-cbc"

	// IPSecPolicyEncryptionAes192Gcm captures enum value "aes-192-gcm"
	IPSecPolicyEncryptionAes192Gcm string = "aes-192-gcm"

	// IPSecPolicyEncryptionAes256Cbc captures enum value "aes-256-cbc"
	IPSecPolicyEncryptionAes256Cbc string = "aes-256-cbc"

	// IPSecPolicyEncryptionAes256Gcm captures enum value "aes-256-gcm"
	IPSecPolicyEncryptionAes256Gcm string = "aes-256-gcm"

	// IPSecPolicyEncryptionDesCbc captures enum value "des-cbc"
	IPSecPolicyEncryptionDesCbc string = "des-cbc"
)

// prop value enum
func (m *IPSecPolicy) validateEncryptionEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, ipSecPolicyTypeEncryptionPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IPSecPolicy) validateEncryption(formats strfmt.Registry) error {

	if err := validate.Required("encryption", "body", m.Encryption); err != nil {
		return err
	}

	// value enum
	if err := m.validateEncryptionEnum("encryption", "body", *m.Encryption); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicy) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicy) validateKeyLifetime(formats strfmt.Registry) error {

	if err := m.KeyLifetime.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("keyLifetime")
		}
		return err
	}

	return nil
}

func (m *IPSecPolicy) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicy) validatePfs(formats strfmt.Registry) error {

	if err := validate.Required("pfs", "body", m.Pfs); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPSecPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPSecPolicy) UnmarshalBinary(b []byte) error {
	var res IPSecPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
