// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServiceBindingRequest service binding request
// swagger:model ServiceBindingRequest
type ServiceBindingRequest struct {

	// app guid
	AppGUID string `json:"app_guid,omitempty"`

	// bind resource
	BindResource *ServiceBindingResourceObject `json:"bind_resource,omitempty"`

	// context
	Context Context `json:"context,omitempty"`

	// parameters
	Parameters Object `json:"parameters,omitempty"`

	// plan id
	// Required: true
	PlanID *string `json:"plan_id"`

	// service id
	// Required: true
	ServiceID *string `json:"service_id"`
}

// Validate validates this service binding request
func (m *ServiceBindingRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBindResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlanID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceBindingRequest) validateBindResource(formats strfmt.Registry) error {

	if swag.IsZero(m.BindResource) { // not required
		return nil
	}

	if m.BindResource != nil {
		if err := m.BindResource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("bind_resource")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceBindingRequest) validatePlanID(formats strfmt.Registry) error {

	if err := validate.Required("plan_id", "body", m.PlanID); err != nil {
		return err
	}

	return nil
}

func (m *ServiceBindingRequest) validateServiceID(formats strfmt.Registry) error {

	if err := validate.Required("service_id", "body", m.ServiceID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceBindingRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceBindingRequest) UnmarshalBinary(b []byte) error {
	var res ServiceBindingRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
