// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServiceInstanceProvisionRequest service instance provision request
// swagger:model ServiceInstanceProvisionRequest
type ServiceInstanceProvisionRequest struct {

	// context
	Context Context `json:"context,omitempty"`

	// organization guid
	OrganizationGUID string `json:"organization_guid,omitempty"`

	// parameters
	Parameters Object `json:"parameters,omitempty"`

	// plan id
	// Required: true
	PlanID *string `json:"plan_id"`

	// service id
	// Required: true
	ServiceID *string `json:"service_id"`

	// space guid
	SpaceGUID string `json:"space_guid,omitempty"`
}

// Validate validates this service instance provision request
func (m *ServiceInstanceProvisionRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePlanID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceInstanceProvisionRequest) validatePlanID(formats strfmt.Registry) error {

	if err := validate.Required("plan_id", "body", m.PlanID); err != nil {
		return err
	}

	return nil
}

func (m *ServiceInstanceProvisionRequest) validateServiceID(formats strfmt.Registry) error {

	if err := validate.Required("service_id", "body", m.ServiceID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceInstanceProvisionRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceInstanceProvisionRequest) UnmarshalBinary(b []byte) error {
	var res ServiceInstanceProvisionRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
