// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageAffinity storage affinity
// swagger:model StorageAffinity
type StorageAffinity struct {

	// PVM Instance (ID or Name) to base storage affinity policy against; required if requesting storage affinity and affinityVolume is not provided
	AffinityPVMInstance *string `json:"affinityPVMInstance,omitempty"`

	// Affinity policy for storage pool selection; ignored if storagePool provided; for policy 'affinity' requires one of affinityPVMInstance or affinityVolume to be specified; for policy 'anti-affinity' requires one of antiAffinityPVMInstances or antiAffinityVolumes to be specified
	// Enum: [affinity anti-affinity]
	AffinityPolicy *string `json:"affinityPolicy,omitempty"`

	// Volume (ID or Name) to base storage affinity policy against; required if requesting storage affinity and affinityPVMInstance is not provided
	AffinityVolume *string `json:"affinityVolume,omitempty"`

	// List of pvmInstances to base storage anti-affinity policy against; required if requesting storage anti-affinity and antiAffinityVolumes is not provided
	AntiAffinityPVMInstances []string `json:"antiAffinityPVMInstances"`

	// List of volumes to base storage anti-affinity policy against; required if requesting storage anti-affinity and antiAffinityPVMInstances is not provided
	AntiAffinityVolumes []string `json:"antiAffinityVolumes"`
}

// Validate validates this storage affinity
func (m *StorageAffinity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAffinityPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageAffinityTypeAffinityPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["affinity","anti-affinity"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageAffinityTypeAffinityPolicyPropEnum = append(storageAffinityTypeAffinityPolicyPropEnum, v)
	}
}

const (

	// StorageAffinityAffinityPolicyAffinity captures enum value "affinity"
	StorageAffinityAffinityPolicyAffinity string = "affinity"

	// StorageAffinityAffinityPolicyAntiAffinity captures enum value "anti-affinity"
	StorageAffinityAffinityPolicyAntiAffinity string = "anti-affinity"
)

// prop value enum
func (m *StorageAffinity) validateAffinityPolicyEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, storageAffinityTypeAffinityPolicyPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *StorageAffinity) validateAffinityPolicy(formats strfmt.Registry) error {

	if swag.IsZero(m.AffinityPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateAffinityPolicyEnum("affinityPolicy", "body", *m.AffinityPolicy); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAffinity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAffinity) UnmarshalBinary(b []byte) error {
	var res StorageAffinity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
