// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
)

// SystemPool Hardware platform detailing its limits and statistics
// swagger:model SystemPool
type SystemPool struct {

	// Advertised capacity cores and memory (GB)
	Capacity *System `json:"capacity,omitempty"`

	// Processor to Memory (GB) Ratio
	CoreMemoryRatio float64 `json:"coreMemoryRatio,omitempty"`

	// Maximum configurable cores and memory (GB) (aggregated from all hosts)
	MaxAvailable *System `json:"maxAvailable,omitempty"`

	// Maximum configurable cores available combined with available memory of that host
	MaxCoresAvailable *System `json:"maxCoresAvailable,omitempty"`

	// Maximum configurable memory available combined with available cores of that host
	MaxMemoryAvailable *System `json:"maxMemoryAvailable,omitempty"`

	// min-max-default allocation percentage of shared core per vCPU
	SharedCoreRatio *MinMaxDefault `json:"sharedCoreRatio,omitempty"`

	// The DataCenter list of servers and their available resources
	Systems []*System `json:"systems"`

	// Type of system hardware
	Type string `json:"type,omitempty"`
}

// Validate validates this system pool
func (m *SystemPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxAvailable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxCoresAvailable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxMemoryAvailable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSharedCoreRatio(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystems(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SystemPool) validateCapacity(formats strfmt.Registry) error {

	if swag.IsZero(m.Capacity) { // not required
		return nil
	}

	if m.Capacity != nil {
		if err := m.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *SystemPool) validateMaxAvailable(formats strfmt.Registry) error {

	if swag.IsZero(m.MaxAvailable) { // not required
		return nil
	}

	if m.MaxAvailable != nil {
		if err := m.MaxAvailable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maxAvailable")
			}
			return err
		}
	}

	return nil
}

func (m *SystemPool) validateMaxCoresAvailable(formats strfmt.Registry) error {

	if swag.IsZero(m.MaxCoresAvailable) { // not required
		return nil
	}

	if m.MaxCoresAvailable != nil {
		if err := m.MaxCoresAvailable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maxCoresAvailable")
			}
			return err
		}
	}

	return nil
}

func (m *SystemPool) validateMaxMemoryAvailable(formats strfmt.Registry) error {

	if swag.IsZero(m.MaxMemoryAvailable) { // not required
		return nil
	}

	if m.MaxMemoryAvailable != nil {
		if err := m.MaxMemoryAvailable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maxMemoryAvailable")
			}
			return err
		}
	}

	return nil
}

func (m *SystemPool) validateSharedCoreRatio(formats strfmt.Registry) error {

	if swag.IsZero(m.SharedCoreRatio) { // not required
		return nil
	}

	if m.SharedCoreRatio != nil {
		if err := m.SharedCoreRatio.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sharedCoreRatio")
			}
			return err
		}
	}

	return nil
}

func (m *SystemPool) validateSystems(formats strfmt.Registry) error {

	if swag.IsZero(m.Systems) { // not required
		return nil
	}

	for i := 0; i < len(m.Systems); i++ {
		if swag.IsZero(m.Systems[i]) { // not required
			continue
		}

		if m.Systems[i] != nil {
			if err := m.Systems[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systems" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SystemPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SystemPool) UnmarshalBinary(b []byte) error {
	var res SystemPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
