// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/admin/v1alpha/analytics_admin.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for GetAccount RPC.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account to lookup.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{0}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccounts RPC.
type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccounts` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Accounts in the
	// results. Accounts can be inspected to determine whether they are deleted or
	// not.
	ShowDeleted bool `protobuf:"varint,3,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{1}
}

func (x *ListAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccountsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Request message for ListAccounts RPC.
type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{2}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteAccount RPC.
type DeleteAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Account to soft-delete.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountRequest) Reset() {
	*x = DeleteAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountRequest) ProtoMessage() {}

func (x *DeleteAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAccount RPC.
type UpdateAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to update.
	// The account's `name` field is used to identify the account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountRequest) Reset() {
	*x = UpdateAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountRequest) ProtoMessage() {}

func (x *UpdateAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAccountRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateAccountRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account to create.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Redirect URI where the user will be sent after accepting Terms of Service.
	// Must be configured in Developers Console as a Redirect URI
	RedirectUri string `protobuf:"bytes,2,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *ProvisionAccountTicketRequest) Reset() {
	*x = ProvisionAccountTicketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketRequest) ProtoMessage() {}

func (x *ProvisionAccountTicketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketRequest.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{5}
}

func (x *ProvisionAccountTicketRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ProvisionAccountTicketRequest) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Response message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The param to be passed in the ToS link.
	AccountTicketId string `protobuf:"bytes,1,opt,name=account_ticket_id,json=accountTicketId,proto3" json:"account_ticket_id,omitempty"`
}

func (x *ProvisionAccountTicketResponse) Reset() {
	*x = ProvisionAccountTicketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketResponse) ProtoMessage() {}

func (x *ProvisionAccountTicketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketResponse.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ProvisionAccountTicketResponse) GetAccountTicketId() string {
	if x != nil {
		return x.AccountTicketId
	}
	return ""
}

// Request message for GetProperty RPC.
type GetPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to lookup.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPropertyRequest) Reset() {
	*x = GetPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPropertyRequest) ProtoMessage() {}

func (x *GetPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPropertyRequest.ProtoReflect.Descriptor instead.
func (*GetPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{7}
}

func (x *GetPropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListProperties RPC.
type ListPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An expression for filtering the results of the request.
	// Fields eligible for filtering are:
	// `parent:`(The resource name of the parent account) or
	// `firebase_project:`(The id or number of the linked firebase project).
	// Some examples of filters:
	//
	// ```
	// | Filter                      | Description                               |
	// |-----------------------------|-------------------------------------------|
	// | parent:accounts/123         | The account with account id: 123.         |
	// | firebase_project:project-id | The firebase project with id: project-id. |
	// | firebase_project:123        | The firebase project with number: 123.    |
	// ```
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListProperties` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Properties in the
	// results. Properties can be inspected to determine whether they are deleted
	// or not.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPropertiesRequest) Reset() {
	*x = ListPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesRequest) ProtoMessage() {}

func (x *ListPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesRequest.ProtoReflect.Descriptor instead.
func (*ListPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{8}
}

func (x *ListPropertiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPropertiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPropertiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPropertiesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListProperties RPC.
type ListPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPropertiesResponse) Reset() {
	*x = ListPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesResponse) ProtoMessage() {}

func (x *ListPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesResponse.ProtoReflect.Descriptor instead.
func (*ListPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{9}
}

func (x *ListPropertiesResponse) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ListPropertiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateProperty RPC.
type UpdatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to update.
	// The property's `name` field is used to identify the property to be
	// updated.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePropertyRequest) Reset() {
	*x = UpdatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePropertyRequest) ProtoMessage() {}

func (x *UpdatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePropertyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{10}
}

func (x *UpdatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *UpdatePropertyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateProperty RPC.
type CreatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to create.
	// Note: the supplied property must specify its parent.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *CreatePropertyRequest) Reset() {
	*x = CreatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePropertyRequest) ProtoMessage() {}

func (x *CreatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePropertyRequest.ProtoReflect.Descriptor instead.
func (*CreatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{11}
}

func (x *CreatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

// Request message for DeleteProperty RPC.
type DeletePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Property to soft-delete.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePropertyRequest) Reset() {
	*x = DeletePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePropertyRequest) ProtoMessage() {}

func (x *DeletePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePropertyRequest.ProtoReflect.Descriptor instead.
func (*DeletePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{12}
}

func (x *DeletePropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetUserLink RPC.
type GetUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetUserLinkRequest) Reset() {
	*x = GetUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserLinkRequest) ProtoMessage() {}

func (x *GetUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{13}
}

func (x *GetUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchGetUserLinks RPC.
type BatchGetUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all provided values for the 'names' field must match
	// this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the user links to retrieve.
	// A maximum of 1000 user links can be retrieved in a batch.
	// Format: accounts/{accountId}/userLinks/{userLinkId}
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetUserLinksRequest) Reset() {
	*x = BatchGetUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksRequest) ProtoMessage() {}

func (x *BatchGetUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{14}
}

func (x *BatchGetUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetUserLinksRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for BatchGetUserLinks RPC.
type BatchGetUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested user links.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchGetUserLinksResponse) Reset() {
	*x = BatchGetUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetUserLinksResponse) ProtoMessage() {}

func (x *BatchGetUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchGetUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{15}
}

func (x *BatchGetUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for ListUserLinks RPC.
type ListUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 200 user links will be returned.
	// The maximum value is 500; values above 500 will be coerced to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUserLinksRequest) Reset() {
	*x = ListUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksRequest) ProtoMessage() {}

func (x *ListUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{16}
}

func (x *ListUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListUserLinks RPC.
type ListUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of UserLinks. These will be ordered stably, but in an arbitrary order.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListUserLinksResponse) Reset() {
	*x = ListUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserLinksResponse) ProtoMessage() {}

func (x *ListUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{17}
}

func (x *ListUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *ListUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AuditUserLinks RPC.
type AuditUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of user links to return.
	// The service may return fewer than this value.
	// If unspecified, at most 1000 user links will be returned.
	// The maximum value is 5000; values above 5000 will be coerced to 5000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `AuditUserLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `AuditUserLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AuditUserLinksRequest) Reset() {
	*x = AuditUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksRequest) ProtoMessage() {}

func (x *AuditUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksRequest.ProtoReflect.Descriptor instead.
func (*AuditUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{18}
}

func (x *AuditUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AuditUserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *AuditUserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for AuditUserLinks RPC.
type AuditUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AuditUserLinks. These will be ordered stably, but in an arbitrary
	// order.
	UserLinks []*AuditUserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AuditUserLinksResponse) Reset() {
	*x = AuditUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLinksResponse) ProtoMessage() {}

func (x *AuditUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLinksResponse.ProtoReflect.Descriptor instead.
func (*AuditUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{19}
}

func (x *AuditUserLinksResponse) GetUserLinks() []*AuditUserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

func (x *AuditUserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateUserLink RPC.
//
// Users can have multiple email addresses associated with their Google
// account, and one of these email addresses is the "primary" email address.
// Any of the email addresses associated with a Google account may be used
// for a new UserLink, but the returned UserLink will always contain the
// "primary" email address. As a result, the input and output email address
// for this request may differ.
type CreateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set, then email the new user notifying them that they've been granted
	// permissions to the resource.
	NotifyNewUser bool `protobuf:"varint,2,opt,name=notify_new_user,json=notifyNewUser,proto3" json:"notify_new_user,omitempty"`
	// Required. The user link to create.
	UserLink *UserLink `protobuf:"bytes,3,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *CreateUserLinkRequest) Reset() {
	*x = CreateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserLinkRequest) ProtoMessage() {}

func (x *CreateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{20}
}

func (x *CreateUserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateUserLinkRequest) GetNotifyNewUser() bool {
	if x != nil {
		return x.NotifyNewUser
	}
	return false
}

func (x *CreateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are for.
	// This field is required. The parent field in the CreateUserLinkRequest
	// messages must either be empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set, then email the new users notifying them that they've been granted
	// permissions to the resource. Regardless of whether this is set or not,
	// notify_new_user field inside each individual request is ignored.
	NotifyNewUsers bool `protobuf:"varint,2,opt,name=notify_new_users,json=notifyNewUsers,proto3" json:"notify_new_users,omitempty"`
	// Required. The requests specifying the user links to create.
	// A maximum of 1000 user links can be created in a batch.
	Requests []*CreateUserLinkRequest `protobuf:"bytes,3,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateUserLinksRequest) Reset() {
	*x = BatchCreateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksRequest) ProtoMessage() {}

func (x *BatchCreateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{21}
}

func (x *BatchCreateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateUserLinksRequest) GetNotifyNewUsers() bool {
	if x != nil {
		return x.NotifyNewUsers
	}
	return false
}

func (x *BatchCreateUserLinksRequest) GetRequests() []*CreateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateUserLinks RPC.
type BatchCreateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links created.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchCreateUserLinksResponse) Reset() {
	*x = BatchCreateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateUserLinksResponse) ProtoMessage() {}

func (x *BatchCreateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{22}
}

func (x *BatchCreateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for UpdateUserLink RPC.
type UpdateUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user link to update.
	UserLink *UserLink `protobuf:"bytes,1,opt,name=user_link,json=userLink,proto3" json:"user_link,omitempty"`
}

func (x *UpdateUserLinkRequest) Reset() {
	*x = UpdateUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserLinkRequest) ProtoMessage() {}

func (x *UpdateUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateUserLinkRequest) GetUserLink() *UserLink {
	if x != nil {
		return x.UserLink
	}
	return nil
}

// Request message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent field in the UpdateUserLinkRequest messages must either be
	// empty or match this field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*UpdateUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateUserLinksRequest) Reset() {
	*x = BatchUpdateUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksRequest) ProtoMessage() {}

func (x *BatchUpdateUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{24}
}

func (x *BatchUpdateUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateUserLinksRequest) GetRequests() []*UpdateUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchUpdateUserLinks RPC.
type BatchUpdateUserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user links updated.
	UserLinks []*UserLink `protobuf:"bytes,1,rep,name=user_links,json=userLinks,proto3" json:"user_links,omitempty"`
}

func (x *BatchUpdateUserLinksResponse) Reset() {
	*x = BatchUpdateUserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateUserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateUserLinksResponse) ProtoMessage() {}

func (x *BatchUpdateUserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateUserLinksResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateUserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{25}
}

func (x *BatchUpdateUserLinksResponse) GetUserLinks() []*UserLink {
	if x != nil {
		return x.UserLinks
	}
	return nil
}

// Request message for DeleteUserLink RPC.
type DeleteUserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: accounts/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteUserLinkRequest) Reset() {
	*x = DeleteUserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserLinkRequest) ProtoMessage() {}

func (x *DeleteUserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteUserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteUserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchDeleteUserLinks RPC.
type BatchDeleteUserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that all user links in the request are
	// for. The parent of all values for user link names to delete must match this
	// field.
	// Example format: accounts/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*DeleteUserLinkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchDeleteUserLinksRequest) Reset() {
	*x = BatchDeleteUserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteUserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteUserLinksRequest) ProtoMessage() {}

func (x *BatchDeleteUserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteUserLinksRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteUserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{27}
}

func (x *BatchDeleteUserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteUserLinksRequest) GetRequests() []*DeleteUserLinkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request message for GetWebDataStream RPC.
type GetWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the web data stream to lookup.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/123/webDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWebDataStreamRequest) Reset() {
	*x = GetWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWebDataStreamRequest) ProtoMessage() {}

func (x *GetWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{28}
}

func (x *GetWebDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteWebDataStream RPC.
type DeleteWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the web data stream to delete.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/123/webDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWebDataStreamRequest) Reset() {
	*x = DeleteWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWebDataStreamRequest) ProtoMessage() {}

func (x *DeleteWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteWebDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateWebDataStream RPC.
type UpdateWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The web stream to update.
	// The `name` field is used to identify the web stream to be updated.
	WebDataStream *WebDataStream `protobuf:"bytes,1,opt,name=web_data_stream,json=webDataStream,proto3" json:"web_data_stream,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWebDataStreamRequest) Reset() {
	*x = UpdateWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWebDataStreamRequest) ProtoMessage() {}

func (x *UpdateWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateWebDataStreamRequest) GetWebDataStream() *WebDataStream {
	if x != nil {
		return x.WebDataStream
	}
	return nil
}

func (x *UpdateWebDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateWebDataStream RPC.
type CreateWebDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The web stream to create.
	WebDataStream *WebDataStream `protobuf:"bytes,1,opt,name=web_data_stream,json=webDataStream,proto3" json:"web_data_stream,omitempty"`
	// Required. The parent resource where this web data stream will be created.
	// Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateWebDataStreamRequest) Reset() {
	*x = CreateWebDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWebDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWebDataStreamRequest) ProtoMessage() {}

func (x *CreateWebDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWebDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateWebDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{31}
}

func (x *CreateWebDataStreamRequest) GetWebDataStream() *WebDataStream {
	if x != nil {
		return x.WebDataStream
	}
	return nil
}

func (x *CreateWebDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for ListWebDataStreams RPC.
type ListWebDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to list results of web streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListWebDataStreams` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListWebDataStreams` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWebDataStreamsRequest) Reset() {
	*x = ListWebDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWebDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebDataStreamsRequest) ProtoMessage() {}

func (x *ListWebDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListWebDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{32}
}

func (x *ListWebDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWebDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWebDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListWebDataStreams RPC.
type ListWebDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	WebDataStreams []*WebDataStream `protobuf:"bytes,1,rep,name=web_data_streams,json=webDataStreams,proto3" json:"web_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWebDataStreamsResponse) Reset() {
	*x = ListWebDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWebDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebDataStreamsResponse) ProtoMessage() {}

func (x *ListWebDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListWebDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{33}
}

func (x *ListWebDataStreamsResponse) GetWebDataStreams() []*WebDataStream {
	if x != nil {
		return x.WebDataStreams
	}
	return nil
}

func (x *ListWebDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetIosAppDataStream RPC.
type GetIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the iOS app data stream to lookup.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/123/iosAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIosAppDataStreamRequest) Reset() {
	*x = GetIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIosAppDataStreamRequest) ProtoMessage() {}

func (x *GetIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{34}
}

func (x *GetIosAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteIosAppDataStream RPC.
type DeleteIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the iOS app data stream to delete.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/123/iosAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIosAppDataStreamRequest) Reset() {
	*x = DeleteIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIosAppDataStreamRequest) ProtoMessage() {}

func (x *DeleteIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteIosAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateIosAppDataStream RPC.
type UpdateIosAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The iOS app stream to update.
	// The `name` field is used to identify the iOS app stream to be updated.
	IosAppDataStream *IosAppDataStream `protobuf:"bytes,1,opt,name=ios_app_data_stream,json=iosAppDataStream,proto3" json:"ios_app_data_stream,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIosAppDataStreamRequest) Reset() {
	*x = UpdateIosAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIosAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIosAppDataStreamRequest) ProtoMessage() {}

func (x *UpdateIosAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIosAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateIosAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateIosAppDataStreamRequest) GetIosAppDataStream() *IosAppDataStream {
	if x != nil {
		return x.IosAppDataStream
	}
	return nil
}

func (x *UpdateIosAppDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListIosAppDataStreams RPC.
type ListIosAppDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to list results of app streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListIosAppDataStreams`
	// call. Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListIosAppDataStreams`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIosAppDataStreamsRequest) Reset() {
	*x = ListIosAppDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIosAppDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIosAppDataStreamsRequest) ProtoMessage() {}

func (x *ListIosAppDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIosAppDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListIosAppDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{37}
}

func (x *ListIosAppDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIosAppDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIosAppDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListIosAppDataStreams RPC.
type ListIosAppDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	IosAppDataStreams []*IosAppDataStream `protobuf:"bytes,1,rep,name=ios_app_data_streams,json=iosAppDataStreams,proto3" json:"ios_app_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIosAppDataStreamsResponse) Reset() {
	*x = ListIosAppDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIosAppDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIosAppDataStreamsResponse) ProtoMessage() {}

func (x *ListIosAppDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIosAppDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListIosAppDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{38}
}

func (x *ListIosAppDataStreamsResponse) GetIosAppDataStreams() []*IosAppDataStream {
	if x != nil {
		return x.IosAppDataStreams
	}
	return nil
}

func (x *ListIosAppDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetAndroidAppDataStream RPC.
type GetAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the android app data stream to lookup.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/123/androidAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAndroidAppDataStreamRequest) Reset() {
	*x = GetAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *GetAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{39}
}

func (x *GetAndroidAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteAndroidAppDataStream RPC.
type DeleteAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the android app data stream to delete.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/123/androidAppDataStreams/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAndroidAppDataStreamRequest) Reset() {
	*x = DeleteAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *DeleteAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{40}
}

func (x *DeleteAndroidAppDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAndroidAppDataStream RPC.
type UpdateAndroidAppDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The android app stream to update.
	// The `name` field is used to identify the android app stream to be updated.
	AndroidAppDataStream *AndroidAppDataStream `protobuf:"bytes,1,opt,name=android_app_data_stream,json=androidAppDataStream,proto3" json:"android_app_data_stream,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAndroidAppDataStreamRequest) Reset() {
	*x = UpdateAndroidAppDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAndroidAppDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAndroidAppDataStreamRequest) ProtoMessage() {}

func (x *UpdateAndroidAppDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAndroidAppDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateAndroidAppDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{41}
}

func (x *UpdateAndroidAppDataStreamRequest) GetAndroidAppDataStream() *AndroidAppDataStream {
	if x != nil {
		return x.AndroidAppDataStream
	}
	return nil
}

func (x *UpdateAndroidAppDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListAndroidAppDataStreams RPC.
type ListAndroidAppDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent property.
	// For example, to limit results to app streams under the property with Id
	// 123: "properties/123"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	//
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous call. Provide this to
	// retrieve the subsequent page.
	// When paginating, all other parameters provided to
	// `ListAndroidAppDataStreams` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAndroidAppDataStreamsRequest) Reset() {
	*x = ListAndroidAppDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAndroidAppDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndroidAppDataStreamsRequest) ProtoMessage() {}

func (x *ListAndroidAppDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndroidAppDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListAndroidAppDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{42}
}

func (x *ListAndroidAppDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAndroidAppDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAndroidAppDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListAndroidDataStreams RPC.
type ListAndroidAppDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	AndroidAppDataStreams []*AndroidAppDataStream `protobuf:"bytes,1,rep,name=android_app_data_streams,json=androidAppDataStreams,proto3" json:"android_app_data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAndroidAppDataStreamsResponse) Reset() {
	*x = ListAndroidAppDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAndroidAppDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndroidAppDataStreamsResponse) ProtoMessage() {}

func (x *ListAndroidAppDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndroidAppDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListAndroidAppDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{43}
}

func (x *ListAndroidAppDataStreamsResponse) GetAndroidAppDataStreams() []*AndroidAppDataStream {
	if x != nil {
		return x.AndroidAppDataStreams
	}
	return nil
}

func (x *ListAndroidAppDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetEnhancedMeasurementSettings RPC.
type GetEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings
	// Example: "properties/1000/webDataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEnhancedMeasurementSettingsRequest) Reset() {
	*x = GetEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *GetEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{44}
}

func (x *GetEnhancedMeasurementSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateEnhancedMeasurementSettings RPC.
type UpdateEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	EnhancedMeasurementSettings *EnhancedMeasurementSettings `protobuf:"bytes,1,opt,name=enhanced_measurement_settings,json=enhancedMeasurementSettings,proto3" json:"enhanced_measurement_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEnhancedMeasurementSettingsRequest) Reset() {
	*x = UpdateEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *UpdateEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{45}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetEnhancedMeasurementSettings() *EnhancedMeasurementSettings {
	if x != nil {
		return x.EnhancedMeasurementSettings
	}
	return nil
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateFirebaseLink RPC
type CreateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Firebase link to create.
	FirebaseLink *FirebaseLink `protobuf:"bytes,2,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
}

func (x *CreateFirebaseLinkRequest) Reset() {
	*x = CreateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFirebaseLinkRequest) ProtoMessage() {}

func (x *CreateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{46}
}

func (x *CreateFirebaseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

// Request message for DeleteFirebaseLink RPC
type DeleteFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
	// Example: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFirebaseLinkRequest) Reset() {
	*x = DeleteFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFirebaseLinkRequest) ProtoMessage() {}

func (x *DeleteFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{47}
}

func (x *DeleteFirebaseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListFirebaseLinks RPC
type ListFirebaseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListFirebaseLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFirebaseLinksRequest) Reset() {
	*x = ListFirebaseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksRequest) ProtoMessage() {}

func (x *ListFirebaseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{48}
}

func (x *ListFirebaseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFirebaseLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFirebaseLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListFirebaseLinks RPC
type ListFirebaseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*FirebaseLink `protobuf:"bytes,1,rep,name=firebase_links,json=firebaseLinks,proto3" json:"firebase_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one FirebaseLink per property,
	// so this will never be populated.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFirebaseLinksResponse) Reset() {
	*x = ListFirebaseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksResponse) ProtoMessage() {}

func (x *ListFirebaseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{49}
}

func (x *ListFirebaseLinksResponse) GetFirebaseLinks() []*FirebaseLink {
	if x != nil {
		return x.FirebaseLinks
	}
	return nil
}

func (x *ListFirebaseLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGlobalSiteTag RPC.
type GetGlobalSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the site tag to lookup.
	// Note that site tags are singletons and do not have unique IDs.
	// Format: properties/{property_id}/webDataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/webDataStreams/456/globalSiteTag"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlobalSiteTagRequest) Reset() {
	*x = GetGlobalSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlobalSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlobalSiteTagRequest) ProtoMessage() {}

func (x *GetGlobalSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlobalSiteTagRequest.ProtoReflect.Descriptor instead.
func (*GetGlobalSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{50}
}

func (x *GetGlobalSiteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateGoogleAdsLink RPC
type CreateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The GoogleAdsLink to create.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,2,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
}

func (x *CreateGoogleAdsLinkRequest) Reset() {
	*x = CreateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *CreateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{51}
}

func (x *CreateGoogleAdsLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

// Request message for UpdateGoogleAdsLink RPC
type UpdateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GoogleAdsLink to update
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,1,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleAdsLinkRequest) Reset() {
	*x = UpdateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *UpdateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{52}
}

func (x *UpdateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *UpdateGoogleAdsLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteGoogleAdsLink RPC.
type DeleteGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/googleAdsLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGoogleAdsLinkRequest) Reset() {
	*x = DeleteGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGoogleAdsLinkRequest) ProtoMessage() {}

func (x *DeleteGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{53}
}

func (x *DeleteGoogleAdsLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListGoogleAdsLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGoogleAdsLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGoogleAdsLinksRequest) Reset() {
	*x = ListGoogleAdsLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksRequest) ProtoMessage() {}

func (x *ListGoogleAdsLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{54}
}

func (x *ListGoogleAdsLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGoogleAdsLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGoogleAdsLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAdsLink `protobuf:"bytes,1,rep,name=google_ads_links,json=googleAdsLinks,proto3" json:"google_ads_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGoogleAdsLinksResponse) Reset() {
	*x = ListGoogleAdsLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksResponse) ProtoMessage() {}

func (x *ListGoogleAdsLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{55}
}

func (x *ListGoogleAdsLinksResponse) GetGoogleAdsLinks() []*GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLinks
	}
	return nil
}

func (x *ListGoogleAdsLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataSharingSettings RPC.
type GetDataSharingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSharingSettingsRequest) Reset() {
	*x = GetDataSharingSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSharingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSharingSettingsRequest) ProtoMessage() {}

func (x *GetDataSharingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSharingSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataSharingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{56}
}

func (x *GetDataSharingSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccountSummaries RPC.
type ListAccountSummariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of AccountSummary resources to return. The service may
	// return fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccountSummaries` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccountSummaries`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountSummariesRequest) Reset() {
	*x = ListAccountSummariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesRequest) ProtoMessage() {}

func (x *ListAccountSummariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesRequest.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{57}
}

func (x *ListAccountSummariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountSummariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAccountSummaries RPC.
type ListAccountSummariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Account summaries of all accounts the caller has access to.
	AccountSummaries []*AccountSummary `protobuf:"bytes,1,rep,name=account_summaries,json=accountSummaries,proto3" json:"account_summaries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountSummariesResponse) Reset() {
	*x = ListAccountSummariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesResponse) ProtoMessage() {}

func (x *ListAccountSummariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesResponse.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{58}
}

func (x *ListAccountSummariesResponse) GetAccountSummaries() []*AccountSummary {
	if x != nil {
		return x.AccountSummaries
	}
	return nil
}

func (x *ListAccountSummariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SearchChangeHistoryEvents RPC.
type SearchChangeHistoryEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account resource for which to return change history resources.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Resource name for a child property. If set, only return changes
	// made to this property or its child resources.
	Property string `protobuf:"bytes,2,opt,name=property,proto3" json:"property,omitempty"`
	// Optional. If set, only return changes if they are for a resource that matches at
	// least one of these types.
	ResourceType []ChangeHistoryResourceType `protobuf:"varint,3,rep,packed,name=resource_type,json=resourceType,proto3,enum=google.analytics.admin.v1alpha.ChangeHistoryResourceType" json:"resource_type,omitempty"`
	// Optional. If set, only return changes that match one or more of these types of
	// actions.
	Action []ActionType `protobuf:"varint,4,rep,packed,name=action,proto3,enum=google.analytics.admin.v1alpha.ActionType" json:"action,omitempty"`
	// Optional. If set, only return changes if they are made by a user in this list.
	ActorEmail []string `protobuf:"bytes,5,rep,name=actor_email,json=actorEmail,proto3" json:"actor_email,omitempty"`
	// Optional. If set, only return changes made after this time (inclusive).
	EarliestChangeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=earliest_change_time,json=earliestChangeTime,proto3" json:"earliest_change_time,omitempty"`
	// Optional. If set, only return changes made before this time (inclusive).
	LatestChangeTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_change_time,json=latestChangeTime,proto3" json:"latest_change_time,omitempty"`
	// Optional. The maximum number of ChangeHistoryEvent items to return.
	// The service may return fewer than this value, even if there are additional
	// pages. If unspecified, at most 50 items will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `SearchChangeHistoryEvents` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `SearchChangeHistoryEvents` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,9,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsRequest) Reset() {
	*x = SearchChangeHistoryEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsRequest) ProtoMessage() {}

func (x *SearchChangeHistoryEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsRequest.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{59}
}

func (x *SearchChangeHistoryEventsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetResourceType() []ChangeHistoryResourceType {
	if x != nil {
		return x.ResourceType
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetAction() []ActionType {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetActorEmail() []string {
	if x != nil {
		return x.ActorEmail
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetEarliestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetLatestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchChangeHistoryEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SearchAccounts RPC.
type SearchChangeHistoryEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	ChangeHistoryEvents []*ChangeHistoryEvent `protobuf:"bytes,1,rep,name=change_history_events,json=changeHistoryEvents,proto3" json:"change_history_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsResponse) Reset() {
	*x = SearchChangeHistoryEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsResponse) ProtoMessage() {}

func (x *SearchChangeHistoryEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsResponse.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{60}
}

func (x *SearchChangeHistoryEventsResponse) GetChangeHistoryEvents() []*ChangeHistoryEvent {
	if x != nil {
		return x.ChangeHistoryEvents
	}
	return nil
}

func (x *SearchChangeHistoryEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetMeasurementProtocolSecret RPC.
type GetMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the measurement protocol secret to lookup.
	// Format:
	// properties/{property}/webDataStreams/{webDataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	// Note: Any type of stream (WebDataStream, IosAppDataStream,
	// AndroidAppDataStream) may be a parent.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMeasurementProtocolSecretRequest) Reset() {
	*x = GetMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *GetMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*GetMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{61}
}

func (x *GetMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateMeasurementProtocolSecret RPC
type CreateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this secret will be created.
	// Any type of stream (WebDataStream, IosAppDataStream, AndroidAppDataStream)
	// may be a parent.
	// Format: properties/{property}/webDataStreams/{webDataStream}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The measurement protocol secret to create.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,2,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
}

func (x *CreateMeasurementProtocolSecretRequest) Reset() {
	*x = CreateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *CreateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*CreateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{62}
}

func (x *CreateMeasurementProtocolSecretRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

// Request message for DeleteMeasurementProtocolSecret RPC
type DeleteMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MeasurementProtocolSecret to delete.
	// Format:
	// properties/{property}/webDataStreams/{webDataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	// Note: Any type of stream (WebDataStream, IosAppDataStream,
	// AndroidAppDataStream) may be a parent.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMeasurementProtocolSecretRequest) Reset() {
	*x = DeleteMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *DeleteMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*DeleteMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{63}
}

func (x *DeleteMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateMeasurementProtocolSecret RPC
type UpdateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The measurement protocol secret to update.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,1,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMeasurementProtocolSecretRequest) Reset() {
	*x = UpdateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *UpdateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*UpdateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{64}
}

func (x *UpdateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

func (x *UpdateMeasurementProtocolSecretRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent stream.
	// Any type of stream (WebDataStream, IosAppDataStream, AndroidAppDataStream)
	// may be a parent.
	// Format:
	// properties/{property}/webDataStreams/{webDataStream}/measurementProtocolSecrets
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 10 resources will be returned.
	// The maximum value is 10. Higher values will be coerced to the maximum.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMeasurementProtocolSecrets`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `ListMeasurementProtocolSecrets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsRequest) Reset() {
	*x = ListMeasurementProtocolSecretsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsRequest) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsRequest.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{65}
}

func (x *ListMeasurementProtocolSecretsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of secrets for the parent stream specified in the request.
	MeasurementProtocolSecrets []*MeasurementProtocolSecret `protobuf:"bytes,1,rep,name=measurement_protocol_secrets,json=measurementProtocolSecrets,proto3" json:"measurement_protocol_secrets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsResponse) Reset() {
	*x = ListMeasurementProtocolSecretsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsResponse) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsResponse.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{66}
}

func (x *ListMeasurementProtocolSecretsResponse) GetMeasurementProtocolSecrets() []*MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecrets
	}
	return nil
}

func (x *ListMeasurementProtocolSecretsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGoogleSignalsSettings RPC
type GetGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the google signals settings to retrieve.
	// Format: properties/{property}/googleSignalsSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGoogleSignalsSettingsRequest) Reset() {
	*x = GetGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *GetGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{67}
}

func (x *GetGoogleSignalsSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateGoogleSignalsSettings RPC
type UpdateGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	GoogleSignalsSettings *GoogleSignalsSettings `protobuf:"bytes,1,opt,name=google_signals_settings,json=googleSignalsSettings,proto3" json:"google_signals_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleSignalsSettingsRequest) Reset() {
	*x = UpdateGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *UpdateGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{68}
}

func (x *UpdateGoogleSignalsSettingsRequest) GetGoogleSignalsSettings() *GoogleSignalsSettings {
	if x != nil {
		return x.GoogleSignalsSettings
	}
	return nil
}

func (x *UpdateGoogleSignalsSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateConversionEvent RPC
type CreateConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversion event to create.
	ConversionEvent *ConversionEvent `protobuf:"bytes,1,opt,name=conversion_event,json=conversionEvent,proto3" json:"conversion_event,omitempty"`
	// Required. The resource name of the parent property where this conversion event will
	// be created. Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateConversionEventRequest) Reset() {
	*x = CreateConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionEventRequest) ProtoMessage() {}

func (x *CreateConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionEventRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{69}
}

func (x *CreateConversionEventRequest) GetConversionEvent() *ConversionEvent {
	if x != nil {
		return x.ConversionEvent
	}
	return nil
}

func (x *CreateConversionEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for GetConversionEvent RPC
type GetConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to retrieve.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionEventRequest) Reset() {
	*x = GetConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionEventRequest) ProtoMessage() {}

func (x *GetConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionEventRequest.ProtoReflect.Descriptor instead.
func (*GetConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{70}
}

func (x *GetConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteConversionEvent RPC
type DeleteConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to delete.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversionEventRequest) Reset() {
	*x = DeleteConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionEventRequest) ProtoMessage() {}

func (x *DeleteConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionEventRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{71}
}

func (x *DeleteConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListConversionEvents RPC
type ListConversionEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent property.
	// Example: 'properties/123'
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConversionEvents` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListConversionEvents`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversionEventsRequest) Reset() {
	*x = ListConversionEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsRequest) ProtoMessage() {}

func (x *ListConversionEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsRequest.ProtoReflect.Descriptor instead.
func (*ListConversionEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{72}
}

func (x *ListConversionEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListConversionEvents RPC.
type ListConversionEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested conversion events
	ConversionEvents []*ConversionEvent `protobuf:"bytes,1,rep,name=conversion_events,json=conversionEvents,proto3" json:"conversion_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversionEventsResponse) Reset() {
	*x = ListConversionEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsResponse) ProtoMessage() {}

func (x *ListConversionEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsResponse.ProtoReflect.Descriptor instead.
func (*ListConversionEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{73}
}

func (x *ListConversionEventsResponse) GetConversionEvents() []*ConversionEvent {
	if x != nil {
		return x.ConversionEvents
	}
	return nil
}

func (x *ListConversionEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDisplayVideo360AdvertiserLink RPC.
type GetDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to get.
	// Example format: properties/1234/displayVideo360AdvertiserLink/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{74}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDisplayVideo360AdvertiserLinks`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinks` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{75}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinks.
	DisplayVideo_360AdvertiserLinks []*DisplayVideo360AdvertiserLink `protobuf:"bytes,1,rep,name=display_video_360_advertiser_links,json=displayVideo360AdvertiserLinks,proto3" json:"display_video_360_advertiser_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{76}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetDisplayVideo_360AdvertiserLinks() []*DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinks
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLink RPC.
type CreateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLink to create.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{77}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLink RPC.
type DeleteDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{78}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDisplayVideo360AdvertiserLink RPC.
type UpdateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink to update
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = UpdateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{79}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDisplayVideo360AdvertiserLinkProposal RPC.
type GetDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{80}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve
	// the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{81}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinkProposals.
	DisplayVideo_360AdvertiserLinkProposals []*DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,1,rep,name=display_video_360_advertiser_link_proposals,json=displayVideo360AdvertiserLinkProposals,proto3" json:"display_video_360_advertiser_link_proposals,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{82}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetDisplayVideo_360AdvertiserLinkProposals() []*DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposals
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLinkProposal RPC.
type CreateDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLinkProposal to create.
	DisplayVideo_360AdvertiserLinkProposal *DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link_proposal,json=displayVideo360AdvertiserLinkProposal,proto3" json:"display_video_360_advertiser_link_proposal,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{83}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetDisplayVideo_360AdvertiserLinkProposal() *DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposal
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLinkProposal RPC.
type DeleteDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{84}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{85}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink created as a result of approving the
	// proposal.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalResponse.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{86}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for CancelDisplayVideo360AdvertiserLinkProposal RPC.
type CancelDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CancelDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{87}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomDimension RPC.
type CreateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomDimension to create.
	CustomDimension *CustomDimension `protobuf:"bytes,2,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
}

func (x *CreateCustomDimensionRequest) Reset() {
	*x = CreateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomDimensionRequest) ProtoMessage() {}

func (x *CreateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{88}
}

func (x *CreateCustomDimensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

// Request message for UpdateCustomDimension RPC.
type UpdateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomDimension to update
	CustomDimension *CustomDimension `protobuf:"bytes,1,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomDimensionRequest) Reset() {
	*x = UpdateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomDimensionRequest) ProtoMessage() {}

func (x *UpdateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{89}
}

func (x *UpdateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

func (x *UpdateCustomDimensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomDimensions RPC.
type ListCustomDimensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomDimensions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomDimensions`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomDimensionsRequest) Reset() {
	*x = ListCustomDimensionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsRequest) ProtoMessage() {}

func (x *ListCustomDimensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{90}
}

func (x *ListCustomDimensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomDimensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomDimensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomDimensions RPC.
type ListCustomDimensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomDimensions.
	CustomDimensions []*CustomDimension `protobuf:"bytes,1,rep,name=custom_dimensions,json=customDimensions,proto3" json:"custom_dimensions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomDimensionsResponse) Reset() {
	*x = ListCustomDimensionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsResponse) ProtoMessage() {}

func (x *ListCustomDimensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{91}
}

func (x *ListCustomDimensionsResponse) GetCustomDimensions() []*CustomDimension {
	if x != nil {
		return x.CustomDimensions
	}
	return nil
}

func (x *ListCustomDimensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomDimension RPC.
type ArchiveCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to archive.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomDimensionRequest) Reset() {
	*x = ArchiveCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomDimensionRequest) ProtoMessage() {}

func (x *ArchiveCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{92}
}

func (x *ArchiveCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomDimension RPC.
type GetCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to get.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomDimensionRequest) Reset() {
	*x = GetCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomDimensionRequest) ProtoMessage() {}

func (x *GetCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*GetCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{93}
}

func (x *GetCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomMetric RPC.
type CreateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomMetric to create.
	CustomMetric *CustomMetric `protobuf:"bytes,2,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
}

func (x *CreateCustomMetricRequest) Reset() {
	*x = CreateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomMetricRequest) ProtoMessage() {}

func (x *CreateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{94}
}

func (x *CreateCustomMetricRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

// Request message for UpdateCustomMetric RPC.
type UpdateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomMetric to update
	CustomMetric *CustomMetric `protobuf:"bytes,1,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomMetricRequest) Reset() {
	*x = UpdateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomMetricRequest) ProtoMessage() {}

func (x *UpdateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{95}
}

func (x *UpdateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

func (x *UpdateCustomMetricRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomMetrics RPC.
type ListCustomMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomMetrics` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomMetrics` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomMetricsRequest) Reset() {
	*x = ListCustomMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsRequest) ProtoMessage() {}

func (x *ListCustomMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{96}
}

func (x *ListCustomMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomMetrics RPC.
type ListCustomMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomMetrics.
	CustomMetrics []*CustomMetric `protobuf:"bytes,1,rep,name=custom_metrics,json=customMetrics,proto3" json:"custom_metrics,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomMetricsResponse) Reset() {
	*x = ListCustomMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsResponse) ProtoMessage() {}

func (x *ListCustomMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{97}
}

func (x *ListCustomMetricsResponse) GetCustomMetrics() []*CustomMetric {
	if x != nil {
		return x.CustomMetrics
	}
	return nil
}

func (x *ListCustomMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomMetric RPC.
type ArchiveCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to archive.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomMetricRequest) Reset() {
	*x = ArchiveCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomMetricRequest) ProtoMessage() {}

func (x *ArchiveCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{98}
}

func (x *ArchiveCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomMetric RPC.
type GetCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to get.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomMetricRequest) Reset() {
	*x = GetCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomMetricRequest) ProtoMessage() {}

func (x *GetCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*GetCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{99}
}

func (x *GetCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetDataRetentionSettings RPC.
type GetDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataRetentionSettings
	// Example: "properties/1000/dataRetentionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataRetentionSettingsRequest) Reset() {
	*x = GetDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataRetentionSettingsRequest) ProtoMessage() {}

func (x *GetDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{100}
}

func (x *GetDataRetentionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataRetentionSettings RPC.
type UpdateDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	DataRetentionSettings *DataRetentionSettings `protobuf:"bytes,1,opt,name=data_retention_settings,json=dataRetentionSettings,proto3" json:"data_retention_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataRetentionSettingsRequest) Reset() {
	*x = UpdateDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataRetentionSettingsRequest) ProtoMessage() {}

func (x *UpdateDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{101}
}

func (x *UpdateDataRetentionSettingsRequest) GetDataRetentionSettings() *DataRetentionSettings {
	if x != nil {
		return x.DataRetentionSettings
	}
	return nil
}

func (x *UpdateDataRetentionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_analytics_admin_v1alpha_analytics_admin_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x43, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x08, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a,
	0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x85, 0x01, 0x0a, 0x1d,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x55, 0x72, 0x69, 0x22, 0x4c, 0x0a, 0x1e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x49,
	0x64, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4,
	0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x62, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x5b, 0x0a, 0x15, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa8, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x19, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x15, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x16, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd8, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79,
	0x4e, 0x65, 0x77, 0x55, 0x73, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0xec, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x79, 0x4e, 0x65, 0x77, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x22, 0x67, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x63, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x22, 0xbd, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x22, 0x67, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x47, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x5b, 0x0a, 0x15, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x62, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x1a, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65,
	0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5a, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x77,
	0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc5,
	0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a,
	0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xa4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x57,
	0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x10,
	0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x68, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x30, 0x0a, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f,
	0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x64, 0x0a, 0x13, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70,
	0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x69, 0x6f, 0x73, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xaa,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a,
	0x14, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x11, 0x69,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x70, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x41,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34,
	0x0a, 0x32, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x73, 0x0a, 0x21, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xd7, 0x01, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x70, 0x0a, 0x17, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x14, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb2, 0x01, 0x0a, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba,
	0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6d, 0x0a, 0x18, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x15, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7e, 0x0a, 0x25, 0x47,
	0x65, 0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x41, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x0a, 0x39, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3, 0x01, 0x0a, 0x28,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x1d, 0x65, 0x6e, 0x68,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x1b, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x63, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x62, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53,
	0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc5, 0x01, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64,
	0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x1a,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf3, 0x04, 0x0a, 0x20,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x51, 0x0a, 0x14, 0x65, 0x61, 0x72,
	0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65,
	0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xb3, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7a, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7e, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x7d, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x01, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x7e, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbc,
	0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39,
	0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01,
	0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x1c, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x1a, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x72, 0x0a,
	0x1f, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xda, 0x01, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x72, 0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xce,
	0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x5f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22,
	0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x69, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01,
	0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c,
	0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x27, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x29, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x12,
	0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xe0, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x89, 0x01, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x1e, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x98, 0x02, 0x0a, 0x2a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x12, 0x3b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x8c, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x85,
	0x01, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf8, 0x01, 0x0a, 0x2a, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x87, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x92, 0x01, 0x0a, 0x2f, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x31, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x45, 0x12, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x02,
	0x0a, 0x32, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x2b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x26, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xc1, 0x02, 0x0a, 0x32, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45,
	0x12, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa5, 0x01,
	0x0a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x25,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x95, 0x01, 0x0a, 0x32, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01,
	0x0a, 0x33, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x34, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x87, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x95, 0x01, 0x0a, 0x32, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xce, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a,
	0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0xb0, 0x01, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0c, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa2, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x53, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64, 0x0a, 0x1a,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x60, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x22, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x72, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xa2, 0x9a, 0x01, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x93, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x29, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x94, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x12, 0x11, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x88, 0x01,
	0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x32, 0x22, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda, 0x41,
	0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xcc, 0x01, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74,
	0x3a, 0x01, 0x2a, 0x12, 0xb4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12,
	0x19, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x0b, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e,
	0x12, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12,
	0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f,
	0x22, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda,
	0x41, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x9e, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x0e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22,
	0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x32, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x14, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12,
	0xce, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x54, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x12,
	0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xf6, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x66, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x12, 0xe1, 0x01, 0x0a, 0x0d, 0x4c, 0x69,
	0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54,
	0x12, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x5a, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xed, 0x01,
	0x0a, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x61, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xf7, 0x01,
	0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5a, 0x35, 0x22,
	0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x8b, 0x02, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x84, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x7e, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5a,
	0x3f, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0xda, 0x41, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x8b, 0x02, 0x0a,
	0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a,
	0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xc2, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x54, 0x2a, 0x26, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x2a, 0x28,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xe5, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x78, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xb8, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x57,
	0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xa7, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x65, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf6, 0x01, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x1b, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xe1, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x3a,
	0x0f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0xcb, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12,
	0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc4, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49,
	0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x3f, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb0,
	0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x8f, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6f, 0x73,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x83, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x13, 0x69, 0x6f,
	0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0xda, 0x41, 0x1f, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x12, 0xd7, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6f, 0x73, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd4, 0x01,
	0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22,
	0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbc, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x43,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xab, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x93, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x67, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x17, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x23, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xe7, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70,
	0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xfe, 0x01, 0x0a, 0x1e,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe8, 0x02, 0x0a,
	0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e,
	0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xbb, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x88, 0x01, 0x32, 0x67, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x65,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x1d, 0x65, 0x6e,
	0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x29, 0x65, 0x6e,
	0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22,
	0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0d, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x14, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0xa4, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xc6, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe1, 0x01,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x12, 0xf6, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x3d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61,
	0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa7, 0x01, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0xcb, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xa1, 0x03, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x22, 0x80, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01, 0x12, 0x4a, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x53, 0x12, 0x51, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x03, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01,
	0x12, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x5a, 0x4f, 0x12, 0x4d,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f,
	0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x5a, 0x53, 0x12,
	0x51, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9c, 0x04, 0x0a, 0x1f,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x22, 0xf5, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc9, 0x02, 0x22, 0x4a, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x5a, 0x6c, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5a, 0x70, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x84, 0x03, 0x0a, 0x1f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x80,
	0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4f, 0x2a, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x53, 0x2a, 0x51, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf7, 0x04, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0xd0, 0x03, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x9f, 0x03, 0x32, 0x66, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5a, 0x88, 0x01, 0x32, 0x69, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5a, 0x8c, 0x01, 0x32, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0xda, 0x41, 0x27, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xe4, 0x01, 0x0a, 0x19,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a,
	0x01, 0x2a, 0x12, 0xd5, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12,
	0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xac, 0x02, 0x0a, 0x1b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x32, 0x4a,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0xda, 0x41, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x10, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xad, 0x01, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xf8, 0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x4c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8b, 0x02, 0x0a, 0x22,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc6, 0x02, 0x0a, 0x23, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x93, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x62, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x28, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33,
	0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x12, 0xd7, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xee, 0x02, 0x0a,
	0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0xbb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x01, 0x32, 0x5f, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x21, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x2d,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36,
	0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x98, 0x02,
	0x0a, 0x28, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xab, 0x02, 0x0a, 0x2a, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x52, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf8, 0x02, 0x0a, 0x2b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x22, 0xad, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x73, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x73, 0x3a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0xda, 0x41, 0x31,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x12, 0xef, 0x01, 0x0a, 0x2b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x54, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x47, 0x2a, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xb3, 0x02, 0x0a, 0x2c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x12, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xa1, 0x02, 0x0a, 0x2b, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x22, 0x4c, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0x12, 0xeb, 0x01,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x2f,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x81, 0x02, 0x0a, 0x15,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x32, 0x40, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x10,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12,
	0xd3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xba, 0x01, 0x0a, 0x16, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22,
	0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x2c, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x0d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0xec, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0xda, 0x41, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0xc7, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb1, 0x01, 0x0a, 0x13, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x22, 0x34,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xac, 0x02,
	0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x65, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x23, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x1a, 0xfc, 0x01, 0xca,
	0x41, 0x1d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0xd8, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x65, 0x64, 0x69,
	0x74, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e,
	0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x80, 0x01, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x42, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 102)
var file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = []interface{}{
	(*GetAccountRequest)(nil),                                    // 0: google.analytics.admin.v1alpha.GetAccountRequest
	(*ListAccountsRequest)(nil),                                  // 1: google.analytics.admin.v1alpha.ListAccountsRequest
	(*ListAccountsResponse)(nil),                                 // 2: google.analytics.admin.v1alpha.ListAccountsResponse
	(*DeleteAccountRequest)(nil),                                 // 3: google.analytics.admin.v1alpha.DeleteAccountRequest
	(*UpdateAccountRequest)(nil),                                 // 4: google.analytics.admin.v1alpha.UpdateAccountRequest
	(*ProvisionAccountTicketRequest)(nil),                        // 5: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	(*ProvisionAccountTicketResponse)(nil),                       // 6: google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	(*GetPropertyRequest)(nil),                                   // 7: google.analytics.admin.v1alpha.GetPropertyRequest
	(*ListPropertiesRequest)(nil),                                // 8: google.analytics.admin.v1alpha.ListPropertiesRequest
	(*ListPropertiesResponse)(nil),                               // 9: google.analytics.admin.v1alpha.ListPropertiesResponse
	(*UpdatePropertyRequest)(nil),                                // 10: google.analytics.admin.v1alpha.UpdatePropertyRequest
	(*CreatePropertyRequest)(nil),                                // 11: google.analytics.admin.v1alpha.CreatePropertyRequest
	(*DeletePropertyRequest)(nil),                                // 12: google.analytics.admin.v1alpha.DeletePropertyRequest
	(*GetUserLinkRequest)(nil),                                   // 13: google.analytics.admin.v1alpha.GetUserLinkRequest
	(*BatchGetUserLinksRequest)(nil),                             // 14: google.analytics.admin.v1alpha.BatchGetUserLinksRequest
	(*BatchGetUserLinksResponse)(nil),                            // 15: google.analytics.admin.v1alpha.BatchGetUserLinksResponse
	(*ListUserLinksRequest)(nil),                                 // 16: google.analytics.admin.v1alpha.ListUserLinksRequest
	(*ListUserLinksResponse)(nil),                                // 17: google.analytics.admin.v1alpha.ListUserLinksResponse
	(*AuditUserLinksRequest)(nil),                                // 18: google.analytics.admin.v1alpha.AuditUserLinksRequest
	(*AuditUserLinksResponse)(nil),                               // 19: google.analytics.admin.v1alpha.AuditUserLinksResponse
	(*CreateUserLinkRequest)(nil),                                // 20: google.analytics.admin.v1alpha.CreateUserLinkRequest
	(*BatchCreateUserLinksRequest)(nil),                          // 21: google.analytics.admin.v1alpha.BatchCreateUserLinksRequest
	(*BatchCreateUserLinksResponse)(nil),                         // 22: google.analytics.admin.v1alpha.BatchCreateUserLinksResponse
	(*UpdateUserLinkRequest)(nil),                                // 23: google.analytics.admin.v1alpha.UpdateUserLinkRequest
	(*BatchUpdateUserLinksRequest)(nil),                          // 24: google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest
	(*BatchUpdateUserLinksResponse)(nil),                         // 25: google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse
	(*DeleteUserLinkRequest)(nil),                                // 26: google.analytics.admin.v1alpha.DeleteUserLinkRequest
	(*BatchDeleteUserLinksRequest)(nil),                          // 27: google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest
	(*GetWebDataStreamRequest)(nil),                              // 28: google.analytics.admin.v1alpha.GetWebDataStreamRequest
	(*DeleteWebDataStreamRequest)(nil),                           // 29: google.analytics.admin.v1alpha.DeleteWebDataStreamRequest
	(*UpdateWebDataStreamRequest)(nil),                           // 30: google.analytics.admin.v1alpha.UpdateWebDataStreamRequest
	(*CreateWebDataStreamRequest)(nil),                           // 31: google.analytics.admin.v1alpha.CreateWebDataStreamRequest
	(*ListWebDataStreamsRequest)(nil),                            // 32: google.analytics.admin.v1alpha.ListWebDataStreamsRequest
	(*ListWebDataStreamsResponse)(nil),                           // 33: google.analytics.admin.v1alpha.ListWebDataStreamsResponse
	(*GetIosAppDataStreamRequest)(nil),                           // 34: google.analytics.admin.v1alpha.GetIosAppDataStreamRequest
	(*DeleteIosAppDataStreamRequest)(nil),                        // 35: google.analytics.admin.v1alpha.DeleteIosAppDataStreamRequest
	(*UpdateIosAppDataStreamRequest)(nil),                        // 36: google.analytics.admin.v1alpha.UpdateIosAppDataStreamRequest
	(*ListIosAppDataStreamsRequest)(nil),                         // 37: google.analytics.admin.v1alpha.ListIosAppDataStreamsRequest
	(*ListIosAppDataStreamsResponse)(nil),                        // 38: google.analytics.admin.v1alpha.ListIosAppDataStreamsResponse
	(*GetAndroidAppDataStreamRequest)(nil),                       // 39: google.analytics.admin.v1alpha.GetAndroidAppDataStreamRequest
	(*DeleteAndroidAppDataStreamRequest)(nil),                    // 40: google.analytics.admin.v1alpha.DeleteAndroidAppDataStreamRequest
	(*UpdateAndroidAppDataStreamRequest)(nil),                    // 41: google.analytics.admin.v1alpha.UpdateAndroidAppDataStreamRequest
	(*ListAndroidAppDataStreamsRequest)(nil),                     // 42: google.analytics.admin.v1alpha.ListAndroidAppDataStreamsRequest
	(*ListAndroidAppDataStreamsResponse)(nil),                    // 43: google.analytics.admin.v1alpha.ListAndroidAppDataStreamsResponse
	(*GetEnhancedMeasurementSettingsRequest)(nil),                // 44: google.analytics.admin.v1alpha.GetEnhancedMeasurementSettingsRequest
	(*UpdateEnhancedMeasurementSettingsRequest)(nil),             // 45: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	(*CreateFirebaseLinkRequest)(nil),                            // 46: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	(*DeleteFirebaseLinkRequest)(nil),                            // 47: google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	(*ListFirebaseLinksRequest)(nil),                             // 48: google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	(*ListFirebaseLinksResponse)(nil),                            // 49: google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	(*GetGlobalSiteTagRequest)(nil),                              // 50: google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	(*CreateGoogleAdsLinkRequest)(nil),                           // 51: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	(*UpdateGoogleAdsLinkRequest)(nil),                           // 52: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	(*DeleteGoogleAdsLinkRequest)(nil),                           // 53: google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	(*ListGoogleAdsLinksRequest)(nil),                            // 54: google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	(*ListGoogleAdsLinksResponse)(nil),                           // 55: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	(*GetDataSharingSettingsRequest)(nil),                        // 56: google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	(*ListAccountSummariesRequest)(nil),                          // 57: google.analytics.admin.v1alpha.ListAccountSummariesRequest
	(*ListAccountSummariesResponse)(nil),                         // 58: google.analytics.admin.v1alpha.ListAccountSummariesResponse
	(*SearchChangeHistoryEventsRequest)(nil),                     // 59: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	(*SearchChangeHistoryEventsResponse)(nil),                    // 60: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	(*GetMeasurementProtocolSecretRequest)(nil),                  // 61: google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	(*CreateMeasurementProtocolSecretRequest)(nil),               // 62: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	(*DeleteMeasurementProtocolSecretRequest)(nil),               // 63: google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	(*UpdateMeasurementProtocolSecretRequest)(nil),               // 64: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	(*ListMeasurementProtocolSecretsRequest)(nil),                // 65: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	(*ListMeasurementProtocolSecretsResponse)(nil),               // 66: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	(*GetGoogleSignalsSettingsRequest)(nil),                      // 67: google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	(*UpdateGoogleSignalsSettingsRequest)(nil),                   // 68: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	(*CreateConversionEventRequest)(nil),                         // 69: google.analytics.admin.v1alpha.CreateConversionEventRequest
	(*GetConversionEventRequest)(nil),                            // 70: google.analytics.admin.v1alpha.GetConversionEventRequest
	(*DeleteConversionEventRequest)(nil),                         // 71: google.analytics.admin.v1alpha.DeleteConversionEventRequest
	(*ListConversionEventsRequest)(nil),                          // 72: google.analytics.admin.v1alpha.ListConversionEventsRequest
	(*ListConversionEventsResponse)(nil),                         // 73: google.analytics.admin.v1alpha.ListConversionEventsResponse
	(*GetDisplayVideo360AdvertiserLinkRequest)(nil),              // 74: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	(*ListDisplayVideo360AdvertiserLinksRequest)(nil),            // 75: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	(*ListDisplayVideo360AdvertiserLinksResponse)(nil),           // 76: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	(*CreateDisplayVideo360AdvertiserLinkRequest)(nil),           // 77: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	(*DeleteDisplayVideo360AdvertiserLinkRequest)(nil),           // 78: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	(*UpdateDisplayVideo360AdvertiserLinkRequest)(nil),           // 79: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	(*GetDisplayVideo360AdvertiserLinkProposalRequest)(nil),      // 80: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsRequest)(nil),    // 81: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsResponse)(nil),   // 82: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	(*CreateDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 83: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	(*DeleteDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 84: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalRequest)(nil),  // 85: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalResponse)(nil), // 86: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	(*CancelDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 87: google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	(*CreateCustomDimensionRequest)(nil),                         // 88: google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	(*UpdateCustomDimensionRequest)(nil),                         // 89: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	(*ListCustomDimensionsRequest)(nil),                          // 90: google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	(*ListCustomDimensionsResponse)(nil),                         // 91: google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	(*ArchiveCustomDimensionRequest)(nil),                        // 92: google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	(*GetCustomDimensionRequest)(nil),                            // 93: google.analytics.admin.v1alpha.GetCustomDimensionRequest
	(*CreateCustomMetricRequest)(nil),                            // 94: google.analytics.admin.v1alpha.CreateCustomMetricRequest
	(*UpdateCustomMetricRequest)(nil),                            // 95: google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	(*ListCustomMetricsRequest)(nil),                             // 96: google.analytics.admin.v1alpha.ListCustomMetricsRequest
	(*ListCustomMetricsResponse)(nil),                            // 97: google.analytics.admin.v1alpha.ListCustomMetricsResponse
	(*ArchiveCustomMetricRequest)(nil),                           // 98: google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	(*GetCustomMetricRequest)(nil),                               // 99: google.analytics.admin.v1alpha.GetCustomMetricRequest
	(*GetDataRetentionSettingsRequest)(nil),                      // 100: google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	(*UpdateDataRetentionSettingsRequest)(nil),                   // 101: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	(*Account)(nil),                                              // 102: google.analytics.admin.v1alpha.Account
	(*fieldmaskpb.FieldMask)(nil),                                // 103: google.protobuf.FieldMask
	(*Property)(nil),                                             // 104: google.analytics.admin.v1alpha.Property
	(*UserLink)(nil),                                             // 105: google.analytics.admin.v1alpha.UserLink
	(*AuditUserLink)(nil),                                        // 106: google.analytics.admin.v1alpha.AuditUserLink
	(*WebDataStream)(nil),                                        // 107: google.analytics.admin.v1alpha.WebDataStream
	(*IosAppDataStream)(nil),                                     // 108: google.analytics.admin.v1alpha.IosAppDataStream
	(*AndroidAppDataStream)(nil),                                 // 109: google.analytics.admin.v1alpha.AndroidAppDataStream
	(*EnhancedMeasurementSettings)(nil),                          // 110: google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	(*FirebaseLink)(nil),                                         // 111: google.analytics.admin.v1alpha.FirebaseLink
	(*GoogleAdsLink)(nil),                                        // 112: google.analytics.admin.v1alpha.GoogleAdsLink
	(*AccountSummary)(nil),                                       // 113: google.analytics.admin.v1alpha.AccountSummary
	(ChangeHistoryResourceType)(0),                               // 114: google.analytics.admin.v1alpha.ChangeHistoryResourceType
	(ActionType)(0),                                              // 115: google.analytics.admin.v1alpha.ActionType
	(*timestamppb.Timestamp)(nil),                                // 116: google.protobuf.Timestamp
	(*ChangeHistoryEvent)(nil),                                   // 117: google.analytics.admin.v1alpha.ChangeHistoryEvent
	(*MeasurementProtocolSecret)(nil),                            // 118: google.analytics.admin.v1alpha.MeasurementProtocolSecret
	(*GoogleSignalsSettings)(nil),                                // 119: google.analytics.admin.v1alpha.GoogleSignalsSettings
	(*ConversionEvent)(nil),                                      // 120: google.analytics.admin.v1alpha.ConversionEvent
	(*DisplayVideo360AdvertiserLink)(nil),                        // 121: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	(*DisplayVideo360AdvertiserLinkProposal)(nil),                // 122: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	(*CustomDimension)(nil),                                      // 123: google.analytics.admin.v1alpha.CustomDimension
	(*CustomMetric)(nil),                                         // 124: google.analytics.admin.v1alpha.CustomMetric
	(*DataRetentionSettings)(nil),                                // 125: google.analytics.admin.v1alpha.DataRetentionSettings
	(*emptypb.Empty)(nil),                                        // 126: google.protobuf.Empty
	(*GlobalSiteTag)(nil),                                        // 127: google.analytics.admin.v1alpha.GlobalSiteTag
	(*DataSharingSettings)(nil),                                  // 128: google.analytics.admin.v1alpha.DataSharingSettings
}
var file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = []int32{
	102, // 0: google.analytics.admin.v1alpha.ListAccountsResponse.accounts:type_name -> google.analytics.admin.v1alpha.Account
	102, // 1: google.analytics.admin.v1alpha.UpdateAccountRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	103, // 2: google.analytics.admin.v1alpha.UpdateAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	102, // 3: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	104, // 4: google.analytics.admin.v1alpha.ListPropertiesResponse.properties:type_name -> google.analytics.admin.v1alpha.Property
	104, // 5: google.analytics.admin.v1alpha.UpdatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	103, // 6: google.analytics.admin.v1alpha.UpdatePropertyRequest.update_mask:type_name -> google.protobuf.FieldMask
	104, // 7: google.analytics.admin.v1alpha.CreatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	105, // 8: google.analytics.admin.v1alpha.BatchGetUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	105, // 9: google.analytics.admin.v1alpha.ListUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	106, // 10: google.analytics.admin.v1alpha.AuditUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.AuditUserLink
	105, // 11: google.analytics.admin.v1alpha.CreateUserLinkRequest.user_link:type_name -> google.analytics.admin.v1alpha.UserLink
	20,  // 12: google.analytics.admin.v1alpha.BatchCreateUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.CreateUserLinkRequest
	105, // 13: google.analytics.admin.v1alpha.BatchCreateUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	105, // 14: google.analytics.admin.v1alpha.UpdateUserLinkRequest.user_link:type_name -> google.analytics.admin.v1alpha.UserLink
	23,  // 15: google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.UpdateUserLinkRequest
	105, // 16: google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse.user_links:type_name -> google.analytics.admin.v1alpha.UserLink
	26,  // 17: google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest.requests:type_name -> google.analytics.admin.v1alpha.DeleteUserLinkRequest
	107, // 18: google.analytics.admin.v1alpha.UpdateWebDataStreamRequest.web_data_stream:type_name -> google.analytics.admin.v1alpha.WebDataStream
	103, // 19: google.analytics.admin.v1alpha.UpdateWebDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	107, // 20: google.analytics.admin.v1alpha.CreateWebDataStreamRequest.web_data_stream:type_name -> google.analytics.admin.v1alpha.WebDataStream
	107, // 21: google.analytics.admin.v1alpha.ListWebDataStreamsResponse.web_data_streams:type_name -> google.analytics.admin.v1alpha.WebDataStream
	108, // 22: google.analytics.admin.v1alpha.UpdateIosAppDataStreamRequest.ios_app_data_stream:type_name -> google.analytics.admin.v1alpha.IosAppDataStream
	103, // 23: google.analytics.admin.v1alpha.UpdateIosAppDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	108, // 24: google.analytics.admin.v1alpha.ListIosAppDataStreamsResponse.ios_app_data_streams:type_name -> google.analytics.admin.v1alpha.IosAppDataStream
	109, // 25: google.analytics.admin.v1alpha.UpdateAndroidAppDataStreamRequest.android_app_data_stream:type_name -> google.analytics.admin.v1alpha.AndroidAppDataStream
	103, // 26: google.analytics.admin.v1alpha.UpdateAndroidAppDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	109, // 27: google.analytics.admin.v1alpha.ListAndroidAppDataStreamsResponse.android_app_data_streams:type_name -> google.analytics.admin.v1alpha.AndroidAppDataStream
	110, // 28: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest.enhanced_measurement_settings:type_name -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	103, // 29: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	111, // 30: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	111, // 31: google.analytics.admin.v1alpha.ListFirebaseLinksResponse.firebase_links:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	112, // 32: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	112, // 33: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	103, // 34: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	112, // 35: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse.google_ads_links:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	113, // 36: google.analytics.admin.v1alpha.ListAccountSummariesResponse.account_summaries:type_name -> google.analytics.admin.v1alpha.AccountSummary
	114, // 37: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.resource_type:type_name -> google.analytics.admin.v1alpha.ChangeHistoryResourceType
	115, // 38: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.action:type_name -> google.analytics.admin.v1alpha.ActionType
	116, // 39: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.earliest_change_time:type_name -> google.protobuf.Timestamp
	116, // 40: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.latest_change_time:type_name -> google.protobuf.Timestamp
	117, // 41: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse.change_history_events:type_name -> google.analytics.admin.v1alpha.ChangeHistoryEvent
	118, // 42: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	118, // 43: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	103, // 44: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.update_mask:type_name -> google.protobuf.FieldMask
	118, // 45: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse.measurement_protocol_secrets:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	119, // 46: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.google_signals_settings:type_name -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	103, // 47: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	120, // 48: google.analytics.admin.v1alpha.CreateConversionEventRequest.conversion_event:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	120, // 49: google.analytics.admin.v1alpha.ListConversionEventsResponse.conversion_events:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	121, // 50: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse.display_video_360_advertiser_links:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	121, // 51: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	121, // 52: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	103, // 53: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	122, // 54: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse.display_video_360_advertiser_link_proposals:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	122, // 55: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest.display_video_360_advertiser_link_proposal:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	121, // 56: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	123, // 57: google.analytics.admin.v1alpha.CreateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	123, // 58: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	103, // 59: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	123, // 60: google.analytics.admin.v1alpha.ListCustomDimensionsResponse.custom_dimensions:type_name -> google.analytics.admin.v1alpha.CustomDimension
	124, // 61: google.analytics.admin.v1alpha.CreateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	124, // 62: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	103, // 63: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.update_mask:type_name -> google.protobuf.FieldMask
	124, // 64: google.analytics.admin.v1alpha.ListCustomMetricsResponse.custom_metrics:type_name -> google.analytics.admin.v1alpha.CustomMetric
	125, // 65: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.data_retention_settings:type_name -> google.analytics.admin.v1alpha.DataRetentionSettings
	103, // 66: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,   // 67: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:input_type -> google.analytics.admin.v1alpha.GetAccountRequest
	1,   // 68: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:input_type -> google.analytics.admin.v1alpha.ListAccountsRequest
	3,   // 69: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:input_type -> google.analytics.admin.v1alpha.DeleteAccountRequest
	4,   // 70: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:input_type -> google.analytics.admin.v1alpha.UpdateAccountRequest
	5,   // 71: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:input_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	57,  // 72: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:input_type -> google.analytics.admin.v1alpha.ListAccountSummariesRequest
	7,   // 73: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:input_type -> google.analytics.admin.v1alpha.GetPropertyRequest
	8,   // 74: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:input_type -> google.analytics.admin.v1alpha.ListPropertiesRequest
	11,  // 75: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:input_type -> google.analytics.admin.v1alpha.CreatePropertyRequest
	12,  // 76: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:input_type -> google.analytics.admin.v1alpha.DeletePropertyRequest
	10,  // 77: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:input_type -> google.analytics.admin.v1alpha.UpdatePropertyRequest
	13,  // 78: google.analytics.admin.v1alpha.AnalyticsAdminService.GetUserLink:input_type -> google.analytics.admin.v1alpha.GetUserLinkRequest
	14,  // 79: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetUserLinks:input_type -> google.analytics.admin.v1alpha.BatchGetUserLinksRequest
	16,  // 80: google.analytics.admin.v1alpha.AnalyticsAdminService.ListUserLinks:input_type -> google.analytics.admin.v1alpha.ListUserLinksRequest
	18,  // 81: google.analytics.admin.v1alpha.AnalyticsAdminService.AuditUserLinks:input_type -> google.analytics.admin.v1alpha.AuditUserLinksRequest
	20,  // 82: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateUserLink:input_type -> google.analytics.admin.v1alpha.CreateUserLinkRequest
	21,  // 83: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateUserLinks:input_type -> google.analytics.admin.v1alpha.BatchCreateUserLinksRequest
	23,  // 84: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateUserLink:input_type -> google.analytics.admin.v1alpha.UpdateUserLinkRequest
	24,  // 85: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateUserLinks:input_type -> google.analytics.admin.v1alpha.BatchUpdateUserLinksRequest
	26,  // 86: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteUserLink:input_type -> google.analytics.admin.v1alpha.DeleteUserLinkRequest
	27,  // 87: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteUserLinks:input_type -> google.analytics.admin.v1alpha.BatchDeleteUserLinksRequest
	28,  // 88: google.analytics.admin.v1alpha.AnalyticsAdminService.GetWebDataStream:input_type -> google.analytics.admin.v1alpha.GetWebDataStreamRequest
	29,  // 89: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteWebDataStream:input_type -> google.analytics.admin.v1alpha.DeleteWebDataStreamRequest
	30,  // 90: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateWebDataStream:input_type -> google.analytics.admin.v1alpha.UpdateWebDataStreamRequest
	31,  // 91: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateWebDataStream:input_type -> google.analytics.admin.v1alpha.CreateWebDataStreamRequest
	32,  // 92: google.analytics.admin.v1alpha.AnalyticsAdminService.ListWebDataStreams:input_type -> google.analytics.admin.v1alpha.ListWebDataStreamsRequest
	34,  // 93: google.analytics.admin.v1alpha.AnalyticsAdminService.GetIosAppDataStream:input_type -> google.analytics.admin.v1alpha.GetIosAppDataStreamRequest
	35,  // 94: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteIosAppDataStream:input_type -> google.analytics.admin.v1alpha.DeleteIosAppDataStreamRequest
	36,  // 95: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateIosAppDataStream:input_type -> google.analytics.admin.v1alpha.UpdateIosAppDataStreamRequest
	37,  // 96: google.analytics.admin.v1alpha.AnalyticsAdminService.ListIosAppDataStreams:input_type -> google.analytics.admin.v1alpha.ListIosAppDataStreamsRequest
	39,  // 97: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAndroidAppDataStream:input_type -> google.analytics.admin.v1alpha.GetAndroidAppDataStreamRequest
	40,  // 98: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAndroidAppDataStream:input_type -> google.analytics.admin.v1alpha.DeleteAndroidAppDataStreamRequest
	41,  // 99: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAndroidAppDataStream:input_type -> google.analytics.admin.v1alpha.UpdateAndroidAppDataStreamRequest
	42,  // 100: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAndroidAppDataStreams:input_type -> google.analytics.admin.v1alpha.ListAndroidAppDataStreamsRequest
	44,  // 101: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEnhancedMeasurementSettings:input_type -> google.analytics.admin.v1alpha.GetEnhancedMeasurementSettingsRequest
	45,  // 102: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEnhancedMeasurementSettings:input_type -> google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	46,  // 103: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:input_type -> google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	47,  // 104: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:input_type -> google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	48,  // 105: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:input_type -> google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	50,  // 106: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:input_type -> google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	51,  // 107: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	52,  // 108: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	53,  // 109: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	54,  // 110: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:input_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	56,  // 111: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:input_type -> google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	61,  // 112: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	65,  // 113: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:input_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	62,  // 114: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	63,  // 115: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	64,  // 116: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	59,  // 117: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:input_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	67,  // 118: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	68,  // 119: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	69,  // 120: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:input_type -> google.analytics.admin.v1alpha.CreateConversionEventRequest
	70,  // 121: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:input_type -> google.analytics.admin.v1alpha.GetConversionEventRequest
	71,  // 122: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:input_type -> google.analytics.admin.v1alpha.DeleteConversionEventRequest
	72,  // 123: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:input_type -> google.analytics.admin.v1alpha.ListConversionEventsRequest
	74,  // 124: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	75,  // 125: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	77,  // 126: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	78,  // 127: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	79,  // 128: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	80,  // 129: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	81,  // 130: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	83,  // 131: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	84,  // 132: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	85,  // 133: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	87,  // 134: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	88,  // 135: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:input_type -> google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	89,  // 136: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:input_type -> google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	90,  // 137: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:input_type -> google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	92,  // 138: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:input_type -> google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	93,  // 139: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:input_type -> google.analytics.admin.v1alpha.GetCustomDimensionRequest
	94,  // 140: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:input_type -> google.analytics.admin.v1alpha.CreateCustomMetricRequest
	95,  // 141: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:input_type -> google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	96,  // 142: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:input_type -> google.analytics.admin.v1alpha.ListCustomMetricsRequest
	98,  // 143: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:input_type -> google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	99,  // 144: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:input_type -> google.analytics.admin.v1alpha.GetCustomMetricRequest
	100, // 145: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	101, // 146: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	102, // 147: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:output_type -> google.analytics.admin.v1alpha.Account
	2,   // 148: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:output_type -> google.analytics.admin.v1alpha.ListAccountsResponse
	126, // 149: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:output_type -> google.protobuf.Empty
	102, // 150: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:output_type -> google.analytics.admin.v1alpha.Account
	6,   // 151: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:output_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	58,  // 152: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:output_type -> google.analytics.admin.v1alpha.ListAccountSummariesResponse
	104, // 153: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:output_type -> google.analytics.admin.v1alpha.Property
	9,   // 154: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:output_type -> google.analytics.admin.v1alpha.ListPropertiesResponse
	104, // 155: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:output_type -> google.analytics.admin.v1alpha.Property
	104, // 156: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:output_type -> google.analytics.admin.v1alpha.Property
	104, // 157: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:output_type -> google.analytics.admin.v1alpha.Property
	105, // 158: google.analytics.admin.v1alpha.AnalyticsAdminService.GetUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	15,  // 159: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetUserLinks:output_type -> google.analytics.admin.v1alpha.BatchGetUserLinksResponse
	17,  // 160: google.analytics.admin.v1alpha.AnalyticsAdminService.ListUserLinks:output_type -> google.analytics.admin.v1alpha.ListUserLinksResponse
	19,  // 161: google.analytics.admin.v1alpha.AnalyticsAdminService.AuditUserLinks:output_type -> google.analytics.admin.v1alpha.AuditUserLinksResponse
	105, // 162: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	22,  // 163: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateUserLinks:output_type -> google.analytics.admin.v1alpha.BatchCreateUserLinksResponse
	105, // 164: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateUserLink:output_type -> google.analytics.admin.v1alpha.UserLink
	25,  // 165: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateUserLinks:output_type -> google.analytics.admin.v1alpha.BatchUpdateUserLinksResponse
	126, // 166: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteUserLink:output_type -> google.protobuf.Empty
	126, // 167: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteUserLinks:output_type -> google.protobuf.Empty
	107, // 168: google.analytics.admin.v1alpha.AnalyticsAdminService.GetWebDataStream:output_type -> google.analytics.admin.v1alpha.WebDataStream
	126, // 169: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteWebDataStream:output_type -> google.protobuf.Empty
	107, // 170: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateWebDataStream:output_type -> google.analytics.admin.v1alpha.WebDataStream
	107, // 171: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateWebDataStream:output_type -> google.analytics.admin.v1alpha.WebDataStream
	33,  // 172: google.analytics.admin.v1alpha.AnalyticsAdminService.ListWebDataStreams:output_type -> google.analytics.admin.v1alpha.ListWebDataStreamsResponse
	108, // 173: google.analytics.admin.v1alpha.AnalyticsAdminService.GetIosAppDataStream:output_type -> google.analytics.admin.v1alpha.IosAppDataStream
	126, // 174: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteIosAppDataStream:output_type -> google.protobuf.Empty
	108, // 175: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateIosAppDataStream:output_type -> google.analytics.admin.v1alpha.IosAppDataStream
	38,  // 176: google.analytics.admin.v1alpha.AnalyticsAdminService.ListIosAppDataStreams:output_type -> google.analytics.admin.v1alpha.ListIosAppDataStreamsResponse
	109, // 177: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAndroidAppDataStream:output_type -> google.analytics.admin.v1alpha.AndroidAppDataStream
	126, // 178: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAndroidAppDataStream:output_type -> google.protobuf.Empty
	109, // 179: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAndroidAppDataStream:output_type -> google.analytics.admin.v1alpha.AndroidAppDataStream
	43,  // 180: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAndroidAppDataStreams:output_type -> google.analytics.admin.v1alpha.ListAndroidAppDataStreamsResponse
	110, // 181: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEnhancedMeasurementSettings:output_type -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	110, // 182: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEnhancedMeasurementSettings:output_type -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	111, // 183: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:output_type -> google.analytics.admin.v1alpha.FirebaseLink
	126, // 184: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:output_type -> google.protobuf.Empty
	49,  // 185: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:output_type -> google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	127, // 186: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:output_type -> google.analytics.admin.v1alpha.GlobalSiteTag
	112, // 187: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	112, // 188: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	126, // 189: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:output_type -> google.protobuf.Empty
	55,  // 190: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:output_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	128, // 191: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:output_type -> google.analytics.admin.v1alpha.DataSharingSettings
	118, // 192: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	66,  // 193: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:output_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	118, // 194: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	126, // 195: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:output_type -> google.protobuf.Empty
	118, // 196: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	60,  // 197: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:output_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	119, // 198: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	119, // 199: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	120, // 200: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	120, // 201: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	126, // 202: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:output_type -> google.protobuf.Empty
	73,  // 203: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:output_type -> google.analytics.admin.v1alpha.ListConversionEventsResponse
	121, // 204: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	76,  // 205: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	121, // 206: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	126, // 207: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:output_type -> google.protobuf.Empty
	121, // 208: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	122, // 209: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	82,  // 210: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	122, // 211: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	126, // 212: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:output_type -> google.protobuf.Empty
	86,  // 213: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	122, // 214: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	123, // 215: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	123, // 216: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	91,  // 217: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:output_type -> google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	126, // 218: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:output_type -> google.protobuf.Empty
	123, // 219: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	124, // 220: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	124, // 221: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	97,  // 222: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:output_type -> google.analytics.admin.v1alpha.ListCustomMetricsResponse
	126, // 223: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:output_type -> google.protobuf.Empty
	124, // 224: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	125, // 225: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	125, // 226: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	147, // [147:227] is the sub-list for method output_type
	67,  // [67:147] is the sub-list for method input_type
	67,  // [67:67] is the sub-list for extension type_name
	67,  // [67:67] is the sub-list for extension extendee
	0,   // [0:67] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_analytics_admin_proto_init() }
func file_google_analytics_admin_v1alpha_analytics_admin_proto_init() {
	if File_google_analytics_admin_v1alpha_analytics_admin_proto != nil {
		return
	}
	file_google_analytics_admin_v1alpha_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateUserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteUserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteUserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWebDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWebDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWebDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIosAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIosAppDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIosAppDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAndroidAppDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAndroidAppDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAndroidAppDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlobalSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSharingSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   102,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs,
		MessageInfos:      file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_analytics_admin_proto = out.File
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsAdminServiceClient is the client API for AnalyticsAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsAdminServiceClient interface {
	// Lookup for a single Account.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single WebDataStream
	GetWebDataStream(ctx context.Context, in *GetWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Deletes a web stream on a property.
	DeleteWebDataStream(ctx context.Context, in *DeleteWebDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a web stream on a property.
	UpdateWebDataStream(ctx context.Context, in *UpdateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Creates a web stream with the specified location and attributes.
	CreateWebDataStream(ctx context.Context, in *CreateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error)
	// Returns child web data streams under the specified parent property.
	//
	// Web data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant web data streams are found.
	ListWebDataStreams(ctx context.Context, in *ListWebDataStreamsRequest, opts ...grpc.CallOption) (*ListWebDataStreamsResponse, error)
	// Lookup for a single IosAppDataStream
	GetIosAppDataStream(ctx context.Context, in *GetIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error)
	// Deletes an iOS app stream on a property.
	DeleteIosAppDataStream(ctx context.Context, in *DeleteIosAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an iOS app stream on a property.
	UpdateIosAppDataStream(ctx context.Context, in *UpdateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error)
	// Returns child iOS app data streams under the specified parent property.
	//
	// iOS app data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant iOS app data streams are found.
	ListIosAppDataStreams(ctx context.Context, in *ListIosAppDataStreamsRequest, opts ...grpc.CallOption) (*ListIosAppDataStreamsResponse, error)
	// Lookup for a single AndroidAppDataStream
	GetAndroidAppDataStream(ctx context.Context, in *GetAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error)
	// Deletes an android app stream on a property.
	DeleteAndroidAppDataStream(ctx context.Context, in *DeleteAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an android app stream on a property.
	UpdateAndroidAppDataStream(ctx context.Context, in *UpdateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error)
	// Returns child android app streams under the specified parent property.
	//
	// Android app streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant android app streams are found.
	ListAndroidAppDataStreams(ctx context.Context, in *ListAndroidAppDataStreamsRequest, opts ...grpc.CallOption) (*ListAndroidAppDataStreamsResponse, error)
	// Returns the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Updates the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
}

type analyticsAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsAdminServiceClient(cc grpc.ClientConnInterface) AnalyticsAdminServiceClient {
	return &analyticsAdminServiceClient{cc}
}

func (c *analyticsAdminServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error) {
	out := new(ListAccountSummariesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetUserLink(ctx context.Context, in *GetUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchGetUserLinks(ctx context.Context, in *BatchGetUserLinksRequest, opts ...grpc.CallOption) (*BatchGetUserLinksResponse, error) {
	out := new(BatchGetUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListUserLinks(ctx context.Context, in *ListUserLinksRequest, opts ...grpc.CallOption) (*ListUserLinksResponse, error) {
	out := new(ListUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AuditUserLinks(ctx context.Context, in *AuditUserLinksRequest, opts ...grpc.CallOption) (*AuditUserLinksResponse, error) {
	out := new(AuditUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/AuditUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateUserLink(ctx context.Context, in *CreateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchCreateUserLinks(ctx context.Context, in *BatchCreateUserLinksRequest, opts ...grpc.CallOption) (*BatchCreateUserLinksResponse, error) {
	out := new(BatchCreateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateUserLink(ctx context.Context, in *UpdateUserLinkRequest, opts ...grpc.CallOption) (*UserLink, error) {
	out := new(UserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchUpdateUserLinks(ctx context.Context, in *BatchUpdateUserLinksRequest, opts ...grpc.CallOption) (*BatchUpdateUserLinksResponse, error) {
	out := new(BatchUpdateUserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteUserLink(ctx context.Context, in *DeleteUserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteUserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchDeleteUserLinks(ctx context.Context, in *BatchDeleteUserLinksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteUserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetWebDataStream(ctx context.Context, in *GetWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteWebDataStream(ctx context.Context, in *DeleteWebDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateWebDataStream(ctx context.Context, in *UpdateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateWebDataStream(ctx context.Context, in *CreateWebDataStreamRequest, opts ...grpc.CallOption) (*WebDataStream, error) {
	out := new(WebDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateWebDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListWebDataStreams(ctx context.Context, in *ListWebDataStreamsRequest, opts ...grpc.CallOption) (*ListWebDataStreamsResponse, error) {
	out := new(ListWebDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListWebDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetIosAppDataStream(ctx context.Context, in *GetIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error) {
	out := new(IosAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteIosAppDataStream(ctx context.Context, in *DeleteIosAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateIosAppDataStream(ctx context.Context, in *UpdateIosAppDataStreamRequest, opts ...grpc.CallOption) (*IosAppDataStream, error) {
	out := new(IosAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateIosAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListIosAppDataStreams(ctx context.Context, in *ListIosAppDataStreamsRequest, opts ...grpc.CallOption) (*ListIosAppDataStreamsResponse, error) {
	out := new(ListIosAppDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListIosAppDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAndroidAppDataStream(ctx context.Context, in *GetAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error) {
	out := new(AndroidAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAndroidAppDataStream(ctx context.Context, in *DeleteAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAndroidAppDataStream(ctx context.Context, in *UpdateAndroidAppDataStreamRequest, opts ...grpc.CallOption) (*AndroidAppDataStream, error) {
	out := new(AndroidAppDataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAndroidAppDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAndroidAppDataStreams(ctx context.Context, in *ListAndroidAppDataStreamsRequest, opts ...grpc.CallOption) (*ListAndroidAppDataStreamsResponse, error) {
	out := new(ListAndroidAppDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAndroidAppDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error) {
	out := new(GlobalSiteTag)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error) {
	out := new(DataSharingSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error) {
	out := new(ListMeasurementProtocolSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error) {
	out := new(SearchChangeHistoryEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error) {
	out := new(ListConversionEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinkProposalsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	out := new(ApproveDisplayVideo360AdvertiserLinkProposalResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error) {
	out := new(ListCustomDimensionsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error) {
	out := new(ListCustomMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsAdminServiceServer is the server API for AnalyticsAdminService service.
type AnalyticsAdminServiceServer interface {
	// Lookup for a single Account.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Gets information about a user's link to an account or property.
	GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error)
	// Gets information about multiple users' links to an account or property.
	BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error)
	// Lists all user links on an account or property.
	ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error)
	// Lists all user links on an account or property, including implicit ones
	// that come from effective permissions granted by groups or organization
	// admin roles.
	//
	// If a returned user link does not have direct permissions, they cannot
	// be removed from the account or property directly with the DeleteUserLink
	// command. They have to be removed from the group/etc that gives them
	// permissions, which is currently only usable/discoverable in the GA or GMP
	// UIs.
	AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error)
	// Creates a user link on an account or property.
	//
	// If the user with the specified email already has permissions on the
	// account or property, then the user's existing permissions will be unioned
	// with the permissions specified in the new UserLink.
	CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error)
	// Creates information about multiple users' links to an account or property.
	//
	// This method is transactional. If any UserLink cannot be created, none of
	// the UserLinks will be created.
	BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error)
	// Updates a user link on an account or property.
	UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error)
	// Updates information about multiple users' links to an account or property.
	BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error)
	// Deletes a user link on an account or property.
	DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error)
	// Lookup for a single WebDataStream
	GetWebDataStream(context.Context, *GetWebDataStreamRequest) (*WebDataStream, error)
	// Deletes a web stream on a property.
	DeleteWebDataStream(context.Context, *DeleteWebDataStreamRequest) (*emptypb.Empty, error)
	// Updates a web stream on a property.
	UpdateWebDataStream(context.Context, *UpdateWebDataStreamRequest) (*WebDataStream, error)
	// Creates a web stream with the specified location and attributes.
	CreateWebDataStream(context.Context, *CreateWebDataStreamRequest) (*WebDataStream, error)
	// Returns child web data streams under the specified parent property.
	//
	// Web data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant web data streams are found.
	ListWebDataStreams(context.Context, *ListWebDataStreamsRequest) (*ListWebDataStreamsResponse, error)
	// Lookup for a single IosAppDataStream
	GetIosAppDataStream(context.Context, *GetIosAppDataStreamRequest) (*IosAppDataStream, error)
	// Deletes an iOS app stream on a property.
	DeleteIosAppDataStream(context.Context, *DeleteIosAppDataStreamRequest) (*emptypb.Empty, error)
	// Updates an iOS app stream on a property.
	UpdateIosAppDataStream(context.Context, *UpdateIosAppDataStreamRequest) (*IosAppDataStream, error)
	// Returns child iOS app data streams under the specified parent property.
	//
	// iOS app data streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant iOS app data streams are found.
	ListIosAppDataStreams(context.Context, *ListIosAppDataStreamsRequest) (*ListIosAppDataStreamsResponse, error)
	// Lookup for a single AndroidAppDataStream
	GetAndroidAppDataStream(context.Context, *GetAndroidAppDataStreamRequest) (*AndroidAppDataStream, error)
	// Deletes an android app stream on a property.
	DeleteAndroidAppDataStream(context.Context, *DeleteAndroidAppDataStreamRequest) (*emptypb.Empty, error)
	// Updates an android app stream on a property.
	UpdateAndroidAppDataStream(context.Context, *UpdateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error)
	// Returns child android app streams under the specified parent property.
	//
	// Android app streams will be excluded if the caller does not have access.
	// Returns an empty list if no relevant android app streams are found.
	ListAndroidAppDataStreams(context.Context, *ListAndroidAppDataStreamsRequest) (*ListAndroidAppDataStreamsResponse, error)
	// Returns the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Updates the singleton enhanced measurement settings for this web stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error)
}

// UnimplementedAnalyticsAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsAdminServiceServer struct {
}

func (*UnimplementedAnalyticsAdminServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountSummaries not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetUserLink(context.Context, *GetUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchGetUserLinks(context.Context, *BatchGetUserLinksRequest) (*BatchGetUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListUserLinks(context.Context, *ListUserLinksRequest) (*ListUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) AuditUserLinks(context.Context, *AuditUserLinksRequest) (*AuditUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuditUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateUserLink(context.Context, *CreateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchCreateUserLinks(context.Context, *BatchCreateUserLinksRequest) (*BatchCreateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateUserLink(context.Context, *UpdateUserLinkRequest) (*UserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchUpdateUserLinks(context.Context, *BatchUpdateUserLinksRequest) (*BatchUpdateUserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteUserLink(context.Context, *DeleteUserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) BatchDeleteUserLinks(context.Context, *BatchDeleteUserLinksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteUserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetWebDataStream(context.Context, *GetWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWebDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteWebDataStream(context.Context, *DeleteWebDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWebDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateWebDataStream(context.Context, *UpdateWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWebDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateWebDataStream(context.Context, *CreateWebDataStreamRequest) (*WebDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWebDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListWebDataStreams(context.Context, *ListWebDataStreamsRequest) (*ListWebDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWebDataStreams not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetIosAppDataStream(context.Context, *GetIosAppDataStreamRequest) (*IosAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIosAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteIosAppDataStream(context.Context, *DeleteIosAppDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIosAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateIosAppDataStream(context.Context, *UpdateIosAppDataStreamRequest) (*IosAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIosAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListIosAppDataStreams(context.Context, *ListIosAppDataStreamsRequest) (*ListIosAppDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIosAppDataStreams not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetAndroidAppDataStream(context.Context, *GetAndroidAppDataStreamRequest) (*AndroidAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAndroidAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteAndroidAppDataStream(context.Context, *DeleteAndroidAppDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAndroidAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAndroidAppDataStream(context.Context, *UpdateAndroidAppDataStreamRequest) (*AndroidAppDataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAndroidAppDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAndroidAppDataStreams(context.Context, *ListAndroidAppDataStreamsRequest) (*ListAndroidAppDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAndroidAppDataStreams not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnhancedMeasurementSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnhancedMeasurementSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalSiteTag not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSharingSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMeasurementProtocolSecrets not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchChangeHistoryEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinkProposals not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomDimensions not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomMetrics not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataRetentionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataRetentionSettings not implemented")
}

func RegisterAnalyticsAdminServiceServer(s *grpc.Server, srv AnalyticsAdminServiceServer) {
	s.RegisterService(&_AnalyticsAdminService_serviceDesc, srv)
}

func _AnalyticsAdminService_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, req.(*DeleteAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, req.(*UpdateAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ProvisionAccountTicket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionAccountTicketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, req.(*ProvisionAccountTicketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccountSummaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountSummariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, req.(*ListAccountSummariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, req.(*GetPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, req.(*ListPropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, req.(*CreatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, req.(*DeletePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, req.(*UpdatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetUserLink(ctx, req.(*GetUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchGetUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchGetUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchGetUserLinks(ctx, req.(*BatchGetUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListUserLinks(ctx, req.(*ListUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_AuditUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).AuditUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/AuditUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).AuditUserLinks(ctx, req.(*AuditUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateUserLink(ctx, req.(*CreateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchCreateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchCreateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchCreateUserLinks(ctx, req.(*BatchCreateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateUserLink(ctx, req.(*UpdateUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchUpdateUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateUserLinks(ctx, req.(*BatchUpdateUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteUserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteUserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteUserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteUserLink(ctx, req.(*DeleteUserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchDeleteUserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteUserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteUserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteUserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteUserLinks(ctx, req.(*BatchDeleteUserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetWebDataStream(ctx, req.(*GetWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteWebDataStream(ctx, req.(*DeleteWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateWebDataStream(ctx, req.(*UpdateWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateWebDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWebDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateWebDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateWebDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateWebDataStream(ctx, req.(*CreateWebDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListWebDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWebDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListWebDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListWebDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListWebDataStreams(ctx, req.(*ListWebDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetIosAppDataStream(ctx, req.(*GetIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteIosAppDataStream(ctx, req.(*DeleteIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateIosAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIosAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateIosAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateIosAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateIosAppDataStream(ctx, req.(*UpdateIosAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListIosAppDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIosAppDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListIosAppDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListIosAppDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListIosAppDataStreams(ctx, req.(*ListIosAppDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAndroidAppDataStream(ctx, req.(*GetAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAndroidAppDataStream(ctx, req.(*DeleteAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAndroidAppDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAndroidAppDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAndroidAppDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAndroidAppDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAndroidAppDataStream(ctx, req.(*UpdateAndroidAppDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAndroidAppDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAndroidAppDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAndroidAppDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAndroidAppDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAndroidAppDataStreams(ctx, req.(*ListAndroidAppDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEnhancedMeasurementSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetEnhancedMeasurementSettings(ctx, req.(*GetEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEnhancedMeasurementSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateEnhancedMeasurementSettings(ctx, req.(*UpdateEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, req.(*CreateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, req.(*DeleteFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListFirebaseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirebaseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, req.(*ListFirebaseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGlobalSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, req.(*GetGlobalSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, req.(*CreateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, req.(*UpdateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, req.(*DeleteGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListGoogleAdsLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleAdsLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, req.(*ListGoogleAdsLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataSharingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSharingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, req.(*GetDataSharingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, req.(*GetMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMeasurementProtocolSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, req.(*ListMeasurementProtocolSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, req.(*CreateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, req.(*DeleteMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, req.(*UpdateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SearchChangeHistoryEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchChangeHistoryEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, req.(*SearchChangeHistoryEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, req.(*GetGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, req.(*UpdateGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, req.(*CreateConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, req.(*GetConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, req.(*DeleteConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListConversionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, req.(*ListConversionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, req.(*GetDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, req.(*ListDisplayVideo360AdvertiserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, req.(*CreateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, req.(*UpdateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, req.(*GetDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinkProposalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, req.(*ListDisplayVideo360AdvertiserLinkProposalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CreateDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, req.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CancelDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, req.(*CreateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, req.(*UpdateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomDimensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomDimensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, req.(*ListCustomDimensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, req.(*ArchiveCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, req.(*GetCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, req.(*CreateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, req.(*UpdateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, req.(*ListCustomMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, req.(*ArchiveCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, req.(*GetCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, req.(*GetDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, req.(*UpdateDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnalyticsAdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.admin.v1alpha.AnalyticsAdminService",
	HandlerType: (*AnalyticsAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccount",
			Handler:    _AnalyticsAdminService_GetAccount_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _AnalyticsAdminService_ListAccounts_Handler,
		},
		{
			MethodName: "DeleteAccount",
			Handler:    _AnalyticsAdminService_DeleteAccount_Handler,
		},
		{
			MethodName: "UpdateAccount",
			Handler:    _AnalyticsAdminService_UpdateAccount_Handler,
		},
		{
			MethodName: "ProvisionAccountTicket",
			Handler:    _AnalyticsAdminService_ProvisionAccountTicket_Handler,
		},
		{
			MethodName: "ListAccountSummaries",
			Handler:    _AnalyticsAdminService_ListAccountSummaries_Handler,
		},
		{
			MethodName: "GetProperty",
			Handler:    _AnalyticsAdminService_GetProperty_Handler,
		},
		{
			MethodName: "ListProperties",
			Handler:    _AnalyticsAdminService_ListProperties_Handler,
		},
		{
			MethodName: "CreateProperty",
			Handler:    _AnalyticsAdminService_CreateProperty_Handler,
		},
		{
			MethodName: "DeleteProperty",
			Handler:    _AnalyticsAdminService_DeleteProperty_Handler,
		},
		{
			MethodName: "UpdateProperty",
			Handler:    _AnalyticsAdminService_UpdateProperty_Handler,
		},
		{
			MethodName: "GetUserLink",
			Handler:    _AnalyticsAdminService_GetUserLink_Handler,
		},
		{
			MethodName: "BatchGetUserLinks",
			Handler:    _AnalyticsAdminService_BatchGetUserLinks_Handler,
		},
		{
			MethodName: "ListUserLinks",
			Handler:    _AnalyticsAdminService_ListUserLinks_Handler,
		},
		{
			MethodName: "AuditUserLinks",
			Handler:    _AnalyticsAdminService_AuditUserLinks_Handler,
		},
		{
			MethodName: "CreateUserLink",
			Handler:    _AnalyticsAdminService_CreateUserLink_Handler,
		},
		{
			MethodName: "BatchCreateUserLinks",
			Handler:    _AnalyticsAdminService_BatchCreateUserLinks_Handler,
		},
		{
			MethodName: "UpdateUserLink",
			Handler:    _AnalyticsAdminService_UpdateUserLink_Handler,
		},
		{
			MethodName: "BatchUpdateUserLinks",
			Handler:    _AnalyticsAdminService_BatchUpdateUserLinks_Handler,
		},
		{
			MethodName: "DeleteUserLink",
			Handler:    _AnalyticsAdminService_DeleteUserLink_Handler,
		},
		{
			MethodName: "BatchDeleteUserLinks",
			Handler:    _AnalyticsAdminService_BatchDeleteUserLinks_Handler,
		},
		{
			MethodName: "GetWebDataStream",
			Handler:    _AnalyticsAdminService_GetWebDataStream_Handler,
		},
		{
			MethodName: "DeleteWebDataStream",
			Handler:    _AnalyticsAdminService_DeleteWebDataStream_Handler,
		},
		{
			MethodName: "UpdateWebDataStream",
			Handler:    _AnalyticsAdminService_UpdateWebDataStream_Handler,
		},
		{
			MethodName: "CreateWebDataStream",
			Handler:    _AnalyticsAdminService_CreateWebDataStream_Handler,
		},
		{
			MethodName: "ListWebDataStreams",
			Handler:    _AnalyticsAdminService_ListWebDataStreams_Handler,
		},
		{
			MethodName: "GetIosAppDataStream",
			Handler:    _AnalyticsAdminService_GetIosAppDataStream_Handler,
		},
		{
			MethodName: "DeleteIosAppDataStream",
			Handler:    _AnalyticsAdminService_DeleteIosAppDataStream_Handler,
		},
		{
			MethodName: "UpdateIosAppDataStream",
			Handler:    _AnalyticsAdminService_UpdateIosAppDataStream_Handler,
		},
		{
			MethodName: "ListIosAppDataStreams",
			Handler:    _AnalyticsAdminService_ListIosAppDataStreams_Handler,
		},
		{
			MethodName: "GetAndroidAppDataStream",
			Handler:    _AnalyticsAdminService_GetAndroidAppDataStream_Handler,
		},
		{
			MethodName: "DeleteAndroidAppDataStream",
			Handler:    _AnalyticsAdminService_DeleteAndroidAppDataStream_Handler,
		},
		{
			MethodName: "UpdateAndroidAppDataStream",
			Handler:    _AnalyticsAdminService_UpdateAndroidAppDataStream_Handler,
		},
		{
			MethodName: "ListAndroidAppDataStreams",
			Handler:    _AnalyticsAdminService_ListAndroidAppDataStreams_Handler,
		},
		{
			MethodName: "GetEnhancedMeasurementSettings",
			Handler:    _AnalyticsAdminService_GetEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "UpdateEnhancedMeasurementSettings",
			Handler:    _AnalyticsAdminService_UpdateEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "CreateFirebaseLink",
			Handler:    _AnalyticsAdminService_CreateFirebaseLink_Handler,
		},
		{
			MethodName: "DeleteFirebaseLink",
			Handler:    _AnalyticsAdminService_DeleteFirebaseLink_Handler,
		},
		{
			MethodName: "ListFirebaseLinks",
			Handler:    _AnalyticsAdminService_ListFirebaseLinks_Handler,
		},
		{
			MethodName: "GetGlobalSiteTag",
			Handler:    _AnalyticsAdminService_GetGlobalSiteTag_Handler,
		},
		{
			MethodName: "CreateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_CreateGoogleAdsLink_Handler,
		},
		{
			MethodName: "UpdateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_UpdateGoogleAdsLink_Handler,
		},
		{
			MethodName: "DeleteGoogleAdsLink",
			Handler:    _AnalyticsAdminService_DeleteGoogleAdsLink_Handler,
		},
		{
			MethodName: "ListGoogleAdsLinks",
			Handler:    _AnalyticsAdminService_ListGoogleAdsLinks_Handler,
		},
		{
			MethodName: "GetDataSharingSettings",
			Handler:    _AnalyticsAdminService_GetDataSharingSettings_Handler,
		},
		{
			MethodName: "GetMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "ListMeasurementProtocolSecrets",
			Handler:    _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler,
		},
		{
			MethodName: "CreateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "DeleteMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "UpdateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "SearchChangeHistoryEvents",
			Handler:    _AnalyticsAdminService_SearchChangeHistoryEvents_Handler,
		},
		{
			MethodName: "GetGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_GetGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "UpdateGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "CreateConversionEvent",
			Handler:    _AnalyticsAdminService_CreateConversionEvent_Handler,
		},
		{
			MethodName: "GetConversionEvent",
			Handler:    _AnalyticsAdminService_GetConversionEvent_Handler,
		},
		{
			MethodName: "DeleteConversionEvent",
			Handler:    _AnalyticsAdminService_DeleteConversionEvent_Handler,
		},
		{
			MethodName: "ListConversionEvents",
			Handler:    _AnalyticsAdminService_ListConversionEvents_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinks",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "UpdateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinkProposals",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ApproveDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CancelDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CreateCustomDimension",
			Handler:    _AnalyticsAdminService_CreateCustomDimension_Handler,
		},
		{
			MethodName: "UpdateCustomDimension",
			Handler:    _AnalyticsAdminService_UpdateCustomDimension_Handler,
		},
		{
			MethodName: "ListCustomDimensions",
			Handler:    _AnalyticsAdminService_ListCustomDimensions_Handler,
		},
		{
			MethodName: "ArchiveCustomDimension",
			Handler:    _AnalyticsAdminService_ArchiveCustomDimension_Handler,
		},
		{
			MethodName: "GetCustomDimension",
			Handler:    _AnalyticsAdminService_GetCustomDimension_Handler,
		},
		{
			MethodName: "CreateCustomMetric",
			Handler:    _AnalyticsAdminService_CreateCustomMetric_Handler,
		},
		{
			MethodName: "UpdateCustomMetric",
			Handler:    _AnalyticsAdminService_UpdateCustomMetric_Handler,
		},
		{
			MethodName: "ListCustomMetrics",
			Handler:    _AnalyticsAdminService_ListCustomMetrics_Handler,
		},
		{
			MethodName: "ArchiveCustomMetric",
			Handler:    _AnalyticsAdminService_ArchiveCustomMetric_Handler,
		},
		{
			MethodName: "GetCustomMetric",
			Handler:    _AnalyticsAdminService_GetCustomMetric_Handler,
		},
		{
			MethodName: "GetDataRetentionSettings",
			Handler:    _AnalyticsAdminService_GetDataRetentionSettings_Handler,
		},
		{
			MethodName: "UpdateDataRetentionSettings",
			Handler:    _AnalyticsAdminService_UpdateDataRetentionSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/admin/v1alpha/analytics_admin.proto",
}
