// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/genomics/v1/readgroupset.proto

package genomics

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A read group set is a logical collection of read groups, which are
// collections of reads produced by a sequencer. A read group set typically
// models reads corresponding to one sample, sequenced one way, and aligned one
// way.
//
// * A read group set belongs to one dataset.
// * A read group belongs to one read group set.
// * A read belongs to one read group.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type ReadGroupSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-generated read group set ID, unique for all read group sets.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The dataset to which this read group set belongs.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The reference set to which the reads in this read group set are aligned.
	ReferenceSetId string `protobuf:"bytes,3,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// The read group set name. By default this will be initialized to the sample
	// name of the sequenced data contained in this set.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The filename of the original source file for this read group set, if any.
	Filename string `protobuf:"bytes,5,opt,name=filename,proto3" json:"filename,omitempty"`
	// The read groups in this set. There are typically 1-10 read groups in a read
	// group set.
	ReadGroups []*ReadGroup `protobuf:"bytes,6,rep,name=read_groups,json=readGroups,proto3" json:"read_groups,omitempty"`
	// A map of additional read group set information.
	Info map[string]*structpb.ListValue `protobuf:"bytes,7,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ReadGroupSet) Reset() {
	*x = ReadGroupSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_readgroupset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadGroupSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadGroupSet) ProtoMessage() {}

func (x *ReadGroupSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_readgroupset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadGroupSet.ProtoReflect.Descriptor instead.
func (*ReadGroupSet) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_readgroupset_proto_rawDescGZIP(), []int{0}
}

func (x *ReadGroupSet) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ReadGroupSet) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *ReadGroupSet) GetReferenceSetId() string {
	if x != nil {
		return x.ReferenceSetId
	}
	return ""
}

func (x *ReadGroupSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReadGroupSet) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *ReadGroupSet) GetReadGroups() []*ReadGroup {
	if x != nil {
		return x.ReadGroups
	}
	return nil
}

func (x *ReadGroupSet) GetInfo() map[string]*structpb.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

var File_google_genomics_v1_readgroupset_proto protoreflect.FileDescriptor

var file_google_genomics_v1_readgroupset_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xec, 0x02, 0x0a, 0x0c,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x65, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x6c, 0x0a, 0x16, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_genomics_v1_readgroupset_proto_rawDescOnce sync.Once
	file_google_genomics_v1_readgroupset_proto_rawDescData = file_google_genomics_v1_readgroupset_proto_rawDesc
)

func file_google_genomics_v1_readgroupset_proto_rawDescGZIP() []byte {
	file_google_genomics_v1_readgroupset_proto_rawDescOnce.Do(func() {
		file_google_genomics_v1_readgroupset_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_genomics_v1_readgroupset_proto_rawDescData)
	})
	return file_google_genomics_v1_readgroupset_proto_rawDescData
}

var file_google_genomics_v1_readgroupset_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_genomics_v1_readgroupset_proto_goTypes = []interface{}{
	(*ReadGroupSet)(nil),       // 0: google.genomics.v1.ReadGroupSet
	nil,                        // 1: google.genomics.v1.ReadGroupSet.InfoEntry
	(*ReadGroup)(nil),          // 2: google.genomics.v1.ReadGroup
	(*structpb.ListValue)(nil), // 3: google.protobuf.ListValue
}
var file_google_genomics_v1_readgroupset_proto_depIdxs = []int32{
	2, // 0: google.genomics.v1.ReadGroupSet.read_groups:type_name -> google.genomics.v1.ReadGroup
	1, // 1: google.genomics.v1.ReadGroupSet.info:type_name -> google.genomics.v1.ReadGroupSet.InfoEntry
	3, // 2: google.genomics.v1.ReadGroupSet.InfoEntry.value:type_name -> google.protobuf.ListValue
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_genomics_v1_readgroupset_proto_init() }
func file_google_genomics_v1_readgroupset_proto_init() {
	if File_google_genomics_v1_readgroupset_proto != nil {
		return
	}
	file_google_genomics_v1_readgroup_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_genomics_v1_readgroupset_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadGroupSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_genomics_v1_readgroupset_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_genomics_v1_readgroupset_proto_goTypes,
		DependencyIndexes: file_google_genomics_v1_readgroupset_proto_depIdxs,
		MessageInfos:      file_google_genomics_v1_readgroupset_proto_msgTypes,
	}.Build()
	File_google_genomics_v1_readgroupset_proto = out.File
	file_google_genomics_v1_readgroupset_proto_rawDesc = nil
	file_google_genomics_v1_readgroupset_proto_goTypes = nil
	file_google_genomics_v1_readgroupset_proto_depIdxs = nil
}
