/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	v1beta1 "k8s.io/autoscaler/vertical-pod-autoscaler/pkg/apis/autoscaling.k8s.io/v1beta1"
	scheme "k8s.io/autoscaler/vertical-pod-autoscaler/pkg/client/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

// VerticalPodAutoscalerCheckpointsGetter has a method to return a VerticalPodAutoscalerCheckpointInterface.
// A group's client should implement this interface.
type VerticalPodAutoscalerCheckpointsGetter interface {
	VerticalPodAutoscalerCheckpoints(namespace string) VerticalPodAutoscalerCheckpointInterface
}

// VerticalPodAutoscalerCheckpointInterface has methods to work with VerticalPodAutoscalerCheckpoint resources.
type VerticalPodAutoscalerCheckpointInterface interface {
	Create(ctx context.Context, verticalPodAutoscalerCheckpoint *v1beta1.VerticalPodAutoscalerCheckpoint, opts v1.CreateOptions) (*v1beta1.VerticalPodAutoscalerCheckpoint, error)
	Update(ctx context.Context, verticalPodAutoscalerCheckpoint *v1beta1.VerticalPodAutoscalerCheckpoint, opts v1.UpdateOptions) (*v1beta1.VerticalPodAutoscalerCheckpoint, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.VerticalPodAutoscalerCheckpoint, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.VerticalPodAutoscalerCheckpointList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.VerticalPodAutoscalerCheckpoint, err error)
	VerticalPodAutoscalerCheckpointExpansion
}

// verticalPodAutoscalerCheckpoints implements VerticalPodAutoscalerCheckpointInterface
type verticalPodAutoscalerCheckpoints struct {
	client rest.Interface
	ns     string
}

// newVerticalPodAutoscalerCheckpoints returns a VerticalPodAutoscalerCheckpoints
func newVerticalPodAutoscalerCheckpoints(c *AutoscalingV1beta1Client, namespace string) *verticalPodAutoscalerCheckpoints {
	return &verticalPodAutoscalerCheckpoints{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the verticalPodAutoscalerCheckpoint, and returns the corresponding verticalPodAutoscalerCheckpoint object, and an error if there is any.
func (c *verticalPodAutoscalerCheckpoints) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.VerticalPodAutoscalerCheckpoint, err error) {
	result = &v1beta1.VerticalPodAutoscalerCheckpoint{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VerticalPodAutoscalerCheckpoints that match those selectors.
func (c *verticalPodAutoscalerCheckpoints) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.VerticalPodAutoscalerCheckpointList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.VerticalPodAutoscalerCheckpointList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested verticalPodAutoscalerCheckpoints.
func (c *verticalPodAutoscalerCheckpoints) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a verticalPodAutoscalerCheckpoint and creates it.  Returns the server's representation of the verticalPodAutoscalerCheckpoint, and an error, if there is any.
func (c *verticalPodAutoscalerCheckpoints) Create(ctx context.Context, verticalPodAutoscalerCheckpoint *v1beta1.VerticalPodAutoscalerCheckpoint, opts v1.CreateOptions) (result *v1beta1.VerticalPodAutoscalerCheckpoint, err error) {
	result = &v1beta1.VerticalPodAutoscalerCheckpoint{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(verticalPodAutoscalerCheckpoint).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a verticalPodAutoscalerCheckpoint and updates it. Returns the server's representation of the verticalPodAutoscalerCheckpoint, and an error, if there is any.
func (c *verticalPodAutoscalerCheckpoints) Update(ctx context.Context, verticalPodAutoscalerCheckpoint *v1beta1.VerticalPodAutoscalerCheckpoint, opts v1.UpdateOptions) (result *v1beta1.VerticalPodAutoscalerCheckpoint, err error) {
	result = &v1beta1.VerticalPodAutoscalerCheckpoint{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		Name(verticalPodAutoscalerCheckpoint.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(verticalPodAutoscalerCheckpoint).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the verticalPodAutoscalerCheckpoint and deletes it. Returns an error if one occurs.
func (c *verticalPodAutoscalerCheckpoints) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *verticalPodAutoscalerCheckpoints) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched verticalPodAutoscalerCheckpoint.
func (c *verticalPodAutoscalerCheckpoints) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.VerticalPodAutoscalerCheckpoint, err error) {
	result = &v1beta1.VerticalPodAutoscalerCheckpoint{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("verticalpodautoscalercheckpoints").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
