//lint:file-ignore SA1019 Ignore all deprecated warning
// Code generated by protoc-gen-go. DO NOT EDIT.
// source: k8scloudoperator.proto

package k8scloudoperator

import (
	context "context"
	fmt "fmt"
	math "math"

	spec "github.com/container-storage-interface/spec/lib/go/csi"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PodListenerRequest struct {
	// The volumeID that needs to be attached to the node.
	VolumeID string `protobuf:"bytes,1,opt,name=volumeID,proto3" json:"volumeID,omitempty"`
	// Name of the node where the Pod is running.
	NodeName             string   `protobuf:"bytes,2,opt,name=nodeName,proto3" json:"nodeName,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodListenerRequest) Reset()         { *m = PodListenerRequest{} }
func (m *PodListenerRequest) String() string { return proto.CompactTextString(m) }
func (*PodListenerRequest) ProtoMessage()    {}
func (*PodListenerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{0}
}

func (m *PodListenerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodListenerRequest.Unmarshal(m, b)
}
func (m *PodListenerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodListenerRequest.Marshal(b, m, deterministic)
}
func (m *PodListenerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodListenerRequest.Merge(m, src)
}
func (m *PodListenerRequest) XXX_Size() int {
	return xxx_messageInfo_PodListenerRequest.Size(m)
}
func (m *PodListenerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PodListenerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PodListenerRequest proto.InternalMessageInfo

func (m *PodListenerRequest) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *PodListenerRequest) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

type PodListenerResponse struct {
	// VM UUID annotation of the pod.
	VmuuidAnnotation     string   `protobuf:"bytes,1,opt,name=vmuuidAnnotation,proto3" json:"vmuuidAnnotation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodListenerResponse) Reset()         { *m = PodListenerResponse{} }
func (m *PodListenerResponse) String() string { return proto.CompactTextString(m) }
func (*PodListenerResponse) ProtoMessage()    {}
func (*PodListenerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{1}
}

func (m *PodListenerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodListenerResponse.Unmarshal(m, b)
}
func (m *PodListenerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodListenerResponse.Marshal(b, m, deterministic)
}
func (m *PodListenerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodListenerResponse.Merge(m, src)
}
func (m *PodListenerResponse) XXX_Size() int {
	return xxx_messageInfo_PodListenerResponse.Size(m)
}
func (m *PodListenerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PodListenerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PodListenerResponse proto.InternalMessageInfo

func (m *PodListenerResponse) GetVmuuidAnnotation() string {
	if m != nil {
		return m.VmuuidAnnotation
	}
	return ""
}

type HostAnnotationRequest struct {
	// Name of the host
	HostName string `protobuf:"bytes,1,opt,name=hostName,proto3" json:"hostName,omitempty"`
	// Name of the annotation key of interest
	AnnotationKey        string   `protobuf:"bytes,2,opt,name=annotationKey,proto3" json:"annotationKey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostAnnotationRequest) Reset()         { *m = HostAnnotationRequest{} }
func (m *HostAnnotationRequest) String() string { return proto.CompactTextString(m) }
func (*HostAnnotationRequest) ProtoMessage()    {}
func (*HostAnnotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{2}
}

func (m *HostAnnotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostAnnotationRequest.Unmarshal(m, b)
}
func (m *HostAnnotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostAnnotationRequest.Marshal(b, m, deterministic)
}
func (m *HostAnnotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostAnnotationRequest.Merge(m, src)
}
func (m *HostAnnotationRequest) XXX_Size() int {
	return xxx_messageInfo_HostAnnotationRequest.Size(m)
}
func (m *HostAnnotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HostAnnotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HostAnnotationRequest proto.InternalMessageInfo

func (m *HostAnnotationRequest) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *HostAnnotationRequest) GetAnnotationKey() string {
	if m != nil {
		return m.AnnotationKey
	}
	return ""
}

type HostAnnotationResponse struct {
	// Value of the annotation key on the node `hostName`
	AnnotationValue      string   `protobuf:"bytes,2,opt,name=annotationValue,proto3" json:"annotationValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostAnnotationResponse) Reset()         { *m = HostAnnotationResponse{} }
func (m *HostAnnotationResponse) String() string { return proto.CompactTextString(m) }
func (*HostAnnotationResponse) ProtoMessage()    {}
func (*HostAnnotationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{3}
}

func (m *HostAnnotationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostAnnotationResponse.Unmarshal(m, b)
}
func (m *HostAnnotationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostAnnotationResponse.Marshal(b, m, deterministic)
}
func (m *HostAnnotationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostAnnotationResponse.Merge(m, src)
}
func (m *HostAnnotationResponse) XXX_Size() int {
	return xxx_messageInfo_HostAnnotationResponse.Size(m)
}
func (m *HostAnnotationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_HostAnnotationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_HostAnnotationResponse proto.InternalMessageInfo

func (m *HostAnnotationResponse) GetAnnotationValue() string {
	if m != nil {
		return m.AnnotationValue
	}
	return ""
}

type PVCPlacementRequest struct {
	// Name of the PVC to place
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace of the PVC to place
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Topology in AccessibilityRequirements to place a PVC
	AccessibilityRequirements *spec.TopologyRequirement `protobuf:"bytes,3,opt,name=accessibility_requirements,json=accessibilityRequirements,proto3" json:"accessibility_requirements,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                  `json:"-"`
	XXX_unrecognized          []byte                    `json:"-"`
	XXX_sizecache             int32                     `json:"-"`
}

func (m *PVCPlacementRequest) Reset()         { *m = PVCPlacementRequest{} }
func (m *PVCPlacementRequest) String() string { return proto.CompactTextString(m) }
func (*PVCPlacementRequest) ProtoMessage()    {}
func (*PVCPlacementRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{4}
}

func (m *PVCPlacementRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PVCPlacementRequest.Unmarshal(m, b)
}
func (m *PVCPlacementRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PVCPlacementRequest.Marshal(b, m, deterministic)
}
func (m *PVCPlacementRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PVCPlacementRequest.Merge(m, src)
}
func (m *PVCPlacementRequest) XXX_Size() int {
	return xxx_messageInfo_PVCPlacementRequest.Size(m)
}
func (m *PVCPlacementRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PVCPlacementRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PVCPlacementRequest proto.InternalMessageInfo

func (m *PVCPlacementRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PVCPlacementRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PVCPlacementRequest) GetAccessibilityRequirements() *spec.TopologyRequirement {
	if m != nil {
		return m.AccessibilityRequirements
	}
	return nil
}

type PVCPlacementResponse struct {
	//Succeed or not for placement engine to find proper storage pool
	PlaceSuccess         bool     `protobuf:"varint,1,opt,name=placeSuccess,proto3" json:"placeSuccess,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PVCPlacementResponse) Reset()         { *m = PVCPlacementResponse{} }
func (m *PVCPlacementResponse) String() string { return proto.CompactTextString(m) }
func (*PVCPlacementResponse) ProtoMessage()    {}
func (*PVCPlacementResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{5}
}

func (m *PVCPlacementResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PVCPlacementResponse.Unmarshal(m, b)
}
func (m *PVCPlacementResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PVCPlacementResponse.Marshal(b, m, deterministic)
}
func (m *PVCPlacementResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PVCPlacementResponse.Merge(m, src)
}
func (m *PVCPlacementResponse) XXX_Size() int {
	return xxx_messageInfo_PVCPlacementResponse.Size(m)
}
func (m *PVCPlacementResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PVCPlacementResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PVCPlacementResponse proto.InternalMessageInfo

func (m *PVCPlacementResponse) GetPlaceSuccess() bool {
	if m != nil {
		return m.PlaceSuccess
	}
	return false
}

type StorageVMotionRequest struct {
	// name of the Storage-Pool
	StoragePoolName string `protobuf:"bytes,1,opt,name=storage_pool_name,json=storagePoolName,proto3" json:"storage_pool_name,omitempty"`
	// Type of maintenance mode, either "ensureAccessibility"/"evacuateAll".
	MaintenanceMode      string   `protobuf:"bytes,2,opt,name=maintenance_mode,json=maintenanceMode,proto3" json:"maintenance_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageVMotionRequest) Reset()         { *m = StorageVMotionRequest{} }
func (m *StorageVMotionRequest) String() string { return proto.CompactTextString(m) }
func (*StorageVMotionRequest) ProtoMessage()    {}
func (*StorageVMotionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{6}
}

func (m *StorageVMotionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageVMotionRequest.Unmarshal(m, b)
}
func (m *StorageVMotionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageVMotionRequest.Marshal(b, m, deterministic)
}
func (m *StorageVMotionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVMotionRequest.Merge(m, src)
}
func (m *StorageVMotionRequest) XXX_Size() int {
	return xxx_messageInfo_StorageVMotionRequest.Size(m)
}
func (m *StorageVMotionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVMotionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVMotionRequest proto.InternalMessageInfo

func (m *StorageVMotionRequest) GetStoragePoolName() string {
	if m != nil {
		return m.StoragePoolName
	}
	return ""
}

func (m *StorageVMotionRequest) GetMaintenanceMode() string {
	if m != nil {
		return m.MaintenanceMode
	}
	return ""
}

type StorageVMotionResponse struct {
	// svMotion plan is returned to caller as a map of PV name to StoragePool name
	SvMotionPlan         map[string]string `protobuf:"bytes,1,rep,name=sv_motion_plan,json=svMotionPlan,proto3" json:"sv_motion_plan,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StorageVMotionResponse) Reset()         { *m = StorageVMotionResponse{} }
func (m *StorageVMotionResponse) String() string { return proto.CompactTextString(m) }
func (*StorageVMotionResponse) ProtoMessage()    {}
func (*StorageVMotionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_acda4807ad521f9a, []int{7}
}

func (m *StorageVMotionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageVMotionResponse.Unmarshal(m, b)
}
func (m *StorageVMotionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageVMotionResponse.Marshal(b, m, deterministic)
}
func (m *StorageVMotionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVMotionResponse.Merge(m, src)
}
func (m *StorageVMotionResponse) XXX_Size() int {
	return xxx_messageInfo_StorageVMotionResponse.Size(m)
}
func (m *StorageVMotionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVMotionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVMotionResponse proto.InternalMessageInfo

func (m *StorageVMotionResponse) GetSvMotionPlan() map[string]string {
	if m != nil {
		return m.SvMotionPlan
	}
	return nil
}

func init() {
	proto.RegisterType((*PodListenerRequest)(nil), "k8scloudoperator.PodListenerRequest")
	proto.RegisterType((*PodListenerResponse)(nil), "k8scloudoperator.PodListenerResponse")
	proto.RegisterType((*HostAnnotationRequest)(nil), "k8scloudoperator.HostAnnotationRequest")
	proto.RegisterType((*HostAnnotationResponse)(nil), "k8scloudoperator.HostAnnotationResponse")
	proto.RegisterType((*PVCPlacementRequest)(nil), "k8scloudoperator.PVCPlacementRequest")
	proto.RegisterType((*PVCPlacementResponse)(nil), "k8scloudoperator.PVCPlacementResponse")
	proto.RegisterType((*StorageVMotionRequest)(nil), "k8scloudoperator.StorageVMotionRequest")
	proto.RegisterType((*StorageVMotionResponse)(nil), "k8scloudoperator.StorageVMotionResponse")
	proto.RegisterMapType((map[string]string)(nil), "k8scloudoperator.StorageVMotionResponse.SvMotionPlanEntry")
}

func init() { proto.RegisterFile("k8scloudoperator.proto", fileDescriptor_acda4807ad521f9a) }

var fileDescriptor_acda4807ad521f9a = []byte{
	// 605 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x54, 0xdd, 0x4e, 0xdb, 0x4c,
	0x10, 0x25, 0xe4, 0xfb, 0x2a, 0x18, 0x68, 0x09, 0x0b, 0x44, 0xd4, 0xf4, 0x02, 0x59, 0xb4, 0x4d,
	0x91, 0x08, 0x2a, 0x55, 0x25, 0xc4, 0x4d, 0x45, 0xa1, 0xa2, 0x08, 0x68, 0xad, 0x50, 0x22, 0xb5,
	0x37, 0xe9, 0xb2, 0x9e, 0x86, 0x15, 0xeb, 0x1d, 0xe3, 0x5d, 0x47, 0xca, 0xf3, 0xf4, 0x31, 0x7a,
	0xd9, 0x17, 0xab, 0xec, 0x38, 0x89, 0x1d, 0x5b, 0xe2, 0x2a, 0x9e, 0x33, 0x7f, 0x67, 0x32, 0x67,
	0x16, 0x9a, 0xf7, 0x87, 0x46, 0x28, 0x8a, 0x7d, 0x0a, 0x31, 0xe2, 0x96, 0xa2, 0x76, 0x18, 0x91,
	0x25, 0xd6, 0x98, 0xc5, 0x9d, 0xf7, 0x7d, 0x69, 0xef, 0xe2, 0xdb, 0xb6, 0xa0, 0x60, 0x5f, 0x90,
	0xb6, 0x5c, 0x6a, 0x8c, 0xf6, 0x8c, 0xa5, 0x88, 0xf7, 0x71, 0x4f, 0x6a, 0x8b, 0xd1, 0x2f, 0x2e,
	0x70, 0xdf, 0x84, 0x28, 0xf6, 0x85, 0x91, 0xa3, 0x42, 0xee, 0x25, 0x30, 0x8f, 0xfc, 0x4b, 0x69,
	0x2c, 0x6a, 0x8c, 0x3a, 0xf8, 0x10, 0xa3, 0xb1, 0xcc, 0x81, 0x85, 0x01, 0xa9, 0x38, 0xc0, 0xf3,
	0xd3, 0xcd, 0xda, 0x76, 0xad, 0xb5, 0xd8, 0x99, 0xd8, 0x89, 0x4f, 0x93, 0x8f, 0x5f, 0x78, 0x80,
	0x9b, 0xf3, 0x23, 0xdf, 0xd8, 0x76, 0x8f, 0x61, 0xad, 0x50, 0xcd, 0x84, 0xa4, 0x0d, 0xb2, 0x5d,
	0x68, 0x0c, 0x82, 0x38, 0x96, 0xfe, 0xb1, 0xd6, 0x64, 0xb9, 0x95, 0xa4, 0xb3, 0xb2, 0x25, 0xdc,
	0xfd, 0x0e, 0x1b, 0x9f, 0xc9, 0xd8, 0x29, 0x92, 0xe3, 0x74, 0x47, 0xc6, 0xa6, 0x7d, 0x33, 0x4e,
	0x63, 0x9b, 0xed, 0xc0, 0x53, 0x3e, 0x49, 0xb8, 0xc0, 0x61, 0x46, 0xac, 0x08, 0xba, 0x1f, 0xa1,
	0x39, 0x5b, 0x3a, 0x23, 0xd8, 0x82, 0x95, 0x69, 0x68, 0x97, 0xab, 0x78, 0x3c, 0xda, 0x2c, 0xec,
	0xfe, 0xae, 0xc1, 0x9a, 0xd7, 0x3d, 0xf1, 0x14, 0x17, 0x18, 0xa0, 0xb6, 0x63, 0x76, 0x0c, 0xfe,
	0xd3, 0x53, 0x66, 0xe9, 0x37, 0x7b, 0x01, 0x8b, 0xc9, 0xaf, 0x09, 0xb9, 0x18, 0xd7, 0x9b, 0x02,
	0xec, 0x07, 0x38, 0x5c, 0x08, 0x34, 0x46, 0xde, 0x4a, 0x25, 0xed, 0xb0, 0x17, 0xe1, 0x43, 0x2c,
	0xa3, 0xb4, 0xaa, 0xd9, 0xac, 0x6f, 0xd7, 0x5a, 0x4b, 0x07, 0x5b, 0xed, 0x64, 0x53, 0x83, 0xb7,
	0xed, 0x6f, 0x14, 0x92, 0xa2, 0xfe, 0xb0, 0x33, 0x8d, 0xe9, 0x3c, 0x2f, 0xa4, 0xe7, 0x3c, 0xc6,
	0x3d, 0x82, 0xf5, 0x22, 0xc9, 0x6c, 0x4e, 0x17, 0x96, 0xc3, 0x04, 0xbc, 0x8e, 0xd3, 0xd4, 0x94,
	0xed, 0x42, 0xa7, 0x80, 0xb9, 0x1a, 0x36, 0xae, 0x47, 0xaa, 0xe9, 0x5e, 0x51, 0x7e, 0x01, 0xbb,
	0xb0, 0x9a, 0xc9, 0xa9, 0x17, 0x12, 0xa9, 0x5e, 0x6e, 0xde, 0x95, 0xcc, 0xe1, 0x11, 0xa9, 0x74,
	0x21, 0x6f, 0xa0, 0x11, 0xf0, 0x44, 0x74, 0x9a, 0x6b, 0x81, 0xbd, 0x80, 0xfc, 0xc9, 0x3f, 0x9a,
	0xc3, 0xaf, 0xc8, 0x47, 0xf7, 0x4f, 0x0d, 0x9a, 0xb3, 0x0d, 0x33, 0xba, 0x3f, 0xe1, 0x99, 0x19,
	0xf4, 0x82, 0x14, 0xec, 0x85, 0x8a, 0x27, 0xaa, 0xa9, 0xb7, 0x96, 0x0e, 0x8e, 0xda, 0xa5, 0xb3,
	0xa8, 0xae, 0xd0, 0xbe, 0x1e, 0x8c, 0x00, 0x4f, 0x71, 0xfd, 0x49, 0xdb, 0x68, 0xd8, 0x59, 0x36,
	0x39, 0xc8, 0xf9, 0x00, 0xab, 0xa5, 0x10, 0xd6, 0x80, 0xfa, 0x3d, 0x0e, 0xb3, 0xd1, 0x92, 0x4f,
	0xb6, 0x0e, 0xff, 0x0f, 0x72, 0xaa, 0x18, 0x19, 0x47, 0xf3, 0x87, 0xb5, 0x83, 0xbf, 0x75, 0x68,
	0x5c, 0x1c, 0x9a, 0x93, 0x84, 0xcc, 0xd7, 0x8c, 0x0c, 0xeb, 0x43, 0xf3, 0x0c, 0xad, 0x47, 0x7e,
	0xf7, 0xea, 0xe6, 0xe6, 0xfc, 0x74, 0x2a, 0x38, 0xb6, 0x53, 0x66, 0x5e, 0x3e, 0x3f, 0xe7, 0xe5,
	0x23, 0x51, 0xa3, 0xe1, 0xdc, 0x39, 0x76, 0x07, 0xab, 0x67, 0x68, 0x8b, 0xa2, 0x66, 0xaf, 0xcb,
	0xd9, 0x95, 0x17, 0xe5, 0xb4, 0x1e, 0x0f, 0x9c, 0x74, 0xd2, 0xb0, 0x95, 0xca, 0xc9, 0xc3, 0xc8,
	0xa4, 0x3c, 0x04, 0x76, 0xd3, 0x17, 0xe1, 0x44, 0x71, 0x19, 0xb0, 0x2a, 0xc6, 0xe5, 0x2b, 0x71,
	0x5e, 0x3d, 0x16, 0x36, 0xe9, 0xa7, 0x60, 0xe3, 0x0c, 0x6d, 0x71, 0xab, 0xc9, 0x86, 0xaa, 0xa6,
	0xab, 0x94, 0x6b, 0xd5, 0x74, 0xd5, 0x22, 0x71, 0xe7, 0x6e, 0x9f, 0xa4, 0x8f, 0xe1, 0xbb, 0x7f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x9b, 0xaf, 0x7c, 0xd6, 0x6f, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// K8SCloudOperatorClient is the client API for K8SCloudOperator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type K8SCloudOperatorClient interface {
	//
	// GetPodVMUUIDAnnotation gets the PV by querying the API server refering to the volumeID in the request.
	// Retrieves the PVC name and Namespace from the PV spec.
	//
	// It then gets the vmuuid annotation from the pod satisfying the below conditions
	// 1. Pod Scheduled on node with name "nodeName"
	// 2. Pod is in pending state in the same namespace as pvc specified using "pvcNamespace"
	// 3. Pod has a volume with name "pvcName" associated with it
	//
	// The annotation might not be available immediately when the Pod is created.
	// So polling the Pod periodically every pollInterval seconds to check if annotation is available.
	// If annotation is not available after a timeout period, the function errors out.
	GetPodVMUUIDAnnotation(ctx context.Context, in *PodListenerRequest, opts ...grpc.CallOption) (*PodListenerResponse, error)
	//
	// GetHostAnnotation gets the annotation value by querying the API server referring to the annotation key
	// and the host specified in the HostAnnotationRequest
	GetHostAnnotation(ctx context.Context, in *HostAnnotationRequest, opts ...grpc.CallOption) (*HostAnnotationResponse, error)
	//
	// Placement API in PlacePersistenceVolumeClaim selects target storage pool to place the given PVC based on its profile and the topology information.
	// If the given PVC should not be handled by PlacePersistenceVolumeClaim like on vSAN or SPBM based cases, this API is a no-op and returns immediately with PVCPlacementRequest.placeSuccess set to true
	// If the PVC has a mapped storage pool, PlacePersistenceVolumeClaim return true
	// If the placement is successful, the PVC will be annotated with the selected storage pool and the PVCPlacementRequest.placeSuccess is set to true.
	// For unsuccessful placement, the PVCPlacementRequest.placeSuccess will be set to false
	PlacePersistenceVolumeClaim(ctx context.Context, in *PVCPlacementRequest, opts ...grpc.CallOption) (*PVCPlacementResponse, error)
	//
	// To decommission a vSAN Direct datastore we need to migrate all the PSP volumes to other vSAN Direct datastores mounted on the same host.
	// GetStorageVMotionPlan creates a storage vMotion plan as a map where keys are PVs residing in the specified vSAN Direct Datastore
	// and values are other vSAN Direct Datastores into which the PV should be migrated.
	//
	// The outcome of the below service can be one of the two below:
	// 1. All the PSP PVs are mapped to a corresponding datastore. We return storage vMotion plan as response with no error.
	// 2. Some (or all) of the PSP PVs cannot be mapped (may be due to lack of capacity). We return with
	//    appropriate error and return vMotion plan as nil.
	GetStorageVMotionPlan(ctx context.Context, in *StorageVMotionRequest, opts ...grpc.CallOption) (*StorageVMotionResponse, error)
}

type k8SCloudOperatorClient struct {
	cc *grpc.ClientConn
}

func NewK8SCloudOperatorClient(cc *grpc.ClientConn) K8SCloudOperatorClient {
	return &k8SCloudOperatorClient{cc}
}

func (c *k8SCloudOperatorClient) GetPodVMUUIDAnnotation(ctx context.Context, in *PodListenerRequest, opts ...grpc.CallOption) (*PodListenerResponse, error) {
	out := new(PodListenerResponse)
	err := c.cc.Invoke(ctx, "/k8scloudoperator.K8sCloudOperator/GetPodVMUUIDAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *k8SCloudOperatorClient) GetHostAnnotation(ctx context.Context, in *HostAnnotationRequest, opts ...grpc.CallOption) (*HostAnnotationResponse, error) {
	out := new(HostAnnotationResponse)
	err := c.cc.Invoke(ctx, "/k8scloudoperator.K8sCloudOperator/GetHostAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *k8SCloudOperatorClient) PlacePersistenceVolumeClaim(ctx context.Context, in *PVCPlacementRequest, opts ...grpc.CallOption) (*PVCPlacementResponse, error) {
	out := new(PVCPlacementResponse)
	err := c.cc.Invoke(ctx, "/k8scloudoperator.K8sCloudOperator/PlacePersistenceVolumeClaim", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *k8SCloudOperatorClient) GetStorageVMotionPlan(ctx context.Context, in *StorageVMotionRequest, opts ...grpc.CallOption) (*StorageVMotionResponse, error) {
	out := new(StorageVMotionResponse)
	err := c.cc.Invoke(ctx, "/k8scloudoperator.K8sCloudOperator/GetStorageVMotionPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// K8SCloudOperatorServer is the server API for K8SCloudOperator service.
type K8SCloudOperatorServer interface {
	//
	// GetPodVMUUIDAnnotation gets the PV by querying the API server refering to the volumeID in the request.
	// Retrieves the PVC name and Namespace from the PV spec.
	//
	// It then gets the vmuuid annotation from the pod satisfying the below conditions
	// 1. Pod Scheduled on node with name "nodeName"
	// 2. Pod is in pending state in the same namespace as pvc specified using "pvcNamespace"
	// 3. Pod has a volume with name "pvcName" associated with it
	//
	// The annotation might not be available immediately when the Pod is created.
	// So polling the Pod periodically every pollInterval seconds to check if annotation is available.
	// If annotation is not available after a timeout period, the function errors out.
	GetPodVMUUIDAnnotation(context.Context, *PodListenerRequest) (*PodListenerResponse, error)
	//
	// GetHostAnnotation gets the annotation value by querying the API server referring to the annotation key
	// and the host specified in the HostAnnotationRequest
	GetHostAnnotation(context.Context, *HostAnnotationRequest) (*HostAnnotationResponse, error)
	//
	// Placement API in PlacePersistenceVolumeClaim selects target storage pool to place the given PVC based on its profile and the topology information.
	// If the given PVC should not be handled by PlacePersistenceVolumeClaim like on vSAN or SPBM based cases, this API is a no-op and returns immediately with PVCPlacementRequest.placeSuccess set to true
	// If the PVC has a mapped storage pool, PlacePersistenceVolumeClaim return true
	// If the placement is successful, the PVC will be annotated with the selected storage pool and the PVCPlacementRequest.placeSuccess is set to true.
	// For unsuccessful placement, the PVCPlacementRequest.placeSuccess will be set to false
	PlacePersistenceVolumeClaim(context.Context, *PVCPlacementRequest) (*PVCPlacementResponse, error)
	//
	// To decommission a vSAN Direct datastore we need to migrate all the PSP volumes to other SAN Direct datastores mounted on the same host.
	// GetStorageVMotionPlan creates a storage vMotion plan as a map where keys are PVs residing in the specified vSAN Direct Datastore
	// and values are other vSAN Direct Datastores into which the PV should be migrated.
	//
	// The outcome of the below service can be one of the two below:
	// 1. All the PSP PVs are mapped to a corresponding datastore. We return storage vMotion plan as response with no error.
	// 2. Some (or all) of the PSP PVs cannot be mapped (may be due to lack of capacity). We return with
	//    appropriate error and return vMotion plan as nil.
	GetStorageVMotionPlan(context.Context, *StorageVMotionRequest) (*StorageVMotionResponse, error)
}

func RegisterK8SCloudOperatorServer(s *grpc.Server, srv K8SCloudOperatorServer) {
	s.RegisterService(&_K8SCloudOperator_serviceDesc, srv)
}

func _K8SCloudOperator_GetPodVMUUIDAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PodListenerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(K8SCloudOperatorServer).GetPodVMUUIDAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/k8scloudoperator.K8sCloudOperator/GetPodVMUUIDAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(K8SCloudOperatorServer).GetPodVMUUIDAnnotation(ctx, req.(*PodListenerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _K8SCloudOperator_GetHostAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HostAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(K8SCloudOperatorServer).GetHostAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/k8scloudoperator.K8sCloudOperator/GetHostAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(K8SCloudOperatorServer).GetHostAnnotation(ctx, req.(*HostAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _K8SCloudOperator_PlacePersistenceVolumeClaim_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PVCPlacementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(K8SCloudOperatorServer).PlacePersistenceVolumeClaim(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/k8scloudoperator.K8sCloudOperator/PlacePersistenceVolumeClaim",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(K8SCloudOperatorServer).PlacePersistenceVolumeClaim(ctx, req.(*PVCPlacementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _K8SCloudOperator_GetStorageVMotionPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageVMotionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(K8SCloudOperatorServer).GetStorageVMotionPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/k8scloudoperator.K8sCloudOperator/GetStorageVMotionPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(K8SCloudOperatorServer).GetStorageVMotionPlan(ctx, req.(*StorageVMotionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _K8SCloudOperator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "k8scloudoperator.K8sCloudOperator",
	HandlerType: (*K8SCloudOperatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPodVMUUIDAnnotation",
			Handler:    _K8SCloudOperator_GetPodVMUUIDAnnotation_Handler,
		},
		{
			MethodName: "GetHostAnnotation",
			Handler:    _K8SCloudOperator_GetHostAnnotation_Handler,
		},
		{
			MethodName: "PlacePersistenceVolumeClaim",
			Handler:    _K8SCloudOperator_PlacePersistenceVolumeClaim_Handler,
		},
		{
			MethodName: "GetStorageVMotionPlan",
			Handler:    _K8SCloudOperator_GetStorageVMotionPlan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "k8scloudoperator.proto",
}
