# Kubelet Config Snippet

To avoid KubeletConfig custom resource limitation, we introduced the experimental
kubelet config snippet annotation `kubeletconfig.experimental`.
It gives you a way to configure an additional set of kubelet parameters on top of
the KubeletConfig custom resource generated by the performance-addon-operator.
But take into account that it is the experimental feature, and we do not have any validations
for the kubelet config snippet that you will provide under the annotation,
so please make sure to set only parameters specified under the [v1beta1 specification](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
Also, by default, the performance-addon-operator will override:

1. CPU manager policy
2. CPU manager reconcile period
3. Topology manager policy
4. Reserved CPUs
5. Memory manager policy

Please avoid specifying them and use the relevant API to configure these parameters.

## Examples

To update the KubeletConfig CR, you should pass the KubeletConfig v1beta1 snippet in the json format.

### Setting unsafe sysctl

```yaml
apiVersion: performance.openshift.io/v2
kind: PerformanceProfile
metadata:
  name: unsafe-sysctl-performanceprofile
  annotations:
    kubeletconfig.experimental: |
      {"allowedUnsafeSysctls":["net.core.somaxconn"]}
spec:
  ...
```
