/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha2 "knative.dev/eventing/pkg/apis/sources/v1alpha2"
	scheme "knative.dev/eventing/pkg/client/clientset/versioned/scheme"
)

// ContainerSourcesGetter has a method to return a ContainerSourceInterface.
// A group's client should implement this interface.
type ContainerSourcesGetter interface {
	ContainerSources(namespace string) ContainerSourceInterface
}

// ContainerSourceInterface has methods to work with ContainerSource resources.
type ContainerSourceInterface interface {
	Create(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.CreateOptions) (*v1alpha2.ContainerSource, error)
	Update(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.UpdateOptions) (*v1alpha2.ContainerSource, error)
	UpdateStatus(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.UpdateOptions) (*v1alpha2.ContainerSource, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.ContainerSource, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.ContainerSourceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.ContainerSource, err error)
	ContainerSourceExpansion
}

// containerSources implements ContainerSourceInterface
type containerSources struct {
	client rest.Interface
	ns     string
}

// newContainerSources returns a ContainerSources
func newContainerSources(c *SourcesV1alpha2Client, namespace string) *containerSources {
	return &containerSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the containerSource, and returns the corresponding containerSource object, and an error if there is any.
func (c *containerSources) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ContainerSources that match those selectors.
func (c *containerSources) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.ContainerSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.ContainerSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested containerSources.
func (c *containerSources) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a containerSource and creates it.  Returns the server's representation of the containerSource, and an error, if there is any.
func (c *containerSources) Create(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.CreateOptions) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerSource).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a containerSource and updates it. Returns the server's representation of the containerSource, and an error, if there is any.
func (c *containerSources) Update(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.UpdateOptions) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containersources").
		Name(containerSource.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerSource).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *containerSources) UpdateStatus(ctx context.Context, containerSource *v1alpha2.ContainerSource, opts v1.UpdateOptions) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containersources").
		Name(containerSource.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerSource).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the containerSource and deletes it. Returns an error if one occurs.
func (c *containerSources) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containersources").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *containerSources) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched containerSource.
func (c *containerSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("containersources").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
