#!/usr/bin/env bash

# Copyright 2018 The Knative Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -o errexit
set -o nounset
set -o pipefail

source $(dirname $0)/../vendor/knative.dev/hack/codegen-library.sh

# If we run with -mod=vendor here, then generate-groups.sh looks for vendor files in the wrong place.
export GOFLAGS=-mod=

echo "=== Update Codegen for $MODULE_NAME"

group "Kubernetes Codegen"

# generate the code with:
# --output-base    because this script should also be able to run inside the vendor dir of
#                  k8s.io/kubernetes. The output-base is needed for the generators to output into the vendor dir
#                  instead of the $GOPATH directly. For normal projects this can be dropped.
${CODEGEN_PKG}/generate-groups.sh "deepcopy,client,informer,lister" \
"knative.dev/eventing-kafka/pkg/client" "knative.dev/eventing-kafka/pkg/apis" \
"sources:v1alpha1 sources:v1beta1 bindings:v1alpha1 bindings:v1beta1 messaging:v1beta1 kafka:v1alpha1" \
--go-header-file ${REPO_ROOT_DIR}/hack/boilerplate.go.txt

# Only deepcopy the Duck types, as they are not real resources.
chmod +x ${CODEGEN_PKG}/generate-groups.sh
${CODEGEN_PKG}/generate-groups.sh "deepcopy" \
  knative.dev/eventing-kafka/pkg/client knative.dev/eventing-kafka/pkg/apis \
  "duck:v1alpha1" \
  --go-header-file ${REPO_ROOT_DIR}/hack/boilerplate.go.txt

group "Knative Codegen"

# Knative Injection
${KNATIVE_CODEGEN_PKG}/hack/generate-knative.sh "injection" \
"knative.dev/eventing-kafka/pkg/client" "knative.dev/eventing-kafka/pkg/apis" \
"sources:v1alpha1 sources:v1beta1 bindings:v1alpha1 bindings:v1beta1 messaging:v1beta1 kafka:v1alpha1" \
--go-header-file ${REPO_ROOT_DIR}/hack/boilerplate.go.txt

group "Deepcopy Gen"

# Depends on generate-groups.sh to install bin/deepcopy-gen
${GOPATH}/bin/deepcopy-gen \
  -O zz_generated.deepcopy \
  --go-header-file ${REPO_ROOT_DIR}/hack/boilerplate.go.txt

group "Update deps post-codegen"

# Make sure our dependencies are up-to-date
${REPO_ROOT_DIR}/hack/update-deps.sh
