/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1beta1 "knative.dev/eventing-kafka/pkg/apis/bindings/v1beta1"
)

// KafkaBindingLister helps list KafkaBindings.
type KafkaBindingLister interface {
	// List lists all KafkaBindings in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.KafkaBinding, err error)
	// KafkaBindings returns an object that can list and get KafkaBindings.
	KafkaBindings(namespace string) KafkaBindingNamespaceLister
	KafkaBindingListerExpansion
}

// kafkaBindingLister implements the KafkaBindingLister interface.
type kafkaBindingLister struct {
	indexer cache.Indexer
}

// NewKafkaBindingLister returns a new KafkaBindingLister.
func NewKafkaBindingLister(indexer cache.Indexer) KafkaBindingLister {
	return &kafkaBindingLister{indexer: indexer}
}

// List lists all KafkaBindings in the indexer.
func (s *kafkaBindingLister) List(selector labels.Selector) (ret []*v1beta1.KafkaBinding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.KafkaBinding))
	})
	return ret, err
}

// KafkaBindings returns an object that can list and get KafkaBindings.
func (s *kafkaBindingLister) KafkaBindings(namespace string) KafkaBindingNamespaceLister {
	return kafkaBindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KafkaBindingNamespaceLister helps list and get KafkaBindings.
type KafkaBindingNamespaceLister interface {
	// List lists all KafkaBindings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.KafkaBinding, err error)
	// Get retrieves the KafkaBinding from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.KafkaBinding, error)
	KafkaBindingNamespaceListerExpansion
}

// kafkaBindingNamespaceLister implements the KafkaBindingNamespaceLister
// interface.
type kafkaBindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KafkaBindings in the indexer for a given namespace.
func (s kafkaBindingNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.KafkaBinding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.KafkaBinding))
	})
	return ret, err
}

// Get retrieves the KafkaBinding from the indexer for a given namespace and name.
func (s kafkaBindingNamespaceLister) Get(name string) (*v1beta1.KafkaBinding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("kafkabinding"), name)
	}
	return obj.(*v1beta1.KafkaBinding), nil
}
