/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing-kafka/pkg/apis/kafka/v1alpha1"
)

// FakeResetOffsets implements ResetOffsetInterface
type FakeResetOffsets struct {
	Fake *FakeKafkaV1alpha1
	ns   string
}

var resetoffsetsResource = schema.GroupVersionResource{Group: "kafka.eventing.knative.dev", Version: "v1alpha1", Resource: "resetoffsets"}

var resetoffsetsKind = schema.GroupVersionKind{Group: "kafka.eventing.knative.dev", Version: "v1alpha1", Kind: "ResetOffset"}

// Get takes name of the resetOffset, and returns the corresponding resetOffset object, and an error if there is any.
func (c *FakeResetOffsets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ResetOffset, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(resetoffsetsResource, c.ns, name), &v1alpha1.ResetOffset{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResetOffset), err
}

// List takes label and field selectors, and returns the list of ResetOffsets that match those selectors.
func (c *FakeResetOffsets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ResetOffsetList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(resetoffsetsResource, resetoffsetsKind, c.ns, opts), &v1alpha1.ResetOffsetList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ResetOffsetList{ListMeta: obj.(*v1alpha1.ResetOffsetList).ListMeta}
	for _, item := range obj.(*v1alpha1.ResetOffsetList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested resetOffsets.
func (c *FakeResetOffsets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(resetoffsetsResource, c.ns, opts))

}

// Create takes the representation of a resetOffset and creates it.  Returns the server's representation of the resetOffset, and an error, if there is any.
func (c *FakeResetOffsets) Create(ctx context.Context, resetOffset *v1alpha1.ResetOffset, opts v1.CreateOptions) (result *v1alpha1.ResetOffset, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(resetoffsetsResource, c.ns, resetOffset), &v1alpha1.ResetOffset{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResetOffset), err
}

// Update takes the representation of a resetOffset and updates it. Returns the server's representation of the resetOffset, and an error, if there is any.
func (c *FakeResetOffsets) Update(ctx context.Context, resetOffset *v1alpha1.ResetOffset, opts v1.UpdateOptions) (result *v1alpha1.ResetOffset, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(resetoffsetsResource, c.ns, resetOffset), &v1alpha1.ResetOffset{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResetOffset), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeResetOffsets) UpdateStatus(ctx context.Context, resetOffset *v1alpha1.ResetOffset, opts v1.UpdateOptions) (*v1alpha1.ResetOffset, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(resetoffsetsResource, "status", c.ns, resetOffset), &v1alpha1.ResetOffset{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResetOffset), err
}

// Delete takes name of the resetOffset and deletes it. Returns an error if one occurs.
func (c *FakeResetOffsets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(resetoffsetsResource, c.ns, name), &v1alpha1.ResetOffset{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeResetOffsets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(resetoffsetsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.ResetOffsetList{})
	return err
}

// Patch applies the patch and returns the patched resetOffset.
func (c *FakeResetOffsets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ResetOffset, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(resetoffsetsResource, c.ns, name, pt, data, subresources...), &v1alpha1.ResetOffset{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResetOffset), err
}
