/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "knative.dev/eventing-kafka/pkg/apis/bindings/v1beta1"
)

// FakeKafkaBindings implements KafkaBindingInterface
type FakeKafkaBindings struct {
	Fake *FakeBindingsV1beta1
	ns   string
}

var kafkabindingsResource = schema.GroupVersionResource{Group: "bindings.knative.dev", Version: "v1beta1", Resource: "kafkabindings"}

var kafkabindingsKind = schema.GroupVersionKind{Group: "bindings.knative.dev", Version: "v1beta1", Kind: "KafkaBinding"}

// Get takes name of the kafkaBinding, and returns the corresponding kafkaBinding object, and an error if there is any.
func (c *FakeKafkaBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.KafkaBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kafkabindingsResource, c.ns, name), &v1beta1.KafkaBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaBinding), err
}

// List takes label and field selectors, and returns the list of KafkaBindings that match those selectors.
func (c *FakeKafkaBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.KafkaBindingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kafkabindingsResource, kafkabindingsKind, c.ns, opts), &v1beta1.KafkaBindingList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.KafkaBindingList{ListMeta: obj.(*v1beta1.KafkaBindingList).ListMeta}
	for _, item := range obj.(*v1beta1.KafkaBindingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kafkaBindings.
func (c *FakeKafkaBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kafkabindingsResource, c.ns, opts))

}

// Create takes the representation of a kafkaBinding and creates it.  Returns the server's representation of the kafkaBinding, and an error, if there is any.
func (c *FakeKafkaBindings) Create(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.CreateOptions) (result *v1beta1.KafkaBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kafkabindingsResource, c.ns, kafkaBinding), &v1beta1.KafkaBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaBinding), err
}

// Update takes the representation of a kafkaBinding and updates it. Returns the server's representation of the kafkaBinding, and an error, if there is any.
func (c *FakeKafkaBindings) Update(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (result *v1beta1.KafkaBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kafkabindingsResource, c.ns, kafkaBinding), &v1beta1.KafkaBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaBinding), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKafkaBindings) UpdateStatus(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (*v1beta1.KafkaBinding, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kafkabindingsResource, "status", c.ns, kafkaBinding), &v1beta1.KafkaBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaBinding), err
}

// Delete takes name of the kafkaBinding and deletes it. Returns an error if one occurs.
func (c *FakeKafkaBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(kafkabindingsResource, c.ns, name), &v1beta1.KafkaBinding{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKafkaBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kafkabindingsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.KafkaBindingList{})
	return err
}

// Patch applies the patch and returns the patched kafkaBinding.
func (c *FakeKafkaBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.KafkaBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kafkabindingsResource, c.ns, name, pt, data, subresources...), &v1beta1.KafkaBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaBinding), err
}
