/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "knative.dev/eventing/pkg/apis/sources/v1beta1"
)

// FakeContainerSources implements ContainerSourceInterface
type FakeContainerSources struct {
	Fake *FakeSourcesV1beta1
	ns   string
}

var containersourcesResource = schema.GroupVersionResource{Group: "sources.knative.dev", Version: "v1beta1", Resource: "containersources"}

var containersourcesKind = schema.GroupVersionKind{Group: "sources.knative.dev", Version: "v1beta1", Kind: "ContainerSource"}

// Get takes name of the containerSource, and returns the corresponding containerSource object, and an error if there is any.
func (c *FakeContainerSources) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ContainerSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(containersourcesResource, c.ns, name), &v1beta1.ContainerSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ContainerSource), err
}

// List takes label and field selectors, and returns the list of ContainerSources that match those selectors.
func (c *FakeContainerSources) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ContainerSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(containersourcesResource, containersourcesKind, c.ns, opts), &v1beta1.ContainerSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.ContainerSourceList{ListMeta: obj.(*v1beta1.ContainerSourceList).ListMeta}
	for _, item := range obj.(*v1beta1.ContainerSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested containerSources.
func (c *FakeContainerSources) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(containersourcesResource, c.ns, opts))

}

// Create takes the representation of a containerSource and creates it.  Returns the server's representation of the containerSource, and an error, if there is any.
func (c *FakeContainerSources) Create(ctx context.Context, containerSource *v1beta1.ContainerSource, opts v1.CreateOptions) (result *v1beta1.ContainerSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(containersourcesResource, c.ns, containerSource), &v1beta1.ContainerSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ContainerSource), err
}

// Update takes the representation of a containerSource and updates it. Returns the server's representation of the containerSource, and an error, if there is any.
func (c *FakeContainerSources) Update(ctx context.Context, containerSource *v1beta1.ContainerSource, opts v1.UpdateOptions) (result *v1beta1.ContainerSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(containersourcesResource, c.ns, containerSource), &v1beta1.ContainerSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ContainerSource), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeContainerSources) UpdateStatus(ctx context.Context, containerSource *v1beta1.ContainerSource, opts v1.UpdateOptions) (*v1beta1.ContainerSource, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(containersourcesResource, "status", c.ns, containerSource), &v1beta1.ContainerSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ContainerSource), err
}

// Delete takes name of the containerSource and deletes it. Returns an error if one occurs.
func (c *FakeContainerSources) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(containersourcesResource, c.ns, name), &v1beta1.ContainerSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeContainerSources) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(containersourcesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.ContainerSourceList{})
	return err
}

// Patch applies the patch and returns the patched containerSource.
func (c *FakeContainerSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ContainerSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(containersourcesResource, c.ns, name, pt, data, subresources...), &v1beta1.ContainerSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ContainerSource), err
}
