// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/firestore/v1/firestore.proto

package firestore

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of change.
type TargetChange_TargetChangeType int32

const (
	// No change has occurred. Used only to send an updated `resume_token`.
	TargetChange_NO_CHANGE TargetChange_TargetChangeType = 0
	// The targets have been added.
	TargetChange_ADD TargetChange_TargetChangeType = 1
	// The targets have been removed.
	TargetChange_REMOVE TargetChange_TargetChangeType = 2
	// The targets reflect all changes committed before the targets were added
	// to the stream.
	//
	// This will be sent after or with a `read_time` that is greater than or
	// equal to the time at which the targets were added.
	//
	// Listeners can wait for this change if read-after-write semantics
	// are desired.
	TargetChange_CURRENT TargetChange_TargetChangeType = 3
	// The targets have been reset, and a new initial state for the targets
	// will be returned in subsequent changes.
	//
	// After the initial state is complete, `CURRENT` will be returned even
	// if the target was previously indicated to be `CURRENT`.
	TargetChange_RESET TargetChange_TargetChangeType = 4
)

// Enum value maps for TargetChange_TargetChangeType.
var (
	TargetChange_TargetChangeType_name = map[int32]string{
		0: "NO_CHANGE",
		1: "ADD",
		2: "REMOVE",
		3: "CURRENT",
		4: "RESET",
	}
	TargetChange_TargetChangeType_value = map[string]int32{
		"NO_CHANGE": 0,
		"ADD":       1,
		"REMOVE":    2,
		"CURRENT":   3,
		"RESET":     4,
	}
)

func (x TargetChange_TargetChangeType) Enum() *TargetChange_TargetChangeType {
	p := new(TargetChange_TargetChangeType)
	*p = x
	return p
}

func (x TargetChange_TargetChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetChange_TargetChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_firestore_proto_enumTypes[0].Descriptor()
}

func (TargetChange_TargetChangeType) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_firestore_proto_enumTypes[0]
}

func (x TargetChange_TargetChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetChange_TargetChangeType.Descriptor instead.
func (TargetChange_TargetChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{22, 0}
}

// The request for [Firestore.GetDocument][google.firestore.v1.Firestore.GetDocument].
type GetDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Document to get. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,2,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are assignable to ConsistencySelector:
	//	*GetDocumentRequest_Transaction
	//	*GetDocumentRequest_ReadTime
	ConsistencySelector isGetDocumentRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (x *GetDocumentRequest) Reset() {
	*x = GetDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentRequest) ProtoMessage() {}

func (x *GetDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentRequest.ProtoReflect.Descriptor instead.
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{0}
}

func (x *GetDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDocumentRequest) GetMask() *DocumentMask {
	if x != nil {
		return x.Mask
	}
	return nil
}

func (m *GetDocumentRequest) GetConsistencySelector() isGetDocumentRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (x *GetDocumentRequest) GetTransaction() []byte {
	if x, ok := x.GetConsistencySelector().(*GetDocumentRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (x *GetDocumentRequest) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetConsistencySelector().(*GetDocumentRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

type isGetDocumentRequest_ConsistencySelector interface {
	isGetDocumentRequest_ConsistencySelector()
}

type GetDocumentRequest_Transaction struct {
	// Reads the document in a transaction.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3,oneof"`
}

type GetDocumentRequest_ReadTime struct {
	// Reads the version of the document at the given time.
	// This may not be older than 270 seconds.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*GetDocumentRequest_Transaction) isGetDocumentRequest_ConsistencySelector() {}

func (*GetDocumentRequest_ReadTime) isGetDocumentRequest_ConsistencySelector() {}

// The request for [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
type ListDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
	// or `messages`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// The maximum number of documents to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The order to sort results by. For example: `priority desc, name`.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,7,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are assignable to ConsistencySelector:
	//	*ListDocumentsRequest_Transaction
	//	*ListDocumentsRequest_ReadTime
	ConsistencySelector isListDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	// If the list should show missing documents. A missing document is a
	// document that does not exist but has sub-documents. These documents will
	// be returned with a key but will not have fields, [Document.create_time][google.firestore.v1.Document.create_time],
	// or [Document.update_time][google.firestore.v1.Document.update_time] set.
	//
	// Requests with `show_missing` may not specify `where` or
	// `order_by`.
	ShowMissing bool `protobuf:"varint,12,opt,name=show_missing,json=showMissing,proto3" json:"show_missing,omitempty"`
}

func (x *ListDocumentsRequest) Reset() {
	*x = ListDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsRequest) ProtoMessage() {}

func (x *ListDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{1}
}

func (x *ListDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDocumentsRequest) GetCollectionId() string {
	if x != nil {
		return x.CollectionId
	}
	return ""
}

func (x *ListDocumentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDocumentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDocumentsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListDocumentsRequest) GetMask() *DocumentMask {
	if x != nil {
		return x.Mask
	}
	return nil
}

func (m *ListDocumentsRequest) GetConsistencySelector() isListDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (x *ListDocumentsRequest) GetTransaction() []byte {
	if x, ok := x.GetConsistencySelector().(*ListDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (x *ListDocumentsRequest) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetConsistencySelector().(*ListDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (x *ListDocumentsRequest) GetShowMissing() bool {
	if x != nil {
		return x.ShowMissing
	}
	return false
}

type isListDocumentsRequest_ConsistencySelector interface {
	isListDocumentsRequest_ConsistencySelector()
}

type ListDocumentsRequest_Transaction struct {
	// Reads documents in a transaction.
	Transaction []byte `protobuf:"bytes,8,opt,name=transaction,proto3,oneof"`
}

type ListDocumentsRequest_ReadTime struct {
	// Reads documents as they were at the given time.
	// This may not be older than 270 seconds.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*ListDocumentsRequest_Transaction) isListDocumentsRequest_ConsistencySelector() {}

func (*ListDocumentsRequest_ReadTime) isListDocumentsRequest_ConsistencySelector() {}

// The response for [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
type ListDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Documents found.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDocumentsResponse) Reset() {
	*x = ListDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsResponse) ProtoMessage() {}

func (x *ListDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{2}
}

func (x *ListDocumentsResponse) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *ListDocumentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [Firestore.CreateDocument][google.firestore.v1.Firestore.CreateDocument].
type CreateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. For example:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// The client-assigned document ID to use for this document.
	//
	// Optional. If not specified, an ID will be assigned by the service.
	DocumentId string `protobuf:"bytes,3,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
	// Required. The document to create. `name` must not be set.
	Document *Document `protobuf:"bytes,4,opt,name=document,proto3" json:"document,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,5,opt,name=mask,proto3" json:"mask,omitempty"`
}

func (x *CreateDocumentRequest) Reset() {
	*x = CreateDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDocumentRequest) ProtoMessage() {}

func (x *CreateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDocumentRequest.ProtoReflect.Descriptor instead.
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{3}
}

func (x *CreateDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDocumentRequest) GetCollectionId() string {
	if x != nil {
		return x.CollectionId
	}
	return ""
}

func (x *CreateDocumentRequest) GetDocumentId() string {
	if x != nil {
		return x.DocumentId
	}
	return ""
}

func (x *CreateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *CreateDocumentRequest) GetMask() *DocumentMask {
	if x != nil {
		return x.Mask
	}
	return nil
}

// The request for [Firestore.UpdateDocument][google.firestore.v1.Firestore.UpdateDocument].
type UpdateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated document.
	// Creates the document if it does not already exist.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The fields to update.
	// None of the field paths in the mask may contain a reserved name.
	//
	// If the document exists on the server and has fields not referenced in the
	// mask, they are left unchanged.
	// Fields referenced in the mask, but not present in the input document, are
	// deleted from the document on the server.
	UpdateMask *DocumentMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask,proto3" json:"mask,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument *Precondition `protobuf:"bytes,4,opt,name=current_document,json=currentDocument,proto3" json:"current_document,omitempty"`
}

func (x *UpdateDocumentRequest) Reset() {
	*x = UpdateDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDocumentRequest) ProtoMessage() {}

func (x *UpdateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDocumentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *UpdateDocumentRequest) GetUpdateMask() *DocumentMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDocumentRequest) GetMask() *DocumentMask {
	if x != nil {
		return x.Mask
	}
	return nil
}

func (x *UpdateDocumentRequest) GetCurrentDocument() *Precondition {
	if x != nil {
		return x.CurrentDocument
	}
	return nil
}

// The request for [Firestore.DeleteDocument][google.firestore.v1.Firestore.DeleteDocument].
type DeleteDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Document to delete. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument *Precondition `protobuf:"bytes,2,opt,name=current_document,json=currentDocument,proto3" json:"current_document,omitempty"`
}

func (x *DeleteDocumentRequest) Reset() {
	*x = DeleteDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentRequest) ProtoMessage() {}

func (x *DeleteDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDocumentRequest) GetCurrentDocument() *Precondition {
	if x != nil {
		return x.CurrentDocument
	}
	return nil
}

// The request for [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
type BatchGetDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of the
	// given `database`. Duplicate names will be elided.
	Documents []string `protobuf:"bytes,2,rep,name=documents,proto3" json:"documents,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field will
	// not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask,proto3" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are assignable to ConsistencySelector:
	//	*BatchGetDocumentsRequest_Transaction
	//	*BatchGetDocumentsRequest_NewTransaction
	//	*BatchGetDocumentsRequest_ReadTime
	ConsistencySelector isBatchGetDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (x *BatchGetDocumentsRequest) Reset() {
	*x = BatchGetDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsRequest) ProtoMessage() {}

func (x *BatchGetDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsRequest.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{6}
}

func (x *BatchGetDocumentsRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *BatchGetDocumentsRequest) GetDocuments() []string {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *BatchGetDocumentsRequest) GetMask() *DocumentMask {
	if x != nil {
		return x.Mask
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetConsistencySelector() isBatchGetDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (x *BatchGetDocumentsRequest) GetTransaction() []byte {
	if x, ok := x.GetConsistencySelector().(*BatchGetDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (x *BatchGetDocumentsRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := x.GetConsistencySelector().(*BatchGetDocumentsRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (x *BatchGetDocumentsRequest) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetConsistencySelector().(*BatchGetDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

type isBatchGetDocumentsRequest_ConsistencySelector interface {
	isBatchGetDocumentsRequest_ConsistencySelector()
}

type BatchGetDocumentsRequest_Transaction struct {
	// Reads documents in a transaction.
	Transaction []byte `protobuf:"bytes,4,opt,name=transaction,proto3,oneof"`
}

type BatchGetDocumentsRequest_NewTransaction struct {
	// Starts a new transaction and reads the documents.
	// Defaults to a read-only transaction.
	// The new transaction ID will be returned as the first response in the
	// stream.
	NewTransaction *TransactionOptions `protobuf:"bytes,5,opt,name=new_transaction,json=newTransaction,proto3,oneof"`
}

type BatchGetDocumentsRequest_ReadTime struct {
	// Reads documents as they were at the given time.
	// This may not be older than 270 seconds.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*BatchGetDocumentsRequest_Transaction) isBatchGetDocumentsRequest_ConsistencySelector() {}

func (*BatchGetDocumentsRequest_NewTransaction) isBatchGetDocumentsRequest_ConsistencySelector() {}

func (*BatchGetDocumentsRequest_ReadTime) isBatchGetDocumentsRequest_ConsistencySelector() {}

// The streamed response for [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
type BatchGetDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A single result.
	// This can be empty if the server is just returning a transaction.
	//
	// Types that are assignable to Result:
	//	*BatchGetDocumentsResponse_Found
	//	*BatchGetDocumentsResponse_Missing
	Result isBatchGetDocumentsResponse_Result `protobuf_oneof:"result"`
	// The transaction that was started as part of this request.
	// Will only be set in the first response, and only if
	// [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction] was set in the request.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// The time at which the document was read.
	// This may be monotically increasing, in this case the previous documents in
	// the result stream are guaranteed not to have changed between their
	// read_time and this one.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *BatchGetDocumentsResponse) Reset() {
	*x = BatchGetDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsResponse) ProtoMessage() {}

func (x *BatchGetDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsResponse.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{7}
}

func (m *BatchGetDocumentsResponse) GetResult() isBatchGetDocumentsResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *BatchGetDocumentsResponse) GetFound() *Document {
	if x, ok := x.GetResult().(*BatchGetDocumentsResponse_Found); ok {
		return x.Found
	}
	return nil
}

func (x *BatchGetDocumentsResponse) GetMissing() string {
	if x, ok := x.GetResult().(*BatchGetDocumentsResponse_Missing); ok {
		return x.Missing
	}
	return ""
}

func (x *BatchGetDocumentsResponse) GetTransaction() []byte {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *BatchGetDocumentsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

type isBatchGetDocumentsResponse_Result interface {
	isBatchGetDocumentsResponse_Result()
}

type BatchGetDocumentsResponse_Found struct {
	// A document that was requested.
	Found *Document `protobuf:"bytes,1,opt,name=found,proto3,oneof"`
}

type BatchGetDocumentsResponse_Missing struct {
	// A document name that was requested but does not exist. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Missing string `protobuf:"bytes,2,opt,name=missing,proto3,oneof"`
}

func (*BatchGetDocumentsResponse_Found) isBatchGetDocumentsResponse_Result() {}

func (*BatchGetDocumentsResponse_Missing) isBatchGetDocumentsResponse_Result() {}

// The request for [Firestore.BeginTransaction][google.firestore.v1.Firestore.BeginTransaction].
type BeginTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The options for the transaction.
	// Defaults to a read-write transaction.
	Options *TransactionOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *BeginTransactionRequest) Reset() {
	*x = BeginTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginTransactionRequest) ProtoMessage() {}

func (x *BeginTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginTransactionRequest.ProtoReflect.Descriptor instead.
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{8}
}

func (x *BeginTransactionRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// The response for [Firestore.BeginTransaction][google.firestore.v1.Firestore.BeginTransaction].
type BeginTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transaction that was started.
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *BeginTransactionResponse) Reset() {
	*x = BeginTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginTransactionResponse) ProtoMessage() {}

func (x *BeginTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginTransactionResponse.ProtoReflect.Descriptor instead.
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{9}
}

func (x *BeginTransactionResponse) GetTransaction() []byte {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The request for [Firestore.Commit][google.firestore.v1.Firestore.Commit].
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	Writes []*Write `protobuf:"bytes,2,rep,name=writes,proto3" json:"writes,omitempty"`
	// If set, applies all writes in this transaction, and commits it.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{10}
}

func (x *CommitRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CommitRequest) GetWrites() []*Write {
	if x != nil {
		return x.Writes
	}
	return nil
}

func (x *CommitRequest) GetTransaction() []byte {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The response for [Firestore.Commit][google.firestore.v1.Firestore.Commit].
type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,1,rep,name=write_results,json=writeResults,proto3" json:"write_results,omitempty"`
	// The time at which the commit occurred. Any read with an equal or greater
	// `read_time` is guaranteed to see the effects of the commit.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{11}
}

func (x *CommitResponse) GetWriteResults() []*WriteResult {
	if x != nil {
		return x.WriteResults
	}
	return nil
}

func (x *CommitResponse) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

// The request for [Firestore.Rollback][google.firestore.v1.Firestore.Rollback].
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Required. The transaction to roll back.
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{12}
}

func (x *RollbackRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *RollbackRequest) GetTransaction() []byte {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The request for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
type RunQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are assignable to QueryType:
	//	*RunQueryRequest_StructuredQuery
	QueryType isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are assignable to ConsistencySelector:
	//	*RunQueryRequest_Transaction
	//	*RunQueryRequest_NewTransaction
	//	*RunQueryRequest_ReadTime
	ConsistencySelector isRunQueryRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (x *RunQueryRequest) Reset() {
	*x = RunQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunQueryRequest) ProtoMessage() {}

func (x *RunQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunQueryRequest.ProtoReflect.Descriptor instead.
func (*RunQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{13}
}

func (x *RunQueryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (x *RunQueryRequest) GetStructuredQuery() *StructuredQuery {
	if x, ok := x.GetQueryType().(*RunQueryRequest_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

func (m *RunQueryRequest) GetConsistencySelector() isRunQueryRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (x *RunQueryRequest) GetTransaction() []byte {
	if x, ok := x.GetConsistencySelector().(*RunQueryRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (x *RunQueryRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := x.GetConsistencySelector().(*RunQueryRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (x *RunQueryRequest) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetConsistencySelector().(*RunQueryRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_StructuredQuery struct {
	// A structured query.
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*RunQueryRequest_StructuredQuery) isRunQueryRequest_QueryType() {}

type isRunQueryRequest_ConsistencySelector interface {
	isRunQueryRequest_ConsistencySelector()
}

type RunQueryRequest_Transaction struct {
	// Reads documents in a transaction.
	Transaction []byte `protobuf:"bytes,5,opt,name=transaction,proto3,oneof"`
}

type RunQueryRequest_NewTransaction struct {
	// Starts a new transaction and reads the documents.
	// Defaults to a read-only transaction.
	// The new transaction ID will be returned as the first response in the
	// stream.
	NewTransaction *TransactionOptions `protobuf:"bytes,6,opt,name=new_transaction,json=newTransaction,proto3,oneof"`
}

type RunQueryRequest_ReadTime struct {
	// Reads documents as they were at the given time.
	// This may not be older than 270 seconds.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*RunQueryRequest_Transaction) isRunQueryRequest_ConsistencySelector() {}

func (*RunQueryRequest_NewTransaction) isRunQueryRequest_ConsistencySelector() {}

func (*RunQueryRequest_ReadTime) isRunQueryRequest_ConsistencySelector() {}

// The response for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
type RunQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transaction that was started as part of this request.
	// Can only be set in the first response, and only if
	// [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction] was set in the request.
	// If set, no other fields will be set in this response.
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// A query result.
	// Not set when reporting partial progress.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The time at which the document was read. This may be monotonically
	// increasing; in this case, the previous documents in the result stream are
	// guaranteed not to have changed between their `read_time` and this one.
	//
	// If the query returns no results, a response with `read_time` and no
	// `document` will be sent, and this represents the time at which the query
	// was run.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// The number of results that have been skipped due to an offset between
	// the last response and the current response.
	SkippedResults int32 `protobuf:"varint,4,opt,name=skipped_results,json=skippedResults,proto3" json:"skipped_results,omitempty"`
}

func (x *RunQueryResponse) Reset() {
	*x = RunQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunQueryResponse) ProtoMessage() {}

func (x *RunQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunQueryResponse.ProtoReflect.Descriptor instead.
func (*RunQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{14}
}

func (x *RunQueryResponse) GetTransaction() []byte {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *RunQueryResponse) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *RunQueryResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *RunQueryResponse) GetSkippedResults() int32 {
	if x != nil {
		return x.SkippedResults
	}
	return 0
}

// The request for [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
type PartitionQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents`.
	// Document resource names are not supported; only database resource names
	// can be specified.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to partition.
	//
	// Types that are assignable to QueryType:
	//	*PartitionQueryRequest_StructuredQuery
	QueryType isPartitionQueryRequest_QueryType `protobuf_oneof:"query_type"`
	// The desired maximum number of partition points.
	// The partitions may be returned across multiple pages of results.
	// The number must be positive. The actual number of partitions
	// returned may be fewer.
	//
	// For example, this may be set to one fewer than the number of parallel
	// queries to be run, or in running a data pipeline job, one fewer than the
	// number of workers or compute instances available.
	PartitionCount int64 `protobuf:"varint,3,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	// The `next_page_token` value returned from a previous call to
	// PartitionQuery that may be used to get an additional set of results.
	// There are no ordering guarantees between sets of results. Thus, using
	// multiple sets of results will require merging the different result sets.
	//
	// For example, two subsequent calls using a page_token may return:
	//
	//  * cursor B, cursor M, cursor Q
	//  * cursor A, cursor U, cursor W
	//
	// To obtain a complete result set ordered with respect to the results of the
	// query supplied to PartitionQuery, the results sets should be merged:
	// cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of partitions to return in this call, subject to
	// `partition_count`.
	//
	// For example, if `partition_count` = 10 and `page_size` = 8, the first call
	// to PartitionQuery will return up to 8 partitions and a `next_page_token`
	// if more results exist. A second call to PartitionQuery will return up to
	// 2 partitions, to complete the total of 10 specified in `partition_count`.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *PartitionQueryRequest) Reset() {
	*x = PartitionQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionQueryRequest) ProtoMessage() {}

func (x *PartitionQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionQueryRequest.ProtoReflect.Descriptor instead.
func (*PartitionQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{15}
}

func (x *PartitionQueryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *PartitionQueryRequest) GetQueryType() isPartitionQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (x *PartitionQueryRequest) GetStructuredQuery() *StructuredQuery {
	if x, ok := x.GetQueryType().(*PartitionQueryRequest_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

func (x *PartitionQueryRequest) GetPartitionCount() int64 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *PartitionQueryRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *PartitionQueryRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

type isPartitionQueryRequest_QueryType interface {
	isPartitionQueryRequest_QueryType()
}

type PartitionQueryRequest_StructuredQuery struct {
	// A structured query.
	// Query must specify collection with all descendants and be ordered by name
	// ascending. Other filters, order bys, limits, offsets, and start/end
	// cursors are not supported.
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*PartitionQueryRequest_StructuredQuery) isPartitionQueryRequest_QueryType() {}

// The response for [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
type PartitionQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition results.
	// Each partition is a split point that can be used by RunQuery as a starting
	// or end point for the query results. The RunQuery requests must be made with
	// the same query supplied to this PartitionQuery request. The partition
	// cursors will be ordered according to same ordering as the results of the
	// query supplied to PartitionQuery.
	//
	// For example, if a PartitionQuery request returns partition cursors A and B,
	// running the following three queries will return the entire result set of
	// the original query:
	//
	//  * query, end_at A
	//  * query, start_at A, end_at B
	//  * query, start_at B
	//
	// An empty result may indicate that the query has too few results to be
	// partitioned.
	Partitions []*Cursor `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// A page token that may be used to request an additional set of results, up
	// to the number specified by `partition_count` in the PartitionQuery request.
	// If blank, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *PartitionQueryResponse) Reset() {
	*x = PartitionQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionQueryResponse) ProtoMessage() {}

func (x *PartitionQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionQueryResponse.ProtoReflect.Descriptor instead.
func (*PartitionQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{16}
}

func (x *PartitionQueryResponse) GetPartitions() []*Cursor {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *PartitionQueryResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [Firestore.Write][google.firestore.v1.Firestore.Write].
//
// The first request creates a stream, or resumes an existing one from a token.
//
// When creating a new stream, the server replies with a response containing
// only an ID and a token, to use in the next request.
//
// When resuming a stream, the server first streams any responses later than the
// given token, then a response containing only an up-to-date token, to use in
// the next request.
type WriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	// This is only required in the first message.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The ID of the write stream to resume.
	// This may only be set in the first message. When left empty, a new write
	// stream will be created.
	StreamId string `protobuf:"bytes,2,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	// This must be empty on the first request.
	// This may be empty on the last request.
	// This must not be empty on all other requests.
	Writes []*Write `protobuf:"bytes,3,rep,name=writes,proto3" json:"writes,omitempty"`
	// A stream token that was previously sent by the server.
	//
	// The client should set this field to the token from the most recent
	// [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
	// received responses up to this token. After sending this token, earlier
	// tokens may not be used anymore.
	//
	// The server may close the stream if there are too many unacknowledged
	// responses.
	//
	// Leave this field unset when creating a new stream. To resume a stream at
	// a specific point, set this field and the `stream_id` field.
	//
	// Leave this field unset when creating a new stream.
	StreamToken []byte `protobuf:"bytes,4,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// Labels associated with this write request.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WriteRequest) Reset() {
	*x = WriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRequest) ProtoMessage() {}

func (x *WriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRequest.ProtoReflect.Descriptor instead.
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{17}
}

func (x *WriteRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *WriteRequest) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

func (x *WriteRequest) GetWrites() []*Write {
	if x != nil {
		return x.Writes
	}
	return nil
}

func (x *WriteRequest) GetStreamToken() []byte {
	if x != nil {
		return x.StreamToken
	}
	return nil
}

func (x *WriteRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The response for [Firestore.Write][google.firestore.v1.Firestore.Write].
type WriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the stream.
	// Only set on the first message, when a new stream was created.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// A token that represents the position of this response in the stream.
	// This can be used by a client to resume the stream at this point.
	//
	// This field is always set.
	StreamToken []byte `protobuf:"bytes,2,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,3,rep,name=write_results,json=writeResults,proto3" json:"write_results,omitempty"`
	// The time at which the commit occurred. Any read with an equal or greater
	// `read_time` is guaranteed to see the effects of the write.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
}

func (x *WriteResponse) Reset() {
	*x = WriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResponse) ProtoMessage() {}

func (x *WriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResponse.ProtoReflect.Descriptor instead.
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{18}
}

func (x *WriteResponse) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

func (x *WriteResponse) GetStreamToken() []byte {
	if x != nil {
		return x.StreamToken
	}
	return nil
}

func (x *WriteResponse) GetWriteResults() []*WriteResult {
	if x != nil {
		return x.WriteResults
	}
	return nil
}

func (x *WriteResponse) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

// A request for [Firestore.Listen][google.firestore.v1.Firestore.Listen]
type ListenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The supported target changes.
	//
	// Types that are assignable to TargetChange:
	//	*ListenRequest_AddTarget
	//	*ListenRequest_RemoveTarget
	TargetChange isListenRequest_TargetChange `protobuf_oneof:"target_change"`
	// Labels associated with this target change.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ListenRequest) Reset() {
	*x = ListenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenRequest) ProtoMessage() {}

func (x *ListenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenRequest.ProtoReflect.Descriptor instead.
func (*ListenRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{19}
}

func (x *ListenRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (m *ListenRequest) GetTargetChange() isListenRequest_TargetChange {
	if m != nil {
		return m.TargetChange
	}
	return nil
}

func (x *ListenRequest) GetAddTarget() *Target {
	if x, ok := x.GetTargetChange().(*ListenRequest_AddTarget); ok {
		return x.AddTarget
	}
	return nil
}

func (x *ListenRequest) GetRemoveTarget() int32 {
	if x, ok := x.GetTargetChange().(*ListenRequest_RemoveTarget); ok {
		return x.RemoveTarget
	}
	return 0
}

func (x *ListenRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isListenRequest_TargetChange interface {
	isListenRequest_TargetChange()
}

type ListenRequest_AddTarget struct {
	// A target to add to this stream.
	AddTarget *Target `protobuf:"bytes,2,opt,name=add_target,json=addTarget,proto3,oneof"`
}

type ListenRequest_RemoveTarget struct {
	// The ID of a target to remove from this stream.
	RemoveTarget int32 `protobuf:"varint,3,opt,name=remove_target,json=removeTarget,proto3,oneof"`
}

func (*ListenRequest_AddTarget) isListenRequest_TargetChange() {}

func (*ListenRequest_RemoveTarget) isListenRequest_TargetChange() {}

// The response for [Firestore.Listen][google.firestore.v1.Firestore.Listen].
type ListenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The supported responses.
	//
	// Types that are assignable to ResponseType:
	//	*ListenResponse_TargetChange
	//	*ListenResponse_DocumentChange
	//	*ListenResponse_DocumentDelete
	//	*ListenResponse_DocumentRemove
	//	*ListenResponse_Filter
	ResponseType isListenResponse_ResponseType `protobuf_oneof:"response_type"`
}

func (x *ListenResponse) Reset() {
	*x = ListenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenResponse) ProtoMessage() {}

func (x *ListenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenResponse.ProtoReflect.Descriptor instead.
func (*ListenResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{20}
}

func (m *ListenResponse) GetResponseType() isListenResponse_ResponseType {
	if m != nil {
		return m.ResponseType
	}
	return nil
}

func (x *ListenResponse) GetTargetChange() *TargetChange {
	if x, ok := x.GetResponseType().(*ListenResponse_TargetChange); ok {
		return x.TargetChange
	}
	return nil
}

func (x *ListenResponse) GetDocumentChange() *DocumentChange {
	if x, ok := x.GetResponseType().(*ListenResponse_DocumentChange); ok {
		return x.DocumentChange
	}
	return nil
}

func (x *ListenResponse) GetDocumentDelete() *DocumentDelete {
	if x, ok := x.GetResponseType().(*ListenResponse_DocumentDelete); ok {
		return x.DocumentDelete
	}
	return nil
}

func (x *ListenResponse) GetDocumentRemove() *DocumentRemove {
	if x, ok := x.GetResponseType().(*ListenResponse_DocumentRemove); ok {
		return x.DocumentRemove
	}
	return nil
}

func (x *ListenResponse) GetFilter() *ExistenceFilter {
	if x, ok := x.GetResponseType().(*ListenResponse_Filter); ok {
		return x.Filter
	}
	return nil
}

type isListenResponse_ResponseType interface {
	isListenResponse_ResponseType()
}

type ListenResponse_TargetChange struct {
	// Targets have changed.
	TargetChange *TargetChange `protobuf:"bytes,2,opt,name=target_change,json=targetChange,proto3,oneof"`
}

type ListenResponse_DocumentChange struct {
	// A [Document][google.firestore.v1.Document] has changed.
	DocumentChange *DocumentChange `protobuf:"bytes,3,opt,name=document_change,json=documentChange,proto3,oneof"`
}

type ListenResponse_DocumentDelete struct {
	// A [Document][google.firestore.v1.Document] has been deleted.
	DocumentDelete *DocumentDelete `protobuf:"bytes,4,opt,name=document_delete,json=documentDelete,proto3,oneof"`
}

type ListenResponse_DocumentRemove struct {
	// A [Document][google.firestore.v1.Document] has been removed from a target (because it is no longer
	// relevant to that target).
	DocumentRemove *DocumentRemove `protobuf:"bytes,6,opt,name=document_remove,json=documentRemove,proto3,oneof"`
}

type ListenResponse_Filter struct {
	// A filter to apply to the set of documents previously returned for the
	// given target.
	//
	// Returned when documents may have been removed from the given target, but
	// the exact documents are unknown.
	Filter *ExistenceFilter `protobuf:"bytes,5,opt,name=filter,proto3,oneof"`
}

func (*ListenResponse_TargetChange) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentChange) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentDelete) isListenResponse_ResponseType() {}

func (*ListenResponse_DocumentRemove) isListenResponse_ResponseType() {}

func (*ListenResponse_Filter) isListenResponse_ResponseType() {}

// A specification of a set of documents to listen to.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of target to listen to.
	//
	// Types that are assignable to TargetType:
	//	*Target_Query
	//	*Target_Documents
	TargetType isTarget_TargetType `protobuf_oneof:"target_type"`
	// When to start listening.
	//
	// If not specified, all matching Documents are returned before any
	// subsequent changes.
	//
	// Types that are assignable to ResumeType:
	//	*Target_ResumeToken
	//	*Target_ReadTime
	ResumeType isTarget_ResumeType `protobuf_oneof:"resume_type"`
	// The target ID that identifies the target on the stream. Must be a positive
	// number and non-zero.
	TargetId int32 `protobuf:"varint,5,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// If the target should be removed once it is current and consistent.
	Once bool `protobuf:"varint,6,opt,name=once,proto3" json:"once,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{21}
}

func (m *Target) GetTargetType() isTarget_TargetType {
	if m != nil {
		return m.TargetType
	}
	return nil
}

func (x *Target) GetQuery() *Target_QueryTarget {
	if x, ok := x.GetTargetType().(*Target_Query); ok {
		return x.Query
	}
	return nil
}

func (x *Target) GetDocuments() *Target_DocumentsTarget {
	if x, ok := x.GetTargetType().(*Target_Documents); ok {
		return x.Documents
	}
	return nil
}

func (m *Target) GetResumeType() isTarget_ResumeType {
	if m != nil {
		return m.ResumeType
	}
	return nil
}

func (x *Target) GetResumeToken() []byte {
	if x, ok := x.GetResumeType().(*Target_ResumeToken); ok {
		return x.ResumeToken
	}
	return nil
}

func (x *Target) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetResumeType().(*Target_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (x *Target) GetTargetId() int32 {
	if x != nil {
		return x.TargetId
	}
	return 0
}

func (x *Target) GetOnce() bool {
	if x != nil {
		return x.Once
	}
	return false
}

type isTarget_TargetType interface {
	isTarget_TargetType()
}

type Target_Query struct {
	// A target specified by a query.
	Query *Target_QueryTarget `protobuf:"bytes,2,opt,name=query,proto3,oneof"`
}

type Target_Documents struct {
	// A target specified by a set of document names.
	Documents *Target_DocumentsTarget `protobuf:"bytes,3,opt,name=documents,proto3,oneof"`
}

func (*Target_Query) isTarget_TargetType() {}

func (*Target_Documents) isTarget_TargetType() {}

type isTarget_ResumeType interface {
	isTarget_ResumeType()
}

type Target_ResumeToken struct {
	// A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
	//
	// Using a resume token with a different target is unsupported and may fail.
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3,oneof"`
}

type Target_ReadTime struct {
	// Start listening after a specific `read_time`.
	//
	// The client must know the state of matching documents at this time.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*Target_ResumeToken) isTarget_ResumeType() {}

func (*Target_ReadTime) isTarget_ResumeType() {}

// Targets being watched have changed.
type TargetChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of change that occurred.
	TargetChangeType TargetChange_TargetChangeType `protobuf:"varint,1,opt,name=target_change_type,json=targetChangeType,proto3,enum=google.firestore.v1.TargetChange_TargetChangeType" json:"target_change_type,omitempty"`
	// The target IDs of targets that have changed.
	//
	// If empty, the change applies to all targets.
	//
	// The order of the target IDs is not defined.
	TargetIds []int32 `protobuf:"varint,2,rep,packed,name=target_ids,json=targetIds,proto3" json:"target_ids,omitempty"`
	// The error that resulted in this change, if applicable.
	Cause *status.Status `protobuf:"bytes,3,opt,name=cause,proto3" json:"cause,omitempty"`
	// A token that can be used to resume the stream for the given `target_ids`,
	// or all targets if `target_ids` is empty.
	//
	// Not set on every target change.
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// The consistent `read_time` for the given `target_ids` (omitted when the
	// target_ids are not at a consistent snapshot).
	//
	// The stream is guaranteed to send a `read_time` with `target_ids` empty
	// whenever the entire stream reaches a new consistent snapshot. ADD,
	// CURRENT, and RESET messages are guaranteed to (eventually) result in a
	// new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
	//
	// For a given stream, `read_time` is guaranteed to be monotonically
	// increasing.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *TargetChange) Reset() {
	*x = TargetChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetChange) ProtoMessage() {}

func (x *TargetChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetChange.ProtoReflect.Descriptor instead.
func (*TargetChange) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{22}
}

func (x *TargetChange) GetTargetChangeType() TargetChange_TargetChangeType {
	if x != nil {
		return x.TargetChangeType
	}
	return TargetChange_NO_CHANGE
}

func (x *TargetChange) GetTargetIds() []int32 {
	if x != nil {
		return x.TargetIds
	}
	return nil
}

func (x *TargetChange) GetCause() *status.Status {
	if x != nil {
		return x.Cause
	}
	return nil
}

func (x *TargetChange) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *TargetChange) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

// The request for [Firestore.ListCollectionIds][google.firestore.v1.Firestore.ListCollectionIds].
type ListCollectionIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent document. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token. Must be a value from
	// [ListCollectionIdsResponse][google.firestore.v1.ListCollectionIdsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCollectionIdsRequest) Reset() {
	*x = ListCollectionIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCollectionIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionIdsRequest) ProtoMessage() {}

func (x *ListCollectionIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCollectionIdsRequest.ProtoReflect.Descriptor instead.
func (*ListCollectionIdsRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{23}
}

func (x *ListCollectionIdsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCollectionIdsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCollectionIdsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from [Firestore.ListCollectionIds][google.firestore.v1.Firestore.ListCollectionIds].
type ListCollectionIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collection ids.
	CollectionIds []string `protobuf:"bytes,1,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// A page token that may be used to continue the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCollectionIdsResponse) Reset() {
	*x = ListCollectionIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCollectionIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionIdsResponse) ProtoMessage() {}

func (x *ListCollectionIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCollectionIdsResponse.ProtoReflect.Descriptor instead.
func (*ListCollectionIdsResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{24}
}

func (x *ListCollectionIdsResponse) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ListCollectionIdsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [Firestore.BatchWrite][google.firestore.v1.Firestore.BatchWrite].
type BatchWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The writes to apply.
	//
	// Method does not apply writes atomically and does not guarantee ordering.
	// Each write succeeds or fails independently. You cannot write to the same
	// document more than once per request.
	Writes []*Write `protobuf:"bytes,2,rep,name=writes,proto3" json:"writes,omitempty"`
	// Labels associated with this batch write.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchWriteRequest) Reset() {
	*x = BatchWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchWriteRequest) ProtoMessage() {}

func (x *BatchWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchWriteRequest.ProtoReflect.Descriptor instead.
func (*BatchWriteRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{25}
}

func (x *BatchWriteRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *BatchWriteRequest) GetWrites() []*Write {
	if x != nil {
		return x.Writes
	}
	return nil
}

func (x *BatchWriteRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The response from [Firestore.BatchWrite][google.firestore.v1.Firestore.BatchWrite].
type BatchWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,1,rep,name=write_results,json=writeResults,proto3" json:"write_results,omitempty"`
	// The status of applying the writes.
	//
	// This i-th write status corresponds to the i-th write in the
	// request.
	Status []*status.Status `protobuf:"bytes,2,rep,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchWriteResponse) Reset() {
	*x = BatchWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchWriteResponse) ProtoMessage() {}

func (x *BatchWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchWriteResponse.ProtoReflect.Descriptor instead.
func (*BatchWriteResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{26}
}

func (x *BatchWriteResponse) GetWriteResults() []*WriteResult {
	if x != nil {
		return x.WriteResults
	}
	return nil
}

func (x *BatchWriteResponse) GetStatus() []*status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// A target specified by a set of documents names.
type Target_DocumentsTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of
	// the given `database`. Duplicate names will be elided.
	Documents []string `protobuf:"bytes,2,rep,name=documents,proto3" json:"documents,omitempty"`
}

func (x *Target_DocumentsTarget) Reset() {
	*x = Target_DocumentsTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target_DocumentsTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target_DocumentsTarget) ProtoMessage() {}

func (x *Target_DocumentsTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target_DocumentsTarget.ProtoReflect.Descriptor instead.
func (*Target_DocumentsTarget) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{21, 0}
}

func (x *Target_DocumentsTarget) GetDocuments() []string {
	if x != nil {
		return x.Documents
	}
	return nil
}

// A target specified by a query.
type Target_QueryTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are assignable to QueryType:
	//	*Target_QueryTarget_StructuredQuery
	QueryType isTarget_QueryTarget_QueryType `protobuf_oneof:"query_type"`
}

func (x *Target_QueryTarget) Reset() {
	*x = Target_QueryTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_firestore_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target_QueryTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target_QueryTarget) ProtoMessage() {}

func (x *Target_QueryTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_firestore_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target_QueryTarget.ProtoReflect.Descriptor instead.
func (*Target_QueryTarget) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_firestore_proto_rawDescGZIP(), []int{21, 1}
}

func (x *Target_QueryTarget) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *Target_QueryTarget) GetQueryType() isTarget_QueryTarget_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (x *Target_QueryTarget) GetStructuredQuery() *StructuredQuery {
	if x, ok := x.GetQueryType().(*Target_QueryTarget_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

type isTarget_QueryTarget_QueryType interface {
	isTarget_QueryTarget_QueryType()
}

type Target_QueryTarget_StructuredQuery struct {
	// A structured query.
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*Target_QueryTarget_StructuredQuery) isTarget_QueryTarget_QueryType() {}

var File_google_firestore_v1_firestore_proto protoreflect.FileDescriptor

var file_google_firestore_v1_firestore_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xdb, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22,
	0x85, 0x03, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x35, 0x0a, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a,
	0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x68, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42,
	0x16, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x7c, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3b, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x22, 0xa0,
	0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x35, 0x0a, 0x04,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6d,
	0x61, 0x73, 0x6b, 0x12, 0x4c, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x7e, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0xdb, 0x02, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f,
	0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x35, 0x0a,
	0x04, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x04,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x6e, 0x65,
	0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22,
	0xd3, 0x01, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a,
	0x05, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x12, 0x20, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x7d, 0x0a, 0x17, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x3c, 0x0a, 0x18, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x52, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x0e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45,
	0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x59, 0x0a, 0x0f, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x02,
	0x0a, 0x0f, 0x52, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51,
	0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00,
	0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x22, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x0e, 0x6e, 0x65, 0x77, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xd1, 0x01, 0x0a, 0x10, 0x52,
	0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e,
	0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xfa,
	0x01, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x0c, 0x0a,
	0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x7d, 0x0a, 0x16, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x02, 0x0a, 0x0c, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x06, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xd3, 0x01, 0x0a, 0x0d, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x45, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x0d, 0x4c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x61,
	0x64, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x00, 0x52, 0x09,
	0x61, 0x64, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x22, 0x9b, 0x03, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x4e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x4e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x4e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x12, 0x3e, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x22, 0xff, 0x03, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3f, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4b,
	0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x00,
	0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0c, 0x72,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x48, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48,
	0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x6f, 0x6e, 0x63, 0x65, 0x1a, 0x2f, 0x0a, 0x0f,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x86, 0x01,
	0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x0c, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xe5, 0x02, 0x0a, 0x0c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x09, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x10,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4d, 0x4f,
	0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x10,
	0x03, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x04, 0x22, 0x73, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x6a, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xef, 0x01,
	0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x06, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x87, 0x01, 0x0a, 0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x32, 0xfd, 0x16, 0x0a, 0x09, 0x46, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x0d, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a, 0x7d, 0x2f, 0x7b,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xbf,
	0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x62, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x14, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0x95, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x3a,
	0x01, 0x2a, 0x30, 0x01, 0x12, 0xc7, 0x01, 0x0a, 0x10, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x65,
	0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a,
	0x62, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0xa6,
	0x01, 0x0a, 0x06, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x08, 0x52, 0x6f, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x72, 0x6f, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x14, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xdf,
	0x01, 0x0a, 0x08, 0x52, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x7d, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x7d,
	0x3a, 0x72, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x40, 0x22, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a,
	0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x30, 0x01,
	0x12, 0xfc, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x90, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x89, 0x01, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x7d, 0x3a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x46, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x12,
	0x94, 0x01, 0x0a, 0x05, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0x28, 0x01, 0x30, 0x01, 0x12, 0x98, 0x01, 0x0a, 0x06, 0x4c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x3a, 0x01, 0x2a, 0x28, 0x01, 0x30,
	0x01, 0x12, 0x94, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01,
	0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x7d, 0x3a,
	0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x49, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa4, 0x01, 0x0a, 0x0a, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f,
	0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0xaf, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x52, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x76, 0xca, 0x41, 0x18, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x58, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0xc7, 0x01, 0x0a, 0x17, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x46, 0x53, 0xaa, 0x02, 0x19, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x46, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_firestore_v1_firestore_proto_rawDescOnce sync.Once
	file_google_firestore_v1_firestore_proto_rawDescData = file_google_firestore_v1_firestore_proto_rawDesc
)

func file_google_firestore_v1_firestore_proto_rawDescGZIP() []byte {
	file_google_firestore_v1_firestore_proto_rawDescOnce.Do(func() {
		file_google_firestore_v1_firestore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_v1_firestore_proto_rawDescData)
	})
	return file_google_firestore_v1_firestore_proto_rawDescData
}

var file_google_firestore_v1_firestore_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_firestore_v1_firestore_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_firestore_v1_firestore_proto_goTypes = []interface{}{
	(TargetChange_TargetChangeType)(0), // 0: google.firestore.v1.TargetChange.TargetChangeType
	(*GetDocumentRequest)(nil),         // 1: google.firestore.v1.GetDocumentRequest
	(*ListDocumentsRequest)(nil),       // 2: google.firestore.v1.ListDocumentsRequest
	(*ListDocumentsResponse)(nil),      // 3: google.firestore.v1.ListDocumentsResponse
	(*CreateDocumentRequest)(nil),      // 4: google.firestore.v1.CreateDocumentRequest
	(*UpdateDocumentRequest)(nil),      // 5: google.firestore.v1.UpdateDocumentRequest
	(*DeleteDocumentRequest)(nil),      // 6: google.firestore.v1.DeleteDocumentRequest
	(*BatchGetDocumentsRequest)(nil),   // 7: google.firestore.v1.BatchGetDocumentsRequest
	(*BatchGetDocumentsResponse)(nil),  // 8: google.firestore.v1.BatchGetDocumentsResponse
	(*BeginTransactionRequest)(nil),    // 9: google.firestore.v1.BeginTransactionRequest
	(*BeginTransactionResponse)(nil),   // 10: google.firestore.v1.BeginTransactionResponse
	(*CommitRequest)(nil),              // 11: google.firestore.v1.CommitRequest
	(*CommitResponse)(nil),             // 12: google.firestore.v1.CommitResponse
	(*RollbackRequest)(nil),            // 13: google.firestore.v1.RollbackRequest
	(*RunQueryRequest)(nil),            // 14: google.firestore.v1.RunQueryRequest
	(*RunQueryResponse)(nil),           // 15: google.firestore.v1.RunQueryResponse
	(*PartitionQueryRequest)(nil),      // 16: google.firestore.v1.PartitionQueryRequest
	(*PartitionQueryResponse)(nil),     // 17: google.firestore.v1.PartitionQueryResponse
	(*WriteRequest)(nil),               // 18: google.firestore.v1.WriteRequest
	(*WriteResponse)(nil),              // 19: google.firestore.v1.WriteResponse
	(*ListenRequest)(nil),              // 20: google.firestore.v1.ListenRequest
	(*ListenResponse)(nil),             // 21: google.firestore.v1.ListenResponse
	(*Target)(nil),                     // 22: google.firestore.v1.Target
	(*TargetChange)(nil),               // 23: google.firestore.v1.TargetChange
	(*ListCollectionIdsRequest)(nil),   // 24: google.firestore.v1.ListCollectionIdsRequest
	(*ListCollectionIdsResponse)(nil),  // 25: google.firestore.v1.ListCollectionIdsResponse
	(*BatchWriteRequest)(nil),          // 26: google.firestore.v1.BatchWriteRequest
	(*BatchWriteResponse)(nil),         // 27: google.firestore.v1.BatchWriteResponse
	nil,                                // 28: google.firestore.v1.WriteRequest.LabelsEntry
	nil,                                // 29: google.firestore.v1.ListenRequest.LabelsEntry
	(*Target_DocumentsTarget)(nil),     // 30: google.firestore.v1.Target.DocumentsTarget
	(*Target_QueryTarget)(nil),         // 31: google.firestore.v1.Target.QueryTarget
	nil,                                // 32: google.firestore.v1.BatchWriteRequest.LabelsEntry
	(*DocumentMask)(nil),               // 33: google.firestore.v1.DocumentMask
	(*timestamppb.Timestamp)(nil),      // 34: google.protobuf.Timestamp
	(*Document)(nil),                   // 35: google.firestore.v1.Document
	(*Precondition)(nil),               // 36: google.firestore.v1.Precondition
	(*TransactionOptions)(nil),         // 37: google.firestore.v1.TransactionOptions
	(*Write)(nil),                      // 38: google.firestore.v1.Write
	(*WriteResult)(nil),                // 39: google.firestore.v1.WriteResult
	(*StructuredQuery)(nil),            // 40: google.firestore.v1.StructuredQuery
	(*Cursor)(nil),                     // 41: google.firestore.v1.Cursor
	(*DocumentChange)(nil),             // 42: google.firestore.v1.DocumentChange
	(*DocumentDelete)(nil),             // 43: google.firestore.v1.DocumentDelete
	(*DocumentRemove)(nil),             // 44: google.firestore.v1.DocumentRemove
	(*ExistenceFilter)(nil),            // 45: google.firestore.v1.ExistenceFilter
	(*status.Status)(nil),              // 46: google.rpc.Status
	(*emptypb.Empty)(nil),              // 47: google.protobuf.Empty
}
var file_google_firestore_v1_firestore_proto_depIdxs = []int32{
	33, // 0: google.firestore.v1.GetDocumentRequest.mask:type_name -> google.firestore.v1.DocumentMask
	34, // 1: google.firestore.v1.GetDocumentRequest.read_time:type_name -> google.protobuf.Timestamp
	33, // 2: google.firestore.v1.ListDocumentsRequest.mask:type_name -> google.firestore.v1.DocumentMask
	34, // 3: google.firestore.v1.ListDocumentsRequest.read_time:type_name -> google.protobuf.Timestamp
	35, // 4: google.firestore.v1.ListDocumentsResponse.documents:type_name -> google.firestore.v1.Document
	35, // 5: google.firestore.v1.CreateDocumentRequest.document:type_name -> google.firestore.v1.Document
	33, // 6: google.firestore.v1.CreateDocumentRequest.mask:type_name -> google.firestore.v1.DocumentMask
	35, // 7: google.firestore.v1.UpdateDocumentRequest.document:type_name -> google.firestore.v1.Document
	33, // 8: google.firestore.v1.UpdateDocumentRequest.update_mask:type_name -> google.firestore.v1.DocumentMask
	33, // 9: google.firestore.v1.UpdateDocumentRequest.mask:type_name -> google.firestore.v1.DocumentMask
	36, // 10: google.firestore.v1.UpdateDocumentRequest.current_document:type_name -> google.firestore.v1.Precondition
	36, // 11: google.firestore.v1.DeleteDocumentRequest.current_document:type_name -> google.firestore.v1.Precondition
	33, // 12: google.firestore.v1.BatchGetDocumentsRequest.mask:type_name -> google.firestore.v1.DocumentMask
	37, // 13: google.firestore.v1.BatchGetDocumentsRequest.new_transaction:type_name -> google.firestore.v1.TransactionOptions
	34, // 14: google.firestore.v1.BatchGetDocumentsRequest.read_time:type_name -> google.protobuf.Timestamp
	35, // 15: google.firestore.v1.BatchGetDocumentsResponse.found:type_name -> google.firestore.v1.Document
	34, // 16: google.firestore.v1.BatchGetDocumentsResponse.read_time:type_name -> google.protobuf.Timestamp
	37, // 17: google.firestore.v1.BeginTransactionRequest.options:type_name -> google.firestore.v1.TransactionOptions
	38, // 18: google.firestore.v1.CommitRequest.writes:type_name -> google.firestore.v1.Write
	39, // 19: google.firestore.v1.CommitResponse.write_results:type_name -> google.firestore.v1.WriteResult
	34, // 20: google.firestore.v1.CommitResponse.commit_time:type_name -> google.protobuf.Timestamp
	40, // 21: google.firestore.v1.RunQueryRequest.structured_query:type_name -> google.firestore.v1.StructuredQuery
	37, // 22: google.firestore.v1.RunQueryRequest.new_transaction:type_name -> google.firestore.v1.TransactionOptions
	34, // 23: google.firestore.v1.RunQueryRequest.read_time:type_name -> google.protobuf.Timestamp
	35, // 24: google.firestore.v1.RunQueryResponse.document:type_name -> google.firestore.v1.Document
	34, // 25: google.firestore.v1.RunQueryResponse.read_time:type_name -> google.protobuf.Timestamp
	40, // 26: google.firestore.v1.PartitionQueryRequest.structured_query:type_name -> google.firestore.v1.StructuredQuery
	41, // 27: google.firestore.v1.PartitionQueryResponse.partitions:type_name -> google.firestore.v1.Cursor
	38, // 28: google.firestore.v1.WriteRequest.writes:type_name -> google.firestore.v1.Write
	28, // 29: google.firestore.v1.WriteRequest.labels:type_name -> google.firestore.v1.WriteRequest.LabelsEntry
	39, // 30: google.firestore.v1.WriteResponse.write_results:type_name -> google.firestore.v1.WriteResult
	34, // 31: google.firestore.v1.WriteResponse.commit_time:type_name -> google.protobuf.Timestamp
	22, // 32: google.firestore.v1.ListenRequest.add_target:type_name -> google.firestore.v1.Target
	29, // 33: google.firestore.v1.ListenRequest.labels:type_name -> google.firestore.v1.ListenRequest.LabelsEntry
	23, // 34: google.firestore.v1.ListenResponse.target_change:type_name -> google.firestore.v1.TargetChange
	42, // 35: google.firestore.v1.ListenResponse.document_change:type_name -> google.firestore.v1.DocumentChange
	43, // 36: google.firestore.v1.ListenResponse.document_delete:type_name -> google.firestore.v1.DocumentDelete
	44, // 37: google.firestore.v1.ListenResponse.document_remove:type_name -> google.firestore.v1.DocumentRemove
	45, // 38: google.firestore.v1.ListenResponse.filter:type_name -> google.firestore.v1.ExistenceFilter
	31, // 39: google.firestore.v1.Target.query:type_name -> google.firestore.v1.Target.QueryTarget
	30, // 40: google.firestore.v1.Target.documents:type_name -> google.firestore.v1.Target.DocumentsTarget
	34, // 41: google.firestore.v1.Target.read_time:type_name -> google.protobuf.Timestamp
	0,  // 42: google.firestore.v1.TargetChange.target_change_type:type_name -> google.firestore.v1.TargetChange.TargetChangeType
	46, // 43: google.firestore.v1.TargetChange.cause:type_name -> google.rpc.Status
	34, // 44: google.firestore.v1.TargetChange.read_time:type_name -> google.protobuf.Timestamp
	38, // 45: google.firestore.v1.BatchWriteRequest.writes:type_name -> google.firestore.v1.Write
	32, // 46: google.firestore.v1.BatchWriteRequest.labels:type_name -> google.firestore.v1.BatchWriteRequest.LabelsEntry
	39, // 47: google.firestore.v1.BatchWriteResponse.write_results:type_name -> google.firestore.v1.WriteResult
	46, // 48: google.firestore.v1.BatchWriteResponse.status:type_name -> google.rpc.Status
	40, // 49: google.firestore.v1.Target.QueryTarget.structured_query:type_name -> google.firestore.v1.StructuredQuery
	1,  // 50: google.firestore.v1.Firestore.GetDocument:input_type -> google.firestore.v1.GetDocumentRequest
	2,  // 51: google.firestore.v1.Firestore.ListDocuments:input_type -> google.firestore.v1.ListDocumentsRequest
	5,  // 52: google.firestore.v1.Firestore.UpdateDocument:input_type -> google.firestore.v1.UpdateDocumentRequest
	6,  // 53: google.firestore.v1.Firestore.DeleteDocument:input_type -> google.firestore.v1.DeleteDocumentRequest
	7,  // 54: google.firestore.v1.Firestore.BatchGetDocuments:input_type -> google.firestore.v1.BatchGetDocumentsRequest
	9,  // 55: google.firestore.v1.Firestore.BeginTransaction:input_type -> google.firestore.v1.BeginTransactionRequest
	11, // 56: google.firestore.v1.Firestore.Commit:input_type -> google.firestore.v1.CommitRequest
	13, // 57: google.firestore.v1.Firestore.Rollback:input_type -> google.firestore.v1.RollbackRequest
	14, // 58: google.firestore.v1.Firestore.RunQuery:input_type -> google.firestore.v1.RunQueryRequest
	16, // 59: google.firestore.v1.Firestore.PartitionQuery:input_type -> google.firestore.v1.PartitionQueryRequest
	18, // 60: google.firestore.v1.Firestore.Write:input_type -> google.firestore.v1.WriteRequest
	20, // 61: google.firestore.v1.Firestore.Listen:input_type -> google.firestore.v1.ListenRequest
	24, // 62: google.firestore.v1.Firestore.ListCollectionIds:input_type -> google.firestore.v1.ListCollectionIdsRequest
	26, // 63: google.firestore.v1.Firestore.BatchWrite:input_type -> google.firestore.v1.BatchWriteRequest
	4,  // 64: google.firestore.v1.Firestore.CreateDocument:input_type -> google.firestore.v1.CreateDocumentRequest
	35, // 65: google.firestore.v1.Firestore.GetDocument:output_type -> google.firestore.v1.Document
	3,  // 66: google.firestore.v1.Firestore.ListDocuments:output_type -> google.firestore.v1.ListDocumentsResponse
	35, // 67: google.firestore.v1.Firestore.UpdateDocument:output_type -> google.firestore.v1.Document
	47, // 68: google.firestore.v1.Firestore.DeleteDocument:output_type -> google.protobuf.Empty
	8,  // 69: google.firestore.v1.Firestore.BatchGetDocuments:output_type -> google.firestore.v1.BatchGetDocumentsResponse
	10, // 70: google.firestore.v1.Firestore.BeginTransaction:output_type -> google.firestore.v1.BeginTransactionResponse
	12, // 71: google.firestore.v1.Firestore.Commit:output_type -> google.firestore.v1.CommitResponse
	47, // 72: google.firestore.v1.Firestore.Rollback:output_type -> google.protobuf.Empty
	15, // 73: google.firestore.v1.Firestore.RunQuery:output_type -> google.firestore.v1.RunQueryResponse
	17, // 74: google.firestore.v1.Firestore.PartitionQuery:output_type -> google.firestore.v1.PartitionQueryResponse
	19, // 75: google.firestore.v1.Firestore.Write:output_type -> google.firestore.v1.WriteResponse
	21, // 76: google.firestore.v1.Firestore.Listen:output_type -> google.firestore.v1.ListenResponse
	25, // 77: google.firestore.v1.Firestore.ListCollectionIds:output_type -> google.firestore.v1.ListCollectionIdsResponse
	27, // 78: google.firestore.v1.Firestore.BatchWrite:output_type -> google.firestore.v1.BatchWriteResponse
	35, // 79: google.firestore.v1.Firestore.CreateDocument:output_type -> google.firestore.v1.Document
	65, // [65:80] is the sub-list for method output_type
	50, // [50:65] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_firestore_v1_firestore_proto_init() }
func file_google_firestore_v1_firestore_proto_init() {
	if File_google_firestore_v1_firestore_proto != nil {
		return
	}
	file_google_firestore_v1_common_proto_init()
	file_google_firestore_v1_document_proto_init()
	file_google_firestore_v1_query_proto_init()
	file_google_firestore_v1_write_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_firestore_v1_firestore_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCollectionIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCollectionIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target_DocumentsTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_firestore_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target_QueryTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_firestore_v1_firestore_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*GetDocumentRequest_Transaction)(nil),
		(*GetDocumentRequest_ReadTime)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ListDocumentsRequest_Transaction)(nil),
		(*ListDocumentsRequest_ReadTime)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*BatchGetDocumentsRequest_Transaction)(nil),
		(*BatchGetDocumentsRequest_NewTransaction)(nil),
		(*BatchGetDocumentsRequest_ReadTime)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*BatchGetDocumentsResponse_Found)(nil),
		(*BatchGetDocumentsResponse_Missing)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*RunQueryRequest_StructuredQuery)(nil),
		(*RunQueryRequest_Transaction)(nil),
		(*RunQueryRequest_NewTransaction)(nil),
		(*RunQueryRequest_ReadTime)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*PartitionQueryRequest_StructuredQuery)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*ListenRequest_AddTarget)(nil),
		(*ListenRequest_RemoveTarget)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*ListenResponse_TargetChange)(nil),
		(*ListenResponse_DocumentChange)(nil),
		(*ListenResponse_DocumentDelete)(nil),
		(*ListenResponse_DocumentRemove)(nil),
		(*ListenResponse_Filter)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[21].OneofWrappers = []interface{}{
		(*Target_Query)(nil),
		(*Target_Documents)(nil),
		(*Target_ResumeToken)(nil),
		(*Target_ReadTime)(nil),
	}
	file_google_firestore_v1_firestore_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*Target_QueryTarget_StructuredQuery)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_v1_firestore_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_firestore_v1_firestore_proto_goTypes,
		DependencyIndexes: file_google_firestore_v1_firestore_proto_depIdxs,
		EnumInfos:         file_google_firestore_v1_firestore_proto_enumTypes,
		MessageInfos:      file_google_firestore_v1_firestore_proto_msgTypes,
	}.Build()
	File_google_firestore_v1_firestore_proto = out.File
	file_google_firestore_v1_firestore_proto_rawDesc = nil
	file_google_firestore_v1_firestore_proto_goTypes = nil
	file_google_firestore_v1_firestore_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FirestoreClient is the client API for Firestore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FirestoreClient interface {
	// Gets a single document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Lists documents.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Updates or inserts a document.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a document.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error)
	// Starts a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Runs a query.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error)
	// Partitions a query by returning partition cursors that can be used to run
	// the query in parallel. The returned partition cursors are split points that
	// can be used by RunQuery as starting/end points for the query results.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionQueryResponse, error)
	// Streams batches of document updates and deletes, in order.
	Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error)
	// Listens to changes.
	Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error)
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error)
	// Applies a batch of write operations.
	//
	// The BatchWrite method does not apply the write operations atomically
	// and can apply them out of order. Method does not allow more than one write
	// per document. Each write succeeds or fails independently. See the
	// [BatchWriteResponse][google.firestore.v1.BatchWriteResponse] for the success status of each write.
	//
	// If you require an atomically applied set of writes, use
	// [Commit][google.firestore.v1.Firestore.Commit] instead.
	BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (*BatchWriteResponse, error)
	// Creates a new document.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
}

type firestoreClient struct {
	cc grpc.ClientConnInterface
}

func NewFirestoreClient(cc grpc.ClientConnInterface) FirestoreClient {
	return &firestoreClient{cc}
}

func (c *firestoreClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/UpdateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/DeleteDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[0], "/google.firestore.v1.Firestore/BatchGetDocuments", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreBatchGetDocumentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_BatchGetDocumentsClient interface {
	Recv() (*BatchGetDocumentsResponse, error)
	grpc.ClientStream
}

type firestoreBatchGetDocumentsClient struct {
	grpc.ClientStream
}

func (x *firestoreBatchGetDocumentsClient) Recv() (*BatchGetDocumentsResponse, error) {
	m := new(BatchGetDocumentsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[1], "/google.firestore.v1.Firestore/RunQuery", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreRunQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_RunQueryClient interface {
	Recv() (*RunQueryResponse, error)
	grpc.ClientStream
}

type firestoreRunQueryClient struct {
	grpc.ClientStream
}

func (x *firestoreRunQueryClient) Recv() (*RunQueryResponse, error) {
	m := new(RunQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionQueryResponse, error) {
	out := new(PartitionQueryResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/PartitionQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[2], "/google.firestore.v1.Firestore/Write", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreWriteClient{stream}
	return x, nil
}

type Firestore_WriteClient interface {
	Send(*WriteRequest) error
	Recv() (*WriteResponse, error)
	grpc.ClientStream
}

type firestoreWriteClient struct {
	grpc.ClientStream
}

func (x *firestoreWriteClient) Send(m *WriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreWriteClient) Recv() (*WriteResponse, error) {
	m := new(WriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Firestore_serviceDesc.Streams[3], "/google.firestore.v1.Firestore/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreListenClient{stream}
	return x, nil
}

type Firestore_ListenClient interface {
	Send(*ListenRequest) error
	Recv() (*ListenResponse, error)
	grpc.ClientStream
}

type firestoreListenClient struct {
	grpc.ClientStream
}

func (x *firestoreListenClient) Send(m *ListenRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreListenClient) Recv() (*ListenResponse, error) {
	m := new(ListenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error) {
	out := new(ListCollectionIdsResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/ListCollectionIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (*BatchWriteResponse, error) {
	out := new(BatchWriteResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/BatchWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.firestore.v1.Firestore/CreateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreServer is the server API for Firestore service.
type FirestoreServer interface {
	// Gets a single document.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Lists documents.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Updates or inserts a document.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a document.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error
	// Starts a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error)
	// Runs a query.
	RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error
	// Partitions a query by returning partition cursors that can be used to run
	// the query in parallel. The returned partition cursors are split points that
	// can be used by RunQuery as starting/end points for the query results.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionQueryResponse, error)
	// Streams batches of document updates and deletes, in order.
	Write(Firestore_WriteServer) error
	// Listens to changes.
	Listen(Firestore_ListenServer) error
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error)
	// Applies a batch of write operations.
	//
	// The BatchWrite method does not apply the write operations atomically
	// and can apply them out of order. Method does not allow more than one write
	// per document. Each write succeeds or fails independently. See the
	// [BatchWriteResponse][google.firestore.v1.BatchWriteResponse] for the success status of each write.
	//
	// If you require an atomically applied set of writes, use
	// [Commit][google.firestore.v1.Firestore.Commit] instead.
	BatchWrite(context.Context, *BatchWriteRequest) (*BatchWriteResponse, error)
	// Creates a new document.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
}

// UnimplementedFirestoreServer can be embedded to have forward compatible implementations.
type UnimplementedFirestoreServer struct {
}

func (*UnimplementedFirestoreServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (*UnimplementedFirestoreServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (*UnimplementedFirestoreServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (*UnimplementedFirestoreServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (*UnimplementedFirestoreServer) BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error {
	return status1.Errorf(codes.Unimplemented, "method BatchGetDocuments not implemented")
}
func (*UnimplementedFirestoreServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (*UnimplementedFirestoreServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (*UnimplementedFirestoreServer) Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (*UnimplementedFirestoreServer) RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error {
	return status1.Errorf(codes.Unimplemented, "method RunQuery not implemented")
}
func (*UnimplementedFirestoreServer) PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionQueryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PartitionQuery not implemented")
}
func (*UnimplementedFirestoreServer) Write(Firestore_WriteServer) error {
	return status1.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (*UnimplementedFirestoreServer) Listen(Firestore_ListenServer) error {
	return status1.Errorf(codes.Unimplemented, "method Listen not implemented")
}
func (*UnimplementedFirestoreServer) ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCollectionIds not implemented")
}
func (*UnimplementedFirestoreServer) BatchWrite(context.Context, *BatchWriteRequest) (*BatchWriteResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchWrite not implemented")
}
func (*UnimplementedFirestoreServer) CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}

func RegisterFirestoreServer(s *grpc.Server, srv FirestoreServer) {
	s.RegisterService(&_Firestore_serviceDesc, srv)
}

func _Firestore_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchGetDocuments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchGetDocumentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).BatchGetDocuments(m, &firestoreBatchGetDocumentsServer{stream})
}

type Firestore_BatchGetDocumentsServer interface {
	Send(*BatchGetDocumentsResponse) error
	grpc.ServerStream
}

type firestoreBatchGetDocumentsServer struct {
	grpc.ServerStream
}

func (x *firestoreBatchGetDocumentsServer) Send(m *BatchGetDocumentsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_RunQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).RunQuery(m, &firestoreRunQueryServer{stream})
}

type Firestore_RunQueryServer interface {
	Send(*RunQueryResponse) error
	grpc.ServerStream
}

type firestoreRunQueryServer struct {
	grpc.ServerStream
}

func (x *firestoreRunQueryServer) Send(m *RunQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/PartitionQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Write_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Write(&firestoreWriteServer{stream})
}

type Firestore_WriteServer interface {
	Send(*WriteResponse) error
	Recv() (*WriteRequest, error)
	grpc.ServerStream
}

type firestoreWriteServer struct {
	grpc.ServerStream
}

func (x *firestoreWriteServer) Send(m *WriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreWriteServer) Recv() (*WriteRequest, error) {
	m := new(WriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Listen(&firestoreListenServer{stream})
}

type Firestore_ListenServer interface {
	Send(*ListenResponse) error
	Recv() (*ListenRequest, error)
	grpc.ServerStream
}

type firestoreListenServer struct {
	grpc.ServerStream
}

func (x *firestoreListenServer) Send(m *ListenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreListenServer) Recv() (*ListenRequest, error) {
	m := new(ListenRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_ListCollectionIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCollectionIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListCollectionIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/ListCollectionIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListCollectionIds(ctx, req.(*ListCollectionIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BatchWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/BatchWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BatchWrite(ctx, req.(*BatchWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1.Firestore/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Firestore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.v1.Firestore",
	HandlerType: (*FirestoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDocument",
			Handler:    _Firestore_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _Firestore_ListDocuments_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Firestore_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Firestore_DeleteDocument_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Firestore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Firestore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Firestore_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Firestore_PartitionQuery_Handler,
		},
		{
			MethodName: "ListCollectionIds",
			Handler:    _Firestore_ListCollectionIds_Handler,
		},
		{
			MethodName: "BatchWrite",
			Handler:    _Firestore_BatchWrite_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Firestore_CreateDocument_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "BatchGetDocuments",
			Handler:       _Firestore_BatchGetDocuments_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunQuery",
			Handler:       _Firestore_RunQuery_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Write",
			Handler:       _Firestore_Write_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Listen",
			Handler:       _Firestore_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/firestore/v1/firestore.proto",
}
