// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/bandwidth_limit/v3alpha/bandwidth_limit.proto

package envoy_extensions_filters_http_bandwidth_limit_v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// Validate checks the field values on BandwidthLimit with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *BandwidthLimit) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		return BandwidthLimitValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
	}

	if _, ok := BandwidthLimit_EnableMode_name[int32(m.GetEnableMode())]; !ok {
		return BandwidthLimitValidationError{
			field:  "EnableMode",
			reason: "value must be one of the defined enum values",
		}
	}

	if wrapper := m.GetLimitKbps(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			return BandwidthLimitValidationError{
				field:  "LimitKbps",
				reason: "value must be greater than or equal to 1",
			}
		}

	}

	if d := m.GetFillInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return BandwidthLimitValidationError{
				field:  "FillInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		lte := time.Duration(1*time.Second + 0*time.Nanosecond)
		gte := time.Duration(0*time.Second + 20000000*time.Nanosecond)

		if dur < gte || dur > lte {
			return BandwidthLimitValidationError{
				field:  "FillInterval",
				reason: "value must be inside range [20ms, 1s]",
			}
		}

	}

	if v, ok := interface{}(m.GetRuntimeEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BandwidthLimitValidationError{
				field:  "RuntimeEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// BandwidthLimitValidationError is the validation error returned by
// BandwidthLimit.Validate if the designated constraints aren't met.
type BandwidthLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandwidthLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandwidthLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandwidthLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandwidthLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandwidthLimitValidationError) ErrorName() string { return "BandwidthLimitValidationError" }

// Error satisfies the builtin error interface
func (e BandwidthLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandwidthLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandwidthLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandwidthLimitValidationError{}
