/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
)

// DomainLister helps list Domains.
type DomainLister interface {
	// List lists all Domains in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Domain, err error)
	// Get retrieves the Domain from the index for a given name.
	Get(name string) (*v1alpha1.Domain, error)
	DomainListerExpansion
}

// domainLister implements the DomainLister interface.
type domainLister struct {
	indexer cache.Indexer
}

// NewDomainLister returns a new DomainLister.
func NewDomainLister(indexer cache.Indexer) DomainLister {
	return &domainLister{indexer: indexer}
}

// List lists all Domains in the indexer.
func (s *domainLister) List(selector labels.Selector) (ret []*v1alpha1.Domain, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Domain))
	})
	return ret, err
}

// Get retrieves the Domain from the index for a given name.
func (s *domainLister) Get(name string) (*v1alpha1.Domain, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("domain"), name)
	}
	return obj.(*v1alpha1.Domain), nil
}
