/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package upgrade

import (
	"knative.dev/eventing-kafka/test/upgrade/continual"
	pkgupgrade "knative.dev/pkg/test/upgrade"
)

// ChannelContinualTests returns background operations to test channel
// functionality in continual manner during the whole upgrade and downgrade
// process asserting that all events are propagated well.
func ChannelContinualTests(opts continual.ChannelTestOptions) []pkgupgrade.BackgroundOperation {
	return []pkgupgrade.BackgroundOperation{
		continual.ChannelTest(opts),
		continual.BrokerBackedByChannelTest(opts),
	}
}

// SourceContinualTests tests source operation in continual manner during the
// whole upgrade and downgrade process asserting that all events are propagated
// well.
func SourceContinualTests(opts continual.SourceTestOptions) []pkgupgrade.BackgroundOperation {
	return []pkgupgrade.BackgroundOperation{
		continual.SourceTest(opts),
	}
}
