/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
)

// RealmLister helps list Realms.
type RealmLister interface {
	// List lists all Realms in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Realm, err error)
	// Get retrieves the Realm from the index for a given name.
	Get(name string) (*v1alpha1.Realm, error)
	RealmListerExpansion
}

// realmLister implements the RealmLister interface.
type realmLister struct {
	indexer cache.Indexer
}

// NewRealmLister returns a new RealmLister.
func NewRealmLister(indexer cache.Indexer) RealmLister {
	return &realmLister{indexer: indexer}
}

// List lists all Realms in the indexer.
func (s *realmLister) List(selector labels.Selector) (ret []*v1alpha1.Realm, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Realm))
	})
	return ret, err
}

// Get retrieves the Realm from the index for a given name.
func (s *realmLister) Get(name string) (*v1alpha1.Realm, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("realm"), name)
	}
	return obj.(*v1alpha1.Realm), nil
}
